create or replace package ploffx_document_tag
authid current_user is
--v5.9
--
-- Namespace
ns_wpc constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas';
ns_mc constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';
ns_o constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:office';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_m constant plx_sc.normalv2  := 'http://schemas.openxmlformats.org/officeDocument/2006/math';
ns_v constant plx_sc.normalv2 :=  'urn:schemas-microsoft-com:vml';
ns_wp14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing';
ns_wp constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing';
ns_w10 constant plx_sc.normalv2 := 'urn:schemas-microsoft-com:office:word';
ns_w constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/wordprocessingml/2006/main';
ns_w14 constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordml';
ns_wpg constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingGroup';
ns_wpi constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingInk';
ns_wne constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2006/wordml';
ns_wps constant plx_sc.normalv2 := 'http://schemas.microsoft.com/office/word/2010/wordprocessingShape';
ns_ve constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/markup-compatibility/2006';
ns_a constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/main';
--
-- Prefixes
ns_wpc_pref constant varchar2(3 char) := 'wpc';
ns_mc_pref constant varchar2(2 char) := 'mc';
ns_o_pref constant varchar2(1 char) := 'o';
ns_r_pref constant varchar2(1 char) := 'r';
ns_m_pref constant varchar2(1 char) := 'm';
ns_v_pref constant varchar2(1 char) := 'v';
ns_wp14_pref constant varchar2(4 char) := 'wp14';
ns_wp_pref constant varchar2(2 char) := 'wp';
ns_w10_pref constant varchar2(3 char) := 'w10';
ns_w_pref constant varchar2(1 char) := 'w';
ns_w14_pref constant varchar2(3 char) := 'w14';
ns_wpg_pref constant varchar2(3 char) := 'wpg';
ns_wpi_pref constant varchar2(3 char) := 'wpi';
ns_wne_pref constant varchar2(3 char) := 'wne';
ns_wps_pref constant varchar2(3 char) := 'wpe';
ns_ve_pref constant varchar2(2 char) := 've';
--
ns_xml_pref constant varchar2(3 char) := 'xml';
--
ns_a_pref constant varchar2(2 char) := 'a';
--
c_filename constant plx_sc.normalv2 := 'word/document.xml';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
--t_abstractNum constant plx_sc.normalv2 := 'abstractNum'; --
--t_abstractNumId constant plx_sc.normalv2 := 'abstractNumId'; --
t_anchor constant plx_sc.normalv2 := 'anchor';
t_b constant plx_sc.normalv2 := 'b';
--t_basedOn constant plx_sc.normalv2 := 'basedOn'; --
t_bCs constant plx_sc.normalv2 := 'bCs';
t_body constant plx_sc.normalv2 := 'body';
t_bookmarkEnd constant plx_sc.normalv2 := 'bookmarkEnd';
t_bookmarkStart constant plx_sc.normalv2 := 'bookmarkStart';
t_br constant plx_sc.normalv2 := 'br';
t_bottom constant plx_sc.normalv2 := 'bottom'; --
t_cNvGraphicFramePr constant plx_sc.normalv2 := 'cNvGraphicFramePr';
t_col constant plx_sc.normalv2 := 'col';
t_cols constant plx_sc.normalv2 := 'cols';
-- t_docDefaults constant plx_sc.normalv2 := 'docDefaults'; --
t_document constant plx_sc.normalv2 := 'document';
t_docGrid constant plx_sc.normalv2 := 'docGrid';
t_docPr constant plx_sc.normalv2 := 'docPr';
t_drawing constant plx_sc.normalv2 := 'drawing';
t_effectExtent constant plx_sc.normalv2 := 'effectExtent';
t_extent constant plx_sc.normalv2 := 'extent';
t_fldChar constant plx_sc.normalv2 := 'fldChar';
t_gridCol constant plx_sc.normalv2 := 'gridCol';
t_hMerge constant plx_sc.normalv2 := 'hMerge';
t_ilvl constant plx_sc.normalv2 := 'ilvl';
t_inline constant plx_sc.normalv2 := 'inline';
t_ind constant plx_sc.normalv2 := 'ind'; --
t_insideH constant plx_sc.normalv2 := 'insideH'; --
t_insideV constant plx_sc.normalv2 := 'insideV'; --
t_jc constant plx_sc.normalv2 := 'jc';
--t_latentStyles constant plx_sc.normalv2 := 'latentStyles'; --
t_left constant plx_sc.normalv2 := 'left'; --
t_lineTo constant plx_sc.normalv2 := 'lineTo';
--t_link constant plx_sc.normalv2 := 'link'; --
--t_lsdException constant plx_sc.normalv2 := 'lsdException'; --
--t_lvl constant plx_sc.normalv2 := 'lvl'; --
--t_lvlJc constant plx_sc.normalv2 := 'lvlJc'; --
--t_lvlText constant plx_sc.normalv2 := 'lvlText'; --
t_noProof constant plx_sc.normalv2 := 'noProof';
--t_multiLevelType constant plx_sc.normalv2 := 'multiLevelType'; --
--t_name constant plx_sc.normalv2 := 'name'; --
--t_nsid constant plx_sc.normalv2 := 'nsid'; --
--t_num constant plx_sc.normalv2 := 'num'; --
--t_numbering constant plx_sc.normalv2 := 'numbering'; --
t_numFmt constant plx_sc.normalv2 := 'numFmt'; --
t_numId constant plx_sc.normalv2 := 'numId';
t_numPr constant plx_sc.normalv2 := 'numPr';
t_p constant plx_sc.normalv2 := 'p';
t_pgSz constant plx_sc.normalv2 := 'pgSz';
t_pgMar constant plx_sc.normalv2 := 'pgMar';
t_positionH constant plx_sc.normalv2 := 'positionH';
t_positionV constant plx_sc.normalv2 := 'positionV';
t_posOffset constant plx_sc.normalv2 := 'posOffset';
t_proofErr constant plx_sc.normalv2 := 'proofErr';
t_pPr constant plx_sc.normalv2 := 'pPr';
--t_pPrDefault constant plx_sc.normalv2 := 'pPrDefault'; --
t_pStyle constant plx_sc.normalv2 := 'pStyle';
--t_qFormat constant plx_sc.normalv2 := 'qFormat'; --
t_r constant plx_sc.normalv2 := 'r';
t_rFonts constant plx_sc.normalv2 := 'rFonts';
t_right constant plx_sc.normalv2 := 'right'; --
t_rPr constant plx_sc.normalv2 := 'rPr';
--t_rprDefault constant plx_sc.normalv2 := 'rPrDefault'; --
--t_rsid constant plx_sc.normalv2 := 'rsid'; --
t_rStyle constant plx_sc.normalv2 := 'rStyle';
t_sectPr constant plx_sc.normalv2 := 'sectPr';
--t_semiHidden constant plx_sc.normalv2 := 'semiHidden'; --
t_shd constant plx_sc.normalv2 := 'shd';
t_simplePos constant plx_sc.normalv2 := 'simplePos';
t_spacing constant plx_sc.normalv2 := 'spacing';
t_start constant plx_sc.normalv2 := 'start'; --
--t_style constant plx_sc.normalv2 := 'style'; --
-- t_styles constant plx_sc.normalv2 := 'styles'; --
t_t constant plx_sc.normalv2 := 't';
t_tc constant plx_sc.normalv2 := 'tc';
t_tcPr constant plx_sc.normalv2 := 'tcPr';
t_tcW constant plx_sc.normalv2 := 'tcW';
t_tbl constant plx_sc.normalv2 := 'tbl';
t_tblBorders constant plx_sc.normalv2 := 'tblBorders';
t_tblCellMar constant plx_sc.normalv2 := 'tblCellMar'; --
t_tblCellSpacing constant plx_sc.normalv2 := 'tblCellSpacing';
t_tblGrid constant plx_sc.normalv2 := 'tblGrid';
t_tblInd constant plx_sc.normalv2 := 'tblInd'; --
t_tblLook constant plx_sc.normalv2 := 'tblLook';
t_tblOverlap constant plx_sc.normalv2 := 'tblOverlap';
t_tblPr constant plx_sc.normalv2 := 'tblPr';
t_tblStyle constant plx_sc.normalv2 := 'tblStyle';
t_tblW constant plx_sc.normalv2 := 'tblW';
t_titlePg constant plx_sc.normalv2 := 'titlePg';
t_tmpl constant plx_sc.normalv2 := 'tmpl'; --
t_top constant plx_sc.normalv2 := 'top'; --
t_tr constant plx_sc.normalv2 := 'tr';
t_trPr constant plx_sc.normalv2 := 'trPr';
--t_uiPriority constant plx_sc.normalv2 := 'uiPriority'; --
--t_unhideWhenUsed constant plx_sc.normalv2 := 'unhideWhenUsed'; --
t_vMerge constant plx_sc.normalv2 := 'vMerge';
t_wrapNone constant plx_sc.normalv2 := 'wrapNone';
t_wrapPolygon constant plx_sc.normalv2 := 'wrapPolygon';
t_wrapSquare constant plx_sc.normalv2 := 'wrapSquare';
t_wrapThrough constant plx_sc.normalv2 := 'wrapThrough';
t_wrapTopAndBottom constant plx_sc.normalv2 := 'wrapTopAndBottom';
t_pageBreakBefore constant plx_sc.normalv2 := 'pageBreakBefore';
t_widowControl constant plx_sc.normalv2 := 'widowControl';
t_wordWrap constant plx_sc.normalv2 := 'wordWrap';
t_color constant plx_sc.normalv2 := 'color';
t_i constant plx_sc.normalv2 := 'i';
t_sz constant plx_sc.normalv2 := 'sz';
t_u constant plx_sc.normalv2 := 'u';
t_numberingChange constant plx_sc.normalv2 := 'numberingChange';
t_ins constant plx_sc.normalv2 := 'ins';
t_lang constant plx_sc.normalv2 := 'lang';
t_szCs constant plx_sc.normalv2 := 'szCs';
t_headerReference constant plx_sc.normalv2 := 'headerReference';
t_footerReference constant plx_sc.normalv2 := 'footerReference';
t_noWrap constant plx_sc.normalv2 := 'noWrap';
--v1.3.0
t_graphic constant plx_sc.normalv2 := 'graphic';
t_graphicData constant plx_sc.normalv2 := 'graphicData';
t_wrapTight constant plx_sc.normalv2 := 'wrapTight';
t_align constant plx_sc.normalv2 := 'align';
t_hlinkClick constant plx_sc.normalv2 := 'hlinkClick';
t_hlinkHover constant plx_sc.normalv2 := 'hlinkHover';
t_graphicFrameLocks constant plx_sc.normalv2 := 'graphicFrameLocks';
--
--t_numIdMacAtCleanup constant plx_sc.normalv2 := 'numIdMacAtCleanUp';
--t_numPicBullet constant plx_sc.normalv2 := 'numPicBullet';
t_pict constant plx_sc.normalv2 := 'pict';
--t_control constant plx_sc.normalv2 := 'control';
--t_movie constant plx_sc.normalv2 := 'movie';
--t_styleLink constant plx_sc.normalv2 := 'styleLink';
--t_numStyleLink constant plx_sc.normalv2 := 'numStyleLink';
--t_lvlOverride constant plx_sc.normalv2 := 'lvlOverride';
--t_startOverride constant plx_sc.normalv2 := 'startOverride';
--t_lvlRestart constant plx_sc.normalv2 := 'lvlRestart';
--t_isLgl constant plx_sc.normalv2 := 'isLgl';
--t_suff constant plx_sc.normalv2 := 'suff';
--t_lvlPicBulletId constant plx_sc.normalv2 := 'lvlPicBulletId';
--t_legacy constant plx_sc.normalv2 := 'legacy';
--v1.3.0
t_attr constant plx_sc.normalv2 := 'attr';
t_customXmlPr constant plx_sc.normalv2 := 'customXmlPr';
t_customXml constant plx_sc.normalv2 := 'customXml';
--
t_eastAsianLayout constant plx_sc.normalv2 := 'eastAsianLayout';
t_effect constant plx_sc.normalv2 := 'effect';
t_em constant plx_sc.normalv2 := 'em';
t_fitText constant plx_sc.normalv2 := 'fitText';
t_highlight constant plx_sc.normalv2 := 'highlight';
t_position constant plx_sc.normalv2 := 'position';
t_vertAlign constant plx_sc.normalv2 := 'vertAlign';
t_w constant plx_sc.normalv2 := 'w';
t_bdr constant plx_sc.normalv2 := 'bdr';
t_caps constant plx_sc.normalv2 := 'caps';
t_cs constant plx_sc.normalv2 := 'cs';
t_dstrike constant plx_sc.normalv2 := 'dstrike';
t_emboss constant plx_sc.normalv2 := 'emboss';
t_iCs constant plx_sc.normalv2 := 'iCs';
t_imprint constant  plx_sc.normalv2 := 'imprint';
t_kern constant plx_sc.normalv2 := 'kern';
t_oMath constant plx_sc.normalv2 := 'oMath';
t_outline constant plx_sc.normalv2 := 'outline';
t_rtl constant plx_sc.normalv2 := 'rtl';
t_shadow constant plx_sc.normalv2 := 'shadow';
t_smallCaps constant plx_sc.normalv2 := 'smallCaps';
t_snapToGrid constant plx_sc.normalv2 := 'snapToGrid';
t_specVanish constant plx_sc.normalv2 := 'specVanish';
t_strike constant plx_sc.normalv2 := 'strike';
t_vanish constant plx_sc.normalv2 := 'vanish';
t_webHidden constant plx_sc.normalv2 := 'webHidden';
--
t_adjustRightInd constant plx_sc.normalv2 := 'adjustRightInd';
t_autoSpaceDE constant plx_sc.normalv2 := 'autoSpaceDE';
t_autoSpaceDN constant plx_sc.normalv2 := 'autoSpaceDN';
t_bidi constant plx_sc.normalv2 := 'bidi';
t_cnfStyle constant plx_sc.normalv2 := 'cnfStyle';
t_contextualSpacing constant plx_sc.normalv2 := 'contextualSpacing';
t_divId constant plx_sc.normalv2 := 'divId';
t_framePr constant plx_sc.normalv2 := 'framePr';
t_keepLines constant plx_sc.normalv2 := 'keepLines';
t_keepNext constant plx_sc.normalv2 := 'keepNext';
t_kinsoku constant plx_sc.normalv2 := 'kinsoku';
t_mirrorIndents constant plx_sc.normalv2 := 'mirrorIndents';
t_outlineLvl constant plx_sc.normalv2 := 'outlineLvl';
t_overflowPunct constant plx_sc.normalv2 := 'overflowPunct';
t_pBdr constant plx_sc.normalv2 := 'pBdr';
t_suppressAutoHyphens constant plx_sc.normalv2 := 'suppressAutoHyphens';
t_suppressLineNumbers constant plx_sc.normalv2 := 'suppressLineNumbers';
t_suppressOverlap constant plx_sc.normalv2 := 'suppressOverlap';
t_tab constant plx_sc.normalv2 := 'tab';
t_tabs constant plx_sc.normalv2 := 'tabs';
t_textAlignment constant plx_sc.normalv2 := 'textAlignment';
t_textboxTightWrap constant plx_sc.normalv2 := 'textboxTightWrap';
t_textDirection constant plx_sc.normalv2 := 'textDirection';
t_topLinePunct constant plx_sc.normalv2 := 'topLinePunct';
t_bar constant plx_sc.normalv2 := 'bar';
t_between constant plx_sc.normalv2 := 'between';
--
t_tblpPr constant plx_sc.normalv2 := 'tblpPr';
t_bidiVisual constant plx_sc.normalv2 := 'bidiVisual';
t_tblStyleRowBandSize constant plx_sc.normalv2 := 'tblStyleRowBandSize';
t_tblStyleColBandSize constant plx_sc.normalv2 := 'tblStyleColBandSize';
t_tblLayout constant plx_sc.normalv2 := 'tblLayout';
t_tblCaption constant plx_sc.normalv2 := 'tblCaption';
t_tblDescription constant plx_sc.normalv2 := 'tblDescription';
t_tblPrChange constant plx_sc.normalv2 := 'tblPrChange';
--
t_gridSpan constant plx_sc.normalv2 := 'gridSpan';
t_hideMark constant plx_sc.normalv2 := 'hideMark';
t_tcBorders constant plx_sc.normalv2 := 'tcBorders';
t_tcFitText constant plx_sc.normalv2 := 'tcFitText';
t_tcMar constant plx_sc.normalv2 := 'tcMar';
t_vAlign constant plx_sc.normalv2 := 'vAlign';
t_tl2br constant plx_sc.normalv2 := 'tl2br';
t_tr2bl constant plx_sc.normalv2 := 'tr2bl';
--
t_gridBefore constant plx_sc.normalv2 := 'gridBefore';
t_gridAfter constant plx_sc.normalv2 := 'gridAfter';
t_wBefore constant plx_sc.normalv2 := 'wBefore';
t_wAfter constant plx_sc.normalv2 := 'wAfter';
t_cantSplit constant plx_sc.normalv2 := 'cantSplit';
t_trHeight constant plx_sc.normalv2 := 'trHeight';
t_tblHeader constant plx_sc.normalv2 := 'tblHeader';
t_hidden constant plx_sc.normalv2 := 'hidden';
--
t_endnotePr constant plx_sc.normalv2 := 'endnotePr';
t_footnotePr constant plx_sc.normalv2 := 'footnotePr';
t_formProt constant plx_sc.normalv2 := 'formProt';
t_lnNumType constant plx_sc.normalv2 := 'lnNumType';
t_noEndnote constant plx_sc.normalv2 := 'noEndnote';
t_paperSrc constant plx_sc.normalv2 := 'paperSrc';
t_pgBorders constant plx_sc.normalv2 := 'pgBorders';
t_pgNumType constant plx_sc.normalv2 := 'pgNumType';
t_printerSettings constant plx_sc.normalv2 := 'printerSettings';
t_rtlGutter constant plx_sc.normalv2 := 'rtlGutter';
t_sectPrChange constant plx_sc.normalv2 := 'sectPrChange';
t_type constant plx_sc.normalv2 := 'type';
t_numRestart constant plx_sc.normalv2 := 'numRestart';
t_numStart constant plx_sc.normalv2 := 'numStart';
t_pos constant plx_sc.normalv2 := 'pos';
t_snd constant plx_sc.normalv2 := 'snd';
t_background constant plx_sc.normalv2 := 'background';
--
t_tblWidth constant plx_sc.normalv2 := 'tblWidth';
t_fldSimple constant plx_sc.normalv2 := 'fldSimple';
t_hyperlink constant plx_sc.normalv2 := 'hyperlink';

t_sdt constant plx_sc.normalv2 := 'sdt';
t_sdtPr constant plx_sc.normalv2 := 'sdtPr';
t_SdtContent constant plx_sc.normalv2 := 'sdtContent';
t_alias constant plx_sc.normalv2 := 'alias';
t_comboBox constant plx_sc.normalv2 := 'comboBox';
t_date constant plx_sc.normalv2 := 'date';
t_dropDownList constant plx_sc.normalv2 := 'dropDownList';
t_tag constant plx_sc.normalv2 := 'tag';
t_id constant plx_sc.normalv2 := 'id';
t_picture constant plx_sc.normalv2 := 'picture';
t_placeholder constant plx_sc.normalv2 := 'placeholder';
t_richText constant plx_sc.normalv2 := 'richText';
t_text constant plx_sc.normalv2 := 'text';
t_docPart constant plx_sc.normalv2 := 'docPart';
t_listItem constant plx_sc.normalv2 := 'listItem';
t_dateFormat constant plx_sc.normalv2 := 'dateFormat';
t_lid constant plx_sc.normalv2 := 'lid';
t_storeMappedDataAs constant plx_sc.normalv2 := 'storeMappedDataAs';
t_calendar constant plx_sc.normalv2 := 'calendar';
t_instrText constant plx_sc.normalv2 := 'instrText';
t_chart constant plx_sc.normalv2 := 'chart';
--v4.9.3
t_tblStylePr constant plx_sc.normalv2 := 'tblStylePr';
t_tblPrBase  constant plx_sc.normalv2 := 'tblPrBase';
/******************************************************************/
-- start
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
-- end
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );
-- anchor
procedure startanchor(
  p_tag varchar2 default t_anchor,
  p_xml in out plx_sc.type_xdoc,
  p_allowOverlap varchar2 default null,
  p_behindDoc varchar2 default null,
  p_distB varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null,
  p_distT varchar2 default null,
  p_hidden varchar2 default null,
  p_layoutInCell varchar2 default null,
  p_locked varchar2 default null,
  p_relativeHeight varchar2 default null,
  p_simplePos varchar2 default null
  );
--
procedure endanchor(
  p_tag varchar2 default t_anchor,
  p_xml in out plx_sc.type_xdoc
  );

-- b
procedure b(
  p_tag varchar2 default t_b,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );
-- bottom
procedure bottom(
  p_tag varchar2 default t_bottom,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2 default null,
  p_w varchar2 default null
  );

-- bottom
procedure bottom(
  p_tag varchar2 default t_bottom,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

-- background
procedure background(
      p_tag varchar2 default t_background,
      p_xml in out plx_sc.type_xdoc,
      p_color varchar2 default null,
      p_themeColor varchar2 default null,
      p_themeTint varchar2 default null
  );

-- color
procedure color(
  p_tag varchar2 default t_color,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null
  );

-- i
procedure i(
  p_tag varchar2 default t_i,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

-- sz
procedure sz(
  p_tag varchar2 default t_sz,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

-- u
procedure u(
  p_tag varchar2 default t_u,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null,
  p_color varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null
  );

-- bCs
procedure bCs(
  p_tag varchar2 default t_bCs,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

-- body
procedure startbody(
  p_tag varchar2 default t_body,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endbody(
  p_tag varchar2 default t_body,
  p_xml in out plx_sc.type_xdoc
  );

-- bookmarkEnd
procedure bookmarkEnd(
  p_tag varchar2 default t_bookmarkEnd,
  p_xml in out plx_sc.type_xdoc,
  p_displacedByCustom varchar2 default null,
  p_id varchar2 default null
  );

-- bookmarkStart
procedure bookmarkStart(
  p_tag varchar2 default t_bookmarkStart,
  p_xml in out plx_sc.type_xdoc,
  p_colFirst varchar2 default null,
  p_colLast varchar2 default null,
  p_displacedByCustomXml varchar2 default null,
  p_id varchar2 default null,
  p_name varchar2
  );

-- br
procedure br(
  p_tag varchar2 default t_br,
  p_xml in out plx_sc.type_xdoc,
  p_clear varchar2 default null,
  p_type varchar2 default null
  );

--v5.0
procedure tabchar(
  p_tag varchar2 default t_tab,
  p_xml in out plx_sc.type_xdoc
  );

-- cNvGraphicFramePr
procedure startcNvGraphicFramePr(
  p_tag varchar2 default t_cNvGraphicFramePr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endcNvGraphicFramePr(
  p_tag varchar2 default t_cNvGraphicFramePr,
  p_xml in out plx_sc.type_xdoc
  );

--graphicFrameLocks
procedure startgraphicFrameLocks(
  p_tag varchar2 default t_graphicFrameLocks,
  p_xml in out plx_sc.type_xdoc,
  p_noGrp varchar2 default null,
  p_noDrilldown varchar2 default null,
  p_noSelect varchar2 default null,
  p_noChangeAspect varchar2 default null,
  p_noMove varchar2 default null,
  p_noResize varchar2 default null
  );
--
procedure endgraphicFrameLocks(
  p_tag varchar2 default t_graphicFrameLocks,
  p_xml in out plx_sc.type_xdoc
  );

-- col
procedure col(
  p_tag varchar2 default t_col,
  p_xml in out plx_sc.type_xdoc,
  p_space varchar2 default null,
  p_w varchar2 default null
  );

-- cols
procedure startcols(
  p_tag varchar2 default t_cols,
  p_xml in out plx_sc.type_xdoc,
  p_equalWidth varchar2 default null,
  p_num varchar2 default null,
  p_sep varchar2 default null,
  p_space varchar2 default null
  );
--
procedure endcols(
  p_tag varchar2 default t_cols,
  p_xml in out plx_sc.type_xdoc
  );
--document
procedure startdocument(
  p_tag varchar2 default t_document,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure enddocument(
  p_tag varchar2 default t_document,
  p_xml in out plx_sc.type_xdoc
 );
-- docGrid
procedure docGrid(
  p_tag varchar2 default t_docGrid,
  p_xml in out plx_sc.type_xdoc,
  p_charSpace varchar2 default null,
  p_linePitch varchar2 default null,
  p_type varchar2 default null
  );
--hlinkClick
procedure starthlinkClick(
  p_tag varchar2 default t_hlinkClick,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2 default null,
  p_invalidUrl varchar2 default null,
  p_action varchar2 default null,
  p_tgtFrame varchar2 default null,
  p_tooltip varchar2 default null,
  p_history varchar2 default null,
  p_highlightClick varchar2 default null,
  p_endSnd varchar2 default null
  );
--
procedure endhlinkClick(
  p_tag varchar2 default t_hlinkClick,
  p_xml in out plx_sc.type_xdoc
  );
--hlinkHover
procedure starthlinkHover(
  p_tag varchar2 default t_hlinkHover,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2 default null,
  p_invalidUrl varchar2 default null,
  p_action varchar2 default null,
  p_tgtFrame varchar2 default null,
  p_tooltip varchar2 default null,
  p_history varchar2 default null,
  p_highlightClick varchar2 default null,
  p_endSnd varchar2 default null
  );
--
procedure endhlinkHover(
  p_tag varchar2 default t_hlinkHover,
  p_xml in out plx_sc.type_xdoc
  );
--snd
procedure snd(
  p_tag varchar2 default t_snd,
  p_xml in out plx_sc.type_xdoc,
  p_embed varchar2 default null,
  p_name varchar2 default null
  );
-- docPr
procedure startdocPr(
  p_tag varchar2 default t_docPr,
  p_xml in out plx_sc.type_xdoc,
  p_descr varchar2 default null,
  p_hidden varchar2 default null,
  p_id varchar2,
  p_name varchar2
  );
--
procedure enddocPr(
  p_tag varchar2 default t_docPr,
  p_xml in out plx_sc.type_xdoc
  );

-- drawing
procedure startdrawing(
  p_tag varchar2 default t_drawing,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure enddrawing(
  p_tag varchar2 default t_drawing,
  p_xml in out plx_sc.type_xdoc
  );
--v5.8
procedure startpict(
  p_tag varchar2 default t_pict,
  p_xml in out plx_sc.type_xdoc
  );
--v5.8
procedure endpict(
  p_tag varchar2 default t_pict,
  p_xml in out plx_sc.type_xdoc
  );
-- effectextent
procedure effectextent (
  p_tag varchar2 default t_effectextent,
  p_xml in out plx_sc.type_xdoc,
  p_b varchar2,
  p_l varchar2,
  p_r varchar2,
  p_t varchar2
  );

-- extent
procedure extent(
  p_tag varchar2 default t_extent,
  p_xml in out plx_sc.type_xdoc,
  p_cx varchar2,
  p_cy varchar2
  );

-- gridCol
procedure gridCol(
  p_tag varchar2 default t_gridCol,
  p_xml in out plx_sc.type_xdoc,
  p_w varchar2
  );

-- hMerge
procedure hMerge(
  p_tag varchar2 default t_hMerge,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- ilvl
procedure ilvl(
  p_tag varchar2 default t_ilvl,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- ind
procedure ind(
  p_tag varchar2 default t_ind,
  p_xml in out plx_sc.type_xdoc,
  p_left varchar2 default null,
  p_leftChars varchar2 default null,
  p_right varchar2 default null,
  p_rightChars varchar2 default null,
  p_hanging varchar2 default null,
  p_hangingChars varchar2 default null,
  p_firstLine varchar2 default null,
  p_firstLineChars varchar2 default null
  );

-- insideH
procedure insideH(
  p_tag varchar2 default t_insideH,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

-- insideV
procedure insideV(
  p_tag varchar2 default t_insideV,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );
-- left
procedure left(
  p_tag varchar2 default t_left,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2 default null,
  p_w varchar2 default null
  );

-- left
procedure left(
  p_tag varchar2 default t_left,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

-- numFmt
procedure numFmt(
  p_tag varchar2 default t_numFmt,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--numberingChange
procedure numberingChange(
  p_tag varchar2 default t_numberingChange,
  p_xml in out plx_sc.type_xdoc,
  p_author varchar2,
  p_date varchar2,
  p_id varchar2,
  p_original varchar2
  );

--ins
procedure ins(
  p_tag varchar2 default t_ins,
  p_xml in out plx_sc.type_xdoc,
  p_author varchar2,
  p_date varchar2,
  p_id varchar2
  );

-- inline
procedure startinline(
  p_tag varchar2 default t_inline,
  p_xml in out plx_sc.type_xdoc,
  p_distB varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null,
  p_distT varchar2 default null
  );
--
procedure endinline(
  p_tag varchar2 default t_inline,
  p_xml in out plx_sc.type_xdoc
  );

-- jc
procedure jc(
  p_tag varchar2 default t_jc,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- pageBreakBefore
procedure pageBreakBefore(
  p_tag varchar2 default t_pageBreakBefore,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- noWrap
procedure noWrap(
  p_tag varchar2 default t_noWrap,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--widowControl
procedure widowControl(
  p_tag varchar2 default t_widowControl,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--wordWrap
procedure wordWrap(
  p_tag varchar2 default t_wordWrap,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- lineTo
procedure lineTo(
  p_tag varchar2 default t_lineTo,
  p_xml in out plx_sc.type_xdoc,
  p_x varchar2,
  p_y varchar2
  );

-- noProof
procedure noProof(
  p_tag varchar2 default t_noProof,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

-- numId
procedure numId(
  p_tag varchar2 default t_numId,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- numPr
procedure startnumPr(
  p_tag varchar2 default t_numPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endnumPr(
  p_tag varchar2 default t_numPr,
  p_xml in out plx_sc.type_xdoc
  );
-- p
procedure startp(
  p_tag varchar2 default t_p,
  p_xml in out plx_sc.type_xdoc,
  p_rsidRPr varchar2 default null,
  p_rsidR varchar2 default null,
  p_rsidDel varchar2 default null,
  p_rsidP varchar2 default null,
  p_rsidRDefault varchar2 default null
  );
--
procedure endp(
  p_tag varchar2 default t_p,
  p_xml in out plx_sc.type_xdoc
  );

-- pgMar
procedure pgMar(
  p_tag varchar2 default t_pgMar,
  p_xml in out plx_sc.type_xdoc,
  p_bottom varchar2,
  p_footer varchar2,
  p_gutter varchar2,
  p_header varchar2,
  p_left varchar2,
  p_right varchar2,
  p_top varchar2
  );

-- pgSz
procedure pgSz(
  p_tag varchar2 default t_pgSz,
  p_xml in out plx_sc.type_xdoc,
  p_code varchar2 default null,
  p_h varchar2 default null,
  p_orient varchar2 default null,
  p_w varchar2 default null
  );
-- positionH
procedure startpositionH(
  p_tag varchar2 default t_positionH,
  p_xml in out plx_sc.type_xdoc,
  p_relativeFrom varchar2
  );
--
procedure endpositionH(
  p_tag varchar2 default t_positionH,
  p_xml in out plx_sc.type_xdoc
  );

-- positionV
procedure startpositionV(
  p_tag varchar2 default t_positionV,
  p_xml in out plx_sc.type_xdoc,
  p_relativeFrom varchar2
  );
--
procedure endpositionV(
  p_tag varchar2 default t_positionV,
  p_xml in out plx_sc.type_xdoc
  );

-- posOffset
procedure startposOffset(
  p_tag varchar2 default t_posOffset,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endposOffset(
  p_tag varchar2 default t_posOffset,
  p_xml in out plx_sc.type_xdoc
  );
-- align
procedure startalign(
  p_tag varchar2 default t_align,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endalign(
  p_tag varchar2 default t_align,
  p_xml in out plx_sc.type_xdoc
  );
-- proofErr
procedure proofErr(
  p_tag varchar2 default t_proofErr,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2
  );

-- pPr
procedure startpPr(
  p_tag varchar2 default t_pPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endpPr(
  p_tag varchar2 default t_pPr,
  p_xml in out plx_sc.type_xdoc
  );
-- pStyle
procedure pStyle(
  p_tag varchar2 default t_pStyle,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );
-- r
procedure startr(
  p_tag varchar2 default t_r,
  p_xml in out plx_sc.type_xdoc,
  p_rsidRPr varchar2 default null,
  p_rsidDel varchar2 default null,
  p_rsidR varchar2 default null
  );
--
procedure endr(
  p_tag varchar2 default t_r,
  p_xml in out plx_sc.type_xdoc
  );

-- right
procedure right(
  p_tag varchar2 default t_right,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2 default null,
  p_w varchar2 default null
  );

-- right
procedure right(
  p_tag varchar2 default t_right,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

-- rFonts
procedure rFonts(
  p_tag varchar2 default t_rFonts,
  p_xml in out plx_sc.type_xdoc,
  p_ascii varchar2 default null,
  p_asciiTheme varchar2 default null,
  p_cs varchar2 default null,
  p_csTheme varchar2 default null,
  p_eastAsia varchar2 default null,
  p_eastAsiaTheme varchar2 default null,
  p_hAnsi varchar2 default null,
  p_hAnsiTheme varchar2 default null,
  p_hint varchar2 default null
  );

-- rPr
procedure startrPr(
  p_tag varchar2 default t_rPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endrPr(
  p_tag varchar2 default t_rPr,
  p_xml in out plx_sc.type_xdoc
  );
-- rStyle
procedure rStyle(
  p_tag varchar2 default t_rStyle,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- sectPr
procedure startsectPr(
  p_tag varchar2 default t_sectPr,
  p_xml in out plx_sc.type_xdoc,
  p_rsidDel varchar2 default null,
  p_rsidR varchar2 default null,
  p_rsidRPr varchar2 default null,
  p_rsidSect varchar2 default null
  );
--
procedure endsectPr(
  p_tag varchar2 default t_sectPr,
  p_xml in out plx_sc.type_xdoc
  );
-- shd
procedure shd(
  p_tag varchar2 default t_shd,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2,
  p_color varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null,
  p_fill varchar2 default null,
  p_themeFill varchar2 default null,
  p_themeFillTint varchar2 default null,
  p_themeFillShade varchar2 default null
  );

-- simplePos
procedure simplePos(
  p_tag varchar2 default t_simplePos,
  p_xml in out plx_sc.type_xdoc,
  p_x varchar2,
  p_y varchar2
  );

-- spacing
procedure spacing(
  p_tag varchar2 default t_spacing,
  p_xml in out plx_sc.type_xdoc,
  p_after varchar2 default null,
  p_afterAutospacing varchar2 default null,
  p_afterLines varchar2 default null,
  p_before varchar2 default null,
  p_beforeAutospacing varchar2 default null,
  p_beforeLines varchar2 default null,
  p_line varchar2 default null,
  p_lineRule varchar2 default null
  );

-- start
procedure start_1(
  p_tag varchar2 default t_start,
  p_xml in out plx_sc.type_xdoc,
  p_x varchar2,
  p_y varchar2
  );
-- t
procedure startt(
  p_tag varchar2 default t_t,
  p_xml in out plx_sc.type_xdoc,
  p_space varchar2 default null
  );
--
procedure endt(
  p_tag varchar2 default t_t,
  p_xml in out plx_sc.type_xdoc
  );

-- tc
procedure starttc(
  p_tag varchar2 default t_tc,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtc(
  p_tag varchar2 default t_tc,
  p_xml in out plx_sc.type_xdoc
  );

-- tcPr
procedure starttcPr(
  p_tag varchar2 default t_tcPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtcPr(
  p_tag varchar2 default t_tcPr,
  p_xml in out plx_sc.type_xdoc
  );

-- tcW
procedure tcW(
  p_tag varchar2 default t_tcW,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2 default null,
  p_w varchar2 default null
  );

-- tbl
procedure starttbl(
  p_tag varchar2 default t_tbl,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtbl(
  p_tag varchar2 default t_tbl,
  p_xml in out plx_sc.type_xdoc
  );

-- tblCellMar
procedure starttblCellMar(
  p_tag varchar2 default t_tblCellMar,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtblCellMar(
  p_tag varchar2 default t_tblCellMar,
  p_xml in out plx_sc.type_xdoc
  );


--bottom, left,top....
procedure Border(
  p_tag varchar2,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null,
  p_color varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null,
  p_sz varchar2 default null,
  p_space varchar2 default null,
  p_shadow varchar2 default null,
  p_frame varchar2 default null
  );

-- tblBorders
procedure starttblBorders(
  p_tag varchar2 default t_tblBorders,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtblBorders(
  p_tag varchar2 default t_tblBorders,
  p_xml in out plx_sc.type_xdoc
  );

-- tblCellSpacing
procedure tblCellSpacing(
  p_tag varchar2 default t_tblCellSpacing,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2,
  p_w varchar2
  );


-- tblGrid
procedure starttblGrid(
  p_tag varchar2 default t_tblGrid,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtblGrid(
  p_tag varchar2 default t_tblGrid,
  p_xml in out plx_sc.type_xdoc
  );

-- tblInd
procedure tblInd(
  p_tag varchar2 default t_tblInd,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2 default null,
  p_w varchar2 default null
  );

-- tblLook
procedure tblLook(
  p_tag varchar2 default t_tblLook,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- tblOverlap
procedure tblOverlap(
  p_tag varchar2 default t_tblOverlap,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- tblPr
procedure starttblPr(
  p_tag varchar2 default t_tblPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtblPr(
  p_tag varchar2 default t_tblPr,
  p_xml in out plx_sc.type_xdoc
  );

-- tblStyle
procedure tblStyle(
  p_tag varchar2 default t_tblStyle,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- tblW
procedure tblW(
  p_tag varchar2 default t_tblW,
  p_xml in out plx_sc.type_xdoc,
  p_w varchar2 default null,
  p_type varchar2 default null
  );
-- top
procedure top(
  p_tag varchar2 default t_top,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2 default null,
  p_w varchar2 default null
  );

-- top
procedure top(
  p_tag varchar2 default t_top,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

-- tr
procedure starttr(
  p_tag varchar2 default t_tr,
  p_xml in out plx_sc.type_xdoc,
  p_rsidDel varchar2 default null,
  p_rsidR varchar2 default null,
  p_rsidRPr varchar2 default null,
  p_rsidTr varchar2 default null
  );
--
procedure endtr(
  p_tag varchar2 default t_tr,
  p_xml in out plx_sc.type_xdoc
  );

-- trPr
procedure starttrPr(
  p_tag varchar2 default t_trPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtrPr(
  p_tag varchar2 default t_trPr,
  p_xml in out plx_sc.type_xdoc
  );
-- vMerge
procedure vMerge(
  p_tag varchar2 default t_vMerge,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- wrapNone
procedure wrapNone(
  p_tag varchar2 default t_wrapNone,
  p_xml in out plx_sc.type_xdoc
  );

-- wrapPolygon
procedure startwrapPolygon(
  p_tag varchar2 default t_wrapPolygon,
  p_xml in out plx_sc.type_xdoc,
  p_edited varchar2 default null
  );
--
procedure endwrapPolygon(
  p_tag varchar2 default t_wrapPolygon,
  p_xml in out plx_sc.type_xdoc
  );

-- wrapSquare
procedure startwrapSquare(
  p_tag varchar2 default t_wrapSquare,
  p_xml in out plx_sc.type_xdoc,
  p_distB varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null,
  p_distT varchar2 default null,
  p_wrapText varchar2 default null
  );

--v1.3.0
procedure endwrapSquare(
  p_tag varchar2 default t_wrapSquare,
  p_xml in out plx_sc.type_xdoc
  );

-- wrapThrough
procedure startwrapThrough(
  p_tag varchar2 default t_wrapThrough,
  p_xml in out plx_sc.type_xdoc,
  p_distL varchar2 default null,
  p_distR varchar2 default null,
  p_wrapText varchar2
  );
--v1.3.0
procedure endwrapThrough(
  p_tag varchar2 default t_wrapThrough,
  p_xml in out plx_sc.type_xdoc
  );
-- wrapTopAndBottom
procedure startwrapTopAndBottom(
  p_tag varchar2 default t_wrapTopAndBottom,
  p_xml in out plx_sc.type_xdoc,
  p_distB varchar2 default null,
  p_distT varchar2 default null
  );
--v1.3.0
procedure endwrapTopAndBottom(
  p_tag varchar2 default t_wrapTopAndBottom,
  p_xml in out plx_sc.type_xdoc
  );
-- lang
procedure lang(
  p_tag varchar2 default t_lang,
  p_xml in out plx_sc.type_xdoc,
  p_bidi varchar2 default null,
  p_eastAsia varchar2 default null,
  p_val varchar2 default null
  );
-- szCs
procedure szCs(
  p_tag varchar2 default t_szCs,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

-- headerReference
procedure headerReference(
  p_tag varchar2 default t_headerReference,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2,
  p_type varchar2
  );

-- footerReference
procedure footerReference(
  p_tag varchar2 default t_footerReference,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2,
  p_type varchar2
  );

-- Addtext
procedure addtext(
  p_xml in out plx_sc.type_xdoc,
  p_text varchar2
  );
--
--v1.3.0
-- graphic CT_GraphicalObject
procedure startgraphic(
  p_tag varchar2 default t_graphic,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endgraphic(
  p_tag varchar2 default t_graphic,
  p_xml in out plx_sc.type_xdoc
  );
--graphicData CT_GraphicalObjectData
procedure startgraphicData(
  p_tag varchar2 default t_graphicData,
  p_xml in out plx_sc.type_xdoc,
  p_uri varchar2
  );
--
procedure endgraphicData(
  p_tag varchar2 default t_graphicData,
  p_xml in out plx_sc.type_xdoc
  );
--wrapTight CT_WrapTight
procedure startwrapTight(
  p_tag varchar2 default t_wrapTight,
  p_xml in out plx_sc.type_xdoc,
  p_distL varchar2 default null,
  p_distR varchar2 default null,
  p_wrapText varchar2 default null
  );
--
procedure endwrapTight(
  p_tag varchar2 default t_wrapTight,
  p_xml in out plx_sc.type_xdoc
  );
--
--v1.3.0
-- CT_Attr
procedure attr(
  p_xml in out plx_sc.type_xdoc,
  p_uri varchar2 default null,
  p_name varchar2 default null,
  p_val varchar2 default null
  );
--v1.3.0
-- CT_CustomXmlPr
procedure startCustomXmlPr(
  p_xml in out plx_sc.type_xdoc,
  p_placeholder varchar2 default null
  );
--
procedure endCustomXmlPr(
  p_xml in out plx_sc.type_xdoc
  );
--v1.3.0
-- CT_CustomXmlRun, CT_CustomXmlCell,CT_CustomXmlRow,CT_CustomXmlBlock
procedure startCustomXml(
  p_xml in out plx_sc.type_xdoc,
  p_uri varchar2 default null,
  p_element varchar2 default null
  );
--
procedure endCustomXml(
  p_xml in out plx_sc.type_xdoc
  );
--v1.3.0
-- eastAsianLayout CT_EastAsianLayout
procedure eastAsianLayout(
  p_tag varchar2 default t_eastAsianLayout,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2 default null,
  p_combine varchar2 default null,
  p_combineBrackets varchar2 default null,
  p_vert varchar2 default null,
  p_vertCompress varchar2 default null
  );

--v1.3.0
-- effect CT_TextEffect
procedure effect(
  p_tag varchar2 default t_effect,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
-- em CT_Em
procedure em(
  p_tag varchar2 default t_em,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
-- fitText CT_FitText
procedure fitText(
  p_tag varchar2 default t_fitText,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2,
  p_id varchar2 default null
  );


--v1.3.0
-- highlight CT_highlight
procedure highlight(
  p_tag varchar2 default t_highlight,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
-- position CT_SignedHpsMeasure
procedure position(
  p_tag varchar2 default t_position,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
-- vertAlign
procedure vertAlign(
  p_tag varchar2 default t_vertAlign,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--w
procedure w(
  p_tag varchar2 default t_w,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--bdr
procedure bdr(
  p_tag varchar2 default t_bdr,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2,
  p_color varchar2 default null, --ST_HexColor
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null, --ST_UcharHexNumber
  p_themeShade varchar2 default null, --ST_UcharHexNumber
  p_sz varchar2 default null, --ST_EighthPointMeasure
  p_space varchar2 default null, --ST_PointMeasure
  p_shadow varchar2 default null, --ST_OnOff
  p_frame varchar2 default null --ST_OnOff
  );

--v1.3.0
--caps
procedure caps(
  p_tag varchar2 default t_caps,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--cs
procedure cs(
  p_tag varchar2 default t_cs,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--dstrike
procedure dstrike(
  p_tag varchar2 default t_dstrike,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

 --v1.3.0
--emboss
procedure emboss(
  p_tag varchar2 default t_emboss,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--iCs
procedure iCs(
  p_tag varchar2 default t_iCs,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--imprint
procedure imprint(
  p_tag varchar2 default t_imprint,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--kern
procedure kern(
  p_tag varchar2 default t_kern,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--oMath
procedure oMath(
  p_tag varchar2 default t_oMath,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--outline
procedure outline(
  p_tag varchar2 default t_outline,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--rtl
procedure rtl(
  p_tag varchar2 default t_rtl,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--shadow
procedure shadow(
  p_tag varchar2 default t_shadow,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--smallCaps
procedure smallCaps(
  p_tag varchar2 default t_smallCaps,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--snapToGrid
procedure snapToGrid(
  p_tag varchar2 default t_snapToGrid,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--specVanish
procedure specVanish(
  p_tag varchar2 default t_specVanish,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--strike
procedure strike(
  p_tag varchar2 default t_strike,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--vanish
procedure vanish(
  p_tag varchar2 default t_vanish,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--webHidden
procedure webHidden(
  p_tag varchar2 default t_webHidden,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );

--v1.3.0
--spacing2
procedure spacing2(
  p_tag varchar2 default t_spacing,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--adjustRightInd
procedure adjustRightInd(
  p_tag varchar2 default t_adjustRightInd,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--autoSpaceDE
procedure autoSpaceDE(
  p_tag varchar2 default t_autoSpaceDE,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--autoSpaceDN
procedure autoSpaceDN(
  p_tag varchar2 default t_autoSpaceDN,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--bidi
procedure bidi(
  p_tag varchar2 default t_bidi,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--cnfStyle
procedure cnfStyle(
  p_tag varchar2 default t_cnfStyle,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--contextualSpacing
procedure contextualSpacing(
  p_tag varchar2 default t_contextualSpacing,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--divId
procedure divId(
  p_tag varchar2 default t_divId,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--framePr
procedure framePr(
  p_tag varchar2 default t_framePr,
  p_xml in out plx_sc.type_xdoc,
  p_dropCap varchar2 default null,
  p_lines varchar2 default null, --ST_DecimalNumber
  p_w varchar2 default null, --ST_TwipsMeasure
  p_h varchar2 default null, --ST_TwipsMeasure
  p_vSpace varchar2 default null, --ST_TwipsMeasure
  p_hSpace varchar2 default null, --ST_TwipsMeasure
  p_wrap varchar2 default null,
  p_hAnchor varchar2 default null,
  p_vAnchor varchar2 default null,
  p_x varchar2 default null, --ST_SignedTwipsMeasure
  p_xAlign varchar2 default null,
  p_y varchar2 default null, --ST_SignedTwipsMeasure
  p_yAlign varchar2 default null,
  p_hRule varchar2 default null,
  p_anchorLock varchar2 default null
  );

--v1.3.0
--keepLines
procedure keepLines(
  p_tag varchar2 default t_keepLines,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--keepNext
procedure keepNext(
  p_tag varchar2 default t_keepNext,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--kinsoku
procedure kinsoku(
  p_tag varchar2 default t_kinsoku,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--mirrorIndents
procedure mirrorIndents(
  p_tag varchar2 default t_mirrorIndents,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--outlineLvl
procedure outlineLvl(
  p_tag varchar2 default t_outlineLvl,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--overflowPunct
procedure overflowPunct(
  p_tag varchar2 default t_overflowPunct,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--pBdr
procedure startpBdr(
  p_tag varchar2 default t_pBdr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endpBdr(
  p_tag varchar2 default t_pBdr,
  p_xml in out plx_sc.type_xdoc
  );

--v1.3.0
--suppressAutoHyphens
procedure suppressAutoHyphens(
  p_tag varchar2 default t_suppressAutoHyphens,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--suppressLineNumbers
procedure suppressLineNumbers(
  p_tag varchar2 default t_suppressLineNumbers,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--suppressOverlap
procedure suppressOverlap(
  p_tag varchar2 default t_suppressOverlap,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--tabs
procedure starttabs(
  p_tag varchar2 default t_tabs,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtabs(
  p_tag varchar2 default t_tabs,
  p_xml in out plx_sc.type_xdoc
  );

--v1.3.0
--tab
procedure tab(
  p_tag varchar2 default t_tab,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2,
  p_leader varchar2,
  p_pos varchar2 --ST_SignedTwipsMeasure
  );

--v1.3.0
--textAlignment
procedure textAlignment(
  p_tag varchar2 default t_textAlignment,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--textboxTightWrap
procedure textboxTightWrap(
  p_tag varchar2 default t_textboxTightWrap,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--textDirection
procedure textDirection(
  p_tag varchar2 default t_textDirection,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--topLinePunct
procedure topLinePunct(
  p_tag varchar2 default t_topLinePunct,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
-- between
procedure between_(
  p_tag varchar2 default t_between,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

--v1.3.0
-- bar
procedure bar(
  p_tag varchar2 default t_bar,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

--v1.3.0
--tblpPr
procedure tblpPr(
  p_tag varchar2 default t_tblpPr,
  p_xml in out plx_sc.type_xdoc,
  p_leftFromText varchar2, --ST_TwipsMeasure
  p_rightFromText varchar2, --ST_TwipsMeasure
  p_topFromText varchar2, --ST_TwipsMeasure
  p_bottomFromText varchar2, --ST_TwipsMeasure
  p_vertAnchor varchar2,
  p_horzAnchor varchar2,
  p_tblpXSpec varchar2,
  p_tblpX varchar2, --ST_SignedTwipsMeasure
  p_tblpYSpec varchar2,
  p_tblpY varchar2 --ST_SignedTwipsMeasure
  );

--v1.3.0
--bidiVisual
procedure bidiVisual(
  p_tag varchar2 default t_bidiVisual,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--tblStyleRowBandSize
procedure tblStyleRowBandSize(
  p_tag varchar2 default t_tblStyleRowBandSize,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--tblStyleColBandSize
procedure tblStyleColBandSize(
  p_tag varchar2 default t_tblStyleColBandSize,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--tblLayout
procedure tblLayout(
  p_tag varchar2 default t_tblLayout,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


--v1.3.0
--tblCaption
procedure tblCaption(
  p_tag varchar2 default t_tblCaption,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--tblDescription
procedure tblDescription(
  p_tag varchar2 default t_tblDescription,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--gridSpan
procedure gridSpan(
  p_tag varchar2 default t_gridSpan,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--hideMark
procedure hideMark(
  p_tag varchar2 default t_hideMark,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--tcBorders
procedure starttcBorders(
  p_tag varchar2 default t_tcBorders,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtcBorders(
  p_tag varchar2 default t_tcBorders,
  p_xml in out plx_sc.type_xdoc
  );

--v1.3.0
--tcFitText
procedure tcFitText(
  p_tag varchar2 default t_tcFitText,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--tcMar
procedure starttcMar(
  p_tag varchar2 default t_tcMar,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endtcMar(
  p_tag varchar2 default t_tcMar,
  p_xml in out plx_sc.type_xdoc
  );

--v1.3.0
--vAlign
procedure vAlign(
  p_tag varchar2 default t_vAlign,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
-- tl2br
procedure tl2br(
  p_tag varchar2 default t_tl2br,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

--v1.3.0
-- tr2bl
procedure tr2bl(
  p_tag varchar2 default t_tr2bl,
  p_xml in out plx_sc.type_xdoc,
  p_color varchar2 default null,
  p_frame varchar2 default null,
  p_shadow varchar2 default null,
  p_space varchar2 default null,
  p_sz varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeShade varchar2 default null,
  p_themeTint varchar2 default null,
  p_val varchar2
  );

--v1.3.0
--gridBefore
procedure gridBefore(
  p_tag varchar2 default t_gridBefore,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--gridAfter
procedure gridAfter(
  p_tag varchar2 default t_gridAfter,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--wBefore
procedure wBefore(
  p_tag varchar2 default t_wBefore,
  p_xml in out plx_sc.type_xdoc,
  p_w varchar2,
  p_type varchar2
  );

--v1.3.0
--wAfter
procedure wAfter(
  p_tag varchar2 default t_wAfter,
  p_xml in out plx_sc.type_xdoc,
  p_w varchar2,
  p_type varchar2
  );

--v1.3.0
--cantSplit
procedure cantSplit(
  p_tag varchar2 default t_cantSplit,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--trHeight
procedure trHeight(
  p_tag varchar2 default t_trHeight,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2,
  p_hRule varchar2
  );

--v1.3.0
--tblHeader
procedure tblHeader(
  p_tag varchar2 default t_tblHeader,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--hidden
procedure hidden(
  p_tag varchar2 default t_hidden,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--endnotePr
procedure startendnotePr(
  p_tag varchar2 default t_endnotePr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endendnotePr(
  p_tag varchar2 default t_endnotePr,
  p_xml in out plx_sc.type_xdoc
  );

--v1.3.0
--footnotePr
procedure startfootnotePr(
  p_tag varchar2 default t_footnotePr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endfootnotePr(
  p_tag varchar2 default t_footnotePr,
  p_xml in out plx_sc.type_xdoc
  );

--v1.3.0
--formProt
procedure formProt(
  p_tag varchar2 default t_formProt,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--lnNumType
procedure lnNumType(
  p_tag varchar2 default t_lnNumType,
  p_xml in out plx_sc.type_xdoc,
  p_countBy varchar2,
  p_distance varchar2,
  p_restart varchar2,
  p_start_ varchar2
  );

--v1.3.0
--noEndnote
procedure noEndnote(
  p_tag varchar2 default t_noEndnote,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--paperSrc
procedure paperSrc(
  p_tag varchar2 default t_paperSrc,
  p_xml in out plx_sc.type_xdoc,
  p_first varchar2 default null,
  p_other varchar2 default null
  );


--v1.3.0
--pgBorders
procedure startpgBorders(
  p_tag varchar2 default t_pgBorders,
  p_xml in out plx_sc.type_xdoc,
  p_display varchar2 default null,
  p_offsetFrom varchar2 default null,
  p_ZOrder varchar2 default null
  );
--
procedure endpgBorders(
  p_tag varchar2 default t_pgBorders,
  p_xml in out plx_sc.type_xdoc
  );


--v1.3.0
--pgNumType
procedure pgNumType(
  p_tag varchar2 default t_pgNumType,
  p_xml in out plx_sc.type_xdoc,
  p_chapSep varchar2 default null,
  p_chapStyle varchar2 default null,
  p_fmt varchar2 default null,
  p_start varchar2 default null
  );

--v1.3.0
--printerSettings
procedure printerSettings(
  p_tag varchar2 default t_printerSettings,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2
  );

--v1.3.0
--rtlGutter
procedure rtlGutter(
  p_tag varchar2 default t_rtlGutter,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--sectPrChange
procedure startsectPrChange(
  p_tag varchar2 default t_sectPrChange,
  p_xml in out plx_sc.type_xdoc,
  p_author varchar2,
  p_date_ varchar2,
  p_id varchar2
  );
--
procedure endsectPrChange(
  p_tag varchar2 default t_sectPrChange,
  p_xml in out plx_sc.type_xdoc
  );


--v1.3.0
--titlePg
procedure titlePg(
  p_tag varchar2 default t_titlePg,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v1.3.0
--type
procedure type(
  p_tag varchar2 default t_type,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- numRestart
procedure numRestart(
  p_tag varchar2 default t_numRestart,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- numStart
procedure numStart(
  p_tag varchar2 default t_numStart,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- pos
procedure pos(
  p_tag varchar2 default t_pos,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );

--v3.0.7
procedure fldChar(
  p_tag varchar2 default t_fldChar,
  p_xml in out plx_sc.type_xdoc,
  p_dirty varchar2 default null,       --ST_OnOff
  p_fldCharType varchar2, --ST_fldCharType
  p_fldLock varchar2 default null      --ST_OnOff
  );

--v2.0.0
procedure fldSimple(
  p_tag varchar2 default t_fldSimple,
  p_xml in out plx_sc.type_xdoc,
  p_instr varchar2,
  p_fldLock varchar2 default null,
  p_dirty varchar2 default null
  );

--v2.0.0
--hyperlink
procedure startHyperlink(
  p_tag varchar2 default t_hyperlink,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2 default null,
  p_tgtFrame varchar2 default null,
  p_tooltip varchar2 default null,
  p_docLocation varchar2 default null,
  p_history varchar2 default null,
  p_anchor plx_sc.normalv2
);

procedure endHyperlink(
  p_tag varchar2 default t_hyperlink,
  p_xml in out plx_sc.type_xdoc
  );


-- sdt
procedure startsdt(
  p_tag varchar2 default t_sdt,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endsdt(
  p_tag varchar2 default t_sdt,
  p_xml in out plx_sc.type_xdoc
  );


-- sdtPr
procedure startsdtPr(
  p_tag varchar2 default t_sdtPr,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endsdtPr(
  p_tag varchar2 default t_sdtPr,
  p_xml in out plx_sc.type_xdoc
  );


-- sdtContent
procedure startsdtContent(
  p_tag varchar2 default t_SdtContent,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endsdtContent(
  p_tag varchar2 default t_SdtContent,
  p_xml in out plx_sc.type_xdoc
  );


-- alias
procedure alias(
  p_tag varchar2 default t_alias,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- comboBox
procedure startcomboBox(
  p_tag varchar2 default t_comboBox,
  p_xml in out plx_sc.type_xdoc,
  p_lastValue varchar2 default null
  );
--
procedure endcomboBox(
  p_tag varchar2 default t_comboBox,
  p_xml in out plx_sc.type_xdoc
  );


-- date
procedure startDate(
  p_tag varchar2 default t_date,
  p_xml in out plx_sc.type_xdoc,
  p_fullDate varchar2 default null
  );
--
procedure endDate(
  p_tag varchar2 default t_alias,
  p_xml in out plx_sc.type_xdoc
  );


-- dropDownList
procedure startdropDownList(
  p_tag varchar2 default t_dropDownList,
  p_xml in out plx_sc.type_xdoc,
  p_lastValue varchar2 default null
  );
--
procedure enddropDownList(
  p_tag varchar2 default t_dropDownList,
  p_xml in out plx_sc.type_xdoc
  );


-- tag
procedure tag(
  p_tag varchar2 default t_tag,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- id
procedure id(
  p_tag varchar2 default t_id,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- picture
procedure picture(
  p_tag varchar2 default t_picture,
  p_xml in out plx_sc.type_xdoc
  );


-- placeholder
procedure startplaceholder(
  p_tag varchar2 default t_placeholder,
  p_xml in out plx_sc.type_xdoc
  );
--
procedure endplaceholder(
  p_tag varchar2 default t_placeholder,
  p_xml in out plx_sc.type_xdoc
  );


-- richText
procedure richText(
  p_tag varchar2 default t_richText,
  p_xml in out plx_sc.type_xdoc
  );


-- text
procedure text(
  p_tag varchar2 default t_text,
  p_xml in out plx_sc.type_xdoc,
  p_multiline varchar2 default null
  );


-- docPart
procedure docPart(
  p_tag varchar2 default t_docPart,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- listItem
procedure listItem(
  p_tag varchar2 default t_listItem,
  p_xml in out plx_sc.type_xdoc,
  p_displayText varchar2 default null,
  p_value varchar2 default null
  );


-- dateFormat
procedure dateFormat(
  p_tag varchar2 default t_dateFormat,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- lid
procedure lid(
  p_tag varchar2 default t_lid,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2
  );


-- storeMappedDataAs
procedure storeMappedDataAs(
  p_tag varchar2 default t_storeMappedDataAs,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );


-- calendar
procedure calendar(
  p_tag varchar2 default t_calendar,
  p_xml in out plx_sc.type_xdoc,
  p_val varchar2 default null
  );
--
-- v3.0.6
-- instrText
procedure startinstrText(
  p_tag varchar2 default t_instrText,
  p_xml in out plx_sc.type_xdoc,
  p_space varchar2 default null
  );
--
-- v3.0.6
-- instrText
procedure endinstrText(
  p_tag varchar2 default t_instrText,
  p_xml in out plx_sc.type_xdoc
  );

-- v3.6.0
procedure chart(
  p_tag varchar2 default t_chart,
  p_xml in out plx_sc.type_xdoc,
  p_r_id varchar2 default null
  );
--
--v4.9.3
--tblStylePr
procedure starttblStylePr(
  p_tag varchar2 default t_tblStylePr,
  p_xml in out plx_sc.type_xdoc,
  p_type varchar2 default null
  );
--
--v4.9.3
--tblStylePr
procedure endtblStylePr(
  p_tag varchar2 default t_tblStylePr,
  p_xml in out plx_sc.type_xdoc
  );
--
--v4.9.3
--tblPrBase
procedure starttblPrBase(
  p_tag varchar2 default t_tblPrBase,
  p_xml in out plx_sc.type_xdoc
  );
--
--4.9.3
--tblPrBase
procedure endtblPrBase(
  p_tag varchar2 default t_tblPrBase,
  p_xml in out plx_sc.type_xdoc
  );
/***********************************************************************************/
end ploffx_document_tag;
/

