create or replace package ploffx_document_cr
authid current_user is
--v5.9
---------------------------------------------
--rFonts
--create structure
function rFonts(
  p_tag varchar2 default ploffx_document_tag.t_rFonts,
  p_ascii varchar2 default null,
  p_asciiTheme varchar2 default null,
  p_cs varchar2 default null,
  p_csTheme varchar2 default null,
  p_eastAsia varchar2 default null,
  p_eastAsiaTheme varchar2 default null,
  p_hAnsi varchar2 default null,
  p_hAnsiTheme varchar2 default null,
  p_hint varchar2 default null
  ) return ploffx_document_type.CT_Fonts;
---------------------------------------------
--v1.3.0
--eastAsianLayout:CT_EastAsianLayout
--create structure
function eastAsianLayout(
  p_tag varchar2 default ploffx_document_tag.t_eastAsianLayout,
  p_id varchar2 default null,
  p_combine varchar2 default null,
  p_combineBrackets varchar2 default null,
  p_vert varchar2 default null,
  p_vertCompress varchar2 default null
  ) return ploffx_document_type.CT_EastAsianLayout;
---------------------------------------------
--v1.3.0
--effect:CT_TextEffect
--create structure
function effect(
  p_tag varchar2 default ploffx_document_tag.t_effect,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TextEffect;
---------------------------------------------
--v1.3.0
--em:CT_Em
--create structure
function em(
  p_tag varchar2 default ploffx_document_tag.t_em,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_Em;
---------------------------------------------
--v1.3.0
--fittext:CT_FitText
--create structure
function fittext(
  p_tag varchar2 default ploffx_document_tag.t_fitText,
  p_val varchar2 default null,
  p_id varchar2 default null
  ) return ploffx_document_type.CT_FitText;
---------------------------------------------
--v1.3.0
--highlight:CT_Highlight
--create structure
function highlight(
  p_tag varchar2 default ploffx_document_tag.t_highlight,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_Highlight;
---------------------------------------------
--v1.3.0
--position:CT_SignedHpsMeasure
--create structure
function position(
  p_tag varchar2 default ploffx_document_tag.t_position,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_SignedHpsMeasure;
---------------------------------------------
--v1.3.0
--shd:CT_Shd
--create structure
function shd(
  p_tag varchar2 default ploffx_document_tag.t_shd,
  p_val varchar2,
  p_color varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null,
  p_fill varchar2 default null,
  p_themeFill varchar2 default null,
  p_themeFillTint varchar2 default null,
  p_themeFillShade varchar2 default null
  ) return ploffx_document_type.CT_Shd;
---------------------------------------------
--v1.3.0
--vertAlign:CT_VerticalAlignRun
--create structure
function vertAlign(
  p_tag varchar2 default ploffx_document_tag.t_vertAlign,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_VerticalAlignRun;
---------------------------------------------
--v1.3.0
--w:CT_TextScale
--create structure
function w(
  p_tag varchar2 default ploffx_document_tag.t_w,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TextScale;
---------------------------------------------
--v1.3.0
--bCs:CT_OnOff
--create structure
function bCs(
  p_tag varchar2 default ploffx_document_tag.t_bCs,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--bdr:CT_Border
--create structure
function bdr(
  p_tag varchar2 default ploffx_document_tag.t_bdr,
  p_val varchar2 default null,
  p_color varchar2 default null, --ST_HexColor
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null, --ST_UcharHexNumber
  p_themeShade varchar2 default null, --ST_UcharHexNumber
  p_sz varchar2 default null, --ST_EighthPointMeasure
  p_space varchar2 default null, --ST_PointMeasure
  p_shadow varchar2 default null, --ST_OnOff
  p_frame varchar2 default null --ST_OnOff
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--v1.3.0
--caps:CT_OnOff
--create structure
function caps(
  p_tag varchar2 default ploffx_document_tag.t_caps,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--cs:CT_OnOff
--create structure
function cs(
  p_tag varchar2 default ploffx_document_tag.t_cs,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--dstrike:CT_OnOff
--create structure
function dstrike(
  p_tag varchar2 default ploffx_document_tag.t_dstrike,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--emboss:CT_OnOff
--create structure
function emboss(
  p_tag varchar2 default ploffx_document_tag.t_emboss,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--iCs:CT_OnOff
--create structure
function iCs(
  p_tag varchar2 default ploffx_document_tag.t_iCs,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--imprint:CT_OnOff
--create structure
function imprint(
  p_tag varchar2 default ploffx_document_tag.t_imprint,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--kern:CT_HpsMeasure
--create structure
function kern(
  p_tag varchar2 default ploffx_document_tag.t_kern,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_HpsMeasure;
---------------------------------------------
--v1.3.0
--oMath:CT_OnOff
--create structure
function oMath(
  p_tag varchar2 default ploffx_document_tag.t_oMath,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--outline:CT_OnOff
--create structure
function outline(
  p_tag varchar2 default ploffx_document_tag.t_outline,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--rtl:CT_OnOff
--create structure
function rtl(
  p_tag varchar2 default ploffx_document_tag.t_rtl,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--shadow:CT_OnOff
--create structure
function shadow(
  p_tag varchar2 default ploffx_document_tag.t_shadow,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--smallCaps:CT_OnOff
--create structure
function smallCaps(
  p_tag varchar2 default ploffx_document_tag.t_smallCaps,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--snapToGrid:CT_OnOff
--create structure
function snapToGrid(
  p_tag varchar2 default ploffx_document_tag.t_snapToGrid,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--specVanish:CT_OnOff
--create structure
function specVanish(
  p_tag varchar2 default ploffx_document_tag.t_specVanish,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--strike:CT_OnOff
--create structure
function strike(
  p_tag varchar2 default ploffx_document_tag.t_strike,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--vanish:CT_OnOff
--create structure
function vanish(
  p_tag varchar2 default ploffx_document_tag.t_vanish,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--webHidden:CT_OnOff
--create structure
function webHidden(
  p_tag varchar2 default ploffx_document_tag.t_webHidden,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--rStyle:CT_String
--create structure
function rStyle(
  p_tag varchar2 default ploffx_document_tag.t_rStyle,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--v1.3.0
--spacing2:CT_SignedTwipsMeasure
--create structure
function spacing2(
  p_tag varchar2 default ploffx_document_tag.t_spacing,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_SignedTwipsMeasure;
---------------------------------------------
--rPr:CT_rPr
--create structure
function rPr(
  p_tag varchar2 default ploffx_document_tag.t_rPr,
  p_b ploffx_document_type.CT_OnOff default null,
  p_bCs ploffx_document_type.CT_OnOff default null,
  p_bdr ploffx_document_type.CT_Border default null,
  p_caps ploffx_document_type.CT_OnOff default null,
  p_color ploffx_document_type.CT_Color default null,
  p_cs ploffx_document_type.CT_OnOff default null,
  p_dstrike ploffx_document_type.CT_OnOff default null,
  p_eastAsianLayout ploffx_document_type.CT_EastAsianLayout default null,
  p_effect ploffx_document_type.CT_TextEffect default null,
  p_em ploffx_document_type.CT_Em default null,
  p_emboss ploffx_document_type.CT_OnOff default null,
  p_fitText ploffx_document_type.CT_FitText default null,
  p_highlight ploffx_document_type.CT_Highlight default null,
  p_i ploffx_document_type.CT_OnOff default null,
  p_iCs ploffx_document_type.CT_OnOff default null,
  p_imprint ploffx_document_type.CT_OnOff default null,
  p_kern ploffx_document_type.CT_HpsMeasure default null,
  p_lang ploffx_document_type.CT_Language default null,
  p_noProof ploffx_document_type.CT_OnOff default null,
  p_oMath ploffx_document_type.CT_OnOff default null,
  p_outline ploffx_document_type.CT_OnOff default null,
  p_position ploffx_document_type.CT_SignedHpsMeasure default null,
  p_rFonts ploffx_document_type.CT_Fonts default null,
  --rPrChange
  p_rStyle ploffx_document_type.CT_String default null,
  p_rtl ploffx_document_type.CT_OnOff default null,
  p_shadow ploffx_document_type.CT_OnOff default null,
  p_shd ploffx_document_type.CT_Shd default null,
  p_smallCaps ploffx_document_type.CT_OnOff default null,
  p_snapToGrid ploffx_document_type.CT_OnOff default null,
  p_spacing ploffx_document_type.CT_SignedTwipsMeasure default null,
  p_specVanish ploffx_document_type.CT_OnOff default null,
  p_strike ploffx_document_type.CT_OnOff default null,
  p_sz ploffx_document_type.CT_HpsMeasure default null,
  p_szCs ploffx_document_type.CT_HpsMeasure default null,
  p_u ploffx_document_type.CT_Underline default null,
  p_vanish ploffx_document_type.CT_OnOff default null,
  p_vertAlign ploffx_document_type.CT_VerticalAlignRun default null,
  p_w ploffx_document_type.CT_TextScale default null,
  p_webHidden ploffx_document_type.CT_OnOff default null
  ) return ploffx_document_type.CT_rPr;
---------------------------------------------
--lang:CT_Language
--create structure
function lang(
  p_tag varchar2 default ploffx_document_tag.t_lang,
  p_val ploffx_document_type.ST_Lang default null,
  p_eastAsia ploffx_document_type.ST_Lang default null,
  p_bidi ploffx_document_type.ST_Lang default null
  ) return ploffx_document_type.CT_Language;
---------------------------------------------
--v1.3.0
--noProof:CT_OnOff
--create structure
function noProof(
  p_tag varchar2 default ploffx_document_tag.t_noProof,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--b:ploffx_docx_styles.ploffx_document_type.CT_OnOff
--create structure
function b(
  p_tag varchar2 default ploffx_document_tag.t_b,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--color:CT_Color
--create structure
function color(
  p_tag varchar2 default ploffx_document_tag.t_color,
  p_val varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null
  ) return ploffx_document_type.CT_Color;
---------------------------------------------
--i: ploffx_docx_styles.ploffx_document_type.CT_OnOff
--create structure
function i(
  p_tag varchar2 default ploffx_document_tag.t_i,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--u CT_Underline
--create structure
function u(
  p_tag varchar2 default ploffx_document_tag.t_u,
  p_val varchar2 default null,
  p_color varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null
  ) return ploffx_document_type.CT_Underline;
---------------------------------------------
--sz:CT_HpsMeasure
--create structure
function sz(
  p_tag varchar2 default ploffx_document_tag.t_sz,
  p_val plx_sc.normalv2 default null-- ST_HpsMeasure
  ) return ploffx_document_type.CT_HpsMeasure;
---------------------------------------------
--szCs:CT_HpsMeasure
--create structure
function szCs(
  p_tag varchar2 default ploffx_document_tag.t_szCs,
  p_val plx_sc.normalv2 default null-- ST_HpsMeasure
  ) return ploffx_document_type.CT_HpsMeasure;
---------------------------------------------
--pStyle:CT_String
--create structure
function pStyle(
  p_tag varchar2 default ploffx_document_tag.t_pStyle,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--spacing:CT_Spacing
--create structure
function spacing(
  p_tag varchar2 default ploffx_document_tag.t_spacing,
  p_before plx_sc.normalv2  default null,
  p_beforeLines plx_sc.normalv2  default null,
  p_beforeAutospacing plx_sc.normalv2  default null,
  p_after plx_sc.normalv2  default null,
  p_afterLines plx_sc.normalv2  default null,
  p_afterAutospacing plx_sc.normalv2  default null,
  p_line plx_sc.normalv2  default null,
  p_lineRule ploffx_document_type.ST_LineSpacingRule  default null
  ) return ploffx_document_type.CT_Spacing;
---------------------------------------------
--jc CT_Jc
--create structure
function jc(
  p_tag varchar2 default ploffx_document_tag.t_jc,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_Jc;
---------------------------------------------
--ilvl CT_DecimalNumber
--create structure
function ilvl(
  p_tag varchar2 default ploffx_document_tag.t_ilvl,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--numId CT_DecimalNumber
--create structure
function numId(
  p_tag varchar2 default ploffx_document_tag.t_numId,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--numberingChange CT_TrackChangeNumbering
--create structure
function numberingChange(
  p_tag varchar2 default ploffx_document_tag.t_numberingChange,
  p_author varchar2 default null,
  p_date varchar2 default null,
  p_id varchar2 default null,
  p_original varchar2 default null
  ) return ploffx_document_type.CT_TrackChangeNumbering;
---------------------------------------------
--ins CT_TrackChange
--create structure
function ins(
  p_tag varchar2 default ploffx_document_tag.t_ins,
  p_author varchar2 default null,
  p_date varchar2 default null,
  p_id varchar2 default null
  ) return ploffx_document_type.CT_TrackChange;
---------------------------------------------
--numPr CT_NumPr
--create structure
function numPr(
  p_tag varchar2 default ploffx_document_tag.t_numPr,
  p_ilvl ploffx_document_type.CT_DecimalNumber default null,
  p_numId ploffx_document_type.CT_DecimalNumber default null,
  p_numberingChange ploffx_document_type.CT_TrackChangeNumbering default null,
  p_ins ploffx_document_type.CT_TrackChange default null
  ) return ploffx_document_type.CT_NumPr;
---------------------------------------------
--v1.3.0
--adjustRightInd:CT_OnOff
--create structure
function adjustRightInd(
  p_tag varchar2 default ploffx_document_tag.t_adjustRightInd,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--autoSpaceDE:CT_OnOff
--create structure
function autoSpaceDE(
  p_tag varchar2 default ploffx_document_tag.t_autoSpaceDE,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--autoSpaceDN:CT_OnOff
--create structure
function autoSpaceDN(
  p_tag varchar2 default ploffx_document_tag.t_autoSpaceDN,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--bidi:CT_OnOff
--create structure
function bidi(
  p_tag varchar2 default ploffx_document_tag.t_bidi,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v4.9.3
--cnfStyle:CT_Cnf
--create structure
function cnfStyle(
  p_tag varchar2 default ploffx_document_tag.t_cnfStyle,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_Cnf;
---------------------------------------------
--v1.3.0
--contextualSpacing:CT_OnOff
--create structure
function contextualSpacing(
  p_tag varchar2 default ploffx_document_tag.t_contextualSpacing,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--divId:CT_DecimalNumber
--create structure
function divId(
  p_tag varchar2 default ploffx_document_tag.t_divId,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--framePr:CT_DecimalNumber
--create structure
function framePr(
  p_tag varchar2 default ploffx_document_tag.t_framePr,
  p_dropCap varchar2 default null,
  p_lines varchar2 default null, --ST_DecimalNumber
  p_w varchar2 default null, --ST_TwipsMeasure
  p_h varchar2 default null, --ST_TwipsMeasure
  p_vSpace varchar2 default null, --ST_TwipsMeasure
  p_hSpace varchar2 default null, --ST_TwipsMeasure
  p_wrap varchar2 default null,
  p_hAnchor varchar2 default null,
  p_vAnchor varchar2 default null,
  p_x varchar2 default null, --ST_SignedTwipsMeasure
  p_xAlign varchar2 default null,
  p_y varchar2 default null, --ST_SignedTwipsMeasure
  p_yAlign varchar2 default null,
  p_hRule varchar2 default null,
  p_anchorLock varchar2 default null
  ) return ploffx_document_type.CT_FramePr;
---------------------------------------------
--v1.3.0
--keepLines:CT_OnOff
--create structure
function keepLines(
  p_tag varchar2 default ploffx_document_tag.t_keepLines,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--keepNext:CT_OnOff
--create structure
function keepNext(
  p_tag varchar2 default ploffx_document_tag.t_keepNext,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--kinsoku:CT_OnOff
--create structure
function kinsoku(
  p_tag varchar2 default ploffx_document_tag.t_kinsoku,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--mirrorIndents:CT_OnOff
--create structure
function mirrorIndents(
  p_tag varchar2 default ploffx_document_tag.t_mirrorIndents,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--outlineLvl:CT_DecimalNumber
--create structure
function outlineLvl(
  p_tag varchar2 default ploffx_document_tag.t_outlineLvl,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--overflowPunct:CT_OnOff
--create structure
function overflowPunct(
  p_tag varchar2 default ploffx_document_tag.t_overflowPunct,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--pBdr:CT_OnOff
--create structure
function pBdr(
  p_tag varchar2 default ploffx_document_tag.t_pBdr,
  p_top ploffx_document_type.CT_Border default null,
  p_left ploffx_document_type.CT_Border  default null,
  p_bottom ploffx_document_type.CT_Border default null,
  p_right ploffx_document_type.CT_Border  default null,
  p_between_ ploffx_document_type.CT_Border default null,
  p_bar ploffx_document_type.CT_Border default null
  ) return ploffx_document_type.CT_PBdr;
---------------------------------------------
--v1.3.0
--suppressAutoHyphens:CT_OnOff
--create structure
function suppressAutoHyphens(
  p_tag varchar2 default ploffx_document_tag.t_suppressAutoHyphens,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--suppressLineNumbers:CT_OnOff
--create structure
function suppressLineNumbers(
  p_tag varchar2 default ploffx_document_tag.t_suppressLineNumbers,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--suppressOverlap:CT_OnOff
--create structure
function suppressOverlap(
  p_tag varchar2 default ploffx_document_tag.t_suppressOverlap,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--tab:CT_TabStop
--create structure
function tab(
  p_tag varchar2 default ploffx_document_tag.t_tab,
  p_val varchar2 default null,
  p_leader varchar2 default null,
  p_pos varchar2 default null --ST_SignedTwipsMeasure
  ) return ploffx_document_type.CT_TabStop;
--tab:CT_Tabs
procedure add_tab(
  p_table in out ploffx_document_type.CT_Tabs,
  p_tab ploffx_document_type.CT_TabStop
  );
---------------------------------------------
--v1.3.0
--textAlignment:CT_TextAlignment
--create structure
function textAlignment(
  p_tag varchar2 default ploffx_document_tag.t_textAlignment,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TextAlignment;
---------------------------------------------
--v1.3.0
--textboxTightWrap:CT_TextboxTightWrap
--create structure
function textboxTightWrap(
  p_tag varchar2 default ploffx_document_tag.t_textboxTightWrap,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TextboxTightWrap;
---------------------------------------------
--v1.3.0
--textDirection:CT_TextDirection
--create structure
function textDirection(
  p_tag varchar2 default ploffx_document_tag.t_textDirection,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TextDirection;
---------------------------------------------
--v1.3.0
--topLinePunct:CT_OnOff
--create structure
function topLinePunct(
  p_tag varchar2 default ploffx_document_tag.t_topLinePunct,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--between:CT_Border
--create structure
function between_(
  p_tag varchar2 default ploffx_document_tag.t_between,
  p_val plx_sc.normalv2,
  p_color plx_sc.normalv2,
  p_themeColor ploffx_document_type.ST_ThemeColor,
  p_themeTint plx_sc.normalv2,
  p_themeShade plx_sc.normalv2,
  p_sz plx_sc.normalv2,
  p_space plx_sc.normalv2,
  p_shadow plx_sc.normalv2,
  p_frame plx_sc.normalv2
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--v1.3.0
--bar:CT_Border
--create structure
function bar(
  p_tag varchar2 default ploffx_document_tag.t_bar,
  p_val plx_sc.normalv2,
  p_color plx_sc.normalv2,
  p_themeColor ploffx_document_type.ST_ThemeColor,
  p_themeTint plx_sc.normalv2,
  p_themeShade plx_sc.normalv2,
  p_sz plx_sc.normalv2,
  p_space plx_sc.normalv2,
  p_shadow plx_sc.normalv2,
  p_frame plx_sc.normalv2
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--pPr:CT_pPr
--create structure
function pPr(
  p_tag varchar2 default ploffx_document_tag.t_pPr,
  p_adjustRightInd ploffx_document_type.CT_OnOff default null, --Automatically Adjust Right Indent When Using Document Grid
  p_autoSpaceDE ploffx_document_type.CT_OnOff default null, --Automatically Adjust Spacing of Latin and East Asian Text
  p_autoSpaceDN ploffx_document_type.CT_OnOff default null, --Automatically Adjust Spacing of East Asian Text and Numbers
  p_bidi ploffx_document_type.CT_OnOff default null, --Right to Left Paragraph Layout
  p_cnfStyle ploffx_document_type.CT_Cnf default null, --Paragraph Conditional Formatting
  p_contextualSpacing ploffx_document_type.CT_OnOff default null, --Ignore Spacing Above and Below When Using Identical Styles
  p_divId ploffx_document_type.CT_DecimalNumber default null, --Associated HTML div ID
  p_framePr ploffx_document_type.CT_FramePr default null, --Text Frame Properties
  p_ind ploffx_document_type.CT_Ind default null, --Paragraph Indentation
  p_jc ploffx_document_type.CT_Jc default null, --Paragraph Alignment
  p_keepLines ploffx_document_type.CT_OnOff default null, --Keep All Lines On One Page
  p_keepNext ploffx_document_type.CT_OnOff default null, --Keep Paragraph With Next Paragraph
  p_kinsoku ploffx_document_type.CT_OnOff default null, --Use East Asian Typography Rules for First and Last Character per Line
  p_mirrorIndents ploffx_document_type.CT_OnOff default null, --Use Left/Right Indents as Inside/Outside Indents
  p_numPr ploffx_document_type.CT_NumPr default null,--Numbering Definition Instance Reference
  p_outlineLvl ploffx_document_type.CT_DecimalNumber default null, --Associated Outline Level
  p_overflowPunct ploffx_document_type.CT_OnOff default null, --Allow Punctuation to Extent Past Text Extents
  p_pageBreakBefore ploffx_document_type.CT_OnOff default null, --Start Paragraph on Next Page
  p_pBdr ploffx_document_type.CT_PBdr default null, --Paragraph Borders
  -- pPrChange --Revision Information for Paragraph Properties
  p_pStyle ploffx_document_type.CT_String default null, --Referenced Paragraph Style
  p_rPr ploffx_document_type.CT_rPr default null, --v2.0.0 Run Properties for the Paragraph Mark
  p_sectPr ploffx_document_type.CT_SectPr default null, --Section Properties
  p_shd ploffx_document_type.CT_Shd default null, --Paragraph Shading
  p_snapToGrid ploffx_document_type.CT_OnOff default null, --Use Document Grid Settings for Inter-Line Paragraph Spacing
  p_spacing ploffx_document_type.CT_Spacing default null, --Spacing Between Lines and Above/Below Paragraph
  p_suppressAutoHyphens ploffx_document_type.CT_OnOff default null, --Suppress Hyphenation for Paragraph
  p_suppressLineNumbers ploffx_document_type.CT_OnOff default null, --Suppress Line Numbers for Paragraph
  p_suppressOverlap ploffx_document_type.CT_OnOff default null, --Prevent Text Frames From Overlapping
  p_tabs  ploffx_document_type.CT_Tabs default null, --Set of Custom Tab Stops
  p_textAlignment ploffx_document_type.CT_TextALignment default null, --Vertical Character Alignment on Line
  p_textboxTightWrap ploffx_document_type.CT_TextboxTightWrap default null, --Allow Surrounding Paragraphs to Tight Wrap to Text Box Contents
  p_textDirection  ploffx_document_type.CT_TextDirection default null, --Paragraph Text Flow Direction
  p_topLinePunct  ploffx_document_type.CT_OnOff default null, --Compress Punctuation at Start of a Line
  p_widowControl ploffx_document_type.CT_OnOff default null, --Allow First/Last Line to Display on a Separate Page
  p_wordWrap ploffx_document_type.CT_OnOff default null --Allow Line Breaking At Character Level
  ) return ploffx_document_type.CT_PPr;
----------------------------------------
--CT_Point2D
--create structure
function start_1(
  p_tag varchar2 default ploffx_document_tag.t_start,
  p_x varchar2,
  p_y varchar2
  ) return ploffx_document_type.CT_Point2D;
----------------------------------------
--start:CT_DecimalNumber
--create structure
function start_2(
  p_tag varchar2 default ploffx_document_tag.t_start,
  p_val varchar2
  ) return ploffx_document_type.CT_DecimalNumber;
----------------------------------------
--numFmt:CT_NumFmt
--create structure
function numFmt(
  p_tag varchar2 default ploffx_document_tag.t_numFmt,
  p_val ploffx_document_type.ST_NumberFormat
  ) return ploffx_document_type.CT_NumFmt;
----------------------------------------
--Ind:CT_Ind
--create structure
function Ind(
  p_tag varchar2 default ploffx_document_tag.t_Ind,
  p_left varchar2 default null,
  p_leftChars varchar2 default null,
  p_right varchar2 default null,
  p_rightChars varchar2 default null,
  p_hanging varchar2 default null,
  p_hangingChars varchar2 default null,
  p_firstLine varchar2 default null,
  p_firstLineChars varchar2 default null
  ) return ploffx_document_type.CT_Ind;
---------------------------------------------
--bottom:CT_Border
--create structure
function bottom(
  p_tag varchar2 default ploffx_document_tag.t_bottom,
  p_val plx_sc.normalv2 default null,
  p_color plx_sc.normalv2 default null,
  p_themeColor ploffx_document_type.ST_ThemeColor default null,
  p_themeTint plx_sc.normalv2 default null,
  p_themeShade plx_sc.normalv2 default null,
  p_sz plx_sc.normalv2 default null,
  p_space plx_sc.normalv2 default null,
  p_shadow plx_sc.normalv2 default null,
  p_frame plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--bottom:CT_tblWidth
--create structure
function bottom_w(
  p_tag varchar2 default ploffx_document_tag.t_bottom,
  p_w plx_sc.normalv2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_tblWidth;
---------------------------------------------
--insideH:CT_Border
--create structure
function insideH(
  p_tag varchar2 default ploffx_document_tag.t_insideH,
  p_val plx_sc.normalv2,
  p_color plx_sc.normalv2,
  p_themeColor ploffx_document_type.ST_ThemeColor,
  p_themeTint plx_sc.normalv2,
  p_themeShade plx_sc.normalv2,
  p_sz plx_sc.normalv2,
  p_space plx_sc.normalv2,
  p_shadow plx_sc.normalv2,
  p_frame plx_sc.normalv2
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--insideV:CT_Border
--create structure
function insideV(
  p_tag varchar2 default ploffx_document_tag.t_insideV,
  p_val plx_sc.normalv2,
  p_color plx_sc.normalv2,
  p_themeColor ploffx_document_type.ST_ThemeColor,
  p_themeTint plx_sc.normalv2,
  p_themeShade plx_sc.normalv2,
  p_sz plx_sc.normalv2,
  p_space plx_sc.normalv2,
  p_shadow plx_sc.normalv2,
  p_frame plx_sc.normalv2
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--left:CT_Border
--create structure
function left(
  p_tag varchar2 default ploffx_document_tag.t_left,
  p_val plx_sc.normalv2 default null,
  p_color plx_sc.normalv2 default null,
  p_themeColor ploffx_document_type.ST_ThemeColor default null,
  p_themeTint plx_sc.normalv2 default null,
  p_themeShade plx_sc.normalv2 default null,
  p_sz plx_sc.normalv2 default null,
  p_space plx_sc.normalv2 default null,
  p_shadow plx_sc.normalv2 default null,
  p_frame plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--left:CT_tblWidth
--create structure
function left_w(
  p_tag varchar2 default ploffx_document_tag.t_left,
  p_w plx_sc.normalv2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_tblWidth;
---------------------------------------------
--right:CT_Border
--create structure
function right(
  p_tag varchar2 default ploffx_document_tag.t_right,
  p_val plx_sc.normalv2 default null,
  p_color plx_sc.normalv2 default null,
  p_themeColor ploffx_document_type.ST_ThemeColor default null,
  p_themeTint plx_sc.normalv2 default null,
  p_themeShade plx_sc.normalv2 default null,
  p_sz plx_sc.normalv2 default null,
  p_space plx_sc.normalv2 default null,
  p_shadow plx_sc.normalv2 default null,
  p_frame plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--rigth:CT_tblWidth
--create structure
function right_w(
  p_tag varchar2 default ploffx_document_tag.t_right,
  p_w plx_sc.normalv2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_tblWidth;
---------------------------------------------
--top:CT_Border
--create structure
function top(
  p_tag varchar2 default ploffx_document_tag.t_top,
  p_val plx_sc.normalv2 default null,
  p_color plx_sc.normalv2 default null,
  p_themeColor ploffx_document_type.ST_ThemeColor default null,
  p_themeTint plx_sc.normalv2 default null,
  p_themeShade plx_sc.normalv2 default null,
  p_sz plx_sc.normalv2 default null,
  p_space plx_sc.normalv2 default null,
  p_shadow plx_sc.normalv2 default null,
  p_frame plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--top:CT_tblWidth
--create structure
function top_w(
  p_tag varchar2 default ploffx_document_tag.t_top,
  p_w plx_sc.normalv2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_tblWidth;
---------------------------------------------
--tblCellMar:CT_tblCellMar
--create structure
function tblCellMar(
  p_tag varchar2 default ploffx_document_tag.t_tblCellMar,
  p_top ploffx_document_type.CT_TblWidth,
  p_bottom ploffx_document_type.CT_TblWidth,
  p_left ploffx_document_type.CT_TblWidth,
  p_right ploffx_document_type.CT_TblWidth
  ) return ploffx_document_type.CT_tblCellMar;
---------------------------------------------
--tblInd:CT_TblWidth
--create structure
function tblInd(
  p_tag varchar2 default ploffx_document_tag.t_tblInd,
  p_w plx_sc.normalv2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_TblWidth;
---------------------------------------------
--tblBorders:CT_tblBorders
--create structure
function TblBorders(
  p_tag varchar2 default ploffx_document_tag.t_TblBorders,
  p_top ploffx_document_type.CT_Border,
  p_left ploffx_document_type.CT_Border,
  p_bottom ploffx_document_type.CT_Border,
  p_right ploffx_document_type.CT_Border,
  p_insideH ploffx_document_type.CT_Border,
  p_insideV ploffx_document_type.CT_Border
  ) return ploffx_document_type.CT_TblBorders;
-------------------------------------------
--v1.3.0
--create structure
function extent(
  p_tag varchar2 default ploffx_document_tag.t_extent,
  p_cx varchar2 default null,
  p_cy varchar2 default null
  ) return ploffx_document_type.CT_PositiveSize2D;
---------------------------------------------
--v1.3.0
--create structure
function effectExtent(
  p_tag varchar2 default ploffx_document_tag.t_effectExtent,
  p_l varchar2 default null,
  p_t varchar2 default null,
  p_r varchar2 default null,
  p_b varchar2 default null
  ) return ploffx_document_type.CT_EffectExtent;
---------------------------------------------
--v1.3.0
--create structure
function docPr(
  p_tag varchar2 default ploffx_document_tag.t_docPr,
  p_hlinkClick ploffx_document_type.CT_Hyperlink default null,
  p_hlinkHover ploffx_document_type.CT_Hyperlink default null,
  p_extLst ploffx_document_type.CT_OfficeArtExtensionList default null,
  p_id varchar2 default null,
  p_name varchar2 default null,
  p_descr varchar2 default null,
  p_hidden varchar2 default null,
  p_title varchar2 default null
  ) return ploffx_document_type.CT_NonVisualDrawingProps;
---------------------------------------------
--v1.3.0
--create structure
function inline(
  p_tag varchar2 default ploffx_document_tag.t_inline,
  p_extent ploffx_document_type.CT_PositiveSize2D default null,
  p_effectExtent ploffx_document_type.CT_EffectExtent default null,
  p_docPr ploffx_document_type.CT_NonVisualDrawingProps default null,
  p_cNvGraphicFramePr ploffx_document_type.CT_NonVisualGraphicFrameProps default null, --CT_NonVisualGraphicFrameProperties
  p_graphic ploffx_document_type.CT_GraphicalObject default null,
  p_distT varchar2 default null,
  p_distB varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null
  ) return ploffx_document_type.CT_Inline;
---------------------------------------------
--v1.3.0
--create structure
function anchor(
  p_tag varchar2 default ploffx_document_tag.t_anchor,
  p_simplePos ploffx_document_type.CT_Point2D,
  p_positionH ploffx_document_type.CT_PosH,
  p_positionV ploffx_document_type.CT_PosV,
  p_extent ploffx_document_type.CT_PositiveSize2D,
  p_effectExtent ploffx_document_type.CT_EffectExtent,
  p_wrapNone ploffx_document_type.CT_WrapNone,
  p_wrapSquare ploffx_document_type.CT_WrapSquare,
  p_wrapTight ploffx_document_type.CT_WrapTight,
  p_wrapThrough ploffx_document_type.CT_WrapThrough,
  p_wrapTopAndBottom ploffx_document_type.CT_WrapTopBottom,
  p_docPr ploffx_document_type.CT_NonVisualDrawingProps,
  p_cNvGraphicFramePr ploffx_document_type.CT_NonVisualGraphicFrameProps, --CT_NonVisualGraphicFrameProperties
  p_graphic ploffx_document_type.CT_GraphicalObject,
  p_distT varchar2 default null,
  p_distB varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null,
  p_simplePos_ varchar2 default null,
  p_relativeHeight varchar2 default null,
  p_behindDoc varchar2 default null,
  p_locked varchar2 default null,
  p_layoutInCell varchar2 default null,
  p_hidden varchar2 default null,
  p_allowOverlap varchar2 default null
  ) return ploffx_document_type.CT_Anchor;
---------------------------------------------
--v1.3.0
--create structure
function simplePos(
  p_tag varchar2 default ploffx_document_tag.t_simplePos,
  p_x varchar2 default null,
  p_y varchar2 default null
  ) return ploffx_document_type.CT_Point2D;
---------------------------------------------
--v1.3.0
--create structure
function cNvGraphicFramePr(
  p_tag varchar2 default ploffx_document_tag.t_cNvGraphicFramePr,
  p_graphicFrameLocks ploffx_document_type.CT_GraphicalObjectFrameLocking default null,
  p_extLst ploffx_document_type.CT_OfficeArtExtensionList default null
  ) return ploffx_document_type.CT_NonVisualGraphicFrameProps;
---------------------------------------------
--v1.3.0
--create structure
function graphicFrameLocks(
  p_tag varchar2 default ploffx_document_tag.t_graphicFrameLocks,
  p_extLst ploffx_document_type.CT_OfficeArtExtensionList default null,
  p_noGrp varchar2 default null,
  p_noDrilldown varchar2 default null,
  p_noSelect varchar2 default null,
  p_noChangeAspect varchar2 default null,
  p_noMove varchar2 default null,
  p_noResize varchar2 default null
  ) return ploffx_document_type.CT_GraphicalObjectFrameLocking;
---------------------------------------------
--drawing CT_Drawing
--create structure
function drawing(
  p_tag varchar2 default ploffx_document_tag.t_drawing,
  p_drawing_type varchar2 default null,
  p_anchor ploffx_document_type.CT_Anchor default null,
  p_inline ploffx_document_type.CT_Inline default null
  ) return ploffx_document_type.CT_Drawing;
---------------------------------------------
--v5.8
function pict(
  p_tag varchar2 default ploffx_document_tag.t_pict,
  p_shapetype ploffx_vmldrawing.CT_Shapetype default null,
  p_shape ploffx_vmldrawing.CT_shape default null
  ) return ploffx_document_type.CT_Picture;
---------------------------------------------
--br CT_Br
--create structure
function br(
  p_tag varchar2 default ploffx_document_tag.t_br,
  p_type varchar2 default null,
  p_clear varchar2 default null
  ) return ploffx_document_type.CT_Br;
---------------------------------------------
--t CT_Text
--create structure
function t(
  p_tag varchar2 default ploffx_document_tag.t_t,
  p_xml_space varchar2 default null,
  p_text varchar2 default null
  ) return ploffx_document_type.CT_Text;
---------------------------------------------
function tabchar(
  p_tag varchar2 default ploffx_document_tag.t_tab
  ) return ploffx_document_type.CT_Empty;
---------------------------------------------
--v3.0.6
--create structure
function add_rinnercontents_br(
  p_rinnercontents in out ploffx_document_type.t_rinnercontents,
  p_br ploffx_document_type.CT_Br
  ) return pls_integer;
---------------------------------------------
--v5.0
function add_rinnercontents_tab(
  p_rinnercontents in out ploffx_document_type.t_rinnercontents,
  p_tab ploffx_document_type.CT_Empty
  ) return pls_integer;
---------------------------------------------
--v1.3.0
--create structure
function add_rinnercontents_t(
  p_rinnercontents in out ploffx_document_type.t_rinnercontents,
  p_t ploffx_document_type.CT_Text
  ) return pls_integer;
---------------------------------------------
--v4.8.2
function add_rinnercontents_instrText(
  p_rinnercontents in out ploffx_document_type.t_rinnercontents,
  p_instrText ploffx_document_type.CT_Text
  ) return pls_integer;
---------------------------------------------
--v1.3.0
--create structure
function add_rinnercontents_drawing(
  p_rinnercontents in out ploffx_document_type.t_rinnercontents,
  p_drawing ploffx_document_type.CT_Drawing
  ) return pls_integer;
---------------------------------------------
--v4.8.2
function add_rinnercontents_fldchar(
  p_rinnercontents in out ploffx_document_type.t_rinnercontents,
  p_fldchar ploffx_document_type.CT_FldChar
  ) return pls_integer;
---------------------------------------------
--create text part
function rinnercontent_t(
  p_t ploffx_document_type.CT_Text
  ) return ploffx_document_type.t_rinnercontent;
---------------------------------------------
--v4.5.0
function rinnercontent_br(
  p_br ploffx_document_type.CT_Br
  ) return ploffx_document_type.t_rinnercontent;
---------------------------------------------
--v5.0
function rinnercontent_tab(
  p_tab ploffx_document_type.CT_Empty
  ) return ploffx_document_type.t_rinnercontent;
---------------------------------------------
--v1.3.0
function rinnercontent_drawing(
  p_drawing ploffx_document_type.CT_Drawing
  ) return ploffx_document_type.t_rinnercontent;
---------------------------------------------
--v5.8
function rinnercontent_pict(
  p_pict ploffx_document_type.CT_Picture
  ) return ploffx_document_type.t_rinnercontent;
---------------------------------------------
--r CT_R
--create structure
function r(
  p_tag varchar2 default ploffx_document_tag.t_R,
  p_rPr ploffx_document_type.CT_RPr default null,--Run Properties
  p_rinnercontents ploffx_document_type.t_rinnercontents default null,
  p_rsidRPr varchar2 default null, --ST_LongHexNumber
  p_rsidDel varchar2 default null, --ST_LongHexNumber
  p_rsidR varchar2 default null --ST_LongHexNumber
  ) return ploffx_document_type.CT_R;
---------------------------------------------
--t_pcontents
function add_pcontents_R(
  p_pcontents in out ploffx_document_type.t_pcontents,
  p_pcontent_items in out ploffx_document_type.t_pcontent_items, --v1.3.0
  p_r ploffx_document_type.CT_R default null
  ) return pls_integer;
---------------------------------------------
--pageBreakBefore CT_OnOff
--create structure
function pageBreakBefore(
  p_tag varchar2 default ploffx_document_tag.t_pageBreakBefore,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--widowControl CT_OnOff
--create structure
function widowControl(
  p_tag varchar2 default ploffx_document_tag.t_widowControl,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--wordWrap CT_OnOff
--create structure
function wordWrap(
  p_tag varchar2 default ploffx_document_tag.t_wordWrap,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
-- p CT_P
--create structure
function p(
  p_tag varchar2 default ploffx_document_tag.t_p,
  p_pPr ploffx_document_type.CT_PPr default null, --Paragraph Properties
  p_pcontent ploffx_document_type.t_pcontents default null,
  p_rsidRPr varchar2 default null,
  p_rsidR varchar2 default null,
  p_rsidDel varchar2 default null,
  p_rsidP varchar2 default null,
  p_rsidRDefault varchar2 default null
  ) return ploffx_document_type.CT_P;
--
--block
function add_blocks_p(
  p_blocks in out ploffx_document_type.t_blocks,
  p_items in out ploffx_document_type.t_block_items,
  p_p ploffx_document_type.CT_P
  ) return pls_integer;
--
function add_blocks_p(
  p_blocks in out ploffx_document_type.t_blocks,
  p_item_id pls_integer
  ) return pls_integer;
--
function add_blocks_tbl(
  p_blocks in out ploffx_document_type.t_blocks,
  p_items in out ploffx_document_type.t_block_items,
  p_tbl ploffx_document_type.CT_Tbl
  ) return pls_integer;
--
function add_blocks_tbl(
  p_blocks in out ploffx_document_type.t_blocks,
  p_item_id pls_integer
  ) return pls_integer;
--v1.3.0
function add_blocks_customXml(
  p_blocks in out ploffx_document_type.t_blocks,
  p_items in out ploffx_document_type.t_block_items,
  p_customXml ploffx_document_type.CT_CustomXmlBlock
  ) return pls_integer;
--v1.3.0
function add_blocks_customXml(
  p_blocks in out ploffx_document_type.t_blocks,
  p_item_id pls_integer
  ) return pls_integer;
----------------------------------------------
--pgSz CT_PageSz
--create structure
function pgSz(
  p_tag varchar2 default ploffx_document_tag.t_pgSz,
  p_w varchar2 default null,
  p_h varchar2 default null,
  p_orient varchar2 default null,
  p_code varchar2 default null
  ) return ploffx_document_type.CT_PageSz;
----------------------------------------------
--headerReference CT_HdrFtrRef
--create structure
function headerReference(
  p_tag varchar2 default ploffx_document_tag.t_headerReference,
  p_id varchar2 default null,
  p_type varchar2 default null
  ) return ploffx_document_type.CT_HdrFtrRef;
----------------------------------------------
--footerReference CT_HdrFtrRef
--create structure
function footerReference(
  p_tag varchar2 default ploffx_document_tag.t_footerReference,
  p_id varchar2 default null,
  p_type varchar2 default null
  ) return ploffx_document_type.CT_HdrFtrRef;
-- addHdrFtrReference
procedure add_HdrFtrReference(
  p_table in out ploffx_document_type.t_HdrFtrRef_,
  p_reference ploffx_document_type.CT_HdrFtrRef
  );
---------------------------------------------
--v1.3.0
--numStart CT_DecimalNumber
--create structure
function numStart(
  p_tag varchar2 default ploffx_document_tag.t_numStart,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--numRestart CT_NumRestart
--create structure
function numRestart(
  p_tag varchar2 default ploffx_document_tag.t_numRestart,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_NumRestart;
---------------------------------------------
--v1.3.0
--pos CT_EdnPos
--create structure
function pos(
  p_tag varchar2 default ploffx_document_tag.t_pos,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_EdnPos;
---------------------------------------------
--v1.3.0
--pos CT_FtnPos
--create structure
function pos_1(
  p_tag varchar2 default ploffx_document_tag.t_pos,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_FtnPos;
---------------------------------------------
--v1.3.0
--col:CT_Column
--create structure
function col(
  p_tag varchar2 default ploffx_document_tag.t_col,
  p_w varchar2 default null,
  p_space varchar2 default null
  ) return ploffx_document_type.CT_Column;
--
procedure add_col(
  p_table in out ploffx_document_type.t_col_,
  p_col ploffx_document_type.CT_Column
  );
---------------------------------------------
--v1.3.0
--cols:CT_Columns
--create structure
function cols(
  p_tag varchar2 default ploffx_document_tag.t_cols,
  p_equalWidth plx_sc.normalv2 default null,
  p_num plx_sc.normalv2 default null,
  p_sep plx_sc.normalv2 default null,
  p_space plx_sc.normalv2 default null,
  p_col ploffx_document_type.t_col_
  ) return ploffx_document_type.CT_Columns;
---------------------------------------------
--v1.3.0
--docGrid:CT_DocGrid
--create structure
function docGrid(
  p_tag varchar2 default ploffx_document_tag.t_docGrid,
  p_charSpace plx_sc.normalv2 default null,
  p_linePitch plx_sc.normalv2 default null,
  p_type_ ploffx_document_type.ST_DocGrid default null
  ) return ploffx_document_type.CT_DocGrid;
---------------------------------------------
--v1.3.0
--endnotePr:CT_EdnProps
--create structure
function endnotePr(
  p_tag varchar2 default ploffx_document_tag.t_endnotePr,
  p_numFmt ploffx_document_type.CT_NumFmt default null,
  p_numRestart ploffx_document_type.CT_NumRestart default null,
  p_numStart ploffx_document_type.CT_DecimalNumber default null,
  p_pos ploffx_document_type.CT_EdnPos default null
  ) return ploffx_document_type.CT_EdnProps;
---------------------------------------------
--v1.3.0
--footnotePr:CT_FtnProps
--create structure
function footnotePr(
  p_tag varchar2 default ploffx_document_tag.t_footnotePr,
  p_numFmt ploffx_document_type.CT_NumFmt default null,
  p_numRestart ploffx_document_type.CT_NumRestart default null,
  p_numStart ploffx_document_type.CT_DecimalNumber default null,
  p_pos ploffx_document_type.CT_FtnPos default null
  ) return ploffx_document_type.CT_FtnProps;
---------------------------------------------
--v1.3.0
--formProt:CT_OnOff
--create structure
function formProt(
  p_tag varchar2 default ploffx_document_tag.t_formProt,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--lnNumType:CT_LineNumber
--create structure
function lnNumType(
  p_tag varchar2 default ploffx_document_tag.t_lnNumType,
  p_countBy varchar2 default null,
  p_distance varchar2 default null,
  p_restart varchar2 default null,
  p_start_ varchar2 default null
  ) return ploffx_document_type.CT_LineNumber;
---------------------------------------------
--v1.3.0
--noEndnote:CT_OnOff
--create structure
function noEndnote(
  p_tag varchar2 default ploffx_document_tag.t_noEndnote,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--paperSrc:CT_PaperSource
--create structure
function paperSrc(
  p_tag varchar2 default ploffx_document_tag.t_paperSrc,
  p_first_ varchar2 default null,
  p_other varchar2 default null
  ) return ploffx_document_type.CT_PaperSource;
---------------------------------------------
--v1.3.0
--pgBorders:CT_PageBorders
--create structure
function pgBorders(
  p_tag varchar2 default ploffx_document_tag.t_pgBorders,
  p_display ploffx_document_type.ST_PageBorderDisplay default null,
  p_offsetFrom ploffx_document_type.ST_PageBorderOffset default null,
  p_zOrder ploffx_document_type.ST_PageBorderZOrder default null,
  p_top ploffx_document_type.CT_Border default null,
  p_left ploffx_document_type.CT_Border default null,
  p_right ploffx_document_type.CT_Border default null,
  p_bottom ploffx_document_type.CT_Border default null
  ) return ploffx_document_type.CT_PageBorders;
---------------------------------------------
--v1.3.0
--pgMar:CT_PageMar
--create structure
function pgMar(
  p_tag varchar2 default ploffx_document_tag.t_pgMar,
  p_bottom varchar2 default null,
  p_footer varchar2 default null,
  p_gutter varchar2 default null,
  p_header varchar2 default null,
  p_left varchar2 default null,
  p_right varchar2 default null,
  p_top varchar2 default null
  ) return ploffx_document_type.CT_PageMar;
---------------------------------------------
--v1.3.0
--pgNumType:CT_PageNumber
--create structure
function pgNumType(
  p_tag varchar2 default ploffx_document_tag.t_pgNumType,
  p_chapSep varchar2 default null,
  p_chapStyle varchar2 default null,
  p_fmt varchar2 default null,
  p_start_p varchar2 default null
  ) return ploffx_document_type.CT_PageNumber;
---------------------------------------------
--v1.3.0
--printerSettings:CT_Rel
--create structure
function printerSettings(
  p_tag varchar2 default ploffx_document_tag.t_printerSettings,
  p_id varchar2 default null
  ) return ploffx_document_type.CT_Rel;
---------------------------------------------
--v1.3.0
--rtlGutter:CT_OnOff
--create structure
function rtlGutter(
  p_tag varchar2 default ploffx_document_tag.t_rtlGutter,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--sectPrChange:CT_SectPrChange
--create structure
function sectPrChange(
  p_tag varchar2 default ploffx_document_tag.t_sectPrChange,
  p_author varchar2 default null,
  p_date_ varchar2 default null,
  p_id varchar2 default null
  -- sectPr
  ) return ploffx_document_type.CT_SectPrChange;
---------------------------------------------
--v1.3.0
--titlePg:CT_OnOff
--create structure
function titlePg(
  p_tag varchar2 default ploffx_document_tag.t_titlePg,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--type_:CT_SectType
--create structure
function type(
  p_tag varchar2 default ploffx_document_tag.t_type,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_SectType;
---------------------------------------------
--sectPr CT_SectPr
--create structure
function sectPr(
  p_tag varchar2 default ploffx_document_tag.t_sectPr,
  p_rsidDel varchar2 default null,
  p_rsidR varchar2 default null,
  p_rsidRPr varchar2 default null,
  p_rsidSect varchar2 default null,
  p_bidi ploffx_document_type.CT_OnOff default null, --Right to Left Section Layou
  p_cols ploffx_document_type.CT_Columns default null, --Column Definitions
  p_docGrid ploffx_document_type.CT_DocGrid default null, --Document Grid
  p_endnotePr ploffx_document_type.CT_EdnProps default null, --Section-Wide Endnote Properties
  p_footerReference_default ploffx_document_type.CT_HdrFtrRef default null, --Footer Reference
  p_footerReference_even ploffx_document_type.CT_HdrFtrRef default null,
  p_footerReference_first ploffx_document_type.CT_HdrFtrRef default null,
  p_footnotePr ploffx_document_type.CT_FtnProps default null, --Section-Wide Footnote Properties
  p_formProt ploffx_document_type.CT_OnOff default null, --Only Allow Editing of Form Fields
  p_headerReference_default ploffx_document_type.CT_HdrFtrRef default null, --Header Reference
  p_headerReference_even ploffx_document_type.CT_HdrFtrRef default null,
  p_headerReference_first ploffx_document_type.CT_HdrFtrRef default null,
  p_lnNumType ploffx_document_type.CT_LineNumber default null, --Line Numbering Settings
  p_noEndnote ploffx_document_type.CT_OnOff default null, --Suppress Endnotes In Document
  p_paperSrc ploffx_document_type.CT_PaperSource default null, --Paper Source Information
  p_pgBorders ploffx_document_type.CT_PageBorders default null, --Page Borders
  p_pgMar ploffx_document_type.CT_PageMar default null, --Page Margins
  p_pgNumType ploffx_document_type.CT_PageNumber default null, --Page Numbering Settings
  p_pgSz ploffx_document_type.CT_PageSz default null, --Page Size
  p_printerSettings ploffx_document_type.CT_Rel default null, --Reference to Printer Settings Data
  p_rtlGutter ploffx_document_type.CT_OnOff default null, --Gutter on Right Side of Page
  p_sectPrChange ploffx_document_type.CT_SectPrChange default null, --Revision Information for Section Properties
  p_textDirection ploffx_document_type.CT_TextDirection default null, --Text Flow Direction
  p_titlePg ploffx_document_type.CT_OnOff default null,--Different First Page Headers and Footers
  p_type_ ploffx_document_type.CT_SectType default null, --Section Type
  p_vAlign ploffx_document_type.CT_VerticalJc default null --Vertical Text Alignment on Page
  ) return ploffx_document_type.CT_SectPr;
---------------------------------------------
--body CT_Body
--create structure
function body(
  p_tag varchar2 default ploffx_document_tag.t_body,
  p_blocks ploffx_document_type.t_blocks default null, --EG_BlockLevelElts
  p_sectPr ploffx_document_type.CT_SectPr default null
  ) return ploffx_document_type.CT_Body;
---------------------------------------------
--background CT_Background
--create structure
function background(
  p_tag varchar2 default ploffx_document_tag.t_background,
  p_color varchar2 default null, -- ST_HexColor
  p_themeColor varchar2 default null, --ST_ThemeColor,
  p_themeShade varchar2 default null, -- ST_UcharHexNumber,
  p_themeTint varchar2 default null
  ) return ploffx_document_type.CT_Background;
---------------------------------------------
--document CT_Document
--create structure
function Document(
  p_tag varchar2 default ploffx_document_tag.t_Document,
  p_background ploffx_document_type.CT_Background default null,
  p_body ploffx_document_type.CT_Body default null
  ) return ploffx_document_type.CT_Document;
---------------------------------------------
--tblOverlap CT_TblOverlap
--create structure
function TblOverlap(
  p_tag varchar2 default ploffx_document_tag.t_TblOverlap,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TblOverlap;
---------------------------------------------
--v1.3.0
--tblpPr:CT_TblPPr
--create structure
function tblpPr(
  p_tag varchar2 default ploffx_document_tag.t_tblpPr,
  p_leftFromText varchar2 default null, --ST_TwipsMeasure
  p_rightFromText varchar2 default null, --ST_TwipsMeasure
  p_topFromText varchar2 default null, --ST_TwipsMeasure
  p_bottomFromText varchar2 default null, --ST_TwipsMeasure
  p_vertAnchor varchar2 default null,
  p_horzAnchor varchar2 default null,
  p_tblpXSpec varchar2 default null,
  p_tblpX varchar2 default null, --ST_SignedTwipsMeasure
  p_tblpYSpec varchar2 default null,
  p_tblpY varchar2 default null --ST_SignedTwipsMeasure
  ) return ploffx_document_type.CT_TblPPr;
---------------------------------------------
--v1.3.0
--bidiVisual:CT_OnOff
--create structure
function bidiVisual(
  p_tag varchar2 default ploffx_document_tag.t_bidiVisual,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--tblStyleRowBandSize:CT_DecimalNumber
--create structure
function tblStyleRowBandSize(
  p_tag varchar2 default ploffx_document_tag.t_tblStyleRowBandSize,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--tblStyleColBandSize:CT_DecimalNumber
--create structure
function tblStyleColBandSize(
  p_tag varchar2 default ploffx_document_tag.t_tblStyleColBandSize,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--tblCellSpacing:CT_TblWidth
--create structure
function tblCellSpacing(
  p_tag varchar2 default ploffx_document_tag.t_tblCellSpacing,
  p_w varchar2 default null,
  p_type varchar2 default null
  ) return ploffx_document_type.CT_TblWidth;
---------------------------------------------
--v1.3.0
--tblLayout:CT_TblLayoutType
--create structure
function tblLayout(
  p_tag varchar2 default ploffx_document_tag.t_tblLayout,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TblLayoutType;
---------------------------------------------
--v1.3.0
--tblLook:CT_TblLook
--create structure
function tblLook(
  p_tag varchar2 default ploffx_document_tag.t_tblLook,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_TblLook;
---------------------------------------------
--v1.3.0
--tblCaption:CT_String
--create structure
function tblCaption(
  p_tag varchar2 default ploffx_document_tag.t_tblCaption,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--v1.3.0
--tblDescription:CT_String
--create structure
function tblDescription(
  p_tag varchar2 default ploffx_document_tag.t_tblDescription,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--tblPr:CT_tblPrBase
--create structure
function TblPr(
  p_tag varchar2 default ploffx_document_tag.t_TblPr,
  p_tblStyle ploffx_document_type.CT_String default null,
  p_tblpPr ploffx_document_type.CT_TblPPr default null,
  p_tblOverlap ploffx_document_type.CT_TblOverlap default null,
  p_bidiVisual ploffx_document_type.CT_OnOff default null,
  p_tblStyleRowBandSize ploffx_document_type.CT_DecimalNumber default null,
  p_tblStyleColBandSize ploffx_document_type.CT_DecimalNumber default null,
  p_tblW ploffx_document_type.CT_TblWidth default null,
  p_jc ploffx_document_type.CT_JcTable default null,
  p_tblCellSpacing ploffx_document_type.CT_TblWidth default null,
  p_tblInd ploffx_document_type.CT_TblWidth default null,
  p_tblBorders ploffx_document_type.CT_TblBorders default null,
  p_shd ploffx_document_type.CT_Shd default null,
  p_tblLayout ploffx_document_type.CT_TblLayoutType default null,
  p_tblCellMar ploffx_document_type.CT_TblCellMar default null,
  p_tblLook ploffx_document_type.CT_TblLook default null,
  p_tblCaption ploffx_document_type.CT_String default null,
  p_tblDescription ploffx_document_type.CT_String default null
  -- p_tblPrChange ploffx_document_type.CT_TblPrChange default null
  ) return ploffx_document_type.CT_TblPr;
---------------------------------------------
--v1.3.0
--gridCol:CT_TblGridCol
--create structure
function gridCol(
  p_tag varchar2 default ploffx_document_tag.t_gridCol,
  p_w varchar2 default null
  ) return ploffx_document_type.CT_TblGridCol;
--gridCol:t_gridCols
procedure add_gridCol(
  p_table in out ploffx_document_type.t_gridCols,
  p_gridCol ploffx_document_type.CT_TblGridCol
  );
---------------------------------------------
--v1.3.0
--tblGrid:CT_TblGrid
--create structure
function tblGrid(
  p_tag varchar2 default ploffx_document_tag.t_tblGrid,
  p_gridCols ploffx_document_type.t_gridCols default null
  ) return ploffx_document_type.CT_TblGrid;
---------------------------------------------
--tbl:CT_Tbl
--create structure
function tbl(
  p_tag varchar2 default ploffx_document_tag.t_tbl,
  p_tblGrid ploffx_document_type.CT_TblGrid default null, -- (Table Grid)
  p_tblPr ploffx_document_type.CT_TblPr default null, -- (Table Properties)
  p_rowcontents ploffx_document_type.t_rowcontents  default null --EG_ContentRowContent
  -- EG_RangeMarkupElements
  ) return ploffx_document_type.CT_Tbl;
---------------------------------------------
--CT_TblWidth
function TblWidth(
  p_tag varchar2 default ploffx_document_tag.t_tblWidth,
  p_w varchar2 default null,
  p_type varchar2 default null
  ) return ploffx_document_type.CT_TblWidth;
---------------------------------------------
--v3.0.1
--tblW:CT_TblWidth
--create structure
function tblW(
  p_tag varchar2 default ploffx_document_tag.t_tblW,
  p_w varchar2 default null,
  p_type varchar2 default null
  ) return ploffx_document_type.CT_TblWidth;
---------------------------------------------
--CT_Border
--create structure
function Border(
  p_tag varchar2,
  p_val varchar2 default null,
  p_color varchar2 default null,
  p_themeColor varchar2 default null,
  p_themeTint varchar2 default null,
  p_themeShade varchar2 default null,
  p_sz varchar2 default null,
  p_space varchar2 default null,
  p_shadow varchar2 default null,
  p_frame varchar2 default null
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--tblStyle
--create structure
function tblStyle(
  p_tag varchar2 default ploffx_document_tag.t_tblStyle,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--jc CT_Jc
--create structure
function jcTable(
  p_tag varchar2 default ploffx_document_tag.t_jc,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_JcTable;
---------------------------------------------
--v1.3.0
--gridBefore:CT_DecimalNumber
--create structure
function gridBefore(
  p_tag varchar2 default ploffx_document_tag.t_gridBefore,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--gridAfter:CT_DecimalNumber
--create structure
function gridAfter(
  p_tag varchar2 default ploffx_document_tag.t_gridAfter,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--wBefore:CT_TblWidth
--create structure
function wBefore(
  p_tag varchar2 default ploffx_document_tag.t_wBefore,
  p_w varchar2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_TblWidth;
---------------------------------------------
--v1.3.0
--wAfter:CT_TblWidth
--create structure
function wAfter(
  p_tag varchar2 default ploffx_document_tag.t_wAfter,
  p_w varchar2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_TblWidth;
---------------------------------------------
--v1.3.0
--cantSplit:CT_OnOff
--create structure
function cantSplit(
  p_tag varchar2 default ploffx_document_tag.t_cantSplit,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--trHeight:CT_Height
--create structure
function trHeight(
  p_tag varchar2 default ploffx_document_tag.t_trHeight,
  p_val varchar2 default null,
  p_hRule varchar2 default null
  ) return ploffx_document_type.CT_Height;
---------------------------------------------
--v1.3.0
--tblHeader:CT_OnOff
--create structure
function tblHeader(
  p_tag varchar2 default ploffx_document_tag.t_tblHeader,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
/*
---------------------------------------------
--v1.3.0
--hidden:CT_OnOff
--create structure
function hidden(
  p_tag varchar2 default ploffx_document_tag.t_hidden,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_OnOff;
*/
---------------------------------------------
--CT_TrPr
--create structure
function TrPr(
  p_tag varchar2 default ploffx_document_tag.t_TrPr,
  p_cnfStyle ploffx_document_type.CT_Cnf default null,
  p_divId ploffx_document_type.CT_DecimalNumber default null,
  p_gridBefore ploffx_document_type.CT_DecimalNumber default null,
  p_gridAfter ploffx_document_type.CT_DecimalNumber default null,
  p_wBefore ploffx_document_type.CT_TblWidth default null,
  p_wAfter ploffx_document_type.CT_TblWidth default null,
  p_cantSplit ploffx_document_type.CT_OnOff default null,
  p_trHeight ploffx_document_type.CT_Height default null,
  p_tblHeader ploffx_document_type.CT_OnOff default null,
  p_tblCellSpacing ploffx_document_type.CT_TblWidth default null,
  p_jc ploffx_document_type.CT_JcTable default null,
  p_hidden ploffx_document_type.CT_OnOff default null
  --p_ins CT_TrackChange
  --p_del CT_TrackChange
  --p_trPrChange CT_TrPrChange
  ) return ploffx_document_type.CT_TrPr;
---------------------------------------------
--CT_Tr
--create structure
function tr(
  p_tag varchar2 default ploffx_document_tag.t_tr,
  -- tblPrEx CT_TblPrEx,
  p_trPr ploffx_document_type.CT_TrPr default null,
  p_cellcontents  ploffx_document_type.t_cellcontents default null,
  p_rsidRPr varchar2 default null,
  p_rsidR varchar2 default null,
  p_rsidDel varchar2 default null,
  p_rsidTr varchar2 default null
  ) return ploffx_document_type.CT_Row;
--rowcontents
function add_rowcontents_tr(
  p_rowcontents in out ploffx_document_type.t_rowcontents,
  p_rowcontent_items  in out ploffx_document_type.t_rowcontent_items,
  p_tr ploffx_document_type.CT_Row
  ) return pls_integer;
--rowcontents
function add_rowcontents_CustomXml(
  p_rowcontents in out ploffx_document_type.t_rowcontents,
  p_rowcontent_items  in out ploffx_document_type.t_rowcontent_items,
  p_CustomXml ploffx_document_type.CT_CustomXmlRow
  ) return pls_integer;
---------------------------------------------
--v1.3.0
--gridSpan:CT_DecimalNumber
--create structure
function gridSpan(
  p_tag varchar2 default ploffx_document_tag.t_gridSpan,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v1.3.0
--hideMark:CT_OnOff
--create structure
function hideMark(
  p_tag varchar2 default ploffx_document_tag.t_hideMark,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--hMerge:CT_HMerge
--create structure
function hMerge(
  p_tag varchar2 default ploffx_document_tag.t_hMerge,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_HMerge;
---------------------------------------------
--v1.3.0
--tcBorders:CT_TcBorders
--create structure
function tcBorders(
  p_tag varchar2 default ploffx_document_tag.t_tcBorders,
  p_top ploffx_document_type.CT_Border default null,
  p_left ploffx_document_type.CT_Border default null,
  p_bottom ploffx_document_type.CT_Border default null,
  p_right ploffx_document_type.CT_Border default null,
  p_insideH ploffx_document_type.CT_Border default null,
  p_insideV ploffx_document_type.CT_Border default null,
  p_tl2br ploffx_document_type.CT_Border default null,
  p_tr2bl ploffx_document_type.CT_Border default null
  ) return ploffx_document_type.CT_TcBorders;
---------------------------------------------
--v1.3.0
--tcFitText:CT_OnOff
--create structure
function tcFitText(
  p_tag varchar2 default ploffx_document_tag.t_tcFitText,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
---------------------------------------------
--v1.3.0
--tcMar:CT_TcMar
--create structure
function tcMar(
  p_tag varchar2 default ploffx_document_tag.t_tcMar,
  p_top ploffx_document_type.CT_TblWidth default null,
  p_left ploffx_document_type.CT_TblWidth default null,
  p_bottom ploffx_document_type.CT_TblWidth default null,
  p_right ploffx_document_type.CT_TblWidth default null
  ) return ploffx_document_type.CT_TcMar;
---------------------------------------------
--v1.3.0
--vAlign:CT_VerticalJc
--create structure
function vAlign(
  p_tag varchar2 default ploffx_document_tag.t_vAlign,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_VerticalJc;
---------------------------------------------
--v1.3.0
--vMerge:CT_VMerge
--create structure
function vMerge(
  p_tag varchar2 default ploffx_document_tag.t_vMerge,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_VMerge;
---------------------------------------------
--tl2br:CT_Border
--create structure
function tl2br(
  p_tag varchar2 default ploffx_document_tag.t_tl2br,
  p_val plx_sc.normalv2,
  p_color plx_sc.normalv2,
  p_themeColor ploffx_document_type.ST_ThemeColor,
  p_themeTint plx_sc.normalv2,
  p_themeShade plx_sc.normalv2,
  p_sz plx_sc.normalv2,
  p_space plx_sc.normalv2,
  p_shadow plx_sc.normalv2,
  p_frame plx_sc.normalv2
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--tr2bl:CT_Border
--create structure
function tr2bl(
  p_tag varchar2 default ploffx_document_tag.t_tr2bl,
  p_val plx_sc.normalv2,
  p_color plx_sc.normalv2,
  p_themeColor ploffx_document_type.ST_ThemeColor,
  p_themeTint plx_sc.normalv2,
  p_themeShade plx_sc.normalv2,
  p_sz plx_sc.normalv2,
  p_space plx_sc.normalv2,
  p_shadow plx_sc.normalv2,
  p_frame plx_sc.normalv2
  ) return ploffx_document_type.CT_Border;
---------------------------------------------
--v1.3.0
--tcw:CT_TblWidth
--create structure
function tcw(
  p_tag varchar2 default ploffx_document_tag.t_tcw,
  p_w varchar2 default null,
  p_type ploffx_document_type.ST_TblWidth default null
  ) return ploffx_document_type.CT_TblWidth;
---------------------------------------------
--v1.3.0
--TcPr:CT_TcPr
--create structure
function tcPr(
  p_tag varchar2 default ploffx_document_tag.t_tcPr,
  -- cellDel
  -- cellIns
  -- cellMerge
  p_cnfStyle ploffx_document_type.CT_Cnf default null,
  p_tcW ploffx_document_type.CT_TblWidth default null,
  p_gridSpan ploffx_document_type.CT_DecimalNumber default null,
  p_vMerge ploffx_document_type.CT_VMerge default null,
  p_tcBorders ploffx_document_type.CT_TcBorders default null,
  p_shd ploffx_document_type.CT_Shd default null,
  p_noWrap ploffx_document_type.CT_OnOff default null,
  p_tcMar ploffx_document_type.CT_TcMar default null,
  p_textDirection ploffx_document_type.CT_TextDirection default null,
  p_tcFitText ploffx_document_type.CT_OnOff default null,
  p_vAlign ploffx_document_type.CT_VerticalJc default null,
  p_hideMark ploffx_document_type.CT_OnOff default null,
  p_hMerge ploffx_document_type.CT_HMerge default null
  -- tcPrChange CT_TcPrChange
  ) return ploffx_document_type.CT_TcPr;
---------------------------------------------
--v1.3.0
--noWrap:CT_OnOff
--create structure
--noWrap
function noWrap(
  p_tag varchar2 default ploffx_document_tag.t_noWrap,
  p_val varchar2 default 'true'
  ) return ploffx_document_type.CT_OnOff;
--v1.3.0
function add_cellcontent_tc(
  p_cellcontents in out ploffx_document_type.t_cellcontents,
  p_cellcontent_items in out ploffx_document_type.t_cellcontent_items,
  p_tc ploffx_document_type.CT_tc
  ) return pls_integer;
--v1.3.0
function add_cellcontent_CustomXML(
  p_cellcontents in out ploffx_document_type.t_cellcontents,
  p_cellcontent_items in out ploffx_document_type.t_cellcontent_items,
  p_CustomXML ploffx_document_type.CT_CustomXMLCell
  ) return pls_integer;
---------------------------------------------
--v1.3.0
--Tc:CT_Tc
--create structure
function tc(
  p_tag varchar2 default ploffx_document_tag.t_tc,
  p_tcPr ploffx_document_type.CT_TcPr default null,
  p_blocks ploffx_document_type.t_blocks default null
  ) return ploffx_document_type.CT_tc;
---------------------------------------------
--v1.3.0
--graphic
--create structure
function graphic(
  p_tag varchar2 default ploffx_document_tag.t_graphic,
  p_graphicData ploffx_document_type.CT_GraphicalObjectData default null
  ) return ploffx_document_type.CT_GraphicalObject;
---------------------------------------------
--v3.6.0
--chart
--create structure
function chart(
  p_tag varchar2 default ploffx_document_tag.t_chart,
  p_r_id varchar2 default null
  ) return ploffx_document_type.t_chart_rel;
---------------------------------------------
--v1.3.0
--graphicData
--create structure
function graphicData(
  p_tag varchar2 default ploffx_document_tag.t_graphicData,
  p_uri varchar2 default null,
  p_pic ploffx_picture.CT_Picture default null,   --any: pic
  p_chart ploffx_document_type.t_chart_rel default null
  ) return ploffx_document_type.CT_GraphicalObjectData;

--v1.3.0
function positionH_align(
  --p_tag varchar2 default ploffx_document_tag.t_positionH.align,
  p_relativeFrom varchar2 default null,
  p_align varchar2 default null
  ) return ploffx_document_type.CT_PosH;
--v1.3.0
function positionH_posOffset(
  --p_tag varchar2 default ploffx_document_tag.t_positionH_posOffset,
  p_relativeFrom varchar2 default null,
  p_posOffset varchar2 default null
  ) return ploffx_document_type.CT_PosH;
--v1.3.0
function positionV_align(
  --p_tag varchar2 default ploffx_document_tag.t_positionV_align,
  p_relativeFrom varchar2 default null,
  p_align varchar2 default null
  ) return ploffx_document_type.CT_PosV;
--v1.3.0
function positionV_posOffset(
  --p_tag varchar2 default ploffx_document_tag.t_positionV_posOffset,
  p_relativeFrom varchar2 default null,
  p_posOffset varchar2 default null
  ) return ploffx_document_type.CT_PosV;
--v1.3.0
function wrapNone
  return ploffx_document_type.CT_WrapNone;
---------------------------------------------
--v1.3.0
--wrapSquare
--create structure
function wrapSquare(
  p_tag varchar2 default ploffx_document_tag.t_wrapSquare,
  p_effectExtent ploffx_document_type.CT_EffectExtent default null,
  p_wrapText varchar2 default null,
  p_distT varchar2 default null,
  p_distB varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null
  ) return ploffx_document_type.CT_WrapSquare;
---------------------------------------------
--v1.3.0
--wrapTight
--create structure
function wrapTight(
  p_tag varchar2 default ploffx_document_tag.t_wrapTight,
  p_wrapPolygon ploffx_document_type.CT_WrapPath default null,
  p_wrapText varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null
  ) return ploffx_document_type.CT_WrapTight;
---------------------------------------------
--v1.3.0
--wrapThrough
--create structure
function wrapThrough(
  p_tag varchar2 default ploffx_document_tag.t_wrapThrough,
  p_wrapPolygon ploffx_document_type.CT_WrapPath default null,
  p_wrapText varchar2 default null,
  p_distL varchar2 default null,
  p_distR varchar2 default null
  ) return ploffx_document_type.CT_WrapThrough;
---------------------------------------------
--v1.3.0
--wrapTopAndBottom
--create structure
function wrapTopAndBottom(
  p_tag varchar2 default ploffx_document_tag.t_wrapTopAndBottom,
  p_effectExtent ploffx_document_type.CT_EffectExtent default null,
  p_distT varchar2 default null,
  p_distB varchar2 default null
  ) return ploffx_document_type.CT_WrapTopBottom;
--v1.3.0
function attr(
  p_tag varchar2 default ploffx_document_tag.t_attr,
  p_uri varchar2 default null,
  p_name varchar2 default null,
  p_val varchar2 default null
  ) return ploffx_document_type.CT_attr;

--v1.3.0
procedure add_attr(
  p_attrs in out ploffx_document_type.t_attrs,
  p_attr ploffx_document_type.CT_attr
  );

--v3.0.7
function fldChar(
  p_fldCharType ploffx_document_type.ST_FldCharType,
  p_fldLock ploffx_document_type.ST_OnOff default null,
  p_dirty ploffx_document_type.ST_OnOff default null
) return ploffx_document_type.CT_fldChar;

--v2.0.0
function fldSimple(
  p_instr plx_sc.normalv2,
  p_fldLock ploffx_document_type.ST_OnOff default null,
  p_dirty ploffx_document_type.ST_OnOff default ploffx_document_type.c_true
) return ploffx_document_type.CT_SimpleField;
--v2.0.0
function add_pcontents_FLD(
  p_pcontents in out ploffx_document_type.t_pcontents,
  p_pcontent_items in out ploffx_document_type.t_pcontent_items, --v1.3.0
  p_fld ploffx_document_type.CT_SimpleField default null
  ) return pls_integer;
function hyperlink(
  p_id plx_sc.normalv2 default null,
  p_tgtFrame plx_sc.normalv2 default null,
  p_tooltip plx_sc.normalv2 default null,
  p_docLocation plx_sc.normalv2 default null,
  p_history ploffx_document_type.ST_OnOff default null,
  p_anchor plx_sc.normalv2 default null,
  p_text ploffx_document_type.t_pcontents  default ploffx_document_type.t_pcontents()
)return ploffx_document_type.CT_Hyperlink_W;
--v2.0.0
function add_pcontents_hlink(
  p_pcontents in out ploffx_document_type.t_pcontents,
  p_pcontent_items in out ploffx_document_type.t_pcontent_items, --v1.3.0
  p_hlink ploffx_document_type.CT_Hyperlink_W default null
  ) return pls_integer;
---------------------------------------------
--v3.0.0
--calendar:CT_CalendarType
--create structure
function calendar(
  p_tag varchar2 default ploffx_document_tag.t_calendar,
  p_val ploffx_document_type.ST_CalendarType default null
  ) return ploffx_document_type.CT_CalendarType;
---------------------------------------------
--v3.0.0
--storeMappedDataAs:CT_SdtDateMappingType
--create structure
function storeMappedDataAs(
  p_tag varchar2 default ploffx_document_tag.t_storeMappedDataAs,
  p_val ploffx_document_type.ST_SdtDateMappingType default null
  ) return ploffx_document_type.CT_SdtDateMappingType;
---------------------------------------------
--v3.0.0
--lid:CT_Lang
--create structure
function dateFormat(
  p_tag varchar2 default ploffx_document_tag.t_lid,
  p_val ploffx_document_type.ST_Lang default null
  ) return ploffx_document_type.CT_Lang;
---------------------------------------------
--v3.0.0
--dateFormat:CT_String
--create structure
function dateFormat(
  p_tag varchar2 default ploffx_document_tag.t_dateFormat,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--v3.0.0
--text:CT_SdtText
--create structure
function text(
  p_tag varchar2 default ploffx_document_tag.t_text,
  p_multiline ploffx_document_type.ST_OnOff default null
  ) return ploffx_document_type.CT_SdtText;
---------------------------------------------
--v3.0.0
--richText:CT_Empty
--create structure
function richText(
  p_tag varchar2 default ploffx_document_tag.t_richText
  ) return ploffx_document_type.CT_Empty;
---------------------------------------------
--v3.0.0
--placeholder:CT_Placeholder
--create structure
function picture(
  p_tag varchar2 default ploffx_document_tag.t_placeholder,
  p_docPart ploffx_document_type.CT_String default null
  ) return ploffx_document_type.CT_Placeholder;
---------------------------------------------
--v3.0.0
--picture:CT_Empty
--create structure
function picture(
  p_tag varchar2 default ploffx_document_tag.t_picture
  ) return ploffx_document_type.CT_Empty;
---------------------------------------------
--v3.0.0
--id:CT_DecimalNumber
--create structure
function id(
  p_tag varchar2 default ploffx_document_tag.t_id,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_DecimalNumber;
---------------------------------------------
--v3.0.0
--tag:CT_String
--create structure
function tag(
  p_tag varchar2 default ploffx_document_tag.t_tag,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--v3.0.0
--dropDownList:CT_SdtDropDownList
--create structure
function dropDownList(
  p_tag varchar2 default ploffx_document_tag.t_dropDownList,
  p_lastValue plx_sc.normalv2 default null,
  p_listItem ploffx_document_type.t_SdtListItem
  ) return ploffx_document_type.CT_SdtDropDownList;
---------------------------------------------
--v3.0.0
--date:CT_SdtDate
--create structure
function date_(
  p_tag varchar2 default ploffx_document_tag.t_date,
  p_fullDate plx_sc.normalv2 default null,
  p_dateFromat ploffx_document_type.CT_String default null,
  p_lid ploffx_document_type.CT_Lang default null,
  p_storeMappedDataAs ploffx_document_type.CT_SdtDateMappingType default null,
  p_calendar ploffx_document_type.CT_CalendarType default null
  ) return ploffx_document_type.CT_SdtDate;
---------------------------------------------
--v3.0.0
--listItem:CT_SdtListItem
--create structure
function comboBox(
  p_tag varchar2 default ploffx_document_tag.t_listItem,
  p_displayText plx_sc.normalv2 default null,
  p_value plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_SdtListItem;
-- t_SdtListItem
procedure add_sdtListItem(
  p_table in out ploffx_document_type.t_SdtListItem,
  p_sdtListItem ploffx_document_type.CT_SdtListItem
  );
---------------------------------------------
--v3.0.0
--comboBox:CT_SdtComboBox
--create structure
function comboBox(
  p_tag varchar2 default ploffx_document_tag.t_comboBox,
  p_lastValue plx_sc.normalv2 default null,
  p_listItem ploffx_document_type.t_SdtListItem
  ) return ploffx_document_type.CT_SdtComboBox;
---------------------------------------------
--v3.0.0
--alias:CT_String
--create structure
function alias(
  p_tag varchar2 default ploffx_document_tag.t_alias,
  p_val plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_String;
---------------------------------------------
--v3.0.0
--sdtPr:CT_SdtPr
--create structure
function sdtPr(
  p_tag varchar2 default ploffx_document_tag.t_sdtPr,
  p_alias ploffx_document_type.CT_String default null,
  p_comboBox ploffx_document_type.CT_SdtComboBox default null,
  p_date ploffx_document_type.CT_SdtDate default null,
  p_dropDownList ploffx_document_type.CT_SdtDropDownList default null,
  p_tag_ ploffx_document_type.CT_String default null,
  p_id ploffx_document_type.CT_DecimalNumber default null,
  p_picture ploffx_document_type.CT_Empty default null,
  p_placeholder ploffx_document_type.CT_Placeholder default null,
  p_richText ploffx_document_type.CT_Empty default null,
  p_rpr ploffx_document_type.CT_RPr default null,
  p_text ploffx_document_type.CT_SdtText default null
  ) return ploffx_document_type.CT_SdtPr;
---------------------------------------------
--v3.0.0
--sdtContent:CT_SdtContent
--create structure
function sdtContent(
  p_tag varchar2 default ploffx_document_tag.t_SdtContent,
  p_sdtConents ploffx_document_type.t_sdtContents
  ) return ploffx_document_type.CT_SdtContent;
---------------------------------------------
--v3.0.0
--sdt:CT_Sdt
--create structure
function sdt(
  p_tag varchar2 default ploffx_document_tag.t_sdt,
  p_sdtPr ploffx_document_type.CT_SdtPr default null,
  p_sdtContent ploffx_document_type.CT_SdtContent default null
  ) return ploffx_document_type.CT_Sdt;
---------------------------------------------
--sdtItems
--v3.0.0
procedure add_sdtItem(
  p_sdtIndexes in out ploffx_document_type.t_blocks,
  p_sdtItems in out ploffx_document_type.t_SdtItems,
  p_sdt ploffx_document_type.CT_Sdt
  );
---------------------------------------------
--bookmarkStart
--v3.0.0
function bookmarkStart(
  p_tag varchar2 default ploffx_document_tag.t_bookmarkStart,
  p_id plx_sc.normalv2 default null,
  p_name plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_Bookmark;
---------------------------------------------
--bookmarkEnd
--v3.0.0
function bookmarkEnd(
  p_tag varchar2 default ploffx_document_tag.t_bookmarkEnd,
  p_id plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_MarkupRange;
---------------------------------------------
--instrText
--v3.0.0
function instrText(
  p_tag varchar2 default ploffx_document_tag.t_instrText,
  p_xml_space plx_sc.normalv2 default null,
  p_text plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_Text;
----------------------------------------------
end ploffx_document_cr;
/

