create or replace package ploffx_core
authid current_user is
--v5.9
--
-- Namespaces
ns_cp constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/package/2006/metadata/core-properties';
ns_dc constant plx_sc.normalv2 := 'http://purl.org/dc/elements/1.1/';
ns_dcterms constant plx_sc.normalv2 := 'http://purl.org/dc/terms/';
ns_dcmitype constant plx_sc.normalv2 := 'http://purl.org/dc/dcmitype/';
ns_xsi constant plx_sc.normalv2 := 'http://www.w3.org/2001/XMLSchema-instance';

-- Prefixes
ns_cp_pref constant varchar2(2 char) := 'cp';
ns_dc_pref constant varchar2(2 char) := 'dc';
ns_dcterms_pref constant varchar2(7 char) := 'dcterms';
ns_dcmitype_pref constant varchar2(8 char) := 'dcmitype';
ns_xsi_pref constant varchar2(3 char) := 'xsi';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_coreProperties constant plx_sc.normalv2 := 'coreProperties';
t_creator constant plx_sc.normalv2 := 'creator';
t_lastModifiedBy constant plx_sc.normalv2 := 'lastModifiedBy';
t_title constant plx_sc.normalv2 := 'title';
t_subject constant plx_sc.normalv2 := 'subject';
t_keywords constant plx_sc.normalv2 := 'keywords';
t_description constant plx_sc.normalv2 := 'description';
t_category constant plx_sc.normalv2 := 'category';
t_contentStatus constant plx_sc.normalv2 := 'contentStatus';
t_created  constant plx_sc.normalv2 := 'created';
t_modified constant plx_sc.normalv2 := 'modified';
t_identifier constant plx_sc.normalv2 := 'identified';
t_language constant plx_sc.normalv2 := 'language';
t_lastPrinted constant plx_sc.normalv2 := 'lastPrinted';
t_revision constant plx_sc.normalv2 := 'revision';
t_version constant plx_sc.normalv2 := 'version';

-- Constants
c_full_ns constant plx_sc.maxv2 := 'xmlns:cp="http://schemas.openxmlformats.org/package/2006/metadata/core-properties" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dcterms="http://purl.org/dc/terms/" xmlns:dcmitype="http://purl.org/dc/dcmitype/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"';
c_filename constant plx_sc.normalv2 := 'docProps/core.xml';

/************************************************************/
--Structures

-- CT_CoreProperties
type CT_CoreProperties is record (
  tag plx_sc.normalv2,
  title plx_sc.normalv2,
  subject  plx_sc.normalv2,
  creator plx_sc.normalv2,
  keywords plx_sc.normalv2,
  description plx_sc.normalv2,
  lastModifiedBy plx_sc.normalv2,
  created plx_sc.normalv2,
  modified plx_sc.normalv2,
  category plx_sc.normalv2,
  contentStatus plx_sc.normalv2,
  identifier plx_sc.normalv2,
  language_ plx_sc.normalv2,
  lastPrinted plx_sc.normalv2,
  revision plx_sc.normalv2,
  version plx_sc.normalv2
  );

/************************************************************/

-- start
procedure start_;
-- end
procedure end_;

-- CoreProperties
procedure startcoreProperties;
--
procedure endcoreProperties;

-- Creator
procedure creator(
  p_creator varchar2
  );

-- LastModifiedBy
procedure lastModifiedBy(
  p_lastModifiedBy varchar2
  );

-- Title
procedure title(
  p_title varchar2
  );

-- Subject
procedure subject(
  p_subject varchar2
  );

-- Keywords
procedure keywords(
  p_keywords varchar2
  );

-- Description
procedure description(
  p_description varchar2
  );

-- Category
procedure category(
  p_category varchar2
  );

-- ContentStatus
procedure contentStatus(
  p_contentStatus varchar2
  );

-- Created
procedure created(
  p_created varchar2
  );

-- Modified
procedure modified(
  p_modified varchar2
  );

-- Identifier
procedure identifier(
  p_identifier varchar2
  );

-- Language
procedure language_(
  p_language varchar2
  );

-- LastPrinted
procedure lastPrinted(
  p_lastPrinted varchar2
  );

-- Revision
procedure revision(
  p_revision varchar2
  );

-- Version
procedure version(
  p_version varchar2
  );

/************************************************************/
-- Create structure

---------------------------------------------
--CoreProperties:CT_CoreProperties
--v1.3.0
function cr_CoreProperties(
  p_tag plx_sc.normalv2 default t_coreProperties,
  p_title          plx_sc.normalv2 default null,
  p_subject        plx_sc.normalv2 default null,
  p_creator        plx_sc.normalv2 default null,
  p_keywords       plx_sc.normalv2 default null,
  p_description    plx_sc.normalv2 default null,
  p_lastModifiedBy plx_sc.normalv2 default null,
  p_created        plx_sc.normalv2 default null,
  p_modified       plx_sc.normalv2 default null,
  p_category       plx_sc.normalv2 default null,
  p_contentStatus  plx_sc.normalv2 default null,
  p_identifier     plx_sc.normalv2 default null,
  p_language_       plx_sc.normalv2 default null,
  p_lastPrinted    plx_sc.normalv2 default null,
  p_revision       plx_sc.normalv2 default null,
  p_version        plx_sc.normalv2 default null
  ) return CT_CoreProperties;

/************************************************************/
-- Generate XML parts

---------------------------------------------
-- CoreProperties:CT_CoreProperties
-- v1.3.0
procedure gen_CoreProperties(
  p_CoreProperties CT_CoreProperties
  );

-- GEN_XML
procedure gen_xml(
  p_CoreProperties CT_CoreProperties
  );

/************************************************************/
-- Parse and preprocessed parts

-- Parse
-- v1.3.0
function parse(
  p_file clob
  ) return CT_CoreProperties;

--v4.10
procedure docx_core_init(
  p_title varchar2,
  p_subject varchar2,
  p_creator varchar2, --producer
  p_keywords varchar2,
  p_description varchar2,
  p_lastmodifiedby varchar2, --producer
  p_created varchar2, --timestamp
  p_modified varchar2, --timestamp
  p_core in out CT_CoreProperties
  );

--
end ploffx_core;
/

