create or replace package ploffx_content_types
authid current_user is
--v5.9
--
--Namespaces
ns_ct constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/package/2006/content-types';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag
t_Types    constant plx_sc.normalv2 := 'Types';
t_Default  constant plx_sc.normalv2 := 'Default';
t_Override constant plx_sc.normalv2 := 'Override';

-- Constants
c_filename constant plx_sc.normalv2 := '[Content_Types].xml';

/************************************************************/
--Structures

-- CT_Default
type CT_Default is record (
  tag plx_sc.normalv2,
  Extension plx_sc.normalv2, --ST_Extension
  ContentType plx_sc.normalv2 --ST_ContentType
  );
-- t_default_
type t_default_ is table of CT_Default;
v_default_empty t_default_ := t_default_();

-- CT_Override
type CT_Override is record (
  tag plx_sc.normalv2,
  ContentType plx_sc.normalv2, --ST_ContentType
  PartName plx_sc.normalv2 --xs:anyURI
  );
-- t_override_
type t_override_ is table of CT_Override;
v_override_empty t_override_ := t_override_();

-- CT_Types
type CT_Types is record(
  tag plx_sc.normalv2,
  Default_ t_default_,
  Override t_override_
  );

/************************************************************/

-- start_
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
-- end_
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );

-- Types
procedure startTypes(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Types
  );
--
procedure endTypes(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Types
  );

-- Default_
procedure Default_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Default,
  p_Extension varchar2,
  p_ContentType varchar2
  );

-- Override_
procedure Override_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Override,
  p_ContentType varchar2,
  p_PartName varchar2
  );


/************************************************************/
-- Create structure

---------------------------------------------
--Default:CT_Default
-- v1.3.0
function cr_Default(
  p_tag varchar2 default t_Default,
  p_extension plx_sc.normalv2,
  p_contentType plx_sc.normalv2
  ) return CT_Default;

---------------------------------------------
--Override:CT_Override
-- v1.3.0
function cr_Override(
  p_tag varchar2 default t_Override,
  p_contentType plx_sc.normalv2,
  p_partName plx_sc.normalv2
  ) return CT_Override;

---------------------------------------------
--Types:CT_Types
-- v3.0.0
function cr_Types(
  p_tag plx_sc.normalv2 default t_Types,
  p_default t_default_ default null,
  p_override t_override_ default null
  ) return CT_Types;

/************************************************************/
-- Generate XML parts

---------------------------------------------
--Default:CT_Default
-- v1.3.0
procedure gen_Default(
  p_xml in out plx_sc.type_xdoc,
  p_default CT_Default
  );

---------------------------------------------
--Override:CT_Override
-- v1.3.0
procedure gen_Override(
  p_xml in out plx_sc.type_xdoc,
  p_override CT_override
  );

---------------------------------------------
--Types:CT_Types
-- v1.3.0
procedure gen_Types(
  p_xml in out plx_sc.type_xdoc,
  p_Types CT_types
  );

---------------------------------------------
-- add_Default
-- v1.3.0
procedure add_Default(
  p_table in out t_default_,
  p_default CT_Default
  );

---------------------------------------------
-- add_Override
-- v1.3.0
procedure add_Override(
  p_table in out t_override_,
  p_override CT_Override
  );

-- GEN_XML
-- v1.3.0
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_Types CT_types
  );

/************************************************************/
-- Parse and preprocessed parts

-- Parse
-- v1.3.0
function parse(
  p_file clob
  ) return CT_types;

-- v1.3.0
procedure docx_ContentTypes_init(
  p_types in out CT_types
  );

-- v1.3.0
procedure xlsx_ContentTypes_init(
  p_types in out CT_types
  );

--
end ploffx_content_types;
/

