create or replace package ploffx_comments
authid current_user is
--v5.9
--
-- Namespace
c_full_ns constant plx_sc.normalv2 := 'xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main"';
-- XML
g_xml plx_sc.type_xdoc;
-- Tag
t_comments constant plx_sc.normalv2 := 'comments';
t_authors constant plx_sc.normalv2 := 'authors';
t_author constant plx_sc.normalv2 := 'author';
t_commentList constant plx_sc.normalv2 := 'commentList';
t_comment constant plx_sc.normalv2 := 'comment';
t_text constant plx_sc.normalv2 := 'text';
t_r constant plx_sc.normalv2 := 'r';
t_rPr constant plx_sc.normalv2 := 'rPr';
t_b constant plx_sc.normalv2 := 'b';
t_color constant plx_sc.normalv2 := 'color';
t_rFont constant plx_sc.normalv2 := 'rFont';
t_charset constant plx_sc.normalv2 := 'charset';
t_t constant plx_sc.normalv2 := 't';
t_sz constant plx_sc.normalv2 := 'sz';
-- Constants
ansi_charset constant pls_integer := 0;
default_charset constant pls_integer := 1;
symbol_charset constant pls_integer := 2;
mac_charset constant pls_integer := 77;
shiftjis_charset constant pls_integer := 128;
hangeul_charset constant pls_integer := 129;
hangul_charset constant pls_integer := 129;
johab_charset constant pls_integer := 130;
gb2312_charset constant pls_integer := 134;
chinesebig5_charset constant pls_integer := 136;
greek_charset constant pls_integer := 161;
turkish_charset constant pls_integer := 162;
vietnamese_charset constant pls_integer := 163;
hebrew_charset constant pls_integer := 177;
arabic_charset constant pls_integer := 178;
baltic_charset constant pls_integer := 186;
russian_charset constant pls_integer := 204;
thai_charset constant pls_integer := 222;
easteurope_charset constant pls_integer := 238;
oem_charset constant pls_integer := 255;
/******************************************************************/
--Structures
-- CT_Comment
type CT_Comment is record(
     tag plx_sc.normalv2,
     text ploffx_sharedstrings.CT_Rst,
     ref_ plx_sc.normalv2, -- ST_Ref
     authorId plx_sc.normalv2, -- xsd:unsignedInt
     guid plx_sc.normalv2 -- ST_Guid xsd:token
     );
-- t_comment_
type t_comment_ is table of CT_Comment;
v_comment_empty t_comment_ := t_comment_();
-- CT_CommentList
type CT_CommentList is record(
     tag plx_sc.normalv2,
     comment_ t_comment_
     );
-- CT_Author
type CT_Author is record(
     tag plx_sc.normalv2,
     val plx_sc.normalv2
     );
-- t_authors_
type t_author_ is table of CT_Author;
v_author_empty t_author_ := t_author_();
-- CT_Authors
type CT_Authors is record(
     tag plx_sc.normalv2,
     author t_author_
     );
-- CT_Comments
type CT_Comments is record(
     tag plx_sc.normalv2,
     authors CT_Authors,
     commentLst CT_CommentList
     -- extLst
     );
--
v_comments_empty CT_Comments;
/******************************************************************/
-- start
procedure start_;
-- end
procedure end_;
-- comments
procedure startcomments(
  p_tag varchar2 default t_comments
  );
--
procedure endcomments(
  p_tag varchar2 default t_comments
  );
-- authors
procedure startauthors(
  p_tag varchar2 default t_authors
  );
--
procedure endauthors(
  p_tag varchar2 default t_authors
  );
-- author
procedure startauthor(
  p_tag varchar2 default t_author
  );
--
procedure endauthor(
  p_tag varchar2 default t_author
  );
-- commentList
procedure startcommentList(
  p_tag varchar2 default t_commentList
  );
--
procedure endcommentList(
  p_tag varchar2 default t_commentList
  );
-- comment
procedure startcomment(
  p_tag varchar2 default t_comment,
  p_ref varchar2,
  p_authorId varchar2,
  p_guid varchar2 default null
  );
--
procedure endcomment(
  p_tag varchar2 default t_comment
  );
-- text
procedure starttext(
  p_tag varchar2 default t_text
  );
--
procedure endtext(
  p_tag varchar2 default t_text
  );
--
/******************************************************************/
-- Create structure
------------------------------------------
-- text: ploffx_sharedstrings.CT_Rst
function cr_text(
  p_tag plx_sc.normalv2 default t_text,
  p_t plx_sc.maxv2, -- text
  p_r ploffx_sharedstrings.t_richtextruns,
  p_rPh ploffx_sharedstrings.t_phoneticruns,
  p_phoneticPr ploffx_sharedstrings.CT_PhoneticPr
  ) return ploffx_sharedstrings.CT_Rst;
------------------------------------------
-- comment: CT_Comment
function cr_comment(
  p_tag plx_sc.normalv2 default t_comment,
  p_text ploffx_sharedstrings.CT_Rst,
  p_ref plx_sc.normalv2,
  p_authorId plx_sc.normalv2,
  p_guid plx_sc.normalv2
  ) return CT_Comment;
-- comment: t_comment_
procedure add_comment(
  p_table in out t_comment_,
  p_comment CT_Comment
  );
------------------------------------------
-- commentList: CT_CommentList
function cr_commentList(
  p_tag plx_sc.normalv2 default t_commentList,
  p_comment t_comment_
  ) return CT_CommentList;
------------------------------------------
-- author: CT_Author
function cr_author(
  p_tag plx_sc.normalv2 default t_author,
  p_val plx_sc.normalv2
  ) return CT_Author;
-- author: t_author_
procedure add_author(
  p_table in out t_author_,
  p_author CT_Author
  );
------------------------------------------
-- authors: CT_Authors
function cr_authors(
  p_tag plx_sc.normalv2 default t_authors,
  p_author t_author_
  ) return CT_Authors;
------------------------------------------
-- comments: CT_Comments
function cr_comments(
  p_tag plx_sc.normalv2 default t_comments,
  p_authors CT_Authors,
  p_commentLst CT_CommentList
  ) return CT_Comments;
/******************************************************************/
-- Generate XML part
---------------------------------------
-- text: CT_text
procedure gen_text(
  p_text ploffx_sharedstrings.CT_Rst
  );
---------------------------------------
-- comment: CT_Comment
procedure gen_comment(
  p_comment CT_Comment
  );
---------------------------------------
-- commentList: CT_CommentList
procedure gen_commentList(
  p_commentList CT_CommentList
  );
---------------------------------------
-- author: CT_Author
procedure gen_author(
  p_author CT_Author
  );
---------------------------------------
-- authors: CT_Authors
procedure gen_authors(
  p_authors CT_Authors
  );
---------------------------------------
-- comments: CT_Comments
procedure gen_comments(
  p_comments CT_Comments
  );
------------------------------------------
-- GEN_XML
procedure gen_xml(
  p_xml CT_Comments
  );
------------------------------------------
-- PARSE_XML
function parse(
  p_file clob
  ) return CT_Comments;
-- GET_SHEET_ID
function getSheetID(
  p_filename varchar2
  ) return pls_integer;
--
end ploffx_comments;
/

