create or replace package ploffx_chart
authid current_user is
--v5.9
--
-- Namespaces
ns_c constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/chart';
ns_a constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/drawingml/2006/main';
ns_r constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/relationships';
ns_xml_pref constant varchar2(3 char) := 'xml';

-- Prefixes
ns_c_pref constant varchar2(1) := 'c';
ns_a_pref constant varchar2(1) := 'a';
ns_r_pref constant varchar2(1) := 'r';

-- XML
g_xml plx_sc.type_xdoc;

-- Tag list
t_chartSpace constant plx_sc.normalv2 := 'chartSpace';
t_chart constant plx_sc.normalv2 := 'chart';
t_title constant plx_sc.normalv2 := 'title';
t_tx constant plx_sc.normalv2 := 'tx';
t_rich constant plx_sc.normalv2 := 'rich';
t_bodyPr constant plx_sc.normalv2 := 'bodyPr';
t_strRef constant plx_sc.normalv2 := 'strRef';
t_f constant plx_sc.normalv2 := 'f';
t_strCache constant plx_sc.normalv2 := 'strCache';
t_ptCount constant plx_sc.normalv2 := 'ptCount';
t_pt constant plx_sc.normalv2 := 'pt';
t_v constant plx_sc.normalv2 := 'v';
t_plotVisOnly constant plx_sc.normalv2 := 'plotVisOnly';
t_legend constant plx_sc.normalv2 := 'legend';
t_legendPos constant plx_sc.normalv2 := 'legendPos';
t_layout constant plx_sc.normalv2 := 'layout';
t_manualLayout constant plx_sc.normalv2 := 'manualLayout';
t_xMode constant plx_sc.normalv2 := 'xMode';
t_yMode constant plx_sc.normalv2 := 'yMode';
t_x constant plx_sc.normalv2 := 'x';
t_y constant plx_sc.normalv2 := 'y';
t_w constant plx_sc.normalv2 := 'w';
t_h constant plx_sc.normalv2 := 'h';
t_plotArea constant plx_sc.normalv2 := 'plotArea';
t_barChart constant plx_sc.normalv2 := 'barChart';
t_overlap constant plx_sc.normalv2 := 'overlap';
t_bar3DChart constant plx_sc.normalv2 := 'bar3DChart';
t_barDir constant plx_sc.normalv2 := 'barDir';
t_shape constant plx_sc.normalv2 := 'shape';
t_serLines constant plx_sc.normalv2 := 'serLines';
t_areaChart constant plx_sc.normalv2 := 'areaChart';
t_area3DChart constant plx_sc.normalv2 := 'area3DChart';
t_lineChart constant plx_sc.normalv2 := 'lineChart';
t_hiLowLines constant plx_sc.normalv2 := 'hiLowLines';
t_marker constant plx_sc.normalv2 := 'marker';
t_smooth constant plx_sc.normalv2 := 'smooth';
t_updownBars constant plx_sc.normalv2 := 'updownBars';
t_line3DChart constant plx_sc.normalv2 := 'line3DChart';
t_pieChart constant plx_sc.normalv2 := 'pieChart';
t_pie3DChart constant plx_sc.normalv2 := 'pie3DChart';
t_doughnutChart constant plx_sc.normalv2 := 'doughnutChart';
t_firstSliceAng constant plx_sc.normalv2 := 'firstSliceAng';
t_holeSize constant plx_sc.normalv2 := 'holeSize';
t_gapWidth constant plx_sc.normalv2 := 'gapWidth';
t_dLbls constant plx_sc.normalv2 := 'dLbls';
t_showVal constant plx_sc.normalv2 := 'showVal';
t_dLblPos constant plx_sc.normalv2 := 'dLblPos';
t_dropLines constant plx_sc.normalv2 := 'dropLines';
t_gapDepth constant plx_sc.normalv2 := 'gapDepth';
t_grouping constant plx_sc.normalv2 := 'grouping';
t_ser constant plx_sc.normalv2 := 'ser';
t_idx constant plx_sc.normalv2 := 'idx';
t_order constant plx_sc.normalv2 := 'order';
t_cat constant plx_sc.normalv2 := 'cat';
t_val constant plx_sc.normalv2 := 'val';
t_numRef constant plx_sc.normalv2 := 'numRef';
t_numCache constant plx_sc.normalv2 := 'numCache';
t_formatCode constant plx_sc.normalv2 := 'formatCode';
t_varyColors constant plx_sc.normalv2 := 'varyColors';
t_catAx constant plx_sc.normalv2 := 'catAx';
t_valAx constant plx_sc.normalv2 := 'valAx';
t_axId constant plx_sc.normalv2 := 'axId';
t_scaling constant plx_sc.normalv2 := 'scaling';
t_orientation constant plx_sc.normalv2 := 'orientation';
t_min constant plx_sc.normalv2 := 'min';
t_max constant plx_sc.normalv2 := 'max';
t_axPos constant plx_sc.normalv2 := 'axPos';
t_majorGridlines constant plx_sc.normalv2 := 'majorGridlines';
t_minorGridlines constant plx_sc.normalv2 := 'minorGridlines';
t_numFmt constant plx_sc.normalv2 := 'numFmt';
t_majorTickMark constant plx_sc.normalv2 := 'majorTickMark';
t_minorTickMark constant plx_sc.normalv2 := 'minorTickMark';
t_tickLblPos constant plx_sc.normalv2 := 'tickLblPos';
t_crossAx constant plx_sc.normalv2 := 'crossAx';
t_crosses constant plx_sc.normalv2 := 'crosses';
t_crossesAt constant plx_sc.normalv2 := 'crossesAt';
t_crossBetween constant plx_sc.normalv2 := 'crossBetween';
t_lblAlgn constant plx_sc.normalv2 := 'lblAlgn';
t_lblOffset constant plx_sc.normalv2 := 'lblOffset';
t_tickLblSkip constant plx_sc.normalv2 := 'tickLblSkip';
t_majorUnit constant plx_sc.normalv2 := 'majorUnit';
t_minorUnit constant plx_sc.normalv2 := 'minorUnit';
t_spPr constant plx_sc.normalv2 := 'spPr';
t_solidFill constant plx_sc.normalv2 := 'solidFill';
t_srgbClr constant plx_sc.normalv2 := 'srgbClr';
t_sysClr constant plx_sc.normalv2 := 'sysClr';
t_schemeClr constant plx_sc.normalv2 := 'schemeClr';
t_lumMod constant plx_sc.normalv2 := 'lumMod';
t_lumOff constant plx_sc.normalv2 := 'lumOff';
t_ln constant plx_sc.normalv2 := 'ln';
t_prstDash constant plx_sc.normalv2 := 'prstDash';
--
t_txPr constant plx_sc.normalv2 := 'txPr';
t_defRPr constant plx_sc.normalv2 := 'defRPr';
t_pPr constant plx_sc.normalv2 := 'pPr';
t_latin constant plx_sc.normalv2 := 'latin';
t_delete constant plx_sc.normalv2 := 'delete';

--t_trendLine constant plx_sc.normalv2 := 'trendLine';
--t_dPt constant plx_sc.normalv2 := 'dPt';
--t_errBars constant plx_sc.normalv2 := 'errBars';
--t_pictureOptions constant plx_sc.normalv2 := 'pictureOptions';
--t_invertIfNegative constant plx_sc.normalv2 := 'invertIfNegative';
--t_explosion constant plx_sc.normalv2 := 'explosion';
--t_auto constant plx_sc.normalv2 := 'auto';
--t_date1904 constant plx_sc.normalv2 := 'date1904';
--t_lang constant plx_sc.normalv2 := 'lang';
--t_layoutTarget constant plx_sc.normalv2 := 'layoutTarget';

--t_view3D constant plx_sc.normalv2 := 'view3D';
--t_deptPercent constant plx_sc.normalv2 := 'deptPercent';
--t_hPercent constant plx_sc.normalv2 := 'hPercent';
--t_perspective constant plx_sc.normalv2 := 'perspective';
--t_rotX constant plx_sc.normalv2 := 'rotX';
--t_rotY constant plx_sc.normalv2 := 'rotY';
t_autoUpdate constant plx_sc.normalv2 := 'autoUpdate';
t_externalData constant plx_sc.normalv2 := 'externalData';
--t_printSettings constant plx_sc.normalv2 := 'printSettings';
--t_headerFooter constant plx_sc.normalv2 := 'headerFooter';
--t_pageMargins constant plx_sc.normalv2 := 'pageMargins';
--t_pageSetup constant plx_sc.normalv2 := 'pageSetup';

/******************************************************************/
-- Structures
--CT_Boolean
type CT_Boolean is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 --xsd:boolean
);
-- CT_UnsignedInt
type CT_UnsignedInt is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 --int
);
--CT_String
type CT_String is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2
  );
-- ST_PageSetupOrientation
subtype ST_PageSetupOrientation is ploffx_util.t_string;
--
c_default constant ST_PageSetupOrientation := 'default';
c_portrait constant ST_PageSetupOrientation := 'portrait';
c_landscape constant ST_PageSetupOrientation := 'landscape';
-- CT_PageSetup
type CT_PageSetup is record(
  tag plx_sc.normalv2,
  paperSize plx_sc.normalv2,
  firstPageNumber plx_sc.normalv2,
  orientation ST_PageSetupOrientation,
  blackAndWhite plx_sc.normalv2, --xsd:boolean
  draft plx_sc.normalv2,--xsd:boolean
  useFirstPageNumber plx_sc.normalv2, --xsd:boolean
  horizontalDpi plx_sc.normalv2, -- xsd:int
  verticalDpi plx_sc.normalv2, --xsd:int
  copies plx_sc.normalv2
);
-- CT_PageMargins
type CT_PageMargins is record(
  tag plx_sc.normalv2,
  l plx_sc.normalv2, --xsd:double
  r plx_sc.normalv2, --xsd:double
  t plx_sc.normalv2, --xsd:double
  b plx_sc.normalv2, --xsd:double
  header plx_sc.normalv2, --xsd:double
  footer plx_sc.normalv2 --xsd:double
);
-- CT_HeaderFooter
type CT_HeaderFooter is record(
  tag plx_sc.normalv2,
  alignWithMargins plx_sc.normalv2, --xsd:boolean
  differentOddEven plx_sc.normalv2, --xsd:boolean
  differentFrist plx_sc.normalv2 --xsd:boolean
);
--
subtype ST_BlackWhiteMode is ploffx_util.t_string;
c_auto constant ST_BlackWhiteMode := 'auto';
-- CT_SRgbColor
type CT_SRgbColor is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2, -- ST_HexBinary3
  alpha CT_UnsignedInt
  );
-- CT_SystemColor
type CT_SystemColor is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2, -- ST_SystemColorVal
  lastClr plx_sc.normalv2 -- ST_HexBinary3
  );
-- CT_SchemeColor
type CT_SchemeColor is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_SchemeColorVal
  --lumOff
  --lumMod
  );
-- CT_SolidColorFillProperties
type CT_SolidColorFillProperties is record(
  tag plx_sc.normalv2,
  srgbClr CT_SRgbColor,
  sysClr CT_SystemColor,
  schemeClr CT_SchemeColor
  );

-- CT_PresetLineDProperties
type CT_PresetLineDProperties is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_PresetLineDashVal
  );
-- CT_LineProperties
type CT_LineProperties is record(
  tag plx_sc.normalv2,
  cmpd plx_sc.normalv2, -- ST_CompoundLine
  w plx_sc.normalv2, -- ST_LineWidth
  solidFill CT_SolidColorFillProperties,
  prstDash CT_PresetLineDProperties
  );
-- CT_ShapeProperties
type CT_ShapeProperties is record(
  tag plx_sc.normalv2,
  bwMode ST_BlackWhiteMode,
  -- blipFill
  -- custGeom
  -- effectLst
  -- extLst
  -- gradFill
  -- grpFill
  ln CT_LineProperties,
  -- noFill
  -- pattFill
  -- prstGeom
  -- scene3d
  solidFill CT_SolidColorFillProperties
  -- sp3d
  -- xfrm
  );
-- CT_ChartLines
type CT_ChartLines is record(
  tag plx_sc.normalv2,
  spPr CT_ShapeProperties
  );
--ST_Orientation
subtype ST_Orientation is ploffx_util.t_string;
--
c_maxMin constant ST_Orientation := 'maxMin';
c_minMax constant ST_Orientation := 'minMax';
--CT_Orientation
type CT_Orientation is record(
  tag plx_sc.normalv2,
  val ST_Orientation
);
--CT_Scaling
type CT_Scaling is record(
  tag plx_sc.normalv2,
  orientation CT_Orientation,
  min_ CT_UnsignedInt, -- CT_Double
  max_ CT_UnsignedInt -- CT_Double
);
-- CT_LblOffset
type CT_LblOffset is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 --St_LblOffset
);
-- ST_LblAlgn
subtype ST_LblAlgn is ploffx_util.t_string;
--
c_ctr_lbl constant ST_LblAlgn := 'ctr';
c_l_lbl constant ST_LblAlgn := 'l';
c_r_lbl constant ST_LblAlgn := 'r';
-- CT_LblAlgn
type CT_LblAlgn is record(
  tag plx_sc.normalv2,
  val ST_LblAlgn
);
--ST_Crosses
subtype ST_Crosses is ploffx_util.t_string;
--
c_autoZero constant ST_Crosses := 'autoZero';
c_max constant ST_Crosses := 'max';
c_min constant ST_Crosses := 'min';
-- CT_Crosses
type CT_Crosses is record(
  tag plx_sc.normalv2,
  val ST_Crosses
);
--ST_TickLblPos
subtype ST_TickLblPos is ploffx_util.t_string;
--
c_high constant ST_TickLblPos := 'high';
c_low constant ST_TickLblPos := 'low';
c_nextTo constant ST_TickLblPos := 'nextTo';
c_none constant ST_TickLblPos := 'none';
-- CT_TickLblPos
type CT_TickLblPos is record(
  tag plx_sc.normalv2,
  val ST_TickLblPos
);
--ST_AxPos
subtype ST_AxPos is ploffx_util.t_string;
--
c_b_ax constant ST_AxPos := 'b';
c_l_ax constant ST_AxPos := 'l';
c_r_ax constant ST_AxPos := 'r';
c_t_ax constant ST_AxPos := 't';
-- CT_AxPos
type CT_AxPos is record(
  tag plx_sc.normalv2,
  val ST_AxPos
);
--
subtype ST_TickMark is ploffx_util.t_string;
c_corss constant ST_TickMark := 'cross';
c_in constant ST_TickMark := 'in';
c_none constant ST_TickMark := 'none';
c_out constant ST_TickMark := 'out';
-- CT_TickMark
type CT_TickMark is record(
  tag plx_sc.normalv2,
  val ST_TickMark
  );
-- CT_Skip
type CT_Skip is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_Skype
  );
--CT_NumFmt
type CT_NumFmt is record(
  tag plx_sc.normalv2,
  formatCode plx_sc.normalv2, --ST_Xstring
  sourceLinked plx_sc.normalv2 --xsd:boolean
);
-- ST_TextAnchoringType
subtype ST_TextAnchoringType is ploffx_util.t_string;
c_b_anchor constant ST_TextAnchoringType := 'b';
c_ctr_anchor constant ST_TextAnchoringType := 'ctr';
c_dist_anchor constant ST_TextAnchoringType := 'dist';
c_just_anchor constant ST_TextAnchoringType := 'just';
c_t_anchor constant ST_TextAnchoringType := 't';
-- ST_TextVerticalType
subtype ST_TextVerticalType is ploffx_util.t_string;
c_eaVert constant ST_TextVerticalType := 'eaVert';
c_horz constant ST_TextVerticalType := 'horz';
c_mongolianVert constant ST_TextVerticalType := 'mongolianVert';
c_vert constant ST_TextVerticalType := 'vert';
c_vert270 constant ST_TextVerticalType := 'vert270';
c_wordArtVert constant ST_TextVerticalType := 'wordArtVert';
c_wordArtVertRtl constant ST_TextVerticalType := 'wordArtVertRtl';
-- CT_TextBodyProperties
type CT_TextBodyProperties is record(
  tag plx_sc.normalv2,
  anchor ST_TextAnchoringType,
  anchorCtr plx_sc.normalv2,
  vert ST_TextVerticalType,
  rot plx_sc.normalv2
  );
-- CT_TextFont
type CT_TextFont is record(
  tag plx_sc.normalv2,
  typeface varchar2(255)
 );
-- CT_TextProperties
type CT_TextProperties is record( -- CT_TextCharacterProperties
  tag plx_sc.normalv2,
  b plx_sc.normalv2,
  cap plx_sc.normalv2,
  i plx_sc.normalv2,
  sz plx_sc.normalv2,
  solidFill CT_SolidColorFillProperties,
  latin CT_TextFont
  );
-- CT_RegularTextRun
type CT_RegularTextRun is record(
  tag plx_sc.normalv2,
  rpr CT_TextProperties,
  t ploffx_document_type.CT_Text
  );
--
type t_regularTextRun is table of CT_RegularTextRun;
v_regularTextRun_empty t_regularTextRun := t_regularTextRun();
-- CT_ParagraphProperties
type CT_ParagraphProperties is record(
  tag plx_sc.normalv2,
  defRPr CT_TextProperties-- CT_TextCharacterProperties
  );
-- CT_TextParagraph
type CT_TextParagraph is record(
  tag plx_sc.normalv2,
  pPr CT_ParagraphProperties,
  r t_regularTextRun
  );
--
type t_textParagraph is table of CT_TextParagraph;
v_textParagraph_empty t_textParagraph := t_textParagraph();
-- CT_TextBody
type CT_TextBody is record(
  tag plx_sc.normalv2,
  bodyPr CT_TextBodyProperties,
  --lstStyle CT_TextListStyle,
  p t_textParagraph -- CT_TextParagraph
  );
--CT_StrVal
type CT_StrVal is record(
  tag plx_sc.normalv2,
  v CT_String,--ST_Xstring
  idx plx_sc.normalv2 -- xsd:unsignedInt
);
--
type t_pt_ is table of CT_StrVal;
v_pt_empty t_pt_ := t_pt_();
-- CT_StrData
type CT_StrData is record(
  tag plx_sc.normalv2,
  ptCount CT_UnsignedInt,
  pt t_pt_
);
--CT_StrRef
type CT_StrRef is record(
  tag plx_sc.normalv2,
  f CT_String,
  strCache CT_StrData
);
-- CT_Tx
type CT_Tx is record(
  tag plx_sc.normalv2,
  rich CT_TextBody,
  strRef CT_StrRef
  );
-- ST_LayoutMode
subtype ST_LayoutMode is ploffx_util.t_string;
c_edge constant ST_LayoutMode := 'edge';
c_factor constant ST_LayoutMode := 'factor';
-- CT_LayoutMode
type CT_LayoutMode is record(
  tag plx_sc.normalv2,
  val ST_LayoutMode
  );
-- CT_ManualLayout
type CT_ManualLayout is record(
  tag plx_sc.normalv2,
  xMode CT_LayoutMode,
  yMode CT_LayoutMode,
  x CT_UnsignedInt, -- CT_Double
  y CT_UnsignedInt, -- CT_Double
  w CT_UnsignedInt, -- CT_Double
  h CT_UnsignedInt -- CT_Double
  );
-- CT_Layout
type CT_Layout is record(
  tag plx_sc.normalv2,
  --extLst CT_ExtLst
  manualLayout CT_ManualLayout
);
-- CT_Title
type CT_Title is record(
  tag plx_sc.normalv2,
  tx CT_Tx,
  txPr CT_TextBody, -- a:CT_TextBody
  spPr CT_ShapeProperties,
  layout CT_Layout
  );
-- CT_CatAx
type CT_CatAx is record(
  tag plx_sc.normalv2,
  deleted CT_Boolean,
  axId CT_UnsignedInt,
  scaling CT_Scaling,
  axPos CT_AxPos,
  majorGridLines CT_ChartLines,
  minorGridLines CT_ChartLines,
  title CT_Title,
  numFmt CT_NumFmt,
  majorTickMark CT_TickMark,
  minorTickMark CT_TickMark,
  tickLblPos CT_TickLblPos,
  spPr CT_ShapeProperties,
  crossAx CT_UnsignedInt,
  crosses CT_Crosses,
  --auto CT_Boolean,
  lblAlgn CT_LblAlgn,
  lblOffset CT_LblOffset,
  tickLblSkip CT_Skip,
  txPr CT_TextBody
);
-- ST_CrossBetween
subtype ST_CrossBetween is ploffx_util.t_string;
--
c_between constant ST_CrossBetween := 'between';
c_midCat constant ST_CrossBetween := 'midCat';
--CT_CrossBetween
type CT_CrossBetween is record(
  tag plx_sc.normalv2,
  val ST_CrossBetween
);
-- CT_AxisUnit
type CT_AxisUnit is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_AxisUnit
  );
-- CT_ValAx
type CT_ValAx is record(
  tag plx_sc.normalv2,
  deleted CT_Boolean,
  axId CT_UnsignedInt,
  scaling CT_Scaling,
  axPos CT_AxPos,
  majorGridLines CT_ChartLines,
  minorGridLines CT_ChartLines,
  title CT_Title,
  numFmt CT_NumFmt,
  majorTickMark CT_TickMark,
  minorTickMark CT_TickMark,
  tickLblPos CT_TickLblPos,
  spPr CT_ShapeProperties,
  crossAx CT_UnsignedInt,
  crosses CT_Crosses,
  --auto CT_Boolean,
  crossesAt CT_UnsignedInt,
  crossBetween CT_CrossBetween,
  majorUnit CT_AxisUnit,
  minorUnit CT_AxisUnit,
  txPr CT_TextBody
);
--CT_NumData
type CT_NumData is record(
  tag plx_sc.normalv2,
  formatCode plx_sc.normalv2,--ST_Xstring
  ptCount CT_UnsignedInt,
  pt t_pt_
);
--CT_NumRef
type CT_NumRef is record(
  tag plx_sc.normalv2,
  f CT_String,
  numCache CT_NumData
);
--Ct_NumDataSource
type CT_NumDataSource is record(
  tag plx_sc.normalv2,
  numRef CT_NumRef
);
-- CT_SerTx
type CT_SerTx is record(
  tag plx_sc.normalv2,
  strRef CT_StrRef,
  v plx_sc.normalv2
);
--CT_AxDataSource
type CT_AxDataSource is record(
  tag plx_sc.normalv2,
  strRef CT_StrRef
);
-- CT_BarSer
type CT_BarSer is record(
  tag plx_sc.normalv2,
  idx CT_UnsignedInt,
  order_ CT_UnsignedInt,
  tx CT_SerTx
);
--ST_BarGrouping
subtype ST_BarGrouping is ploffx_util.t_string;
--
c_clustered constant ST_BarGrouping := 'clustered';
c_percentStacked constant ST_BarGrouping := 'percentStacked';
c_stacked constant ST_BarGrouping := 'stacked';
c_standard constant ST_BarGrouping := 'standard';
-- CT_Grouping
type CT_BarGrouping is record(
  tag plx_sc.normalv2,
  val ST_BarGrouping
);
--ST_BarDir
subtype ST_BarDir is ploffx_util.t_string;
c_bar constant ST_BarDir := 'bar';
c_col constant ST_BarDir := 'col';
-- CT_BarDir
type CT_BarDir is record(
  tag plx_sc.normalv2,
  val ST_BarDir --(xsd:string)
);
-- CT_GapAmount
type CT_GapAmount is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_GapAmount (0-500)
  );
--
subtype ST_Shape is ploffx_util.t_string;
c_box constant ST_Shape := 'box';
c_cone constant ST_Shape := 'cone';
c_coneToMax constant ST_Shape := 'coneToMax';
c_cylinder constant ST_Shape := 'cylinder';
c_pyramid constant ST_Shape := 'pyramid';
c_pyramidToMax constant ST_Shape := 'pyramidToMax';
-- CT_Shape
type CT_Shape is record(
  tag plx_sc.normalv2,
  val ST_Shape
  );
-- CT_Overlap
type CT_Overlap is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_Overlap
  );
--
type CT_UpDownBar is record(
  tag plx_sc.normalv2,
  spPr CT_ShapeProperties
  );
-- CT_UpDownBars
type CT_UpDownBars is record(
  tag plx_sc.normalv2,
  --downBars CT_UpDownBar,
  --extLst
  gapWidth CT_GapAmount
  --upBars CT_UpDownBar
  );
-- CT_FirstSliceAng
type CT_FirstSliceAng is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_FirstSliceAng
  );
-- CT_HoleSize
type CT_HoleSize is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_HoleSize (0-90)
  );
--
subtype ST_DLblPos is ploffx_util.t_string;
c_b constant ST_DLblPos := 'b';
c_bestFit constant ST_DLblPos := 'bestFit';
c_ctr constant ST_DLblPos := 'ctr';
c_inBase constant ST_DLblPos := 'inBase';
c_inEnd constant ST_DLblPos := 'inEnd';
c_l constant ST_DLblPos := 'l';
c_outEnd constant ST_DLblPos := 'outEnd';
c_r constant ST_DLblPos := 'r';
c_t constant ST_DLblPos := 't';
-- CT_DLblPos
type CT_DLblPos is record(
  tag plx_sc.normalv2,
  val ST_DLblPos
  );
-- CT_dLblbs
type CT_dLblbs is record(
  tag plx_sc.normalv2,
  -- delete
  -- dLbl
  dLblPos CT_DLblPos,
  -- extLst
  -- leaderLines
  -- numFmt
  -- separator
  -- showBubblesize
  -- showCatName
  -- showLeaderLines
  -- showLegendKey
  -- showPercent
  -- showSerName
  showVal CT_Boolean
  -- spPr
  -- txPr
  );
--
subtype ST_Grouping is ploffx_util.t_string;
c_percentStacket ST_Grouping := 'percentStacked';
c_stacked ST_Grouping := 'stacked';
c_standard ST_Grouping := 'standard';
-- CT_Grouping
type CT_Grouping is record(
  tag plx_sc.normalv2,
  val ST_Grouping
  );
-- CT_PictureOptions
type CT_PictureOptions is record(
  tag plx_sc.normalv2
  -- applyToFront
  -- applyToSides
  -- applyToEnd
  -- pictureFormat
  -- pictureStackUnit
  );
-- CT_Marker
type CT_Marker is record(
  tag plx_sc.normalv2
  -- extLst
  -- size
  -- spPr
  -- symbol
  );
-- CT_DPt
type CT_DPt is record(
  tag plx_sc.normalv2,
  --bubble3D CT_Boolean,
  explosion CT_UnsignedInt,
  -- extLst
  idx CT_UnsignedInt,
  invertIfNegative CT_Boolean,
  marker CT_Marker,
  pictureOptions CT_PictureOptions,
  spPr CT_ShapeProperties
  );
-- CT_ErrBars
type CT_ErrBars is record(
  tag plx_sc.normalv2
  -- errBarType
  -- errDir
  -- extLst
  -- minus
  -- noEndCap
  -- plus
  -- spPr
  -- val
  );
-- CT_Trendline
type CT_Trendline is record(
  tag plx_sc.normalv2
  -- backward
  -- dispEq
  -- dispRsqr
  -- extLst
  -- forward
  -- intercept
  -- name
  -- order
  -- period
  -- spPr
  -- trendlineLbl
  -- trendlineType
  );
-- CT_Ser
type CT_Ser is record(
  tag plx_sc.normalv2,
  ser_type plx_sc.normalv2,
  cat CT_AxDataSource,
  dLbls CT_dLblbs,
  dPt CT_DPt,
  errBars CT_ErrBars,
  -- extLst
  idx CT_UnsignedInt,
  order_ CT_UnsignedInt,
  pictureOptions CT_PictureOptions,
  spPr CT_ShapeProperties,
  trendLine CT_Trendline,
  tx CT_Tx,
  val CT_NumDataSource,
  invertIfNegative CT_Boolean, -- bar/bar3D
  marker CT_Boolean, -- line/line3D
  smooth CT_Boolean,
  explosion CT_UnsignedInt
  );
--
type t_ser_ is table of CT_Ser;
v_ser_empty t_ser_ := t_ser_();
--
subtype ST_ChartType is ploffx_util.t_string;
c_areaChart ST_ChartType := t_areaChart;
c_area3DChart ST_ChartType := t_area3DChart;
c_lineChart ST_ChartType := t_lineChart;
c_line3DChart ST_ChartType := t_line3DChart;
c_pieChart ST_ChartType := t_pieChart;
c_pie3DChart ST_ChartType := t_pie3DChart;
c_doughnutChart ST_ChartType := t_doughnutChart;
c_barChart ST_ChartType := t_barChart;
c_bar3DChart ST_ChartType := t_bar3DChart;
--
type t_axId_ is table of CT_UnsignedInt;
v_axId_empty t_axId_ := t_axId_();
-- CT_COMMONCHART
type CT_COMMONCHART is record(
  chart_type ST_ChartType,
  axId t_axId_,
  dLbls CT_dLblbs,
  dropLines CT_ChartLines,
  -- extLst
  gapDepth CT_GapAmount,
  ser t_ser_,
  varyColors CT_Boolean,
  --
  grouping_ CT_Grouping, -- barChart, bar3DChart,areaChart,area3DChart, lineChart, line3DChart
  gapWidth CT_GapAmount, -- barChart
  overlap CT_Overlap, -- barChart
  serLines CT_ChartLines, -- barChart
  barDir CT_BarDir, -- barChart
  shape CT_Shape, -- bar3DChart
  hiLowLines CT_ChartLines, -- lineChart
  marker CT_Boolean, -- lineChart
  smooth CT_Boolean, -- lineChart
  UpDownBars CT_UpDownBars, -- lineChart
  firstSliceAng              CT_FirstSliceAng, -- pieChart, doughnutChart
  holeSize CT_HoleSize -- doughnutChart
  );
-- CT_AreaChart
type CT_AreaChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART
  );
-- CT_Area3DChart
type CT_Area3DChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART
  );
-- CT_Bar3DChart
type CT_Bar3DChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART,
  gapWidth CT_GapAmount,
  shape CT_Shape,
  barDir CT_BarDir
  );
-- CT_BarChart
type CT_BarChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART,
  gapWidth CT_GapAmount,
  overlap CT_Overlap,
  serLines CT_ChartLines,
  barDir CT_BarDir
  );
-- CT_line3DChart
type CT_line3DChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART,
  gapDepth CT_GapAmount
  );
-- CT_lineChart
type CT_lineChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART,
  hiLowLines CT_ChartLines,
  marker CT_Boolean,
  smooth CT_Boolean,
  UpDownBars CT_UpDownBars
  );
-- CT_Pie3DChart
type CT_Pie3DChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART
  );
-- CT_PieChart
type CT_PieChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART,
  firstSliceAng CT_FirstSliceAng
  );
-- CT_DoughnutChart
type CT_DoughnutChart is record(
  tag plx_sc.normalv2,
  common CT_COMMONCHART,
  firstSliceAng CT_FirstSliceAng,
  holeSize CT_HoleSize
  );
-- CT_PlotArea
type CT_PlotArea is record(
  tag plx_sc.normalv2,
  commonChartProps CT_COMMONCHART,
  layout CT_Layout,
  catAx CT_CatAx,
  valAx CT_ValAx,
  spPr CT_ShapeProperties
  -- chart types
  --areaChart CT_AreaChart,
  --area3DChart CT_Area3DChart,
  --lineChart CT_LineChart,
  --line3DChart CT_Line3DChart,
  --pieChart CT_PieChart,
  --pie3DChart CT_Pie3DChart,
  --doughnutChart CT_DoughnutChart,
  --bar3DChart CT_Bar3DChart,
  --barChart CT_BarChart,
  -- dateAx
  -- serAx
  );
--ST_LegendPos
subtype ST_LegendPos is ploffx_util.t_string;
c_b_lgd constant ST_LegendPos := 'b';
c_l_lgd constant ST_LegendPos := 'l';
c_r_lgd constant ST_LegendPos := 'r';
c_t_lgd constant ST_LegendPos := 't';
c_tr_lgd constant ST_LegendPos := 'tr';
--CT_LegendPos
type CT_LegendPos is record(
  tag plx_sc.normalv2,
  val ST_LegendPos
);
--CT_Legend
type CT_Legend is record(
  tag plx_sc.normalv2,
  legendPos CT_LegendPos,
  layout CT_Layout,
  spPr CT_ShapeProperties
  );
-- CT_DepthPercent
type CT_DepthPercent is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_DepthPercent: 20-2000
  );
-- CT_hPercent
type CT_hPercent is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_HPercent: 5 - 500
  );
-- CT_Perspective
type CT_Perspective is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_Perspective 0 - 100
  );
-- CT_RotX
type CT_RotX is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_RotX -90 - 90
  );
-- CT_RoxY
type CT_RotY is recorD(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_RotY: 0 - 360
  );
-- CT_View3D
type CT_View3D is record(
  tag plx_sc.normalv2,
  depthPercent CT_DepthPercent,
  hPercent CT_HPercent,
  perspective CT_Perspective,
  rotX CT_RotX,
  rotY CT_RotY
  );
--CT_Chart
type CT_Chart is record(
  tag plx_sc.normalv2,
  plotVisOnly CT_Boolean,
  legend CT_Legend,
  plotArea CT_PlotArea,
  title CT_Title,
  view3D CT_View3D
  -- backWall
  -- floor
  -- sideWall
  );
--CT_ExternalData
type CT_ExternalData is record(
  tag plx_sc.normalv2,
  id plx_sc.normalv2, -- ST_RelationshipId
  autoUpdate CT_Boolean --v4.11
  );
--CT_TextLanguageID
type CT_TextLanguageID is record(
  tag plx_sc.normalv2,
  val plx_sc.normalv2 -- ST_TextLanguageID
  );
-- CT_PrintSettings
type CT_PrintSettings is record(
  tag plx_sc.normalv2,
  headerFooter CT_HeaderFooter,
  pageMargins CT_PageMargins,
  pageSetup CT_PageSetup
  );
-- CT_ChartSpace
type CT_ChartSpace is record(
  tag plx_sc.normalv2,
  lang CT_TextLanguageID,
  date1904 CT_Boolean,
  roundedCorners CT_Boolean,
  chart CT_Chart,
  spPr CT_ShapeProperties,
  externalData CT_ExternalData --v4.11
  -- style
  -- txPr
  -- userShapes
  -- protection
  );
--
type t_charts is table of CT_ChartSpace index by pls_integer;
/******************************************************************/
-- XML Writers
-- start
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
-- end
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );
-- chartSpace
-- v3.6.0
procedure startchartSpace(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_chartSpace
  );
--
procedure endchartSpace(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_chartSpace
  );
-- chart
-- v3.6.0
procedure startchart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_chart
  );
--
procedure endchart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_chart
  );
-- plotArea
-- v3.6.0
procedure startplotArea(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_plotArea
  );
--
procedure endplotArea(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_plotArea
  );
-- legend
-- v3.6.0
procedure startlegend(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_legend
  );
--
procedure endlegend(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_legend
  );
-- plotVisOnly
-- v3.6.0
procedure plotVisOnly(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_plotVisOnly,
  p_val varchar2 default null
  );
-- layout
-- v3.6.0
procedure startlayout(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_layout
  );
--
procedure endlayout(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_layout
  );
-- dougnutChart
-- v3.6.0
procedure startdougnutChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_doughnutChart
  );
--
procedure enddougnutChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_doughnutChart
  );
-- pie3DChart
-- v3.6.0
procedure startpie3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pie3DChart
  );
--
procedure endpie3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pie3DChart
  );
-- pieChart
-- v3.6.0
procedure startpieChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pieChart
  );
--
procedure endpieChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pieChart
  );
-- line3DChart
-- v3.6.0
procedure startline3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_line3DChart
  );
--
procedure endline3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_line3DChart
  );
-- lineChart
-- v3.6.0
procedure startlineChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lineChart
  );
--
procedure endlineChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lineChart
  );
-- area3DChart
-- v3.6.0
procedure startarea3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_area3DChart
  );
--
procedure endarea3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_area3DChart
  );
-- areaChart
-- v3.6.0
procedure startareaChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_areaChart
  );
--
procedure endareaChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_areaChart
  );
-- bar3DChart
-- v3.6.0
procedure startbar3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_bar3DChart
  );
--
procedure endbar3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_bar3DChart
  );
-- barChart
-- v3.6.0
procedure startbarChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_barChart
  );
--
procedure endbarChart(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_barChart
  );
-- catAx
-- v3.6.0
procedure startcatAx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_catAx
  );
--
procedure endcatAx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_catAx
  );
-- valAx
-- v3.6.0
procedure startvalAx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_valAx
  );
--
procedure endvalAx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_valAx
  );
-- barDir
-- v3.6.0
procedure barDir(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_barDir,
  p_val varchar2
  );
-- grouping
-- v3.6.0
procedure grouping_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_grouping,
  p_val varchar2
  );
-- ser
-- v3.6.0
procedure startser(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ser
  );
--
procedure endser(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ser
  );
-- idx
-- v3.6.0
procedure idx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_idx,
  p_val varchar2
  );
-- order
-- v3.6.0
procedure order_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_order,
  p_val varchar2
  );
-- tx
-- v3.6.0
procedure starttx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_tx
  );
--
procedure endtx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_tx
  );
-- cat
-- v3.6.0
procedure startcat(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cat
  );
--
procedure endcat(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_cat
  );
-- val
-- v3.6.0
procedure startval(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_val
  );
--
procedure endval(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_val
  );
-- strRef
-- v3.6.0
procedure startstrRef(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_strRef
  );
--
procedure endstrRef(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_strRef
  );
-- strCache
-- v3.6.0
procedure startstrCache(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_strCache
  );
--
procedure endstrCache(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_strCache
  );
-- ptCount
-- v3.6.0
procedure ptCount(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ptCount,
  p_val varchar2
  );
-- pt
-- v3.6.0
procedure startpt(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pt,
  p_idx varchar2
  );
--
procedure endpt(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pt
  );
-- v
-- v3.6.0
procedure startv(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_v
  );
--
procedure endv(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_v
  );
-- numRef
-- v3.6.0
procedure startnumRef(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numRef
  );
--
procedure endnumRef(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numRef
  );
-- numCache
-- v3.6.0
procedure startnumCache(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numCache
  );
--
procedure endnumCache(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numCache
  );
-- formatCode
-- v3.6.0
procedure startformatCode(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_formatCode
  );
--
procedure endformatCode(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_formatCode
  );
-- scaling
-- v3.6.0
procedure startscaling(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_scaling
  );
--
procedure endscaling(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_scaling
  );
-- orientation
-- v3.6.0
procedure orientation(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_orientation,
  p_val varchar2
  );
-- axPos
-- v3.6.0
procedure axPos(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_axPos,
  p_val varchar2
  );
-- tickLblPos
-- v3.6.0
procedure tickLblPos(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_tickLblPos,
  p_val varchar2
  );
-- crossAx
-- v3.6.0
procedure crossAx(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_crossAx,
  p_val varchar2
  );
-- crosses
-- v3.6.0
procedure crosses(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_crosses,
  p_val varchar2
  );
-- lblAlgn
-- v3.6.0
procedure lblAlgn(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lblAlgn,
  p_val varchar2
  );
-- lblOffset
-- v3.6.0
procedure lblOffset(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lblOffset,
  p_val varchar2
  );
-- majorGridlines
-- v3.6.0
procedure startmajorGridlines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_majorGridlines
  );
--
procedure endmajorGridlines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_majorGridlines
  );
-- numFmt
-- v3.6.0
procedure numFmt(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_numFmt,
  p_formatCode varchar2,
  p_sourceLinked varchar2
  );
-- crossBetween
-- v3.6.0
procedure crossBetween(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_crossBetween,
  p_val varchar2
  );
-- legendPos
-- v3.6.0
procedure legendPos(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_legendPos,
  p_val varchar2
  );
-- f
-- v3.6.0
procedure startf(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_f
  );
--
procedure endf(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_f
  );
-- title
-- v3.6.0
procedure starttitle(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_title
  );
--
procedure endtitle(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_title
  );
-- rich
-- v3.6.0
procedure startrich(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_rich
  );
--
procedure endrich(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_rich
  );
-- bodyPr
-- v3.6.0
procedure bodyPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_bodyPr,
  p_anchor varchar2 default null,
  p_anchorCtr varchar2 default null,
  p_vert varchar2 default null,
  p_rot varchar2 default null
  );
-- spPr
-- v3.6.0
procedure startspPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_spPr,
  p_bwMode varchar2 default null
  );
--
procedure endspPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_spPr
  );
-- solidFill
-- v3.6.0
procedure startsolidFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_solidFill
  );
--
procedure endsolidFill(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_solidFill
  );
-- ln
-- v3.6.0
procedure startln(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ln,
  p_cmpd varchar2 default null,
  p_w varchar2 default null
  );
--
procedure endln(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ln
  );
-- srgbClr
-- v3.6.0
procedure srgbClr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_srgbClr,
  p_val varchar2 default null
  );
-- sysClr
-- v3.6.0
procedure sysClr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_sysClr,
  p_val varchar2 default null,
  p_lastClr varchar2 default null
  );
-- prstDash
-- v3.6.0
procedure prstDash(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_f,
  p_val varchar2 default null
  );
-- schemeClr
-- v3.6.0
procedure startschemeClr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_schemeClr,
  p_val varchar2 default null
  );
--
procedure endSchemeClr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_schemeClr
  );
-- lumMod
-- v3.6.0
procedure lumMod(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lumMod
  );
-- lumOff
-- v3.6.0
procedure lumOff(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lumOff
  );
-- manualLayout
-- v3.6.0
procedure startmanualLayout(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_manualLayout
  );
--
procedure endmanualLayout(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_manualLayout
  );
-- xMode
-- v3.6.0
procedure xMode(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_xMode,
  p_val varchar2 default null
  );
-- yMode
-- v3.6.0
procedure yMode(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_yMode,
  p_val varchar2 default null
  );
-- x
-- v3.6.0
procedure x(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_x,
  p_val varchar2 default null
  );
-- y
-- v3.6.0
procedure y(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_y,
  p_val varchar2 default null
  );
-- w
-- v3.6.0
procedure w(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_w,
  p_val varchar2 default null
  );
-- h
-- v3.6.0
procedure h(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_h,
  p_val varchar2 default null
  );
-- axId
-- v3.6.0
procedure axId(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_axId,
  p_val varchar2 default null
  );
-- minorGridLines
-- v3.6.0
procedure startminorGridLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_minorGridLines
  );
--
procedure endminorGridLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_minorGridLines
  );
-- majorTickMark
-- v3.6.0
procedure majorTickMark(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_majorTickMark,
  p_val varchar2 default null
  );
-- minorTickMark
-- v3.6.0
procedure minorTickMark(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_minorTickMark,
  p_val varchar2 default null
  );
-- tickLblSkip
-- v3.6.0
procedure tickLblSkip(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_tickLblSkip,
  p_val varchar2 default null
  );
-- crossesAt
-- v3.6.0
procedure crossesAt(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_crossesAt,
  p_val varchar2 default null
  );
-- majorUnit
-- v3.6.0
procedure majorUnit(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_majorUnit,
  p_val varchar2 default null
  );
-- minorUnit
-- v3.6.0
procedure minorUnit(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_minorUnit,
  p_val varchar2 default null
  );
-- min
-- v3.6.0
procedure min_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_min,
  p_val varchar2 default null
  );
-- max
-- v3.6.0
procedure max_(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_max,
  p_val varchar2 default null
  );
-- dLbls
-- v3.6.0
procedure showVal(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_showVal,
  p_val varchar default null
  );
-- dLbls
-- v3.6.0
procedure startdLbls(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_dLbls
  );
--
procedure enddLbls(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_dLbls
  );
-- dLblPos
-- v3.6.0
procedure dLblPos(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_dLblPos,
  p_val varchar2 default null
  );
-- dropLines
-- v3.6.0
procedure startdropLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_dropLines
  );
--
procedure enddropLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_dropLines
  );
-- varyColors
-- v3.6.0
procedure varyColors(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_varyColors,
  p_val varchar2 default null
  );
-- overlap
-- v3.6.0
procedure overlap(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_varyColors,
  p_val varchar2 default null
  );
-- gapWidth
-- v3.6.0
procedure gapWidth(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_gapWidth,
  p_val varchar2 default null
  );
-- holeSize
-- v3.6.0
procedure holeSize(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_holeSize,
  p_val varchar2 default null
  );
-- firstSliceAng
-- v3.6.0
procedure firstSliceAng(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_firstSliceAng,
  p_val varchar2 default null
  );
-- updownbars
-- v3.6.0
procedure startupdownbars(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_updownBars
  );
--
procedure endupdownbars(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_updownBars
  );
-- smooth
-- v3.6.0
procedure smooth(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_smooth,
  p_val varchar2 default null
  );
-- marker
-- v3.6.0
procedure marker(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_marker,
  p_val varchar2 default null
  );
-- hiLowLines
-- v3.6.0
procedure starthiLowLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_hiLowLines
  );
--
procedure endhiLowLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_hiLowLines
  );
-- serLines
-- v3.6.0
procedure startserLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_serLines
  );
--
procedure endserLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_serLines
  );
-- shape
-- v3.6.0
procedure shape(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_shape,
  p_val varchar2 default null
  );
-- gapDepth
-- v3.6.0
procedure gapDepth(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_gapDepth,
  p_val varchar2 default null
  );
-- p
-- v3.6.0
procedure startp(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default ploffx_document_tag.t_p
  );
--
procedure endp(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default ploffx_document_tag.t_p
  );
-- r
-- v3.6.0
procedure startr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default ploffx_document_tag.t_r
  );
--
procedure endr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default ploffx_document_tag.t_r
  );
-- rpr
procedure startrPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default ploffx_document_tag.t_rPr,
  p_b varchar2 default null,
  p_cap varchar2 default null,
  p_i varchar2 default null,
  p_sz varchar2 default null
  );
--
procedure endrPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default ploffx_document_tag.t_rPr
  );
-- DefRPr
procedure startDefRPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_defRPr,
  p_b varchar2 default null,
  p_i varchar2 default null,
  p_sz varchar2 default null,
  p_cap varchar2 default null
  );
--
procedure endDefRPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_defRPr
  );
-- pPr
procedure startpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pPr
  );
--
procedure endpPr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_pPr
  );
-- latin
procedure latin(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_latin,
  p_typeface varchar2 default null
  );
-- t
procedure startt(
  p_tag varchar2 default ploffx_document_tag.t_t,
  p_xml in out plx_sc.type_xdoc,
  p_space varchar2 default null
  );
--
procedure endt(
  p_tag varchar2 default ploffx_document_tag.t_t,
  p_xml in out plx_sc.type_xdoc
  );
--v4.11
procedure startExternalData(
  p_tag varchar2 default t_ExternalData,
  p_xml in out plx_sc.type_xdoc,
  p_id varchar2 default null
  );
--v4.11
procedure endExternalData(
  p_tag varchar2 default t_ExternalData,
  p_xml in out plx_sc.type_xdoc
  );

/******************************************************************/
-- Create structure
-- ppr: CT_ParagraphProperties
function cr_PPr(
  p_tag varchar2 default t_ppr,
  p_defRPr CT_TextProperties default null
  ) return CT_ParagraphProperties;
-- minorUnit:CT_AxisUnit
function cr_minorUnit(
  p_tag varchar2 default t_minorUnit,
  p_val varchar2 default null
  ) return CT_AxisUnit;
-- majorUnit:CT_AxisUnit
function cr_majorUnit(
  p_tag varchar2 default t_majorUnit,
  p_val varchar2 default null
  ) return CT_AxisUnit;
-- tickLblSkip:CT_Skip
function cr_tickLblSkip(
  p_tag varchar2 default t_tickLblSkip,
  p_val varchar2 default null
  ) return CT_Skip;
--lblOffset:CT_LblOffset
--v3.2.0
function cr_lblOffset(
  p_tag varchar2 default t_lblOffset,
  p_val varchar2 default null
  ) return CT_LblOffset;
--lblAlgn:CT_LblAlgn
--v3.2.0
function cr_lblAlgn(
  p_tag varchar2 default t_lblAlgn,
  p_val ST_LblAlgn default null
  ) return CT_LblAlgn;
--crossBetween:CT_CrossBetween
--v3.2.0
function cr_crossBetween(
  p_tag varchar2 default t_crossBetween,
  p_val ST_CrossBetween default null
  ) return CT_CrossBetween;
--crossesAt:CT_UnsignedInt
function cr_crossesAt(
  p_tag varchar2 default t_crossesAt,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--crosses:CT_Crosses
--v3.2.0
function cr_crosses(
  p_tag varchar2 default t_crosses,
  p_val ST_Crosses default null
  ) return CT_Crosses;
--crossAx:CT_UnsignedInt
--v3.2.0
function cr_crossAx(
  p_tag varchar2 default t_crossAx,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--tickLblPos:CT_TickLblPos
--v3.2.0
function cr_tickLblPos(
  p_tag varchar2 default t_tickLblPos,
  p_val ST_AxPos default null
  ) return CT_TickLblPos;
--majorTickMark:CT_TickMark
--v3.2.0
function cr_majorTickMark(
  p_tag varchar2 default t_majorTickMark,
  p_val ST_TickMark default null
  ) return CT_TickMark;
--minorTickMark:CT_TickMark
--v4.1.0
function cr_minorTickMark(
  p_tag varchar2 default t_minorTickMark,
  p_val varchar2 default null
  ) return CT_TickMark;
--numFmt:CT_NumFmt
--v3.2.0
function cr_numFmt(
  p_tag varchar2 default t_numFmt,
  p_formatCode plx_sc.normalv2 default null,
  p_sourceLinked plx_sc.normalv2 default null
  ) return CT_NumFmt;
--minorGridLines:CT_ChartLines
--v3.2.0
function cr_minorGridlines(
  p_tag varchar2 default t_minorGridlines,
  p_spPr CT_ShapeProperties default null
  ) return CT_ChartLines;
--majorGridlines:CT_ChartLines
--v3.2.0
function cr_majorGridlines(
  p_tag varchar2 default t_majorGridlines,
  p_spPr CT_ShapeProperties default null
  ) return CT_ChartLines;
--axPos:CT_AxPos
--v3.2.0
function cr_axPos(
  p_tag varchar2 default t_axPos,
  p_val ST_AxPos default null
  ) return CT_AxPos;
--min:CT_UnsignedInt
function cr_min(
  p_tag varchar2 default t_min,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--max:CT_UnsignedInt
function cr_max(
  p_tag varchar2 default t_max,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--orientation:CT_Orientation
--v3.2.0
function cr_orientation(
  p_tag varchar2 default t_orientation,
  p_val ST_Orientation default null
  ) return CT_Orientation;
--scaling:CT_Scaling
--v3.2.0
function cr_Scaling(
  p_tag varchar2 default t_scaling,
  p_orientation CT_Orientation default null,
  p_min CT_UnsignedInt default null,
  p_max CT_UnsignedInt default null
  ) return CT_Scaling;
--axId:CT_UnsignedInt
--v3.2.0
function cr_axId(
  p_tag varchar2 default t_axId,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--valAx:CT_ValAx
--v3.2.0
function cr_valAx(
  p_tag varchar2 default t_valAx,
  p_axId CT_UnsignedInt default null,
  p_scaling CT_Scaling default null,
  p_axPos CT_AxPos default null,
  p_majorGridLines CT_ChartLines default null,
  p_minorGridLines CT_ChartLines default null,
  p_title CT_Title default null,
  p_numFmt CT_NumFmt default null,
  p_majorTickMark CT_TickMark default null,
  p_minorTickMart CT_TickMark default null,
  p_tickLblPos CT_TickLblPos default null,
  p_spPr CT_ShapeProperties default null,
  p_crossAx CT_UnsignedInt default null,
  p_crosses CT_Crosses default null,
  --auto CT_Boolean,
  p_crossesAt CT_UnsignedInt default null,
  p_crossBetween CT_CrossBetween default null,
  p_majorUnit CT_AxisUnit default null,
  p_minorUnit CT_AxisUnit default null
  ) return CT_ValAx;
--catAx:CT_CatAx
--v3.2.0
function cr_catAx(
  p_tag varchar2 default t_catAx,
  p_axId CT_UnsignedInt default null,
  p_scaling CT_Scaling default null,
  p_axPos CT_AxPos default null,
  p_majorGridLines CT_ChartLines default null,
  p_minorGridLines CT_ChartLines default null,
  p_title CT_Title default null,
  p_numFmt CT_NumFmt default null,
  p_majorTickMark CT_TickMark default null,
  p_minorTickMart CT_TickMark default null,
  p_tickLblPos CT_TickLblPos default null,
  p_spPr CT_ShapeProperties default null,
  p_crossAx CT_UnsignedInt default null,
  p_crosses CT_Crosses default null,
  --auto CT_Boolean,
  p_lblAlgn CT_LblAlgn default null,
  p_lblOffset CT_LblOffset default null,
  p_tickLblSkip CT_Skip default null
  ) return CT_CatAx;
--varyColors:CT_Boolean
function cr_varyColors(
  p_tag varchar2 default t_varyColors,
  p_val varchar2 default null
  ) return CT_Boolean;
-- formatCode:CT_String
-- v3.6.0
function cr_formatCode(
  p_tag varchar2 default t_formatCode,
  p_val varchar2 default null
  ) return CT_String;
--numCache:CT_NumData
--v3.2.0
function cr_numCache(
  p_tag varchar2 default t_numCache,
  p_formatCode plx_sc.normalv2 default null,
  p_ptCount CT_UnsignedInt default null,
  p_pt t_pt_ default null
  ) return CT_NumData;
--string:CT_String
--v3.2.0
function cr_string(
  p_tag varchar2 default null,
  p_val varchar2 default null
  ) return CT_String;
--numRef:CT_NumRef
--v3.2.0
function cr_numRef(
  p_tag varchar2 default t_numRef,
  p_f CT_String default null,
  p_numCache CT_NumData default null
  ) return CT_NumRef;
--val:CT_NumDataSourcea
--v3.2.0
function cr_val(
  p_tag varchar2 default t_val,
  p_numRef CT_NumRef default null
  ) return CT_NumDataSource;
--cat:CT_AxDataSource
--v3.2.0
function cr_cat(
  p_tag varchar2 default t_cat,
  p_strRef CT_StrRef default null
  ) return CT_AxDataSource;
--idx:CT_UnsignedInt
--v3.6.0
function cr_idx(
  p_tag varchar2 default t_idx,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--order:CT_UnsignedInt
--v3.6.0
function cr_order(
  p_tag varchar2 default t_order,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--ser:CT_Ser
--v3.2.0
function cr_ser(
  p_tag varchar2 default t_ser,
  p_cat CT_AxDataSource default null,
  p_dLbls CT_dLblbs default null,
  --dPt CT_DPt default null,
  --p_errBars CT_ErrBars default null,
  p_idx CT_UnsignedInt default null,
  p_order_ CT_UnsignedInt default null,
  p_pictureOptions CT_PictureOptions default null,
  p_spPr CT_ShapeProperties default null,
  p_trendLine CT_Trendline default null,
  p_tx CT_Tx default null,
  p_val CT_NumDataSource default null,
  p_invertIfNegative CT_Boolean default null, -- bar/bar3D
  p_marker CT_Boolean default null, -- line/line3D
  p_smooth CT_Boolean default null,
  p_explosion CT_UnsignedInt default null
  ) return CT_Ser;
--grouping:CT_Grouping
--v3.2.0
function cr_grouping(
  p_tag varchar2 default t_grouping,
  p_val ST_BarGrouping default null
  ) return CT_Grouping;
--gapDepth:CT_GapAmount
--v3.6.0
function cr_gapDepth(
  p_tag varchar2 default t_gapDepth,
  p_val varchar2 default null
  ) return CT_GapAmount;
--dropLines:CT_ChartLines
function cr_dropLines(
  p_tag varchar2 default t_dropLines,
  p_spPr CT_ShapeProperties default null
  ) return CT_ChartLines;
--dLblPos:CT_dLblPos
function cr_dLblPos(
  p_tag varchar2 default t_dLblPos,
  p_val ST_DLblPos default null
  ) return CT_DLblPos;
--showVal:CT_Boolean
--v3.6.0
function cr_showVal(
  p_tag varchar2 default t_showVal,
  p_val varchar2 default null
  ) return CT_Boolean;
-- dLbls:CT_dLblbs
function cr_dLbls(
  p_tag varchar2 default t_dLbls,
  p_dLblPos CT_DLblPos default null,
  p_showVal CT_Boolean default null
  ) return CT_dLblbs;
-- gapWidth:CT_GapAmount
function cr_gapWidth(
  p_tag varchar2 default t_gapWidth,
  p_val varchar2 default null
  ) return CT_GapAmount;
-- holeSize:CT_HoleSize
function cr_holeSize(
  p_tag varchar2 default t_holeSize,
  p_val varchar2 default null
  ) return CT_HoleSize;
-- firstSliceAng:CT_FirstSliceAng
function cr_firstSliceAng(
  p_tag varchar2 default t_firstSliceAng,
  p_val varchar2 default null
  ) return CT_FirstSliceAng;
-- doughnutChart:CT_DoughnutChart
function cr_doughnutChart(
  p_tag varchar2 default t_doughnutChart,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null,
  p_firstSliceAng CT_FirstSliceAng default null
  ) return CT_DoughnutChart;
-- pie3DChart:CT_Pie3DChart
function cr_pie3DChart(
  p_tag varchar2 default t_pie3DChart,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null
  ) return CT_Pie3DChart;
-- pieChart:CT_PieChart
function cr_pieChart(
  p_tag varchar2 default t_pieChart,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null
  ) return CT_PieChart;
-- line3DChart:CT_line3DChart
function cr_line3DChart(
  p_tag varchar2 default t_line3DChart,
  p_axId t_axId_ default null,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null
  ) return CT_line3DChart;
-- upDownBars: CT_UpDownBars
function cr_upDownBars(
  p_tag varchar2 default t_updownBars,
  p_gapWidth CT_GapAmount default null
  ) return CT_UpDownBars;
-- smooth:CT_Boolean
function cr_smooth(
  p_tag varchar2 default t_smooth,
  p_val varchar2 default null
  ) return CT_Boolean;
-- marker:CT_Boolean
function cr_marker(
  p_tag varchar2 default t_marker,
  p_val varchar2 default null
  ) return CT_Boolean;
-- hiLowLines:CT_ChartLines
function cr_hiLowLines(
  p_tag varchar2 default t_hiLowLines,
  p_spPr CT_ShapeProperties default null
  ) return CT_ChartLines;
-- lineChart:CT_lineChart
function cr_lineChart(
  p_tag varchar2 default t_lineChart,
  p_axId t_axId_ default null,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null,
  p_hiLowLines CT_ChartLines default null,
  p_marker CT_Boolean default null,
  p_smooth CT_Boolean default null,
  p_UpDownBars CT_UpDownBars default null
  ) return CT_lineChart;
-- area3DChart:CT_Area3DChart
function cr_area3DChart(
  p_tag varchar2 default t_area3DChart,
  p_axId t_axId_ default null,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null
  ) return CT_Area3DChart;
-- areaChart:CT_AreaChart
function cr_areaChart(
  p_tag varchar2 default t_areaChart,
  p_axId t_axId_ default null,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null
  ) return CT_AreaChart;
--serLines:CT_ChartLines
function cr_serLines(
  p_tag varchar2 default t_serLines,
  p_spPr CT_ShapeProperties default null
  ) return CT_ChartLines;
--shape:CT_Shape
function cr_shape(
  p_tag varchar2 default t_shape,
  p_val ST_Shape default null
  ) return CT_Shape;
--barDir:CT_BarDir
--v3.2.0
function cr_barDir(
  p_tag varchar2 default t_barDir,
  p_val ST_BarDir default null
  ) return CT_BarDir;
--bar3DChart:CT_Bar3DChart
-- v3.6.0
function cr_bar3DChart(
  p_tag varchar2 default t_bar3DChart,
  p_axId t_axId_ default null,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null,
  p_gapWidth CT_GapAmount default null,
  p_shape CT_Shape default null,
  p_barDir CT_BarDir default null
  ) return CT_Bar3DChart;
--overlap:CT_Overlap
-- v3.6.0
function cr_overlap(
  p_tag varchar2 default t_overlap,
  p_val varchar2 default null  -- ST_Overlap
  )return CT_Overlap;
--barChart:CT_BarChart
--v3.2.0
function cr_barChart(
  p_tag varchar2 default t_barChart,
  p_axId t_axId_ default null,
  p_dLbls CT_dLblbs default null,
  p_dropLines CT_ChartLines default null,
  p_gapDepth CT_GapAmount default null,
  p_grouping_ CT_Grouping default null,
  p_ser t_ser_ default null,
  p_varyColors CT_Boolean default null,
  p_gapWidth CT_GapAmount default null,
  p_overlap CT_Overlap default null,
  p_serLines CT_ChartLines default null,
  p_barDir CT_BarDir default null
  ) return CT_BarChart;
--plotarea:CT_PlotArea
--v3.2.0
function cr_plotArea(
  p_tag varchar2 default t_plotArea,
  p_layout CT_Layout default null,
  p_commonChartProps CT_CommonChart default null,
  p_catAx CT_CatAx default null,
  p_valAx CT_ValAx default null
  ) return CT_PlotArea;
-- h:CT_UnsignedInt
-- v3.6.0
function cr_h(
  p_tag varchar2 default t_h,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
-- w:CT_UnsignedInt
-- v3.6.0
function cr_w(
  p_tag varchar2 default t_w,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
-- y:CT_UnsignedInt
-- v3.6.0
function cr_y(
  p_tag varchar2 default t_y,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
-- x:CT_UnsignedInt
-- v3.6.0
function cr_x(
  p_tag varchar2 default t_x,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
-- yMode: CT_LayoutMode
-- v3.6.0
function cr_yMode(
  p_tag varchar2 default t_yMode,
  p_val ST_LayoutMode default null
  ) return CT_LayoutMode;
-- xMode: CT_LayoutMode
-- 3.6.0
function cr_xMode(
  p_tag varchar2 default t_xMode,
  p_val ST_LayoutMode default null
  ) return CT_LayoutMode;
-- manualLayout:CT_ManualLayout
-- v3.6.0
function cr_manualLayout(
  p_tag varchar2 default t_manualLayout,
  p_xMode CT_LayoutMode default null,
  p_yMode CT_LayoutMode default null,
  p_x CT_UnsignedInt default null,
  p_y CT_UnsignedInt default null,
  p_w CT_UnsignedInt default null,
  p_h CT_UnsignedInt default null
  ) return CT_ManualLayout;
--layout:CT_Layout
--v3.2.0
function cr_layout(
  p_tag varchar2 default t_layout,
  p_manualLayout CT_ManualLayout default null
  ) return CT_Layout;
-- legendPos:CT_LegendPos
-- v3.6.0
function cr_legendPos(
  p_tag varchar2 default t_legendPos,
  p_val ST_LegendPos default null
  ) return CT_LegendPos;
-- legend:CT_Legend
-- v3.6.0
function cr_legend(
  p_tag varchar2 default t_legend,
  p_legendPos CT_LegendPos default null
  ) return CT_Legend;
-- plotVisOnly
-- v3.6.0
function cr_plotVisOnly(
  p_tag varchar2 default t_plotVisOnly,
  p_val varchar2 default null
  ) return CT_Boolean;
--v:String
-- v3.6.0
function cr_v(
  p_tag varchar2 default t_v,
  p_val varchar2 default null
  ) return CT_String;
--pt:CT_StrVal
-- v3.6.0
function cr_pt(
  p_tag varchar2 default t_pt,
  p_v CT_String default null,
  p_idx plx_sc.normalv2 default null
  ) return CT_StrVal;
--ptCount:CT_UnsignedInt
-- v3.6.0
function cr_ptCount(
  p_tag varchar2 default t_ptCount,
  p_val varchar2 default null
  ) return CT_UnsignedInt;
--strCache:CT_StrData
-- v3.6.0
function cr_strCache(
  p_tag varchar2 default t_strCache,
  p_ptCount CT_UnsignedInt default null,
  p_pt t_pt_ default null
  ) return CT_StrData;
--f:xsd:String
-- v3.6.0
function cr_f(
  p_tag varchar2 default t_f,
  p_val varchar2 default null
  ) return CT_String;
--strRef:CT_StrRef
--v3.6.0
function cr_strRef(
  p_tag varchar2 default t_strRef,
  p_f CT_String default null,
  p_strCache CT_StrData default null
  ) return CT_StrRef;
--bodyPr:CT_TextBodyProperties
-- v3.6.0
function cr_bodyPr(
  p_tag varchar2 default t_bodyPr,
  p_anchor ST_TextAnchoringType default null,
  p_anchorCtr plx_sc.normalv2 default null,
  p_vert ST_TextVerticalType default null,
  p_rot plx_sc.normalv2 default null
  ) return CT_TextBodyProperties;
--rich:CT_TextBody
-- v3.6.0
function cr_rich(
  p_tag varchar2 default t_rich,
  p_bodyPr CT_TextBodyProperties default null,
  p_p t_textParagraph default null
  ) return CT_TextBody;
--tx:CT_Tx
--v3.6.0
function cr_tx(
  p_tag varchar2 default t_tx,
  p_rich CT_TextBody default null,
  p_strRef CT_StrRef default null
  ) return CT_Tx;
--title:CT_Title
-- v3.6.0
function cr_title(
   p_tag varchar2 default t_title,
   p_tx CT_Tx default null,
   p_txPr CT_TextBody default null
   ) return CT_Title;
--chart:CT_Chart
--v3.2.0
function cr_chart(
  p_tag varchar2 default t_chart,
  p_plotVisOnly CT_Boolean default null,
  p_legend CT_Legend default null,
  p_plotArea CT_PlotArea default null
  ) return CT_Chart;
--srgbClr:CT_SRgbColor
function cr_srgbClr(
  p_tag varchar2 default t_srgbClr,
  p_val varchar2 default null
  ) return CT_SRgbColor;
--sysClr:CT_SystemColor
function cr_sysClr(
  p_tag varchar2 default t_sysClr,
  p_val varchar2 default null,
  p_lastClr varchar2 default null
  ) return CT_SystemColor;
--schemeClr:CT_SchemeColor
function cr_schemeClr(
  p_tag varchar2 default t_schemeClr,
  p_val varchar2 default null
  ) return CT_SchemeColor;
--solidFill:CT_SolidColorFillProperties
function cr_solidFill(
  p_tag varchar2 default t_solidFill,
  p_srgbClr CT_SRgbColor default null,
  p_sysClr CT_SystemColor default null,
  p_schemeClr CT_SchemeColor default null
  ) return CT_SolidColorFillProperties;
--prstDash:CT_PresetLineDProperties
function cr_prstDash(
  p_tag varchar2 default t_prstDash,
  p_val varchar2 default null
  ) return CT_PresetLineDProperties;
--ln:CT_LineProperties
function cr_ln(
  p_tag varchar2 default t_ln,
  p_cmpd varchar2 default null,
  p_w varchar2 default null,
  p_solidFill CT_SolidColorFillProperties default null,
  p_prstDash CT_PresetLineDProperties default null
  ) return CT_LineProperties;
--spPr:CT_ShapeProperties
--v3.2.0
function cr_spPr(
  p_tag varchar2 default t_spPr,
  p_ln CT_LineProperties default null,
  p_solidFill CT_SolidColorFillProperties default null
  ) return CT_ShapeProperties;
--chartSpace:CT_ChartSpace
--v3.2.0
function cr_chartSpace(
  p_tag varchar2 default t_chartSpace,
  p_lang CT_TextLanguageID default null,
  p_chart CT_Chart default null,
  p_spPr CT_ShapeProperties default null
  ) return CT_ChartSpace;
-- DefRPr:CT_TextProperties
function cr_DefRPr(
  p_tag varchar2 default t_defRPr,
  p_b varchar2 default null,
  p_i varchar2 default null,
  p_sz varchar2 default null,
  p_solidFill CT_SolidColorFillProperties default null
  ) return CT_TextProperties;
-- p:CT_TextParagraph
-- v3.6.0
function cr_p(
  p_tag varchar2 default ploffx_document_tag.t_p,
  p_pPr CT_ParagraphProperties default null,
  p_r t_regularTextRun default null
  ) return CT_TextParagraph;
-- r:CT_RegularTextRun
function cr_r(
  p_tag varchar2 default ploffx_document_tag.t_r,
  p_rpr CT_TextProperties default null,
  p_t ploffx_document_type.CT_Text default null
  ) return CT_RegularTextRun;
-- rPr:CT_TextProperties
function cr_rPr(
  p_tag varchar2 default ploffx_document_tag.t_rPr,
  p_b varchar2 default null,
  p_cap varchar2 default null,
  p_i varchar2 default null,
  p_sz varchar2 default null
  ) return CT_TextProperties;
-- txPr:CT_TextBody
function cr_TxPr(
  p_tag varchar2 default t_txPr,
  p_bodyPr CT_TextBodyProperties default null,
  p_p t_textParagraph default null
  ) return CT_TextBody;
-- t: CT_Text
function cr_t(
  p_tag varchar2 default ploffx_document_tag.t_t,
  p_xml_space plx_sc.normalv2 default null,
  p_text plx_sc.normalv2 default null
  ) return ploffx_document_type.CT_Text;
--v4.11
function cr_externalData(
  p_tag varchar2 default t_externalData,
  p_id plx_sc.normalv2 default null
  ) return CT_externalData;
--v4.11
function cr_autoUpdate(
  p_tag varchar2 default t_autoUpdate,
  p_val plx_sc.normalv2 default null
  ) return CT_Boolean;

/******************************************************************/
-- Generate XML parts
-- addSer
function addSer(
  p_ser CT_Ser,
  p_table in out t_ser_
  ) return pls_integer;
-- addPt
function addPt(
  p_pt CT_StrVal,
  p_table in out t_pt_
  ) return pls_integer;
-- addP
function addP(
  p_p CT_TextParagraph,
  p_table in out t_textParagraph
  ) return pls_integer;
-- addR
procedure addR(
  p_r CT_RegularTextRun,
  p_table in out t_regularTextRun
  );
-- addAxId
procedure addAxId(
  p_axId CT_UnsignedInt,
  p_table in out t_axId_
  );
---------------------------------------------
-- v3.6.0
-- t_ser_
function ser_count(
  p_ser t_ser_
  ) return pls_integer;
---------------------------------------------
--DefRPr:CT_TextProperties
--v3.2.0
procedure gen_DefRPr(
  p_xml in out plx_sc.type_xdoc,
  p_defRPr CT_TextProperties
  );
---------------------------------------------
--latin:CT_TextFont
--v3.2.0
procedure gen_latin(
  p_xml in out plx_sc.type_xdoc,
  p_latin CT_TextFont
  );
---------------------------------------------
--rPr:CT_TextProperties
--v3.2.0
procedure gen_rPr(
  p_xml in out plx_sc.type_xdoc,
  p_rPr CT_TextProperties
  );
---------------------------------------------
--r:CT_RegularTextRun
--v3.2.0
procedure gen_r(
  p_xml in out plx_sc.type_xdoc,
  p_r CT_RegularTextRun
  );
---------------------------------------------
--p:CT_TextParagraph
--v3.2.0
procedure gen_p(
  p_xml in out plx_sc.type_xdoc,
  p_p CT_TextParagraph
  );
---------------------------------------------
--tickLblSkip:CT_Skip
--v3.2.0
procedure gen_tickLblSkip(
  p_xml in out plx_sc.type_xdoc,
  p_tickLblSkip CT_Skip
  );
---------------------------------------------
--lblOffset:CT_LblOffset
--v3.2.0
procedure gen_lblOffset(
  p_xml in out plx_sc.type_xdoc,
  p_lblOffset CT_LblOffset
  );
---------------------------------------------
--lblAlgn:CT_LblAlgn
--v3.2.0
procedure gen_lblAlgn(
  p_xml in out plx_sc.type_xdoc,
  p_lblAlgn CT_LblAlgn
  );
---------------------------------------------
--minorUnit:CT_AxisUnit
--v3.2.0
procedure gen_minorUnit(
  p_xml in out plx_sc.type_xdoc,
  p_minorUnit CT_AxisUnit
  );
---------------------------------------------
--majorUnit:CT_AxisUnit
--v3.2.0
procedure gen_majorUnit(
  p_xml in out plx_sc.type_xdoc,
  p_majorUnit CT_AxisUnit
  );
---------------------------------------------
--crossBetween:CT_CrossBetween
--v3.2.0
procedure gen_crossBetween(
  p_xml in out plx_sc.type_xdoc,
  p_crossBetween CT_CrossBetween
  );
---------------------------------------------
--crossesAt:CT_UnsignedInt
--v3.2.0
procedure gen_crossesAt(
  p_xml in out plx_sc.type_xdoc,
  p_crossesAt CT_UnsignedInt
  );
---------------------------------------------
--crosses:CT_Crosses
--v3.2.0
procedure gen_crosses(
  p_xml in out plx_sc.type_xdoc,
  p_crosses CT_Crosses
  );
---------------------------------------------
--crossAx:CT_UnsignedInt
--v3.2.0
procedure gen_crossAx(
  p_xml in out plx_sc.type_xdoc,
  p_crossAx CT_UnsignedInt
  );
---------------------------------------------
--tickLblPos:CT_TickLblPos
--v3.2.0
procedure gen_tickLblPos(
  p_xml in out plx_sc.type_xdoc,
  p_tickLblPos CT_TickLblPos
  );
---------------------------------------------
--minorTickMark:CT_TickMark
--v3.2.0
procedure gen_minorTickMark(
  p_xml in out plx_sc.type_xdoc,
  p_minorTickMark CT_TickMark
  );
---------------------------------------------
--majorTickMark:CT_TickMark
--v3.2.0
procedure gen_majorTickMark(
  p_xml in out plx_sc.type_xdoc,
  p_majorTickMark CT_TickMark
  );
---------------------------------------------
--numFmt:CT_NumFmt
--v3.2.0
procedure gen_numFmt(
  p_xml in out plx_sc.type_xdoc,
  p_numFmt CT_NumFmt
  );
---------------------------------------------
--minorGridLines:CT_ChartLines
--v3.2.0
procedure gen_minorGridLines(
  p_xml in out plx_sc.type_xdoc,
  p_minorGridLines CT_ChartLines
  );
---------------------------------------------
--majorGridLines:CT_ChartLines
--v3.2.0
procedure gen_majorGridLines(
  p_xml in out plx_sc.type_xdoc,
  p_majorGridLines CT_ChartLines
  );
---------------------------------------------
--axPos:CT_AxPos
--v3.2.0
procedure gen_axPos(
  p_xml in out plx_sc.type_xdoc,
  p_axPos CT_AxPos
  );
---------------------------------------------
--min:CT_UnsignedInt
--v3.2.0
procedure gen_min(
  p_xml in out plx_sc.type_xdoc,
  p_min CT_UnsignedInt
  );
---------------------------------------------
--max:CT_UnsignedInt
--v3.2.0
procedure gen_max(
  p_xml in out plx_sc.type_xdoc,
  p_max CT_UnsignedInt
  );
---------------------------------------------
--orientation:CT_Orientation
--v3.2.0
procedure gen_orientation(
  p_xml in out plx_sc.type_xdoc,
  p_orientation CT_Orientation
  );
---------------------------------------------
--scaling:CT_Scaling
--v3.2.0
procedure gen_scaling(
  p_xml in out plx_sc.type_xdoc,
  p_scaling CT_Scaling
  );
---------------------------------------------
--axId:CT_UnsignedInt
--v3.2.0
procedure gen_axId(
  p_xml in out plx_sc.type_xdoc,
  p_axId CT_UnsignedInt
  );
---------------------------------------------
--valAx:CT_valAx
--v3.2.0
procedure gen_valAx(
  p_xml in out plx_sc.type_xdoc,
  p_valAx CT_valAx
  );
---------------------------------------------
--catAx:CT_CatAx
--v3.2.0
procedure gen_catAx(
  p_xml in out plx_sc.type_xdoc,
  p_catAx CT_catAx
  );
---------------------------------------------
--numCache:CT_NumData
--v3.2.0
procedure gen_numCache(
  p_xml in out plx_sc.type_xdoc,
  p_numCache CT_NumData
  );
---------------------------------------------
--numRef:CT_NumRef
--v3.2.0
procedure gen_numRef(
  p_xml in out plx_sc.type_xdoc,
  p_numRef CT_NumRef
  );
---------------------------------------------
--val:CT_NumDataSource
--v3.2.0
procedure gen_val(
  p_xml in out plx_sc.type_xdoc,
  p_val CT_NumDataSource
  );
---------------------------------------------
--order:CT_UnsignedInt
--v3.2.0
procedure gen_order(
  p_xml in out plx_sc.type_xdoc,
  p_order CT_UnsignedInt
  );
---------------------------------------------
--idx:CT_UnsignedInt
--v3.2.0
procedure gen_idx(
  p_xml in out plx_sc.type_xdoc,
  p_idx CT_UnsignedInt
  );
---------------------------------------------
--cat:CT_AxDataSource
--v3.2.0
procedure gen_cat(
  p_xml in out plx_sc.type_xdoc,
  p_cat CT_AxDataSource
  );
---------------------------------------------
--ser:CT_ser
--v3.2.0
procedure gen_ser(
  p_xml in out plx_sc.type_xdoc,
  p_ser CT_Ser
  );
---------------------------------------------
--varyColors:CT_Boolean
--v3.2.0
procedure gen_varyColors(
  p_xml in out plx_sc.type_xdoc,
  p_varyColors CT_Boolean
  );
---------------------------------------------
--grouping:CT_Grouping
--v3.2.0
procedure gen_grouping(
  p_xml in out plx_sc.type_xdoc,
  p_grouping CT_Grouping
  );
---------------------------------------------
--gapDepth:CT_GapAmount
--v3.2.0
procedure gen_gapDepth(
  p_xml in out plx_sc.type_xdoc,
  p_gapDepth CT_GapAmount
  );
---------------------------------------------
--dropLines:CT_ChartLines
--v3.2.0
procedure gen_dropLines(
  p_xml in out plx_sc.type_xdoc,
  p_dropLines CT_ChartLines
  );
---------------------------------------------
--dLblPos:CT_DLblPos
--v3.2.0
procedure gen_dLblPos(
  p_xml in out plx_sc.type_xdoc,
  p_dLblPos CT_DLblPos
  );
---------------------------------------------
--showVal:CT_Boolean
--v3.2.0
procedure gen_showVal(
  p_xml in out plx_sc.type_xdoc,
  p_showVal CT_Boolean
  );
---------------------------------------------
--dLbls:CT_dLblbs
--v3.2.0
procedure gen_dLbls(
  p_xml in out plx_sc.type_xdoc,
  p_dLbls CT_dLblbs
  );
---------------------------------------------
--bardir:CT_BarDir
--v3.2.0
procedure gen_bardir(
  p_xml in out plx_sc.type_xdoc,
  p_bardir CT_BarDir
  );
---------------------------------------------
--shape:CT_Shape
--v3.2.0
procedure gen_shape(
  p_xml in out plx_sc.type_xdoc,
  p_shape CT_Shape
  );
---------------------------------------------
--serLines:CT_ChartLines
--v3.2.0
procedure gen_serLines(
  p_xml in out plx_sc.type_xdoc,
  p_serLines CT_ChartLines
  );

---------------------------------------------
--hilowlines:CT_ChartLines
--v3.2.0
procedure gen_hilowlines(
  p_xml in out plx_sc.type_xdoc,
  p_hilowlines CT_ChartLines
  );
---------------------------------------------
--marker:CT_Boolean
--v3.2.0
procedure gen_marker(
  p_xml in out plx_sc.type_xdoc,
  p_marker CT_Boolean
  );
---------------------------------------------
--smooth:CT_Boolean
--v3.2.0
procedure gen_smooth(
  p_xml in out plx_sc.type_xdoc,
  p_smooth CT_Boolean
  );
---------------------------------------------
--updownbars:CT_UpDownBars
--v3.2.0
procedure gen_updownbars(
  p_xml in out plx_sc.type_xdoc,
  p_updownbars CT_UpDownBars
  );
---------------------------------------------
--firstSliceAng:CT_FirstSliceAng
--v3.2.0
procedure gen_firstSliceAng(
  p_xml in out plx_sc.type_xdoc,
  p_firstSliceAng CT_FirstSliceAng
  );
---------------------------------------------
--holeSize:CT_HoleSize
--v3.2.0
procedure gen_holeSize(
  p_xml in out plx_sc.type_xdoc,
  p_holeSize CT_HoleSize
  );
---------------------------------------------
--gapWidth:CT_GapAmount
--v3.2.0
procedure gen_gapWidth(
  p_xml in out plx_sc.type_xdoc,
  p_gapWidth CT_GapAmount
  );
---------------------------------------------
--overlap:CT_dLblbs
--v3.2.0
procedure gen_overlap(
  p_xml in out plx_sc.type_xdoc,
  p_overlap CT_Overlap
  );
---------------------------------------------
--bar3DChart:CT_bar3DChart
--v3.2.0
procedure gen_bar3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_bar3DChart CT_COMMONCHART
  ) ;
---------------------------------------------
--barChart:CT_barChart
--v3.2.0
procedure gen_barChart(
  p_xml in out plx_sc.type_xdoc,
  p_barChart CT_COMMONCHART
  );
---------------------------------------------
--doughnutChart:CT_dougnutChart
--v3.2.0
procedure gen_doughnutChart(
  p_xml in out plx_sc.type_xdoc,
  p_doughnutChart CT_COMMONCHART
  );
---------------------------------------------
--pie3DChart:CT_pie3DChart
--v3.2.0
procedure gen_pie3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_pie3DChart CT_COMMONCHART
  );
---------------------------------------------
--pieChart:CT_pieChart
--v3.2.0
procedure gen_pieChart(
  p_xml in out plx_sc.type_xdoc,
  p_pieChart CT_COMMONCHART
  );
---------------------------------------------
--line3DChart:CT_line3DChart
--v3.2.0
procedure gen_line3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_line3DChart CT_COMMONCHART
  );
---------------------------------------------
--lineChart:CT_lineChart
--v3.2.0
procedure gen_lineChart(
  p_xml in out plx_sc.type_xdoc,
  p_lineChart CT_COMMONCHART
  );
---------------------------------------------
--area3DChart:CT_Area3DChart
--v3.2.0
procedure gen_area3DChart(
  p_xml in out plx_sc.type_xdoc,
  p_area3DChart CT_COMMONCHART
  );
---------------------------------------------
--areaChart:CT_AreaChart
--v3.2.0
procedure gen_areaChart(
  p_xml in out plx_sc.type_xdoc,
  p_areaChart CT_COMMONCHART
  );
---------------------------------------------
--plotArea:CT_PlotArea
--v3.2.0
procedure gen_plotArea(
  p_xml in out plx_sc.type_xdoc,
  p_plotArea CT_PlotArea
  );
---------------------------------------------
--prstDash:
--v3.2.0
procedure gen_prstDash(
  p_xml in out plx_sc.type_xdoc,
  p_prstDash CT_PresetLineDProperties
  );
---------------------------------------------
--schemeClr: CT_SchemeColor
--v3.2.0
procedure gen_schemeClr(
  p_xml in out plx_sc.type_xdoc,
  p_schemeClr CT_SchemeColor
  );
---------------------------------------------
--sysClr: CT_SystemColor
--v3.2.0
procedure gen_sysClr(
  p_xml in out plx_sc.type_xdoc,
  p_sysClr CT_SystemColor
  );
---------------------------------------------
--srgbClr: CT_SRgbColor
--v3.2.0
procedure gen_srgbClr(
  p_xml in out plx_sc.type_xdoc,
  p_srgbClr CT_SRgbColor
  );
---------------------------------------------
--ln: CT_LineProperties
--v3.2.0
procedure gen_ln(
  p_xml in out plx_sc.type_xdoc,
  p_ln CT_LineProperties
  );
---------------------------------------------
--solidFill: CT_SolidColorFillProperties
--v3.2.0
procedure gen_solidFill(
  p_xml in out plx_sc.type_xdoc,
  p_solidFill CT_SolidColorFillProperties
  );
---------------------------------------------
--spPr:CT_ShapeProperties
--v3.2.0
procedure gen_spPr(
  p_xml in out plx_sc.type_xdoc,
  p_spPr CT_ShapeProperties
  );
---------------------------------------------
--h:CT_UnsignedInt
--v3.2.0
procedure gen_h(
  p_xml in out plx_sc.type_xdoc,
  p_h CT_UnsignedInt
  );
---------------------------------------------
--w:CT_UnsignedInt
--v3.2.0
procedure gen_w(
  p_xml in out plx_sc.type_xdoc,
  p_w CT_UnsignedInt
  );
---------------------------------------------
--y:CT_UnsignedInt
--v3.2.0
procedure gen_y(
  p_xml in out plx_sc.type_xdoc,
  p_y CT_UnsignedInt
  );
---------------------------------------------
--x:CT_UnsignedInt
--v3.2.0
procedure gen_x(
  p_xml in out plx_sc.type_xdoc,
  p_x CT_UnsignedInt
  );
---------------------------------------------
--yMode:CT_LayoutMode
--v3.2.0
procedure gen_yMode(
  p_xml in out plx_sc.type_xdoc,
  p_yMode CT_LayoutMode
  );
---------------------------------------------
--xMode:CT_LayoutMode
--v3.2.0
procedure gen_xMode(
  p_xml in out plx_sc.type_xdoc,
  p_xMode CT_LayoutMode
  );
---------------------------------------------
--manualLayout:CT_manualLayout
--v3.2.0
procedure gen_manualLayout(
  p_xml in out plx_sc.type_xdoc,
  p_manualLayout CT_ManualLayout
  );
---------------------------------------------
--layout:CT_Layout
--v3.2.0
procedure gen_layout(
  p_xml in out plx_sc.type_xdoc,
  p_layout CT_Layout
  );
---------------------------------------------
--legendPos:CT_legend
--v3.2.0
procedure gen_legendPos(
  p_xml in out plx_sc.type_xdoc,
  p_legendPos CT_LegendPos
  );
---------------------------------------------
--legend:CT_Legend
--v3.2.0
procedure gen_legend(
  p_xml in out plx_sc.type_xdoc,
  p_legend CT_Legend
  );
---------------------------------------------
--plotVisOnly:CT_Boolean
--v3.2.0
procedure gen_plotVisOnly(
  p_xml in out plx_sc.type_xdoc,
  p_plotVisOnly CT_Boolean
  );
---------------------------------------------
--v:CT_String
--v3.2.0
procedure gen_v(
  p_xml in out plx_sc.type_xdoc,
  p_v CT_String
  );
---------------------------------------------
--pt:CT_StrVal
--v3.2.0
procedure gen_pt(
  p_xml in out plx_sc.type_xdoc,
  p_pt CT_StrVal
  );
---------------------------------------------
--ptCount:CT_UnsignedInt
--v3.2.0
procedure gen_ptCount(
  p_xml in out plx_sc.type_xdoc,
  p_ptCount CT_UnsignedInt
  );
---------------------------------------------
--strCache:CT_strCache
--v3.2.0
procedure gen_strCache(
  p_xml in out plx_sc.type_xdoc,
  p_strCache CT_StrData
  );
---------------------------------------------
--f:CT_String
--v3.2.0
procedure gen_f(
  p_xml in out plx_sc.type_xdoc,
  p_f CT_String
  );
---------------------------------------------
--strRef:CT_StrRef
--v3.2.0
procedure gen_strRef(
  p_xml in out plx_sc.type_xdoc,
  p_strRef CT_StrRef
  );
---------------------------------------------
--bodyPr:CT_TextBodyProperties
--v3.2.0
procedure gen_bodyPr(
  p_xml in out plx_sc.type_xdoc,
  p_bodyPr CT_TextBodyProperties
  );
---------------------------------------------
--rich:CT_TextBody
--v3.2.0
procedure gen_rich(
  p_xml in out plx_sc.type_xdoc,
  p_rich CT_TextBody
  );
---------------------------------------------
--tx:CT_Tx
--v3.2.0
procedure gen_tx(
  p_xml in out plx_sc.type_xdoc,
  p_tx CT_Tx
  );
---------------------------------------------
--title:CT_Title
--v3.2.0
procedure gen_title(
  p_xml in out plx_sc.type_xdoc,
  p_title CT_Title
  );
---------------------------------------------
--chart:CT_Chart
--v3.2.0
procedure gen_chart(
  p_xml in out plx_sc.type_xdoc,
  p_chart CT_Chart
  );
--v4.11
procedure gen_autoUpdate(
  p_xml in out plx_sc.type_xdoc,
  p_autoUpdate CT_Boolean
  );
--v4.11
procedure gen_externalData(
  p_xml in out plx_sc.type_xdoc,
  p_externalData ct_externalData
  );
--chartSpace:CT_ChartSpace
--v3.2.0
procedure gen_chartSpace(
  p_xml in out plx_sc.type_xdoc,
  p_chartSpace CT_ChartSpace
  );
-- GEN_XML
-- v3.2.0
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_chartSpace CT_ChartSpace
  );
---------------------------------------------
-- PARSE
--v3.2.0
function parse(
  p_file clob
  ) return CT_ChartSpace;
--------------------------------------------
end ploffx_chart;
/

