create or replace package ploffx_chart_api
authid current_user is
--v5.9
--
v_chartSpace ploffx_chart.CT_ChartSpace;
--
procedure init(
  p_type varchar2 -- required
  );
--
procedure setChartTitle(
  p_x number default null,
  p_y number default null,
  p_width number default null,
  p_height number default null,
  p_xMode varchar2 default null,
  p_yMode varchar2 default null,
  p_text varchar2,
  --
  p_angle number default null,
  p_caps varchar2 default null,
  p_font varchar2 default null,
  p_bold boolean default false,
  p_italic boolean default false,
  p_fontSize varchar2 default null,
  p_font_srgb_color varchar2 default null,
  p_font_sys_color varchar2 default null,
  p_font_scheme_color varchar2 default null,
  --
  p_bg_srgb_color varchar2 default null,
  p_bg_sys_color varchar2 default null,
  p_bg_scheme_color varchar2 default null,
  p_borderWidth varchar2 default null,
  p_border_srgb_color varchar2 default null,
  p_border_sys_color varchar2 default null,
  p_border_scheme_color varchar2 default null
  );
--
procedure setBarProperties(
  p_direction varchar2 default null,
  p_gap number default null,
  p_overlap number default null
  );
--
procedure setDatasetLabel(
  p_position varchar2
  );
--
procedure setChartDataLabels(
  p_position varchar2
  );
--v.11
procedure addSeries(
  p_formula varchar2, --v4.11
  p_name varchar2
  );
--
--v4.11
procedure addCategory(
  p_formula varchar2
  );
--v4.11
procedure addCategoryValue(
  p_name varchar2
  );
--v4.11
procedure AddValues(
  p_formula varchar2
  );
--v4.11
procedure AddValuesValue(
  p_value varchar2 default null
  );

procedure setXAxisTitle(
  p_x number default null,
  p_y number default null,
  p_width number default null,
  p_height number default null,
  p_xMode varchar2 default null,
  p_yMode varchar2 default null,
  p_text varchar2,
  p_angle number default null,
  p_cap varchar2 default null,
  p_font varchar2 default null,
  p_bold boolean default null,
  p_italic boolean default null,
  p_fontSize varchar2 default null,
  p_font_srgb_color varchar2 default null,
  p_font_sys_color varchar2 default null,
  p_font_scheme_color varchar2 default null
  );
--
procedure setXMajorGridLine(
  p_lineType varchar2 default null,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null,
  p_width varchar2 default null,
  p_dashType varchar2 default null,
  p_alpha pls_integer default null
  );
--
procedure setXMinorGridLine(
  p_lineType varchar2 default null,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null,
  p_width varchar2 default null,
  p_dashType varchar2 default null,
  p_alpha pls_integer default null
  );
--
procedure setXAxisScaling(
  p_min number default null,
  p_max number default null,
  p_orientation varchar2 default null
  );
--
procedure setXAxisPosition(
  p_position varchar2 default null
  );
--
procedure setXAxisLine(
  p_lineType varchar2 default null,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null,
  p_width varchar2 default null,
  p_dashType varchar2 default null,
  p_alpha pls_integer default null,
  p_crosses varchar2 default null,
  p_showAxis boolean default true
  );
--
procedure setXTickMarks(
  p_major varchar2 default null,
  p_minor varchar2 default null,
  p_labelPosition varchar2 default null,
  p_labelFormat varchar2 default null
  );
--
procedure setXLabels(
  p_align varchar2 default null,
  p_offset varchar2 default null,
  p_fontname varchar2 default null,
  p_fontsize varchar2 default null,
  p_bold boolean default false,
  p_italic boolean default false,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null
  );
--
procedure setYAxisTitle(
  p_x number default null,
  p_y number default null,
  p_width number default null,
  p_height number default null,
  p_xMode varchar2 default null,
  p_yMode varchar2 default null,
  p_text varchar2,
  p_angle number default null,
  p_cap varchar2 default null,
  p_font varchar2 default null,
  p_bold boolean default null,
  p_italic boolean default null,
  p_fontSize varchar2 default null,
  p_font_srgb_color varchar2 default null,
  p_font_sys_color varchar2 default null,
  p_font_scheme_color varchar2 default null
  );
--
procedure setYMajorGridLine(
  p_lineType varchar2 default null,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null,
  p_width varchar2 default null,
  p_dashType varchar2 default null,
  p_alpha pls_integer default null
  ) ;
--
procedure setYMinorGridLine(
  p_lineType varchar2 default null,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null,
  p_width varchar2 default null,
  p_dashType varchar2 default null,
  p_alpha pls_integer default null
  );
--
procedure setYAxisScaling(
  p_min number default null,
  p_max number default null,
  p_orientation varchar2 default null
  );
--
procedure setYAxisPosition(
  p_position varchar2 default null
  );
--
procedure setYAxisLine(
  p_lineType varchar2 default null,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null,
  p_width varchar2 default null,
  p_dashType varchar2 default null,
  p_alpha pls_integer default null,
  p_crosses varchar2 default null,
  p_showAxis boolean default true
  );
--
procedure setYUnitShift(
  p_major number default null, -- float,
  p_minor number default null -- float
  );
--
procedure setYTickMarks(
  p_major varchar2 default null,
  p_minor varchar2 default null,
  p_labelPosition varchar2 default null,
  p_labelFormat varchar2 default null
  );
--
procedure setYLabels(
  p_align varchar2 default null,
  p_offset varchar2 default null,
  p_fontname varchar2 default null,
  p_fontsize varchar2 default null,
  p_bold boolean default false,
  p_italic boolean default false,
  --p_underline varchar2 default null,
  p_srgb_color varchar2 default null,
  p_sys_color varchar2 default null,
  p_scheme_color varchar2 default null
  );
--
procedure addLegend(
  p_x number default null,
  p_y number default null,
  p_width number default null,
  p_height number default null,
  p_xMode varchar2 default null,
  p_yMode varchar2 default null,
  p_position varchar2 --
  );
--v4.11
procedure setexternalData(
  p_id varchar2 default null,
  p_autoUpdate varchar2 default null
  );
--
procedure setPlotAreaPosition(
  p_x number default null,
  p_y number default null,
  p_width number default null,
  p_height number default null,
  p_xMode varchar2 default null,
  p_yMode varchar2 default null
  );
--
end ploffx_chart_api;
/

