create or replace package ploffx_calcChain
authid current_user is
--v5.9
--
-- Namespace
ns constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/spreadsheetml/2006/main';
-- XML
g_xml plx_sc.type_xdoc;
-- Tag
t_calcChain constant plx_sc.normalv2 := 'calcChain';
t_c constant plx_sc.normalv2 := 'c'; --cell
--
c_filename constant plx_sc.normalv2 := 'xl/calcChain.xml';
--
type CT_CalcCell is record (
  tag plx_sc.normalv2, --c
  a plx_sc.normalv2, --array boolean
  i plx_sc.normalv2, --sheetId
  l plx_sc.normalv2, -- new dependency level boolean
  r plx_sc.normalv2, --cell reference: ST_CellRef
  s plx_sc.normalv2, --child chain boolean
  t plx_sc.normalv2 --new thread boolean
);
--
type t_calccells is table of CT_CalcCell;
v_calccells_empty t_calccells := t_calccells();
--
type CT_CalcChain is record (
  tag plx_sc.normalv2, --t_calcChain
  callcells t_calccells
  --extLst
  );
--
v_calcChain_empty CT_CalcChain;
--
c_a constant plx_sc.normalv2 := 'a';
c_i constant plx_sc.normalv2 := 'i';
c_l constant plx_sc.normalv2 := 'l';
c_r constant plx_sc.normalv2 := 'r';
c_s constant plx_sc.normalv2 := 's';
c_t constant plx_sc.normalv2 := 't';
--
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
--
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );
--
procedure startcalcChain(
  p_tag varchar2 default t_calcChain,
  p_xml in out nocopy plx_sc.type_xdoc
  );
--
procedure endcalcChain(
  p_tag varchar2 default t_calcChain,
  p_xml in out nocopy plx_sc.type_xdoc
  );
--
procedure startc(
  p_tag varchar2 default t_c,
  p_xml in out nocopy plx_sc.type_xdoc,
  p_a varchar2 default null, --array boolean
  p_i varchar2 default null, --sheetId
  p_l varchar2 default null, -- new dependency level boolean
  p_r varchar2 default null, --cell reference: ST_CellRef
  p_s varchar2 default null, --child chain boolean
  p_t varchar2 default null  --new thread boolean
  );
--
procedure endc(
  p_tag varchar2 default t_c,
  p_xml in out nocopy plx_sc.type_xdoc
  );
--
function cr_CalcCell(
  p_tag varchar2 default t_c,
  p_a varchar2 default null, --array boolean
  p_i varchar2 default null, --sheetId
  p_l varchar2 default null, -- new dependency level boolean
  p_r varchar2 default null, --cell reference: ST_CellRef
  p_s varchar2 default null, --child chain boolean
  p_t varchar2 default null  --new thread boolean
  ) return CT_CalcCell;
--
function cr_CalcChain(
  p_tag varchar2 default t_calcChain
  ) return CT_CalcChain;
--
procedure add_CalcCell(
  p_table in out t_calccells,
  p_CalcCell CT_CalcCell
  );
--
procedure gen_calcChain(
  p_xml in out nocopy plx_sc.type_xdoc,
  p_calcChain CT_CalcChain
  );
--
procedure gen_CalcCell(
  p_xml in out nocopy plx_sc.type_xdoc,
  p_CalcCell CT_CalcCell
  );
--
--
procedure gen_xml(
  p_xml in out nocopy plx_sc.type_xdoc,
  p_CalcChain CT_CalcChain
  );
--
--
function parse(
  p_file clob
  ) return CT_CalcChain;
--
end ploffx_calcChain;
/

