create or replace package ploffx_app
authid current_user is
-- v5.9
--
-- Namespaces
ns_extprops constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/extended-properties';
ns_vt constant plx_sc.normalv2 := 'http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes';
-- Prefixes
ns_vt_pref constant varchar2(2 char) := 'vt';
-- XML
g_xml plx_sc.type_xdoc;
-- Tag
t_Application constant plx_sc.normalv2 := 'Application';
t_AppVersion constant plx_sc.normalv2 := 'AppVersion';
t_Characters constant plx_sc.normalv2 := 'Characters';
t_CharactersWithSpaces constant plx_sc.normalv2 := 'CharactersWithSpaces';
t_Company constant plx_sc.normalv2 := 'Company';
t_DocSecurity constant plx_sc.normalv2 := 'DocSecurity';
t_HeadingPairs constant plx_sc.normalv2 := 'HeadingPairs';
t_HyperlinkBase constant plx_sc.normalv2 := 'HyperlinkBase'; -- v1.3.0
t_HiddenSlides constant plx_sc.normalv2 := 'HiddenSlides'; -- v1.3.0
t_HyperlinksChanged constant plx_sc.normalv2 := 'HyperlinksChanged';
t_Lines constant plx_sc.normalv2 := 'Lines';
t_LinksUpToDate constant plx_sc.normalv2 := 'LinksUpToDate';
t_Manager constant plx_sc.normalv2 := 'Manager'; -- v1.3.0
t_MMClips constant plx_sc.normalv2 := 'MMClips'; -- v1.3.0
t_Notes constant plx_sc.normalv2 := 'Notes'; -- v1.3.0
t_Pages constant plx_sc.normalv2 := 'Pages';
t_Paragraphs constant plx_sc.normalv2 := 'Paragraphs';
t_PresentationFormat constant plx_sc.normalv2 := 'PresentationFormat'; -- v1.3.0
t_Properties constant plx_sc.normalv2 := 'Properties';
t_ScaleCrop constant plx_sc.normalv2 := 'ScaleCrop';
t_Slides constant plx_sc.normalv2 := 'Slides'; -- v1.3.0
t_SharedDoc constant plx_sc.normalv2 := 'SharedDoc';
t_Template constant plx_sc.normalv2 := 'Template';
t_TitlesOfParts constant plx_sc.normalv2 := 'TitlesOfParts';
t_TotalTime constant plx_sc.normalv2 := 'TotalTime';
t_Words constant plx_sc.normalv2 := 'Words';
--
t_vector constant plx_sc.normalv2 := 'vector';
t_variant constant plx_sc.normalv2 := 'variant';
t_lpstr constant plx_sc.normalv2 := 'lpstr';
t_i4 constant plx_sc.normalv2 := 'i4';
-- Constants
c_filename constant plx_sc.normalv2 := 'docProps/app.xml' ;
--Structures
--v1.3.0
subtype ST_VectorBaseType  is ploffx_util.t_string;
  c_variant constant ST_VectorBaseType := 'variant';
  c_i1 constant ST_VectorBaseType := 'i1';
  c_i2 constant ST_VectorBaseType := 'i2';
  c_i4 constant ST_VectorBaseType := 'i4';
  c_i8 constant ST_VectorBaseType := 'i8';
  c_ui1 constant ST_VectorBaseType := 'ui1';
  c_ui2 constant ST_VectorBaseType := 'ui2';
  c_ui4 constant ST_VectorBaseType := 'ui4';
  c_ui8 constant ST_VectorBaseType := 'ui8';
  c_r4 constant ST_VectorBaseType := 'r4';
  c_r8 constant ST_VectorBaseType := 'r8';
  c_lpstr constant ST_VectorBaseType := 'lpstr';
  c_lpwstr constant ST_VectorBaseType := 'lpwstr';
  c_bstr constant ST_VectorBaseType := 'bstr';
  c_date constant ST_VectorBaseType := 'date';
  c_filetime constant ST_VectorBaseType := 'filetime';
  c_bool constant ST_VectorBaseType := 'bool';
  c_cy constant ST_VectorBaseType := 'cy';
  c_error constant ST_VectorBaseType := 'error';
  c_clsid constant ST_VectorBaseType := 'clsid';
--
type CT_Properties is record (
  tag plx_sc.normalv2, --v1.3.0
  Template plx_sc.normalv2, --xsd:string
  Manager plx_sc.normalv2, --xsd:string
  Company plx_sc.normalv2, --xsd:string
  Pages plx_sc.normalv2, --xsd:int
  Words plx_sc.normalv2, --xsd:int
  Characters plx_sc.normalv2, --xsd:int
  PresentationFormat plx_sc.normalv2, --xsd:string
  Lines plx_sc.normalv2, --xsd:int
  Paragraphs plx_sc.normalv2, --xsd:int
  Slides plx_sc.normalv2, --xsd:int
  Notes plx_sc.normalv2, --xsd:int
  TotalTime plx_sc.normalv2, --xsd:int
  HiddenSlides plx_sc.normalv2, --xsd:int
  MMClips plx_sc.normalv2, --xsd:int
  ScaleCrop plx_sc.normalv2, --xsd:boolean
  -- HeadingPairs CT_VectorVariant, --CT_VectorVariant TODO
  -- TitlesOfParts CT_VectorLpstr, --CT_VectorLpstr TODO
  LinksUpToDate plx_sc.normalv2, --xsd:boolean
  CharactersWithSpaces plx_sc.normalv2, --xsd:int
  SharedDoc plx_sc.normalv2, --xsd:boolean
  HyperlinkBase plx_sc.normalv2, --xsd:string
  -- HLinks CT_VectorVariant, --CT_VectorVariant TODO
  HyperlinksChanged plx_sc.normalv2, --xsd:boolean
  -- DigSig CT_DigSigBlob, --CT_DigSigBlob:xsd:base64Binary TODO
  Application plx_sc.normalv2, --xsd:string
  AppVersion plx_sc.normalv2, --xsd:string
  DocSecurity plx_sc.normalv2 --xsd:int
  );
--
--v_properties_empty CT_Properties;
-- start
procedure start_(
  p_xml in out plx_sc.type_xdoc
  );
-- end
procedure end_(
  p_xml in out plx_sc.type_xdoc
  );
-- Application
procedure startApplication(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Application
  );
--
procedure endApplication(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Application
  );
-- AppVersion
procedure startAppVersion(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_AppVersion
  );
--
procedure endAppVersion(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_AppVersion
  );
-- Characters
procedure startCharacters(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Characters
  );
--
procedure endCharacters(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Characters
  );
-- CharectersWithSpaces
procedure startCharectersWithSpaces(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_CharactersWithSpaces
  );
--
procedure endCharectersWithSpaces(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_CharactersWithSpaces
  );
-- Company
procedure startCompany(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Company
  );
--
procedure endCompany(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Company
  );
-- DocSecurity
procedure startDocSecurity(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_DocSecurity
  );
--
procedure endDocSecurity(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_DocSecurity
  );
-- HeadingPairs
procedure startHeadingPairs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HeadingPairs
  );
--
procedure endHeadingPairs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HeadingPairs
  );
-- HiddenSlides
procedure startHiddenSlides(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HiddenSlides
  );
--
procedure endHiddenSlides(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HiddenSlides
  );
-- HyperlinkBase
procedure startHyperlinkBase(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HyperlinkBase
  );
--
procedure endHyperlinkBase(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HyperlinkBase
  );
-- HyperlinksChanged
procedure startHyperlinksChanged(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HyperlinksChanged
  );
--
procedure endHyperlinksChanged(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_HyperlinksChanged
  );
-- Lines
procedure startLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Lines
  );
--
procedure endLines(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Lines
  );
-- LinksUpToDate
procedure startLinksUpToDate(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_LinksUpToDate
  );
--
procedure endLinksUpToDate(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_LinksUpToDate
  );
-- Manager
procedure startManager(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Manager
  );
--
procedure endManager(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Manager
  );
-- MMClips
procedure startMMClips(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_MMClips
  );
--
procedure endMMClips(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_MMClips
  );
-- Notes
procedure startNotes(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Notes
  );
--
procedure endNotes(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Notes
  );
-- Paragraphs
procedure startParagraphs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Paragraphs
  );
--
procedure endParagraphs(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Paragraphs
  );
-- Pages
procedure startPages(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Pages
  );
--
procedure endPages(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Pages
  );
-- PresentationFormat
procedure startPresentationFormat(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_PresentationFormat
  );
--
procedure endPresentationFormat(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_PresentationFormat
  );
-- Properties
procedure startProperties(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Properties
  );
--
procedure endProperties(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Properties
  );
-- ScaleCrop
procedure startScaleCrop(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ScaleCrop
  );
--
procedure endScaleCrop(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_ScaleCrop
  );
-- SharedDoc
procedure startSharedDoc(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_SharedDoc
  );
--
procedure endSharedDoc(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_SharedDoc
  );
-- Slides
procedure startSlides(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Slides
  );
--
procedure endSlides(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Slides
  );
-- Template
procedure startTemplate(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Template
  );
--
procedure endTemplate(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Template
  );
-- TitlesOfParts
procedure startTitlesOfParts(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_TitlesOfParts
  );
--
procedure endTitlesOfParts(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_TitlesOfParts
  );
-- TotalTime
procedure startTotalTime(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_TotalTime
  );
--
procedure endTotalTime(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_TotalTime
  );
-- Words
procedure startWords(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Words
  );
--
procedure endWords(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_Words
  );
-- Vector
procedure startvector(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_vector,
  p_baseType varchar2,
  p_size varchar2
  );
--
procedure endvector(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_vector
  );
-- Variant
procedure startvariant(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_variant
  );
--
procedure endvariant(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_variant
  );
-- lpstr
procedure startlpstr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lpstr
  );
--
procedure endlpstr(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_lpstr
  );
-- i4
procedure starti4(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_i4
  );
--
procedure endi4(
  p_xml in out plx_sc.type_xdoc,
  p_tag varchar2 default t_i4
  );
-- Create structure
---------------------------------------------
--Properties:CT_Properties
--create structure
--v1.3.0
function cr_Properties(
  p_tag varchar2 default t_Properties,
  p_Template plx_sc.normalv2 default null, --xsd:string
  p_Manager plx_sc.normalv2 default null, --xsd:string
  p_Company plx_sc.normalv2 default null, --xsd:string
  p_Pages plx_sc.normalv2 default null, --xsd:int
  p_Words plx_sc.normalv2 default null, --xsd:int
  p_Characters plx_sc.normalv2 default null, --xsd:int
  p_PresentationFormat plx_sc.normalv2 default null, --xsd:string
  p_Lines plx_sc.normalv2  default null, --xsd:int
  p_Paragraphs plx_sc.normalv2 default null, --xsd:int
  p_Slides plx_sc.normalv2 default null, --xsd:int
  p_Notes plx_sc.normalv2 default null, --xsd:int
  p_TotalTime plx_sc.normalv2 default null, --xsd:int
  p_HiddenSlides plx_sc.normalv2 default null, --xsd:int
  p_MMClips plx_sc.normalv2 default null, --xsd:int
  p_ScaleCrop plx_sc.normalv2 default null, --xsd:boolean
  -- HeadingPairs CT_VectorVariant, --CT_VectorVariant TODO
  -- TitlesOfParts CT_VectorLpstr, --CT_VectorLpstr TODO
  p_LinksUpToDate plx_sc.normalv2 default null, --xsd:boolean
  p_CharactersWithSpaces plx_sc.normalv2 default null, --xsd:int
  p_SharedDoc plx_sc.normalv2 default null, --xsd:boolean
  p_HyperlinkBase plx_sc.normalv2 default null, --xsd:string
  -- HLinks CT_VectorVariant, --CT_VectorVariant TODO
  p_HyperlinksChanged plx_sc.normalv2 default null, --xsd:boolean
  -- DigSig CT_DigSigBlob, --CT_DigSigBlob:xsd:base64Binary TODO
  p_Application plx_sc.normalv2 default null, --xsd:string
  p_AppVersion plx_sc.normalv2 default null, --xsd:string
  p_DocSecurity plx_sc.normalv2 default null --xsd:int
  ) return CT_Properties;
---------------------------------------------
-- Generate XML parts
--
--Template:plx_sc.normalv2
--v1.3.0
procedure gen_Template(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Company:plx_sc.normalv2
--v1.3.0
procedure gen_Company(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Pages:plx_sc.normalv2
--v1.3.0
procedure gen_Pages(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Words:plx_sc.normalv2
--v1.3.0
procedure gen_Words(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Characters:plx_sc.normalv2
--v1.3.0
procedure gen_Characters(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Lines:plx_sc.normalv2
--v1.3.0
procedure gen_Lines(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Paragraphs:plx_sc.normalv2
--v1.3.0
procedure gen_Paragraphs(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--TotalTime:plx_sc.normalv2
--v1.3.0
procedure gen_TotalTime(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--ScaleCrop:plx_sc.normalv2
--v1.3.0
procedure gen_ScaleCrop(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--LinksUpToDate:plx_sc.normalv2
--v1.3.0
procedure gen_LinksUpToDate(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--CharactersWithSpaces:plx_sc.normalv2
--v1.3.0
procedure gen_CharactersWithSpaces(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--SharedDoc:plx_sc.normalv2
--v1.3.0
procedure gen_SharedDoc(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--HyperlinksChanged:plx_sc.normalv2
--v1.3.0
procedure gen_HyperlinksChanged(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Application:plx_sc.normalv2
--v1.3.0
procedure gen_Application(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--AppVersion:plx_sc.normalv2
--v1.3.0
procedure gen_AppVersion(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--DocSecurity:plx_sc.normalv2
--v1.3.0
procedure gen_DocSecurity(
  p_xml in out plx_sc.type_xdoc,
  p_val plx_sc.normalv2
  );
---------------------------------------------
--Properties:CT_Properties
--v1.3.0
procedure gen_Properties(
  p_xml in out plx_sc.type_xdoc,
  p_properties CT_Properties
  );
---------------------------------------------
-- GEN_XML
-- v1.3.0
procedure gen_xml(
  p_xml in out plx_sc.type_xdoc,
  p_Properties CT_Properties
  );
---------------------------------------------
-- Parse and preprocessed parts
-- PARSE
--v1.3.0
function parse(
  p_file clob
  ) return CT_Properties;
--v4.10
procedure docx_app_init(
  p_company varchar2 default null,
  p_manager varchar2 default null,
  p_Properties in out CT_Properties
  );
--v1.3.0
procedure xlsx_docPropsappxml(
  p_xml in out plx_sc.type_xdoc,
  p_first_sheet pls_integer,
  p_last_sheet pls_integer
  );
--
end ploffx_app;
/

