create or replace package plzip as

/**
<config>
  <pck-name>PL/ZIP</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v1.1.0</pck-version>
   <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
</config>
*/

/**
<h1>Introdution</h1>
<br/>
<p>
  PL/ZIP is a PL/SQL package for creating ZIP files. The method consist of three easy steps, create new archive,
  add files and finally save the complete ZIP. TRIAL limitation is a Random message: It''s not error! Certification is TRIAL!
</p>
<br/>
<h2>Installation</h2>
<p>
System requirements: Oracle 10g RDBMS Release 2 or higher. Oracle 10g Express Edition is supported.
</p>
<br/>
*/

/**
<newpage/>
<h1>Procedures and Functions </h1>
<br/>
*/

/**
<name>GetVersion</name>
<type>function</type>
<desc>
Gets the version number of PL/ZIP package.
</desc>
<version>v1.0.0</version>
<params>-</params>
<return>
  <return-def>varchar2</return-def>
  <return-desc>number of current version</return-desc>
</return>
*/
function getVersion return varchar2;

/**
<name>createNewZip</name>
<type>Procedure</type>
<desc>
  Initializes the package, creates a new zip archive.
</desc>
<version>v1.0.0</version>
<params>-</params>
<return>-</return>
*/
procedure createNewZip;

/**
<name>addFile</name>
<type>Procedure</type>
<desc>
  Adds a file to the ZIP archive. To place a file into a subdirectory inside the ZIP archive, set the full path as p_filename.
</desc>
<version>v1.0.0</version>
<params>
  <param>
   <param-def>p_filename varchar2</param-def>
   <param-desc>[<i>path/</i>]name of the file</param-desc>
  </param>
  <param>
   <param-def>p_file varchar2</param-def>
   <param-desc>file</param-desc>
  </param>
</params>
<return>-</return>
*/
procedure addFile(
  p_filename varchar2,
  p_file blob
  );

/**
<name>saveZip</name>
<type>Function</type>
<desc>
  Builds entries to ZIP file format.
</desc>
<version>v1.0.0</version>
<params>-</params>
<return>
  <return-def>blob</return-def>
  <return-desc>The ZIP archive</return-desc>
</return>
*/
function saveZip
  return blob;

end plzip;
/

create or replace package body plzip wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
b
9200000
1
4
0 
82
2 :e:
1PACKAGE:
1BODY:
1PLZIP:
1G_VERSION:
1CONSTANT:
1VARCHAR2:
1CHAR:
15:
14.9.0:
1V_BLOB_FILE:
1BLOB:
1FUNCTION:
1GETVERSION:
1RETURN:
1RAISE_ERROR:
1P_MSG:
1RAISE_APPLICATION_ERROR:
1-:
120000:
1CR_ERROR:
1P_CODE:
1P_1:
1L_MSG:
1255:
1=:
1301:
1Stream error:: &1.:
1ELSIF:
1302:
1Buffer error:: &1.:
1303:
1Data error:: &1.:
1IS NOT NULL:
1REPLACE:
1&1:
1SUBSTR:
1ERR-:
1||:
1 :
11:
1P_PROC:
1ERROR:: proc:::
1,msg:: :
1CREATENEWZIP:
1DBMS_LOB:
1CREATETEMPORARY:
1TRUE:
1LITTLE_ENDIAN:
1P_BIG:
1NUMBER:
1P_BYTES:
1PLS_INTEGER:
14:
1RAW:
1L_BIG:
1>:
12147483647:
14294967296:
1UTL_RAW:
1CAST_FROM_BINARY_INTEGER:
1ADDFILE:
1P_FILENAME:
1P_FILE:
1L_NOW:
1DATE:
1L_BLOB:
1L_CLEN:
1INTEGER:
1SYSDATE:
1UTL_COMPRESS:
1LZ_COMPRESS:
1GETLENGTH:
1APPEND:
1CONCAT:
1HEXTORAW:
1504B0304:
11400:
10000:
10800:
1TO_NUMBER:
1TO_CHAR:
1ss:
1/:
12:
1+:
1mi:
1*:
132:
1hh24:
12048:
1dd:
1mm:
1yyyy:
11980:
1512:
17:
118:
1LENGTH:
1CAST_TO_RAW:
1COPY:
111:
1FREETEMPORARY:
1ADDPRECOMPRESSEDFILE:
1P_CRC32:
1P_OSIZE:
1CREATEPRECOMPRESSEDFILE:
1P_CFILE:
1OUT:
1NOCOPY:
1SAVEZIP:
1L_CNT:
10:
1L_OFFS:
1L_OFFS_DIR_HEADER:
1L_OFFS_END_HEADER:
1L_COMMENT:
132767:
1PL/PDF PL/ZIP:
1L_SS:
1INSTR:
1WHILE:
1LOOP:
1504B0102:
126:
10100:
12000B681:
1CAST_TO_BINARY_INTEGER:
130:
1504B0506:
1NVL:
0

0
0
35d
2
0 :2 a0 97 87 :3 a0 51 a5 1c
6e 1b b0 a3 a0 1c 81 b0
a0 8d a0 b4 a0 2c 6a :2 a0
65 b7 a4 b1 11 68 4f 9a
8f a0 b0 3d b4 55 6a a0
7e 51 b4 2e a0 a5 57 b7
a4 b1 11 68 4f 9a 8f a0
b0 3d 8f a0 b0 3d b4 55
6a a3 :2 a0 51 a5 1c 81 b0
a0 7e 6e b4 2e a0 6e d
a0 b7 a0 7e 6e b4 2e a0
6e d a0 b7 19 a0 7e 6e
b4 2e a0 6e d b7 :2 19 3c
a0 7e b4 2e :3 a0 6e a0 a5
b d b7 19 3c :2 a0 6e 7e
a0 b4 2e 7e 6e b4 2e 7e
a0 b4 2e :2 51 a5 b d a0
7e 51 b4 2e a0 a5 57 b7
a4 b1 11 68 4f 9a 8f a0
b0 3d 8f a0 b0 3d b4 55
6a a0 7e 51 b4 2e 6e 7e
a0 b4 2e 7e 6e b4 2e 7e
a0 b4 2e a5 57 b7 a4 b1
11 68 4f 9a b4 55 6a :2 a0
6b :2 a0 a5 57 b7 a4 b1 11
68 4f a0 8d 8f a0 b0 3d
8f a0 51 b0 3d b4 :2 a0 2c
6a a3 a0 1c 81 b0 :2 a0 d
a0 7e 51 b4 2e :2 a0 7e 51
b4 2e d b7 19 3c :3 a0 6b
:2 a0 6b :3 a0 6b a5 b 51 a0
a5 b 65 b7 a4 b1 11 68
4f 9a 8f a0 b0 3d 8f a0
b0 3d b4 55 6a a3 a0 1c
81 b0 a3 a0 1c 81 b0 a3
a0 1c 81 b0 :2 a0 d :3 a0 6b
a0 a5 b d :3 a0 6b a0 a5
b d :2 a0 6b :3 a0 6b a0 6e
a5 b a0 6e a5 b a0 6e
a5 b a0 6e a5 b :4 a0 6e
a5 b a5 b 7e 51 b4 2e
7e :3 a0 6e a5 b a5 b 7e
51 b4 2e b4 2e 7e :3 a0 6e
a5 b a5 b 7e 51 b4 2e
b4 2e 51 a5 b :4 a0 6e a5
b a5 b 7e :3 a0 6e a5 b
a5 b 7e 51 b4 2e b4 2e
7e :3 a0 6e a5 b a5 b 7e
51 b4 2e 5a 7e 51 b4 2e
b4 2e 51 a5 b :2 a0 6b a0
51 a0 7e 51 b4 2e a5 b
:2 a0 7e 51 b4 2e a5 b :3 a0
6b a0 a5 b a5 b :3 a0 a5
b 51 a5 b a0 6e a5 b
:2 a0 6b a0 a5 b a5 b a5
57 :2 a0 6b :3 a0 7e 51 b4 2e
:2 a0 6b a0 a5 b 7e 51 b4
2e 51 a5 57 :2 a0 6b a0 a5
57 b7 a4 b1 11 68 4f 9a
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
b4 55 6a 4f b7 a4 b1 11
68 4f 9a 8f a0 b0 3d 96
:3 a0 b0 54 96 :3 a0 b0 54 96
:3 a0 b0 54 b4 55 6a 4f b7
a4 b1 11 68 4f a0 8d a0
b4 a0 2c 6a a3 a0 1c 51
81 b0 a3 a0 1c 81 b0 a3
a0 1c 81 b0 a3 a0 1c 81
b0 a3 a0 51 a5 1c :2 a0 6b
6e a5 b 81 b0 a3 a0 1c
81 b0 :3 a0 6b a0 a5 b d
:3 a0 6b :2 a0 6e a5 b 51 a5
b d :2 a0 7e 51 a0 b4 2e
82 :2 a0 7e 51 b4 2e d :2 a0
6b :3 a0 6b a0 6e a5 b a0
6e a5 b :2 a0 6b a0 51 a0
7e 51 b4 2e a5 b a0 6e
a5 b a0 6e a5 b a0 6e
a5 b a0 6e a5 b :2 a0 7e
51 b4 2e a5 b :2 a0 6b :3 a0
6b :2 a0 6b a0 51 a0 7e 51
b4 2e a5 b :2 a0 6b a5 b
a0 7e 51 b4 2e a5 b a5
b a5 57 :3 a0 6b :2 a0 6e a5
b a0 7e 51 b4 2e a5 b
d b7 a0 47 :3 a0 6b a0 a5
b d :2 a0 6b :3 a0 6b a0 6e
a5 b a0 6e a5 b a0 6e
a5 b :2 a0 51 a5 b :2 a0 51
a5 b :2 a0 7e a0 b4 2e a5
b :2 a0 a5 b :4 a0 6b a0 a5
b 51 a5 b 51 a5 b a0
a5 b a5 57 :2 a0 65 b7 a4
b1 11 68 4f b1 b7 a4 11
a0 b1 56 4f 1d 17 b5 
35d
2
0 3 7 b 3a 19 1d 21
25 28 29 31 36 18 56 45
49 51 15 41 5d 71 75 76
7a 7e 82 86 8a 8e 90 94
96 a2 a6 a8 c4 c0 bf cc
bc d1 d5 d9 dd e0 e3 e4
e9 ed ee f3 f5 f9 fb 107
10b 10d 129 125 124 131 13e 13a
121 146 139 14b 14f 16d 157 15b
136 15f 160 168 156 174 153 178
17d 17e 183 187 18c 190 194 196
19a 19d 1a2 1a3 1a8 1ac 1b1 1b5
1b9 1bb 1bf 1c3 1c6 1cb 1cc 1d1
1d5 1da 1de 1e0 1e4 1e8 1eb 1ef
1f2 1f3 1f8 1fc 200 204 209 20d
20e 210 214 216 21a 21d 221 225
22a 22d 231 232 237 23a 23f 240
245 248 24c 24d 252 255 258 259
25b 25f 263 266 269 26a 26f 273
274 279 27b 27f 281 28d 291 293
2af 2ab 2aa 2b7 2c4 2c0 2a7 2cc
2bf 2d1 2d5 2d9 2bc 2dd 2e0 2e1
2e6 2eb 2ee 2f2 2f3 2f8 2fb 300
301 306 309 30d 30e 313 314 319
31b 31f 321 32d 331 333 347 348
34c 350 354 358 35b 35f 363 364
369 36b 36f 371 37d 381 383 387
3a3 39f 39e 3ab 3b8 3b4 39b 3b3
3c0 3b0 3c5 3c9 3cd 3d1 3ea 3d9
3dd 3e5 3d8 3f1 3f5 3f9 3fd 3d5
401 404 405 40a 40e 412 415 418
419 41e 422 424 428 42b 42f 433
437 43a 43e 442 445 449 44d 451
454 455 457 45a 45e 45f 461 465
467 46b 46d 479 47d 47f 49b 497
496 4a3 4b0 4ac 493 4b8 4ab 4bd
4c1 4da 4c9 4cd 4d5 4a8 4f2 4e1
4e5 4ed 4c8 50e 4fd 501 509 4c5
4f9 515 519 51d 521 525 529 52c
530 531 533 537 53b 53f 543 546
54a 54b 54d 551 555 559 55c 560
564 568 56b 56f 574 575 577 57b
580 581 583 587 58c 58d 58f 593
598 599 59b 59f 5a3 5a7 5ab 5b0
5b1 5b3 5b4 5b6 5b9 5bc 5bd 5c2
5c5 5c9 5cd 5d1 5d6 5d7 5d9 5da
5dc 5df 5e2 5e3 5e8 5e9 5ee 5f1
5f5 5f9 5fd 602 603 605 606 608
60b 60e 60f 614 615 61a 61d 61e
620 624 628 62c 630 635 636 638
639 63b 63e 642 646 64a 64f 650
652 653 655 658 65b 65c 661 662
667 66a 66e 672 676 67b 67c 67e
67f 681 684 687 688 68d 690 693
696 697 69c 69d 6a2 6a5 6a6 6a8
6ac 6b0 6b3 6b7 6ba 6be 6c1 6c4
6c5 6ca 6cb 6cd 6d1 6d5 6d8 6db
6dc 6e1 6e2 6e4 6e8 6ec 6f0 6f3
6f7 6f8 6fa 6fb 6fd 701 705 709
70a 70c 70f 710 712 716 71b 71c
71e 722 726 729 72d 72e 730 731
733 734 739 73d 741 744 748 74c
750 753 756 757 75c 760 764 767
76b 76c 76e 771 774 775 77a 77d
77e 783 787 78b 78e 792 793 798
79a 79e 7a0 7ac 7b0 7b2 7ce 7ca
7c9 7d6 7e3 7df 7c6 7eb 7f4 7f0
7de 7fc 809 805 7db 811 804 816
81a 801 81e 820 824 826 832 836
838 854 850 84f 85c 871 865 869
86d 84c 878 889 87d 881 885 864
890 8a5 899 89d 8a1 861 8ac 898
8b1 8b5 895 8b9 8bb 8bf 8c1 8cd
8d1 8d3 8d7 8eb 8ef 8f0 8f4 8f8
914 900 904 90c 90f 8ff 930 91f
923 92b 8fc 948 937 93b 943 91e
964 953 957 95f 91b 993 96b 96f
972 973 97b 97f 983 986 98b 98c
98e 952 9af 99e 9a2 9aa 94f 99a
9b6 9ba 9be 9c1 9c5 9c6 9c8 9cc
9d0 9d4 9d8 9db 9df 9e3 9e8 9e9
9eb 9ee 9ef 9f1 9f5 9f9 9fd a00
a03 a07 a08 a0d a0f a13 a17 a1a
a1d a1e a23 a27 a2b a2f a32 a36
a3a a3e a41 a45 a4a a4b a4d a51
a56 a57 a59 a5d a61 a64 a68 a6b
a6f a72 a75 a76 a7b a7c a7e a82
a87 a88 a8a a8e a93 a94 a96 a9a
a9f aa0 aa2 aa6 aab aac aae ab2
ab6 ab9 abc abd ac2 ac3 ac5 ac9
acd ad0 ad4 ad8 adc adf ae3 ae7
aea aee af1 af5 af8 afb afc b01
b02 b04 b08 b0c b0f b10 b12 b16
b19 b1c b1d b22 b23 b25 b26 b28
b29 b2e b32 b36 b3a b3d b41 b45
b4a b4b b4d b51 b54 b57 b58 b5d
b5e b60 b64 b66 b6a b71 b75 b79
b7d b80 b84 b85 b87 b8b b8f b93
b96 b9a b9e ba2 ba5 ba9 bae baf
bb1 bb5 bba bbb bbd bc1 bc6 bc7
bc9 bcd bd1 bd4 bd5 bd7 bdb bdf
be2 be3 be5 be9 bed bf0 bf4 bf5
bfa bfb bfd c01 c05 c06 c08 c0c
c10 c14 c18 c1b c1f c20 c22 c25
c26 c28 c2b c2c c2e c32 c33 c35
c36 c3b c3f c43 c47 c49 c4d c4f
c5b c5f c61 c63 c65 c69 c75 c79
c7b c7e c80 c81 c8a 
35d
2
0 1 9 e 1 b 14 1f
:2 1c 14 28 b 1 3 :3 f 3
2 b 5 0 c :2 2 5 c
5 :2 3 :4 2 b 3 9 :2 3 16
:2 1 3 1b 1c :2 1b 22 :2 3 :6 1
b 3 a :3 3 7 :2 3 13 :2 1
3 9 16 :2 11 :2 9 3 6 d
f :2 d 5 e 5 3 15 9
10 12 :2 10 5 e 5 3 18
15 9 10 12 :2 10 5 e 5
18 15 :2 3 :4 6 5 e 16 1c
21 :2 e 5 16 :3 3 b 12 19
1c :2 12 23 26 :2 12 2a 2d :2 12
33 35 :2 b :2 3 1b 1c :2 1b 22
:2 3 :6 1 b 17 1e :2 17 28 2e
:2 28 16 :2 1 5 1d 1e :2 1d 25
34 37 :2 25 3e 41 :2 25 4a 4d
:2 25 :2 5 :2 3 :4 1 b 0 :2 1 3
:2 c 1c 29 :2 3 :7 1 a 3 9
:3 3 b 1a :2 3 17 5 c :2 1
3 :3 9 :2 3 c 3 6 c e
:2 c 5 e 14 16 :2 e 5 19
:3 3 a :2 12 19 :2 21 3a 40 :2 48
:2 19 57 59 :2 a 3 :6 1 b 3
e :3 3 a :2 3 12 :2 1 3 :3 a
:2 3 :3 a :2 3 :3 a :2 3 d :2 3 d
:2 1a 26 :2 d :2 3 d :2 16 20 :2 d
:2 3 :2 c :2 13 :2 1b 22 2b :2 22 37
40 :2 37 48 51 :2 48 59 62 :2 59
22 30 3a 42 49 :2 3a :2 30 50
52 :2 30 54 30 3a 42 49 :2 3a
:2 30 50 52 :4 30 55 30 3a 42
48 :2 3a :2 30 51 53 :4 30 58 :3 22
30 3a 42 49 :2 3a :2 30 50 30
3a 42 49 :2 3a :2 30 50 52 :4 30
55 31 3b 43 49 :2 3b :2 31 52
54 :2 31 30 5a 5c :4 30 60 :3 22
:2 2b 32 3a 3d 44 46 :2 3d :2 22
24 32 39 3b :2 32 :3 24 32 :2 3b
45 :2 32 :3 24 32 39 :2 32 46 :3 24
2d :3 24 :2 2c 38 :2 24 :2 13 :3 3 :2 c
:3 11 18 1a :3 11 :2 1a 24 :2 11 31
33 :3 11 :3 3 :2 c 1a :2 3 :6 1 b
3 e :3 3 a :3 3 b :3 3 b
:2 3 1f :2 1 3 :6 1 b 3 d
:3 3 b f 16 :3 3 b f 16
:3 3 b f 16 :2 3 22 :2 1 3
:7 1 a 3 0 a :2 1 3 :2 15
24 15 :2 3 :3 15 :2 3 :3 15 :2 3 :3 15
:2 3 15 19 18 15 23 :2 2b 37
:2 23 15 :2 3 :3 8 :2 3 18 :2 21 2b
:2 18 :2 3 18 :2 21 27 33 3c :2 33
48 :2 18 :2 3 9 10 12 14 :2 10
3 5 e 14 16 :2 e :2 5 :2 e
:2 15 :2 1d 24 2d :3 24 2d :3 24 :2 2d
34 40 43 4a 4c :2 43 :3 24 2d
:3 24 2d :3 24 2d :3 24 2d :3 24 32
39 3b :2 32 :3 24 :2 2d :2 34 :2 3c 34
:2 3d 44 50 52 59 5b :2 52 :2 34
5f :2 67 :3 34 3b 3d :2 34 :2 24 :2 15
:3 5 f :2 18 1e 2a 33 :2 2a 3f
46 48 :2 3f :2 f 5 14 7 :2 3
18 :2 21 2b :2 18 3 5 :2 e :2 15
:2 1d 24 2d :3 24 2d :3 24 2d :3 24
32 39 :3 24 32 39 :3 24 32 44
46 :2 32 :3 24 32 :3 24 32 36 :2 3e
45 :2 36 50 :2 32 53 :3 24 :2 15 :2 5
3 a 3 :6 1 :4 2 5 :6 1 
35d
4
0 :3 1 :a 3 :5 8
:2 a b 0 b
:2 a :3 d :2 c :4 a
10 :4 11 :3 10 :8 15
:2 13 :4 10 18 :4 19
:4 1a :3 18 :8 1d :5 1f
:3 20 21 1f :5 21
:3 22 23 21 1f
:5 23 :3 24 23 :3 1f
:4 26 :8 27 :3 26 :14 29
:8 2b :2 1e :4 18 :c 2e
:14 30 :2 2f :4 2e 33
0 :2 33 :7 36 :2 35
:4 33 :2 39 :4 3a :5 3b
39 :2 3c :2 39 :5 3d
:3 3f :5 40 :7 41 :3 40
:12 43 :2 3e :4 39 46
:4 47 :4 48 :3 46 :5 4a
:5 4b :5 4c :3 4e :8 4f
:8 50 :4 51 :13 52 :e 53
:c 54 :2 53 54 :c 55
:2 53 55 :2 53 :a 56
:c 57 :2 56 57 :11 58
:2 56 58 :2 56 :c 59
:8 5a :9 5b :8 5c :4 5d
:6 5e :2 52 :2 51 :4 61
62 :5 63 :a 64 65
:2 61 :6 66 :2 4d :4 46
69 :4 6a :4 6b :4 6c
:4 6d :3 69 70 :2 6f
:4 69 73 :4 74 :6 75
:6 76 :6 77 :3 73 7a
:2 79 :4 73 :2 7d 7e
0 7e :2 7d :6 7f
:5 80 :5 81 :5 82 :d 83
:5 84 :8 87 :d 88 :8 8a
:7 8b :4 8c :7 8d :4 8e
:c 8f :4 90 :4 91 :4 92
:4 93 :8 94 :4 95 :3 96
:f 97 :2 96 :5 98 :2 95
:2 8d :2 8c :11 9c 8a
9d 8a :8 9f :4 a0
:7 a1 :4 a2 :4 a3 :5 a4
:5 a5 :8 a6 :4 a7 :e a8
a9 :2 a1 :2 a0 :3 ab
:2 85 :4 7d :4 a b1
:6 1 
c8c
4
:3 0 1 :3 0 2
:3 0 3 :6 0 1
:2 0 8 41 0
6 5 :3 0 6
:3 0 7 :3 0 8
:2 0 3 6 9
:6 0 9 :4 0 d
a b 357 4
:6 0 c :3 0 b
:3 0 f :7 0 12
10 0 357 0
a :6 0 d :a 0
21 2 :7 0 e
:4 0 6 :3 0 16
17 0 21 14
18 :2 0 e :3 0
4 :3 0 1b :2 0
1d a 20 :3 0
20 0 20 1f
1d 1e :6 0 21
1 0 14 18
20 357 :2 0 f
:a 0 37 3 :7 0
e :2 0 c 6
:3 0 10 :7 0 26
25 :3 0 28 :2 0
37 23 29 :2 0
11 :3 0 12 :2 0
13 :2 0 10 2c
2e :3 0 10 :3 0
12 2b 31 :2 0
33 15 36 :3 0
36 0 36 35
33 34 :6 0 37
1 0 23 29
36 357 :2 0 14
:a 0 9d 4 :7 0
19 136 0 17
6 :3 0 15 :7 0
3c 3b :3 0 18
:2 0 1b 6 :3 0
16 :7 0 40 3f
:3 0 42 :2 0 9d
39 43 :2 0 19
:2 0 21 6 :3 0
7 :3 0 1e 46
49 :6 0 4c 4a
0 9b 0 17
:6 0 15 :3 0 1a
:4 0 25 4e 50
:3 0 17 :3 0 1b
:4 0 52 53 0
56 1c :3 0 28
6c 15 :3 0 19
:2 0 1d :4 0 2c
58 5a :3 0 17
:3 0 1e :4 0 5c
5d 0 60 1c
:3 0 2f 61 5b
60 0 6d 15
:3 0 19 :2 0 1f
:4 0 33 63 65
:3 0 17 :3 0 20
:4 0 67 68 0
6a 36 6b 66
6a 0 6d 51
56 0 6d 38
0 99 16 :3 0
21 :2 0 3c 6f
70 :3 0 17 :3 0
22 :3 0 17 :3 0
23 :4 0 16 :3 0
3e 73 77 72
78 0 7a 42
7b 71 7a 0
7c 44 0 99
17 :3 0 24 :3 0
25 :4 0 26 :2 0
15 :3 0 46 80
82 :3 0 26 :2 0
27 :4 0 49 84
86 :3 0 26 :2 0
17 :3 0 4c 88
8a :3 0 28 :2 0
18 :2 0 4f 7e
8e 7d 8f 0
99 11 :3 0 12
:2 0 13 :2 0 53
92 94 :3 0 17
:3 0 55 91 97
:2 0 99 58 9c
:3 0 9c 5d 9c
9b 99 9a :6 0
9d 1 0 39
43 9c 357 :2 0
f :a 0 c3 5
:7 0 61 2bc 0
5f 6 :3 0 29
:7 0 a2 a1 :3 0
12 :2 0 63 6
:3 0 10 :7 0 a6
a5 :3 0 a8 :2 0
c3 9f a9 :2 0
11 :3 0 13 :2 0
66 ac ae :3 0
2a :4 0 26 :2 0
29 :3 0 68 b1
b3 :3 0 26 :2 0
2b :4 0 6b b5
b7 :3 0 26 :2 0
10 :3 0 6e b9
bb :3 0 71 ab
bd :2 0 bf 74
c2 :3 0 c2 0
c2 c1 bf c0
:6 0 c3 1 0
9f a9 c2 357
:2 0 2c :a 0 d4
6 :8 0 c6 :2 0
d4 c5 c7 :2 0
2d :3 0 2e :3 0
c9 ca 0 a
:3 0 2f :3 0 76
cb ce :2 0 d0
79 d3 :3 0 d3
0 d3 d2 d0
d1 :6 0 d4 1
0 c5 c7 d3
357 :2 0 c :3 0
30 :a 0 113 7
:7 0 35 :2 0 7b
32 :3 0 31 :7 0
da d9 :3 0 7f
:2 0 7d 34 :3 0
33 :7 0 df dd
de :2 0 e :3 0
36 :3 0 e1 e3
0 113 d7 e4
:2 0 38 :2 0 82
32 :3 0 e7 :7 0
ea e8 0 111
0 37 :6 0 37
:3 0 31 :3 0 eb
ec 0 10f 37
:3 0 39 :2 0 86
ef f1 :3 0 37
:3 0 37 :3 0 12
:2 0 3a :2 0 89
f5 f7 :3 0 f3
f8 0 fa 8c
fb f2 fa 0
fc 8e 0 10f
e :3 0 3b :3 0
24 :3 0 fe ff
0 3b :3 0 3c
:3 0 101 102 0
37 :3 0 3b :3 0
30 :3 0 105 106
0 90 103 108
28 :2 0 33 :3 0
93 100 10c 10d
:2 0 10f 97 112
:3 0 112 9b 112
111 10f 110 :6 0
113 1 0 d7
e4 112 357 :2 0
3d :a 0 20b 8
:7 0 9f 4a8 0
9d 6 :3 0 3e
:7 0 118 117 :3 0
a4 4c5 0 a1
b :3 0 3f :7 0
11c 11b :3 0 11e
:2 0 20b 115 11f
:2 0 a8 4f9 0
a6 41 :3 0 122
:7 0 125 123 0
209 0 40 :6 0
b :3 0 127 :7 0
12a 128 0 209
0 42 :6 0 40
:3 0 44 :3 0 12c
:7 0 12f 12d 0
209 0 43 :6 0
45 :3 0 130 131
0 207 42 :3 0
46 :3 0 47 :3 0
134 135 0 3f
:3 0 aa 136 138
133 139 0 207
43 :3 0 2d :3 0
48 :3 0 13c 13d
0 42 :3 0 ac
13e 140 13b 141
0 207 2d :3 0
49 :3 0 143 144
0 a :3 0 3b
:3 0 4a :3 0 147
148 0 4b :3 0
4c :4 0 ae 14a
14c 4b :3 0 4d
:4 0 b0 14e 150
4b :3 0 4e :4 0
b2 152 154 4b
:3 0 4f :4 0 b4
156 158 30 :3 0
50 :3 0 51 :3 0
40 :3 0 52 :4 0
b6 15c 15f b9
15b 161 53 :2 0
54 :2 0 bb 163
165 :3 0 55 :2 0
50 :3 0 51 :3 0
40 :3 0 56 :4 0
be 169 16c c1
168 16e 57 :2 0
58 :2 0 c3 170
172 :3 0 c6 167
174 :3 0 55 :2 0
50 :3 0 51 :3 0
40 :3 0 59 :4 0
c9 178 17b cc
177 17d 57 :2 0
5a :2 0 ce 17f
181 :3 0 d1 176
183 :3 0 54 :2 0
d4 15a 186 30
:3 0 50 :3 0 51
:3 0 40 :3 0 5b
:4 0 d7 18a 18d
da 189 18f 55
:2 0 50 :3 0 51
:3 0 40 :3 0 5c
:4 0 dc 193 196
df 192 198 57
:2 0 58 :2 0 e1
19a 19c :3 0 e4
191 19e :3 0 55
:2 0 50 :3 0 51
:3 0 40 :3 0 5d
:4 0 e7 1a2 1a5
ea 1a1 1a7 12
:2 0 5e :2 0 ec
1a9 1ab :3 0 1ac
:2 0 57 :2 0 5f
:2 0 ef 1ae 1b0
:3 0 f2 1a0 1b2
:3 0 54 :2 0 f5
188 1b5 2d :3 0
24 :3 0 1b7 1b8
0 42 :3 0 35
:2 0 43 :3 0 12
:2 0 60 :2 0 f8
1bd 1bf :3 0 fb
1b9 1c1 30 :3 0
43 :3 0 12 :2 0
61 :2 0 ff 1c5
1c7 :3 0 102 1c3
1c9 30 :3 0 2d
:3 0 48 :3 0 1cc
1cd 0 3f :3 0
104 1ce 1d0 106
1cb 1d2 30 :3 0
62 :3 0 3e :3 0
108 1d5 1d7 54
:2 0 10a 1d4 1da
4b :3 0 4e :4 0
10d 1dc 1de 3b
:3 0 63 :3 0 1e0
1e1 0 3e :3 0
10f 1e2 1e4 111
149 1e6 11e 145
1e8 :2 0 207 2d
:3 0 64 :3 0 1ea
1eb 0 a :3 0
42 :3 0 43 :3 0
12 :2 0 61 :2 0
121 1f0 1f2 :3 0
2d :3 0 48 :3 0
1f4 1f5 0 a
:3 0 124 1f6 1f8
55 :2 0 28 :2 0
126 1fa 1fc :3 0
65 :2 0 129 1ec
1ff :2 0 207 2d
:3 0 66 :3 0 201
202 0 42 :3 0
12f 203 205 :2 0
207 131 20a :3 0
20a 138 20a 209
207 208 :6 0 20b
1 0 115 11f
20a 357 :2 0 67
:a 0 226 9 :7 0
13e 7db 0 13c
6 :3 0 3e :7 0
210 20f :3 0 142
801 0 140 b
:3 0 3f :7 0 214
213 :3 0 36 :3 0
68 :7 0 218 217
:4 0 222 0 144
36 :3 0 69 :7 0
21c 21b :3 0 21e
:2 0 226 20d 21f
:2 0 149 225 :3 0
225 0 225 224
222 223 :6 0 226
1 0 20d 21f
225 357 :2 0 6a
:a 0 247 a :7 0
14d 861 0 14b
b :3 0 3f :7 0
22b 22a :3 0 151
895 0 14f 6c
:3 0 6d :3 0 b
:3 0 6b :5 0 1
231 230 :3 0 6c
:3 0 6d :3 0 36
:3 0 68 :5 0 1
237 236 :4 0 243
0 153 6c :3 0
6d :3 0 36 :3 0
69 :5 0 1 23d
23c :3 0 23f :2 0
247 228 240 :2 0
158 246 :3 0 246
0 246 245 243
244 :6 0 247 1
0 228 240 246
357 :2 0 c :3 0
6e :a 0 350 b
:7 0 e :4 0 b
:3 0 24c 24d 0
350 24a 24e :2 0
15c 91b 0 15a
34 :3 0 251 :7 0
70 :2 0 255 252
253 34e 0 6f
:6 0 160 94f 0
15e 44 :3 0 257
:7 0 25a 258 0
34e 0 71 :6 0
44 :3 0 25c :7 0
25f 25d 0 34e
0 72 :6 0 168
99a 0 166 44
:3 0 261 :7 0 264
262 0 34e 0
73 :6 0 36 :3 0
75 :2 0 162 266
268 :6 0 3b :3 0
63 :3 0 26a 26b
0 76 :4 0 164
26c 26e 271 269
26f 34e 0 74
:6 0 72 :3 0 32
:3 0 273 :7 0 276
274 0 34e 0
77 :6 0 2d :3 0
48 :3 0 278 279
0 a :3 0 16a
27a 27c 277 27d
0 34c 71 :3 0
2d :3 0 78 :3 0
280 281 0 a
:3 0 4b :3 0 4c
:4 0 16c 284 286
28 :2 0 16e 282
289 27f 28a 0
34c 79 :3 0 71
:3 0 38 :2 0 70
:2 0 7a :3 0 174
28e 291 :3 0 292
304 6f :3 0 6f
:3 0 55 :2 0 28
:2 0 177 296 298
:3 0 294 299 0
302 2d :3 0 49
:3 0 29b 29c 0
a :3 0 3b :3 0
4a :3 0 29f 2a0
0 4b :3 0 7b
:4 0 17a 2a2 2a4
4b :3 0 4d :4 0
17c 2a6 2a8 2d
:3 0 24 :3 0 2aa
2ab 0 a :3 0
7c :2 0 71 :3 0
55 :2 0 35 :2 0
17e 2b0 2b2 :3 0
181 2ac 2b4 4b
:3 0 4e :4 0 185
2b6 2b8 4b :3 0
4e :4 0 187 2ba
2bc 4b :3 0 7d
:4 0 189 2be 2c0
4b :3 0 7e :4 0
18b 2c2 2c4 30
:3 0 71 :3 0 12
:2 0 28 :2 0 18d
2c8 2ca :3 0 190
2c6 2cc 2d :3 0
24 :3 0 2ce 2cf
0 a :3 0 3b
:3 0 7f :3 0 2d2
2d3 0 2d :3 0
24 :3 0 2d5 2d6
0 a :3 0 54
:2 0 71 :3 0 55
:2 0 7c :2 0 192
2db 2dd :3 0 195
2d7 2df 3b :3 0
30 :3 0 2e1 2e2
0 199 2d4 2e4
71 :3 0 55 :2 0
80 :2 0 19c 2e7
2e9 :3 0 19f 2d0
2eb 1a3 2a1 2ed
1ad 29d 2ef :2 0
302 71 :3 0 2d
:3 0 78 :3 0 2f2
2f3 0 a :3 0
4b :3 0 4c :4 0
1b0 2f6 2f8 71
:3 0 55 :2 0 58
:2 0 1b2 2fb 2fd
:3 0 1b5 2f4 2ff
2f1 300 0 302
1b9 304 7a :3 0
293 302 :4 0 34c
73 :3 0 2d :3 0
48 :3 0 306 307
0 a :3 0 1bd
308 30a 305 30b
0 34c 2d :3 0
49 :3 0 30d 30e
0 a :3 0 3b
:3 0 4a :3 0 311
312 0 4b :3 0
81 :4 0 1bf 314
316 4b :3 0 4e
:4 0 1c1 318 31a
4b :3 0 4e :4 0
1c3 31c 31e 30
:3 0 6f :3 0 54
:2 0 1c5 320 323
30 :3 0 6f :3 0
54 :2 0 1c8 325
328 30 :3 0 73
:3 0 12 :2 0 72
:3 0 1cb 32c 32e
:3 0 1ce 32a 330
30 :3 0 72 :3 0
1d0 332 334 30
:3 0 82 :3 0 3b
:3 0 62 :3 0 338
339 0 74 :3 0
1d2 33a 33c 70
:2 0 1d4 337 33f
54 :2 0 1d7 336
342 74 :3 0 1da
313 345 1e4 30f
347 :2 0 34c e
:3 0 a :3 0 34a
:2 0 34c 1e7 34f
:3 0 34f 1ee 34f
34e 34c 34d :6 0
350 1 0 24a
24e 34f 357 :3 0
355 0 355 :3 0
355 357 353 354
:6 0 358 :2 0 3
:3 0 1f5 0 3
355 35b :3 0 35a
358 35c :8 0 
202
4
:3 0 2 8 7
1 4 1 e
1 1c 1 24
1 27 1 2d
2 2f 30 1
32 1 3a 1
3e 2 3d 41
2 48 47 1
45 1 4f 2
4d 4f 1 54
1 59 2 57
59 1 5e 1
64 2 62 64
1 69 3 6c
61 6b 1 6e
3 74 75 76
1 79 1 7b
2 7f 81 2
83 85 2 87
89 3 8b 8c
8d 1 93 2
95 96 4 6d
7c 90 98 1
4b 1 a0 1
a4 2 a3 a7
1 ad 2 b0
b2 2 b4 b6
2 b8 ba 2
af bc 1 be
2 cc cd 1
cf 1 d8 1
dc 2 db e0
1 e6 1 f0
2 ee f0 2
f4 f6 1 f9
1 fb 2 104
107 3 109 10a
10b 3 ed fc
10e 1 e9 1
116 1 11a 2
119 11d 1 121
1 126 1 12b
1 137 1 13f
1 14b 1 14f
1 153 1 157
2 15d 15e 1
160 2 162 164
2 16a 16b 1
16d 2 16f 171
2 166 173 2
179 17a 1 17c
2 17e 180 2
175 182 2 184
185 2 18b 18c
1 18e 2 194
195 1 197 2
199 19b 2 190
19d 2 1a3 1a4
1 1a6 2 1a8
1aa 2 1ad 1af
2 19f 1b1 2
1b3 1b4 2 1bc
1be 3 1ba 1bb
1c0 2 1c4 1c6
1 1c8 1 1cf
1 1d1 1 1d6
2 1d8 1d9 1
1dd 1 1e3 c
14d 151 155 159
187 1b6 1c2 1ca
1d3 1db 1df 1e5
2 146 1e7 2
1ef 1f1 1 1f7
2 1f9 1fb 5
1ed 1ee 1f3 1fd
1fe 1 204 6
132 13a 142 1e9
200 206 3 124
129 12e 1 20e
1 212 1 216
1 21a 4 211
215 219 21d 1
221 1 229 1
22d 1 233 1
239 4 22c 232
238 23e 1 242
1 250 1 256
1 25b 1 260
1 267 1 26d
1 265 1 272
1 27b 1 285
3 283 287 288
1 28f 2 28d
28f 2 295 297
1 2a3 1 2a7
2 2af 2b1 3
2ad 2ae 2b3 1
2b7 1 2bb 1
2bf 1 2c3 2
2c7 2c9 1 2cb
2 2da 2dc 3
2d8 2d9 2de 2
2e0 2e3 2 2e6
2e8 3 2d1 2e5
2ea 9 2a5 2a9
2b5 2b9 2bd 2c1
2c5 2cd 2ec 2
29e 2ee 1 2f7
2 2fa 2fc 3
2f5 2f9 2fe 3
29a 2f0 301 1
309 1 315 1
319 1 31d 2
321 322 2 326
327 2 32b 32d
1 32f 1 333
1 33b 2 33d
33e 2 340 341
9 317 31b 31f
324 329 331 335
343 344 2 310
346 6 27e 28b
304 30c 348 34b
6 254 259 25e
263 270 275 :2 c
11 21 37 9d
c3 d4 113 20b
226 247 350 
1
4
0 
35b
0
1
14
c
29
0 1 1 1 1 1 1 1
1 1 1 b 0 0 0 0
0 0 0 0 
c5 1 6
22d a 0
24a 1 b
233 a 0
216 9 0
12b 8 0
126 8 0
d8 7 0
45 4 0
239 a 0
21a 9 0
228 1 a
121 8 0
272 b 0
3a 4 0
9f 1 5
23 1 3
4 1 0
229 a 0
212 9 0
11a 8 0
20e 9 0
116 8 0
260 b 0
25b b 0
e6 7 0
3e 4 0
a0 5 0
3 0 1
20d 1 9
250 b 0
14 1 2
dc 7 0
a4 5 0
24 3 0
256 b 0
e 1 0
d7 1 7
39 1 4
265 b 0
115 1 8
0

/
