create or replace procedure image1 is
    /* 20. Example:  Image */
  l_blob blob;
  l_image blob;
  l_img2 blob;
 begin
    plpdf.init;
    plpdf.NewPage;

    -- an unsupported PNG, example "Interlacing"
    select image_file
      into l_image
     from IMAGE_BLOB
     where id = 50
     /*for update*/;
   
  --without for update   
	dbms_lob.createtemporary(l_img2, true, dbms_lob.session);
  dbms_lob.copy(dest_lob => l_img2,src_lob => l_image,amount => dbms_lob.getlength(l_image));

    plpdf.PutImage(
     p_name => 'image1',
     p_data => l_img2,
     p_x => 10,
     p_y => 20,
     p_w => 80,
     p_h =>  40
     );

    plpdf.SendDoc(
     p_blob => l_blob 
     );


    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    delete from store_blob;
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);

    commit;
 end;
/
