create or replace package XLSX_Examples is
--v4.9.0
--
procedure Init;
procedure SetDocumentProperties;
procedure AddWorksheet;
procedure AddRow;
procedure AddCellString;
procedure AddCellNumber;
procedure AddCellDate;
procedure RowHeight;
procedure ColumnWidth;
procedure SetDefaultFont;
procedure Cell_setFont;
procedure Cell_setBold;
procedure Cell_setItalic;
procedure Cell_setUnderline;
procedure Cell_setColor;
procedure Cell_setBGColor;
procedure Cell_setHLeft;
procedure Cell_setHCenter;
procedure Cell_setHRight;
procedure Cell_setVTop;
procedure Cell_setVCenter;
procedure Cell_setVBottom;
procedure Cell_setBorder;
procedure Cell_setBorder_Top;
procedure Cell_setBorder_Bottom;
procedure Cell_setBorder_Left;
procedure Cell_setBorder_Right;
procedure Cell_WrapText;
procedure Cell_SetHyperlink;
procedure Cell_SetComment;
procedure Cell_SetFormatMask;
procedure MergeCells;
procedure MergeRows;
procedure SetAutoFilter;
procedure SetAutoFilter2;
procedure SetAutoFilter3;
procedure RowFreeze;
procedure ColumnFreeze;
procedure SetCurrentWorksheet;
--
procedure QueryExample;
procedure ImportToDb;
procedure ImportToDbOneCell;
procedure SetPrinterSettings;
--
procedure Cell_setFormula;
procedure AddImage;
-- Required table scripts for Import examples

/*
create table XLSX_TEXT
(
  id        NUMBER,
  datatext  VARCHAR2(2000),
  cell_id   VARCHAR2(7),
  cell_type VARCHAR2(10)
);
*/

/*
create table STORE_BLOB_T
(
  blob_file    BLOB,
  created_date DATE,
  filename     VARCHAR2(255)
);
*/

/*
create table IMAGE_BLOB
(
  ID         NUMBER,
  IMAGE_FILE BLOB
);
*/
end;
/
create or replace package body XLSX_Examples is
--v4.9.0
procedure Init is
  l_xls blob;
  sheet_id pls_integer; -- Worksheet ID
  row_id   pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  --
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  --
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Init' -- String in the cell
                             );
  --
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  --
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Init.xlsx');
  commit;
end;
--
procedure SetDocumentProperties is
  l_xls blob;
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  --
  /* Excel documents store metadata related to the document for example, the title, subject, keywords, etc.  */
  ploffx_xlsx.setDocumentProperties(p_title         => 'MyTitle', -- Document title
                                    p_subject       => 'MySubject', -- Document subject
                                    p_keywords      => 'keyword1,keyword2,keyword3', -- Keywords
                                    p_description   => 'Description of document', -- Description
                                    p_category      => 'MyCategory', -- Category
                                    p_contentStatus => 'MyContentStatus' -- Content status
                                    );
  
  ploffx_xlsx.addWorksheet(p_Name => 'MyWorksheet'); -- Add new worksheet called MyWorksheet.
  ploffx_xlsx.addRow(1); -- Add new row the indexed worksheet
  ploffx_xlsx.addCell_String(1, 1, 'A', 'SetDocumentProperties'); -- Add a string type data to the indexed cell.
  --
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  --
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'SetDocumentProperties.xlsx');
  commit;
end;
--
procedure AddWorksheet is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  --
  /* Excel documents store metadata related to the document for example, the title, subject, keywords, etc.  */
  ploffx_xlsx.setDocumentProperties(p_title         => 'MyTitle', -- Document title
                                    p_subject       => 'MySubject', -- Document subject
                                    p_keywords      => 'keyword1,keyword2,keyword3', -- Keywords
                                    p_description   => 'Description of document', -- Description
                                    p_category      => 'MyCategory', -- Category
                                    p_contentStatus => 'MyContentStatus' -- Content status
                                    );
  --
  ploffx_xlsx.addWorksheet(p_Name => 'NewWorksheet1'); -- Add new worksheet called MyWorksheet.
  ploffx_xlsx.addRow(1); -- Add new row the indexed worksheet
  ploffx_xlsx.addCell_String(1, 1, 'A', 'AddWorksheet'); -- Add a string type data to the indexed cell.
  --
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'NewData' -- Data in the cell
                             );
  --
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  --
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'AddWorksheet.xlsx');
  commit;
end;
--
procedure AddRow is
  l_xls blob;
  sheet_id pls_integer; -- Worksheet ID
  row_id   pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  sheet_id := ploffx_xlsx.addWorksheet('MyWorksheet'); -- Add new worksheet
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  --
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'AddRow' -- Data in the cell
                             );
  --
  /*Add a new row to the sheet */
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  --
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Second row' -- Data in the cell
                             );
  --
  /*Add a new row to the sheet */
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  --
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Another row' -- Data in the cell
                             );
  --
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  --
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'AddRow.xlsx');
  commit;
end;
--
procedure AddCellString is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
  l_format_id pls_integer; -- Format ID
  font_id     pls_integer; -- Font ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  --
  font_id := ploffx_xlsx.addFont(p_font_name => 'Calibri', -- Font family
                                 p_font_size => 12, -- Font size
                                 p_italic    => true, -- Italic
                                 p_underline => false, -- Underline
                                 p_bold      => false, -- Bold
                                 p_color     => 'FF0000' -- Color
                                 );
  --
  l_format_id := ploffx_xlsx.addFormat(p_fontid => font_id);
  --
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'A', -- Column name
                             p_data      => 'AddString', -- String in the cell
                             p_format_id => l_format_id);
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'A', -- Column name
                             p_data      => 'String1', -- String in the cell
                             p_format_id => l_format_id);
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'B', -- Column name
                             p_data      => 'String2', -- String in the cell
                             p_format_id => l_format_id);
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  --
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'AddCellString.xlsx');
  commit;
end;
--
procedure AddCellNumber is
  l_xls blob;
  sheet_id      pls_integer; -- Worksheet ID
  row_id        pls_integer; -- Row ID
  l_format_id   pls_integer; -- Format ID
  font_id       pls_integer; -- Font ID
  num_format_id pls_integer; -- format
begin
  ploffx_xlsx.init; -- Initializes generator program variables

  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  font_id := ploffx_xlsx.addFont(p_font_name => 'Calibri',
                                 p_font_size => 12,
                                 p_italic    => true,
                                 p_underline => false,
                                 p_bold      => false,
                                 p_color     => 'A4A5EE');
  
  num_format_id := ploffx_xlsx.addFormatMask(p_format_mask => '# ###.#');
  
  l_format_id := ploffx_xlsx.addFormat(p_numfmtid => num_format_id,
                                       p_fontid   => font_id);
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'AddCellNumber' -- Data in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Number(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'A', -- Column name
                             p_data      => 1234.59, -- Number in the cell
                             p_format_id => l_format_id -- Format ID
                             );
  
  num_format_id := ploffx_xlsx.addFormatMask(p_format_mask => '###.#00');
  
  l_format_id := ploffx_xlsx.addFormat(p_numfmtid => num_format_id,
                                       p_fontid   => font_id);
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Number(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'B', -- Column name
                             p_data      => 232.37, -- Number in the cell
                             p_format_id => l_format_id -- Format ID
                             );
  
  num_format_id := ploffx_xlsx.addFormatMask(p_format_mask => '$###.00');
  
  l_format_id := ploffx_xlsx.addFormat(p_numfmtid => num_format_id,
                                       p_fontid   => font_id);
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Number(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'C', -- Column name
                             p_data      => 140.75, -- Number in the cell
                             p_format_id => l_format_id -- Format ID
                             );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'AddCellNumber.xlsx');
  commit;
end;
--
procedure AddCellDate is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
  l_format_id pls_integer; -- Format ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  l_format_id := ploffx_xlsx.addFormat1(p_format_mask => 'yyyy.mm.dd');
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'AddCellDate' -- Data in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id);
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Date(p_ws          => sheet_id, -- Worksheet ID
                           p_row         => row_id, -- Row ID
                           p_cell        => 'A', -- Column name
                           p_data        => sysdate, -- Date in the cell
                           p_format_mask => 'd.m.yyyy' -- Date format
                           );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Date(p_ws          => sheet_id, -- Worksheet ID
                           p_row         => row_id, -- Row ID
                           p_cell        => 'A', -- Column name
                           p_data        => sysdate, -- Date in the cell
                           p_format_mask => 'yyyy.m.d' -- Date format
                           );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Date(p_ws        => sheet_id, -- Worksheet ID
                           p_row       => row_id, -- Row ID
                           p_cell      => 'A', -- Column name
                           p_data      => sysdate, -- Date in the cell
                           p_format_id => l_format_id -- Format ID
                           );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'A', -- Column ID
                           p_width  => 12 -- Width value
                           );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'AddCellDate.xlsx');
  commit;
end;
--
procedure RowHeight is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'RowHeight' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'height value: 30' -- String in the cell
                             );
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 30 -- Height value
                         );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'height value: 20' -- String in the cell
                             );
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 20 -- Height value
                         );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'height value: 15' -- String in the cell
                             );
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 15 -- Height value
                         );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'RowHeight.xlsx');
  commit;
end;
--
procedure ColumnWidth is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'ColumnWidth' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Width: 38' -- String in the cell
                             );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'A', -- Column ID
                           p_width  => 38 -- Width value
                           );
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 'Width: 50' -- String in the cell
                             );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'B', -- Column ID
                           p_width  => 50 -- Width value
                           );
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'C', -- Column name
                             p_data => 'Width: 140' -- String in the cell
                             );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'C', -- Column ID
                           p_width  => 140 -- Width value
                           );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'ColumnWidth.xlsx');
  commit;
end;
--
procedure SetDefaultFont is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'SetDefaultFont' -- String in the cell
                             );
  
  ploffx_xlsx.setDefaultFont(p_FontName => 'Tahoma', -- Name of the font-family. Default value: Calibri
                             p_Size     => '14' -- Font size. Default value: 11
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Default font: Tahoma' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Size: 14' -- String in the cell
                             );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'SetDefaultFont.xlsx');
  commit;
end;
--
procedure Cell_setFont is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setFont' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Tahoma 12' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setFont(p_ws       => sheet_id, -- Worksheet ID
                           p_row      => row_id, -- Row ID
                           p_cell     => 'A', -- Cell name
                           p_FontName => 'Tahoma', -- Font family
                           p_Size     => 12 -- Font size
                           );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Courier 14' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setFont(p_ws       => sheet_id, -- Worksheet ID
                           p_row      => row_id, -- Row ID
                           p_cell     => 'A', -- Cell name
                           p_FontName => 'Courier', -- Font family
                           p_Size     => 14 -- Font size
                           );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheets
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => ' Verdana 8' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setFont(p_ws       => sheet_id, -- Worksheet ID
                           p_row      => row_id, -- Row ID
                           p_cell     => 'B', -- Cell name
                           p_FontName => 'Verdana', -- Font family
                           p_Size     => 8 -- Font size
                           );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setFont.xlsx');
  commit;
end;
--
procedure Cell_setBold is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setBold' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Normal' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 'Bold' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setBold(p_ws   => sheet_id, -- Worksheet ID
                           p_row  => row_id, -- Row ID
                           p_cell => 'B' -- Column name
                           );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setBold.xlsx');
  commit;
end;
--
procedure Cell_setItalic is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setItalic' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Normal' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 'Italic' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setItalic(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B' -- Column name
                             );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setItalic.xlsx');
  commit;
end;
--
procedure Cell_setUnderline is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setUnderline' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Normal' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 'Underline' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setUnderline(p_ws   => sheet_id, -- Worksheet ID
                                p_row  => row_id, -- Row ID
                                p_cell => 'B' -- Column name
                                );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setUnderline.xlsx');
  commit;
end;
--
procedure Cell_setColor is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setColor' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Magenta' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setColor(p_ws    => sheet_id, -- Workshet ID
                            p_row   => row_id, -- Row ID
                            p_cell  => 'A', -- Column name
                            p_color => 'FF00FF' -- Color
                            );
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 'Green' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setColor(p_ws    => sheet_id, -- Workshet ID
                            p_row   => row_id, -- Row ID
                            p_cell  => 'B', -- Column name
                            p_color => ploffx_xlsx_styles.c_Green -- Color
                            );
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'C', -- Column name
                             p_data => 'Khaki' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setColor(p_ws    => sheet_id, -- Workshet ID
                            p_row   => row_id, -- Row ID
                            p_cell  => 'C', -- Column name
                            p_color => ploffx_xlsx_styles.c_Khaki -- Color
                            );
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setColor.xlsx');
  commit;
end;
--
procedure Cell_setBGColor is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setBGColor' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Magenta' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setBGColor(p_ws    => sheet_id, -- Workshet ID
                              p_row   => row_id, -- Row ID
                              p_cell  => 'A', -- Column name
                              p_color => 'FF00FF' -- Color
                              );
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 'Green' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setBGColor(p_ws    => sheet_id, -- Workshet ID
                              p_row   => row_id, -- Row ID
                              p_cell  => 'B', -- Column name
                              p_color => ploffx_xlsx_styles.c_Green -- Color
                              );
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'C', -- Column name
                             p_data => 'Khaki' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setBGColor(p_ws    => sheet_id, -- Workshet ID
                              p_row   => row_id, -- Row ID
                              p_cell  => 'C', -- Column name
                              p_color => ploffx_xlsx_styles.c_Khaki -- Color
                              );
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setBGColor.xlsx');
  commit;
end;
--
procedure Cell_setHLeft is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setHLeft' -- String in the cell
                             );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id,
                           p_column => 'A',
                           p_width  => 35);
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Horizontal align: Left' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setHLeft(p_ws   => sheet_id, -- Worksheet ID
                            p_row  => row_id, -- Row ID
                            p_cell => 'A' -- Column name
                            );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setHLeft.xlsx');
  commit;
end;
--
procedure Cell_setHCenter is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setHCenter' -- String in the cell
                             );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id,
                           p_column => 'A',
                           p_width  => 35);
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Horizontal align: Center' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setHCenter(p_ws   => sheet_id, -- Worksheet ID
                              p_row  => row_id, -- Row ID
                              p_cell => 'A' -- Column name
                              );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setHCenter.xlsx');
  commit;
end;
--
procedure Cell_setHRight is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setHRight' -- String in the cell
                             );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id,
                           p_column => 'A',
                           p_width  => 35);
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Horizontal align: Right' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setHRight(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A' -- Column name
                             );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setHRight.xlsx');
  commit;
end;
--
procedure Cell_setVTop is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setVTop' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'A', -- Column name
                           p_width  => 35 -- Column widht
                           );
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 50 -- Row height
                         );
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Vertical align: Top' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setVTop(p_ws   => sheet_id, -- Worksheet ID
                           p_row  => row_id, -- Row ID
                           p_cell => 'A' -- Column name
                           );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setVTop.xlsx');
  commit;
end;
--
procedure Cell_setVCenter is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setVCenter' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'A', -- Column name
                           p_width  => 35 -- Column widht
                           );
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 50 -- Row height
                         );
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Vertical align: Middle' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setVCenter(p_ws   => sheet_id, -- Worksheet ID
                              p_row  => row_id, -- Row ID
                              p_cell => 'A' -- Column name
                              );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setVCenter.xlsx');
  commit;
end;
--
procedure Cell_setVBottom is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setVBottom' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'A', -- Column name
                           p_width  => 35 -- Column widht
                           );
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 50 -- Row height
                         );
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Vertical align: Bottom' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setVBottom(p_ws   => sheet_id, -- Worksheet ID
                              p_row  => row_id, -- Row ID
                              p_cell => 'A' -- Column name
                              );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setVBottom.xlsx');
  commit;
end;
--
procedure Cell_setBorder is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setBorder' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Cell_setBorder(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'B', -- Column name
                             p_LineStyle => ploffx_xlsx_styles.c_dotted, -- Line style
                             p_color     => ploffx_xlsx_styles.c_Green -- Border color
                             );
  
  ploffx_xlsx.Cell_setBorder(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'D', -- Column name
                             p_LineStyle => ploffx_xlsx_styles.c_dashed, -- Line style
                             p_color     => ploffx_xlsx_styles.c_Khaki -- Border color
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Cell_setBorder(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'A', -- Column name
                             p_LineStyle => ploffx_xlsx_styles.c_hair, -- Line style
                             p_color     => ploffx_xlsx_styles.c_Orange -- Border color
                             );
  
  ploffx_xlsx.Cell_setBorder(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'C', -- Column name
                             p_LineStyle => ploffx_xlsx_styles.c_double, -- Line style
                             p_color     => ploffx_xlsx_styles.c_Cyan -- Border color
                             );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setBorder.xlsx');
  commit;
end;
--
procedure Cell_setBorder_Top is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setBorder_Top' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Cell_setBorder_Top(p_ws        => sheet_id, -- Worksheet ID
                                 p_row       => row_id, -- Row ID
                                 p_cell      => 'B', -- Column name
                                 p_LineStyle => ploffx_xlsx_styles.c_slantDashDot, -- Line style
                                 p_color     => ploffx_xlsx_styles.c_Green -- Border color
                                 );
  
  ploffx_xlsx.Cell_setBorder_Top(p_ws        => sheet_id, -- Worksheet ID
                                 p_row       => row_id, -- Row ID
                                 p_cell      => 'D', -- Column name
                                 p_LineStyle => ploffx_xlsx_styles.c_medium, -- Line style
                                 p_color     => ploffx_xlsx_styles.c_Lime -- Border color
                                 );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Cell_setBorder_Top(p_ws        => sheet_id, -- Worksheet ID
                                 p_row       => row_id, -- Row ID
                                 p_cell      => 'A', -- Column name
                                 p_LineStyle => ploffx_xlsx_styles.c_mediumDashDot, -- Line style
                                 p_color     => ploffx_xlsx_styles.c_Orange -- Border color
                                 );
  
  ploffx_xlsx.Cell_setBorder_Top(p_ws        => sheet_id, -- Worksheet ID
                                 p_row       => row_id, -- Row ID
                                 p_cell      => 'C', -- Column name
                                 p_LineStyle => ploffx_xlsx_styles.c_thick, -- Line style
                                 p_color     => ploffx_xlsx_styles.c_Cyan -- Border color
                                 );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setBorder_Top.xlsx');
  commit;
end;
--
procedure Cell_setBorder_Bottom is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setBorder_Bottom' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Cell_setBorder_Bottom(p_ws        => sheet_id, -- Worksheet ID
                                    p_row       => row_id, -- Row ID
                                    p_cell      => 'B', -- Column name
                                    p_LineStyle => ploffx_xlsx_styles.c_slantDashDot, -- Line style
                                    p_color     => ploffx_xlsx_styles.c_Green -- Border color
                                    );
  
  ploffx_xlsx.Cell_setBorder_Bottom(p_ws        => sheet_id, -- Worksheet ID
                                    p_row       => row_id, -- Row ID
                                    p_cell      => 'D', -- Column name
                                    p_LineStyle => ploffx_xlsx_styles.c_medium, -- Line style
                                    p_color     => ploffx_xlsx_styles.c_Lime -- Border color
                                    );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Cell_setBorder_Bottom(p_ws        => sheet_id, -- Worksheet ID
                                    p_row       => row_id, -- Row ID
                                    p_cell      => 'A', -- Column name
                                    p_LineStyle => ploffx_xlsx_styles.c_mediumDashDot, -- Line style
                                    p_color     => ploffx_xlsx_styles.c_Orange -- Border color
                                    );
  
  ploffx_xlsx.Cell_setBorder_Bottom(p_ws        => sheet_id, -- Worksheet ID
                                    p_row       => row_id, -- Row ID
                                    p_cell      => 'C', -- Column name
                                    p_LineStyle => ploffx_xlsx_styles.c_thick, -- Line style
                                    p_color     => ploffx_xlsx_styles.c_Cyan -- Border color
                                    );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setBorder_Bottom.xlsx');
  commit;
end;
--
procedure Cell_setBorder_Left is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setBorder_Left' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 50 -- Row height
                         );
  
  ploffx_xlsx.Cell_setBorder_Left(p_ws        => sheet_id, -- Worksheet ID
                                  p_row       => row_id, -- Row ID
                                  p_cell      => 'B', -- Column name
                                  p_LineStyle => ploffx_xlsx_styles.c_slantDashDot, -- Line style
                                  p_color     => ploffx_xlsx_styles.c_Green -- Border color
                                  );
  
  ploffx_xlsx.Cell_setBorder_Left(p_ws        => sheet_id, -- Worksheet ID
                                  p_row       => row_id, -- Row ID
                                  p_cell      => 'D', -- Column name
                                  p_LineStyle => ploffx_xlsx_styles.c_medium, -- Line style
                                  p_color     => ploffx_xlsx_styles.c_Lime -- Border color
                                  );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 50 -- Row height
                         );
  
  ploffx_xlsx.Cell_setBorder_Left(p_ws        => sheet_id, -- Worksheet ID
                                  p_row       => row_id, -- Row ID
                                  p_cell      => 'C', -- Column name
                                  p_LineStyle => ploffx_xlsx_styles.c_mediumDashDot, -- Line style
                                  p_color     => ploffx_xlsx_styles.c_Orange -- Border color
                                  );
  
  ploffx_xlsx.Cell_setBorder_Left(p_ws        => sheet_id, -- Worksheet ID
                                  p_row       => row_id, -- Row ID
                                  p_cell      => 'E', -- Column name
                                  p_LineStyle => ploffx_xlsx_styles.c_thick, -- Line style
                                  p_color     => ploffx_xlsx_styles.c_Cyan -- Border color
                                  );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setBorder_Left.xlsx');
  commit;
end;
--
procedure Cell_setBorder_Right is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_setBorder_Right' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 50 -- Row height
                         );
  
  ploffx_xlsx.Cell_setBorder_Right(p_ws        => sheet_id, -- Worksheet ID
                                   p_row       => row_id, -- Row ID
                                   p_cell      => 'B', -- Column name
                                   p_LineStyle => ploffx_xlsx_styles.c_slantDashDot, -- Line style
                                   p_color     => ploffx_xlsx_styles.c_Green -- Border color
                                   );
  
  ploffx_xlsx.Cell_setBorder_Right(p_ws        => sheet_id, -- Worksheet ID
                                   p_row       => row_id, -- Row ID
                                   p_cell      => 'D', -- Column name
                                   p_LineStyle => ploffx_xlsx_styles.c_medium, -- Line style
                                   p_color     => ploffx_xlsx_styles.c_Lime -- Border color
                                   );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.Row_Height(p_ws     => sheet_id, -- Worksheet ID
                         p_row    => row_id, -- Row ID
                         p_Height => 50 -- Row height
                         );
  
  ploffx_xlsx.Cell_setBorder_Right(p_ws        => sheet_id, -- Worksheet ID
                                   p_row       => row_id, -- Row ID
                                   p_cell      => 'C', -- Column name
                                   p_LineStyle => ploffx_xlsx_styles.c_mediumDashDot, -- Line style
                                   p_color     => ploffx_xlsx_styles.c_Orange -- Border color
                                   );
  
  ploffx_xlsx.Cell_setBorder_Right(p_ws        => sheet_id, -- Worksheet ID
                                   p_row       => row_id, -- Row ID
                                   p_cell      => 'E', -- Column name
                                   p_LineStyle => ploffx_xlsx_styles.c_thick, -- Line style
                                   p_color     => ploffx_xlsx_styles.c_Cyan -- Border color
                                   );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setBorder_Right.xlsx');
  commit;
end;
--
procedure Cell_WrapText is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_WrapText' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Text,Text,Text,Text,Text,Text,Text,Text' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'WrapText,WrapText,WrapText,WrapText,WrapText,WrapText' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setWrapText(p_ws   => sheet_id, -- Worksheet ID
                               p_row  => row_id, -- Row ID
                               p_cell => 'A' -- Column name
                               );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_WrapText.xlsx');
  commit;
end;
--
procedure Cell_SetHyperlink is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_SetHyperlink' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Linkt to plpdf.com' -- String in the cell
                             );
  
  ploffx_xlsx.Cell_setHyperlink(p_ws        => sheet_id, -- Worksheet ID
                                p_row       => row_id, -- Rod ID
                                p_cell      => 'A', -- Column name
                                p_hyperlink => 'http://www.plpdf.com' -- Hyperlink text
                                );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_SetHyperlink.xlsx');
  commit;
end;
--
procedure Cell_SetComment is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_SetComment' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /*
  ploffx_xlsx.setDefaultFont(
  p_FontName => 'Calibri',
  p_Size => '9'
  );
  */
  
  ploffx_xlsx.Cell_setComment(p_ws     => sheet_id, -- Worksheet ID
                              p_row    => row_id, -- Row ID
                              p_cell   => 'B', -- Column name
                              p_text   => 'This is a comment example. Comment box size: 100x50', -- Text of the comment box
                              p_author => 'PLXLSX', -- Author name
                              p_width  => 100, -- Width of comment box
                              p_height => 50 -- Height of comment box
                              );
  
  ploffx_xlsx.Cell_setComment(p_ws     => sheet_id, -- Worksheet ID
                              p_row    => row_id, -- Row ID
                              p_cell   => 'C', -- Column name
                              p_text   => 'Second comment example. Comment box size: 200x80', -- Text of the comment box
                              p_author => 'PLXLSX', -- Author name
                              p_width  => 200, -- Width of comment box
                              p_height => 80 -- Height of comment box
                              );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_SetComment.xlsx');
  commit;
end;
--
procedure Cell_SetFormatMask is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Cell_SetFormatMask' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add date type data to a cell*/
  ploffx_xlsx.addCell_Date(p_ws   => sheet_id, -- Worksheet ID
                           p_row  => row_id, -- Row ID
                           p_cell => 'A', -- Column name
                           p_data => sysdate -- Date in the cell
                           );
  
  ploffx_xlsx.Cell_setFormatMask(p_ws          => sheet_id, -- Worksheet ID
                                 p_row         => row_id, -- Row ID
                                 p_cell        => 'A', -- Column name
                                 p_format_mask => 'yyyy.m.d' -- Format ID
                                 );
  
  /* Add date type data to a cell*/
  ploffx_xlsx.addCell_Date(p_ws   => sheet_id, -- Worksheet ID
                           p_row  => row_id, -- Row ID
                           p_cell => 'B', -- Column name
                           p_data => sysdate -- Date in the cell
                           );
  
  ploffx_xlsx.Cell_setFormatMask(p_ws          => sheet_id, -- Worksheet ID
                                 p_row         => row_id, -- Row ID
                                 p_cell        => 'B', -- Column name
                                 p_format_mask => 'd.m.yyyy' -- Format ID
                                 );
  
  /* Add date type data to a cell*/
  ploffx_xlsx.addCell_Number(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'C', -- Column name
                             p_data => 12345.6 -- Date in the cell
                             );
  
  ploffx_xlsx.Cell_setFormatMask(p_ws          => sheet_id, -- Worksheet ID
                                 p_row         => row_id, -- Row ID
                                 p_cell        => 'C', -- Column name
                                 p_format_mask => '##,###.00' -- Format ID
                                 );
  
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'C', -- Column ID
                           p_width  => 15 -- Width value
                           );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_SetFormatMask.xlsx');
  commit;
end;
--
procedure MergeCells is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'MergeCells' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  ploffx_xlsx.mergeCells(p_ws  => sheet_id, -- Worksheet ID
                         p_row => row_id, -- Row ID
                         -- p_cell => 'B',               -- Column name
                         p_cell_from => 'C', -- Start cell
                         p_cell_to   => 'G' -- End cell
                         );
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'C', -- Column name
                             p_data => 'Merged cells' -- String in the cell
                             );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'MergeCells.xlsx');
  commit;
end;
--
procedure MergeRows is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'MergeRows' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'C', -- Column name
                             p_data => 'Merged cells' -- String in the cell
                             );
  
  ploffx_xlsx.mergeRows(p_ws       => sheet_id,
                        p_row      => row_id,
                        p_cell     => 'C',
                        p_num_rows => 5);
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'MergeRows.xlsx');
  commit;
end;
--
procedure SetAutoFilter is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'AddAutoFilter' -- String in the cell
                             );
  
  for l_row in 1 .. 10 loop
    row_id := ploffx_xlsx.addRow(sheet_id);
    for l_col in 1 .. 10 loop
      ploffx_xlsx.addCell_String(sheet_id,
                                 row_id,
                                 l_col,
                                 'data' || l_row || '_' || l_col);
    end loop;
  end loop;
  
  ploffx_xlsx.setAutofilter(p_ws           => sheet_id, -- Worksheet ID
                            p_column_start => 'C', -- Start column
                            p_row_start    => 3 -- Start row
                            );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'SetAutoFilter.xlsx');
  commit;
end;
--
procedure SetAutoFilter2 is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'AddAutoFilter2' -- String in the cell
                             );
  
  for l_row in 1 .. 10 loop
    row_id := ploffx_xlsx.addRow(sheet_id);
    for l_col in 1 .. 10 loop
      ploffx_xlsx.addCell_String(sheet_id,
                                 row_id,
                                 l_col,
                                 'data' || l_row || '_' || l_col);
    end loop;
  end loop;
  
  ploffx_xlsx.setAutofilter(p_ws           => sheet_id, -- Worksheet ID
                            p_column_start => 'C', -- Start column
                            p_column_end   => 'F', --  End column
                            p_row_start    => 3, -- Start row
                            p_row_end      => 3 -- End row
                            );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'SetAutoFilter2.xlsx');
  commit;
end;
--
procedure RowFreeze is
  l_xls blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'RowFreeze' -- String in the cell
                             );
  
  for l_row in 1 .. 10 loop
    row_id := ploffx_xlsx.addRow(sheet_id);
    for l_col in 1 .. 10 loop
      ploffx_xlsx.addCell_String(sheet_id,
                                 row_id,
                                 l_col,
                                 'data' || l_row || '_' || l_col);
    end loop;
  end loop;
  
  ploffx_xlsx.Row_Freeze(p_ws          => sheet_id, -- Worksheet ID
                         p_number_rows => 3 -- Number of rows
                         );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'RowFreeze.xlsx');
  commit;
end;
--
procedure ColumnFreeze is
  l_xls       blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'ColumnFreeze' -- String in the cell
                             );
  
  for l_row in 1 .. 10 loop
    row_id := ploffx_xlsx.addRow(sheet_id);
    for l_col in 1 .. 10 loop
      ploffx_xlsx.addCell_String(sheet_id,
                                 row_id,
                                 l_col,
                                 'data' || l_row || '_' || l_col);
    end loop;
  end loop;
  
  ploffx_xlsx.Column_Freeze(p_ws             => sheet_id, -- Worksheet ID
                            p_number_columns => 5 -- Number of columns
                            );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'ColumnFreeze.xlsx');
  commit;
end;

procedure SetCurrentWorksheet is
  l_xls       blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init;
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'SetCurrentWorksheet' -- String in the cell
                             );
  
  sheet_id := ploffx_xlsx.addWorksheet(p_Name => 'Second');
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Second' -- String in the cell
                             );
  
  sheet_id := ploffx_xlsx.addWorksheet(p_Name => 'Third');
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Third' -- String in the cell
                             );
  
  ploffx_xlsx.setCurrentWorksheet(p_idx => 2);
  
  row_id := ploffx_xlsx.addRow(ploffx_xlsx.getCurrentWorksheet); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => ploffx_xlsx.getCurrentWorksheet, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'New String to second Worksheet' -- String in the cell
                             );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'SetCurrentWorksheet.xlsx');
  commit;
end;
--
procedure QueryExample is
  l_xls    blob;
  sheet_id pls_integer; -- Worksheet ID
  row_id   pls_integer; -- Row ID
  --
  type t_row_datas is table of varchar2(4000 char) index by pls_integer; -- data row type
  l_datas t_row_datas; -- Array of datas
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Query Example' -- String in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id);
  
  /* Create header for the Query */
  
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'ROWNUM' -- String in the cell
                             );
  --
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 'OWNER' -- String in the cell
                             );
  --
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'C', -- Column name
                             p_data => 'OBJECT_NAME' -- String in the cell
                             );
  
  for l_i in ascii('A') .. ascii('C') loop
    --
    ploffx_xlsx.Cell_setColor(p_ws    => sheet_id, -- Workshet ID
                              p_row   => row_id, -- Row ID
                              p_cell  => chr(l_i), -- Column name
                              p_color => '5566EE' -- Color
                              );
    --
    ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                             p_column => chr(l_i), -- Column ID
                             p_width  => 28 -- Width value
                             );
  end loop;
  --
  
  /* Get data from a table and insert them to an xlsx file */
  for f_obj in (select rownum, owner, object_name
                  from all_objects
                 where rownum <= 10) loop
    
    /* Set datas */
    l_datas(1) := to_char(f_obj.rownum);
    l_datas(2) := f_obj.owner;
    l_datas(3) := f_obj.object_name;
    
    row_id := ploffx_xlsx.addRow(sheet_id); -- add new row to the xlsx file
    
    /* Fill up the cell with data */
    ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                               p_row  => row_id, -- Row ID
                               p_cell => 'A', -- Column name
                               p_data => l_datas(1) -- String in the cell
                               );
    --
    ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                               p_row  => row_id, -- Row ID
                               p_cell => 'B', -- Column name
                               p_data => l_datas(2) -- String in the cell
                               );
    --
    ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                               p_row  => row_id, -- Row ID
                               p_cell => 'C', -- Column name
                               p_data => l_datas(3) -- String in the cell
                               );
    
  end loop;
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'QueryExample.xlsx');
  commit;
end;
--
procedure ImportToDb is
  l_xlsx   blob;
  l_sheets ploffx_xls_parser.t_sheets; -- store XLSX cells
  l_cell   ploffx_xls_parser.t_cell; -- one cell data
begin
  -- get the source xlsx file from a table
  select blob_file
    into l_xlsx
    from store_blob
   where filename = 'xlsx_example';

  -- load the blob file to the ploffx_xlsx application
  l_sheets := ploffx_xlsx_parser.ParseXLS(l_xlsx);
  
  -- go through the sheet of the xlsx document
  for l_sheet_idx in 1 .. l_sheets.count loop
    -- go through the rows of the current sheet
    for l_row_idx in 1 .. l_sheets(l_sheet_idx).cells.count loop
      -- go through the cols of the current row
      for l_col_idx in 1 .. l_sheets(l_sheet_idx).cells(l_row_idx).count loop
        -- get the current cell
        l_cell := l_sheets(l_sheet_idx).cells(l_row_idx) (l_col_idx);
        -- insert cell data to a custom table
        insert into xlsx_text
        values
          (l_col_idx, l_cell.cell_text, l_cell.cell_id, l_cell.data_type);
      --
      end loop;
      --
    end loop;
    --
  end loop;
  --
  commit;
  --
end;

procedure ImportToDbOneCell is
  l_xlsx   blob;
  l_sheets ploffx_xls_parser.t_sheets; -- store XLSX cells
  l_cell   ploffx_xls_parser.t_cell; -- one cell data
begin
  -- get the source xlsx file from a table
  select blob_file
    into l_xlsx
    from store_blob
   where filename = 'xlsx_example';
 
  -- load the blob file to the ploffx_xlsx application
  l_sheets := ploffx_xlsx_parser.ParseXLS(l_xlsx);
  
  -- go through the sheet of the xlsx document
  for l_sheet_idx in 1 .. l_sheets.count loop
    -- go through the rows of the current sheet
    for l_row_idx in 1 .. l_sheets(l_sheet_idx).cells.count loop
      -- go through the cols of the current row
      for l_col_idx in 1 .. l_sheets(l_sheet_idx).cells(l_row_idx).count loop
        -- get the current cell
        l_cell := l_sheets(l_sheet_idx).cells(l_row_idx) (l_col_idx);
        
        -- if you want to get data only a specific cell, you can do it multiple ways
        if l_cell.cell_id = 'A2' then
          -- insert cell data to a custom table
          insert into xlsx_text
          values
            (l_col_idx,
             l_cell.cell_text,
             l_cell.cell_id,
             l_cell.data_type);
        end if;
        
      --
      end loop;
      --
    end loop;
    --
  end loop;
  --
  commit;
  --
end;
--
procedure SetPrinterSettings is
  l_xls       blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
  l_format_id pls_integer; -- Format ID
  font_id     pls_integer; -- Font ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  font_id := ploffx_xlsx.addFont(p_font_name => 'Calibri', -- Font family
                                 p_font_size => 12, -- Font size
                                 p_italic    => true, -- Italic
                                 p_underline => false, -- Underline
                                 p_bold      => false, -- Bold
                                 p_color     => 'FF0000' -- Color
                                 );
  
  l_format_id := ploffx_xlsx.addFormat(p_fontid => font_id);
  
  ploffx_xlsx.addCell_String(p_ws        => sheet_id, -- Worksheet ID
                             p_row       => row_id, -- Row ID
                             p_cell      => 'A', -- Column name
                             p_data      => 'SetPrinterSettings', -- Data in the cell
                             p_format_id => l_format_id -- Set format
                             );
  -- Set printer settings
  ploffx_xlsx.setPrinterSettings(p_ws            => sheet_id, -- Worksheet ID
                                 p_paperSize     => ploffx_sheet.paperSize_A5, -- Papersize
                                 p_blackAndWhite => true, -- Black and white printing
                                 p_orientation   => ploffx_sheet.c_landscape);
  
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'SetPrinterSettings.xlsx');
  commit;
end;
--
procedure Cell_setFormula is
  l_xls    blob;
  sheet_id pls_integer; -- Worksheet ID
  row_id   pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet2'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Set column width */
  ploffx_xlsx.Column_Width(p_ws     => sheet_id, -- Worksheet ID
                           p_column => 'A', -- Column ID
                           p_width  => 20 -- Width value
                           );
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'First data' -- String in the cell
                             );
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Number(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 2 -- Number in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'Second data' -- String in the cell
                             );
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Number(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => 5 -- Number in the cell
                             );
  
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'SUM data' -- String in the cell
                             );
  
  /* Add number type data to a cell*/
  ploffx_xlsx.addCell_Number(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'B', -- Column name
                             p_data => null -- Number in the cell
                             );
  
  ploffx_xlsx.Cell_setFormula(p_ws      => sheet_id,
                              p_row     => row_id,
                              p_cell    => 'B',
                              p_formula => '=SUM(B1:B2)');
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'Cell_setFormula.xlsx');
  commit;
end;
--
procedure SetAutoFilter3 is
  l_xls       blob;
  sheet_id    pls_integer; -- Worksheet ID
  row_id      pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet3'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'D', -- Column name
                             p_data => 'AddAutoFilter' -- String in the cell
                             );
  
  for l_row in 3 .. 15 loop
    row_id := ploffx_xlsx.addRow(sheet_id);
    for l_col in 5 .. 10 loop
      ploffx_xlsx.addCell_String(sheet_id,
                                 row_id,
                                 l_col,
                                 'data' || l_row || '_' || l_col);
    end loop;
  end loop;
  
  for l_row in 30 .. 40 loop
    row_id := ploffx_xlsx.addRow(sheet_id);
    for l_col in 20 .. 34 loop
      ploffx_xlsx.addCell_String(sheet_id,
                                 row_id,
                                 l_col,
                                 'data' || l_row || '_' || l_col);
    end loop;
  end loop;
  
  ploffx_xlsx.setAutofilter(p_ws           => sheet_id, -- Worksheet ID
                            p_column_start => 'C', -- Start column
                            p_row_start    => 8 -- Start row
                            );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'SetAutoFilter3.xlsx');
  commit;
end;
--
procedure AddImage is
  l_xls   blob;
  l_image blob;
  sheet_id pls_integer; -- Worksheet ID
  row_id   pls_integer; -- Row ID
begin
  ploffx_xlsx.init; -- Initializes generator program variables
  
  sheet_id := ploffx_xlsx.addWorksheet('NewWorksheet3'); -- Add new worksheet
  row_id   := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  
  /* Add string type data to a cell */
  ploffx_xlsx.addCell_String(p_ws   => sheet_id, -- Worksheet ID
                             p_row  => row_id, -- Row ID
                             p_cell => 'A', -- Column name
                             p_data => 'AddImage' -- String in the cell
                             );
  
  select image_file into l_image from image_blob where id = 1; --Select image file to blob
  
  ploffx_xlsx.addImage(p_ws                 => sheet_id, --Worksheet ID
                       p_row_from           => row_id, --Row ID
                       p_column_from        => '4', --Column ID
                       p_name               => 'test1.jpg', --Image name
                       p_image              => l_image, --Image blob
                       p_height             => 204, --Image height(pixel)
                       p_width              => 204, --Image width(pixel)
                       p_descr              => 'this is an image', --Description for the image
                       p_column_from_offset => 20, --Offset from the column(pixel)
                       p_row_from_offset    => 50 --Offset from the row(pixel)
                       );
  
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'AddImage.xlsx');
  commit;
end;
/* End of package */
end;
/
