create or replace procedure plpdf3_xhtml_ol_test as
  v_out blob; -- result PDF
begin
  -- initialize
  plpdf.init();
  -- plpdf.SetEncoding(plpdf_const.iso_8859_1);
  -- create a new page
  plpdf.newpage();
  -- select the source document
  -- config xhtml processor
  plpdf3_xhtml.init();
  -- call XHTML processor
  --<p>' || l_text ||' <img src="1.png" width="20" height="10"/> ' || l_text ||'</p>
  plpdf3_xhtml.toPdf(
  p_img_proc => 'get_img',
  p_src =>
  '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
  <head>
    <meta name="author" content="LL" />
    <meta name="subject" content="test" />
    <title>PL/PDF XHTML Test</title>
  </head>
 <body>
   <p> Ordered List Test </p>
   <ol>
     <li>Seasons the dry deep that in i. Had, it upon.</li>
     <li>For tree yielding. Replenish wherein lesser rule seed grass creeping.</li>
     <li>Creepeth morning appear was in saying under. Us fifth Said.</li>
     <li>Over morning you shed whales whales, creature doesnt you beginning.</li>
   </ol>
   <p> Ordered list starting at 20 </p>
   <ol start="20">
     <li>Seasons the dry deep that in i. Had, it upon.</li>
     <li>For tree yielding. Replenish wherein lesser rule seed grass creeping.</li>
     <li>Creepeth morning appear was in saying under. Us fifth Said.</li>
     <li>Over morning you shed whales whales, creature doesnt you beginning.</li>
   </ol>
   <p> Ordered list with capital letters </p>
   <ol type="A">
     <li>Seasons the dry deep that in i. Had, it upon.</li>
     <li>For tree yielding. Replenish wherein lesser rule seed grass creeping.</li>
     <li>Creepeth morning appear was in saying under. Us fifth Said.</li>
     <li>Over morning you shed whales whales, creature doesnt you beginning.</li>
   </ol>
   <p> Ordered list with small letters</p>
   <ol type="a">
     <li>Seasons the dry deep that in i. Had, it upon.</li>
     <li>For tree yielding. Replenish wherein lesser rule seed grass creeping.</li>
     <li>Creepeth morning appear was in saying under. Us fifth Said.</li>
     <li>Over morning you shed whales whales, creature doesnt you beginning.</li>
   </ol>
   <p> Ordered list with Roman numerals </p>
   <ol type="I">
     <li>Seasons the dry deep that in i. Had, it upon.</li>
     <li>For tree yielding. Replenish wherein lesser rule seed grass creeping.</li>
     <li>Creepeth morning appear was in saying under. Us fifth Said.</li>
     <li>Over morning you shed whales whales, creature doesnt you beginning.</li>
   </ol>
   <p> Ordered list with Small Roman numerals </p>
   <ol type="i">
     <li>Seasons the dry deep that in i. Had, it upon.</li>
     <li>For tree yielding. Replenish wherein lesser rule seed grass creeping.</li>
     <li>Creepeth morning appear was in saying under. Us fifth Said.</li>
     <li>Over morning you shed whales whales, creature doesnt you beginning.</li>
   </ol>
 </body>
</html>'
  );

  plpdf.senddoc(v_out);
  -- save result
  delete from store_blob;
  insert into store_blob values(v_out, sysdate,'plpdf3_xhtml_ol_test.pdf');
  commit;
end;
