create or replace procedure plpdf3_xhtml_img_test as
  v_out blob; -- result PDF
begin
  -- initialize
  plpdf.init();
  -- plpdf.SetEncoding(plpdf_const.iso_8859_1);
  -- create a new page
  plpdf.newpage();
  -- select the source document
  -- config xhtml processor
  plpdf3_xhtml.init();
  -- call XHTML processor
  --<p>' || l_text ||' <img src="1.png" width="20" height="10"/> ' || l_text ||'</p>
  plpdf3_xhtml.toPdf(
  p_img_proc => 'get_img',
  p_src =>
  '<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
  <head>
    <meta name="author" content="LL" />
    <meta name="subject" content="test" />
    <title>PL/PDF XHTML Test</title>
  </head>
 <body>
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
  Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
  Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat
  cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
  <img src="1.png"/>
  Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
  Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure
  dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non
  proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
</body>
</html>'
  );

  plpdf.senddoc(v_out);
  -- save result
  delete from store_blob;
  insert into store_blob values(v_out, sysdate,'plpdf3_xhtml_img_test.pdf');
  commit;
end;
