create or replace package RowExamples is
--default cell
procedure DefaultRow;
--margin
procedure setMargin;
--border
procedure setBorder;
--padding
procedure setPadding;
--box
procedure setBoxProperties;
--background color
procedure setBackgroundColor;
--box+background color
procedure setBoxBackgroundColor;
--v3.6.0
procedure RowXhtml;
--
end RowExamples;
/
create or replace package body RowExamples is
--
v_text_short plpdf_type.v2avg :=
  'Portable Document Format (PDF) is a file format used to present documents ' ||
  'in a manner independent of application software, hardware, and operating systems.';
--
v_text_long plpdf_type.v2long :=
  'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor ' ||
  'incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud ' ||
  'exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure ' ||
  'dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. ' ||
  'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt ' ||
  'mollit anim id est laborum.';
--Draw page margins
procedure drawPageMargins
  is
begin
  --left
  plpdf.Line(
    p_x1 => plpdf.getLeftMargin,
    p_y1 => 0,
    p_x2 => plpdf.getLeftMargin,
    p_y2 => plpdf.getPageHeight,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
  --right
  plpdf.Line(
    p_x1 => plpdf.getPageWidth - plpdf.getRightMargin,
    p_y1 => 0,
    p_x2 => plpdf.getPageWidth - plpdf.getRightMargin,
    p_y2 => plpdf.getPageHeight,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
   --top
  plpdf.Line(
    p_x1 => 0,
    p_y1 => plpdf.getTopMargin,
    p_x2 => plpdf.getPageWidth,
    p_y2 => plpdf.getTopMargin,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
   --bottom
  plpdf.Line(
    p_x1 => 0,
    p_y1 => plpdf.getPageHeight - plpdf.getBottomMargin,
    p_x2 => plpdf.getPageWidth,
    p_y2 => plpdf.getPageHeight - plpdf.getBottomMargin,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
end;
--Create and print one row
procedure print1row is
  l_cell plpdf_cell.t_cell;
begin
  plpdf_row.crRow(
   --p_cantSplit boolean default null,
   --p_min_height number default null
    );

  plpdf_cell.init; --reset layour settings
  --
  l_cell := plpdf_cell.crCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => v_text_short -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    );
  plpdf_row.AddCell(
    p_cell => l_cell
    );

  l_cell := plpdf_cell.crCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => v_text_long -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    );
   plpdf_row.AddCell(
      p_cell => l_cell
      );
  --
  plpdf_row.printRow;
end;
--default Row
procedure DefaultRow
  is
  l_blob blob;
begin
  --Initialize inner variables
  plpdf.init();
  --Create new page
  plpdf.NewPage();
  --Create new font
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style => null,
    p_size => 12
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_row.init;
  --Print row
  print1row;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintRow Example - DefaultRow' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DefaultRow');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.DefaultRow;
    commit;
  end;
  */
end DefaultRow;
--
--margin
procedure setMargin
  is
  l_blob blob;
begin
  --Initialize inner variables
  plpdf.init();
  --Create new page
  plpdf.NewPage();
  --Create new font
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style => null,
    p_size => 12
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_row.init;
  --Set margin for row
  plpdf_row.setMargin(10);
  --Set border width
  plpdf_row.setBorderWidth(0.5);
  --Print row
  print1row;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintRow Example - setMargin' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf.NewLine(plpdf_cell.getLastCellHeight);
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Margin is the spacing after the border.' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setMargin');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.setMargin;
    commit;
  end;
  */
end setMargin;
--
--border
procedure setBorder
  is
  l_blob blob;
begin
  --Initialize inner variables
  plpdf.init();
  --Create new page
  plpdf.NewPage();
  --Create new font
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style => null,
    p_size => 12
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_row.init;
  --Set border width
  plpdf_row.setBorderWidth(0.5);
  --Set border color
  plpdf_row.setBorderColor(plpdf_const.Red);
  --Print row
  print1row;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintRow Example - setBorder' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBorder');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.SetBorder;
    commit;
  end;
  */
end setBorder;
--
--padding
procedure setPadding
  is
  l_blob blob;
begin
  --Initialize inner variables
  plpdf.init();
  --Create new page
  plpdf.NewPage();
  --Create new font
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style => null,
    p_size => 12
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_row.init;
  --Set padding
  plpdf_row.setPadding(10);
  --Set border width
  plpdf_row.setBorderWidth(0.5);
  --Print row
  print1row;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintRow Example - setPadding' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf.NewLine(plpdf_cell.getLastCellHeight);
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Padding is the spacing before the border.' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setPadding');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.setPadding;
    commit;
  end;
  */
end setPadding;
--
--setBoxProperties
procedure setBoxProperties
  is
  l_blob blob;
begin
  --Initialize inner variables
  plpdf.init();
  --Create new page
  plpdf.NewPage();
  --Create new font
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style => null,
    p_size => 12
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_row.init;
  --Set margin
  plpdf_row.setMargin(0.5);
  --Set border width
  plpdf_row.setBorderWidth(0.7);
  --Set border color
  plpdf_row.setBorderColor(plpdf_const.Dark_turquoise);
  --Set padding
  plpdf_row.setPadding(0.9);
  --Print row
  print1row;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintRow Example - setBoxProperties' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBoxProperties');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.setBox;
    commit;
  end;
  */
end setBoxProperties;
--
--background color
procedure setBackgroundColor
  is
  l_blob blob;
begin
  --Initialize inner variables
  plpdf.init();
  --Create new page
  plpdf.NewPage();
  --Create new font
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style => null,
    p_size => 12
    );
  --Draw page margins
  drawPageMargins;
  --Create new line
  plpdf.NewLine(plpdf_cell.getLastCellHeight);
  --Reset layout settings
  plpdf_row.init;
  --Set background color
  plpdf_row.setBackgroundColor(plpdf_const.Yellow);
  --Print row
  print1row;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintRow Example - setBackgroundColor' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBackgroundColor');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.setBackgroundColor;
    commit;
  end;
  */
end setBackgroundColor;
--Set row background color
procedure setBoxBackgroundColor
  is
  l_blob blob;
begin
  --Initialize inner variables
  plpdf.init();
  --Create new page
  plpdf.NewPage();
  --Create new font
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style => null,
    p_size => 12
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_row.init;
  --Set margin
  plpdf_row.setMargin(0.5);
  --Set border width
  plpdf_row.setBorderWidth(0.7);
  --Set border color
  plpdf_row.setBorderColor(plpdf_const.Dark_turquoise);
  --Set padding
  plpdf_row.setPadding(0.9);
  --Set background color
  plpdf_row.setBackgroundColor(plpdf_const.Yellow);
  --Print row
  print1row;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintRow Example - setBoxBackgroundColor' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBoxBackgroundColor');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.setBoxBackgroundColor;
    commit;
  end;
  */
end setBoxBackgroundColor;
--
--v3.6.0
procedure RowXhtml
  is
  l_blob blob;
  l_cell1  plpdf_cell.t_cell;
  l_cell2  plpdf_cell.t_cell;
  l_cell3  plpdf_cell.t_cell;
begin
  plpdf.Init;
  plpdf.NewPage();
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style  => null,
    p_size   => 12
    );
  -- cells in row
  plpdf_cell.printCell(p_text => '---XHTML cells in a row.');
  l_cell1 := plpdf_cell.crCellXHTML(p_text => '<u>Test</u>');
  l_cell2 := plpdf_cell.crCellXHTML(p_text => '<a href="www.plpdf.com">Test</a>');
  l_cell3 := plpdf_cell.crCellXHTML(p_text => '<p><font face="Times-Roman" color="blue">Test<br></br><b><a href="www.something.com">Te<i>st</i></a></b><u>Te<b>s</b>t</u><br></br>TesttEST<i>Te<u>s</u>t</i></font></p>');
  plpdf_row.crRow(p_width => 100,p_min_height => 30);
  plpdf_row.AddCell(l_cell1);
  plpdf_row.AddCell(l_cell2);
  plpdf_row.AddCell(l_cell3);
  plpdf_row.printRow;
  plpdf.SendDoc(
    p_blob => l_blob
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'RowXhtml');
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    RowExamples.setBoxBackgroundColor;
    commit;
  end;
  */
end RowXhtml;
--   
--
end RowExamples;
/
