create or replace procedure row_chart_example is
  l_box plpdf3.t_box;
  l_blob blob;
begin
  /* Creating a box for the legend */
  l_box.background_color := plpdf_const.Medium_aquamarine;
  l_box.padding.left := 0;
  l_box.border.top := plpdf3.crBorder1(plpdf_const.Black, 0.5, plpdf3.c_double);
  l_box.border.bottom := plpdf3.crBorder1(plpdf_const.Black, 0.5, plpdf3.c_double);
  l_box.border.left := plpdf3.crBorder1(plpdf_const.Black, 0.5, plpdf3.c_double);
  l_box.border.right := plpdf3.crBorder1(plpdf_const.Black, 0.5, plpdf3.c_double);
  plpdf.Init(p_unit => 'pt');
  plpdf.NewPage();
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style  => null,
    p_size   => 8
    );
  /* Initializing */
  plpdf3_chart.Init(
     p_type => plpdf3_chart.c_bar   -- Initializing the chart variables, and defining the type of the chart(Bar,Pie,Line)
     );          
  plpdf3_chart.setBarProperties(
     p_direction => plpdf3_chart.c_row, -- Define if it is a Column or a Row Chart.
     p_gap => 219                   
     );       
  /* Creating categories */
  plpdf3_chart.AddCategory(
     p_textValue => 'Category 1'
     );
  plpdf3_chart.AddCategory(
     p_textValue => 'Category 2'
     );
  plpdf3_chart.AddCategory(
     p_textValue => 'Category 3'
     );
  /* Creating Series' and loading them with data */
  plpdf3_chart.addDataSet(
     p_name => 'Series 1',        -- Name of the Series
     p_color => plpdf_const.Red   -- You can select the color of the columns(/rows)
     ); 
  plpdf3_chart.setDataSetLabel(   -- Sets where the Labels will be shown on the bar for this Data Set
    p_position => plpdf3_chart.c_outEnd -- Outside of the bar at the end of it
    );
  plpdf3_chart.AddValue(
     p_value => 4,              -- Value of the data
     p_idx => 1                   -- Index in the Series
     );
  plpdf3_chart.AddValue(2.5,2);
  plpdf3_chart.AddValue(3.5,3);
  plpdf3_chart.addDataSet('Series 2', plpdf_const.Green);
  plpdf3_chart.setDataSetLabel(plpdf3_chart.c_inEnd);
  plpdf3_chart.AddValue(2.4,1);
  plpdf3_chart.AddValue(4.4,2);
  plpdf3_chart.AddValue(1.8,3);
  plpdf3_chart.addDataSet('Series 3', plpdf_Const.purple);
  plpdf3_chart.setDataSetLabel(plpdf3_chart.c_ctr);
  plpdf3_chart.AddValue(2,1);
  plpdf3_chart.AddValue(2,2);
  plpdf3_chart.AddValue(3,3);
  plpdf3_chart.addDataSet('Series 4', plpdf_Const.Medium_spring_green);
  plpdf3_chart.setDataSetLabel(plpdf3_chart.c_inBase);
  plpdf3_chart.AddValue(2.8,1);
  plpdf3_chart.AddValue(6.4,2);
  plpdf3_chart.AddValue(4.1,3);
  
  /* X Axis */
  plpdf3_chart.setXAxisTitle(      -- Sets the properties of the Horizontal Axis' title
    p_title => 'Horizontal Axis',
    p_angle => 0,
    p_bold => true,
    p_font => plpdf_const.Times_Roman, 
    p_size => 12, 
    p_text_color => plpdf_const.Blue
    );
  plpdf3_chart.setXAxisLine(       -- Sets the properties of the Horizontal Axis
    p_lineType => plpdf3_chart.c_sng, 
    p_color => plpdf_const.Gray
    );
  plpdf3_chart.setXLabels(         -- Sets the prooperties of the Labels on the Horizontal Axis
    p_align => plpdf3_chart.c_b,   -- Alignment
    p_offset => 0,                 -- Distance from the axis
    p_fontname => plpdf_const.Times_Roman,
    p_italic => true,
    p_bold => true,
    p_fontsize => 10,
    p_color => plpdf_const.Red
    );
  plpdf3_chart.setXMajorGridLine(  -- Sets the major gridlines on the Horizontal Axis
    p_lineType => plpdf3_chart.c_sng, 
    p_color => plpdf_const.Black
    );
  plpdf3_chart.setXMinorGridLine(   -- Sets the minor gridlines on the Horizontal Axis
    p_lineType => plpdf3_chart.c_sng,
    p_color => plpdf_const.Gray
    );
  plpdf3_chart.setXTickMarks(       -- Sets the properties of the Tick Marks on the Horizontal Axis
    p_major => plpdf3_chart.c_in,   -- Inside of the axis
    p_minor => plpdf3_chart.c_out,  -- Outside of the axis
    p_labelPosition => plpdf3_chart.c_low -- Label position: Below the axis
    );
  /*plpdf3_chart.setXAxisScaling(  You can define the start/end value of the axis, but it is calculated automatically if you don't.
    p_min => 0,                    -- Minimum value
    p_max => 11.0,                 -- Maximum value
    p_orientation => plpdf3_chart.c_minMax
    );*/  
  /*plpdf3_chart.setXUnitShift(    You can define the value shift of the axis, but it is calculated automatically if you don't.
    p_major => 2.0,                -- Major shift
    p_minor => 0.2                 -- Minor shift
    );*/
    
  /* Y Axis */
  plpdf3_chart.setYAxisTitle(       -- Sets the properties of the Vertical Axis' title
    p_title => 'Vertical Axis', 
    p_angle => 270, 
    p_bold => true, 
    p_font => plpdf_const.Times_Roman, 
    p_size => 12, 
    p_text_color => plpdf_const.Blue
    );
  plpdf3_chart.setYAxisLine(        -- Sets the properties of the Vertical Axis
    p_showAxis => false             -- The labels will not be shown
    );
  plpdf3_chart.setYLabels(          -- Sets the prooperties of the Labels on the Horizontal Axis
    p_align => plpdf3_chart.c_b,    -- Alignment
    p_offset => 100,                -- Distance from the axis
    p_fontname => plpdf_const.Times_Roman, 
    p_fontsize => 9,
    p_color => plpdf_const.Purple
    );
  plpdf3_chart.setYMajorGridLine(   -- Sets the major gridlines on the Vertical Axis
    p_lineType => plpdf3_chart.c_sng,
    p_color => plpdf_const.Black
    );
  plpdf3_chart.setYTickMarks(       -- Sets the properties of the Tick Marks on the Vertical Axis
    plpdf3_chart.c_in,              -- Outside of the axis
    plpdf3_chart.c_cross,           -- Across the axis
    plpdf3_chart.c_nextTo           -- Label position: Next to the axis
    );
  /* Legend */                          
  plpdf3_chart.AddLegend(          -- Creating a Legend to the chart
    p_position => plpdf3_chart.c_t,-- Position of the Legend
    p_box => l_box                 -- Properties of the legend
    );
  /* Drawing */
  plpdf3_chart.DrawChart(          -- Sets the dimensions of the chart
    p_x => 25 * plpdf_util.unit2factor('mm'),             -- X Position (Top left corner)
    p_y => 25 * plpdf_util.unit2factor('mm'),             -- Y Position (Top left corner)
    p_width => 160 * plpdf_util.unit2factor('mm'),        -- Width
    p_Height => 90 * plpdf_util.unit2factor('mm'));       -- Height
  plpdf.SendDoc(
    p_blob => l_blob
    );
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'row_chart.pdf');
  commit;
end;
