create or replace package CellExamples is
--Drawing a default cell
procedure DefaultCell;
--Set cell margins
procedure setMargin;
--Set cell border
procedure setBorder;
--Set cell paddings
procedure setPadding;
--Set box properties
procedure setBoxProperties;
--Set cell background color
procedure setBackgroundColor;
--Set box background color
procedure setBoxBackgroundColor;
--Set font for text
procedure setFont;
--Set cell size
procedure setCellSize;
--Set cell size to clip text
procedure setCellSizeClipped;
--Set hyperlink
procedure setHyperlink;
--Set text alignment
procedure setAlign;
--Set vertical align
procedure setVerticalAlign;
--Set cursor position
procedure setCursorPosition;
--Set multiline cell
procedure MultilineCell;
--Image cell
procedure ImageCell;
--Code39 Barcode Cell
procedure Code39BarcodeCell;
--Set current X coordinates
procedure setCurrentX;
--Set current Y coordinates
procedure setCurrentY;
--Set current XY coordinates
procedure setCurrentXY;
--Set top,left,bottom and right margins
procedure setMargins;
--Set top,left,bottom and right paddings
procedure setPaddings;
--v3.6.0
procedure cellXhtml;
--
end CellExamples;
/
create or replace package body CellExamples is
l_sample_text varchar2(1000) := 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.';
l_long_text varchar2(1000) := 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Maecenas tristique tellus et placerat molestie. Duis commodo interdum nisl. Quisque finibus dui id nisi porta scelerisque. Sed placerat orci nunc, id tristique risus scelerisque ac. Suspendisse sed nisi condimentum mauris sollicitudin pellentesque. Praesent ipsum ex, vestibulum ac erat sit amet, scelerisque tincidunt lectus. Vestibulum eget mattis dui, id tincidunt sapien. Aenean condimentum, ipsum vel maximus suscipit, libero odio ullamcorper felis, hendrerit feugiat risus mi vel justo. In finibus erat fermentum leo faucibus, nec fringilla erat tincidunt. Fusce bibendum mauris a quam porttitor, id laoreet mauris feugiat. Quisque fermentum eros nec feugiat.';
--Procedure to draw page margins
procedure drawPageMargins
  is
begin
  --left
  plpdf.Line(
    p_x1 => plpdf.getLeftMargin,
    p_y1 => 0,
    p_x2 => plpdf.getLeftMargin,
    p_y2 => plpdf.getPageHeight,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
  --right
  plpdf.Line(
    p_x1 => plpdf.getPageWidth - plpdf.getRightMargin,
    p_y1 => 0,
    p_x2 => plpdf.getPageWidth - plpdf.getRightMargin,
    p_y2 => plpdf.getPageHeight,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
   --top
  plpdf.Line(
    p_x1 => 0,
    p_y1 => plpdf.getTopMargin,
    p_x2 => plpdf.getPageWidth,
    p_y2 => plpdf.getTopMargin,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
   --bottom
  plpdf.Line(
    p_x1 => 0,
    p_y1 => plpdf.getPageHeight - plpdf.getBottomMargin,
    p_x2 => plpdf.getPageWidth,
    p_y2 => plpdf.getPageHeight - plpdf.getBottomMargin,
    p_color => plpdf_const.Green,
    p_width => 0.1
    );
end drawPageMargins;
--Drawing a default cell
procedure DefaultCell
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => l_sample_text                        -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - DefaultCell' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DefaultCell');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.DefaultCell;
    commit;
  end;
  */
end DefaultCell;
--Set cell margins
procedure setMargin
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setMargin(10);
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => l_sample_text                                  -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setMargin' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Margin is the spacing after the border' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setMargin');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.setMargin;
    commit;
  end;
  */
end setMargin;
--
--Set cell borders
procedure setBorder
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => l_sample_text -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setBorder' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBorder');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.SetBorder;
    commit;
  end;
  */
end setBorder;
--
--Set cell paddings
procedure setPadding
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set padding
  plpdf_cell.setPadding(0.8);
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => l_sample_text                        -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setPadding' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Padding is the spacing before the border' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setPadding');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setPadding;
    commit;
  end;
  */
end setPadding;
--
--Set box properties
procedure setBoxProperties
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setMargin(5);
  --Set border width
  plpdf_cell.setBorderWidth(1);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Dark_turquoise);
  --Set background color
  plpdf_cell.setBackgroundColor(plpdf_const.Light_grey);
  --Set padding
  plpdf_cell.setPadding(5);
  --Print cell
  plpdf_cell.printMultilineCell(
    p_width => 110,
    p_height => 30,                                         -- Cell height
    p_text => 'Set box properties: light grey background,' ||
    ' light grey padding, dark turquoise border and'||
    ' transparent margin'                                    -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setBoxProperties' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBoxProperties');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setBox;
    commit;
  end;
  */
end setBoxProperties;
--Set cell background color
procedure setBackgroundColor
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set cell background color
  plpdf_cell.setBackgroundColor(plpdf_const.Yellow);
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => l_sample_text                             -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text height
    p_text => 'PrintCell Example - setBackgroundColor' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBackgroundColor');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setBackgroundColor;
    commit;
  end;
  */
end setBackgroundColor;
--Set box background color
procedure setBoxBackgroundColor
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setMargin(0.5);
  --Set border width
  plpdf_cell.setBorderWidth(0.7);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Dark_turquoise);
  --Set padding
  plpdf_cell.setPadding(0.9);
  --Set cell background color
  plpdf_cell.setBackgroundColor(plpdf_const.Yellow);
  --Print cell
  plpdf_cell.printCell(
    p_width => 150,                                -- Cell width
    p_height => 20,                                -- Cell height
    p_text => ' '                          -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setBoxBackgroundColor' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setBoxBackgroundColor');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setBoxBackgroundColor;
    commit;
  end;
  */
end setBoxBackgroundColor;
--Set font for text
procedure setFont
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set font name
  plpdf_cell.setFontName(plpdf_const.Courier);
  --Set font size
  plpdf_cell.setFontSize(12);
  --Set font bold
  plpdf_cell.setFontBold;
  --Set font italic
  plpdf_cell.setFontItalic;
  --Set font underline
  plpdf_cell.setFontUnderline;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => l_sample_text                  -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setFont'        -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setFont');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setFont;
    commit;
  end;
  */
end setFont;
--
--Set cell size
procedure setCellSize
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print cell
  plpdf_cell.printCell(
    p_width => 150,                                -- Cell width
    p_height => 20,                                -- Cell height
    p_text => l_sample_text                        -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setCellSize' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setCellSize');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setCellSize;
    commit;
  end;
  */
end setCellSize;
--Set cell size to clip text
procedure setCellSizeClipped
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print cell
  plpdf_cell.printCell(
    p_width => 50,                                 -- Cell width
    p_height => 20,                                -- Cell height
    p_text => l_sample_text                        -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setCellSizeClipped' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setCellSizeClipped');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setCellSize2;
    commit;
  end;
  */
end setCellSizeClipped;
--
--Set hyperlink
procedure setHyperlink
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Print cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Link for plpdf.com',                 -- Printed text
    p_link => 'www.plpdf.com'                       -- Hyperlink
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setHyperlink' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setHyperlink');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setHyperlink;
    commit;
  end;
  */
end setHyperlink;
--
--Set text alignment
procedure setAlign
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setMargin(0.5);
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print cell
  plpdf_cell.printCell(
    p_width => 100,                                 -- Cell width
    p_height => 20,                                 -- Cell height
    p_text => 'Text alignment left', -- Printed text
    --p_hyperlink: null is default: no link
    p_align => plpdf3.c_left                        -- Text alignment
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Set cursor position in a new line
  plpdf_cell.NewLine;
  --Print cell
  plpdf_cell.printCell(
    p_width => 100,                                 -- Cell width
    p_height => 20,                                 -- Cell height
    p_text => 'Text alignment center', -- Printed text
    --p_hyperlink: null is default: no link
    p_align => plpdf3.c_center                      -- Text alignment
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Set cursor position in a new line
  plpdf_cell.NewLine;
  --Print cell
  plpdf_cell.printCell(
    p_width => 100,                                 -- Cell width
    p_height => 20,                                 -- Cell height
    p_text => 'Text alignment right', -- Printed text
    --p_hyperlink: null is default: no link
    p_align => plpdf3.c_right                       -- Text alignment

    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setAlign' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );


  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setAlign');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.setAlign;
    commit;
  end;
  */
end setAlign;
--
--Set vertical align
procedure setVerticalAlign
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setMargin(0.5);
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print cell
  plpdf_cell.printCell(
    p_width => 100,
    p_height => 20,
    p_text => 'Vertical alignment center', -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    p_vert_align => plpdf3.c_center
    --p_ln: null is default: beside
  );
  --Set cursor position
  plpdf_cell.NewLine;
  --Print cell
  plpdf_cell.printCell(
    p_width => 100,                                 -- Cell width
    p_height => 20,                                 -- Cell height
    p_text => 'Vertical alignment top', -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    p_vert_align => plpdf3.c_top                    -- Vertical alignment
    --p_ln: null is default: beside
  );
  --Set cursor position
  plpdf_cell.NewLine;
  --Print cell
  plpdf_cell.printCell(
    p_width => 100,                                 -- Cell width
    p_height => 20,                                 -- Cell height
    p_text => 'Vertical alignment bottom', -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    p_vert_align => plpdf3.c_bottom                 -- Vertical alignment
    --p_ln: null is default: beside
  );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setVerticalAlign' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );

  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setVerticalAlign');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.setVerticalAlign;
    commit;
  end;
  */

end setVerticalAlign;
--Set cursor position
procedure setCursorPosition
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 10                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setMargin(0.5);
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print cell
  plpdf_cell.printCell(
    p_width => 70,                 -- Cell width
    p_height => 20,                -- Cell height
    p_text => 'First cell', -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    p_ln => plpdf_const.beside     -- Cursor position after the cell is printed
    );
  --Print cell
  plpdf_cell.printCell(
    p_width => 70,                                    -- Cell width
    p_height => 20,                                   -- Cell height
    p_text => 'Second cell in same row as first'      -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Set cursor position
  plpdf_cell.NewLine;
  --Set cursor position
  plpdf.setCurrentX(50);
  --Print cell
  plpdf_cell.printMultilineCell(
    p_width => 80,                                                               -- Cell width
    p_height => 20,                                                              -- Cell height
    p_text => 'Third cell in new row with identation from the left page margin', -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    p_ln => plpdf_const.newline
  );
  --Print cell
  plpdf_cell.printCell(
    p_width => 80,                                   -- Cell width
    p_height => 20,                                  -- Cell height
    p_text => 'Fourth cell in new line'              -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Add new line
  plpdf_cell.NewLine;              --Line height
  --Set cursor position
  plpdf.setCurrentX(50);
  --Print cell
  plpdf_cell.printMultilineCell(
    p_width => 80,                 -- Cell width
    p_height => 20,                -- Cell height
    p_text => 'Fifth cell in new line with identation from the left page margin', -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    p_ln => plpdf_const.under
  );
  --Print cell
  plpdf_cell.printCell(
    p_width => 80,                 -- Cell width
    p_height => 20,                -- Cell height
    p_text => 'Sixth cell under fifth cell'  -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
  );
  --Add new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setCursorPosition' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setCursorPosition');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.setCursorPosition;
    commit;
  end;
  */

end setCursorPosition;
--
--Set multiline cell
procedure MultilineCell
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set border width
  plpdf_cell.setBorderWidth(0.5);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  -- Printing multiline cell
  plpdf_cell.printMultilineCell(
   p_width => 100,                                      --Cell width
   --p_height
   p_text => l_sample_text || l_sample_text             -- Cell text
   --p_hyperlink
   --p_align
   --p_vert_align
   --p_ln
   );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - MultilineCell' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'MultilineCell');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.MultilineCell;
    commit;
  end;
  */
end MultilineCell;
--

--Image cell
procedure ImageCell
  is
  l_blob blob;
  l_image blob;
begin
  --Get image blob from IMAGE_BLOB table
  select image_file
      into l_image
     from IMAGE_BLOB
     where id = 1
     for update;
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Set the border width
  plpdf_cell.setBorderWidth(0.5);
  --Set the border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print image cell
  plpdf_cell.printImageCell(
    p_width => 70,           -- Rectangle width
    p_height => 30,          -- Rectangle height
    p_name => '1.jpg',       -- Name of the image file
    p_data => l_image,       -- Image file in blob
    p_img_width => 35,       -- Image width
    p_img_height => 15       -- Image height
    --p_hyperlink
    --p_align
    --p_vert_align
    --p_ln
  );
  --Reset layout settings
  plpdf_cell.init;
  --Create new line
  plpdf_cell.NewLine;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - ImageCell' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'ImageCell');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.ImageCell;
    commit;
  end;
  */
end ImageCell;

--Code39BarcodeCell
procedure Code39BarcodeCell
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
  );
  --Draw page margins
  drawPageMargins;
  --Set the border width
  plpdf_cell.setBorderWidth(0.5);
  --Set the border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Print image cell
  plpdf_cell.printCode39BarcodeCell(
    p_width => 70,           -- Rectangle width
    p_height => 30,          -- Rectangle height
    p_data => '2387439823874398',
    --p_gap number default null,
    --p_font plpdf3.t_font default null,
    p_barc_width => 35, --null=width-box frame
    p_barc_height => 15 --null=height-box frame
    --p_link varchar2 default null,
    --p_align varchar2 default plpdf3.c_left, --p_alignment=p_align
    --p_vert_align varchar2 default plpdf3.c_center,
    --p_ln number default plpdf_const.beside
    );
  --Reset layout settings
  plpdf_cell.init;
  --Create new line
  plpdf_cell.NewLine;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - ImageCell' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'Code39BarcodeCell');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.Code39BarcodeCell;
    commit;
  end;
  */
end Code39BarcodeCell;


--Set current X coordinates
procedure setCurrentX
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Red);
  --Set cell horizontal position
  plpdf.setCurrentX(0);
  --Set border width
  plpdf_cell.setBorderWidth(0.3);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Dark_turquoise);
  --Set padding
  plpdf_cell.setPadding(0.5);
  -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at X position 0. '        -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
   --Create new line
  plpdf_cell.NewLine;
   --Set cell horizontal position
  plpdf.setCurrentX(40);
   -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at X position 40. '        -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
   --Create new line
  plpdf_cell.NewLine;
  --Set cell horizontal position
  plpdf.setCurrentX(80);
   -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at X position 80.'        -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text height
    p_text => 'PrintCell Example - setCurrentX' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setCurrentX');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.MultilineCell;
    commit;
  end;
  */
end setCurrentX;
--Set current Y coordinates
procedure setCurrentY
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set border width
  plpdf_cell.setBorderWidth(0.3);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Yellow_green);
  --Set padding
  plpdf_cell.setPadding(0.5);
  --Set vertical position
  plpdf.setCurrentY(0);
  -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at Y position 0.'           -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
  --Set vertical position
  plpdf.setCurrentY(50);
  -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at Y position 50.'           -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
  --Set vertical position
  plpdf.setCurrentY(100);
  -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at Y position 100. '           -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text height
    p_text => 'PrintCell Example - setCurrentY' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setCurrentY');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.MultilineCell;
    commit;
  end;
  */
end setCurrentY;
--Set current XY coordinates
procedure setCurrentXY
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set border width
  plpdf_cell.setBorderWidth(0.3);
  --Set border color
  plpdf_cell.setBorderColor(plpdf_const.Teal);
  --Set padding
  plpdf_cell.setPadding(0.5);
  --Set vertical position
  plpdf.setCurrentXY(0,0);
  -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at X position 0 and Y position 0.'           -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
  --Set vertical position
  plpdf.setCurrentXY(40,50);
  -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at X position 40 and Y position 50.'           -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
  --Set vertical position
  plpdf.setCurrentXY(80,100);
  -- Print cell
  plpdf_cell.printCell(
   --p_width: null is default: text width
   --p_height: null is default: text height
   p_text => 'This text starts at X position 80 and Y position 100.'           -- Cell text
   --p_hyperlink: null is default: no link
   --p_align: null is default: left
   --p_vert_align: null is default: center
   --p_ln: null is default: beside
   );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text height
    p_text => 'PrintCell Example - setCurrentXY' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setCurrentXY');
  --
  commit;
  /*--run
  begin
    delete from store_blob;
    CellExamples.MultilineCell;
    commit;
  end;
  */
end setCurrentXY;
--
--Set top,left,bottom and right margins
procedure setMargins
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setTopMargin(15);
  --Set padding
  plpdf_cell.setPadding(0.8);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Top margin cell. Sample text: ' || l_long_text                              -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Create new page
  plpdf.NewPage();
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setLeftMargin(15);
  --Set padding
  plpdf_cell.setPadding(0.8);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Left margin cell. Sample text: ' || l_long_text                             -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new page
  plpdf.NewPage();
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setRightMargin(15);
  --Set padding
  plpdf_cell.setPadding(0.8);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Right margin cell. Sample text: ' || l_long_text                                 -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new page
  plpdf.NewPage();
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set margin
  plpdf_cell.setBottomMargin(15);
  --Set padding
  plpdf_cell.setPadding(0.8);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Bottom margin cell. Sample text: ' || l_long_text                                -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setMargins' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setMargins');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.setMargin;
    commit;
  end;
  */
end setMargins;
--
--Set top,left,bottom and right paddings
procedure setPaddings
  is
  l_blob blob;
begin
  --Setting up inner variables
  plpdf.init();
  --Creating new page
  plpdf.NewPage();
  --Creating font for text
  plpdf.SetPrintFont(
    p_family => 'Arial',        --Font name
    p_style => null,            --Font style
    p_size => 12                --Font size
    );
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set top padding
  plpdf_cell.setTopPadding(15);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Top padding cell. Sample text: ' || l_long_text                              -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Create new page
  plpdf.NewPage();
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set left padding
  plpdf_cell.setLeftPadding(15);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Left padding cell. Sample text: ' || l_long_text                              -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new page
  plpdf.NewPage();
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set top padding
  plpdf_cell.setRightPadding(15);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Right padding cell. Sample text: ' || l_long_text                              -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new page
  plpdf.NewPage();
  --Draw page margins
  drawPageMargins;
  --Reset layout settings
  plpdf_cell.init;
  --Set top padding
  plpdf_cell.setBottomPadding(15);
  --Print default cell
  plpdf_cell.printMultilineCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'Bottom padding cell. Sample text: ' || l_long_text                              -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Create new line
  plpdf_cell.NewLine;
  --Reset layout settings
  plpdf_cell.init;
  --Print default cell
  plpdf_cell.printCell(
    --p_width: null is default: text width
    --p_height: null is default: text width
    p_text => 'PrintCell Example - setPaddings' -- Printed text
    --p_hyperlink: null is default: no link
    --p_align: null is default: left
    --p_vert_align: null is default: center
    --p_ln: null is default: beside
    );
  --Send the document to be generated
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
  );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setPaddings');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.setMargin;
    commit;
  end;
  */
end setPaddings;
--v3.6.0
procedure cellXhtml
  is
  l_blob blob;
begin
 plpdf.Init;
  plpdf.NewPage();
  plpdf.SetPrintFont(
    p_family => 'Arial',
    p_style  => null,
    p_size   => 12
    );
  -- p
  plpdf_cell.printCell(p_text => '---A general paragraph.');
  plpdf_cell.printCellXhtml(p_text => '<p>Test</p>');
  -- b
  plpdf_cell.printCell(p_text => '---Bold text.');
  plpdf_cell.printCellXhtml(p_text => '<b>Test</b>');
  -- i
  plpdf_cell.printCell(p_text => '---Italic text.');
  plpdf_cell.printCellXhtml(p_text => '<i>Test</i>');
  -- u
  plpdf_cell.printCell(p_text => '---Underlined text.');
  plpdf_cell.printCellXhtml(p_text => '<u>Test</u>');
  -- sup
  plpdf_cell.printCell(p_text => '---Superscript text.');
  plpdf_cell.printCellXhtml(p_text => '<sup>Test</sup>');
  -- sub
  plpdf_cell.printCell(p_text => '---Subscript text.');
  plpdf_cell.printCellXhtml(p_text => '<sub>Test</sub>');
  -- a
  plpdf_cell.printCell(p_text => '---Hyperlink.');
  plpdf_cell.printCellXhtml(p_text => '<a href="www.plpdf.com">Test</a>');
  -- font 
  plpdf_cell.printCell(p_text => '---Font properties changed (pt).');
  plpdf_cell.printCellXhtml(p_text => '<font face="courier" size="40pt" color="red">Test</font>');
  -- font 
  plpdf_cell.printCell(p_text => '---Font properties changed (HTML font size).');
  plpdf_cell.printCellXhtml(p_text => '<font face="courier" size="7" color="green">Test</font>');
  -- br
  plpdf_cell.printCell(p_text => '---Line break.');
  plpdf_cell.printCellXhtml(p_text => '<p>Test Test <br></br> Test</p>');
  -- mixed
  plpdf_cell.printCell(p_text => '---Mixed use of the tags.');
  plpdf_cell.printCellXhtml(p_text => '<p><font face="Times-Roman" color="blue">Test<br></br><b><a href="www.something.com">Te<i>st</i></a></b><u>Te<b>s</b>t</u><br></br>TesttEST<i>Te<u>s</u>t</i></font></p>');
  plpdf.SendDoc(
    p_blob => l_blob
    );
  --
  --Insert pdf into table
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'cellXhtml');
  --
  commit;
  --
  /*--run
  begin
    delete from store_blob;
    CellExamples.setMargin;
    commit;
  end;
  */
end cellXhtml;
--
end;
/
