create or replace package BasicExamples is
  --v4.7.0
  /* Release date : 2017-03-02- YYYY-MM-DD */

  -- Init examples
  procedure InitDefault;
  procedure InitOrient;
  procedure InitUnit;
  procedure InitPageFormat;
  procedure InitCustom;
  procedure InitSample;
  --
  procedure NewPage;
  procedure NewLine;
  --
  procedure SetPrintFont;
  --
  procedure SetEncoding;
  procedure SetEncoding2;
  --
  procedure SetProperties;
  --
  procedure DisplayModeZoom1;
  procedure DisplayModeZoom2;
  procedure DisplayModeZoom3;
  --
  procedure DisplayModeHide1;
  procedure DisplayModeHide2;
  procedure HeaderFooter;
  procedure HeaderFooter1;
  procedure header1;
  procedure footer1;
  --
  procedure header5(
    p_1 varchar2,
    p_2 varchar2 default null,
    p_3 varchar2 default null,
    p_4 varchar2 default null,
    p_5 varchar2 default null
    );
  procedure Header5Footer;
  --
  procedure SetAllMargin;
  procedure SetMarginsValue;
  --
  procedure GetTextWidth;
  procedure NonStrokingColor;
  procedure StrokingColor;
  procedure DrawLine;
  procedure DrawRect;
  procedure DrawCircle;
  procedure DrawEllipse;
  procedure DrawSector;
  procedure DashPattern;
  procedure DrawPolygon;
  procedure Pattern;
  procedure DrawRoundedRect;
  procedure InternalLink;
  procedure Image;
  procedure Rotate;
  procedure SetRotatePage;
  procedure CreateBookmark;
  procedure TTFembending;
  procedure TTFembendingSubset;
  procedure Clipping;
  procedure Protect;
  procedure JavaScript;
  procedure AttachFile;
  procedure PageNumber;
  procedure header2;
  procedure footer2;
  procedure TextAnnotation;
  procedure FileAnnotation;
  procedure MarkupAnnotation;
  procedure ScreenAnnotation;
  procedure ChineseFont;
  procedure WithoutTOC;
  procedure HeaderTOC1;
  procedure FooterTOC1;
  procedure MinimalTOC;
  procedure NormalTOC;
  procedure MovetoTOC;
  procedure CoverPageTOC;
  procedure FooterTOC2;
  procedure DifferentFooter;
  procedure FooterTOC3;
  procedure TestTOC1Custom;
  procedure CustomTOC;
  procedure ProfTOC;
  procedure InsMoveTOC;
  procedure PrintoutText;
  procedure SetAutoNewPage;
  procedure SetCompress;
  procedure SetNOLastpageProcName;
  procedure NotLastPage;
  procedure InsertMovePage;
  procedure Opacity;
  procedure OptCont;
  procedure TemplatePage;
  procedure template_init;
  procedure template_eg;
  procedure setPageDefaultTemplate;
  procedure Acroform_Choice;
  procedure Acroform_PushButton;
  procedure Acroform_RadioButtonField;
  procedure Acroform_SignatureField;
  procedure Acroform_TextField;
  procedure Acroform_CheckboxField;
--
end BasicExamples;
/
create or replace package body BasicExamples is

v_tpl   plpdf_type.tr_tpl_data;

/* INIT_EXAMPLE */
procedure InitDefault is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'InitDefault example'
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'Simple, innitialiezed document with some text.'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InitDefault');
  commit;
  /* call procedure
  begin
    delete from store_blob;
    -- Call the procedure
    basicexamples.initdefault;
    commit;
  end;
  */
end;

/* INITORIENT */
procedure InitOrient is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init(
    p_orientation => plpdf_const.landscape --'L'
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => plpdf_const.Arial, -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'InitOrient example'
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'Default page orientation changed to landscape.'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InitOrient');
  commit;
end;

/* INITUNIT */
procedure InitUnit is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init(
    p_unit => plpdf_const.cm -- 'cm'
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 2,
    p_y => 3,
    p_txt => 'InitUnit example'
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 2,
    p_y => 5,
    p_txt => 'Default measurement unit changed to centimeter.'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InitUnit');
  commit;

end;

/* INITPAGEFORMAT */
procedure InitPageFormat is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init(
    p_format => 'A5'
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'InitPageFormat example'
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'Page format changed to A5 size.'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InitPageFormat');
  commit;

end;

/* INITCUSTOM */
procedure InitCustom is
  l_blob blob;
  l_page_format plpdf_type.t_pageformat;
  l_w float := 500.38; --points
  l_h float := 200.22; --points
begin
  /*  set custom page size small as A5 * */
  l_page_format.w := l_w; /*  width */
  l_page_format.h := l_h; /* height */

  /* the init1 procedure can custom others custom page format setting */
  plpdf.init1(
    p_orientation =>plpdf_const.landscape,
    p_unit => plpdf_const.mm,
    p_format => l_page_format --points
  );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 10,
    p_y => 30,
    p_txt => 'InitCustom example'
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 10,
    p_y => 50,
    p_txt => 'Custom size (' || l_w || 'X' || l_h || ')'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InitCustom');
  commit;

end;


/* INITSAMPLE */
procedure InitSample is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init(
    p_format => 'A3',
    p_unit => plpdf_const.inch,
    p_orientation => plpdf_const.landscape
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  /* Print text  */
  plpdf.PrintoutText(
    p_x => 2,
    p_y => 3,
    p_txt => 'Mathematic'
    );

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Symbol', -- Font family: Symbol
    p_style  => null, -- Font style: Regular
    p_size   => 24 -- Font size: 24
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 2,
    p_y => 5,
    p_txt => 'a+b=g, p'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InitSample');
  commit;

end;


/* NEWPAGE */
procedure NewPage is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'NewPage - Start page orientation: Portrait(default)'
    );


  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage(
     p_orientation => plpdf_const.landscape
     );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'Second page with landscape orientation.'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'NewPage');
  commit;

end;

/* NewLine */
procedure NewLine is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  /* Print text */
  plpdf_cell.printCell(
    p_width => 150,
    --p_height => null automatic
    p_text => 'NewLine example',
    p_ln => plpdf_const.newline
    );

  /* Create a new line. Without parameters the default line height is 0. */
  plpdf.NewLine(
     p_h => 15           -- new line height
     );

  -- add text
  plpdf_cell.printCell(
    p_width => 150,
    --p_height => null automatic
    p_text => 'Second line is a line below from the first line with the line height of 15.',
    p_ln => plpdf_const.newline
    );

  /* Create a new line. Without parameters the default line height is 0. */
  plpdf.NewLine(
     p_h => 10           -- new line height
     );
  plpdf_cell.printCell(
    p_width => 150,
    --p_height => null automatic
    p_text => 'Third line is a line below from the first line with the line height of 10.',
    p_ln => plpdf_const.newline
    );
  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'NewLine');
  commit;

end;

/* SetPrintFont */
procedure SetPrintFont is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => plpdf_const.Arial, -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'SetPrintFont example'
    );

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => plpdf_const.Courier, -- Font family: Courier
    p_style  => 'B', -- Font style: Bold
    p_size   => 14 -- Font size: 14
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 80,
    p_txt => 'Courier text with bold style and 14 size.'
    );

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => plpdf_const.Arial, -- Font family: Arial
    p_style  => 'I', -- Font style: Italic
    p_size   => 18 -- Font size: 18
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 100,
    p_txt => 'Arial text with italic style and 18 size.'
    );


  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetPrintFont');
  commit;

end;

/* INIT_EXAMPLE */
procedure SetEncoding is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  plpdf.setEncoding(
    p_enc => 'cp1252'
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,             -- X coordinate
    p_y => 30,             -- Y coordinate
    p_txt => 'SetEncoding example' --
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'The character encoding: cp1252'
    );

  plpdf.PrintoutText(
    p_x => 20,
    p_y => 70,
    p_txt => UNISTR('\00FB\00ED\00E9\00E1\00f5\00FA\00F6\00FC\00F3!')
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetEncoding');
  commit;
  /* call procedure
  begin
    delete from store_blob;
    -- Call the procedure
    basicexamples.initdefault;
    commit;
  end;
  */
end;

/* INIT_EXAMPLE */
procedure SetEncoding2 is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  plpdf.setEncoding(
    p_enc => 'iso-8859-2'
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,             -- X coordinate
    p_y => 30,             -- Y coordinate
    p_txt => 'SetEncoding example' --
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'The character encoding: cp1252'
    );

  plpdf.PrintoutText(
    p_x => 20,
    p_y => 70,
    p_txt => UNISTR('\0171\00ED\00E9\00E1\0151\00FA\00F6\00FC\00F3!')
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetEncodig2');
  commit;

end;

/* INIT_EXAMPLE */
procedure SetProperties is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

   /* Sets the document subject */
  plpdf.SetDocSubject(
  p_subject => 'MySubject' -- Document subject
  );

  /* Sets the document author */
  plpdf.SetDocAuthor(
  p_author => 'Author name'   -- Document author
  );

  /* Sets the document keywords */
  plpdf.SetDocKeywords(
  p_keywords => 'key1, key2, key3' -- Keywords
  );

  /* Sets the document creator */
  plpdf.SetDocCreator(
  p_creator => 'Creator name'       -- Document creator
  );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                           -- X coordinate
    p_y => 30,                           -- Y coordinate
    p_txt => 'SetProperties example'     -- text
    );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'See the document properties window.'     -- text
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetProperties');
  commit;

end;

/* DISPLAY_MODE_ZOOM_EXAMPLE1 */
procedure DisplayModeZoom1 is

  l_blob blob;
begin

   /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;

  /* Sets how to display the document in a PDF viewer  */
  plpdf.SetDocDisplayMode(
  p_zoom => 'fullpage',      -- Layout view: fits as full page
  p_layout => 'continuous'   -- Page layout: displays pages continuously
  );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

 /* Sets the font properties */
  plpdf.SetPrintFont(
  p_family => 'Arial',        -- Font family: Arial
  p_style => null,            -- Font style: Regular
  p_size => 12                -- Font size: 12
  );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'DisplayModeZoom1 example'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page2'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page3'     -- text
    );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate, 'DisplayModeZoom1');
commit;
end;

/* DISPLAY_MODE_ZOOM_EXAMPLE2 */
procedure DisplayModeZoom2 is

  l_blob blob;
begin

   /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;

  /* Sets how to display the document in a PDF viewer  */
  plpdf.SetDocDisplayMode(
  p_zoom => 'fullwidth',      -- Layout view: fits as full page
  p_layout => 'default'   -- Page layout: displays pages continuously
  );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

 /* Sets the font properties */
  plpdf.SetPrintFont(
  p_family => 'Arial',        -- Font family: Arial
  p_style => null,            -- Font style: Regular
  p_size => 12                -- Font size: 12
  );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'DisplayModeZoom2 example'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page2'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page3'     -- text
    );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate, 'DisplayModeZoom2');
commit;
end;

/* DISPLAY_MODE_ZOOM_EXAMPLE3 */
procedure DisplayModeZoom3 is

  l_blob blob;
begin

   /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;

  /* Sets how to display the document in a PDF viewer  */
  plpdf.SetDocDisplayMode(
  p_zoom => 'real',      -- Layout view: fits as full page
  p_layout => 'single'   -- Page layout: displays pages continuously
  );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

 /* Sets the font properties */
  plpdf.SetPrintFont(
  p_family => 'Arial',        -- Font family: Arial
  p_style => null,            -- Font style: Regular
  p_size => 12                -- Font size: 12
  );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'DisplayModeZoom3 example'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page2'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page3'     -- text
    );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate, 'DisplayModeZoom3');
commit;
end;

procedure DisplayModeHide1 is

  l_blob blob;
begin
  /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;

  /* Sets how to display the document in a PDF viewer  */
  plpdf.SetDocDisplayMode(
  p_zoom => 'fullpage',      -- Layout view: fits as full page
  p_layout => 'continuous',   -- Page layout: displays pages continuously
  p_hidemenubar => true,     -- hide the viewer application's menu bar when the document active
  p_hidetoolbar => true,     -- hide the viewer application's tool bars when the document active
  p_hidewindowui => true     -- hide user interface elements (e.g. scrool bars, navigation controls)
  );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font properties */
  plpdf.SetPrintFont(
  p_family => 'Arial',        -- Font family: Arial
  p_style => null,            -- Font style: Regular
  p_size => 12                -- Font size: 12
  );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'DisplayModeHide1 example'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page2'     -- text
    );


  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page3'     -- text
    );


  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate, 'DisplayModeHide1');
commit;

end;

procedure DisplayModeHide2 is

  l_blob blob;
begin
  /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;

  /* Sets how to display the document in a PDF viewer  */
  plpdf.SetDocDisplayMode(
  p_zoom => 'fullpage',      -- Layout view: fits as full page
  p_layout => 'continuous',   -- Page layout: displays pages continuously
  p_displaydoctitle => true, -- The window's title bar should display the document title taken from the Title entry of the document information dictionary
  p_centerwindow => true,    -- Sets the document's window position int the center of the screen
  p_fitwindow => true        -- Resize the document's window to fit the size of the first displayed page
  );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font properties */
  plpdf.SetPrintFont(
  p_family => 'Arial',        -- Font family: Arial
  p_style => null,            -- Font style: Regular
  p_size => 12                -- Font size: 12
  );

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'DisplayModeHide2 example'     -- text
    );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page2'     -- text
    );


  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'Page3'     -- text
    );


  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate, 'DisplayModeHide2');
commit;

end;

/* HEADER_FOOTER EXAMPLE */
procedure HeaderFooter is

l_blob blob;

begin
  /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;


    /*Sets the page header procedure name. The program name passed
      as a parameter executes when the page header is created. */
   plpdf.SetHeaderProcName(
     p_proc_name => 'basicexamples.header1',    -- Page header procedure name: xheader
     p_height => 10               -- Height of header section
     );

     /* Sets the page footer procedure name. The program name passed
       as a parameter executes when the page footer is created. */
   plpdf.SetFooterProcName(
     p_proc_name => 'basicexamples.footer1',    --Page footer procedure name: xfooter
     p_height => 10               --Height of footer section
     );

     /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Sets the font properties */
     plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => null,            -- Font style: Regular
     p_size => 12                -- Font size: 12
     );

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Header/Footer example'     -- text
      );


     /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Page2'     -- text
      );

      /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Page3'     -- text
      );

     /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate,'HeaderFooter');
  commit;
end;

procedure HeaderFooter1 is

l_blob blob;

begin
   /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;


    /*Sets the page header procedure name. The program name passed
      as a parameter executes when the page header is created. */
   plpdf.SetHeaderProcName(
     p_proc_name => 'basicexamples.header1',    -- Page header procedure name: xheader
     p_height => 10               -- Height of header section
     );

     /* Sets the page footer procedure name. The program name passed
       as a parameter executes when the page footer is created. */
   plpdf.SetFooterProcName(
     p_proc_name => 'basicexamples.footer1',    --Page footer procedure name: xfooter
     p_height => 10               --Height of footer section
     );
     /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Sets the font properties */
     plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => null,            -- Font style: Regular
     p_size => 12                -- Font size: 12
     );

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Header/Footer example'     -- text
      );

     /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Page2'     -- text
      );

      /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Page3'     -- text
      );


      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate,'HeaderFooter1');
  commit;
end;

procedure header1 is
begin

  /* Sets the font properties */
  plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     );

    /* Page title */

    /* Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified. */
    plpdf_cell.printCell(
     p_width => plpdf.getPageAvailableWidth,                          -- Rectangle width
     p_height =>  null,                         -- Rectangle heigth
     p_text => 'Page Header',             -- Text in rectangle
     p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside
     p_align => plpdf3.c_center                     -- Text alignment: Center
     );

    /* Line break. */
    plpdf.NewLine(
     p_h => plpdf_cell.getLastCellHeight      --Height of the line break.
     );
end;

procedure footer1 is
begin

  /* Sets the font properties */
  plpdf.SetPrintFont(
     p_family => 'Arial',             -- Font family: Arial
     p_style => 'I',                  -- Font style: Italic
     p_size => 8                      -- Font size: 8 pt
     );

  /* Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified. */
    plpdf_cell.printCell(
     p_width => plpdf.getPageAvailableWidth,                          -- Rectangle width
     p_height =>  null,                         -- Rectangle heigth
     p_text => to_char(plpdf.getCurrPageNum) || '/'||to_char(plpdf.getNumOfPages()), -- Text in rectangle,             -- Text in rectangle
     p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside
     p_align => plpdf3.c_center                    -- Text alignment: Center
     );

end;

--20150916
procedure header5(
  p_1 varchar2,
  p_2 varchar2 default null,
  p_3 varchar2 default null,
  p_4 varchar2 default null,
  p_5 varchar2 default null
  ) is
begin

  /* Sets the font properties */
  plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     );

    /* Page title */

    /* Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified. */
    plpdf_cell.printCell(
     p_width => plpdf.getPageAvailableWidth,                          -- Rectangle width
     p_height =>  null,                         -- Rectangle heigth
     p_text => p_1,             -- Text in rectangle
     p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside
     p_align => plpdf3.c_center                     -- Text alignment: Center
     );

    /* Line break. */
    plpdf.NewLine(
     p_h => plpdf_cell.getLastCellHeight      --Height of the line break.
     );
end;

--20150916
procedure Header5Footer is

l_blob blob;

begin
  /* Initializes generator program variables.
       Default parameter values:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
  plpdf.Init;


    /*Sets the page header procedure name. The program name passed
      as a parameter executes when the page header is created. */
   plpdf.SetHeaderProcName5(
     p_proc_name => 'basicexamples.header5',    -- Page header procedure name: header
     p_height => 10,               -- Height of header section
     p_1 => 'Title'
     );

     /* Sets the page footer procedure name. The program name passed
       as a parameter executes when the page footer is created. */
   plpdf.SetFooterProcName(
     p_proc_name => 'basicexamples.footer1',    --Page footer procedure name: xfooter
     p_height => 10               --Height of footer section
     );

     /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Sets the font properties */
     plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => null,            -- Font style: Regular
     p_size => 12                -- Font size: 12
     );

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Header/Footer example'     -- text
      );


     /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Page2'     -- text
      );

      /* Create a new page. Without parameters the default page orientation: portrait. */
     plpdf.NewPage;

     /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Page3'     -- text
      );

     /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate,'Header5Footer');
  commit;
end;

procedure SetAllMargin is
  l_blob blob;
  begin
   /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
   plpdf.init;

    /* Sets the margin size. */
    plpdf.SetAllMargin(
     p_left => 30, -- Left margin: 30mm
     p_top => 40,  -- Top margin: 40mm
     p_right => 50 -- Right margin: 50mm
     );

    /* Create a new page. Without parameters the default page orientation: portrait. */
    plpdf.NewPage;

    /* Sets the font properties */
    plpdf.SetPrintFont(
     p_family => 'Arial', -- Font family: Arial
     p_style => null,     -- Font style: regular (default)
     p_size => 12         -- Font size: 12 pt
     );

    /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'Page title'     -- text
      );

    /* Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified. */
    plpdf_cell.PrintCell(
     p_width => 50,              -- Rectangle width
     p_height => 10,              -- Rectangle heigth
     p_text => 'Set margins example cell 1', -- Text in rectangle
     p_ln => 1    -- Cursor position after the cell: New Line (Beside the cell - 0, Under the cell - 2
     );

    /* Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified. */
    plpdf_cell.PrintCell(
    p_width => 10,            -- Rectangle width
    p_height => 10,           -- Rectangle height
    p_text => 'Set margins example cell 2'      -- Text in rectangle
    );

    /* Sets the margin size. */
    plpdf.SetAllMargin(
    p_left => 10, -- Left margin: 10mm
    p_top => 10,  -- Top margin: 10mm
    p_right => 10 -- Right margin: 10mm
    );

    /* Create a new page. Without parameters the default page orientation: portrait. */
    plpdf.NewPage;

    /* Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified. */
    plpdf_cell.printCell(
    p_width => 10,            -- Rectangle width
    p_height => 10,           -- Rectangle height
    p_text => 'New page with new margins'        -- Text in rectangle
    );

    /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Print it:

    owa_util.mime_header('application/pdf',false);
          htp.init;
          htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
          owa_util.http_header_close;
          wpg_docload.download_file(l_blob);   */

    /* Store */
     insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate,'SetMargin');
     commit;

end;

procedure SetMarginsValue is
  l_blob blob;

  begin
     /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;

    /* Sets the top margin size. */
    plpdf.SetTopMargin(
    p_margin => 20  -- Margin size
    );

    /* Sets the left margin size. */
    plpdf.SetLeftMargin(
    p_margin => 30 -- Margin size
    );

    /* Sets the right margin size */
    plpdf.SetRightMargin(
    p_margin => 40 -- Margin size
    );

    /* Begin a new page, without parameters means:
     - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                    -- Font style: Regular
     p_size => 12                         -- Font size: 12
     );

    /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 50,                                         -- Y coordinate
      p_txt => 'SetMarginsValue example'     -- text
      );


    /* Print text */
    plpdf.PrintoutText(
      p_x => 20,                                         -- X coordinate
      p_y => 70,                                         -- Y coordinate
      p_txt => 'Top margin: 20, Left margin: 30, Right margin:40'     -- text
      );

    /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );


    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate, 'SetMarginsValue');
    commit;
  end;
--
procedure GetTextWidth is
  l_blob blob;
  l_length number;
  l_text varchar2(255);
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
   plpdf.Init;

   /* Create a new page. Without parameters the default page orientation: portrait. */
   plpdf.NewPage;

   /* Sets the font properties */
   plpdf.SetPrintFont(
     p_family => 'Arial', -- Font family: Arial
     p_style => null,     -- Font style: regular (default)
     p_size => 12         -- Font size: 12 pt
     );

   l_text := 'This is the text.';
   /* function plpdf.GetTextWidth:
      Returns the width of the parameter text.
      The width of the text in the unit of measure specified in plpdf.Init */
   l_length:= plpdf.GetTextWidth(
     p_s => l_text      -- Parameter text
     );

    /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => l_text || ' - text length: ' || to_char(l_length)     -- text
    );

   l_text := 'This is the longer text.';
   l_length := plpdf.GetTextWidth(
     p_s => l_text -- Parameter text
     );

     /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 70,                                         -- Y coordinate
    p_txt => l_text || ' - text length: ' || to_char(l_length)     -- text
    );

   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Store */
   insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'GetTextWidth');
   commit;
end;

/* INIT_EXAMPLE */
procedure NonStrokingColor is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'NonStroking color example'
    );

  plpdf.nonstrokingcolor(
    p_r => 255,
    p_g => 50,
    p_b => 50
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'The color of the text is different.'
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'NonStrokingColor');
  commit;
end;
--StrokingColor
procedure StrokingColor is
  l_blob blob;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'Stroking color example'
    );

  -- add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 50,
    p_txt => 'Set the drawing color.'
    );

    /* Draws a rectangle on the page. */
    plpdf.Rect(
    p_x => 20,           -- X coordinate for the top left corner of the rectangle
    p_y => 60,           -- Y coordinate for the top left corner of the rectangle
    p_w => 100,          -- Rectangle width
    p_h => 10,           -- Rectangle height
    p_linewidth => 3
    );

    /* Sets the fill color for objects inserted after this statement. */
    plpdf.strokingcolor(
    p_r => 50,      -- Red component code, can be between 0 and 255
    p_g => 255,     -- Green component code, can be between 0 and 255
    p_b => 50      -- Blue component code, can be between 0 and 255
    );

    /* Draws a rectangle on the page. */
    plpdf.Rect(
    p_x => 20,           -- X coordinate for the top left corner of the rectangle
    p_y => 90,           -- Y coordinate for the top left corner of the rectangle
    p_w => 100,          -- Rectangle width
    p_h => 10,           -- Rectangle height
    p_linewidth => 3
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'StrokingColor');
  commit;
end;
--DrawLine
procedure DrawLine is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'Draw line example'
    );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
    p_x1 => 10,        -- X coordinate for the start of the line
    p_y1 => 50,        -- Y coordinate for the start of the line
    p_x2 => 10,        -- X coordinate for the end of the line
    p_y2 => 90         -- Y coordinate for the end of the line
    );

  /* Sets the line color for objects (line, rectangle, circle etc.)
     inserted after this statement. */
  plpdf.strokingcolor(
   p_r => 200,        -- Red component code, can be between 0 and 255
   p_g => 100,        -- Green component code, can be between 0 and 255
   p_b => 50          -- Blue component code, can be between 0 and 255
   );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 20,        -- X coordinate for the start of the line
   p_y1 => 50,        -- Y coordinate for the start of the line
   p_x2 => 20,        -- X coordinate for the end of the line
   p_y2 => 90         -- Y coordinate for the end of the line
   );


  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 30,        -- X coordinate for the start of the line
   p_y1 => 50,        -- Y coordinate for the start of the line
   p_x2 => 30,        -- X coordinate for the end of the line
   p_y2 => 90         -- Y coordinate for the end of the line
   );

   /* Sets the line color for objects (line, rectangle, circle etc.)
     inserted after this statement. */
  plpdf.strokingcolor(
   p_r => 100,        -- Red component code, can be between 0 and 255
   p_g => 255,        -- Green component code, can be between 0 and 255
   p_b => 100          -- Blue component code, can be between 0 and 255
   );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 40,        -- X coordinate for the start of the line
   p_y1 => 50,        -- Y coordinate for the start of the line
   p_x2 => 40,        -- X coordinate for the end of the line
   p_y2 => 90         -- Y coordinate for the end of the line
   );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 50,        -- X coordinate for the start of the line
   p_y1 => 50,        -- Y coordinate for the start of the line
   p_x2 => 50,        -- X coordinate for the end of the line
   p_y2 => 90         -- Y coordinate for the end of the line
   );

   /* Sets the line color for objects (line, rectangle, circle etc.)
     inserted after this statement. */
  plpdf.strokingcolor(
   p_r => 200,        -- Red component code, can be between 0 and 255
   p_g => 150,        -- Green component code, can be between 0 and 255
   p_b => 240          -- Blue component code, can be between 0 and 255
   );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
    p_x1 => 10,     -- X coordinate for the start of the line
    p_y1 => 100,     -- Y coordinate for the start of the line
    p_x2 => 60,     -- X coordinate for the end of the line
    p_y2 => 120      -- Y coordinate for the end of the line
    );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
    p_x1 => 10,     -- X coordinate for the start of the line
    p_y1 => 120,     -- Y coordinate for the start of the line
    p_x2 => 60,     -- X coordinate for the end of the line
    p_y2 => 100      -- Y coordinate for the end of the line
    );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DrawLine');
  commit;
end;
--DrawRect
procedure DrawRect is
  l_blob blob;
  l_fill_color plpdf_type.t_color;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'DrawRect example'
    );

  for i in 1..20 loop

  /* Sets the line color for objects (line, rectangle, circle etc.)
     inserted after this statement. */
  plpdf.strokingcolor(
   p_r => i*13-10,      -- Red component code, can be between 0 and 255
   p_g => 255-(i*12),   -- Green component code, can be between 0 and 255
   p_b => 0             -- Blue component code, can be between 0 and 255
   );

  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 40-i,         -- X coordinate for the top left corner of the rectangle
   p_y => 100-i,         -- Y coordinate for the top left corner of the rectangle
   p_w => 2*i,          -- The width of the rectangle
   p_h => 2*i          -- The height of the rectangle
   );

  end loop;

  /* Sets the line color for objects (line, rectangle, circle etc.)
     inserted after this statement.
   - p_g: -1 (default)
   - p_b: -1 (default) */
  plpdf.strokingcolor(0,0,0);

  /* Sets the fill color for objects inserted after this statement.
     Colors must be specified according to the RGB pallet.*/

  /* Draws a rectangle on the page */

  l_fill_color.r := 255;
  l_fill_color.g := 0;
  l_fill_color.b := 0;

  plpdf.Rect(
   p_x => 100,             -- X coordinate for the top left corner of the rectangle
   p_y => 60,             -- Y coordinate for the top left corner of the rectangle
   p_w => 50,             -- The width of the rectangle
   p_h => 50             -- The height of the rectangle
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Print it:
    owa_util.mime_header('application/pdf',false);
          htp.init;
          htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
          owa_util.http_header_close;
          wpg_docload.download_file(l_blob);   */

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DrawRect');
  commit;

end;
--DrawCircle
procedure DrawCircle is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'Draw circle example'
    );

  /* Draws an ellipse on the current page - style: draw (default) */
  plpdf.Circle(
  p_x => 60, -- X coordinate of the center of the circle
  p_y => 60, -- Y coordinate of the center of the circle
  p_r => 20 -- Horizontal radius of the circle
  );


  /* Draws an ellipse on the current page - style: draw (default) */
  plpdf.Circle(
  p_x => 60,  -- X coordinate of the center of the ellipse
  p_y => 200,  -- Y coordinate of the center of the ellipse
  p_r => 30 -- Horizontal radius of the ellipse
  );

  /* Draws a circle on the current page */
  plpdf.Circle(
  p_x => 100, -- X coordinate of the center of the circle
  p_y => 100, -- Y coordinate of the center of the circle
  p_r => 10  -- The radius of the circle
  );

  /* Draws a circle on the current page */
  plpdf.Circle(
  p_x => 120,     -- X coordinate of the center of the circle
  p_y => 100,     -- Y coordinate of the center of the circle
  p_r => 10      -- The radius of the circle
  );

  /* Draws a circle on the current page */
  plpdf.Circle(
  p_x => 110,     -- X coordinate of the center of the circle
  p_y => 120,     -- Y coordinate of the center of the circle
  p_r => 10      -- The radius of the circle
  );

  /* Returns the generated PDF document.
 The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DrawCircle');
  commit;
end;
--DrawEllipse
procedure DrawEllipse is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'Draw ellipse example'
    );

  /* Draws an ellipse on the current page - style: draw (default) */
  plpdf.Ellipse(
    p_x => 60, -- X coordinate of the center of the circle
    p_y => 60, -- Y coordinate of the center of the circle
    p_rx => 20, -- Horizontal radius of the ellipse
    p_ry => 10 -- Vertical radius of the ellipse
    );


  /* Draws an ellipse on the current page - style: draw (default) */
  plpdf.Ellipse(
    p_x => 60,  -- X coordinate of the center of the ellipse
    p_y => 200,  -- Y coordinate of the center of the ellipse
    p_rx => 30, -- Horizontal radius of the ellipse
    p_ry => 10  -- Vertical radius of the ellipse
    );

  /* Draws a circle on the current page */
  plpdf.Ellipse(
    p_x => 100, -- X coordinate of the center of the circle
    p_y => 100, -- Y coordinate of the center of the circle
    p_rx => 5, -- Horizontal radius of the ellipse
    p_ry => 30  -- Vertical radius of the ellipse
    );

  /* Draws a circle on the current page */
  plpdf.Ellipse(
    p_x => 120,     -- X coordinate of the center of the circle
    p_y => 100,     -- Y coordinate of the center of the circle
    p_rx => 30, -- Horizontal radius of the ellipse
    p_ry => 5  -- Vertical radius of the ellipse
    );

  /* Draws a circle on the current page */
  plpdf.Ellipse(
    p_x => 110,     -- X coordinate of the center of the circle
    p_y => 120,     -- Y coordinate of the center of the circle
    p_rx => 35, -- Horizontal radius of the ellipse
    p_ry => 15  -- Vertical radius of the ellipse
    );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DrawEllipse');
  commit;
end;
--DrawSector
procedure DrawSector is
  l_blob blob;
  l_xc number;
  l_yc number;
  l_r number;
begin
  /* Initializes generator program variables.
    Default parameter values:
  - page orientation: portrait
  - unit: mm
  - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage();

  /* Sets the font properties */
  plpdf.SetPrintFont(
    p_family => 'Arial', -- Font family: Arial
    p_style  => null, -- Font style: Regular
    p_size   => 12 -- Font size: 12
    );

  --add text
  plpdf.PrintoutText(
    p_x => 20,
    p_y => 30,
    p_txt => 'Drawsector example'
    );

    l_xc := 105;    -- Abscissa of the center
    l_yc := 105;     -- Ordinate of the center
    l_r := 50;      -- Radius

    /* Draws a sector on the current page. */
    plpdf.Sector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 20,     -- Starting point of the sector
     p_b => 100     -- End point of the sector
     );

    /* Draws a sector on the current page. */
    plpdf.Sector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 100,    -- Starting point of the sector
     p_b => 200,     -- End point of the sector
     p_fill => true,
     p_fill_color => plpdf_const.Blue
     );

    /* Draws a sector on the current page. */
    plpdf.Sector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 200,    -- Starting point of the sector
     p_b => 255,      --End point of the sector
     p_fill => true,
     p_fill_color => plpdf_const.Green
     );

   /* Draws a sector on the current page. */
   plpdf.Sector(
     p_xc => l_xc,    -- X coordinate of the center of the sector
     p_yc => l_yc,    -- Y coordinate of the center of the sector
     p_r => l_r,      -- Radius of the sector
     p_a => 255,      -- Starting point of the sector
     p_b => 299,        --End point of the sector
     p_fill => true,
     p_fill_color => plpdf_const.Red
     );

   /* Draws a sector on the current page. */
   plpdf.Sector(
     p_xc => l_xc,    -- X coordinate of the center of the sector
     p_yc => l_yc,    -- Y coordinate of the center of the sector
     p_r => l_r,      -- Radius of the sector
     p_a => 299,      -- Starting point of the sector
     p_b => 20,        --End point of the sector
     p_fill => true,
     p_fill_color => plpdf_const.Navy
     );

    l_xc := 120;    -- Abscissa of the center
    l_yc := 200;     -- Ordinate of the center
    l_r := 30;      -- Radius


   /* Draws a sector on the current page. */
   plpdf.Sector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 20,     -- Starting point of the sector
     p_b => 100,     -- End point of the sector
     p_draw => false,
     p_fill => true,
     p_fill_color => plpdf_const.Navy
     );


   /* Draws a sector on the current page. */
   plpdf.Sector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 100,    -- Starting point of the sector
     p_b => 200,     -- End point of the sector
     p_draw => false,
     p_fill => true,
     p_fill_color => plpdf_const.Brown
     );


   /* Draws a sector on the current page. */
   plpdf.Sector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => 40,    -- Radius of the sector
     p_a => 200,    -- Starting point of the sector
     p_b => 255,      --End point of the sector
     p_draw => false,
     p_fill => true,
     p_fill_color => plpdf_const.Purple,
     p_cw => false,    -- Draw direction: Anti-clockwise
     p_o => 30        -- origin of angles
     );


     /* Draws a sector on the current page. */
    plpdf.Sector(
     p_xc => l_xc,  -- X coordinate of the center of the sector
     p_yc => l_yc,  -- Y coordinate of the center of the sector
     p_r => l_r,    -- Radius of the sector
     p_a => 255,    -- Starting point of the sector
     p_b => 20,      --End point of the sector
     p_draw => false,
     p_fill => true,
     p_fill_color => plpdf_const.Pale_green
     );

  /* Returns the generated PDF document.
  The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
    p_blob => l_blob -- The generated document
    );

  /* store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DrawSector');
  commit;
  /* call procedure
  begin
    delete from store_blob;
    -- Call the procedure
    basicexamples.initdefault;
    commit;
  end;
  */
end;
--DashPattern
procedure DashPattern is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 20,        -- X coordinate for the start of the line
   p_y1 => 20,        -- Y coordinate for the start of the line
   p_x2 => 100,       -- X coordinate for the end of the line
   p_y2 => 20         -- Y coordinate for the end of the line
   );

  /* Sets the dash pattern for lines inserted after thisstatement. */
  plpdf_pattern.SetDashPattern(
   p_line => 5,       -- Length of dashes
   p_noline => 2      -- length of gaps
   );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 20,        -- X coordinate for the start of the line
   p_y1 => 40,        -- Y coordinate for the start of the line
   p_x2 => 100,       -- X coordinate for the end of the line
   p_y2 => 40,         -- Y coordinate for the end of the line
   p_width => 1       -- Line thickness: 1mm
   );


  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 20,        -- X coordinate for the start of the line
   p_y1 => 60,        -- Y coordinate for the start of the line
   p_x2 => 100,       -- X coordinate for the end of the line
   p_y2 => 60         -- Y coordinate for the end of the line
   );

  /* Sets the dash pattern for lines inserted after thisstatement.
     Call the procedure without parameter to restore normal drawing. */
  plpdf_pattern.SetDashPattern();

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
   p_x1 => 20,        -- X coordinate for the start of the line
   p_y1 => 80,        -- Y coordinate for the start of the line
   p_x2 => 100,       -- X coordinate for the end of the line
   p_y2 => 80         -- Y coordinate for the end of the line
   );

  /* Sets the dash pattern for lines inserted after thisstatement.
     Call the procedure without parameter to restore normal drawing. */
  plpdf_pattern.SetDashPattern(
  p_line => 4,          -- Length of dashes
  p_noline => 2         -- length of gaps
  );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
  p_x1 => 20,     -- X coordinate for the start of the line
  p_y1 => 100,    -- Y coordinate for the start of the line
  p_x2 => 200,    -- X coordinate for the end of the line
  p_y2 => 100     -- Y coordinate for the end of the line
  );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
  p_x1 => 200,    -- X coordinate for the start of the line
  p_y1 => 100,    -- Y coordinate for the start of the line
  p_x2 => 200,    -- X coordinate for the end of the line
  p_y2 => 150     -- Y coordinate for the end of the line
  );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
  p_x1 => 200,    -- X coordinate for the start of the line
  p_y1 => 150,    -- Y coordinate for the start of the line
  p_x2 => 20,     -- X coordinate for the end of the line
  p_y2 => 150     -- Y coordinate for the end of the line
  );

  /* Draws a line between the two positions on the page. */
  plpdf.Line(
  p_x1 => 20,     -- X coordinate for the start of the line
  p_y1 => 150,    -- Y coordinate for the start of the line
  p_x2 => 20,     -- X coordinate for the end of the line
  p_y2 => 100     -- Y coordinate for the end of the line
  );

   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Print it:

    owa_util.mime_header('application/pdf',false);
          htp.init;
          htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
          owa_util.http_header_close;
          wpg_docload.download_file(l_blob);   */

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DashPattern');
  commit;
end;
--DrawPolygon
procedure DrawPolygon is
  l_blob blob;
  l_points plpdf_type.t_points;
begin

  for l_i in 1..10 loop
    /* Generates random coordinates */
    l_points(l_i).x := dbms_random.value(15,120);
    l_points(l_i).y := dbms_random.value(15,120);
  end loop;

  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

   /* Sets the fill color for objects inserted after this statement.
     Colors must be specified according to the RGB pallet.*/
  plpdf.strokingcolor(
  p_r => 160,    -- Red component code, can be between 0 and 255
  p_g => 180,    -- Green component code, can be between 0 and 255
  p_b => 200     -- BLue component code, can be between 0 and 255
  );


  /* Draws a lines (polygon) between the points on the page. */
  plpdf.Polygon(
   p_points => l_points, -- set of ordered points
   p_fill => true
   );

   /* Cursor is placed at the start of the next line. */
   plpdf.NewLine(
     p_h => 1         -- Height of the line break.
    );

   for l_i in 1..10 loop
    /* Generates random coordinates */
    l_points(l_i).x := dbms_random.value(120,200);
    l_points(l_i).y := dbms_random.value(15,120);
  end loop;

   plpdf.Polygon(
   p_points => l_points -- set of ordered points
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob     -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DrawPolygon');
  commit;
end;
--Pattern
procedure Pattern is
  l_blob blob;
  l_points plpdf_type.t_points;
begin

  for l_i in 1..6 loop
    /* Generates random coordinates */
    l_points(l_i).x := dbms_random.value(1,7);
    l_points(l_i).y := dbms_random.value(1,7);
  end loop;
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create pattern: line */

  /* Starts of define a ?Tilling Pattern?.
     Tiling patterns consist of a small graphical figure
     (called a pattern cell) that is replicated at fixed
     horizontal and vertical intervals to fill the area to
     be painted.*/
  plpdf_pattern.startTillingPattern(
   p_name => 'line',          -- Name of pattern
   p_width => 5,              -- Width of pattern
   p_height => 5              -- Height of pattern
   );

  /* Add a line to the pattern. */
  plpdf.line(
   p_x1 => 0,                 -- X coordinate for the start of the line
   p_y1 => 0,                 -- Y coordinate for the start of the line
   p_x2 => 5,                 -- X coordinate for the end of the line
   p_y2 => 5                  -- Y coordinate for the end of the line
   );

  plpdf_pattern.endTillingPattern;

  /* Create pattern: chequer */

  /* Starts of define a ?Tilling Pattern?. */
  plpdf_pattern.startTillingPattern(
   p_name => 'chequer',       -- Name of pattern
   p_width => 4,              -- Width of pattern
   p_height => 4              -- Height of pattern
   );

  /* Add a rectangle to the pattern. */
  plpdf.rect(
   p_x => 0,                  -- X coordinate for the top left corner of the rectangle
   p_y => 0,                  -- Y coordinate for the top left corner of the rectangle
   p_w => 2,                  -- The width of the rectangle
   p_h => 2,                  -- The height of the rectangle
   p_fill => true,             -- Style: Fill,
   p_draw => false
   );

  /* Add a rectangle to the pattern. */
  plpdf.rect(
   p_x => 2,                  -- X coordinate for the top left corner of the rectangle
   p_y => 2,                  -- Y coordinate for the top left corner of the rectangle
   p_w => 2,                  -- The width of the rectangle
   p_h => 2,                  -- The height of the rectangle
   p_fill => true,             -- Style: Fill,
   p_draw => false
   );

  plpdf_pattern.endTillingPattern;

  /* Create pattern: halfchequer */

  /* Starts of define a ?Tilling Pattern?. */
  plpdf_pattern.startTillingPattern(
   p_name => 'halfchequer',   -- Name of pattern
   p_width => 4,              -- Width of pattern
   p_height => 4              -- Height of pattern
   );

   /* Add a rectangle to the pattern. */
  plpdf.rect(
   p_x => 0,                  -- X coordinate for the top left corner of the rectangle
   p_y => 0,                  -- Y coordinate for the top left corner of the rectangle
   p_w => 2,                  -- The width of the rectangle
   p_h => 2,                  -- The height of the rectangle
   p_fill => true,             -- Style: Fill,
   p_draw => false
   );

  /* Add a rectangle to the pattern. */
 plpdf.rect(
   p_x => 2,                  -- X coordinate for the top left corner of the rectangle
   p_y => 2,                  -- Y coordinate for the top left corner of the rectangle
   p_w => 2,                  -- The width of the rectangle
   p_h => 2,                  -- The height of the rectangle
   p_fill => false,             -- Style: draw,
   p_draw => true
   );

   plpdf_pattern.endTillingPattern;

  /* Create pattern: circle */

  /* Starts of define a ?Tilling Pattern?. */
  plpdf_pattern.startTillingPattern(
   p_name => 'circle',        -- Name of pattern
   p_width => 5,              -- Width of pattern
   p_height => 5              -- Height of pattern
   );

  /* Add a circle to the pattern. */
  plpdf.circle(
   p_x => 5/2,                -- X coordinate of the center of the circle
   p_y => 5/2,                -- Y coordinate of the center of the circle
   p_r => 2,                  -- The radius of the circle
   p_fill => false,             -- Style: draw,
   p_draw => true
   );

  /* Add a circle to the pattern. */
  plpdf.circle(
   p_x => 0,                  -- X coordinate of the center of the circle
   p_y => 5/2,                -- Y coordinate of the center of the circle
   p_r => 2,                  -- The radius of the circle
   p_fill => false,             -- Style: draw,
   p_draw => true
   );

  /* Add a circle to the pattern. */
 plpdf.circle(
   p_x => 5,                  -- X coordinate of the center of the circle
   p_y => 5/2,                -- Y coordinate of the center of the circle
   p_r => 2,                  -- The radius of the circle
   p_fill => false,             -- Style: draw,
   p_draw => true
   );

   plpdf_pattern.endTillingPattern;

   /* Create pattern: Ellipse */

  /* Starts of define a ?Tilling Pattern?. */
   plpdf_pattern.startTillingPattern(
   p_name => 'ellipse', -- Name of pattern
   p_width => 5,        -- Width of pattern
   p_height => 5        -- Height of pattern
   );

   /* Add a ellipse to the pattern. */
   plpdf.ellipse(
   p_x => 5,               -- X coordinate of the center of the circle
   p_y => 5/2,             -- Y coordinate of the center of the circle
   p_rx => 3,              -- Horizontal radius of the ellipse
   p_ry => 1,              -- Vertical radius of the ellipse
   p_fill => true,             -- Style: fill,
   p_draw => false
   );

   /* Add a ellipse to the pattern. */
   plpdf.ellipse(
   p_x => 0,               -- X coordinate of the center of the circle
   p_y => 5/2,             -- Y coordinate of the center of the circle
   p_rx => 3,              -- Horizontal radius of the ellipse
   p_ry => 1,              -- Vertical radius of the ellipse
   p_fill => true,             -- Style: fill,
   p_draw => false
   );

   plpdf_pattern.endTillingPattern;

   /* Create pattern: Polygon */

  /* Starts of define a ?Tilling Pattern?. */
   plpdf_pattern.startTillingPattern(
   p_name => 'polygon', -- Name of pattern
   p_width => 7,        -- Width of pattern
   p_height => 7        -- Height of pattern
   );

   /* Add a polygon to the pattern. */
   plpdf.Polygon(
   p_points => l_points,   -- Points
    p_fill => true,             -- Style: fill,draw
   p_draw => true
   );

  plpdf_pattern.endTillingPattern;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',       -- Font family: Arial
   p_style => null,           -- Font style: regular (default)
   p_size => 12               -- Font size: 12 pt
   );

  /* Draw pattern: line*/

  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 10,                 -- X coordinate for the top left corner of the rectangle
   p_y => 10,                 -- Y coordinate for the top left corner of the rectangle
   p_w => 40,                 -- The width of the rectangle
   p_h => 40,                 -- The height of the rectangle
   p_fill => true,
   p_fill_pattern => 'line',            -- fill
   p_fill_color => plpdf_const.Salmon,
   p_draw => true             -- border
   );


  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 10,                 -- X coordinate for the top left corner of the rectangle
   p_y => 55,                 -- Y coordinate for the top left corner of the rectangle
   p_w => 40,                 -- The width of the rectangle
   p_h => 40,                 -- The height of the rectangle
   p_fill => true,
   p_fill_pattern => 'chequer',            -- fill
   p_fill_color => plpdf_const.Black,
   p_draw => true             -- border
   );

  /* Draw pattern: halfchequer */

  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 10,                 -- X coordinate for the top left corner of the rectangle
   p_y => 100,                -- Y coordinate for the top left corner of the rectangle
   p_w => 40,                 -- The width of the rectangle
   p_h => 40,                 -- The height of the rectangle
   p_fill => true,
   p_fill_pattern => 'halfchequer',            -- fill
   p_fill_color => plpdf_const.Royal_blue,
   p_draw => true             -- border
   );

   /* Draw pattern: circle */

  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 10,                 -- X coordinate for the top left corner of the rectangle
   p_y => 145,                -- Y coordinate for the top left corner of the rectangle
   p_w => 40,                 -- The width of the rectangle
   p_h => 40,                 -- The height of the rectangle
   p_fill => true,
   p_fill_pattern => 'circle',            -- fill
   p_fill_color => plpdf_const.Yellow_green,
   p_draw => true             -- border
   );

   /* Draw pattern: ellipse */

  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 10,                 -- X coordinate for the top left corner of the rectangle
   p_y => 190,                -- Y coordinate for the top left corner of the rectangle
   p_w => 40,                 -- The width of the rectangle
   p_h => 40,                 -- The height of the rectangle
   p_fill => true,
   p_fill_pattern => 'ellipse',            -- fill
   p_fill_color => plpdf_const.Green,
   p_draw => true             -- border
   );

   /* Draw pattern: polygon */

  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 10,                 -- X coordinate for the top left corner of the rectangle
   p_y => 235,                -- Y coordinate for the top left corner of the rectangle
   p_w => 40,                  -- The width of the rectangle
   p_h => 40,                 -- The height of the rectangle
   p_fill => true,
   p_fill_pattern => 'polygon',            -- fill
   p_fill_color => plpdf_const.Orange,
   p_draw => true             -- border
   );

  /* Print text */
  plpdf.PrintoutText(
   p_x => 70,                 -- X coordinate
   p_y => 20,                 -- Y coordinate
   p_txt => 'Line pattern'    -- Text
   );

   /* Print text */
  plpdf.PrintoutText(
   p_x => 70,                 -- X coordinate
   p_y => 70,                 -- Y coordinate
   p_txt => 'Chequer pattern'    -- Text
   );


  /* Print text */
  plpdf.PrintoutText(
   p_x => 70,                 -- X coordinate
   p_y => 120,                 -- Y coordinate
   p_txt => 'Half-chequer pattern'    -- Text
   );

   /* Print text */
  plpdf.PrintoutText(
   p_x => 70,                 -- X coordinate
   p_y => 170,                 -- Y coordinate
   p_txt => 'Circle pattern'    -- Text
   );

   /* Print text */
  plpdf.PrintoutText(
   p_x => 70,                 -- X coordinate
   p_y => 210,                 -- Y coordinate
   p_txt => 'Ellipse pattern'    -- Text
   );

   /* Print text */
  plpdf.PrintoutText(
   p_x => 70,                 -- X coordinate
   p_y => 260,                 -- Y coordinate
   p_txt => 'Polygon pattern'    -- Text
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob     -- The generated document
  );

  /* Print it:


  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'Pattern');
  commit;
end;
--DrawRoundedRect
procedure DrawRoundedRect is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

    /* Sets the font properties */
  plpdf.SetPrintFont(
  p_family => 'Arial',        -- Font family: Arial
  p_style => null,            -- Font style: Regular
  p_size => 12                -- Font size: 12
  );

      /* Print text */
  plpdf.PrintoutText(
    p_x => 20,                                         -- X coordinate
    p_y => 50,                                         -- Y coordinate
    p_txt => 'DrawRoundedRect example'     -- text
    );

  /* Draws a rectangle on the page.*/
  plpdf.RoundedRect(
  p_x => 10,        -- X coordinate for the top left corner of the rectangle
  p_y => 100,        -- Y coordinate for the top left corner of the rectangle
  p_w => 100,       -- The width of the rectangle
  p_h => 40,        -- The height of the rectangle
  p_r => 4,         -- The radius of the corners
  p_draw => true
  );


  /* Draws a rectangle on the page.*/
  plpdf.RoundedRect(
  p_x => 10,        -- X coordinate for the top left corner of the rectangle
  p_y => 150,        -- Y coordinate for the top left corner of the rectangle
  p_w => 70,       -- The width of the rectangle
  p_h => 30,        -- The height of the rectangle
  p_r => 8,         -- The radius of the corners
  p_draw => true,
  p_fill => true,
  p_fill_color => plpdf_const.Blue
  );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob     -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DrawRoundedRect');
  commit;
end;
--InternalLink
procedure InternalLink is
  l_blob blob;
  l_link number;
begin
   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Creates an internal link, and returns its ID.
     An internal link can be used to take the cursor to another place
     within the document by clicking over it. */
  l_link := plpdf.CrInternalLink;

   /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',       -- Font family: Arial
   p_style => null,           -- Font style: regular (default)
   p_size => 12               -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified. */
  plpdf_cell.printCell(
  p_width => 50,           -- Rectangle width
  p_height => 10,           -- Rectangle height
  p_text => 'Target'    -- Text in rectangle
  );

  /* Sets the destination page and position for the internal link */
  plpdf.SetLinkDest(l_link);

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Puts a link area on the page that point to an internal link */
  plpdf.PutInternalLink(
   p_x => 100,               --X coordinate of the top left corner of the area
   p_y => 20,               -- Y coordinate of the top left corner of the area
   p_w => 60,               -- Link area width
   p_h => 15,               -- Link area height
   p_link => l_link         -- Internal link ID
   );

  /* Draws a rectangle on the page */
  plpdf.Rect(
   p_x => 100,              -- X coordinate for the top left corner of the rectangle
   p_y => 20,               -- Y coordinate for the top left corner of the rectangle
   p_w => 60,               -- The width of the rectangle
   p_h => 15,               -- The height of the rectangle
   p_draw => true
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob     -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InternalLink');
  commit;
end;
--Image
procedure Image is
  l_blob blob;
  l_image blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => null,        -- Font style: regular (default)
   p_size => 12            -- Font size: 12 pt
   );

  /* Print text */
  plpdf.PrintoutText(
  p_x => 20,      -- Rectangle width
  p_y => 50,       -- Rectangle height
  p_txt => 'Image example' -- Text in rectangle
  );

  /* Select image from a table.
     Needs table IMAGE_BLOB(id number, image_file blob).
     Image_file must contain image. */
  select image_file
    into l_image
   from IMAGE_BLOB
   where id = 1;


  /* Inserts an image (JPG, BMP, PNG, etc.) from a BLOB variable
     into the current page. */
  plpdf.PutImage(
   p_name => 'kep.jpg',  -- Image name or ID
   p_data => l_image,           -- Variable containing the image as binary data
   p_x => 10,                   -- X coordinate of the image
   p_y => 60,                   -- Y coordinate of the image
   p_w => 100,                   -- Image width
   p_h =>  30                   -- Image height
   );


  /* Inserts an image (JPG, BMP, PNG, etc.) from a BLOB variable
     into the current page. */
  plpdf.PutImage(
   p_name => 'kep.jpg',         -- Image name or ID
   p_data => l_image,           -- Variable containing the image as binary d
   p_x => 10,                   -- X coordinate of the image
   p_y => 100,                   -- Y coordinate of the image
   p_w =>  0,                   -- Image width, if 0 then the image is displayed in its actual width
   p_h =>  0                    -- Image height, if 0 then the image is displayed in its actual height
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'Image');
  commit;
end;
--Rotate
procedure Rotate is
  l_blob blob;
begin
   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Places the cursor at the X and Y coordinate */
  plpdf.SetCurrentXY(
   p_x => 50,             -- X coordinate
   p_y => 50              -- Y coordinate
   );

  /* Sets the degree of rotation. Text and images can both be rotated. */
  plpdf.SetRotate(
   p_angle => 45          -- Angle/degree of rotation
   );

 /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',        -- Font family: Arial
   p_style => 'B',             -- Font style: Bold
   p_size => 12                -- Font size: 12 pt
   );

   /* Draws a rectangle cell with text inside. */
  plpdf.PrintoutText(
   p_x => 50,           -- Rectangle width
   p_y => 10,           -- Rectangle height
   p_txt => 'ROTATE'   -- Text in rectangle
   );


  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the degree of rotation. Text and images can both be rotated. */
   plpdf.SetRotate(
   p_angle => 120,      -- Angle/degree of rotation
   p_x => 50,           -- X coordinate of the rotation point, if -1 then the X coordinate of the cursor
   p_y => 50            -- Y coordinate of the rotation point, if -1 then the Y coordinate of the cursor
   );

    /* Draws a rectangle cell with text inside. */
  plpdf.PrintoutText(
   p_x => 50,           -- Rectangle width
   p_y => 10,           -- Rectangle height
   p_txt => 'ROTATE2'   -- Text in rectangle
   );

  /*Sets rotate back*/
  plpdf.SetRotate(0);

 /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'Rotate');
  commit;
end;
--SetRotatePage
procedure SetRotatePage is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                       -- Font size: 12
   );

    /* Draws a rectangle cell with text inside. */
  plpdf.PrintoutText(
   p_x => 50,           -- Rectangle width
   p_y => 50,           -- Rectangle height
   p_txt => 'SetRotatePage example'   -- Text in rectangle
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.printCell(
  p_width => 100,          -- Rectangle width
  p_height => 10,           -- Rectangle height
  p_text => 'Sample Text'  -- Text in rectangle
  );

  /* Sets the degree of rotation for all pages. The value must be a multiple of 90. */
  plpdf.setRotatePages(
  p_angle => 90     -- Angle/degree of rotation
  );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetRotatePage');
  commit;
end;
/*CreateBookmark*/
procedure CreateBookmark is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

   /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',        -- Font family: Arial
   p_style => 'B',             -- Font style: Bold
   p_size => 12                -- Font size: 12 pt
   );

  /* Create a bookmark in the PDF document.
     Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
  plpdf.CrBookmark(
   p_txt => 'Page 1',         -- Text of bookmark
   p_level => 0,              -- Bookmark level
   p_y => -1                  -- Y coordinate of the bookmark within the current page: denoted
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.printCell(
   p_width => 50,           -- Rectangle width
   p_height => 10,           -- Rectangle height
   p_text => 'Page 1'    -- Text in rectangle
   );

  /* Cursor is placed at the start of the next line. */
  plpdf.NewLine(
  p_h => 20           -- Height of the line break.
  );

  /* Create a bookmark in the PDF document.
     Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
  plpdf.CrBookmark(
   p_txt => 'Paragraph 1.1',  -- Text of bookmark
   p_level => 1,              -- Bookmark level
   p_y => -1                  -- Y coordinate of the bookmark within the current page. ?1 denotes the cursor position.
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.printCell(
   p_width => 50,                 -- Rectangle width
   p_height => 10,                 -- Rectangle heigth
   p_text => 'Paragraph 1.1'   -- Text in rectangle
   );

  /* Cursor is placed at the start of the next line. */
  plpdf.NewLine(
  p_h => 40             -- Height of the line break.
  );

  /* Create a bookmark in the PDF document.
     Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
  plpdf.CrBookmark(
   p_txt => 'Paragraph 1.2',  -- Text of bookmark
   p_level => 1,              -- Bookmark level
   p_y => -1                  -- Y coordinate of the bookmark within the current page. ?1 denotes the cursor position.
   );

   /* Draws a rectangle cell with text inside. */
  plpdf_cell.printCell(
   p_width => 50,                 -- Rectangle width
   p_height => 10,                 -- Rectangle heigth
   p_text => 'Paragraph 1.2'   -- Text in rectangle
   );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Create a bookmark in the PDF document.
     Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
  plpdf.CrBookmark(
   p_txt => 'Page 2',         -- Text of bookmark
   p_level => 0,              -- Bookmark level
   p_y => -1                  -- Y coordinate of the bookmark within the current page: denoted
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.printCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 2'   -- Text in rectangle
   );

   /* Create a new page. Without parameters the default page orientation: portrait. */
   plpdf.NewPage;

  /* Create a bookmark in the PDF document.
     Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
  plpdf.CrBookmark(
   p_txt => 'Page 3',         -- Text of bookmark
   p_level => 0,              -- Bookmark level
   p_y => -1                  -- Y coordinate of the bookmark within the current page: denoted
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.printCell(
   p_width => 50,                 -- Rectangle width
   p_height => 10,                 -- Rectangle height
   p_text => 'Page 3'          -- Text in rectangle
   );

   /* Create a new page. Without parameters the default page orientation: portrait. */
   plpdf.NewPage;

  /* Create a bookmark in the PDF document.
     Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader). */
  plpdf.CrBookmark(
   p_txt => 'Page 4',         -- Text of bookmark
   p_level => 0,              -- Bookmark level
   p_y => -1                  -- Y coordinate of the bookmark within the current page: denoted
   );

  /* Draws a rectangle cell with text inside. */
   plpdf_cell.printCell(
   p_width => 50,                 -- Rectangle width
   p_height => 10,                 -- Rectangle height
   p_text => 'Page 4'          -- Text in rectangle
   );

   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'CreateBookmark');
  commit;
end;
/*TTFembending*/
procedure TTFembending is
  l_blob blob;
  l_ttf plpdf_type.t_addfont;
begin

   /*
  begin
    plpdf_ttf_parser.storettf(
      p_font_file_id => 1
      );
  end;
  result = 1
  */

  /* Retrieves the font form PLPDF_TTF_ADD table.*/
  l_ttf := plpdf_Ttf.GetTTF(
            p_id => 1  -- ID field of the PLPDF_TTF_ADD table
            );

   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Imports a TTF (True Type Font). The imported font becomes
     available to the SetPrintFont procedure. */
  Plpdf.addTTF(
   p_family => 'DejaVuSerif-Italic',  -- TTF name
   p_style => null,  -- Font style: Regular
   p_data => l_ttf  -- It contains the font definition binary file
   );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

   /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'DejaVuSerif-Italic',    -- Font family: DejaVuSerif-Italic
   p_style => null,          -- Font style: regular
   p_size => 12              -- Font sie 12;
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 200,         -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Font family:DejaVuSerif-Italic -> TTF Example' -- Text in rectangle
   );


   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'TTFembending');
  commit;
end;
/*TTFembendingSubset*/
procedure TTFembendingSubset is
  l_blob blob;
  l_ttf plpdf_type.t_addfont;
begin

 /*
  begin
  plpdf_ttf_parser.StoreTTF_Utf16(
    p_font_file_id => 1,
    p_commit => true,
    p_enable_subset => true --= make runtime subset
    );
   end;
  result = 2
  */

  /* Retrieves the font form PLPDF_TTF_ADD table.*/
  l_ttf := plpdf_Ttf.GetTTF(
            p_id => 1  -- ID field of the PLPDF_TTF_ADD table
            );

   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Imports a TTF (True Type Font). The imported font becomes
     available to the SetPrintFont procedure. */
  Plpdf.addTTF(
   p_family => 'DejaVuSerif-Italic',  -- TTF name
   p_style => null,  -- Font style: Regular
   p_data => l_ttf  -- It contains the font definition binary file
   );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

   /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'DejaVuSerif-Italic',    -- Font family: DejaVuSerif-Italic
   p_style => null,          -- Font style: regular
   p_size => 12              -- Font sie 12;
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 200,         -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Font family:DejaVuSerif-Italic -> TTF Example subsetted' -- Text in rectangle
   );

   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'TTFembendingSubset');
  commit;
end;
--Clipping
procedure Clipping is
  l_blob blob;
  l_text varchar2(255) := 'Hello World! PLPDF Hello World! PLPDF';
  l_length number;
begin
   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',        -- Font family: Arial
   p_style => null,             -- Font style: Bold
   p_size => 12                -- Font size: 12 pt
   );

  /* function plpdf.GetTextWidth:
     Returns the width of the parameter text.
     The width of the text in the unit of measure specified in plpdf.Init */
  l_length := plpdf.GetTextWidth(
               p_s => l_text  -- Parameter text
               );

  /* Starts a clipping frame.
     The clipping limits the region that can be paint. */
  plpdf.StartClipping(
  p_x => 20,                  -- X coordinate for the start of the clipping frame
  p_y => 15,                  -- Y coordinate for the start of the clipping frame
  p_w => 45,                  -- Height of clipping frame
  p_h => 60                   -- Width of clipping frame
  );

  for l_i in 1..10 loop
    /* Draws a rectangle cell with text inside. */
    plpdf_cell.PrintCell(
     p_width => l_length,         -- Rectangle width
     p_height => 10,               -- Rectangle heigth
     p_text => l_text,         -- Text in rectangle
     p_ln => 1                -- Cursor position after the cell is printed: New line
     );
  end loop;

  /* The clipping affects for objects wich located between
     StartClipping and EndClipping. */
  plpdf.EndClipping;

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'Clipping');
  commit;
end;
--Protect
procedure Protect is
  l_blob blob;
begin
    /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;
  /* Allows to protect the PDF document. */
  plpdf.SetProtection(
   p_print_perm => false,          -- Print the PDF
   p_modify_perm => true,         -- Modify the PDF
   p_copy_perm => true,           -- Copy the PDF
   p_annot_forms_perm => true,    -- Add annotations and forms
   p_user_pass => 'apple',        -- User password
   p_owner_pass=> 'pear'          -- Owner password
   );

   /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;


   /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => null,          -- Font style: regular
   p_size => 12              -- Font sie 12;
   );

   /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 65,           -- Rectangle width
   p_height => 10,           -- Rectangle height
   p_text => 'Protection example'     -- Text in rectangle
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'Protect');
  commit;
end;
--JavaScript
procedure JavaScript is
  l_blob blob;
begin

   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

   /* Add JavaScript inside the PDF. */
  Plpdf.addJavaScript (
  p_name => 'JsName',
  p_text => 'this.print(true);' -- JavaScript source code: print pdf when open
  );

   /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => null,          -- Font style: regular
   p_size => 12              -- Font sie 12;
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'JavaScript'  -- Text in rectangle
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'JavaScript');
  commit;
end;
/*AttachFile*/
procedure AttachFile is
  l_blob blob;
  l_pdf blob;
begin
  /* Select another PDF into l_pdf */
  begin
    select  blob_file
      into  l_pdf
      from  store_BLOB
     where rownum < 2;
  exception when no_data_found then
    InitDefault();
    --again
    select  blob_file
      into  l_pdf
      from  store_BLOB
     where rownum < 2;
  end;

    /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Attachs a file to the PDF document. */
  plpdf.AttachFile(
   p_filename => 'test.pdf',        -- Name of file
   p_fileblob => l_pdf,              -- BLOB containing the PDF as binary data
   p_desc => 'Desctription text'    -- Desctription of file
   );

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => null,          -- Font style: regular
   p_size => 12              -- Font sie 12;
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 80,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Attached File'        -- Text in rectangle
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'AttachFile');
  commit;
end;
/*PageNumber*/
procedure PageNumber is
  l_blob blob;
  /*
  Logical Page | Command | PageNo
   1              -         1/2
   2              end       2/2
   3              -         -
   4              -         -
   5              start     1/4
   6              -         2/4
   7              -         3/3
   8              -         4/4
   9              start     1/2
   10             -         2/2  
   */
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.header2',    -- Page header procedure name: xheader
   p_height => 10               -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.footer2',   --Page footer procedure name: xfooter
   p_height => 10               --Height of footer section
   );

  /* Page 1, PageNo. 1/2 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => null,          -- Font style: regular
   p_size => 12              -- Font sie 12;
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 1'   -- Text in rectangle
   );

  /* Page 2, PageNo. 2/2 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets end of page numbering to the current page. */
  plpdf.SetPageNoEnd;

 /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 2'   -- Text in rectangle
   );

  /* Page 3, PageNo. -- */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

 /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 3'   -- Text in rectangle
   );

  /* Page 4, PageNo. -- */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 4'   -- Text in rectangle
   );

  /* Page 5, PageNo. 1/4 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets start of page numbering to the current page. */
  plpdf.SetPageNoStart;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 5'   -- Text in rectangle
   );

  /* Page 6, PageNo. 2/4 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 6'   -- Text in rectangle
   );

  /* Page 7, PageNo. 3/4 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 7'   -- Text in rectangle
   );

  /* Page 8, PageNo. 4/4 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 8'   -- Text in rectangle
   );

  /* Page 9, PageNo. 1/2 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets start of page numbering to the current page. */
  plpdf.SetPageNoStart;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 9'   -- Text in rectangle
   );

  /* Page 10, PageNo. 2/2 */

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,          -- Rectangle width
   p_height => 10,          -- Rectangle height
   p_text => 'Page 10'  -- Text in rectangle
   );

    /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'PageNumber');
  commit;
end;
/*header2*/
procedure header2 
  is
begin
  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => 'BU',        -- Font style: Bold and Underline
   p_size => 12            -- Font size: 12 pt
   );

  /* Page title */

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => null,                          -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page title text',        -- Text in rectangle
   p_ln => '0',                       -- Cursor position after the cell is printed: Beside
   p_align => 'C'                     -- Text alignment: Center
   );

  /* Line break.
     Cursor is placed at the start of the next line. */
  plpdf.NewLine(
   p_h => 20                          --Height of the line break.
   );
end;
/*footer2*/
procedure footer2 
  is
begin
  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',     -- Font family: Arial
   p_style => 'I',          -- Font style: Italic
   p_size => 8              -- Font size: 8 pt
   );

  /* Print number of page */

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => null,                -- Rectangle width
   p_height => 10,               -- Rectangle heigth
   --p_txt => '{cp}/{nb}',    -- Text in rectangle
   p_text => to_char(plpdf.getCurrPageNum)||'/'||to_char(plpdf.getNumOfPages()),    -- Text in rectangle
   p_ln => '0',             -- Cursor position after the cell is printed: Beside
   p_align => 'C'           -- Text alignment: Center
   );
end;
/*TextAnnotation*/
procedure TextAnnotation is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* 1st annotation */

  /* Add Text annotation to the current page. */
  plpdf_annot.AddTextAnnot(
    p_name => 'Note',     -- The name of an icon to be used in displaying the annotation.
    p_contents => 'With Oracle Enterprise Manager 10g Release 2, ' ||
                  'customers can manage many business applications, ' ||
                  'end-user services and the entire grid infrastructure ' ||
                  'as easily as managing one application running on one computer.',
                  /* The text to be displayed in the pop-up window when the annotation is opened. */
    p_x => 20,            -- X coordinate of the annotation
    p_y => 30             -- Y coordinate of the annotation
    );



  /* 2nd annotation */

  /* Add Text annotation to the current page. */
  plpdf_annot.AddTextAnnot(
    p_name => 'Key',      -- The name of an icon to be used in displaying the annotation.
    p_contents => 'Manage your grids as a single entity using improved ' ||
                  'tools such as new service modeling, broader support ' ||
                  'for service protocols, and comprehensive policies and templates. ' ||
                  'Virtualized application component resources, ' ||
                  'as well as virtualized infrastructure components, ' ||
                  'are transparently monitored, diagnosed, and provisioned.',
                  /* The text to be displayed in the pop-up window when the annotation is opened. */
    p_x => 20,            -- X coordinate of the annotation
    p_y => 50,            -- Y coordinate of the annotation
    p_label => 'Manage Virtualized Grid Resources',
                  /* The text label to be displayed in the title bar
                     of the annotation?s pop-up window when open and active. */
    p_popup_x  => 40,     -- X coordinate of the pop-up window
    p_popup_y  => 50,     -- Y coordinate of the pop-up window
    p_popup_w  => 100,    -- Width of the pop-up window
    p_popup_h  => 50      -- Height of the pop-up window
    );



  /* 3rd annotation */

  /* Add Text annotation to the current page. */
  plpdf_annot.AddTextAnnot(
    p_name => 'Comment',  -- The name of an icon to be used in displaying the annotation.
    p_contents => 'Unique service management features such as graphical ' ||
                  'service topologies and service dashboards provide the ' ||
                  'right information to high-level decision makers and lines ' ||
                  'of business managers so they can better understand system ' ||
                  'and service level quality and plan effectively. ' || '
                  Robust automated provisioning and patching functionality ' ||
                  'give IT administrators the power make efficient, error-free changes.',
                  /* The text to be displayed in the pop-up window when the annotation is opened. */
    p_x => 20,            -- X coordinate of the annotation
    p_y => 70,            -- Y coordinate of the annotation
    p_label => 'Best Quality of Service at Lowest Management Cost',
                  /* The text label to be displayed in the title bar
                     of the annotation?s pop-up window when open and active. */
    p_color => plpdf_const.Lime, -- This color will be used.(see User Guide)
    p_popup_x  => 40,     -- X coordinate of the pop-up window
    p_popup_y  => 70,     -- X coordinate of the pop-up window
    p_popup_w  => 140,    -- Width of the pop-up window
    p_popup_h  => 50      -- Height of the pop-up window
    );



  /* 4th annotation */

  /* Add Text annotation to the current page. */
  plpdf_annot.AddTextAnnot(
    p_name => 'Help',     -- The name of an icon to be used in displaying the annotation.
    p_contents => 'Increased management scope for IT infrastructure products ' ||
                  'provide customers improved insight into every aspect of ' ||
                  'service performance ? including application servers, ' ||
                  'firewalls, operating systems, load balancers, ' ||
                  'and storage components. Customers can easily detect and ' ||
                  'resolve issues throughout a grid as well as monitor and ' ||
                  'manage key non-Oracle products in the data center environment.',
                  /* The text to be displayed in the pop-up window when the annotation is opened. */
    p_x => 20,            -- X coordinate of the annotation
    p_y => 90,            -- X coordinate of the annotation
    p_label => 'Higher Value through Wider Breadth of Management',
                  /* The text label to be displayed in the title bar
                     of the annotation?s pop-up window when open and active. */
    p_color => plpdf_const.Salmon,  -- This color will be used.(see User Guide)
    p_popup_x  => 40,     -- X coordinate of the pop-up window
    p_popup_y  => 90,     -- X coordinate of the pop-up window
    p_popup_w  => 140,    -- Width of the pop-up window
    p_popup_h  => 50,     -- Height of the pop-up window
    p_open => true        -- A flag specifying whether the pop-up window should initially be displayed open.
    );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'TextAnnotation');
  commit;
end;
/*FileAnnotation*/
procedure FileAnnotation is
  l_blob blob;
  l_blob2 blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */

  /* Get file from STORE_BLOB */
  <<again>>
  begin
    select  x.blob_file
      into  l_blob2
      from  store_blob x
     where  rownum < 2;
  exception when no_data_found then
    InitDefault();
    goto again;
  end;

  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;


 /* Add File annotation to the current page. */
 plpdf_annot.AddFileAnnot(
   p_name => 'Paperclip',       -- The name of an icon to be used in displaying the annotation.
   p_contents => 'Oracle Database 10g has unique security features that ' ||
                 'address requirements in the areas of privacy, ' ||
                 'regulatory compliance, and data consolidation, ' ||
                 'including row-level security, fine grained auditing, ' ||
                 'and transparent data encryption.',
                 /* The text to be displayed in the pop-up window when the
                    annotation is opened. */
   p_x => 20,                   -- X coordinate of the annotation
   p_y => 20,                   -- Y coordinate of the annotation
   p_filename => '1.pdf',       -- name of file
   p_fileblob => l_blob2,       -- BLOB containing the PDF as binary data
   p_label => 'Industry-Leading Security',
                /* The text label to be displayed in the title bar of the
                   annotation?s pop-up window when open and active. */
   p_color => plpdf_const.Lime  -- This color will be used.(see User Guide)
   );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'FileAnnotation');
  commit;
end;
/*MarkupAnnotation*/
procedure MarkupAnnotation is
  l_blob blob;
  l_x number;
  l_y number;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Gets the X coordinate of the cursor. */
  l_x := plpdf.GetCurrentX ;
  /* Gets the Y coordinate of the cursor */
  l_y := plpdf.GetCurrentY;

  /* Draws a rectangle cell with text inside.
     The rectangle may have a border and fill color specified. */
  plpdf_cell.PrintCell(
   p_width => 80,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Highlight Annotation'    -- Text in rectangle
   );

  /* Add HighLight annotation to the current page. */
  plpdf_annot.AddHighLightAnnot(
   p_contents => 'With Oracle Database 10g, the first relational database ' ||
                 'designed for Grid Computing, your information is always ' ||
                 'available and secure. Oracle Database 10g lowers the cost ' ||
                 'of ownership through automated management while providing ' ||
                 'the highest possible quality of service. And with Release 2, ' ||
                 'Oracle builds on Release 1''s foundation to further improve ' ||
                 'efficiencies and reduce the cost of information management. ' ||
                 'Oracle is the best choice for large enterprises, ' ||
                 'small and midsize businesses, and departments alike.',
                 /* The text to be displayed in the pop-up window when the annotation is opened. */
   p_x => l_x,                        -- X coordinate of the annotation
   p_y => l_y + 1,                    -- Y coordinate of the annotation
   p_w => 50,                         -- Width of the annotation
   p_h => 7,                          -- Height of the annotation
   p_label => 'The First Database Designed for Grid Computing',
                  /* The text label to be displayed in the title bar of the
                  annotation?s pop-up window when open and active. */
   p_color => plpdf_const.Lime,       -- This color will be used.(see User Guide)
   p_popup_x => l_x,                  -- X coordinate of the pop-up window
   p_popup_y => l_y + 7,              -- Y coordinate of the pop-up window
   p_popup_w => 80,                   -- Width of the pop-up window
   p_popup_h => 50                    -- Height of the pop-up window
   );

  /* Places the cursor at the Y coordinate. */
  plpdf.SetCurrentY(
   p_y => l_y + 50                    -- Y coordinate
  );

  /* Gets the Y coordinate of the cursor */
  l_y := plpdf.GetCurrentY;

  /* Draws a rectangle cell with text inside.
     The rectangle may have a border and fill color specified. */
  plpdf_cell.PrintCell(
   p_width => 80,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'StrikeOut Annotation'    -- Text in rectangle
   );

 /* Add StrikeOut annotation to the current page. */
  plpdf_annot.AddStrikeOutAnnot(
   p_contents => 'Oracle Database 10g delivers the response times your users' ||
                 'demand and reduces your cost of downtime. And only Oracle ' ||
                 'offers non-stop availability, scalability, and low-cost ' ||
                 'clustering with Oracle Real Application Clusters, ' ||
                 'the foundation for Grid Computing.',
                 /* The text to be displayed in the pop-up window
                    when the annotation is opened. */
   p_x => l_x,                        -- X coordinate of the annotation
   p_y => l_y + 1,                    -- Y coordinate of the annotation
   p_w => 50,                         -- Width of the annotation
   p_h => 7,                          -- Height of the annotation
   p_label => 'Availability and Scalability with Grid Computing',
                 /* The text label to be displayed in the title bar of the
                    annotation?s pop-up window when open and active. */
   p_color => plpdf_const.Turquoise,  -- This color will be used.(see User Guide)
   p_popup_x => l_x,                  -- X coordinate of the pop-up window
   p_popup_y => l_y + 7,              -- Y coordinate of the pop-up window
   p_popup_w => 80,                   -- Width of the pop-up window
   p_popup_h => 50                    -- Height of the pop-up window
   );

  /* Places the cursor at the Y coordinate. */
  plpdf.SetCurrentX(
   p_x => l_X + 100                   -- X coordinate
   );

  /* Gets the X coordinate of the cursor */
  l_x := plpdf.GetCurrentX;

  /* Draws a rectangle cell with text inside.
     The rectangle may have a border and fill color specified. */
  plpdf_cell.PrintCell(
   p_width => 80,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Underline Annotation'    -- Text in rectangle
   );

  /* Add Underline annotation to the current page. */
  plpdf_annot.AddUnderlineAnnot(
   p_contents => 'Oracle automates time-consuming, error-prone administrative ' ||
                 'tasks, so DBAs can focus on strategic business objectives. ' ||
                 'Studies from the Edison Group prove Oracle Database 10g ' ||
                 'offers superior manageability and significant cost savings ' ||
                 'over IBM DB2 8.2 as well as Microsoft SQL Server 2000.',
                 /* The text to be displayed in the pop-up window when the
                 annotation is opened. */
   p_x => l_x,                        -- X coordinate of the annotation
   p_y => l_y + 1,                    -- Y coordinate of the annotation
   p_w => 50,                         -- Width of the annotation
   p_h => 7,                          -- Height of the annotation
   p_label => 'Lower Costs with the Self-Managing Database',
                 /* The text label to be displayed in the title bar of the
                    annotation?s pop-up window when open and active. */
   p_color => plpdf_const.Violet,     -- This color will be used.(see User Guide)
    p_popup_x => l_x,                 -- X coordinate of the pop-up window
   p_popup_y => l_y + 7,              -- Y coordinate of the pop-up window
   p_popup_w => 80,                   -- Width of the pop-up window
   p_popup_h => 50                    -- Height of the pop-up window
   );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'MarkupAnnotation');
  commit;
end;
/*ScreenAnnotation*/
procedure ScreenAnnotation is
  l_blob blob;
  l_file blob;
begin
   /* Select another PDF into l_pdf */
  begin
    select  blob_file
      into  l_file
      from  store_BLOB
      where rownum < 2;
  exception when no_data_found then
    InitDefault();
    select  blob_file
      into  l_file
      from  store_BLOB
      where rownum < 2;
  end;

   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

   /* Draws a rectangle cell with text inside.
     The rectangle may have a border and fill color specified. */
  plpdf_cell.PrintCell(
   p_width => 80,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'ScreenAnnotation'    -- Text in rectangle
   );

   /* Draws a rectangle on the page. */
  plpdf.Rect(
  p_x => 10,           -- X coordinate for the top left corner of the rectangle
  p_y => 20,           -- Y coordinate for the top left corner of the rectangle
  p_w => 50,          -- Rectangle width
  p_h => 50,           -- Rectangle height
  p_draw => true       -- Style: border
  );

  /* Draws a rectangle on the page. */
  plpdf.Rect(
  p_x => 80,           -- X coordinate for the top left corner of the rectangle
  p_y => 20,           -- Y coordinate for the top left corner of the rectangle
  p_w => 50,          -- Rectangle width
  p_h => 50,           -- Rectangle height
  p_draw => true      -- Style: border
  );

   /* A screen annotation specifies a region of a page upon which media clips may be played.
     Source of the media is an URL. */
   plpdf_annot.AddScreenAnnotURL(
   p_name => 'ScreenAnnotationURL' ,      -- Name of the media clip.
   p_x => 10 ,                           -- X coordinate of the annotation
   p_y => 20,                           -- Y coordinate of the annotation
   p_w => 50,                           -- width of the annotation
   p_h => 50,                           -- height of the annotation
   p_url => 'http://www.plpdf.com',   -- URL of the annotation
   p_mime => '',                        -- MIME type of the annotation
   p_event => null                    -- dditional action when play annotation, (null - default)
   );

   /* A screen annotation specifies a region of a page upon which media clips may be played.
    Source of the media is an BLOB. */
   plpdf_annot.AddScreenAnnotFile(
   p_name => 'ScreenAnnotationFile' ,     -- Name of the media clip.
   p_x => 80 ,                           -- X coordinate of the annotation
   p_y => 20,                           -- Y coordinate of the annotation
   p_w => 50,                           -- width of the annotation
   p_h => 50,                           -- height of the annotation
   p_fileblob => l_file,                -- File of the annotation
   p_mime => '',                        -- MIME type of the annotation
   p_event => null                    -- dditional action when play annotation, (null - default)
   );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'ScreenAnnotation');
  commit;
 end;
/*ChineseFont*/
procedure ChineseFont is
  l_blob blob;
  l_chinese varchar2(2000 char);
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Create a new page. Without parameters the default page orientation: portrait. */
  plpdf.NewPage;

  /* Create a chinese text */
  l_chinese := UNISTR(
             '\53d6\6e96\53d7\4fdd\4eba\5728\6211\56fd\7ecf\6d4e\7ed3\6784'
          || '\8fdb\884c\6218\7565\6027\8c03\6574\7684'
          || '\80CC\666F\4e0B\ff0c\4FE1\606f\4ea7\4e1a'
          || '\5c06\6210\4E3A\62c9\52A8\7ecf\6d4e\589e'
          || '\957f\7684\65b0\52A8\529b\ff0c\800c\4f5c'
          || '\4E3A\4FE1\606f\6280\672f\6838\5fc3\4e4b'
          );

  /* Add CJK (Chinese/Japanese/Korean) font. */
  plpdf.AddCJKFont(
    plpdf_const.font_chinese_GB -- Name of font
    );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => plpdf_const.font_chinese_GB,   -- Font family: STSongStd-Light-Acro
   p_style => null,                             -- Font style: regular (default)
   p_size => 12                                 -- Font size: 12 pt
   );

  /* Draws a multi line cell. */
  plpdf_cell.PrintMultiLineCell(
   p_width => 50, -- Rectangle width
   p_height => 10, -- Rectangle height
   p_text => l_chinese -- Variable containing the chinese text
   );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE,FILENAME) VALUES (l_blob,sysdate,'ChineseFont');
  commit;
end;
/*WithoutTOC*/
procedure WithoutTOC is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;


  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.footerTOC1',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );


  /* Page 5 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 5'                  -- Text in rectangle
   );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'WithoutTOC');
  commit;
end;
/*HeaderTOC1*/
procedure HeaderTOC1 
  is
begin
   /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => 'BU',        -- Font style: Bold and Underline
   p_size => 12            -- Font size: 12 pt
   );

  /* Page title */

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => null,                          -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page title text',        -- Text in rectangle
   p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside
   p_align => plpdf3.c_center                     -- Text alignment: Center
   );
end;
/*FooterTOC1*/
procedure FooterTOC1 
  is
begin
  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => 'I',        -- Font style: regular (default)
   p_size => 8            -- Font size: 12 pt
   );

  /*Number of page*/
  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => null,                          -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => To_CHAR(plpdf.getCurrPageNum), -- Text in rectangle
   p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside the cell
   p_align => plpdf3.c_center                     -- Alignment: Center
   );
end;
/*MinimalTOC*/
procedure MinimalTOC is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;
  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'BasicExamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'BasicExamples.FooterTOC1',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 1'                   -- Label of TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 2'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 3'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 4'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
   p_item_height => 10                -- Height of TOC item cell
   );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'MinimalTOC');
  commit;
end;
/*NormalTOC*/
procedure NormalTOC 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.FooterTOC1',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 1'                   -- Label of TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 2'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 3'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 4'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
   p_item_height => 10,               -- Height of TOC item cell
   p_title_font_family => 'Courier',  -- Font family of title text
   p_title_font_style => 'BU',        -- Font style of title text
   p_title_font_size => 15,           -- Font size of title text
   p_title_height => 20,              -- Height of title's cell
   p_title_text => 'Table of Contents',  -- Title of TOC
   p_title_body_gap => 20,            -- Gap between title and TOC items
   p_separator => '.'                 -- Filler between TOC item and page number
   );

  /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
  p_blob => l_blob  -- The generated document
  );

  /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.init;
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'NormalTOC');
  commit;
end;
/*MovetoTOC*/
procedure MovetoTOC 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;
  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.FooterTOC1',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 1'                   -- Label of TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 2'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 3'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 4'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
   p_item_height => 10,               -- Height of TOC item cell
   p_title_font_family => 'Courier',  -- Font family of title text
   p_title_font_style => 'BU',        -- Font style of title text
   p_title_font_size => 15,           -- Font size of title text
   p_title_height => 20,              -- Height of title's cell
   p_title_text => 'Table of Contents',  -- Title of TOC
   p_title_body_gap => 20,            -- Gap between title and TOC items
   p_separator => '.',                -- Filler between TOC item and page number
   p_move_to => 1                     -- Move TOC pages to a new page number in PDF
   );
  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'MovetoTOC');
  commit;
end;
/*CoverPageTOC*/
procedure CoverPageTOC is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.FooterTOC2',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Cover Page */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => 'B',                    -- Font style: Bold
   p_size => 14                       -- Font size: 14 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Cover Page'              -- Text in rectangle
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 1'                   -- Label of TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 2'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 3'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
   p_item_height => 10,               -- Height of TOC item cell
   p_title_font_family => 'Courier',  -- Font family of title text
   p_title_font_style => 'BU',        -- Font style of title text
   p_title_font_size => 15,           -- Font size of title text
   p_title_height => 20,              -- Height of title's cell
   p_title_text => 'Table of Contents',  -- Title of TOC
   p_title_body_gap => 20,            -- Gap between title and TOC items
   p_separator => '.',                -- Filler between TOC item and page number
   p_move_to => 2                     -- Move TOC pages to a new page number in PDF
   );
  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'CoverPageTOC');
  commit;
end;
/*FooterTOC2*/
procedure FooterTOC2 
  is
begin
 /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => 'I',        -- Font style: regular (default)
   p_size => 8            -- Font size: 12 pt
   );

  /* CurrentPageNumber: Returns the page number of the current page. */
  if plpdf.getCurrPageNum > 1 then -- If true then cover page
    /*Number of page*/
    /* Draws a rectangle cell with text inside. */
    plpdf_cell.PrintCell(
     p_width => null,                          -- Rectangle width
     p_height => 10,                         -- Rectangle heigth
     p_text => to_char(plpdf.getCurrPageNum -1), -- Text in rectangle
     p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside the cell
     p_align => plpdf3.c_center                     -- Alignment: Center
     );
  end if;
end;
/*DifferentFooter*/
procedure DifferentFooter 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;
  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.FooterTOC3',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 1'                   -- Label of TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 2'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 3'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 4'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
   p_item_height => 10,               -- Height of TOC item cell
   p_title_font_family => 'Courier',  -- Font family of title text
   p_title_font_style => 'BU',        -- Font style of title text
   p_title_font_size => 15,           -- Font size of title text
   p_title_height => 20,              -- Height of title's cell
   p_title_text => 'Table of Contents',  -- Title of TOC
   p_title_body_gap => 20,            -- Gap between title and TOC items
   p_separator => '.',                -- Filler between TOC item and page number
   p_move_to => 1,                    -- Move TOC pages to a new page number in PDF
   p_stop_footer => false             -- Do not print footer in TOC: false
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'DifferentFooter');
  commit;
end;
/*FooterTOC3*/
procedure FooterTOC3 
is
begin
  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',    -- Font family: Arial
   p_style => 'I',        -- Font style: regular (default)
   p_size => 8            -- Font size: 12 pt
   );

  /* InToc: Is current position inside TOC */
  if plpdf_toc.InTOC then
    /* Draws a rectangle cell with text inside. */
    plpdf_cell.PrintCell(
     p_width => null,                          -- Rectangle width
     p_height => 10,                         -- Rectangle heigth
     p_text => lower(to_char(Plpdf_toc.GetTOCPageNum,'RM')), -- Text in rectangle
     p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside the cell
     p_align => plpdf3.c_center                     -- Alignment: Center
    );
  else
    plpdf_cell.PrintCell(
     p_width => null,                          -- Rectangle width
     p_height => 10,                         -- Rectangle heigth
     p_text => to_char(plpdf.getCurrPageNum), -- Text in rectangle
     p_ln => plpdf_const.beside,                       -- Cursor position after the cell is printed: Beside the cell
     p_align => plpdf3.c_center                     -- Alignment: Center
     );
  end if;
end;
/*TestTOC1Custom*/
procedure TestTOC1Custom 
  is
  l_toc plpdf_type.t_toc_items;
  begin
    /* Print title */

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Courier',         -- Font family: Arial
     p_style => 'B',                -- Font style: regular (default)
     p_size => 15                   -- Font size: 12 pt
     );

    /* Insert title section in TOC (for creating custom TOC). */
    plpdf_toc.PrintTOCTitle(
     p_toc_title_text => 'Table of Contents', -- Text of title
     p_toc_title_height => 20       -- Height of title's cell
     );

    /* Insert gap between title and items (for creating custom TOC). */
    plpdf_toc.TOCInsertGap(
     p_toc_title_body_gap => 20     -- Size of gap
     );


    /* Print items */

    /* Returns array of TOC items (for creating custom TOC). */
    l_toc := plpdf_toc.GetTOCItems;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',           -- Font family: Arial
     p_style => null,               -- Font style: regular (default)
     p_size => 12                   -- Font size: 12 pt
     );

    for l_i in 1..l_toc.count loop
        /* Print a TOC Item into the PDF (for creating custom TOC). */
        plpdf_toc.PrintTOCItem(
         p_item => l_toc(l_i),      -- TOC Item
         p_toc_level_indent  => 0,  -- indent size for levels
         p_toc_item_height => 10,   -- height of TOC item cell
         p_toc_separator => '.'     -- filler between TOC item and page number
         );
  end loop;
end;
/*CustomTOC*/
procedure CustomTOC 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.FooterTOC1',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 1'                   -- Label of TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 2'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 3'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 4'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
   p_custom_proc => 'BasicExamples.TestTOC1Custom' -- The name of the custom procedure which is used for creating TOC
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'CustomTOC');
  commit;
end;
/*ProfTOC*/
procedure ProfTOC is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'basicexamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'basicexamples.FooterTOC1',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );

  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'Content 1',                   -- Label of TOC item
   p_add_link => true,                     -- create link from TOC item to page
   p_add_bookmark => true                  -- create bookmark for TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'Content 1.2',                   -- Label of TOC item
   p_level => 1,                             -- level, 0 is the highest level
   p_add_link => true,                       -- create link from TOC item to page
   p_add_bookmark => true                    -- create bookmark for TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );

  /* Cursor is placed at the start of the next line. */
  plpdf.NewLine(
  p_h => 150          -- Height of the line break.
  );




  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Content 1.3'                  -- Text in rectangle
   );

   /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'Content 1.3',                   -- Label of TOC item
   p_level => 1,                             -- level, 0 is the highest level
   p_add_link => true,                       -- create link from TOC item to page
   p_add_bookmark => true                    -- create bookmark for TOC item
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'Content 2',                   -- Label of TOC item
   p_level => 0,                           -- level, 0 is the highest level
   p_add_link => true,                     -- create link from TOC item to page
   p_add_bookmark => true                  -- create bookmark for TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
    p_item_height => 10,                -- height of TOC item cell
    p_title_font_family => 'Arial',     -- font family of title text: Arial
    p_title_font_style => 'I',          -- font style: Italic
    p_title_font_size => 14,            -- font size: 14
    p_title_height => 20,               -- height of title's cell
    p_title_text => 'Table of Contents',-- title of TOC
    p_title_body_gap => 15,             -- gap between title and TOC items
    p_item_font_family => 'Courier',    -- ont family of TOC items: Courier
    p_item_font_style => null,          -- font style of TOC items: Regular
    p_item_font_size => 12,             -- font size: 12
    p_separator => '.',                 -- filler between TOC item and page number
    p_move_to => 1,                     -- move TOC pages to a new page number in PDF
    p_level_indent => 2                 -- indent size for levels
    );
    
   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'ProfTOC');
  commit;
end;
/*InsMoveTOC*/
procedure InsMoveTOC 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;
  /*Sets the page header procedure name. The program name passed
    as a parameter executes when the page header is created. */
  plpdf.SetHeaderProcName(
   p_proc_name => 'BasicExamples.HeaderTOC1',    -- Page header procedure name
   p_height => 10                     -- Height of header section
   );

  /* Sets the page footer procedure name. The program name passed
     as a parameter executes when the page footer is created. */
  plpdf.SetFooterProcName(
   p_proc_name => 'BasicExamples.FooterTOC1',    --Page footer procedure name
   p_height => 10                     --Height of footer section
   );


  /* Page 1 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 1'                   -- Label of TOC item
   );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 1'                  -- Text in rectangle
   );


  /* Page 2 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 2'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 2'                  -- Text in rectangle
   );


  /* Page 3 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 3'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 3'                  -- Text in rectangle
   );


  /* Page 4 */

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Add Table of Contents item. */
  plpdf_toc.AddTOCItem(
   p_txt => 'TOC 4'                   -- Label of TOC item
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 50,                         -- Rectangle width
   p_height => 10,                         -- Rectangle heigth
   p_text => 'Page 4'                  -- Text in rectangle
   );

  /* Construct Table of Contents. */
  plpdf_toc.AddTOC(
   p_item_height => 10                -- Height of TOC item cell
   );

  /* Move TOC to specified page number. */
  plpdf_toc.InsMoveTOC(
  p_move_to => 2
  );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Print it:

    owa_util.mime_header('application/pdf',false);
          htp.init;
          htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
          owa_util.http_header_close;
          wpg_docload.download_file(l_blob);   */

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'InsMoveTOC');
  commit;
end;
/*PrintoutText*/
procedure PrintoutText is
l_blob blob;

begin
    /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',           -- Font family: Arial
   p_style => null,               -- Font style: regular (default)
   p_size => 12                   -- Font size: 12 pt
   );

  /* Prints a text starting from the specified position. */
  plpdf.PrintoutText(
   p_x => 50,                     -- X coordinate for the start of the text
   p_y => 50,                     -- Y coordinate for the start of the text
   p_txt => 'Print Text Example'  -- Text
   );

   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'PrintText');
  commit;
end;
/*SetAutoNewPage*/
procedure SetAutoNewPage is
  l_blob blob;
begin
   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /*
  Enables or disables automatic page breaks. The p_margin parameter is
  only relevant when enabling automatic page breaks. It sets the bottom
  margin size under which an automatic page break is triggered.
  */
  plpdf.SetAutoNewPage(
  p_auto => true,   -- Automatic page break
  p_margin => 200   -- Bottom margin size, if not set, then 1 cm
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 14                       -- Font size: 14
   );

  /* Draw multiline cell with text inside */
  plpdf_cell.PrintMultiLineCell(
  p_width => null,          -- Rectangle width
  p_height => 20,         -- Rectangle height
  p_text => 'Generate dynamic PDF documents from data stored in Oracle databases ' ||
          'using the PL/PDF program package. PL/PDF is written exclusively in PL/SQL. ' ||
          'It is able to either store the generated PDF document in the database or ' ||
          'provide the results directly to a browser using MOD_PLSQL. No third-party ' ||
          'software is needed; PL/PDF only uses tools provided by the installation ' ||
          'package of an Oracle Database. Use PL/PDF to quickly and easily develop ' ||
          'applications with dynamic content but also quality ' ||
          'presentation and printing capabilities.' -- Text
  );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetAutoNewPage');
  commit;
end;
/*SetCompress*/
procedure SetCompress is
  l_blob blob;
begin
   /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

   /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Enables or disables the compression of PDF documents.
     By default compression is enabled. */
  plpdf.setNOCompress();

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => 100,          -- Rectangle width
  p_height => 10,           -- Rectangle height
  p_text => 'Compressed file'        -- Text in rectangle
  );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetCompress');
  commit;
end;
/*SetNOLastpageProcName*/
procedure SetNOLastpageProcName is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

   /* Sets the not last page procedure name.
     The program name passed as a parameter
     executes when the not last page closed.*/
  plpdf.SetNOLastpageProcName(
  p_proc_name => 'basicexamples.notlastpage'      -- Procedure name
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 1'   -- Text in rectangle
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 2'   -- Text in rectangle
  );

  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 3'   -- Text in rectangle
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 4'   -- Text in rectangle
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

   /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

   /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 5'   -- Text in rectangle
  );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'SetNOLastpageProcName');
  commit;
end;
/*NotLastPage*/
procedure NotLastPage 
  is
begin
  /* Add JavaScript inside the PDF. */
  Plpdf.addJavaScript (
  p_name => 'JSName',
  p_text => 'this.print(true);' -- JavaScript source code: print pdf when open
  );
end;
/*InsertMovePage*/
procedure InsertMovePage 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Insert a new page and move it by changing order of pages. */
  plpdf.InsertMovePage(
  p_orig_pos => 2,      -- origin page position
  p_new_pos => 5        -- new page position
  );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 1'   -- Text in rectangle
  );

  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => ' '
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 3'   -- Text in rectangle
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 4'   -- Text in rectangle
  );

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => null,            -- Rectangle with
  p_height => 10,           -- Rectangle height
  p_text => 'Page 5'  -- Text in rectangle
  );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.init;
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'NotLastPage');
  commit;
end;
/*Opacity*/
procedure Opacity is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;


  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => 'I',                    -- Font style: Italic
   p_size => 12                         -- Font size: 12
   );

  /* Places the cursor at the X and Y coordinate.*/
  plpdf.SetCurrentXY(
  p_x => 140,
  p_y => 15
  );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => 100,          -- Rectangle width
  p_height => 10,           -- Rectangle height
  p_text => 'No transparency'        -- Text in rectangle
  );
   /* Places the cursor at the X and Y coordinate.*/
  plpdf.SetCurrentXY(
  p_x => 140,
  p_y => 30
  );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => 100,          -- Rectangle width
  p_height => 10,           -- Rectangle height
  p_text => 'No transparency'        -- Text in rectangle
  );


  /* Places the cursor at the X and Y coordinate.*/
  plpdf.SetCurrentXY(
  p_x => 140,          -- X coordinate
  p_y => 65            -- Y coordinate
  );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => 100,          -- Rectangle width
  p_height => 10,           -- Rectangle height
  p_text => '50% transparency'       -- Text in rectangle
  );

   /* Places the cursor at the X and Y coordinate.*/
  plpdf.SetCurrentXY(
  p_x => 140,          -- X coordinate
  p_y => 80            -- Y coordinate
  );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
  p_width => 100,          -- Rectangle width
  p_height => 10,           -- Rectangle height
  p_text => '50% transparency'       -- Text in rectangle
  );


  /* Set the fill color */
  plpdf.strokingcolor(
  p_r => 255,     -- Red component code. Number between 0 and 255
  p_g => 0,       -- Green component code. Number between 0 and 255
  p_b => 0        -- Blue component code. Number between 0 and 255
  );

  /* Draws a rectangle on the page */
  plpdf.Rect(
  p_x => 10,           -- X coordinate for the top left corner of the rectangle
  p_y => 10,           -- Y coordinate for the top left corner of the rectangle
  p_w => 100,          -- The width of the rectangle
  p_h => 30,           -- The height of the rectangle
  p_draw => true,
  p_fill => true,
  p_fill_color => plpdf_const.blue
  );

  /* Starts a transparency. The transparency affects for
objects wich located between StartOpacity and EndOpacity. */
  plpdf.StartOpacity(
  p_val => 0.5       -- can be a value from 0.0 - 1.0. A lower value makes the element more transparent.
  );

  /* Set the fill color */
  plpdf.strokingcolor(
  p_r => 255,     -- Red component code. Number between 0 and 255
  p_g => 0,       -- Green component code. Number between 0 and 255
  p_b => 0        -- Blue component code. Number between 0 and 255
  );

   /* Draws a rectangle on the page */
  plpdf.Rect(
  p_x => 10,           -- X coordinate for the top left corner of the rectangle
  p_y => 60,           -- Y coordinate for the top left corner of the rectangle
  p_w => 100,          -- The width of the rectangle
  p_h => 30,           -- The height of the rectangle
  p_draw => true,
  p_fill => true,
  p_fill_color => plpdf_const.blue
  );

  /* End a transparency. */
  plpdf.EndOpacity;

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'Opacity');
  commit;
end;
/*OptCont*/
procedure OptCont 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Start an optional content. */
  plpdf.StartOptCont(
  p_name => 'Name of Content',  -- name of optional content
  p_state => true,              -- default state is visible or invisible
  p_ui_order => false,          -- insert into the state array
  p_print => false              -- printed out
  );

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                    -- Font style: Regular
   p_size => 12                         -- Font size: 12
   );

   /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 160,         -- Rectangle width
   p_height => 50,          -- Rectangle height
   p_text => 'Optional Content Area'  -- Text in rectangle
   );

  /* End an optional content. */
  plpdf.EndOptCont;

  /* Start an optional content. */
  plpdf.StartOptCont(
  p_name => 'Name of Content',  -- name of optional content
  p_state => false,              -- default state is visible or invisible
  p_ui_order => false,          -- insert into the state array
  p_print => false              -- printed out
  );

   /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 160,         -- Rectangle width
   p_height => 50,          -- Rectangle height
   p_text => 'Optional Content Area2'  -- Text in rectangle
   );

  /* End an optional content. */
  plpdf.EndOptCont;


  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Print it:

    owa_util.mime_header('application/pdf',false);
          htp.init;
          htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
          owa_util.http_header_close;
          wpg_docload.download_file(l_blob);   */

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'OptCont');
  commit;
end;
/*TemplatePage*/
procedure TemplatePage 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => 'B',                    -- Font style: Regular
   p_size => 72                         -- Font size: 72
   );

  /* Sets the text color for objects inserted after this statement.
Colors must be specified according to the RGB pallet.*/
  plpdf.nonstrokingcolor(
   p_r => 255,           -- Red component code. Number between 0 and 255
   p_g => 230,           -- Green component code. Number between 0 and 255
   p_b => 230            -- Blue component code. Number between 0 and 255
   );

  /* Places the cursor at the X and Y coordinate. */
  plpdf.SetCurrentXY(
   p_x => 25,          -- X coordinate
   p_y => 10           -- Y coordinate
  );

  /* Draws a rectangle cell with text inside. */
  plpdf_cell.PrintCell(
   p_width => 160,         -- Rectangle width
   p_height => 50,          -- Rectangle height
   p_text => 'TEMPLATE!'  -- Text in rectangle
   );

  /* Places the cursor at the X and Y coordinate. */
  plpdf.SetCurrentXY(
   p_x => 25,          -- X coordinate
   p_y => 110          -- Y coordinate
  );

  plpdf_cell.PrintCell(
   p_width => 160,         -- Rectangle width
   p_height => 50,          -- Rectangle height
   p_text => 'TEMPLATE!'-- Text in rectangle
   );

  /* Places the cursor at the X and Y coordinate. */
  plpdf.SetCurrentXY(
   p_x => 25,          -- X coordinate
   p_y => 210          -- Y coordinate
  );

  plpdf_cell.PrintCell(
   p_width => 160,         -- Rectangle width
   p_height => 50,          -- Rectangle height
   p_text => 'TEMPLATE!' -- Text in rectangle
   );

  /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Print it:

    owa_util.mime_header('application/pdf',false);
          htp.init;
          htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
          owa_util.http_header_close;
          wpg_docload.download_file(l_blob);   */

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'TemplatePage');
  commit;
end;
/*template_init*/
procedure template_init 
  is
  l_pdf blob;
begin
  /* Select template PDF*/
  begin
    select  t.orig_pdf
      into  l_pdf
      from  plpdf_template t
      where id = 1;
  exception when no_data_found then
    delete from store_blob;
    InitDefault();
    select  store_blob.blob_file
      into  l_pdf
      from  store_blob
      where rownum < 2;

    insert into plpdf_template (id, orig_pdf,page_id) values(1, l_pdf,1) returning orig_pdf into l_pdf;
    plpdf_parser.GenerateTemplate(
      p_id => 1
      );
    commit;
  end;

   /* Parsing data */
   v_tpl := plpdf_parser.GetTemplate(
   p_blob => l_pdf,
   p_page_id => 1
   );
end;
/* Procedure which use the template page */
procedure template_eg 
  is
  l_blob blob;
  l_tpl_id number;
begin
    /* Select template PDF*/
    template_init;

    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init();

    /* Insert a template into the pdf.
       Return: Template ID */
    l_tpl_id := plpdf.InsTemplate(
                 p_tpl => v_tpl   -- Template data
                 );

    /* Begin a new page, without parameters means:
     - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Use a template. */
    plpdf.setPageTemplate(
     p_tplidx => l_tpl_id         -- Template ID
     );

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',         -- Font family: Arial
     p_style => null,             -- Font style: regular (default)
     p_size => 12                 -- Font size: 12 pt
     );

    /* Draws a rectangle cell with text inside.
       The rectangle may have a border and fill color specified. */
    plpdf_cell.PrintCell(
     p_width => 50,                   -- Rectangle width
     p_height => 10,                   -- Rectangle heigth
     p_text => 'Template Example'  -- Text in rectangle
     );

     /* Begin a new page, without parameters means:
     - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',         -- Font family: Arial
     p_style => null,             -- Font style: regular (default)
     p_size => 12                 -- Font size: 12 pt
     );

    /* Draws a rectangle cell with text inside.
       The rectangle may have a border and fill color specified. */
    plpdf_cell.PrintCell(
     p_width => 50,                   -- Rectangle width
     p_height => 10,                   -- Rectangle heigth
     p_text => 'Template Example'  -- Text in rectangle
     );


    /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
      plpdf.SendDoc(
      p_blob => l_blob  -- The generated document
      );

      /* Print it:

      owa_util.mime_header('application/pdf',false);
            htp.init;
            htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
            owa_util.http_header_close;
            wpg_docload.download_file(l_blob);   */

      /* Store */
     insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'template_eg');
    commit;
end;
/*setPageDefaultTemplate*/
procedure setPageDefaultTemplate is
  l_blob blob;
  l_tpl_id number;
begin
  /* Select template PDF*/
  template_init;

  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
   plpdf.Init;

   /* Insert a template into the pdf.
     Return: Template ID */
  l_tpl_id := plpdf.InsTemplate(
               p_tpl => v_tpl   -- Template data
               );

   plpdf.setPageDefaultTemplate(
   p_tplidx => l_tpl_id,       -- template ID
   p_fittopage => true         -- fit template to page size
   );

    /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',         -- Font family: Arial
   p_style => null,             -- Font style: regular (default)
   p_size => 12                 -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside.
     The rectangle may have a border and fill color specified. */
  plpdf_cell.PrintCell(
   p_width => 50,                   -- Rectangle width
   p_height => 10,                   -- Rectangle heigth
   p_text => 'Template Example'  -- Text in rectangle
   );

    /* Begin a new page, without parameters means:
   - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',         -- Font family: Arial
   p_style => null,             -- Font style: regular (default)
   p_size => 12                 -- Font size: 12 pt
   );

  /* Draws a rectangle cell with text inside.
     The rectangle may have a border and fill color specified. */
  plpdf_cell.PrintCell(
   p_width => 50,                   -- Rectangle width
   p_height => 10,                   -- Rectangle heigth
   p_text => 'Template Example'  -- Text in rectangle
   );

   /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
    p_blob => l_blob  -- The generated document
    );

    /* Print it:

    owa_util.mime_header('application/pdf',false);
          htp.init;
          htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
          owa_util.http_header_close;
          wpg_docload.download_file(l_blob);   */

    /* Store */
  insert into STORE_BLOB (blob_file, created_date, filename) VALUES (l_blob,sysdate, 'setPageDefaultTemplate');
  commit;
end;
/*Acroform_Choice*/
procedure Acroform_Choice is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;


  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Add choicefield values */
  l_values(1) := 'ONE';
  l_values(2) := 'TWO';
  l_values(3) := 'THREE';

  /* Add ChoiceField. */
  plpdf_acroForm.AddChoiceField(
   p_name => 'ch1',                   -- Identifier of object
   p_values => l_values,              -- Value set of field
   p_value => 'TWO',                  -- Value of field
   p_default_value => 'ONE',          -- The default value
   p_combo => true,                   -- If set, the field is a combo box
   p_x => 10,                         -- X coordinate for the field
   p_y => 70,                         -- Y coordinate for the field
   p_width => 100,                    -- The width of the field
   p_height => 10,                    -- The height of the field
   p_border_width => 0.2,             -- width of border
   p_hint => 'Oracle Application Express (Oracle APEX), ' ||
             'formerly called HTML DB, is a rapid web'
             -- Messages for the field
   );

    /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;
/*Acroform_Pushbutton*/
procedure Acroform_Pushbutton 
  is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;
  l_rb      plpdf_type.t_radiobutton_array;
begin
    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;

    /* Begin a new page, without parameters means: - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     );

    /* Add Pushbutton */
    plpdf_acroForm.AddPushbutton(
     p_name => 'pb1',                   -- Identifier of object
     p_label => 'Say Hello!',           -- Caption of button
     p_x => 10,                         -- X coordinate for the field
     p_y => 110,                        -- Y coordinate for the field
     p_width => 50,                     -- The width of the field
     p_height => 10,                    -- The height of the field
     p_action => plpdf_const.button_action_javascript,  -- Set supported action
     p_javascript => 'app.alert("Hello!");',  -- JavaScript for execution
     p_fill_color => plpdf_const.Light_Grey,  -- Color for filling the field
     p_border_width => 0.3,                   -- Width of border of the field
     p_border_color => plpdf_const.Steelblue, -- Color of border
     p_font_size_auto => true,                -- The text size automatic
     p_hint => 'Oracle Application Express (Oracle APEX), ' ||
               'formerly called HTML DB, is a rapid web'
                -- messages for the field
     );


      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );


    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;
/*Acroform_RadiobuttonField*/
procedure Acroform_RadiobuttonField 
is
  l_blob blob;
  l_rb      plpdf_type.t_radiobutton_array;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  plpdf.setNOCompress;

  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );

  /* Set values of RadioButtonfield */
  l_rb(1).value := 'one';
  l_rb(1).x := 10;
  l_rb(1).y := 10;
  l_rb(1).label := 'Choose the ONE!';

  l_rb(2).value := 'two';
  l_rb(2).x := 10;
  l_rb(2).y := 30;
  l_rb(2).label := 'Or choose the TWO!';

  l_rb(3).value := 'three';
  l_rb(3).x := 10;
  l_rb(3).y := 50;
  l_rb(3).label := 'Or choose the 3!';


  /* Add Radiobutton field */
  plpdf_acroForm.AddRadiobuttonField(
   p_name => 'radio1',                -- Identifier of object
   p_values => l_rb,                  -- Value set of field
   p_value => 'one',                  -- Value of field
   p_default_value => 'one',          -- The default value of field
   p_read_only => false,              -- If set, the user may not change the value
   p_required => false,               -- If set, the field must have a value
   p_NoToggleToOff  => false,         -- If set, exactly one radio button must be selected
   p_height => 10,                    -- The height of the field
   p_gap => 2,                        -- Gap bettween graphical symbol and text
   p_fill_color => plpdf_const.red,  -- Color for filling the field
   p_hint => 'Oracle Application Express (Oracle APEX), ' ||
             'formerly called HTML DB, is a rapid web'
             -- Message for the field
   );

    /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );


  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;
/*Acroform_SignatureField*/
procedure Acroform_SignatureField 
  is
  l_blob blob;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );


  plpdf_acroform.addsignaturefield(
    p_name => 'sig1',
    p_x => 10,                         -- X coordinate for the field
    p_y => 20,                         -- Y coordinate for the field
    p_width => 100,                    -- The width of the field
    p_height => 30,
    p_hint => 'initialize, without parameters means: ' ||
             'page orientation: portrait, unit: mm, ' ||
             'default page format: A4', -- Messages for the field
    p_fill_color => plpdf_const.Green,
    p_border_width => 1,
    p_border_color => plpdf_const.Lime,
    p_border_style => plpdf_const.solid
    );

    /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;
/*Acroform_TextField*/
procedure Acroform_TextField 
is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;
  l_rb      plpdf_type.t_radiobutton_array;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );


/* Add TextField. */
  plpdf_acroForm.AddTextField(
   p_name => 'test1text',             -- Identifier of object
   p_value => 'Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple',                -- Value of field
   p_default_value => 'Default',      -- The default value
   p_x => 10,                         -- X coordinate for the field
   p_y => 20,                         -- Y coordinate for the field
   p_width => 100,                    -- The width of the field
   p_height => 30,                    -- The height of the field
   p_border_width => 1,               -- width of border
   p_border_color => plpdf_const.Lime,-- Color of border
   -- p_fill_color => plpdf_const.Spring_Green, -- Color for filling the field
   p_hint => 'initialize, without parameters means: ' ||
             'page orientation: portrait, unit: mm, ' ||
             'default page format: A4', -- Messages for the field
   --p_rotate => 270,                   -- Rotation of the field
   p_border_style => plpdf_const.solid, -- .beveled,
   p_multiline => true
   );

    /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;
/*Acroform_CheckBoxField*/
procedure Acroform_CheckBoxField 
  is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;
  l_rb      plpdf_type.t_radiobutton_array;
begin
  /* Initialize, without parameters means:
   - page orientation: portrait
   - unit: mm
   - default page format: A4 */
  plpdf.Init;

  plpdf.setNOCompress();

  /* Begin a new page, without parameters means: - page orientation: default (portrait) */
  plpdf.NewPage;

  /* Sets the font and its properties */
  plpdf.SetPrintFont(
   p_family => 'Arial',               -- Font family: Arial
   p_style => null,                   -- Font style: regular (default)
   p_size => 12                       -- Font size: 12 pt
   );


plpdf_acroForm.AddCheckBoxField(
   p_name => 'cb1',                   -- Identifier of object
   p_checked => false,                -- If set, the checkbox is checked
   p_default_checked => false,        -- The default value
   p_read_only => false,              -- If set, the user may not change the value
   p_required => false,               -- If set, the field must have a value
   p_x => 10,                         -- X coordinate for the field
   p_y => 70,                         -- Y coordinate for the field
   p_width => 50,
   p_height => 30,
   p_border_width => 3,
   p_border_color => plpdf_const.Dark_turquoise,
   p_border_style => plpdf_const.beveled, -- Border style: dashed,
   p_fill_color => plpdf_const.Red, -- Color for filling the field
   p_text_color => plpdf_const.Green,
   p_hint => 'Oracle Application Express (Oracle APEX), ' ||
             'formerly called HTML DB, is a rapid web'
             -- Message for field
   );

    /* Returns the generated PDF document.
     The document is closed and then returned in the OUT parameter. */
  plpdf.SendDoc(
   p_blob => l_blob                   -- The generated document
   );

  /* Print it:

owa_util.mime_header('application/pdf',false);
      htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
      owa_util.http_header_close;
      wpg_docload.download_file(l_blob);   */

  /* Store */
  insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;
/***************************************end*******************************************/
end BasicExamples;
/
