create or replace package AcroformExamples is

procedure Acroform_Choice;
procedure Acroform_PushButton;
procedure Acroform_RadioButtonField;
procedure Acroform_SignatureField;
procedure Acroform_TextField;
procedure Acroform_CheckboxField;

end AcroformExamples;
/
create or replace package body AcroformExamples is
procedure Acroform_Choice is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;

  begin
    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;


    /* Begin a new page, without parameters means: - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     );

    /* Add choicefield values */
    l_values(1) := 'ONE';
    l_values(2) := 'TWO';
    l_values(3) := 'THREE';

    /* Add ChoiceField. */
    plpdf_acroForm.AddChoiceField(
     p_name => 'ch1',                   -- Identifier of object
     p_values => l_values,              -- Value set of field
     p_value => 'TWO',                  -- Value of field
     p_default_value => 'ONE',          -- The default value
     p_combo => true,                   -- If set, the field is a combo box
     p_x => 10,                         -- X coordinate for the field
     p_y => 70,                         -- Y coordinate for the field
     p_width => 100,                    -- The width of the field
     p_height => 10,                    -- The height of the field
     p_border_width => 0.2,             -- width of border
     p_hint => 'Oracle Application Express (Oracle APEX), ' ||
               'formerly called HTML DB, is a rapid web'
               -- Messages for the field
     );

      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );

    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
    commit;
  end;

procedure Acroform_Pushbutton is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;
  l_rb      plpdf_type.t_radiobutton_array;

begin
    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;


    /* Begin a new page, without parameters means: - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     );

    /* Add Pushbutton */
    plpdf_acroForm.AddPushbutton(
     p_name => 'pb1',                   -- Identifier of object
     p_label => 'Say Hello!',           -- Caption of button
     p_x => 10,                         -- X coordinate for the field
     p_y => 110,                        -- Y coordinate for the field
     p_width => 50,                     -- The width of the field
     p_height => 10,                    -- The height of the field
     p_action => plpdf_const.button_action_javascript,  -- Set supported action
     p_javascript => 'app.alert("Hello!");',  -- JavaScript for execution
     p_fill_color => plpdf_const.Light_Grey,  -- Color for filling the field
     p_border_width => 0.3,                   -- Width of border of the field
     p_border_color => plpdf_const.Steelblue, -- Color of border
     p_font_size_auto => true,                -- The text size automatic
     p_hint => 'Oracle Application Express (Oracle APEX), ' ||
               'formerly called HTML DB, is a rapid web'
                -- messages for the field
     );


      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );


    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;

procedure Acroform_RadiobuttonField is
  l_blob blob;
  l_rb      plpdf_type.t_radiobutton_array;

  begin
    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;

    plpdf.setNOCompress;

    /* Begin a new page, without parameters means: - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     );

    /* Set values of RadioButtonfield */
    l_rb(1).value := 'one';
    l_rb(1).x := 10;
    l_rb(1).y := 10;
    l_rb(1).label := 'Choose the ONE!';

    l_rb(2).value := 'two';
    l_rb(2).x := 10;
    l_rb(2).y := 30;
    l_rb(2).label := 'Or choose the TWO!';

    l_rb(3).value := 'three';
    l_rb(3).x := 10;
    l_rb(3).y := 50;
    l_rb(3).label := 'Or choose the 3!';


    /* Add Radiobutton field */
    plpdf_acroForm.AddRadiobuttonField(
     p_name => 'radio1',                -- Identifier of object
     p_values => l_rb,                  -- Value set of field
     p_value => 'one',                  -- Value of field
     p_default_value => 'one',          -- The default value of field
     p_read_only => false,              -- If set, the user may not change the value
     p_required => false,               -- If set, the field must have a value
     p_NoToggleToOff  => false,         -- If set, exactly one radio button must be selected
     p_height => 10,                    -- The height of the field
     p_gap => 2,                        -- Gap bettween graphical symbol and text
     p_fill_color => plpdf_const.red,  -- Color for filling the field
     p_hint => 'Oracle Application Express (Oracle APEX), ' ||
               'formerly called HTML DB, is a rapid web'
               -- Message for the field
     );

      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );


    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;

procedure Acroform_SignatureField is
  l_blob blob;

  begin
    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;

    /* Begin a new page, without parameters means: - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     );


    plpdf_acroform.addsignaturefield(
      p_name => 'sig1',
      p_x => 10,                         -- X coordinate for the field
      p_y => 20,                         -- Y coordinate for the field
      p_width => 100,                    -- The width of the field
      p_height => 30,
      p_hint => 'initialize, without parameters means: ' ||
               'page orientation: portrait, unit: mm, ' ||
               'default page format: A4', -- Messages for the field
      p_fill_color => plpdf_const.Green,
      p_border_width => 1,
      p_border_color => plpdf_const.Lime,
      p_border_style => plpdf_const.solid
      );

      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );

    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
    commit;
  end;

procedure Acroform_TextField is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;
  l_rb      plpdf_type.t_radiobutton_array;

  begin
    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;

    /* Begin a new page, without parameters means: - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     );


  /* Add TextField. */
    plpdf_acroForm.AddTextField(
     p_name => 'test1text',             -- Identifier of object
     p_value => 'Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple Apple',                -- Value of field
     p_default_value => 'Default',      -- The default value
     p_x => 10,                         -- X coordinate for the field
     p_y => 20,                         -- Y coordinate for the field
     p_width => 100,                    -- The width of the field
     p_height => 30,                    -- The height of the field
     p_border_width => 1,               -- width of border
     p_border_color => plpdf_const.Lime,-- Color of border
     -- p_fill_color => plpdf_const.Spring_Green, -- Color for filling the field
     p_hint => 'initialize, without parameters means: ' ||
               'page orientation: portrait, unit: mm, ' ||
               'default page format: A4', -- Messages for the field
     --p_rotate => 270,                   -- Rotation of the field
     p_border_style => plpdf_const.solid, -- .beveled,
     p_multiline => true
     );

      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );

    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
    commit;
  end;

procedure Acroform_CheckBoxField is
  l_blob blob;
  l_values  plpdf_type.t_opt_array;
  l_rb      plpdf_type.t_radiobutton_array;

  begin
    /* Initialize, without parameters means:
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.Init;

    plpdf.setNOCompress();

    /* Begin a new page, without parameters means: - page orientation: default (portrait) */
    plpdf.NewPage;

    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     );


 plpdf_acroForm.AddCheckBoxField(
     p_name => 'cb1',                   -- Identifier of object
     p_checked => false,                -- If set, the checkbox is checked
     p_default_checked => false,        -- The default value
     p_read_only => false,              -- If set, the user may not change the value
     p_required => false,               -- If set, the field must have a value
     p_x => 10,                         -- X coordinate for the field
     p_y => 70,                         -- Y coordinate for the field
     p_width => 50,
     p_height => 30,
     p_border_width => 3,
     p_border_color => plpdf_const.Dark_turquoise,
     p_border_style => plpdf_const.beveled, -- Border style: dashed,
     p_fill_color => plpdf_const.Red, -- Color for filling the field
     p_text_color => plpdf_const.Green,
     p_hint => 'Oracle Application Express (Oracle APEX), ' ||
               'formerly called HTML DB, is a rapid web'
               -- Message for field
     );

      /* Returns the generated PDF document.
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );

    /* Print it:

  owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob));
        owa_util.http_header_close;
        wpg_docload.download_file(l_blob);   */

    /* Store */
    insert into STORE_BLOB(BLOB_FILE,CREATED_DATE) VALUES (l_blob,sysdate);
  commit;
end;
end AcroformExamples;
