create or replace package DOCX_Examples is
--v4.9.2

procedure Init;
procedure SetPageOrientation;
procedure AddText;
procedure AddText_FontName;
procedure AddText_FontSize;
procedure AddText_Bold;
procedure AddText_Italic;
procedure AddText_Underline;
procedure AddText_Strike;
procedure AddText_Uppercase;
procedure AddText_SmallCaps;
procedure AddText_VertAlign;
procedure AddText_TextWidth;
procedure AddText_VertPosition;
procedure AddText_Spacing;
procedure AddText_Highlight;
procedure AddText_Fittext;
procedure AddText_Border;
procedure AddParagraph;
procedure AddParagraph_RightToLeft;
procedure AddParagraph_IgnoreSpaceBA;
procedure AddParagraph_Indentation;
procedure AddParagraph_Alignment;
procedure AddParagraph_PageBreakBefore;
procedure AddParagraph_Border;
procedure AddParagraph_Spacing;
procedure AddParagraph_VerticalAlignment;
procedure AddParagraph_WidowControl;
procedure AddList;
procedure AddDefaultHeader;
procedure AddEvenHeader;
procedure AddFirstHeader;
procedure AddDefaultFooter;
procedure AddEvenFooter;
procedure AddFirstFooter;
procedure AddTable;
procedure crCellBorder;
procedure AddInlineImage;
procedure AddImage;
procedure AddHyperlink;
procedure AddDateField;
procedure AddAuthorField;
procedure AddPageNumField;
procedure AddTableOfContent;
procedure SetBackground;
--
end DOCX_Examples;
/
create or replace package body docx_Examples is
--v4.9.2

l_sample_text varchar2(1000) := 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer ut placerat libero, eu lobortis ante. Suspendisse sagittis felis sem, a ullamcorper libero semper eget. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Nam semper mi orci, ultrices tincidunt magna ultricies quis. Ut sodales nisi ac tincidunt auctor. Mauris ac tellus massa. Fusce ornare porttitor orci, vitae ornare nulla congue eu. Quisque vehicula, nisl id vestibulum gravida, tellus metus sollicitudin tortor, dignissim semper tellus elit quis quam. Aenean placerat mi eu ligula blandit blandit. Curabitur ut volutpat sapien. Nullam sed nisl enim. Proin id cursus quam.';
l_sample_text_short varchar2(1000) := 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin et arcu et erat feugiat accumsan sit amet id risus. Suspendisse sit amet vulputate nisi. Nulla interdum ex vel diam efficitur, in semper leo mattis.';
l_sample_text_long varchar2(2000) := 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam convallis quis est et euismod. Donec posuere egestas quam. Pellentesque vitae diam ullamcorper, pulvinar est sit amet, luctus odio. Vivamus in suscipit velit. Phasellus imperdiet hendrerit nulla in vestibulum. Nulla consequat justo est. Integer nec orci ut urna vehicula pharetra nec id ligula. Nulla ut neque elit. Vestibulum interdum tincidunt fermentum. Pellentesque malesuada vel nunc eget tincidunt. Sed dignissim sed lorem in volutpat. Phasellus sagittis magna sit amet justo venenatis, at eleifend nunc sagittis. Donec placerat nunc in enim dignissim tempus non facilisis massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nam enim sapien, pretium id blandit in, adipiscing quis velit. In tincidunt sem neque, ac varius purus venenatis sed. Suspendisse porttitor nibh felis, id sodales ante fermentum ut. Morbi vestibulum neque vitae velit faucibus, et ultricies velit semper. Donec metus.';

procedure Init is
  l_docx blob;

  l_paragraph_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init();

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Init example'                                                       /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  /* Insert blob file into the store_blob table */
  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'Init.docx');

  commit;
end Init;

procedure SetPageOrientation is
  l_docx blob;

  l_paragraph_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init(
    p_orientation => ploffx_document_type.c_landscape                             /* Page orientation */
  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Page orientation landscape'                                         /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  /* Insert blob file into the store_blob table */
  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'SetPageOrientation.docx');

  commit;
end SetPageOrientation;

procedure AddText is
  l_docx blob;

  l_paragraph_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText'                                                            /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText.docx');
  commit;
end AddText;

procedure AddText_FontName is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_FontName'                                                   /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Font Name: Calibri(default)'                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Font Name: Verdana',                                                /* Text in the paragraph */
    p_FontName => ploffx_document_type.c_Verdana                                    /* Font Name */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Font Name: TimesNewRoman',                                          /* Text in the paragraph */
    p_FontName => ploffx_document_type.c_TimesNewRoman                              /* Font Name */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_FontName.docx');
  commit;
end AddText_FontName;

procedure AddText_FontSize is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_FontSize'                                                   /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Font size: 10(default)'                                             /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Font size: 24',                                                     /* Text in the paragraph */
    p_FontSize => 24                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_FontSize.docx');
  commit;
end AddText_FontSize;

procedure AddText_Bold is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Bold'                                                       /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Bold formatted text',                                               /* Text in the paragraph */
    p_bold => true
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

 insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Bold.docx');
 commit;
end AddText_Bold;

procedure AddText_Italic is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Italic'                                                     /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Italic formatted text',                                             /* Text in the paragraph */
    p_italic => true
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Italic.docx');
  commit;
end AddText_Italic;

procedure AddText_Underline is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_underline ploffx_document_type.CT_Underline;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create underline variable */
  l_underline := ploffx_document_cr.u(
                       p_val => ploffx_document_type.c_single                      /* Set underline style */
                       );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Underline'                                                  /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Underline example text',                                            /* Text in the paragraph */
    p_underline => l_underline
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Underline.docx');
  commit;
end AddText_Underline;

procedure AddText_Strike is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Strike'                                                     /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Strikeout example text',                                            /* Text in the paragraph */
    p_strikeout => true
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Strike.docx');
  commit;
end AddText_Strike;

procedure AddText_UpperCase is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_UpperCase'                                                  /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal Text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Uppercase text',                                                    /* Text in the paragraph */
    p_upperCase =>  true                                                           /* Uppercase */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_UpperCase.docx');
  commit;
end AddText_UpperCase;

procedure AddText_SmallCaps is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_LowerCase'                                                  /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal Text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph();                                     /* Create new paragraph */

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Smallcapital text',                                                 /* Text in the paragraph */
    p_smallCaps => true                                                            /* Smallcapital */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_SmallCaps.docx');
  commit;
end AddText_SmallCaps;

procedure AddText_VertAlign is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_VertAlign'                                                  /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Default Text'                                                       /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Vertical align: baseline',                                          /* Text in the paragraph */
    p_vertAlign => ploffx_document_type.c_baseline                             /* Vertical alignment */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Vertical align: superscript',                                       /* Text in the paragraph */
    p_vertAlign => ploffx_document_type.c_superscript                          /* Vertical alignment */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Vertical align: subscirpt',                                         /* Text in the paragraph */
    p_vertAlign => ploffx_document_type.c_subscript                            /* Vertical alignment */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_VertAlign.docx');
  commit;
end AddText_VertAlign;

procedure AddText_TextWidth is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_TextWidth'                                                  /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'COMPRESSED TEXT',                                                   /* Text in the paragraph */
    p_w => 50                                                                      /* Text width in percent */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'EXPANDED TEXT',                                                     /* Text in the paragraph */
    p_w => 200                                                                     /* Text width in percent */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_TextWidth.docx');
  commit;
end AddText_TextWidth;


procedure AddText_VertPosition is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_VertPosition'                                               /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'text above the baseline',                                           /* Text in the paragraph */
    p_vertPosition => 25                                                           /* Vertical position */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'text under the baseline',                                           /* Text in the paragraph */
    p_vertPosition => -25                                                          /* Vertical position */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_VertPosition.docx');
  commit;
end AddText_VertPosition;



procedure AddText_Spacing is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Spacing'                                                    /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Default spacing'                                                    /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Text spacing: 5',                                                   /* Text in the paragraph */
    p_spacing => 5                                                                 /* Text spacing in points */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Spacing.docx');
  commit;
end AddText_Spacing;

procedure AddText_Highlight is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Highlight'                                                  /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Highlighted text',                                                  /* Text in the paragraph */
    p_highlight => ploffx_document_type.c_red_                                      /* Highlight color */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Highlight.docx');
  commit;
end AddText_Highlight;

procedure AddText_Fittext is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Fittext'                                                    /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph();                                     /* Create new paragraph */

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Default text'                                                       /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '15 mm displayed',                                                   /* Text in the paragraph */
    p_fitText => 15                                                                /* Text width in units default 'mm' */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '30 mm displayed',                                                   /* Text in the paragraph */
    p_fitText => 30                                                                /* Text width in units default 'mm' */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Fittext.docx');
  commit;
end AddText_Fittext;

procedure AddText_Border is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_border ploffx_document_type.CT_Border;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddText_Border'                                                     /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Normal text'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Set up border properties */
  l_border := ploffx_docx.crBorder(
    p_color => ploffx_document_type.c_Gold,                                          /* Border color */
    p_width => 5,                                                                  /* Border size */
    p_spacing => 1,                                                                /* Border padding */
    p_style => ploffx_document_type.c_single                                    /* Border style */
    );


  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Bordered text',                                                     /* Text in the paragraph */
    p_border => l_border                                                           /* Add border to the text */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddText_Border.docx');
  commit;
end AddText_Border;

procedure AddParagraph is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Basic paragraph'                                                    /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph.docx');
  commit;
end AddParagraph;

procedure AddParagraph_RightToLeft is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_RightToLeft'                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragprah */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_bidi => true                                                 /* Set layout right to left */
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

  insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_RightToLeft.docx');
  commit;
end AddParagraph_RightToLeft;

procedure AddParagraph_IgnoreSpaceBA is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_IgnoreSpaceBA'                                         /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_contextualSpacing => false                                  /* Ignore space before and after paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Ignore space below and above (false): ' || l_sample_text,           /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_contextualSpacing => true                                   /* Ignore space before and after paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Ignore space below and above of this paragraph: ',                  /* Text in the paragraph */
    p_bold => true,                                                                /* Bold */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 12                                                               /* Font size */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 12                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_contextualSpacing => false                                   /* Ignore space before and after paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                               /* Paragraph ID */
    p_text => l_sample_text_long,                                                   /* Text in the paragraph */
    p_FontName => 'Arial',                                                          /* Font name */
    p_FontSize => 10                                                                /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_IgnoreSpaceBA.docx');
  commit;
end AddParagraph_IgnoreSpaceBA;

procedure AddParagraph_Indentation is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_indentation ploffx_document_type.CT_Ind;
begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_Indentation'                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* indentation */
  l_indentation := ploffx_docx.crIndentation(
                   p_left => 12.7                                                  /* Identation in units default 'mm' */
                   );

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_ind => l_indentation                                        /* Indentation */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Paragraph indentation example',                                     /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 16                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);
  /* indentation */
  l_indentation := ploffx_docx.crIndentation(
                   p_left => 25.4,                                                 /* Identation in units default 'mm' */
                   p_firstLine => 38.1
                   );

  /* Create paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_ind => l_indentation                                        /* Add indentation to paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Paragraph indentation example, left and first line: ',              /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 12                                                               /* Font size */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );


   /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* indentation */
  l_indentation := ploffx_docx.crIndentation(
                   p_left => 12.7,                                                 /* Identation in units default 'mm' */
                   p_firstLine => 25.4,
                   p_right => 12.7
                   );

  /* create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_ind => l_indentation                                        /* Add previously defined indentation to the paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Paragraph indentation example, left, right and first line: ',       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 12                                                               /* Font size */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_Indentation.docx');
  commit;
end AddParagraph_Indentation;

procedure AddParagraph_Alignment is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;



begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_Alignment'                                             /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_right                /* Set paragraph alignment */
                     );

    /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Paragraph alignment: right',                                        /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 16                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_right                /* Set paragraph alignment */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Set paragraph alignment */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_left                /* Set paragraph alignment */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Paragraph alignment: left',                                         /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 16                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_left                /* Set paragraph alignment */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Set paragraph alignment */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_center               /* Set paragraph alignment */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Paragraph alignment: center',                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 16                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_center                /* Set paragraph alignment */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                               /* Paragraph ID */
    p_text => l_sample_text,                                                        /* Text in the paragraph */
    p_FontName => 'Arial',                                                          /* Font name */
    p_FontSize => 10                                                                /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Set paragraph alignment */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_both
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                               /* Paragraph ID */
    p_text => 'Paragraph alignment: justify ',                                      /* Text in the paragraph */
    p_FontName => 'Arial',                                                          /* Font name */
    p_FontSize => 16                                                                /* Font size */
  );
  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_alignment => ploffx_document_type.c_both                  /* Set paragraph alignment */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                               /* Paragraph ID */
    p_text => l_sample_text,                                                        /* Text in the paragraph */
    p_FontName => 'Arial',                                                          /* Font name */
    p_FontSize => 10                                                                /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_Alignment.docx');
  commit;
end AddParagraph_Alignment;


procedure AddParagraph_PageBreakBefore is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_PageBreakBefore'                                       /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_pageBreakBefore => false                                    /* Page break before paragrah */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Next paragraph is on the other page.',                              /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 16                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_pageBreakBefore => true                                     /* Page break before paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_PageBreakBefore.docx');
  commit;
end AddParagraph_PageBreakBefore;

procedure AddParagraph_Border is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_border ploffx_document_type.CT_Border;
  l_pBorder ploffx_document_type.CT_PBdr;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_Border'                                                /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Setting border properties */
  l_border := ploffx_docx.crBorder(
    p_color => ploffx_document_type.c_Red,                                          /* Border color */
    p_style => ploffx_document_type.c_double                                            /* Border style */
  );

  /* Setting paragraph border */
  l_pBorder := ploffx_docx.crParagraphBorder(
    p_top => l_border,
    p_bottom => l_border,
    p_left => l_border,
    p_right => l_border
  );

  /* create bordered paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_border => l_pBorder                                         /* Add border properties to the paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Setting border properties */
  l_border := ploffx_docx.crBorder(
    p_color => ploffx_document_type.c_Sea_green,                                    /* Border color */
    p_style => ploffx_document_type.c_dashed                                            /* Border style */
  );

  /* Setting paragraph border */
  l_pBorder := ploffx_docx.crParagraphBorder(
    p_top => l_border,
    p_bottom => l_border,
    p_left => l_border,
    p_right => l_border
  );

  /* Create new paragraph  */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_border => l_pBorder                                         /* Add border properties to the paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Setting border properties */
  l_border := ploffx_docx.crBorder(
    p_color => ploffx_document_type.c_Brown,                                        /* Border color */
    p_style => ploffx_document_type.c_single                                            /* Border style */
  );

  /* Setting paragraph border */
  l_pBorder := ploffx_docx.crParagraphBorder(
    p_top => l_border,
    p_bottom => l_border,
    p_left => l_border,
    p_right => l_border
  );

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_border => l_pBorder                                         /* Add border properties to the paragraph */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Setting border properties */
  l_border := ploffx_docx.crBorder(
    p_color => ploffx_document_type.c_Violet,                                       /* Border color */
    p_style => ploffx_document_type.c_dotted                                            /* Border style */
  );

  /* Setting paragraph border */
  l_pBorder := ploffx_docx.crParagraphBorder(
    p_top => l_border,
    p_bottom => l_border,
    p_left => l_border,
    p_right => l_border
  );

  /* Crete new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_border => l_pBorder                                         /* Add border properties to the paragraph */
                     );
  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text,                                                       /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_Border.docx');
  commit;
end AddParagraph_Border;

procedure AddParagraph_Spacing is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_spacing ploffx_document_type.CT_Spacing;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;
  /* Create new paragrpah */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_Spacing'                                               /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create spacing */
  l_spacing := ploffx_docx.crSpacing(
                     p_before => 20,
                     p_after => 20
                     );

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_spacing => l_spacing                                        /* Set spacing before and after paragraph in units default mm */
                     );

  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Spacing above and below paragraph: 20 mm',                          /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 12                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create spacing */
  l_spacing := ploffx_docx.crSpacing(
                     p_linespace => 5
                     );

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_spacing => l_spacing                                        /* Set spacing between lines in lines */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Line spacing in this example text is 5 lines: ' || l_sample_text,   /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 12                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_Spacing.docx');
  commit;
end AddParagraph_Spacing;

procedure AddParagraph_VerticalAlignment is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_VerticalAlignment'                                     /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_textAlignment => ploffx_xlsx_styles.c_top                   /* Text vertical alignment */
                     );

    /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Vertical alignment top: This is text',                              /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'of vari',                                                           /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 20                                                               /* Font size */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'ous ',                                                              /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 16                                                               /* Font size */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'size. ',                                                            /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 12                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_textAlignment => ploffx_xlsx_styles.c_baseline              /* Vertical alignment */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
                      p_paragraph_id => l_paragraph_id,                            /* Paragraph ID */
                      p_text => 'Vertical alignment baseline: This is text',       /* Text in the paragraph */
                      p_FontName => 'Arial',                                       /* Font name */
                      p_FontSize => 10                                             /* Font size */
                      );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'of vari',                                                           /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 20                                                               /* Font size */
  );
  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                               /* Paragraph ID */
    p_text => 'ous ',                                                               /* Text in the paragraph */
    p_FontName => 'Arial',                                                          /* Font name */
    p_FontSize => 16                                                                /* Font size */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                               /* Paragraph ID */
    p_text => 'size. ',                                                             /* Text in the paragraph */
    p_FontName => 'Arial',                                                          /* Font name */
    p_FontSize => 12                                                                /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_VerticalAlignment.docx');
  commit;
end AddParagraph_VerticalAlignment;

procedure AddParagraph_WidowControl is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_spacing ploffx_document_type.CT_Spacing;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'AddParagraph_WidowControl'                                          /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* line spacing in lines */
  l_spacing := ploffx_docx.crSpacing(p_linespace => 5);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_spacing => l_spacing
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Allow First/Last Line to Display on a Separate Page',               /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 16                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragrpah */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_long,                                                  /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
      p_FontSize => 14                                                             /* Font size */
    );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragrpah */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_widowControl => false                                       /* Widow control (default: false) */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_long,                                                  /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 14                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph(
                     p_widowControl => true                                        /* Set widow control true */
                     );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_long,                                                  /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 14                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddParagraph_WidowControl.docx');
  commit;
end AddParagraph_WidowControl;

procedure AddList is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  l_text_id := ploffx_docx.addText(
               p_paragraph_id => l_paragraph_id,                                   /* Paragraph ID */
               p_text => 'AddList'                                                 /* Text in the paragraph */
               );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'First list'                                                         /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for first identations first element: ',                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 1                                                     /* List level(Identation levels) */
                  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for first identations second element: ',                /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 1                                                     /* List level */
                  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for first identations third element: ',                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 1                                                     /* List level */
                  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for first identations fourth element: ',                /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 1                                                     /* List level */
                  );

  /* INSERT SECOND LIST TO THE SAME DOCUMENT */

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph( );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Second list'                                                        /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for first identations first element: ',                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 1,                                                    /* List level */
                  p_numId => 2                                                     /* List ID */
                  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for first identations second element: ',                /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 1,                                                    /* List level */
                  p_numId => 2                                                     /* List ID */
                  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for second identations first element: ',                /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 2,                                                    /* List level */
                  p_numId => 2                                                     /* List ID */
                  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for second identations second element: ',               /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */                                            -- font thickness
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 2,                                                    /* List level */
                  p_numId => 2                                                     /* List ID */
                  );

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Sample text for third identations first element: ',                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10,                                                              /* Font size */
    p_bold => true                                                                 /* Font thickness */
  );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => l_sample_text_short,                                                 /* Text in the paragraph */
    p_FontName => 'Arial',                                                         /* Font name */
    p_FontSize => 10                                                               /* Font size */                                             -- font thickness
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add paragraph to list */
  ploffx_docx.setListLevel(
                  p_paragraph_id => l_paragraph_id,                                /* Paragraph ID */
                  p_level => 3,                                                    /* List level */
                  p_numId => 2                                                     /* List ID */
                  );

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddList.docx');
  commit;
end AddList;

procedure AddDefaultHeader is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;
begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Add default header'                                                 /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '2nd page'                                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '3rd page'                                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* HEADER */

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Default header',                                                    /* Text in the paragraph */
    p_FontName => 'Arial',
    p_FontSize => 14
  );

   /* Add paragraph to the document header */
  ploffx_docx.AddHeader(p_paragraph_id => l_paragraph_id);
  
   ploffx_docx.setTitlePg();

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddDefaultHeader.docx');
  commit;
end AddDefaultHeader;

procedure AddEvenHeader is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;
begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Add even header'                                                    /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '2nd page'                                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '3rd page'                                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* HEADER */

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,
    p_text => 'Even header',
    p_FontName => 'Arial',
    p_FontSize => 14
  );

   /* Add paragraph to the document header */
  ploffx_docx.AddHeader(p_paragraph_id => l_paragraph_id, p_type => ploffx_document_type.c_even);
  
   ploffx_docx.setTitlePg();

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddEvenHeader.docx');
  commit;
end AddEvenHeader;

procedure AddFirstHeader is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;
begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();
                                                                                   --a
  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => 'Add first header'                                                   /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '2nd page'                                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                                              /* Paragraph ID */
    p_text => '3rd page'                                                           /* Text in the paragraph */
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* HEADER */

  /* Create new paragraph */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,
    p_text => 'First header',
    p_FontName => 'Arial',
    p_FontSize => 14
  );

   /* Add paragraph to the document header */
  ploffx_docx.AddHeader(p_paragraph_id => l_paragraph_id, p_type => ploffx_document_type.c_first);
  
   ploffx_docx.setTitlePg();

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddFirstHeader.docx');
  commit;
end AddFirstHeader;

procedure AddDefaultFooter is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;
begin
  /* Initializes generator program variables */
  ploffx_docx.init;

  /* Create new paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();          --

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => 'Add default footer'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => '2nd page'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => '3rd page'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Footer */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,
    p_text => 'Default footer',
    p_FontName => 'Arial',
    p_FontSize => 14
  );

   /* Add paragraph to the document footer */
  ploffx_docx.AddFooter(p_paragraph_id => l_paragraph_id);
  
   ploffx_docx.setTitlePg();

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddDefaultFooter.docx');
  commit;
end AddDefaultFooter;

procedure AddEvenFooter is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;
begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => 'Add even footer'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => '2nd page'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => '3rd page'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Footer */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,
    p_text => 'Even footer',
    p_FontName => 'Arial',
    p_FontSize => 14
  );

   /* Add paragraph to the document footer */
  ploffx_docx.AddFooter(p_paragraph_id => l_paragraph_id, p_type => ploffx_document_type.c_even);
  
   ploffx_docx.setTitlePg();

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddEvenFooter.docx');
  commit;
end AddEvenFooter;

procedure AddFirstFooter is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;
begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => 'Add first footer'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => '2nd page'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph(p_pageBreakBefore => true);          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => '3rd page'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Footer */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,
    p_text => 'First footer',
    p_FontName => 'Arial',
    p_FontSize => 14
  );

   /* Add paragraph to the document footer */
  ploffx_docx.AddFooter(p_paragraph_id => l_paragraph_id, p_type => ploffx_document_type.c_first);
  
   ploffx_docx.setTitlePg();

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddFirstFooter.docx');
  commit;
end AddFirstFooter;

procedure AddTable is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_table pls_integer;
  l_tab_id pls_integer;

  l_row pls_integer;
  l_cell pls_integer;

  l_p_table pls_integer;

  l_table2 pls_integer;
  l_table_c pls_integer;

begin
  ploffx_docx.init(p_unit => 'pt')
  ;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'AddTable'                     -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  l_paragraph_id :=  ploffx_docx.crParagraph();            -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,    -- Paragraph ID
    p_text => 'Generated table',         -- text in the paragraph
    p_FontName => 'Arial',               -- font name
    p_FontSize => 14                     -- font size
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create table */
  l_table2 := ploffx_docx.crTable(
                 --p_width => 200,                  -- preferred table width in mm
                 p_alignment => 'center'         -- table alignment
                 );


  for i in 1..5 loop

  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table2,         -- table ID
                 p_alignment => 'center',        -- row alignment
                 p_height => 50                  -- row height
                 );

    for j in 1..5 loop

      /* Add table cell to an existing row */
      l_cell := ploffx_docx.AddCell(
                 p_table_id => l_table2,   -- table ID
                 p_row_id => l_row,        -- row ID
                 p_noWrap => false,        -- wrapping (true or false
                 p_width => 80
                 );
      if j mod 2 = 0 then
      l_paragraph_id :=  ploffx_docx.crParagraph(p_alignment => ploffx_document_type.c_both);    -- Create new paragraph
      else
      l_paragraph_id :=  ploffx_docx.crParagraph();
      end if;
      /* Add text to an existing paragraph */
      ploffx_docx.addText(
        p_paragraph_id => l_paragraph_id,   -- paragraph ID
        p_text => to_char(i*j),             -- text in the paragraph
        p_FontName => 'Arial',              -- font name
        p_FontSize => 12                    -- font size
      );

      /* Add paragraph to an existing table cell */
      l_p_table := ploffx_docx.TableaddParagraph(
                 p_table_id => l_table2,                  -- table ID
                 p_row_id => l_row,                       -- row ID
                 p_cell_id => l_cell,                     -- cell ID
                 p_paragraph_id => l_paragraph_id         -- paragraph ID
                 );
    end loop;
  end loop;

  /* Set table border properties */
  ploffx_docx.setTableBorders(
                 p_table_id => l_table2,                                  -- table ID
                 p_style => ploffx_document_type.c_single,                     -- border style (solid, dotted, sahed...etc)
                 p_width => 0.5,                                          -- border width
                 p_color => ploffx_document_type.c_Green                   -- border color
                 );

  /* Add table to the document */
  l_tab_id := ploffx_docx.addTable(
                 p_table_id => l_table2                   -- table ID
                 );


  l_paragraph_id :=  ploffx_docx.crParagraph();  -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,    -- Paragraph ID
    p_text => 'Complex table',           -- text in the paragraph
    p_FontName => 'Arial',               -- font name
    p_FontSize => 14                     -- font size
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Add #2 table example to the document */

  /* Create table */
  l_table_c := ploffx_docx.crTable(
                 p_width => 500,                  -- table width in mm
                 p_alignment => 'center'          -- table alignment
                 );


  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table_c,         -- table ID
                 p_alignment => 'center'          -- row alignment
                 );


  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 1',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 2',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false         -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 3',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false         -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 4',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false         -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 5',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table_c,         -- table ID
                 p_alignment => 'center'          -- row alignment
                 );


  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 1',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false         -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 2',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 3',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 4',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 5',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table_c,         -- table ID
                 p_alignment => 'center'          -- row alignment
                 );


  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 6',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
    );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false         -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 7',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 8',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 9',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 10',                -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );


  /* Set table border properties */
  ploffx_docx.setTableBorders(
                 p_table_id => l_table_c,                  -- table ID
                 p_style => 'single',                      -- border style (solid, dotted, dashed...etc)
                 p_width => 1,                             -- border width
                 p_color => ploffx_document_type.c_red      -- border color
                 );

  /* Add table to the document */
  l_tab_id := ploffx_docx.addTable(
                 p_table_id => l_table_c                   -- table ID
                 );

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddTable.docx');
  commit;
end AddTable;

procedure crCellBorder is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_table pls_integer;
  l_tab_id pls_integer;

  l_row pls_integer;
  l_cell pls_integer;

  l_p_table pls_integer;

  l_table2 pls_integer;
  l_table_c pls_integer;

  l_sideBorder ploffx_document_type.CT_Border;
  l_cellBorder ploffx_document_type.CT_TcBorders;
begin
  ploffx_docx.init(p_unit => 'pt');            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'Create cell border'                     -- Text in the paragraph
  );

  /* Define a side border */
  l_sideBorder := ploffx_docx.crBorder(p_style => ploffx_document_type.c_single, -- type of the line
                                       p_width => 1 -- border width
                                       );
  /* Create cell border */
  l_cellBorder := ploffx_docx.crCellBorder(p_top => l_sideBorder, -- top border
                                           p_bottom => l_sideBorder, -- bottom border
                                           p_left => l_sideBorder, -- left border
                                           p_right => l_sideBorder -- right border
                                          );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  l_paragraph_id :=  ploffx_docx.crParagraph();            -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,    -- Paragraph ID
    p_text => 'Generated table',         -- text in the paragraph
    p_FontName => 'Arial',               -- font name
    p_FontSize => 14                     -- font size
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create table */
  l_table2 := ploffx_docx.crTable(
                 --p_width => 200,                  -- preferred table width in mm
                 p_alignment => 'center'         -- table alignment
                 );

  for i in 1..5 loop

  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table2,         -- table ID
                 p_alignment => 'center',        -- row alignment
                 p_height => 50                  -- row height
                 );

    for j in 1..5 loop

      if j mod 2 = 0 and i mod 2 > 0 then
        /* Add table cell to an existing row */
        l_cell := ploffx_docx.AddCell(
                   p_table_id => l_table2,   -- table ID
                   p_row_id => l_row,        -- row ID
                   p_noWrap => false,        -- wrapping (true or false
                   p_width => 80,            -- cell width
                   p_cellBorder => l_cellBorder              -- cell border
                   );
      else
        /* Add table cell to an existing row */
        l_cell := ploffx_docx.AddCell(
                   p_table_id => l_table2,   -- table ID
                   p_row_id => l_row,        -- row ID
                   p_noWrap => false,        -- wrapping (true or false
                   p_width => 80
                   );
      end if;




      if j mod 2 = 0 then
      l_paragraph_id :=  ploffx_docx.crParagraph(p_alignment => ploffx_document_type.c_both);    -- Create new paragraph
      else
      l_paragraph_id :=  ploffx_docx.crParagraph();
      end if;
      /* Add text to an existing paragraph */
      ploffx_docx.addText(
        p_paragraph_id => l_paragraph_id,   -- paragraph ID
        p_text => to_char(i*j),             -- text in the paragraph
        p_FontName => 'Arial',              -- font name
        p_FontSize => 12                    -- font size
      );

      /* Add paragraph to an existing table cell */
      l_p_table := ploffx_docx.TableaddParagraph(
                 p_table_id => l_table2,                  -- table ID
                 p_row_id => l_row,                       -- row ID
                 p_cell_id => l_cell,                     -- cell ID
                 p_paragraph_id => l_paragraph_id         -- paragraph ID
                 );
    end loop;
  end loop;


  /* Add table to the document */
  l_tab_id := ploffx_docx.addTable(
                 p_table_id => l_table2                   -- table ID
                 );


  l_paragraph_id :=  ploffx_docx.crParagraph();  -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,    -- Paragraph ID
    p_text => 'Complex table',           -- text in the paragraph
    p_FontName => 'Arial',               -- font name
    p_FontSize => 14                     -- font size
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Add #2 table example to the document */

  /* Create table */
  l_table_c := ploffx_docx.crTable(
                 p_width => 500,                  -- table width in mm
                 p_alignment => 'center'          -- table alignment
                 );

  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table_c,         -- table ID
                 p_alignment => 'center'          -- row alignment
                 );


  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false,          -- wrapping (true or false)
             p_cellBorder => l_cellBorder -- cell border
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 1',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false,          -- wrapping (true or false)
             p_cellBorder => l_cellBorder -- cell border
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 2',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false,         -- wrapping (true or false)
             p_cellBorder => l_cellBorder -- cell border
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 3',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false,         -- wrapping (true or false)
             p_cellBorder => l_cellBorder -- cell border
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 4',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false,         -- wrapping (true or false)
             p_cellBorder => l_cellBorder -- cell border
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Header 5',               -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table_c,         -- table ID
                 p_alignment => 'center'          -- row alignment
                 );


  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 1',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false         -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 2',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 3',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 4',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 5',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add row to the table */
  l_row := ploffx_docx.AddRow(
                 p_table_id => l_table_c,         -- table ID
                 p_alignment => 'center'          -- row alignment
                 );


  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 6',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
    );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,  -- table ID
             p_row_id => l_row,        -- row ID
             p_noWrap => false         -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 7',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 8',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 9',                 -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );

  /* Add table cell to an existing row */
  l_cell := ploffx_docx.AddCell(
             p_table_id => l_table_c,   -- table ID
             p_row_id => l_row,         -- row ID
             p_noWrap => false          -- wrapping (true or false)
             );

  l_paragraph_id :=  ploffx_docx.crParagraph();    -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,   -- paragraph ID
    p_text => 'Data 10',                -- text in the paragraph
    p_FontName => 'Arial',              -- font name
    p_FontSize => 12                    -- font size
  );

  /* Add paragraph to an existing table cell */
  l_p_table := ploffx_docx.TableaddParagraph(
             p_table_id => l_table_c,                 -- table ID
             p_row_id => l_row,                       -- row ID
             p_cell_id => l_cell,                     -- cell ID
             p_paragraph_id => l_paragraph_id         -- paragraph ID
             );


  /* Add table to the document */
  l_tab_id := ploffx_docx.addTable(
                 p_table_id => l_table_c                   -- table ID
                 );

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'crCellBorder.docx');
  commit;
end crCellBorder;



procedure AddInlineImage is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_file blob;

  l_image pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'AddInlineImage',                     -- Text in the paragraph
    p_FontSize=> 16                                 -- Font size
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* get the image from a database table */
  select image_file
  into l_file
  from image_blob where id = 1;

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => l_sample_text,                 -- Text in the paragraph
    p_FontSize => 14                         -- Font size
  );

  /* Add image */
  l_image := ploffx_docx.addInlineImage(
            p_paragraph_id => l_paragraph_id,    -- Paragraph ID
            p_name => 'koala.jpg',                -- file name
            p_file => l_file,                    -- image data blob
            p_width => 46,                      -- with
            p_height => 26                      -- height
            );

  /* Add text to paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => l_sample_text,                 -- Text in the paragraph
    p_FontSize => 14                         -- Font size
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddInlineImage.docx');
  commit;
end AddInlineImage;

procedure AddImage is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_file blob;

  l_image pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'AddImage'                     -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* get the image from a database table */
  select image_file
  into l_file
  from image_blob where id = 1;

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => l_sample_text                  -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Add inline image */
  l_image := ploffx_docx.addImage( p_paragraph_id => l_paragraph_id,
                  p_name => 'koala.jpg',
                  p_file => l_file,
                  p_width =>46,
                  p_height =>26,
                  p_x =>20,
                  p_y =>10,
                  p_textWrap => 'wrapSquare',
                  p_behindDoc => 'false'
                  );

  /* Add text to the paragraph*/
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => l_sample_text                  -- Text in the paragraph
  );

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddImage.docx');
  commit;
end AddImage;

procedure AddHyperlink is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_hyperlink pls_integer;

  l_file blob;

  l_image pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'AddHyperlink'                 -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'Hyperlink example: '          -- Text in the paragraph
  );

  l_hyperlink := ploffx_docx.addHyperLink(
             p_paragraph_id => l_paragraph_id,
             p_text => 'www.plpdf.com',
             p_url => 'http://www.plpdf.com',
             p_bold => true,
             p_FontSize => 16
             );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddHyperlink.docx');
  commit;
end AddHyperlink;

procedure AddDateField is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_date_id pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'AddDate'                      -- Text in the paragraph
  );

  -- #1
  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  l_date_id := ploffx_docx.addDateField(
                 p_paragraph_id => l_paragraph_id
                 );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  -- #2
  /* Add paragraph to the document */
  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  l_date_id := ploffx_docx.addDateField(
                 p_paragraph_id => l_paragraph_id,
                 p_format => ploffx_document_type.c_ddddyyMMMMd
                 );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddDateField.docx');
  commit;
end AddDateField;

procedure AddAuthorField is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_author_id pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => 'AddInsertAuthor'                         -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add author field to the document */
  l_author_id := ploffx_docx.addAuthorField(
              p_paragraph_id => l_paragraph_id,         -- paragraph ID
              p_format => ploffx_document_type.c_lower
              );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddAuthorField.docx');
  commit;
end AddAuthorField;

procedure AddPageNumField is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_header_id pls_integer;
  l_footer_id pls_integer;

  l_pageNum_id pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_text => 'AddPageNum'                   -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* HEADER */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                -- Paragraph ID
    p_text => 'Page number in the header: ',         -- Text in the paragraph
    p_FontName => 'Arial',                           -- Font name
    p_FontSize => 14                                 -- Font size
  );

  /* Add page number */
  l_pageNum_id := ploffx_docx.addPageNumField(
                      p_paragraph_id => l_paragraph_id,             -- paragraph ID
                      p_format => ploffx_document_type.c_ordinal          -- page number format
                      );

  ploffx_docx.AddHeader(p_paragraph_id => l_paragraph_id);

 /* FOOTER */
  l_paragraph_id :=  ploffx_docx.crParagraph();

  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,
    p_text => 'Page number in the footer: ',
    p_FontName => 'Arial',
    p_FontSize => 14
  );

  /* Add page number */
  l_pageNum_id := ploffx_docx.addPageNumField(
                      p_paragraph_id => l_paragraph_id,                     -- paragraph ID
                      p_format => ploffx_document_type.c_upperRoman               -- page number format
                      );

  ploffx_docx.AddFooter(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddPageNumField.docx');
  commit;
end AddPageNumField;

procedure AddTableOfContent is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

  l_toc_id pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                   -- Paragraph ID
    p_text => 'AddTableOfContents'                      -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  l_paragraph_id := ploffx_docx.crParagraph(
                    p_alignment => 'center'      -- set alignment to center
                    );                           -- Create new paragraph

  /* add tab stop */
  ploffx_docx.addTabStop(
               p_paragraph_id => l_paragraph_id, -- paragraph ID
               p_val => 'start',                  -- tab position
               p_pos => 2
               );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 14,                        -- Font size
    p_italic => true,                        -- text format to italic
    p_text => 'Table of Contents'            -- Text in the paragraph
  );
  /* Add table of content to de document */
  l_toc_id := ploffx_docx.addTableOfContent(
           p_paragraph_id => l_paragraph_id
           );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);



  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD1',           -- style name
                    p_pageBreakBefore => true    -- add page break before paragraph
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,              -- Paragraph ID
    p_FontSize => 14,                              -- Font size
    p_color => ploffx_document_type.c_Medium_blue,  -- Font color
    p_text => 'Main Title 1'                       -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD2'           -- style name
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 13,                        -- Font size
    p_color => ploffx_document_type.c_Green,  -- Font color
    p_text => 'Paragraph title 1'            -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 10,                        -- Font size
    p_text => l_sample_text                  -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD1',           -- style name
                    p_pageBreakBefore => true    -- add page break before paragraph
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,             -- Paragraph ID
    p_FontSize => 14,                             -- Font size
    p_color => ploffx_document_type.c_Medium_blue, -- Font color
    p_text => 'Main Title 2'                      -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD2'           -- style name
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 13,                        -- Font size
    p_color => ploffx_document_type.c_green,  -- Font color
    p_text => 'Paragraph title 2'            -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 10,                        -- Font size
    p_text => l_sample_text                  -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD2'           -- style name
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 13,                        -- Font size
    p_color => ploffx_document_type.c_green,  -- Font color
    p_text => 'Paragraph title 3'            -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 10,                        -- Font size
    p_text => l_sample_text                  -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD2'                   -- style name
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 13,                        -- Font size
    p_color => ploffx_document_type.c_green,  -- Font color
    p_text => 'Paragraph title 4'            -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 10,                        -- Font size
    p_text => l_sample_text                  -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /**/
  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD1',           -- style name
                    p_pageBreakBefore => true    -- add page break before paragraph
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,                     -- Paragraph ID
    p_FontSize => 14,                                     -- Font size
    p_color => ploffx_document_type.c_Medium_blue,         -- Font color
    p_text => 'Main Title 3'                              -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph(
                    p_pStyle => 'HD2'           -- style name
                    );

  ploffx_docx.addTabStop(
                    p_paragraph_id => l_paragraph_id,   -- paragraph ID
                    p_val => 'start',                   -- type of tab stop
                    p_pos => 2                          -- position
                    );

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 13,                        -- Font size
    p_color => ploffx_document_type.c_green,  -- Font color
    p_text => 'Paragraph title 5'            -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Create paragraph */
  l_paragraph_id := ploffx_docx.crParagraph();

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,        -- Paragraph ID
    p_FontSize => 10,                        -- Font size
    p_text => l_sample_text                  -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);

  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);


   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'AddTableOfContent.docx');
  commit;
end AddTableOfContent;

procedure SetBackground is
  l_docx blob;

  l_paragraph_id pls_integer;
  l_text_id pls_integer;

begin
  ploffx_docx.init;            -- Initializes generator program variables

  l_paragraph_id := ploffx_docx.crParagraph();          -- Create new paragraph

  /* Add text to an existing paragraph */
  ploffx_docx.addText(
    p_paragraph_id => l_paragraph_id,         -- Paragraph ID
    p_text => 'SetBackground'                 -- Text in the paragraph
  );

  /* Add paragraph to the document */
  ploffx_docx.addParagraph(p_paragraph_id => l_paragraph_id);


  /* Set document background color */
  ploffx_docx.SetBackground(
                  p_backcolor => ploffx_document_type.c_Green        -- color
                  );


  /* Returns the generated document. The document is closed and then returned. */
  ploffx_docx.getDoc(p_blob_file => l_docx);

   insert into store_blob(blob_file,created_date,filename) values (l_docx,sysdate,'SetBackground.docx');
  commit;
end SetBackground;
--
end docx_Examples;
/
