create or replace package x_simpleTableHeader is
   -- Required procedure
  procedure genPDF;
 
  -- Required variable
  v_pdf blob;
   
  
    CURSOR C_ALL_OBJECTS is 
  SELECT o.OBJECT_ID, o.OBJECT_NAME, o.CREATED
  FROM ALL_OBJECTS o
  WHERE ROWNUM <= 100;


  
end x_simpleTableHeader;
/
create or replace package body x_simpleTableHeader is
/* 2016-JAN-26 08:58 */
/* PL/PDF REPORTER 3.7.0 */
/* THIS IS GENERATED CODE. DO NOT MODIFY DIRECTLY! PLEASE CHANGE THE TEMPLATE. */
v_format1 plpdf_type.t_pageformat;
l_box1 plpdf3.t_box;
v_paragraph1 plpdf3.t_paragraph;
l_text_idx1 pls_integer;
l_tblGrid1 plpdf3.t_TableGrid := plpdf3.v_TableGrid_empty;
l_table1 plpdf3.t_Table;
l_row1 plpdf3.t_TableRow;
l_color1 plpdf_type.t_color;
l_border_side1 plpdf3.t_border1;
l_border2 plpdf3.t_Border;
l_padding1 plpdf3.t_Padding;
l_box2 plpdf3.t_box;
l_cell1 plpdf3.t_TableCell;
l_box3 plpdf3.t_box;
v_paragraph2 plpdf3.t_paragraph;
l_text_idx2 pls_integer;
l_paragraph3 pls_integer;
l_cell2 pls_integer;
l_cell3 plpdf3.t_TableCell;
l_box4 plpdf3.t_box;
v_paragraph4 plpdf3.t_paragraph;
l_paragraph5 pls_integer;
l_cell4 pls_integer;
l_cell5 plpdf3.t_TableCell;
l_box5 plpdf3.t_box;
v_paragraph6 plpdf3.t_paragraph;
l_paragraph7 pls_integer;
l_cell6 pls_integer;
l_row2 pls_integer;
l_row3 plpdf3.t_TableRow;
l_cell7 plpdf3.t_TableCell;
l_box6 plpdf3.t_box;
v_paragraph8 plpdf3.t_paragraph;
l_text_idx3 pls_integer;
l_paragraph9 pls_integer;
l_cell8 pls_integer;
l_cell9 plpdf3.t_TableCell;
l_box7 plpdf3.t_box;
v_paragraph10 plpdf3.t_paragraph;
l_text_idx4 pls_integer;
l_paragraph11 pls_integer;
l_cell10 pls_integer;
l_cell11 plpdf3.t_TableCell;
l_box8 plpdf3.t_box;
v_paragraph12 plpdf3.t_paragraph;
l_text_idx5 pls_integer;
l_paragraph13 pls_integer;
l_cell12 pls_integer;
l_row_idx4 pls_integer;
l_parsedTable2 plpdf3.t_parsed_table;
l_row5 plpdf3.t_TableRow;
l_cell13 plpdf3.t_TableCell;
l_box9 plpdf3.t_box;
v_paragraph14 plpdf3.t_paragraph;
l_text_idx6 pls_integer;
l_paragraph15 pls_integer;
l_cell14 pls_integer;
l_cell15 plpdf3.t_TableCell;
l_box10 plpdf3.t_box;
v_paragraph16 plpdf3.t_paragraph;
l_text_idx7 pls_integer;
l_paragraph17 pls_integer;
l_cell16 pls_integer;
l_cell17 plpdf3.t_TableCell;
l_box11 plpdf3.t_box;
v_paragraph18 plpdf3.t_paragraph;
l_text_idx8 pls_integer;
l_paragraph19 pls_integer;
l_cell18 pls_integer;
l_box12 plpdf3.t_box;
v_paragraph20 plpdf3.t_paragraph;
l_link1 pls_integer;
/* BODYSECTION */
procedure genPDF is
 begin 
v_format1 := plpdf_util.crFormat( p_w => 595.300, p_h => 841.900);
plpdf.init1( p_orientation => 'P', p_unit => 'pt', p_format => v_format1);
plpdf.setTopMargin( p_margin => 35.400);
plpdf.setLeftMargin( p_margin => 70.850);
plpdf.setRightMargin( p_margin => 70.850);
plpdf.NewPage( );
/* PARAGRAPH */
l_box1 := plpdf3.crBox( );
v_paragraph1 := plpdf3.crParagraph( p_box => l_box1);
/* ADD TEXT */
l_text_idx1 := plpdf3.addText( p_paragraph => v_paragraph1, p_text => 'Simple table header example');
plpdf3.printParagraph( p_paragraph => v_paragraph1);
/* TABLE */
l_tblGrid1  := plpdf3.v_TableGrid_empty;
plpdf3.AddGridCol( p_tableGrid => l_tblGrid1, p_width => 151);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid1, p_width => 151.050);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid1, p_width => 151.050);
l_table1 := plpdf3.crTable( p_width => 0, p_grid => l_tblGrid1);
/* SDT CONTROL: GFOOTER -> LAST */
/* TABLE ROW */
l_row1 := plpdf3.crRow();
/* TABLE CELL */
l_color1 := plpdf_util.crColor( p_r => 0, p_g => 0, p_b => 0);
l_border_side1 := plpdf3.crBorder1( p_color => l_color1, p_width => 1, p_style => 'single');
l_border2 := plpdf3.crBorder( p_top => l_border_side1, p_bottom => l_border_side1, p_left => l_border_side1, p_right => l_border_side1);
l_padding1 := plpdf3.crPadding( p_top => 0, p_bottom => 0, p_left => 0, p_right => 0);
l_box2 := plpdf3.crBox( p_border => l_border2, p_padding => l_padding1);
l_cell1 := plpdf3.crCell(p_box => l_box2, p_width => 151);
/* PARAGRAPH */
l_box3 := plpdf3.crBox( );
v_paragraph2 := plpdf3.crParagraph( p_box => l_box3);
/* ADD TEXT */
l_text_idx2 := plpdf3.addText( p_paragraph => v_paragraph2, p_text => 'Footer line');
l_paragraph3 := plpdf3.addParagraph(p_TableCell => l_cell1, p_Paragraph => v_paragraph2);
l_cell2 := plpdf3.addCell(p_TableRow => l_row1, p_TableCell => l_cell1);
/* TABLE CELL */
l_cell3 := plpdf3.crCell(p_box => l_box2, p_width => 151.050);
/* PARAGRAPH */
l_box4 := plpdf3.crBox( );
v_paragraph4 := plpdf3.crParagraph( p_box => l_box4);
l_paragraph5 := plpdf3.addParagraph(p_TableCell => l_cell3, p_Paragraph => v_paragraph4);
l_cell4 := plpdf3.addCell(p_TableRow => l_row1, p_TableCell => l_cell3);
/* TABLE CELL */
l_cell5 := plpdf3.crCell(p_box => l_box2, p_width => 151.050);
/* PARAGRAPH */
l_box5 := plpdf3.crBox( );
v_paragraph6 := plpdf3.crParagraph( p_box => l_box5);
l_paragraph7 := plpdf3.addParagraph(p_TableCell => l_cell5, p_Paragraph => v_paragraph6);
l_cell6 := plpdf3.addCell(p_TableRow => l_row1, p_TableCell => l_cell5);
/* TABLE FOOTER ROW */
l_row2 := plpdf3.addFooterRow(p_table => l_table1, p_TableRow => l_row1, p_print => 'last');
/* TABLE ROW */
l_row3 := plpdf3.crRow();
/* TABLE CELL */
l_cell7 := plpdf3.crCell(p_box => l_box2, p_width => 151);
/* PARAGRAPH */
l_box6 := plpdf3.crBox( );
v_paragraph8 := plpdf3.crParagraph( p_box => l_box6);
/* ADD TEXT */
l_text_idx3 := plpdf3.addText( p_paragraph => v_paragraph8, p_text => 'Object ID');
l_paragraph9 := plpdf3.addParagraph(p_TableCell => l_cell7, p_Paragraph => v_paragraph8);
l_cell8 := plpdf3.addCell(p_TableRow => l_row3, p_TableCell => l_cell7);
/* TABLE CELL */
l_cell9 := plpdf3.crCell(p_box => l_box2, p_width => 151.050);
/* PARAGRAPH */
l_box7 := plpdf3.crBox( );
v_paragraph10 := plpdf3.crParagraph( p_box => l_box7);
/* ADD TEXT */
l_text_idx4 := plpdf3.addText( p_paragraph => v_paragraph10, p_text => 'Object name');
l_paragraph11 := plpdf3.addParagraph(p_TableCell => l_cell9, p_Paragraph => v_paragraph10);
l_cell10 := plpdf3.addCell(p_TableRow => l_row3, p_TableCell => l_cell9);
/* TABLE CELL */
l_cell11 := plpdf3.crCell(p_box => l_box2, p_width => 151.050);
/* PARAGRAPH */
l_box8 := plpdf3.crBox( );
v_paragraph12 := plpdf3.crParagraph( p_box => l_box8);
/* ADD TEXT */
l_text_idx5 := plpdf3.addText( p_paragraph => v_paragraph12, p_text => 'Created');
l_paragraph13 := plpdf3.addParagraph(p_TableCell => l_cell11, p_Paragraph => v_paragraph12);
l_cell12 := plpdf3.addCell(p_TableRow => l_row3, p_TableCell => l_cell11);
/* TABLE HEADER ROW */
l_row_idx4 := plpdf3.addHeaderRow(p_table => l_table1, p_TableRow => l_row3);
l_parsedTable2 := plpdf3.InitParseTable( p_table => l_table1);
plpdf3.startTable( p_parsed_table => l_parsedTable2);
/* SDT CONTROL: GROUP -> F_OBJECT IN C_ALL_OBJECTS */
for F_OBJECT in C_ALL_OBJECTS loop

/* TABLE ROW */
l_row5 := plpdf3.crRow();
/* TABLE CELL */
l_cell13 := plpdf3.crCell(p_box => l_box2, p_width => 151);
/* SDT CONTROL: COLUMN -> F_OBJECT.OBJECT_ID */
/* PARAGRAPH */
l_box9 := plpdf3.crBox( );
v_paragraph14 := plpdf3.crParagraph( p_box => l_box9);
/* ADD TEXT */
l_text_idx6 := plpdf3.addText( p_paragraph => v_paragraph14, p_text => F_OBJECT.OBJECT_ID);
l_paragraph15 := plpdf3.addParagraph(p_TableCell => l_cell13, p_Paragraph => v_paragraph14);
l_cell14 := plpdf3.addCell(p_TableRow => l_row5, p_TableCell => l_cell13);
/* TABLE CELL */
l_cell15 := plpdf3.crCell(p_box => l_box2, p_width => 151.050);
/* SDT CONTROL: COLUMN -> F_OBJECT.OBJECT_NAME */
/* PARAGRAPH */
l_box10 := plpdf3.crBox( );
v_paragraph16 := plpdf3.crParagraph( p_box => l_box10);
/* ADD TEXT */
l_text_idx7 := plpdf3.addText( p_paragraph => v_paragraph16, p_text => F_OBJECT.OBJECT_NAME);
l_paragraph17 := plpdf3.addParagraph(p_TableCell => l_cell15, p_Paragraph => v_paragraph16);
l_cell16 := plpdf3.addCell(p_TableRow => l_row5, p_TableCell => l_cell15);
/* TABLE CELL */
l_cell17 := plpdf3.crCell(p_box => l_box2, p_width => 151.050);
/* SDT CONTROL: COLUMN -> F_OBJECT.CREATED */
/* PARAGRAPH */
l_box11 := plpdf3.crBox( );
v_paragraph18 := plpdf3.crParagraph( p_box => l_box11);
/* ADD TEXT */
l_text_idx8 := plpdf3.addText( p_paragraph => v_paragraph18, p_text => F_OBJECT.CREATED);
l_paragraph19 := plpdf3.addParagraph(p_TableCell => l_cell17, p_Paragraph => v_paragraph18);
l_cell18 := plpdf3.addCell(p_TableRow => l_row5, p_TableCell => l_cell17);
/* TABLE BODY ROW */
plpdf3.printBodyRow( p_parsed_table => l_parsedTable2, p_TableRow => l_row5);
end loop;
plpdf3.endTable( p_parsed_table => l_parsedTable2);
/* PARAGRAPH */
l_box12 := plpdf3.crBox( );
v_paragraph20 := plpdf3.crParagraph( p_box => l_box12);
l_link1 := plpdf.crInternalLink( );
plpdf.setLinkDest( p_link => l_link1);
plpdf3.printParagraph( p_paragraph => v_paragraph20);
plpdf.SendDoc( p_blob => v_pdf);
end;
end x_simpleTableHeader;
/
