create or replace package SDT_COLUMN_GROUP is
  procedure genPDF;
  v_pdf blob;
  cursor c_sample is
    select rownum, owner, object_name from all_objects where rownum <= 100;
end SDT_COLUMN_GROUP;
/
create or replace package body SDT_COLUMN_GROUP is
  /* 2020-FEB-09 09:54 */
  /* PL/PDF REPORTER 4.10 */
  /* THIS IS A GENERATED CODE, DO NOT MODIFY DIRECTLY! */
  l_margin1      plpdf3.t_margin;
  l_box1         plpdf3.t_box;
  l_font1        plpdf3.t_font;
  l_padding1     plpdf3.t_Padding;
  l_box2         plpdf3.t_box;
  l_pPr1         plpdf3.t_ParagraphProps;
  l_color1       plpdf_type.t_color;
  l_border_side1 plpdf3.t_border1;
  l_border2      plpdf3.t_Border;
  l_box3         plpdf3.t_box;
  l_color2       plpdf_type.t_color;
  l_font2        plpdf3.t_font;
  l_rPr1         plpdf3.t_RunProps;

  v_format1      plpdf_type.t_pageformat;
  l_margin2      plpdf3.t_margin;
  l_box4         plpdf3.t_box;
  l_margin3      plpdf3.t_margin;
  l_box5         plpdf3.t_box;
  v_paragraph1   plpdf3.t_paragraph;
  l_text_idx1    pls_integer;
  l_tblGrid1     plpdf3.t_TableGrid := plpdf3.v_TableGrid_empty;
  l_table1       plpdf3.t_Table;
  l_row1         plpdf3.t_TableRow;
  l_border_side3 plpdf3.t_border1;
  l_border4      plpdf3.t_Border;
  l_box6         plpdf3.t_box;
  l_cell1        plpdf3.t_TableCell;
  v_paragraph2   plpdf3.t_paragraph;
  l_text_idx2    pls_integer;
  l_paragraph3   pls_integer;
  l_cell2        pls_integer;
  l_cell3        plpdf3.t_TableCell;
  v_paragraph4   plpdf3.t_paragraph;
  l_text_idx3    pls_integer;
  l_paragraph5   pls_integer;
  l_cell4        pls_integer;
  l_cell5        plpdf3.t_TableCell;
  v_paragraph6   plpdf3.t_paragraph;
  l_text_idx4    pls_integer;
  l_paragraph7   pls_integer;
  l_cell6        pls_integer;
  l_row_idx2     pls_integer;
  l_parsedTable2 plpdf3.t_parsed_table;
  l_row3         plpdf3.t_TableRow;
  l_cell7        plpdf3.t_TableCell;
  v_paragraph8   plpdf3.t_paragraph;
  l_text_idx5    pls_integer;
  l_paragraph9   pls_integer;
  l_cell8        pls_integer;
  l_cell9        plpdf3.t_TableCell;
  v_paragraph10  plpdf3.t_paragraph;
  l_text_idx6    pls_integer;
  l_paragraph11  pls_integer;
  l_cell10       pls_integer;
  l_cell11       plpdf3.t_TableCell;
  v_paragraph12  plpdf3.t_paragraph;
  l_text_idx7    pls_integer;
  l_paragraph13  pls_integer;
  l_cell12       pls_integer;
  v_paragraph14  plpdf3.t_paragraph;
  /* BODYSECTION */
  procedure initStyles is
  
  begin
  
    plpdf3.initStyles();
    l_margin1 := plpdf3.crMargin(p_bottom => 0);
    l_box1    := plpdf3.crBox(p_margin => l_margin1);
    plpdf3.addParagraphStyle(p_styleId => 'Normal',
                             p_default => true,
                             p_box     => l_box1);
    l_font1 := plpdf3.crFont(p_fontname => 'Helvetica');
    plpdf3.addRunStyle(p_styleId => 'DefaultParagraphFont',
                       p_default => true,
                       p_font    => l_font1);
    l_padding1 := plpdf3.crPadding(p_top    => 0,
                                   p_bottom => 0,
                                   p_left   => 5.400,
                                   p_right  => 5.400);
    l_box2     := plpdf3.crBox(p_padding => l_padding1);
    plpdf3.addTableStyle(p_styleId  => 'TableNormal',
                         p_default  => true,
                         p_cell_box => l_box2);
    l_pPr1         := plpdf3.crParagraphProps(p_box     => l_box1,
                                              p_spacing => 1);
    l_color1       := plpdf_util.crColor(p_r => 0, p_g => 0, p_b => 0);
    l_border_side1 := plpdf3.crBorder1(p_color => l_color1,
                                       p_width => 0.500,
                                       p_style => 'single');
    l_border2      := plpdf3.crBorder(p_top    => l_border_side1,
                                      p_bottom => l_border_side1,
                                      p_left   => l_border_side1,
                                      p_right  => l_border_side1);
    l_box3         := plpdf3.crBox(p_border => l_border2);
    plpdf3.addTableStyle(p_styleId => 'TableGrid',
                         p_pPr     => l_pPr1,
                         p_box     => l_box3,
                         p_basedOn => 'TableNormal');
    l_color2 := plpdf_util.crColor(p_r => 128, p_g => 128, p_b => 128);
    plpdf3.addRunStyle(p_styleId    => 'PlaceholderText',
                       p_font       => l_font1,
                       p_text_color => l_color2);
    l_font2 := plpdf3.crFont(p_fontname => 'Helvetica', p_sz => 8);
    l_rPr1  := plpdf3.crRunProps(p_font       => l_font2,
                                 p_text_color => l_color2);
    plpdf3.addParagraphStyle(p_styleId => 'BalloonText',
                             p_spacing => 1,
                             p_rPr     => l_rPr1);
    plpdf3.addRunStyle(p_styleId    => 'BalloonTextChar',
                       p_font       => l_font2,
                       p_text_color => l_color2);
  end;

  procedure genPDF is
  begin
    v_format1 := plpdf_util.crFormat(p_w => 595.300, p_h => 841.900);
    plpdf.init1(p_orientation => 'P',
                p_unit        => 'pt',
                p_format      => v_format1);
    initStyles();
    plpdf.setTopMargin(p_margin => 70.850);
    plpdf.setLeftMargin(p_margin => 70.850);
    plpdf.setRightMargin(p_margin => 70.850);
    plpdf.setBottomMargin(p_margin => 70.850);
    plpdf3.setDefaultRunProps(p_fontname => 'Helvetica', p_sz => 11);
    l_margin2 := plpdf3.crMargin(p_bottom => 8);
    l_box4    := plpdf3.crBox(p_margin => l_margin2);
    plpdf3.setDefaultParagraphProps(p_box                 => l_box4,
                                    p_spacing             => 1.079,
                                    p_linerule            => 'auto',
                                    p_linerule_auto_multi => 1.160);
    plpdf3.setDefaultTabStop(p_tabstop => 35.40);
    plpdf.NewPage();
    /* PARAGRAPH */
    l_margin3    := plpdf3.crMargin(p_bottom => 12);
    l_box5       := plpdf3.crBox(p_margin => l_margin3);
    v_paragraph1 := plpdf3.crParagraph(p_box     => l_box5,
                                       p_styleId => 'Normal');
    /* ADD TEXT */
    l_text_idx1 := plpdf3.addText(p_paragraph => v_paragraph1,
                                  p_text      => 'Mixed GROUP and COLUMN example!',
                                  p_font      => l_font1);
    plpdf3.printParagraph(p_paragraph => v_paragraph1);
    /* TABLE */
    l_tblGrid1 := plpdf3.v_TableGrid_empty;
    plpdf3.AddGridCol(p_tableGrid => l_tblGrid1, p_width => 151);
    plpdf3.AddGridCol(p_tableGrid => l_tblGrid1, p_width => 151.050);
    plpdf3.AddGridCol(p_tableGrid => l_tblGrid1, p_width => 151.050);
    l_table1 := plpdf3.crTable(p_grid    => l_tblGrid1,
                               p_styleId => 'TableGrid');
    /* TABLE ROW */
    l_row1 := plpdf3.crRow();
    /* TABLE CELL */
    l_border_side3 := plpdf3.crBorder1(p_color => l_color1,
                                       p_width => 1,
                                       p_style => 'single');
    l_border4      := plpdf3.crBorder(p_top    => l_border_side3,
                                      p_bottom => l_border_side3,
                                      p_left   => l_border_side3,
                                      p_right  => l_border_side3);
    l_box6         := plpdf3.crBox(p_border => l_border4);
    l_cell1        := plpdf3.crCell(p_box => l_box6, p_width => 151);
    /* PARAGRAPH */
    v_paragraph2 := plpdf3.crParagraph(p_styleId => 'Normal');
    /* ADD TEXT */
    l_text_idx2  := plpdf3.addText(p_paragraph => v_paragraph2,
                                   p_text      => 'Rownum',
                                   p_font      => l_font1);
    l_paragraph3 := plpdf3.addParagraph(p_TableCell => l_cell1,
                                        p_Paragraph => v_paragraph2);
    l_cell2      := plpdf3.addCell(p_TableRow  => l_row1,
                                   p_TableCell => l_cell1);
    /* TABLE CELL */
    l_cell3 := plpdf3.crCell(p_box => l_box6, p_width => 151.050);
    /* PARAGRAPH */
    v_paragraph4 := plpdf3.crParagraph(p_styleId => 'Normal');
    /* ADD TEXT */
    l_text_idx3  := plpdf3.addText(p_paragraph => v_paragraph4,
                                   p_text      => 'Owner',
                                   p_font      => l_font1);
    l_paragraph5 := plpdf3.addParagraph(p_TableCell => l_cell3,
                                        p_Paragraph => v_paragraph4);
    l_cell4      := plpdf3.addCell(p_TableRow  => l_row1,
                                   p_TableCell => l_cell3);
    /* TABLE CELL */
    l_cell5 := plpdf3.crCell(p_box => l_box6, p_width => 151.050);
    /* PARAGRAPH */
    v_paragraph6 := plpdf3.crParagraph(p_styleId => 'Normal');
    /* ADD TEXT */
    l_text_idx4  := plpdf3.addText(p_paragraph => v_paragraph6,
                                   p_text      => 'Object name',
                                   p_font      => l_font1);
    l_paragraph7 := plpdf3.addParagraph(p_TableCell => l_cell5,
                                        p_Paragraph => v_paragraph6);
    l_cell6      := plpdf3.addCell(p_TableRow  => l_row1,
                                   p_TableCell => l_cell5);
    /* TABLE HEADER ROW */
    l_row_idx2     := plpdf3.addHeaderRow(p_table    => l_table1,
                                          p_TableRow => l_row1);
    l_parsedTable2 := plpdf3.InitParseTable(p_table => l_table1);
    plpdf3.startTable(p_parsed_table => l_parsedTable2);
    /* SDT CONTROL: GROUP -> F_SAMPLE IN C_SAMPLE */
    for F_SAMPLE in C_SAMPLE loop
    
      /* TABLE ROW */
      l_row3 := plpdf3.crRow();
      /* TABLE CELL */
      l_cell7 := plpdf3.crCell(p_box => l_box6, p_width => 151);
      /* SDT CONTROL: COLUMN -> F_SAMPLE.ROWNUM */
      /* PARAGRAPH */
      v_paragraph8 := plpdf3.crParagraph(p_styleId => 'Normal');
      /* ADD TEXT */
      l_text_idx5  := plpdf3.addText(p_paragraph => v_paragraph8,
                                     p_text      => F_SAMPLE.ROWNUM,
                                     p_font      => l_font1);
      l_paragraph9 := plpdf3.addParagraph(p_TableCell => l_cell7,
                                          p_Paragraph => v_paragraph8);
      l_cell8      := plpdf3.addCell(p_TableRow  => l_row3,
                                     p_TableCell => l_cell7);
      /* TABLE CELL */
      l_cell9 := plpdf3.crCell(p_box => l_box6, p_width => 151.050);
      /* SDT CONTROL: COLUMN -> F_SAMPLE.OWNER */
      /* PARAGRAPH */
      v_paragraph10 := plpdf3.crParagraph(p_styleId => 'Normal');
      /* ADD TEXT */
      l_text_idx6   := plpdf3.addText(p_paragraph => v_paragraph10,
                                      p_text      => F_SAMPLE.OWNER,
                                      p_font      => l_font1);
      l_paragraph11 := plpdf3.addParagraph(p_TableCell => l_cell9,
                                           p_Paragraph => v_paragraph10);
      l_cell10      := plpdf3.addCell(p_TableRow  => l_row3,
                                      p_TableCell => l_cell9);
      /* TABLE CELL */
      l_cell11 := plpdf3.crCell(p_box => l_box6, p_width => 151.050);
      /* SDT CONTROL: COLUMN -> F_SAMPLE.OBJECT_NAME */
      /* PARAGRAPH */
      v_paragraph12 := plpdf3.crParagraph(p_styleId => 'Normal');
      /* ADD TEXT */
      l_text_idx7   := plpdf3.addText(p_paragraph => v_paragraph12,
                                      p_text      => F_SAMPLE.OBJECT_NAME,
                                      p_font      => l_font1);
      l_paragraph13 := plpdf3.addParagraph(p_TableCell => l_cell11,
                                           p_Paragraph => v_paragraph12);
      l_cell12      := plpdf3.addCell(p_TableRow  => l_row3,
                                      p_TableCell => l_cell11);
      /* TABLE BODY ROW */
      plpdf3.printBodyRow(p_parsed_table => l_parsedTable2,
                          p_TableRow     => l_row3);
    end loop;
    plpdf3.endTable(p_parsed_table => l_parsedTable2);
    /* PARAGRAPH */
    v_paragraph14 := plpdf3.crParagraph(p_styleId => 'Normal');
    plpdf3.printParagraph(p_paragraph => v_paragraph14);
    plpdf.SendDoc(p_blob => v_pdf);
  end;
end SDT_COLUMN_GROUP;
/
