create or replace package x_order_report is
  v_pdf blob;
  
  procedure genPDF;
    
  cursor_count pls_integer := 1;
  
    --parameter
  p_order_id number default 7;

  --one reocord table
  cursor c_order(p_ord_id number) is
    select
    ord.order_id order_id,
    cus.cust_first_name || ' ' || cus.cust_last_name cust_name,
    cus.cust_street_address1 cust_street_address1,
    cus.cust_city cust_city,
    sta.state_name cust_state_name,
    cus.cust_postal_code cust_postal_code,
    to_char(ord.order_total) order_total,
    to_char(ord.order_timestamp,'MM-DD-YYYY') order_date
  from demo_orders ord,
       demo_customers cus,
       demo_states sta
  where ord.order_id = p_ord_id
    and ord.customer_id = cus.customer_id
    and cus.cust_state = sta.st;

  --multi record table
  cursor c_order_items(p_ord_id number) is
   select
    oit.order_item_id order_item_id,
    oit.product_id product_id,
    pro.product_name product_name,
    to_char(oit.quantity) quantity,
    to_char(oit.unit_price) unit_price,
    to_char(oit.quantity * oit.unit_price) extended_price
    from demo_order_items oit,
         demo_product_info pro
    where oit.order_id = p_ord_id
      and oit.product_id = pro.product_id
    ;


end x_order_report;
/
create or replace package body x_order_report is
/* 2016-JAN-25 15:11 */
/* PL/PDF REPORTER 3.7.0 */
/* THIS IS GENERATED CODE. DO NOT MODIFY DIRECTLY! PLEASE CHANGE THE TEMPLATE. */
l_font1 plpdf3.t_font;
l_listLevel1 plpdf3.t_ListLevel;
l_listLevel2 plpdf3.t_ListLevel;
l_listLevel3 plpdf3.t_ListLevel;
l_listLevel4 plpdf3.t_ListLevel;
l_listLevel5 plpdf3.t_ListLevel;
l_listLevel6 plpdf3.t_ListLevel;
l_listLevel7 plpdf3.t_ListLevel;
l_listLevel8 plpdf3.t_ListLevel;
l_listLevel9 plpdf3.t_ListLevel;
l_listLevel10 plpdf3.t_ListLevel;
l_listLevel11 plpdf3.t_ListLevel;
l_listLevel12 plpdf3.t_ListLevel;
l_listLevel13 plpdf3.t_ListLevel;
l_listLevel14 plpdf3.t_ListLevel;
l_listLevel15 plpdf3.t_ListLevel;
l_listLevel16 plpdf3.t_ListLevel;
l_listLevel17 plpdf3.t_ListLevel;
l_listLevel18 plpdf3.t_ListLevel;

l_ttf1 plpdf_type.t_addfont;
l_ttf2 plpdf_type.t_addfont;
v_format1 plpdf_type.t_pageformat;
l_tblGrid1 plpdf3.t_TableGrid := plpdf3.v_TableGrid_empty;
l_table1 plpdf3.t_Table;
l_parsedTable2 plpdf3.t_parsed_table;
l_parsedTable3 plpdf3.t_parsed_table;
l_row1 plpdf3.t_TableRow;
l_border_side1 plpdf3.t_border1;
l_border2 plpdf3.t_Border;
l_box1 plpdf3.t_box;
l_cell1 plpdf3.t_TableCell;
l_margin1 plpdf3.t_margin;
l_box2 plpdf3.t_box;
v_paragraph1 plpdf3.t_paragraph;
l_imageBlob1 blob;
l_box3 plpdf3.t_box;
l_image1 pls_integer;
l_paragraph2 pls_integer;
l_cell2 pls_integer;
l_cell3 plpdf3.t_TableCell;
v_paragraph3 plpdf3.t_paragraph;
l_font2 plpdf3.t_font;
l_text_idx1 pls_integer;
l_paragraph4 pls_integer;
l_cell4 pls_integer;
v_paragraph5 plpdf3.t_paragraph;
l_color1 plpdf_type.t_color;
l_border_side3 plpdf3.t_border1;
l_border4 plpdf3.t_Border;
l_box4 plpdf3.t_box;
l_tblGrid2 plpdf3.t_TableGrid := plpdf3.v_TableGrid_empty;
l_table4 plpdf3.t_Table;
l_parsedTable5 plpdf3.t_parsed_table;
l_parsedTable6 plpdf3.t_parsed_table;
l_row2 plpdf3.t_TableRow;
l_border_side5 plpdf3.t_border1;
l_border6 plpdf3.t_Border;
l_padding1 plpdf3.t_Padding;
l_color2 plpdf_type.t_color;
l_box5 plpdf3.t_box;
l_cell5 plpdf3.t_TableCell;
l_box6 plpdf3.t_box;
v_paragraph6 plpdf3.t_paragraph;
l_font3 plpdf3.t_font;
l_text_idx2 pls_integer;
l_font4 plpdf3.t_font;
l_text_idx3 pls_integer;
l_paragraph7 pls_integer;
l_cell6 pls_integer;
l_border_side7 plpdf3.t_border1;
l_border8 plpdf3.t_Border;
l_box7 plpdf3.t_box;
l_cell7 plpdf3.t_TableCell;
l_box8 plpdf3.t_box;
v_paragraph8 plpdf3.t_paragraph;
l_text_idx4 pls_integer;
l_paragraph9 pls_integer;
l_cell8 pls_integer;
l_row3 plpdf3.t_TableRow;
l_border9 plpdf3.t_Border;
l_box9 plpdf3.t_box;
l_cell9 plpdf3.t_TableCell;
l_box10 plpdf3.t_box;
v_paragraph10 plpdf3.t_paragraph;
l_text_idx5 pls_integer;
l_paragraph11 pls_integer;
l_box11 plpdf3.t_box;
v_paragraph12 plpdf3.t_paragraph;
l_text_idx6 pls_integer;
l_paragraph13 pls_integer;
l_box12 plpdf3.t_box;
v_paragraph14 plpdf3.t_paragraph;
l_text_idx7 pls_integer;
l_paragraph15 pls_integer;
l_box13 plpdf3.t_box;
v_paragraph16 plpdf3.t_paragraph;
l_text_idx8 pls_integer;
l_paragraph17 pls_integer;
l_cell10 pls_integer;
l_border10 plpdf3.t_Border;
l_box14 plpdf3.t_box;
l_cell11 plpdf3.t_TableCell;
l_box15 plpdf3.t_box;
v_paragraph18 plpdf3.t_paragraph;
l_text_idx9 pls_integer;
l_text_idx10 pls_integer;
l_paragraph19 pls_integer;
l_box16 plpdf3.t_box;
v_paragraph20 plpdf3.t_paragraph;
l_text_idx11 pls_integer;
l_text_idx12 pls_integer;
l_paragraph21 pls_integer;
l_box17 plpdf3.t_box;
v_paragraph22 plpdf3.t_paragraph;
l_text_idx13 pls_integer;
l_text_idx14 pls_integer;
l_paragraph23 pls_integer;
l_box18 plpdf3.t_box;
v_paragraph24 plpdf3.t_paragraph;
l_text_idx15 pls_integer;
l_text_idx16 pls_integer;
l_text_idx17 pls_integer;
l_paragraph25 pls_integer;
l_box19 plpdf3.t_box;
v_paragraph26 plpdf3.t_paragraph;
l_text_idx18 pls_integer;
l_text_idx19 pls_integer;
l_paragraph27 pls_integer;
l_cell12 pls_integer;
l_box20 plpdf3.t_box;
v_paragraph28 plpdf3.t_paragraph;
l_box21 plpdf3.t_box;
v_paragraph29 plpdf3.t_paragraph;
l_font5 plpdf3.t_font;
l_text_idx20 pls_integer;
l_tblGrid3 plpdf3.t_TableGrid := plpdf3.v_TableGrid_empty;
l_table7 plpdf3.t_Table;
l_row4 plpdf3.t_TableRow;
l_box22 plpdf3.t_box;
l_cell13 plpdf3.t_TableCell;
l_box23 plpdf3.t_box;
v_paragraph30 plpdf3.t_paragraph;
l_font6 plpdf3.t_font;
l_text_idx21 pls_integer;
l_paragraph31 pls_integer;
l_cell14 pls_integer;
l_cell15 plpdf3.t_TableCell;
l_box24 plpdf3.t_box;
v_paragraph32 plpdf3.t_paragraph;
l_text_idx22 pls_integer;
l_paragraph33 pls_integer;
l_cell16 pls_integer;
l_cell17 plpdf3.t_TableCell;
l_box25 plpdf3.t_box;
v_paragraph34 plpdf3.t_paragraph;
l_text_idx23 pls_integer;
l_paragraph35 pls_integer;
l_cell18 pls_integer;
l_cell19 plpdf3.t_TableCell;
l_box26 plpdf3.t_box;
v_paragraph36 plpdf3.t_paragraph;
l_text_idx24 pls_integer;
l_paragraph37 pls_integer;
l_cell20 pls_integer;
l_cell21 plpdf3.t_TableCell;
l_box27 plpdf3.t_box;
v_paragraph38 plpdf3.t_paragraph;
l_text_idx25 pls_integer;
l_paragraph39 pls_integer;
l_cell22 pls_integer;
l_cell23 plpdf3.t_TableCell;
l_box28 plpdf3.t_box;
v_paragraph40 plpdf3.t_paragraph;
l_text_idx26 pls_integer;
l_paragraph41 pls_integer;
l_cell24 pls_integer;
l_row_idx5 pls_integer;
l_parsedTable8 plpdf3.t_parsed_table;
l_row6 plpdf3.t_TableRow;
l_box29 plpdf3.t_box;
l_cell25 plpdf3.t_TableCell;
l_box30 plpdf3.t_box;
v_paragraph42 plpdf3.t_paragraph;
l_text_idx27 pls_integer;
l_paragraph43 pls_integer;
l_cell26 pls_integer;
l_cell27 plpdf3.t_TableCell;
l_box31 plpdf3.t_box;
v_paragraph44 plpdf3.t_paragraph;
l_text_idx28 pls_integer;
l_paragraph45 pls_integer;
l_cell28 pls_integer;
l_cell29 plpdf3.t_TableCell;
l_box32 plpdf3.t_box;
v_paragraph46 plpdf3.t_paragraph;
l_text_idx29 pls_integer;
l_paragraph47 pls_integer;
l_cell30 pls_integer;
l_cell31 plpdf3.t_TableCell;
l_margin2 plpdf3.t_margin;
l_box33 plpdf3.t_box;
v_paragraph48 plpdf3.t_paragraph;
l_text_idx30 pls_integer;
l_paragraph49 pls_integer;
l_cell32 pls_integer;
l_cell33 plpdf3.t_TableCell;
l_box34 plpdf3.t_box;
v_paragraph50 plpdf3.t_paragraph;
l_text_idx31 pls_integer;
l_paragraph51 pls_integer;
l_cell34 pls_integer;
l_cell35 plpdf3.t_TableCell;
l_box35 plpdf3.t_box;
v_paragraph52 plpdf3.t_paragraph;
l_text_idx32 pls_integer;
l_paragraph53 pls_integer;
l_cell36 pls_integer;
l_margin3 plpdf3.t_margin;
l_box36 plpdf3.t_box;
v_paragraph54 plpdf3.t_paragraph;
l_text_idx33 pls_integer;
l_tblGrid4 plpdf3.t_TableGrid := plpdf3.v_TableGrid_empty;
l_table9 plpdf3.t_Table;
l_row7 plpdf3.t_TableRow;
l_cell37 plpdf3.t_TableCell;
l_box37 plpdf3.t_box;
v_paragraph55 plpdf3.t_paragraph;
l_text_idx34 pls_integer;
l_paragraph56 pls_integer;
l_cell38 pls_integer;
l_cell39 plpdf3.t_TableCell;
l_box38 plpdf3.t_box;
v_paragraph57 plpdf3.t_paragraph;
l_text_idx35 pls_integer;
l_paragraph58 pls_integer;
l_cell40 pls_integer;
l_cell41 plpdf3.t_TableCell;
l_box39 plpdf3.t_box;
v_paragraph59 plpdf3.t_paragraph;
l_text_idx36 pls_integer;
l_paragraph60 pls_integer;
l_cell42 pls_integer;
l_row_idx8 pls_integer;
l_parsedTable10 plpdf3.t_parsed_table;
l_row9 plpdf3.t_TableRow;
l_cell43 plpdf3.t_TableCell;
l_box40 plpdf3.t_box;
v_paragraph61 plpdf3.t_paragraph;
l_text_idx37 pls_integer;
l_paragraph62 pls_integer;
l_cell44 pls_integer;
l_cell45 plpdf3.t_TableCell;
l_box41 plpdf3.t_box;
v_paragraph63 plpdf3.t_paragraph;
l_paragraph64 pls_integer;
l_cell46 pls_integer;
l_cell47 plpdf3.t_TableCell;
l_box42 plpdf3.t_box;
v_paragraph65 plpdf3.t_paragraph;
l_text_idx38 pls_integer;
l_paragraph66 pls_integer;
l_cell48 pls_integer;
l_box43 plpdf3.t_box;
v_paragraph67 plpdf3.t_paragraph;
/* BODYSECTION */
function image_util( 
p_name varchar2
) return blob is
l_ret blob;
begin 
SELECT IMAGE_FILE INTO l_ret FROM PLPDF_REPORTER_IMAGE WHERE FILENAME = p_name;
return l_ret;
end;
procedure initNumbering 
 is 

begin

plpdf3.initNum();
l_font1 := plpdf3.crFont( p_fontname => 'ZapfDingbats');
l_listLevel1 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 0, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 36, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel1);
l_listLevel2 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 1, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 72, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel2);
l_listLevel3 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 2, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 108, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel3);
l_listLevel4 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 3, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 144, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel4);
l_listLevel5 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 4, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 180, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel5);
l_listLevel6 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 5, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 216, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel6);
l_listLevel7 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 6, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 252, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel7);
l_listLevel8 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 7, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 288, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel8);
l_listLevel9 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 8, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 324, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel9);
l_listLevel10 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 0, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 36, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel10);
l_listLevel11 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 1, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 72, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel11);
l_listLevel12 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 2, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 108, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel12);
l_listLevel13 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 3, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 144, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel13);
l_listLevel14 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 4, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 180, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel14);
l_listLevel15 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 5, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 216, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel15);
l_listLevel16 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 6, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 252, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel16);
l_listLevel17 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 7, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 288, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel17);
l_listLevel18 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 8, p_lvlJc => 'left', p_lvlText => chr(108), p_pPr_ind_left => 324, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 1, p_ListLevel => l_listLevel18);
plpdf3.AddNumbering( p_numId => 1, p_abstractNumId => 0);
plpdf3.AddNumbering( p_numId => 2, p_abstractNumId => 1);
end;

procedure genPDF is
 begin 
l_ttf1 := plpdf_ttf.GetTTF( p_id => 1);
l_ttf2 := plpdf_ttf.GetTTF( p_id => 22);
v_format1 := plpdf_util.crFormat( p_w => 595.300, p_h => 841.900);
plpdf.init1( p_orientation => 'P', p_unit => 'pt', p_format => v_format1);
initNumbering( );
plpdf.AddTTF( p_family => 'DejaVuSerif-Italic', p_style => 'I', p_data => l_ttf1);
plpdf.AddTTF( p_family => 'Roboto-Bold', p_style => 'B', p_data => l_ttf2);
plpdf.setTopMargin( p_margin => 35.400);
plpdf.setLeftMargin( p_margin => 70.850);
plpdf.setRightMargin( p_margin => 70.850);
plpdf.NewPage( );
/* TABLE */
l_tblGrid1  := plpdf3.v_TableGrid_empty;
plpdf3.AddGridCol( p_tableGrid => l_tblGrid1, p_width => 97.550);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid1, p_width => 363.050);
l_table1 := plpdf3.crTable( p_width => 0, p_grid => l_tblGrid1);
l_parsedTable2 := plpdf3.InitParseTable( p_table => l_table1);
plpdf3.startTable( p_parsed_table => l_parsedTable2);
l_parsedTable3 := plpdf3.InitParseTable( p_table => l_table1);
plpdf3.startTable( p_parsed_table => l_parsedTable3);
/* TABLE ROW */
l_row1 := plpdf3.crRow();
/* TABLE CELL */
l_border_side1 := plpdf3.crBorder1( p_width => 0.250, p_style => 'nil');
l_border2 := plpdf3.crBorder( p_top => l_border_side1, p_bottom => l_border_side1, p_left => l_border_side1, p_right => l_border_side1);
l_box1 := plpdf3.crBox( p_border => l_border2);
l_cell1 := plpdf3.crCell(p_box => l_box1, p_width => 97.550);
/* PARAGRAPH */
l_margin1 := plpdf3.crMargin( p_bottom => 18);
l_box2 := plpdf3.crBox( p_margin => l_margin1);
v_paragraph1 := plpdf3.crParagraph( p_box => l_box2, p_alignment => 'left');
l_imageBlob1 := image_util( p_name => 'image2.jpeg');
l_box3 := plpdf3.crBox( );
l_image1 := plpdf3.addInlineImage( p_paragraph => v_paragraph1, p_name => 'Picture 16', p_data => l_imageBlob1, p_width => 60.500, p_height => 60.500, p_box => l_box3);
l_paragraph2 := plpdf3.addParagraph(p_TableCell => l_cell1, p_Paragraph => v_paragraph1);
l_cell2 := plpdf3.addCell(p_TableRow => l_row1, p_TableCell => l_cell1);
/* TABLE CELL */
l_cell3 := plpdf3.crCell(p_box => l_box1, p_width => 363.050);
/* PARAGRAPH */
v_paragraph3 := plpdf3.crParagraph( p_box => l_box2, p_alignment => 'left');
/* ADD TEXT */
l_font2 := plpdf3.crFont( p_i => true, p_sz => 42);
l_text_idx1 := plpdf3.addText( p_paragraph => v_paragraph3, p_text => 'ORDER REPORT', p_font => l_font2);
l_paragraph4 := plpdf3.addParagraph(p_TableCell => l_cell3, p_Paragraph => v_paragraph3);
l_cell4 := plpdf3.addCell(p_TableRow => l_row1, p_TableCell => l_cell3);
/* TABLE BODY ROW */
plpdf3.printBodyRow( p_parsed_table => l_parsedTable3, p_TableRow => l_row1);
plpdf3.endTable( p_parsed_table => l_parsedTable3);
/* PARAGRAPH */
v_paragraph5 := plpdf3.crParagraph( p_box => l_box2, p_alignment => 'left');
plpdf3.printParagraph( p_paragraph => v_paragraph5);
/* TABLE */
l_color1 := plpdf_util.crColor( p_r => 0, p_g => 0, p_b => 0);
l_border_side3 := plpdf3.crBorder1( p_color => l_color1, p_width => 0.250, p_style => 'single');
l_border4 := plpdf3.crBorder( p_top => l_border_side3, p_bottom => l_border_side3, p_left => l_border_side3, p_right => l_border_side3);
l_box4 := plpdf3.crBox( p_border => l_border4);
l_tblGrid2  := plpdf3.v_TableGrid_empty;
plpdf3.AddGridCol( p_tableGrid => l_tblGrid2, p_width => 230.300);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid2, p_width => 230.300);
l_table4 := plpdf3.crTable( p_box => l_box4, p_width => 0, p_grid => l_tblGrid2);
l_parsedTable5 := plpdf3.InitParseTable( p_table => l_table4);
plpdf3.startTable( p_parsed_table => l_parsedTable5);
l_parsedTable6 := plpdf3.InitParseTable( p_table => l_table4);
plpdf3.startTable( p_parsed_table => l_parsedTable6);
/* TABLE ROW */
l_row2 := plpdf3.crRow();
/* TABLE CELL */
l_border_side5 := plpdf3.crBorder1( p_color => l_color1, p_width => 0, p_style => 'none');
l_border6 := plpdf3.crBorder( p_top => l_border_side3, p_bottom => l_border_side3, p_left => l_border_side5, p_right => l_border_side3);
l_padding1 := plpdf3.crPadding( p_top => 0, p_bottom => 0, p_left => 0, p_right => 0);
l_color2 := plpdf_util.crColor( p_r => 51, p_g => 204, p_b => 51);
l_box5 := plpdf3.crBox( p_border => l_border6, p_padding => l_padding1, p_background_color => l_color2);
l_cell5 := plpdf3.crCell(p_box => l_box5, p_width => 230.300);
/* PARAGRAPH */
l_box6 := plpdf3.crBox( );
v_paragraph6 := plpdf3.crParagraph( p_box => l_box6);
/* ADD TEXT */
l_font3 := plpdf3.crFont( p_i => true, p_sz => 16);
l_text_idx2 := plpdf3.addText( p_paragraph => v_paragraph6, p_text => 'Supplier', p_font => l_font3);
/* ADD TEXT */
l_font4 := plpdf3.crFont( p_i => true, p_sz => 14);
l_text_idx3 := plpdf3.addText( p_paragraph => v_paragraph6, p_text => ':', p_font => l_font4);
l_paragraph7 := plpdf3.addParagraph(p_TableCell => l_cell5, p_Paragraph => v_paragraph6);
l_cell6 := plpdf3.addCell(p_TableRow => l_row2, p_TableCell => l_cell5);
/* TABLE CELL */
l_border_side7 := plpdf3.crBorder1( p_color => l_color1, p_width => 0.500, p_style => 'single');
l_border8 := plpdf3.crBorder( p_top => l_border_side3, p_bottom => l_border_side7, p_left => l_border_side3, p_right => l_border_side5);
l_box7 := plpdf3.crBox( p_border => l_border8, p_padding => l_padding1, p_background_color => l_color2);
l_cell7 := plpdf3.crCell(p_box => l_box7, p_width => 230.300);
/* PARAGRAPH */
l_box8 := plpdf3.crBox( );
v_paragraph8 := plpdf3.crParagraph( p_box => l_box8);
/* ADD TEXT */
l_text_idx4 := plpdf3.addText( p_paragraph => v_paragraph8, p_text => ' Buyer:');
l_paragraph9 := plpdf3.addParagraph(p_TableCell => l_cell7, p_Paragraph => v_paragraph8);
l_cell8 := plpdf3.addCell(p_TableRow => l_row2, p_TableCell => l_cell7);
/* TABLE BODY ROW */
plpdf3.printBodyRow( p_parsed_table => l_parsedTable6, p_TableRow => l_row2);
/* SDT CONTROL: GROUP -> F_ORDER IN C_ORDER(P_ORDER_ID) */
for F_ORDER in C_ORDER(p_order_id) loop

/* TABLE ROW */
l_row3 := plpdf3.crRow(p_min_height => 104.100);
/* TABLE CELL */
l_border9 := plpdf3.crBorder( p_top => l_border_side3, p_bottom => l_border_side3, p_left => l_border_side3, p_right => l_border_side7);
l_box9 := plpdf3.crBox( p_border => l_border9, p_padding => l_padding1);
l_cell9 := plpdf3.crCell(p_box => l_box9, p_width => 230.300);
/* PARAGRAPH */
l_box10 := plpdf3.crBox( );
v_paragraph10 := plpdf3.crParagraph( p_box => l_box10, p_alignment => 'left');
/* ADD TEXT */
l_text_idx5 := plpdf3.addText( p_paragraph => v_paragraph10, p_text => 'Name:                    Clothing co.');
l_paragraph11 := plpdf3.addParagraph(p_TableCell => l_cell9, p_Paragraph => v_paragraph10);
/* PARAGRAPH */
l_box11 := plpdf3.crBox( );
v_paragraph12 := plpdf3.crParagraph( p_box => l_box11, p_alignment => 'left');
/* ADD TEXT */
l_text_idx6 := plpdf3.addText( p_paragraph => v_paragraph12, p_text => 'Address:                80 Rue Armand Carrel');
l_paragraph13 := plpdf3.addParagraph(p_TableCell => l_cell9, p_Paragraph => v_paragraph12);
/* PARAGRAPH */
l_box12 := plpdf3.crBox( );
v_paragraph14 := plpdf3.crParagraph( p_box => l_box12, p_alignment => 'left');
/* ADD TEXT */
l_text_idx7 := plpdf3.addText( p_paragraph => v_paragraph14, p_text => '                               Paris ');
l_paragraph15 := plpdf3.addParagraph(p_TableCell => l_cell9, p_Paragraph => v_paragraph14);
/* PARAGRAPH */
l_box13 := plpdf3.crBox( );
v_paragraph16 := plpdf3.crParagraph( p_box => l_box13, p_alignment => 'left');
/* ADD TEXT */
l_text_idx8 := plpdf3.addText( p_paragraph => v_paragraph16, p_text => '                               75019');
l_paragraph17 := plpdf3.addParagraph(p_TableCell => l_cell9, p_Paragraph => v_paragraph16);
l_cell10 := plpdf3.addCell(p_TableRow => l_row3, p_TableCell => l_cell9);
/* TABLE CELL */
l_border10 := plpdf3.crBorder( p_top => l_border_side7, p_bottom => l_border_side3, p_left => l_border_side7, p_right => l_border_side7);
l_box14 := plpdf3.crBox( p_border => l_border10, p_padding => l_padding1);
l_cell11 := plpdf3.crCell(p_box => l_box14, p_width => 230.300);
/* PARAGRAPH */
l_box15 := plpdf3.crBox( );
v_paragraph18 := plpdf3.crParagraph( p_box => l_box15, p_alignment => 'left');
/* ADD TEXT */
l_text_idx9 := plpdf3.addText( p_paragraph => v_paragraph18, p_text => 'Name                    ');
/* SDT CONTROL: COLUMN -> F_ORDER.CUST_NAME */
/* ADD TEXT */
l_text_idx10 := plpdf3.addText( p_paragraph => v_paragraph18, p_text => F_ORDER.cust_name);
l_paragraph19 := plpdf3.addParagraph(p_TableCell => l_cell11, p_Paragraph => v_paragraph18);
/* PARAGRAPH */
l_box16 := plpdf3.crBox( );
v_paragraph20 := plpdf3.crParagraph( p_box => l_box16, p_alignment => 'left');
/* ADD TEXT */
l_text_idx11 := plpdf3.addText( p_paragraph => v_paragraph20, p_text => 'Address:               ');
/* SDT CONTROL: COLUMN -> F_ORDER.CUST_STREET_ADDRESS1 */
/* ADD TEXT */
l_text_idx12 := plpdf3.addText( p_paragraph => v_paragraph20, p_text => F_ORDER.cust_street_address1);
l_paragraph21 := plpdf3.addParagraph(p_TableCell => l_cell11, p_Paragraph => v_paragraph20);
/* PARAGRAPH */
l_box17 := plpdf3.crBox( );
v_paragraph22 := plpdf3.crParagraph( p_box => l_box17);
/* ADD TEXT */
l_text_idx13 := plpdf3.addText( p_paragraph => v_paragraph22, p_text => '                              ');
/* SDT CONTROL: COLUMN -> F_ORDER.CUST_CITY */
/* ADD TEXT */
l_text_idx14 := plpdf3.addText( p_paragraph => v_paragraph22, p_text => F_ORDER.cust_city);
l_paragraph23 := plpdf3.addParagraph(p_TableCell => l_cell11, p_Paragraph => v_paragraph22);
/* PARAGRAPH */
l_box18 := plpdf3.crBox( );
v_paragraph24 := plpdf3.crParagraph( p_box => l_box18, p_alignment => 'left');
/* ADD TEXT */
l_text_idx15 := plpdf3.addText( p_paragraph => v_paragraph24, p_text => '               ');
/* SDT CONTROL: COLUMN -> F_ORDER.CUST_STATE_NAME */
/* ADD TEXT */
l_text_idx16 := plpdf3.addText( p_paragraph => v_paragraph24, p_text => F_ORDER.cust_state_name);
/* ADD TEXT */
l_text_idx17 := plpdf3.addText( p_paragraph => v_paragraph24, p_text => '               ');
l_paragraph25 := plpdf3.addParagraph(p_TableCell => l_cell11, p_Paragraph => v_paragraph24);
/* PARAGRAPH */
l_box19 := plpdf3.crBox( );
v_paragraph26 := plpdf3.crParagraph( p_box => l_box19);
/* ADD TEXT */
l_text_idx18 := plpdf3.addText( p_paragraph => v_paragraph26, p_text => '                              ');
/* SDT CONTROL: COLUMN -> F_ORDER.CUST_POSTAL_CODE */
/* ADD TEXT */
l_text_idx19 := plpdf3.addText( p_paragraph => v_paragraph26, p_text => F_ORDER.cust_postal_code);
l_paragraph27 := plpdf3.addParagraph(p_TableCell => l_cell11, p_Paragraph => v_paragraph26);
l_cell12 := plpdf3.addCell(p_TableRow => l_row3, p_TableCell => l_cell11);
/* TABLE BODY ROW */
plpdf3.printBodyRow( p_parsed_table => l_parsedTable6, p_TableRow => l_row3);
end loop;
plpdf3.endTable( p_parsed_table => l_parsedTable6);
/* PARAGRAPH */
l_box20 := plpdf3.crBox( );
v_paragraph28 := plpdf3.crParagraph( p_box => l_box20);
plpdf3.printParagraph( p_paragraph => v_paragraph28);
/* PARAGRAPH */
l_box21 := plpdf3.crBox( );
v_paragraph29 := plpdf3.crParagraph( p_box => l_box21);
/* ADD TEXT */
l_font5 := plpdf3.crFont( p_b => true, p_sz => 18);
l_text_idx20 := plpdf3.addText( p_paragraph => v_paragraph29, p_text => 'Order details', p_font => l_font5);
plpdf3.printParagraph( p_paragraph => v_paragraph29);
/* TABLE */
l_tblGrid3  := plpdf3.v_TableGrid_empty;
plpdf3.AddGridCol( p_tableGrid => l_tblGrid3, p_width => 50.950);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid3, p_width => 66.400);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid3, p_width => 86.500);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid3, p_width => 92.150);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid3, p_width => 77.950);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid3, p_width => 93.550);
l_table7 := plpdf3.crTable( p_width => 467.500, p_grid => l_tblGrid3);
/* TABLE ROW */
l_row4 := plpdf3.crRow(p_min_height => 11.850);
/* TABLE CELL */
l_box22 := plpdf3.crBox( p_border => l_border4, p_padding => l_padding1, p_background_color => l_color2);
l_cell13 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 50.950);
/* PARAGRAPH */
l_box23 := plpdf3.crBox( );
v_paragraph30 := plpdf3.crParagraph( p_box => l_box23, p_alignment => 'center');
/* ADD TEXT */
l_font6 := plpdf3.crFont( p_b => true);
l_text_idx21 := plpdf3.addText( p_paragraph => v_paragraph30, p_text => 'Order ID', p_font => l_font6);
l_paragraph31 := plpdf3.addParagraph(p_TableCell => l_cell13, p_Paragraph => v_paragraph30);
l_cell14 := plpdf3.addCell(p_TableRow => l_row4, p_TableCell => l_cell13);
/* TABLE CELL */
l_cell15 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 66.400);
/* PARAGRAPH */
l_box24 := plpdf3.crBox( );
v_paragraph32 := plpdf3.crParagraph( p_box => l_box24, p_alignment => 'center');
/* ADD TEXT */
l_text_idx22 := plpdf3.addText( p_paragraph => v_paragraph32, p_text => 'Product ID', p_font => l_font6);
l_paragraph33 := plpdf3.addParagraph(p_TableCell => l_cell15, p_Paragraph => v_paragraph32);
l_cell16 := plpdf3.addCell(p_TableRow => l_row4, p_TableCell => l_cell15);
/* TABLE CELL */
l_cell17 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 86.500);
/* PARAGRAPH */
l_box25 := plpdf3.crBox( );
v_paragraph34 := plpdf3.crParagraph( p_box => l_box25, p_alignment => 'center');
/* ADD TEXT */
l_text_idx23 := plpdf3.addText( p_paragraph => v_paragraph34, p_text => 'Product name', p_font => l_font6);
l_paragraph35 := plpdf3.addParagraph(p_TableCell => l_cell17, p_Paragraph => v_paragraph34);
l_cell18 := plpdf3.addCell(p_TableRow => l_row4, p_TableCell => l_cell17);
/* TABLE CELL */
l_cell19 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 92.150);
/* PARAGRAPH */
l_box26 := plpdf3.crBox( );
v_paragraph36 := plpdf3.crParagraph( p_box => l_box26, p_alignment => 'center');
/* ADD TEXT */
l_text_idx24 := plpdf3.addText( p_paragraph => v_paragraph36, p_text => 'Quantity', p_font => l_font6);
l_paragraph37 := plpdf3.addParagraph(p_TableCell => l_cell19, p_Paragraph => v_paragraph36);
l_cell20 := plpdf3.addCell(p_TableRow => l_row4, p_TableCell => l_cell19);
/* TABLE CELL */
l_cell21 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 77.950);
/* PARAGRAPH */
l_box27 := plpdf3.crBox( );
v_paragraph38 := plpdf3.crParagraph( p_box => l_box27, p_alignment => 'center');
/* ADD TEXT */
l_text_idx25 := plpdf3.addText( p_paragraph => v_paragraph38, p_text => 'Unit Price', p_font => l_font6);
l_paragraph39 := plpdf3.addParagraph(p_TableCell => l_cell21, p_Paragraph => v_paragraph38);
l_cell22 := plpdf3.addCell(p_TableRow => l_row4, p_TableCell => l_cell21);
/* TABLE CELL */
l_cell23 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 93.550);
/* PARAGRAPH */
l_box28 := plpdf3.crBox( );
v_paragraph40 := plpdf3.crParagraph( p_box => l_box28, p_alignment => 'center');
/* ADD TEXT */
l_text_idx26 := plpdf3.addText( p_paragraph => v_paragraph40, p_text => 'Extended Price', p_font => l_font6);
l_paragraph41 := plpdf3.addParagraph(p_TableCell => l_cell23, p_Paragraph => v_paragraph40);
l_cell24 := plpdf3.addCell(p_TableRow => l_row4, p_TableCell => l_cell23);
/* TABLE HEADER ROW */
l_row_idx5 := plpdf3.addHeaderRow(p_table => l_table7, p_TableRow => l_row4);
l_parsedTable8 := plpdf3.InitParseTable( p_table => l_table7);
plpdf3.startTable( p_parsed_table => l_parsedTable8);
/* SDT CONTROL: GROUP -> F_ITEM IN C_ORDER_ITEMS(P_ORDER_ID) */
for F_ITEM in c_order_items(p_order_id) loop

/* TABLE ROW */
l_row6 := plpdf3.crRow(p_min_height => 118.650);
/* TABLE CELL */
l_box29 := plpdf3.crBox( p_border => l_border4, p_padding => l_padding1);
l_cell25 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 50.950);
/* SDT CONTROL: COLUMN -> F_ITEM.ORDER_ITEM_ID */
/* PARAGRAPH */
l_box30 := plpdf3.crBox( );
v_paragraph42 := plpdf3.crParagraph( p_box => l_box30, p_alignment => 'center');
/* ADD TEXT */
l_text_idx27 := plpdf3.addText( p_paragraph => v_paragraph42, p_text => F_ITEM.order_item_id);
l_paragraph43 := plpdf3.addParagraph(p_TableCell => l_cell25, p_Paragraph => v_paragraph42);
l_cell26 := plpdf3.addCell(p_TableRow => l_row6, p_TableCell => l_cell25);
/* TABLE CELL */
l_cell27 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 66.400);
/* SDT CONTROL: COLUMN -> F_ITEM.PRODUCT_ID */
/* PARAGRAPH */
l_box31 := plpdf3.crBox( );
v_paragraph44 := plpdf3.crParagraph( p_box => l_box31, p_alignment => 'center');
/* ADD TEXT */
l_text_idx28 := plpdf3.addText( p_paragraph => v_paragraph44, p_text => F_ITEM.product_id);
l_paragraph45 := plpdf3.addParagraph(p_TableCell => l_cell27, p_Paragraph => v_paragraph44);
l_cell28 := plpdf3.addCell(p_TableRow => l_row6, p_TableCell => l_cell27);
/* TABLE CELL */
l_cell29 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 86.500);
/* SDT CONTROL: COLUMN -> F_ITEM.PRODUCT_NAME */
/* PARAGRAPH */
l_box32 := plpdf3.crBox( );
v_paragraph46 := plpdf3.crParagraph( p_box => l_box32);
/* ADD TEXT */
l_text_idx29 := plpdf3.addText( p_paragraph => v_paragraph46, p_text => F_ITEM.product_name);
l_paragraph47 := plpdf3.addParagraph(p_TableCell => l_cell29, p_Paragraph => v_paragraph46);
l_cell30 := plpdf3.addCell(p_TableRow => l_row6, p_TableCell => l_cell29);
/* TABLE CELL */
l_cell31 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 92.150);
/* SDT CONTROL: COLUMN -> F_ITEM.QUANTITY */
/* PARAGRAPH */
l_margin2 := plpdf3.crMargin( p_bottom => 10);
l_box33 := plpdf3.crBox( p_margin => l_margin2);
v_paragraph48 := plpdf3.crParagraph( p_box => l_box33, p_alignment => 'center', p_spacing => 1.150);
/* ADD TEXT */
l_text_idx30 := plpdf3.addText( p_paragraph => v_paragraph48, p_text => F_ITEM.quantity);
l_paragraph49 := plpdf3.addParagraph(p_TableCell => l_cell31, p_Paragraph => v_paragraph48);
l_cell32 := plpdf3.addCell(p_TableRow => l_row6, p_TableCell => l_cell31);
/* TABLE CELL */
l_cell33 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 77.950);
/* SDT CONTROL: COLUMN -> F_ITEM.UNIT_PRICE */
/* PARAGRAPH */
l_box34 := plpdf3.crBox( );
v_paragraph50 := plpdf3.crParagraph( p_box => l_box34, p_alignment => 'center');
/* ADD TEXT */
l_text_idx31 := plpdf3.addText( p_paragraph => v_paragraph50, p_text => F_ITEM.unit_price);
l_paragraph51 := plpdf3.addParagraph(p_TableCell => l_cell33, p_Paragraph => v_paragraph50);
l_cell34 := plpdf3.addCell(p_TableRow => l_row6, p_TableCell => l_cell33);
/* TABLE CELL */
l_cell35 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 93.550);
/* SDT CONTROL: COLUMN -> F_ITEM.EXTENDED_PRICE */
/* PARAGRAPH */
l_box35 := plpdf3.crBox( );
v_paragraph52 := plpdf3.crParagraph( p_box => l_box35, p_alignment => 'center');
/* ADD TEXT */
l_text_idx32 := plpdf3.addText( p_paragraph => v_paragraph52, p_text => F_ITEM.extended_price);
l_paragraph53 := plpdf3.addParagraph(p_TableCell => l_cell35, p_Paragraph => v_paragraph52);
l_cell36 := plpdf3.addCell(p_TableRow => l_row6, p_TableCell => l_cell35);
/* TABLE BODY ROW */
plpdf3.printBodyRow( p_parsed_table => l_parsedTable8, p_TableRow => l_row6);
end loop;
plpdf3.endTable( p_parsed_table => l_parsedTable8);
/* PARAGRAPH */
l_margin3 := plpdf3.crMargin( p_top => 18);
l_box36 := plpdf3.crBox( p_margin => l_margin3);
v_paragraph54 := plpdf3.crParagraph( p_box => l_box36, p_alignment => 'right');
/* ADD TEXT */
l_text_idx33 := plpdf3.addText( p_paragraph => v_paragraph54, p_text => 'Order', p_font => l_font5);
plpdf3.printParagraph( p_paragraph => v_paragraph54);
/* TABLE */
l_tblGrid4  := plpdf3.v_TableGrid_empty;
plpdf3.AddGridCol( p_tableGrid => l_tblGrid4, p_width => 60.900);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid4, p_width => 60.950);
plpdf3.AddGridCol( p_tableGrid => l_tblGrid4, p_width => 61.150);
l_table9 := plpdf3.crTable( p_width => 183, p_grid => l_tblGrid4, p_alignment => 'right');
/* TABLE ROW */
l_row7 := plpdf3.crRow(p_min_height => 11.850);
/* TABLE CELL */
l_cell37 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 60.900);
/* PARAGRAPH */
l_box37 := plpdf3.crBox( );
v_paragraph55 := plpdf3.crParagraph( p_box => l_box37, p_alignment => 'left');
/* ADD TEXT */
l_text_idx34 := plpdf3.addText( p_paragraph => v_paragraph55, p_text => 'No.', p_font => l_font6);
l_paragraph56 := plpdf3.addParagraph(p_TableCell => l_cell37, p_Paragraph => v_paragraph55);
l_cell38 := plpdf3.addCell(p_TableRow => l_row7, p_TableCell => l_cell37);
/* TABLE CELL */
l_cell39 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 60.950);
/* PARAGRAPH */
l_box38 := plpdf3.crBox( );
v_paragraph57 := plpdf3.crParagraph( p_box => l_box38, p_alignment => 'left');
/* ADD TEXT */
l_text_idx35 := plpdf3.addText( p_paragraph => v_paragraph57, p_text => 'Total order', p_font => l_font6);
l_paragraph58 := plpdf3.addParagraph(p_TableCell => l_cell39, p_Paragraph => v_paragraph57);
l_cell40 := plpdf3.addCell(p_TableRow => l_row7, p_TableCell => l_cell39);
/* TABLE CELL */
l_cell41 := plpdf3.crCell(p_box => l_box22, p_Valign => 'center', p_width => 61.150);
/* PARAGRAPH */
l_box39 := plpdf3.crBox( );
v_paragraph59 := plpdf3.crParagraph( p_box => l_box39, p_alignment => 'left');
/* ADD TEXT */
l_text_idx36 := plpdf3.addText( p_paragraph => v_paragraph59, p_text => 'Order date', p_font => l_font6);
l_paragraph60 := plpdf3.addParagraph(p_TableCell => l_cell41, p_Paragraph => v_paragraph59);
l_cell42 := plpdf3.addCell(p_TableRow => l_row7, p_TableCell => l_cell41);
/* TABLE HEADER ROW */
l_row_idx8 := plpdf3.addHeaderRow(p_table => l_table9, p_TableRow => l_row7);
l_parsedTable10 := plpdf3.InitParseTable( p_table => l_table9);
plpdf3.startTable( p_parsed_table => l_parsedTable10);
/* SDT CONTROL: GROUP -> F_ORDER IN C_ORDER(P_ORDER_ID) */
for F_ORDER in C_ORDER(p_order_id) loop

/* TABLE ROW */
l_row9 := plpdf3.crRow(p_min_height => 37.500);
/* TABLE CELL */
l_cell43 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 60.900);
/* SDT CONTROL: COLUMN -> F_ORDER.ORDER_TOTAL */
/* PARAGRAPH */
l_box40 := plpdf3.crBox( );
v_paragraph61 := plpdf3.crParagraph( p_box => l_box40, p_alignment => 'left');
/* ADD TEXT */
l_text_idx37 := plpdf3.addText( p_paragraph => v_paragraph61, p_text => F_ORDER.order_total);
l_paragraph62 := plpdf3.addParagraph(p_TableCell => l_cell43, p_Paragraph => v_paragraph61);
l_cell44 := plpdf3.addCell(p_TableRow => l_row9, p_TableCell => l_cell43);
/* TABLE CELL */
l_cell45 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 60.950);
/* PARAGRAPH */
l_box41 := plpdf3.crBox( );
v_paragraph63 := plpdf3.crParagraph( p_box => l_box41, p_alignment => 'left');
l_paragraph64 := plpdf3.addParagraph(p_TableCell => l_cell45, p_Paragraph => v_paragraph63);
l_cell46 := plpdf3.addCell(p_TableRow => l_row9, p_TableCell => l_cell45);
/* TABLE CELL */
l_cell47 := plpdf3.crCell(p_box => l_box29, p_Valign => 'center', p_width => 61.150);
/* SDT CONTROL: COLUMN -> F_ORDER.ORDER_DATE */
/* PARAGRAPH */
l_box42 := plpdf3.crBox( );
v_paragraph65 := plpdf3.crParagraph( p_box => l_box42, p_alignment => 'left');
/* ADD TEXT */
l_text_idx38 := plpdf3.addText( p_paragraph => v_paragraph65, p_text => F_ORDER.order_date);
l_paragraph66 := plpdf3.addParagraph(p_TableCell => l_cell47, p_Paragraph => v_paragraph65);
l_cell48 := plpdf3.addCell(p_TableRow => l_row9, p_TableCell => l_cell47);
/* TABLE BODY ROW */
plpdf3.printBodyRow( p_parsed_table => l_parsedTable10, p_TableRow => l_row9);
end loop;
plpdf3.endTable( p_parsed_table => l_parsedTable10);
/* PARAGRAPH */
l_box43 := plpdf3.crBox( );
v_paragraph67 := plpdf3.crParagraph( p_box => l_box43);
plpdf3.printParagraph( p_paragraph => v_paragraph67);
plpdf.SendDoc( p_blob => v_pdf);
end;
end x_order_report;
/
