﻿set feedback off
set define off
prompt Creating DEMO_CUSTOMERS...
create table DEMO_CUSTOMERS
(
  CUSTOMER_ID          NUMBER not null,
  CUST_FIRST_NAME      VARCHAR2(20) not null,
  CUST_LAST_NAME       VARCHAR2(20) not null,
  CUST_STREET_ADDRESS1 VARCHAR2(60),
  CUST_STREET_ADDRESS2 VARCHAR2(60),
  CUST_CITY            VARCHAR2(30),
  CUST_STATE           VARCHAR2(2),
  CUST_POSTAL_CODE     VARCHAR2(10),
  PHONE_NUMBER1        VARCHAR2(25),
  PHONE_NUMBER2        VARCHAR2(25),
  CREDIT_LIMIT         NUMBER(9,2),
  CUST_EMAIL           VARCHAR2(30)
)
tablespace SYSTEM
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
alter table DEMO_CUSTOMERS
  add constraint DEMO_CUSTOMERS_PK primary key (CUSTOMER_ID)
  using index 
  tablespace SYSTEM
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
alter table DEMO_CUSTOMERS
  add constraint DEMO_CUST_CREDIT_LIMIT_MAX
  check (credit_limit <= 5000);
create index DEMO_CUST_NAME_IX on DEMO_CUSTOMERS (CUST_LAST_NAME, CUST_FIRST_NAME)
  tablespace SYSTEM
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );

prompt Creating DEMO_ORDERS...
create table DEMO_ORDERS
(
  ORDER_ID        NUMBER not null,
  CUSTOMER_ID     NUMBER not null,
  ORDER_TOTAL     NUMBER(8,2),
  ORDER_TIMESTAMP DATE,
  USER_ID         NUMBER
)
tablespace SYSTEM
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
alter table DEMO_ORDERS
  add constraint DEMO_ORDER_PK primary key (ORDER_ID)
  using index 
  tablespace SYSTEM
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
alter table DEMO_ORDERS
  add constraint DEMO_ORDERS_CUSTOMER_ID_FK foreign key (CUSTOMER_ID)
  references DEMO_CUSTOMERS (CUSTOMER_ID);
alter table DEMO_ORDERS
  add constraint DEMO_ORDERS_USER_ID_FK foreign key (USER_ID)
  references DEMO_USERS (USER_ID);
alter table DEMO_ORDERS
  add constraint DEMO_ORDER_TOTAL_MIN
  check (order_total >= 0);
create index DEMO_ORD_CUSTOMER_IX on DEMO_ORDERS (CUSTOMER_ID)
  tablespace SYSTEM
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );

prompt Creating DEMO_ORDER_ITEMS...
create table DEMO_ORDER_ITEMS
(
  ORDER_ITEM_ID NUMBER(3) not null,
  ORDER_ID      NUMBER not null,
  PRODUCT_ID    NUMBER not null,
  UNIT_PRICE    NUMBER(8,2) not null,
  QUANTITY      NUMBER(8) not null
)
tablespace SYSTEM
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
alter table DEMO_ORDER_ITEMS
  add constraint DEMO_ORDER_ITEMS_PK primary key (ORDER_ITEM_ID)
  using index 
  tablespace SYSTEM
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
alter table DEMO_ORDER_ITEMS
  add constraint DEMO_ORDER_ITEMS_FK foreign key (ORDER_ID)
  references DEMO_ORDERS (ORDER_ID) on delete cascade;
alter table DEMO_ORDER_ITEMS
  add constraint DEMO_ORDER_ITEMS_PRODUCT_ID_FK foreign key (PRODUCT_ID)
  references DEMO_PRODUCT_INFO (PRODUCT_ID) on delete cascade;

prompt Creating DEMO_PRODUCT_INFO...
create table DEMO_PRODUCT_INFO
(
  PRODUCT_ID          NUMBER not null,
  PRODUCT_NAME        VARCHAR2(50),
  PRODUCT_DESCRIPTION VARCHAR2(2000),
  CATEGORY            VARCHAR2(30),
  PRODUCT_AVAIL       VARCHAR2(1),
  LIST_PRICE          NUMBER(8,2),
  IMAGE_LAST_UPDATE   DATE
)
tablespace SYSTEM
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );

prompt Creating DEMO_STATES...
create table DEMO_STATES
(
  ST         VARCHAR2(30),
  STATE_NAME VARCHAR2(30)
)
tablespace SYSTEM
  pctfree 10
  pctused 40
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );

prompt Loading DEMO_CUSTOMERS...
insert into DEMO_CUSTOMERS (CUSTOMER_ID, CUST_FIRST_NAME, CUST_LAST_NAME, CUST_STREET_ADDRESS1, CUST_STREET_ADDRESS2, CUST_CITY, CUST_STATE, CUST_POSTAL_CODE, PHONE_NUMBER1, PHONE_NUMBER2, CREDIT_LIMIT, CUST_EMAIL)
values (1, 'John', 'Dulles', '45020 Aviation Drive', null, 'Sterling', 'VA', '20166', '703-555-2143', null, 1000, null);
insert into DEMO_CUSTOMERS (CUSTOMER_ID, CUST_FIRST_NAME, CUST_LAST_NAME, CUST_STREET_ADDRESS1, CUST_STREET_ADDRESS2, CUST_CITY, CUST_STATE, CUST_POSTAL_CODE, PHONE_NUMBER1, PHONE_NUMBER2, CREDIT_LIMIT, CUST_EMAIL)
values (2, 'William', 'Hartsfield', '6000 North Terminal Parkway', null, 'Atlanta', 'GA', '30320', '404-555-3285', null, 1000, null);
insert into DEMO_CUSTOMERS (CUSTOMER_ID, CUST_FIRST_NAME, CUST_LAST_NAME, CUST_STREET_ADDRESS1, CUST_STREET_ADDRESS2, CUST_CITY, CUST_STATE, CUST_POSTAL_CODE, PHONE_NUMBER1, PHONE_NUMBER2, CREDIT_LIMIT, CUST_EMAIL)
values (3, 'Edward', 'Logan', '1 Harborside Drive', null, 'East Boston', 'MA', '02128', '617-555-3295', null, 1000, null);
insert into DEMO_CUSTOMERS (CUSTOMER_ID, CUST_FIRST_NAME, CUST_LAST_NAME, CUST_STREET_ADDRESS1, CUST_STREET_ADDRESS2, CUST_CITY, CUST_STATE, CUST_POSTAL_CODE, PHONE_NUMBER1, PHONE_NUMBER2, CREDIT_LIMIT, CUST_EMAIL)
values (4, 'Edward "Butch"', 'OHare', '10000 West OHare', null, 'Chicago', 'IL', '60666', '773-555-7693', null, 1000, null);
insert into DEMO_CUSTOMERS (CUSTOMER_ID, CUST_FIRST_NAME, CUST_LAST_NAME, CUST_STREET_ADDRESS1, CUST_STREET_ADDRESS2, CUST_CITY, CUST_STATE, CUST_POSTAL_CODE, PHONE_NUMBER1, PHONE_NUMBER2, CREDIT_LIMIT, CUST_EMAIL)
values (5, 'Fiorello', 'LaGuardia', 'Hangar Center', 'Third Floor', 'Flushing', 'NY', '11371', '212-555-3923', null, 1000, null);
insert into DEMO_CUSTOMERS (CUSTOMER_ID, CUST_FIRST_NAME, CUST_LAST_NAME, CUST_STREET_ADDRESS1, CUST_STREET_ADDRESS2, CUST_CITY, CUST_STATE, CUST_POSTAL_CODE, PHONE_NUMBER1, PHONE_NUMBER2, CREDIT_LIMIT, CUST_EMAIL)
values (6, 'Albert', 'Lambert', '10701 Lambert International Blvd.', null, 'St. Louis', 'MO', '63145', '314-555-4022', null, 1000, null);
insert into DEMO_CUSTOMERS (CUSTOMER_ID, CUST_FIRST_NAME, CUST_LAST_NAME, CUST_STREET_ADDRESS1, CUST_STREET_ADDRESS2, CUST_CITY, CUST_STATE, CUST_POSTAL_CODE, PHONE_NUMBER1, PHONE_NUMBER2, CREDIT_LIMIT, CUST_EMAIL)
values (7, 'Eugene', 'Bradley', 'Schoephoester Road', null, 'Windsor Locks', 'CT', '06096', '860-555-1835', null, 1000, null);
commit;
prompt 7 records loaded
prompt Loading DEMO_ORDERS...
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (1, 7, 1890, to_date('11-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (2, 1, 2380, to_date('08-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (3, 2, 1640, to_date('02-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (4, 5, 1090, to_date('22-02-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (5, 6, 950, to_date('17-02-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (6, 3, 1515, to_date('12-02-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (7, 3, 905, to_date('02-02-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (8, 4, 1060, to_date('31-01-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (9, 2, 730, to_date('20-01-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
insert into DEMO_ORDERS (ORDER_ID, CUSTOMER_ID, ORDER_TOTAL, ORDER_TIMESTAMP, USER_ID)
values (10, 7, 870, to_date('06-01-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'), 2);
commit;
prompt 10 records loaded
prompt Loading DEMO_ORDER_ITEMS...
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (1, 1, 1, 50, 10);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (2, 1, 2, 80, 8);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (3, 1, 3, 150, 5);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (4, 2, 1, 50, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (5, 2, 2, 80, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (6, 2, 3, 150, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (7, 2, 4, 60, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (8, 2, 5, 80, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (9, 2, 6, 120, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (10, 2, 7, 30, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (11, 2, 8, 125, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (12, 2, 9, 110, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (13, 2, 10, 50, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (14, 3, 4, 60, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (15, 3, 5, 80, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (16, 3, 6, 120, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (17, 3, 8, 125, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (18, 3, 10, 50, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (19, 4, 6, 120, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (20, 4, 7, 30, 6);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (21, 4, 8, 125, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (22, 4, 9, 110, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (23, 4, 10, 50, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (24, 5, 1, 50, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (25, 5, 2, 80, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (26, 5, 3, 150, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (27, 5, 4, 60, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (28, 5, 5, 80, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (29, 6, 3, 150, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (30, 6, 6, 120, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (31, 6, 8, 125, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (32, 6, 9, 110, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (33, 7, 1, 50, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (34, 7, 2, 80, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (35, 7, 4, 60, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (36, 7, 5, 80, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (37, 7, 7, 30, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (38, 7, 8, 125, 1);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (39, 7, 10, 50, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (40, 8, 2, 80, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (41, 8, 3, 150, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (42, 8, 6, 120, 1);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (43, 8, 9, 110, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (44, 9, 4, 60, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (45, 9, 5, 80, 3);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (46, 9, 8, 125, 2);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (47, 10, 1, 50, 5);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (48, 10, 2, 80, 4);
insert into DEMO_ORDER_ITEMS (ORDER_ITEM_ID, ORDER_ID, PRODUCT_ID, UNIT_PRICE, QUANTITY)
values (49, 10, 3, 150, 2);
commit;
prompt 49 records loaded
prompt Loading DEMO_PRODUCT_INFO...
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (1, 'Business Shirt', 'Wrinkle-free cotton business shirt', 'Mens', 'Y', 50, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (2, 'Trousers', 'Black trousers suitable for every business man', 'Mens', 'Y', 80, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (3, 'Jacket', 'Fully lined jacket which is both professional and extremely comfortable to wear', 'Mens', 'Y', 150, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (4, 'Blouse', 'Silk blouse ideal for all business women', 'Womens', 'Y', 60, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (5, 'Skirt', 'Wrinkle free skirt', 'Womens', 'Y', 80, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (6, 'Ladies Shoes', 'Low heel and cushioned interior for comfort and style in simple yet elegant shoes', 'Womens', 'Y', 120, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (7, 'Belt', 'Leather belt', 'Accessories', 'Y', 30, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (8, 'Bag', 'Unisex bag suitable for carrying laptops with room for many additional items', 'Accessories', 'Y', 125, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (9, 'Mens Shoes', 'Leather upper and lower lace up shoes', 'Mens', 'Y', 110, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
insert into DEMO_PRODUCT_INFO (PRODUCT_ID, PRODUCT_NAME, PRODUCT_DESCRIPTION, CATEGORY, PRODUCT_AVAIL, LIST_PRICE, IMAGE_LAST_UPDATE)
values (10, 'Wallet', 'Travel wallet suitable for men and women. Several compartments for credit cards, passports and cash', 'Accessories', 'Y', 50, to_date('12-03-2015 12:08:57', 'dd-mm-yyyy hh24:mi:ss'));
commit;
prompt 10 records loaded
prompt Loading DEMO_STATES...
insert into DEMO_STATES (ST, STATE_NAME)
values ('AK', 'ALASKA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('AL', 'ALABAMA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('AR', 'ARKANSAS');
insert into DEMO_STATES (ST, STATE_NAME)
values ('AZ', 'ARIZONA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('CA', 'CALIFORNIA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('CO', 'COLORADO');
insert into DEMO_STATES (ST, STATE_NAME)
values ('CT', 'CONNECTICUT');
insert into DEMO_STATES (ST, STATE_NAME)
values ('DC', 'DISTRICT OF COLUMBIA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('DE', 'DELAWARE');
insert into DEMO_STATES (ST, STATE_NAME)
values ('FL', 'FLORIDA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('GA', 'GEORGIA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('HI', 'HAWAII');
insert into DEMO_STATES (ST, STATE_NAME)
values ('IA', 'IOWA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('ID', 'IDAHO');
insert into DEMO_STATES (ST, STATE_NAME)
values ('IL', 'ILLINOIS');
insert into DEMO_STATES (ST, STATE_NAME)
values ('IN', 'INDIANA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('KS', 'KANSAS');
insert into DEMO_STATES (ST, STATE_NAME)
values ('KY', 'KENTUCKY');
insert into DEMO_STATES (ST, STATE_NAME)
values ('LA', 'LOUISIANA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('MA', 'MASSACHUSETTS');
insert into DEMO_STATES (ST, STATE_NAME)
values ('MD', 'MARYLAND');
insert into DEMO_STATES (ST, STATE_NAME)
values ('ME', 'MAINE');
insert into DEMO_STATES (ST, STATE_NAME)
values ('MI', 'MICHIGAN');
insert into DEMO_STATES (ST, STATE_NAME)
values ('MN', 'MINNESOTA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('MO', 'MISSOURI');
insert into DEMO_STATES (ST, STATE_NAME)
values ('MS', 'MISSISSIPPI');
insert into DEMO_STATES (ST, STATE_NAME)
values ('MT', 'MONTANA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('NC', 'NORTH CAROLINA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('ND', 'NORTH DAKOTA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('NE', 'NEBRASKA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('NH', 'NEW HAMPSHIRE');
insert into DEMO_STATES (ST, STATE_NAME)
values ('NJ', 'NEW JERSEY');
insert into DEMO_STATES (ST, STATE_NAME)
values ('NM', 'NEW MEXICO');
insert into DEMO_STATES (ST, STATE_NAME)
values ('NV', 'NEVADA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('NY', 'NEW YORK');
insert into DEMO_STATES (ST, STATE_NAME)
values ('OH', 'OHIO');
insert into DEMO_STATES (ST, STATE_NAME)
values ('OK', 'OKLAHOMA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('OR', 'OREGON');
insert into DEMO_STATES (ST, STATE_NAME)
values ('PA', 'PENNSYLVANIA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('RI', 'RHODE ISLAND');
insert into DEMO_STATES (ST, STATE_NAME)
values ('SC', 'SOUTH CAROLINA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('SD', 'SOUTH DAKOTA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('TN', 'TENNESSEE');
insert into DEMO_STATES (ST, STATE_NAME)
values ('TX', 'TEXAS');
insert into DEMO_STATES (ST, STATE_NAME)
values ('UT', 'UTAH');
insert into DEMO_STATES (ST, STATE_NAME)
values ('VA', 'VIRGINIA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('VT', 'VERMONT');
insert into DEMO_STATES (ST, STATE_NAME)
values ('WA', 'WASHINGTON');
insert into DEMO_STATES (ST, STATE_NAME)
values ('WI', 'WISCONSIN');
insert into DEMO_STATES (ST, STATE_NAME)
values ('WV', 'WEST VIRGINIA');
insert into DEMO_STATES (ST, STATE_NAME)
values ('WY', 'WYOMING');
commit;
prompt 51 records loaded
set feedback on
set define on
prompt Done.
