create or replace package a_table_test is
  v_pdf blob;
  
  procedure genPDF;
  
  --procedure header_default;

  
  v_exp1 varchar2(255) := 'EXPRESSION1';
  v_exp2 varchar2(255) := 'EXPRESSION2';

  
  -- Master
  cursor c_users is
  SELECT u.USER_ID, u.USERNAME, u.CREATED
  FROM all_users u
  WHERE rownum <= 10;
  
  -- Detail
  cursor c_objects(owner in varchar2) is
  SELECT a.OBJECT_ID, a.OBJECT_NAME, a.OBJECT_TYPE
  FROM all_objects a
  WHERE UPPER(a.OWNER) = UPPER(owner)
  AND rownum <= 10;
  
  cursor c_all_objects is
SELECT o.OBJECT_ID, o.OBJECT_NAME, o.CREATED, o.OBJECT_TYPE
      FROM all_objects o
      WHERE o.OBJECT_ID between 1000 and 1500;

end a_table_test;
/
create or replace package body a_table_test is
/* 2016-JAN-25 14:16 */
/* PL/PDF REPORTER 3.7.0 */
/* THIS IS GENERATED CODE. DO NOT MODIFY DIRECTLY! PLEASE CHANGE THE TEMPLATE. */
l_font1 plpdf3.t_font;
l_listLevel1 plpdf3.t_ListLevel;
l_font2 plpdf3.t_font;
l_listLevel2 plpdf3.t_ListLevel;
l_font3 plpdf3.t_font;
l_listLevel3 plpdf3.t_ListLevel;
l_listLevel4 plpdf3.t_ListLevel;
l_listLevel5 plpdf3.t_ListLevel;
l_listLevel6 plpdf3.t_ListLevel;
l_listLevel7 plpdf3.t_ListLevel;
l_listLevel8 plpdf3.t_ListLevel;
l_listLevel9 plpdf3.t_ListLevel;

v_format1 plpdf_type.t_pageformat;
l_box1 plpdf3.t_box;
v_paragraph1 plpdf3.t_paragraph;
l_text_idx1 pls_integer;
l_box2 plpdf3.t_box;
v_paragraph2 plpdf3.t_paragraph;
l_text_idx2 pls_integer;
l_box3 plpdf3.t_box;
v_paragraph3 plpdf3.t_paragraph;
l_font4 plpdf3.t_font;
l_text_idx3 pls_integer;
/* BODYSECTION */
procedure initNumbering 
 is 

begin

plpdf3.initNum();
l_font1 := plpdf3.crFont( p_fontname => 'Symbol');
l_listLevel1 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 0, p_lvlJc => 'left', p_lvlText => chr(45), p_pPr_ind_left => 36, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel1);
l_font2 := plpdf3.crFont( p_fontname => 'Courier');
l_listLevel2 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 1, p_lvlJc => 'left', p_lvlText => chr(111), p_pPr_ind_left => 72, p_pPr_ind_hanging => 18, p_font => l_font2);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel2);
l_font3 := plpdf3.crFont( p_fontname => 'wingdings');
l_listLevel3 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 2, p_lvlJc => 'left', p_lvlText => chr(45), p_pPr_ind_left => 108, p_pPr_ind_hanging => 18, p_font => l_font3);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel3);
l_listLevel4 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 3, p_lvlJc => 'left', p_lvlText => chr(45), p_pPr_ind_left => 144, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel4);
l_listLevel5 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 4, p_lvlJc => 'left', p_lvlText => chr(111), p_pPr_ind_left => 180, p_pPr_ind_hanging => 18, p_font => l_font2);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel5);
l_listLevel6 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 5, p_lvlJc => 'left', p_lvlText => chr(45), p_pPr_ind_left => 216, p_pPr_ind_hanging => 18, p_font => l_font3);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel6);
l_listLevel7 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 6, p_lvlJc => 'left', p_lvlText => chr(45), p_pPr_ind_left => 252, p_pPr_ind_hanging => 18, p_font => l_font1);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel7);
l_listLevel8 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 7, p_lvlJc => 'left', p_lvlText => chr(111), p_pPr_ind_left => 288, p_pPr_ind_hanging => 18, p_font => l_font2);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel8);
l_listLevel9 := plpdf3.crListLevel( p_numFmt => 'bullet', p_ilvl => 8, p_lvlJc => 'left', p_lvlText => chr(45), p_pPr_ind_left => 324, p_pPr_ind_hanging => 18, p_font => l_font3);
plpdf3.addListLevel( p_abstractNumId => 0, p_ListLevel => l_listLevel9);
plpdf3.AddNumbering( p_numId => 1, p_abstractNumId => 0);
end;

procedure genPDF is
 begin 
v_format1 := plpdf_util.crFormat( p_w => 595.280, p_h => 841.890);
plpdf.init1( p_orientation => 'P', p_unit => 'pt', p_format => v_format1);
initNumbering( );
plpdf.setTopMargin( p_margin => 35.400);
plpdf.setLeftMargin( p_margin => 70.850);
plpdf.setRightMargin( p_margin => 70.850);
plpdf.NewPage( );
/* PARAGRAPH */
l_box1 := plpdf3.crBox( );
v_paragraph1 := plpdf3.crParagraph( p_box => l_box1);
/* ADD TEXT */
l_text_idx1 := plpdf3.addText( p_paragraph => v_paragraph1, p_text => 'AddText_FontSize');
plpdf3.printParagraph( p_paragraph => v_paragraph1);
/* PARAGRAPH */
l_box2 := plpdf3.crBox( );
v_paragraph2 := plpdf3.crParagraph( p_box => l_box2);
/* ADD TEXT */
l_text_idx2 := plpdf3.addText( p_paragraph => v_paragraph2, p_text => 'Font size: 10(default)');
plpdf3.printParagraph( p_paragraph => v_paragraph2);
/* PARAGRAPH */
l_box3 := plpdf3.crBox( );
v_paragraph3 := plpdf3.crParagraph( p_box => l_box3);
/* ADD TEXT */
l_font4 := plpdf3.crFont( p_sz => 24);
l_text_idx3 := plpdf3.addText( p_paragraph => v_paragraph3, p_text => 'Font size: 24', p_font => l_font4);
plpdf3.printParagraph( p_paragraph => v_paragraph3);
plpdf.SendDoc( p_blob => v_pdf);
end;
end a_table_test;
/
