declare
  l_sql_stmt varchar2(2000 char);
  type t_curtype is ref cursor;
  l_src_cur t_curtype;
  l_curid number;
  l_desctab dbms_sql.desc_tab;
  l_colcnt number;
  l_v2var varchar2(2000 char);
  l_numvar number;
  l_datevar date;
  --
  l_xls blob;
  sheet_id pls_integer; -- Worksheet ID
  row_id   pls_integer; -- Row ID
begin
  l_sql_stmt := 'select object_id, object_name, status from user_objects order by object_id';
  --
  ploffx_xlsx.init; -- Initializes generator program variables
  sheet_id := ploffx_xlsx.addWorksheet('Export1'); -- Add new worksheet
  --
  -- Open REF CURSOR variable:
  open l_src_cur for l_sql_stmt;
  -- switch from native dynamic sql to dbms_sql package:
  l_curid := dbms_sql.to_cursor_number(l_src_cur);
  dbms_sql.describe_columns(l_curid, l_colcnt, l_desctab);
  --
  row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
  -- define columns:
  for l_colcnt_i in 1 .. l_colcnt loop
    --
    ploffx_xlsx.addCell_String(
      p_ws   => sheet_id, -- Worksheet ID
      p_row  => row_id, -- Row ID
      p_cell => ploffx_util.num2col(l_colcnt_i), -- Column name
      p_data => l_desctab(l_colcnt_i).col_name -- String in the cell
      );
    --
    if l_desctab(l_colcnt_i).col_type = dbms_sql.varchar2_type then --1
      dbms_sql.define_column(l_curid, l_colcnt_i, l_v2var, 50);
    elsif l_desctab(l_colcnt_i).col_type = dbms_sql.number_type then --2
       dbms_sql.define_column(l_curid, l_colcnt_i, l_numvar);
    elsif l_desctab(l_colcnt_i).col_type = dbms_sql.date_type then --12
          dbms_sql.define_column(l_curid, l_colcnt_i, l_datevar);
    end if;
  end loop;
  --
  -- fetch rows with dbms_sql package:
  while dbms_sql.fetch_rows(l_curid) > 0 loop
    row_id := ploffx_xlsx.addRow(sheet_id); -- Add row to the worksheet
    for l_colcnt_i in 1 .. l_colcnt loop
      if (l_desctab(l_colcnt_i).col_type = dbms_sql.varchar2_type) then --1
        dbms_sql.column_value(l_curid, l_colcnt_i, l_v2var);
        --
        ploffx_xlsx.addCell_String(
          p_ws   => sheet_id, -- Worksheet ID
          p_row  => row_id, -- Row ID
          p_cell => ploffx_util.num2col(l_colcnt_i), -- Column name
          p_data => l_v2var -- String in the cell
          );
        --
      elsif (l_desctab(l_colcnt_i).col_type = dbms_sql.number_type) then --2
        dbms_sql.column_value(l_curid, l_colcnt_i, l_numvar);
        --
        ploffx_xlsx.addCell_Number(
          p_ws   => sheet_id, -- Worksheet ID
          p_row  => row_id, -- Row ID
          p_cell => ploffx_util.num2col(l_colcnt_i), -- Column name
          p_data => l_numvar 
          );
        --
      elsif (l_desctab(l_colcnt_i).col_type = dbms_sql.date_type) then --12
        dbms_sql.column_value(l_curid, l_colcnt_i, l_datevar);
      --
        ploffx_xlsx.addCell_Date(
          p_ws   => sheet_id, -- Worksheet ID
          p_row  => row_id, -- Row ID
          p_cell => ploffx_util.num2col(l_colcnt_i), -- Column name
          p_data => l_datevar 
          );
        --
      end if;
    end loop;
  end loop;
  --
  dbms_sql.close_cursor(l_curid);
  --
  /* Returns the generated document. The document is closed and then returned. */
  ploffx_xlsx.getDoc(p_blob_file => l_xls);
  --
  delete from store_blob where filename = 'export1.xlsx';
  --
  insert into store_blob
    (blob_file, created_date, filename)
  values
    (l_xls, sysdate, 'export1.xlsx');
  commit;
  --
end;
