create or replace package DOCX_SDT_MASTERDETAIL is
 -- Required procedure
  procedure genDOCX;
 
  -- Required variable
  v_docx blob;

  -- Master
  cursor c_users is
  SELECT u.USER_ID, u.USERNAME, u.CREATED
  FROM all_users u
  WHERE rownum <= 10;
  
  -- Detail
  cursor c_objects(owner in varchar2) is
  SELECT a.OBJECT_ID, a.OBJECT_NAME, a.OBJECT_TYPE
  FROM all_objects a
  WHERE UPPER(a.OWNER) = UPPER(owner)
  AND rownum <= 10;




  
end DOCX_SDT_MASTERDETAIL;
/
create or replace package body DOCX_SDT_MASTERDETAIL is
/* 2016-JAN-26 11:56 */
/* PL/PDF REPORTER 3.7.0 */
l_paragraph1 pls_integer;
l_text_idx1 pls_integer;
l_table1 pls_integer;
l_row1 pls_integer;
l_borderSide1 ploffx_document_type.CT_Border;
l_border2 ploffx_document_type.CT_TcBorders;
l_cell1 pls_integer;
l_paragraph2 pls_integer;
l_text_idx2 pls_integer;
l_cell2 pls_integer;
l_paragraph3 pls_integer;
l_text_idx3 pls_integer;
l_cell3 pls_integer;
l_paragraph4 pls_integer;
l_text_idx4 pls_integer;
l_row2 pls_integer;
l_cell4 pls_integer;
l_paragraph5 pls_integer;
l_text_idx5 pls_integer;
l_cell5 pls_integer;
l_paragraph6 pls_integer;
l_text_idx6 pls_integer;
l_cell6 pls_integer;
l_paragraph7 pls_integer;
l_text_idx7 pls_integer;

l_table2 pls_integer;
l_paragraph8 pls_integer;
procedure genDOCX is
 begin 
ploffx_docx.init( );
/* START PARAGRAPH */
l_paragraph1 := ploffx_docx.crParagraph();
l_text_idx1 := ploffx_docx.addText( p_paragraph_id => l_paragraph1, p_text => 'Master-Detail with header and footer example');
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph1);
/* START TABLE */
l_table1 := ploffx_docx.crTable( p_width => 0);
for F_USER in C_USERS loop

l_row1 := ploffx_docx.AddRow( p_table_id => l_table1);
l_borderSide1 := ploffx_docx.crBorder(p_style => 'single', p_color => '000000', p_width => 0.353, p_spacing => 0);
l_border2 := ploffx_docx.crCellBorder(p_top => l_borderSide1, p_bottom => l_borderSide1, p_left => l_borderSide1, p_right => l_borderSide1);
l_cell1 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 53.269, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_paragraph2 := ploffx_docx.crParagraph();
l_text_idx2 := ploffx_docx.addText( p_paragraph_id => l_paragraph2, p_text => F_USER.USER_ID);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell1, p_paragraph_id => l_paragraph2);
l_cell2 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 53.287, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_paragraph3 := ploffx_docx.crParagraph();
l_text_idx3 := ploffx_docx.addText( p_paragraph_id => l_paragraph3, p_text => F_USER.USERNAME);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell2, p_paragraph_id => l_paragraph3);
l_cell3 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 53.287, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_paragraph4 := ploffx_docx.crParagraph();
l_text_idx4 := ploffx_docx.addText( p_paragraph_id => l_paragraph4, p_text => F_USER.CREATED);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell3, p_paragraph_id => l_paragraph4);
for F_OBJECT in C_OBJECTS(F_USER.USERNAME) loop

l_row2 := ploffx_docx.AddRow( p_table_id => l_table1);
l_cell4 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 53.269, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_paragraph5 := ploffx_docx.crParagraph();
l_text_idx5 := ploffx_docx.addText( p_paragraph_id => l_paragraph5, p_text => F_OBJECT.OBJECT_ID);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell4, p_paragraph_id => l_paragraph5);
l_cell5 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 53.287, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_paragraph6 := ploffx_docx.crParagraph();
l_text_idx6 := ploffx_docx.addText( p_paragraph_id => l_paragraph6, p_text => F_OBJECT.OBJECT_NAME);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell5, p_paragraph_id => l_paragraph6);
l_cell6 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 53.287, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_paragraph7 := ploffx_docx.crParagraph();
l_text_idx7 := ploffx_docx.addText( p_paragraph_id => l_paragraph7, p_text => F_OBJECT.OBJECT_TYPE);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell6, p_paragraph_id => l_paragraph7);
end loop;

end loop;
l_table2 := ploffx_docx.addTable( p_table_id => l_table1);
/* START PARAGRAPH */
l_paragraph8 := ploffx_docx.crParagraph();
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph8);
ploffx_docx.getDoc( p_blob_file => v_Docx);
end;
end DOCX_SDT_MASTERDETAIL;
/
