create or replace package DOCX_SDT_IMAGE is
 -- Required procedure
  procedure genDOCX;
 
  -- Required variable
  v_docx blob;

    cursor_count pls_integer := 1;
  
    --parameter
  p_order_id number default 7;

  --one reocord table
  cursor c_order(p_ord_id number) is
    select
    ord.order_id order_id,
    cus.cust_first_name || ' ' || cus.cust_last_name cust_name,
    cus.cust_street_address1 cust_street_address1,
    cus.cust_city cust_city,
    sta.state_name cust_state_name,
    cus.cust_postal_code cust_postal_code,
    to_char(ord.order_total) order_total,
    to_char(ord.order_timestamp,'MM-DD-YYYY') order_date
  from demo_orders ord,
       demo_customers cus,
       demo_states sta
  where ord.order_id = p_ord_id
    and ord.customer_id = cus.customer_id
    and cus.cust_state = sta.st;

  --multi record table
  cursor c_order_items(p_ord_id number) is
   select
    oit.order_item_id order_item_id,
    oit.product_id product_id,
    pro.product_name product_name,
    pro.product_image product_image,
    to_char(oit.quantity) quantity,
    to_char(oit.unit_price) unit_price,
    to_char(oit.quantity * oit.unit_price) extended_price
    from demo_order_items oit,
         demo_product_info pro
    where oit.order_id = p_ord_id
      and oit.product_id = pro.product_id
    ;



  
end DOCX_SDT_IMAGE;
/
create or replace package body DOCX_SDT_IMAGE is
/* 2016-JAN-26 11:39 */
/* PL/PDF REPORTER 3.7.0 */
l_table1 pls_integer;
l_row1 pls_integer;
l_borderSide1 ploffx_document_type.CT_Border;
l_border2 ploffx_document_type.CT_TcBorders;
l_cell1 pls_integer;
l_spacing1 ploffx_document_type.CT_Spacing;
l_paragraph1 pls_integer;
l_imageBlob1 blob;
l_image1 pls_integer;
l_cell2 pls_integer;
l_paragraph2 pls_integer;
l_text_idx1 pls_integer;
l_table2 pls_integer;
l_paragraph3 pls_integer;
l_table3 pls_integer;
l_row2 pls_integer;
l_borderSide3 ploffx_document_type.CT_Border;
l_border4 ploffx_document_type.CT_TcBorders;
l_cell3 pls_integer;
l_paragraph4 pls_integer;
l_text_idx2 pls_integer;
l_text_idx3 pls_integer;
l_borderSide5 ploffx_document_type.CT_Border;
l_border6 ploffx_document_type.CT_TcBorders;
l_cell4 pls_integer;
l_paragraph5 pls_integer;
l_text_idx4 pls_integer;
l_row3 pls_integer;
l_border7 ploffx_document_type.CT_TcBorders;
l_cell5 pls_integer;
l_paragraph6 pls_integer;
l_text_idx5 pls_integer;
l_paragraph7 pls_integer;
l_text_idx6 pls_integer;
l_paragraph8 pls_integer;
l_text_idx7 pls_integer;
l_paragraph9 pls_integer;
l_text_idx8 pls_integer;
l_border8 ploffx_document_type.CT_TcBorders;
l_cell6 pls_integer;
l_paragraph10 pls_integer;
l_text_idx9 pls_integer;
l_text_idx10 pls_integer;
l_paragraph11 pls_integer;
l_text_idx11 pls_integer;
l_text_idx12 pls_integer;
l_paragraph12 pls_integer;
l_text_idx13 pls_integer;
l_text_idx14 pls_integer;
l_paragraph13 pls_integer;
l_text_idx15 pls_integer;
l_text_idx16 pls_integer;
l_paragraph14 pls_integer;
l_text_idx17 pls_integer;
l_text_idx18 pls_integer;
l_table4 pls_integer;
l_paragraph15 pls_integer;
l_paragraph16 pls_integer;
l_text_idx19 pls_integer;
l_table5 pls_integer;
l_row4 pls_integer;
l_border9 ploffx_document_type.CT_TcBorders;
l_cell7 pls_integer;
l_paragraph17 pls_integer;
l_text_idx20 pls_integer;
l_cell8 pls_integer;
l_paragraph18 pls_integer;
l_text_idx21 pls_integer;
l_cell9 pls_integer;
l_paragraph19 pls_integer;
l_text_idx22 pls_integer;
l_cell10 pls_integer;
l_paragraph20 pls_integer;
l_text_idx23 pls_integer;
l_cell11 pls_integer;
l_paragraph21 pls_integer;
l_text_idx24 pls_integer;
l_cell12 pls_integer;
l_paragraph22 pls_integer;
l_text_idx25 pls_integer;
l_cell13 pls_integer;
l_paragraph23 pls_integer;
l_text_idx26 pls_integer;
l_row5 pls_integer;
l_cell14 pls_integer;
l_paragraph24 pls_integer;
l_text_idx27 pls_integer;
l_cell15 pls_integer;
l_paragraph25 pls_integer;
l_text_idx28 pls_integer;
l_cell16 pls_integer;
l_paragraph26 pls_integer;
l_text_idx29 pls_integer;
l_cell17 pls_integer;
l_paragraph27 pls_integer;
l_image2 pls_integer;
l_cell18 pls_integer;
l_spacing2 ploffx_document_type.CT_Spacing;
l_paragraph28 pls_integer;
l_text_idx30 pls_integer;
l_cell19 pls_integer;
l_paragraph29 pls_integer;
l_text_idx31 pls_integer;
l_cell20 pls_integer;
l_paragraph30 pls_integer;
l_text_idx32 pls_integer;
l_table6 pls_integer;
l_spacing3 ploffx_document_type.CT_Spacing;
l_paragraph31 pls_integer;
l_text_idx33 pls_integer;
l_table7 pls_integer;
l_row6 pls_integer;
l_cell21 pls_integer;
l_paragraph32 pls_integer;
l_text_idx34 pls_integer;
l_cell22 pls_integer;
l_paragraph33 pls_integer;
l_text_idx35 pls_integer;
l_cell23 pls_integer;
l_paragraph34 pls_integer;
l_text_idx36 pls_integer;
l_row7 pls_integer;
l_cell24 pls_integer;
l_paragraph35 pls_integer;
l_text_idx37 pls_integer;
l_cell25 pls_integer;
l_paragraph36 pls_integer;
l_text_idx38 pls_integer;
l_cell26 pls_integer;
l_paragraph37 pls_integer;
l_text_idx39 pls_integer;
l_table8 pls_integer;
l_paragraph38 pls_integer;
function image_util( 
p_name varchar2
) return blob is
l_ret blob;
begin 
SELECT IMAGE_FILE INTO l_ret FROM PLPDF_REPORTER_IMAGE WHERE FILENAME = p_name;
return l_ret;
end;
procedure genDOCX is
 begin 
ploffx_docx.init( );
/* START TABLE */
l_table1 := ploffx_docx.crTable( p_width => 0);
l_row1 := ploffx_docx.AddRow( p_table_id => l_table1);
l_borderSide1 := ploffx_docx.crBorder(p_style => 'nil');
l_border2 := ploffx_docx.crCellBorder(p_top => l_borderSide1, p_bottom => l_borderSide1, p_left => l_borderSide1, p_right => l_borderSide1);
l_cell1 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 34.413, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_spacing1 := ploffx_docx.crSpacing(p_after => 18);
l_paragraph1 := ploffx_docx.crParagraph(p_alignment => 'left', p_spacing => l_spacing1);
l_imageBlob1 := image_util( p_name => 'image2.jpeg');
l_image1 := ploffx_docx.addInlineImage( p_paragraph_id => l_paragraph1, p_name => 'image2.jpeg', p_file => l_imageBlob1, p_width => 21, p_height => 21);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell1, p_paragraph_id => l_paragraph1);
l_cell2 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 128.076, p_cellBorder => l_border2);
/* START PARAGRAPH */
l_paragraph2 := ploffx_docx.crParagraph(p_alignment => 'left', p_spacing => l_spacing1);
l_text_idx1 := ploffx_docx.addText( p_paragraph_id => l_paragraph2, p_text => 'ORDER REPORT', p_italic => true, p_fontSize => 42);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell2, p_paragraph_id => l_paragraph2);
l_table2 := ploffx_docx.addTable( p_table_id => l_table1);
/* START PARAGRAPH */
l_paragraph3 := ploffx_docx.crParagraph(p_alignment => 'left', p_spacing => l_spacing1);
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph3);
/* START TABLE */
l_table3 := ploffx_docx.crTable( p_width => 0);
ploffx_docx.setTableBorders( p_table_id => l_table3, p_style => 'single', p_width => 0.088, p_space => 0, p_color => 'auto');
l_row2 := ploffx_docx.AddRow( p_table_id => l_table3);
l_borderSide3 := ploffx_docx.crBorder(p_style => 'single', p_color => 'auto', p_width => 0.088, p_spacing => 0);
l_border4 := ploffx_docx.crCellBorder(p_top => l_borderSide3, p_bottom => l_borderSide3, p_right => l_borderSide3);
l_cell3 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 81.245, p_cellBorder => l_border4, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph4 := ploffx_docx.crParagraph();
l_text_idx2 := ploffx_docx.addText( p_paragraph_id => l_paragraph4, p_text => 'Supplier', p_italic => true, p_fontSize => 16);
l_text_idx3 := ploffx_docx.addText( p_paragraph_id => l_paragraph4, p_text => ':', p_italic => true, p_fontSize => 14);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell3, p_paragraph_id => l_paragraph4);
l_borderSide5 := ploffx_docx.crBorder(p_style => 'single', p_color => 'auto', p_width => 0.176, p_spacing => 0);
l_border6 := ploffx_docx.crCellBorder(p_top => l_borderSide3, p_bottom => l_borderSide5, p_left => l_borderSide3);
l_cell4 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 81.245, p_cellBorder => l_border6, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph5 := ploffx_docx.crParagraph();
l_text_idx4 := ploffx_docx.addText( p_paragraph_id => l_paragraph5, p_text => ' Buyer:');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell4, p_paragraph_id => l_paragraph5);
for F_ORDER in C_ORDER(p_order_id) loop

l_row3 := ploffx_docx.AddRow( p_table_id => l_table3, p_height => 36.724);
l_border7 := ploffx_docx.crCellBorder(p_top => l_borderSide3, p_bottom => l_borderSide3, p_left => l_borderSide3, p_right => l_borderSide5);
l_cell5 := ploffx_docx.AddCell( p_row_id => l_row3, p_width => 81.245, p_cellBorder => l_border7);
/* START PARAGRAPH */
l_paragraph6 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx5 := ploffx_docx.addText( p_paragraph_id => l_paragraph6, p_text => 'Name:                    Clothing co.');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell5, p_paragraph_id => l_paragraph6);
/* START PARAGRAPH */
l_paragraph7 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx6 := ploffx_docx.addText( p_paragraph_id => l_paragraph7, p_text => 'Address:                80 Rue Armand Carrel');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell5, p_paragraph_id => l_paragraph7);
/* START PARAGRAPH */
l_paragraph8 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx7 := ploffx_docx.addText( p_paragraph_id => l_paragraph8, p_text => '                               Paris ');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell5, p_paragraph_id => l_paragraph8);
/* START PARAGRAPH */
l_paragraph9 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx8 := ploffx_docx.addText( p_paragraph_id => l_paragraph9, p_text => '                               75019');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell5, p_paragraph_id => l_paragraph9);
l_border8 := ploffx_docx.crCellBorder(p_top => l_borderSide5, p_bottom => l_borderSide3, p_left => l_borderSide5, p_right => l_borderSide5);
l_cell6 := ploffx_docx.AddCell( p_row_id => l_row3, p_width => 81.245, p_cellBorder => l_border8);
/* START PARAGRAPH */
l_paragraph10 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx9 := ploffx_docx.addText( p_paragraph_id => l_paragraph10, p_text => 'Name                    ');
l_text_idx10 := ploffx_docx.addText( p_paragraph_id => l_paragraph10, p_text => F_ORDER.cust_name);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell6, p_paragraph_id => l_paragraph10);
/* START PARAGRAPH */
l_paragraph11 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx11 := ploffx_docx.addText( p_paragraph_id => l_paragraph11, p_text => 'Address:               ');
l_text_idx12 := ploffx_docx.addText( p_paragraph_id => l_paragraph11, p_text => F_ORDER.cust_street_address1);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell6, p_paragraph_id => l_paragraph11);
/* START PARAGRAPH */
l_paragraph12 := ploffx_docx.crParagraph();
l_text_idx13 := ploffx_docx.addText( p_paragraph_id => l_paragraph12, p_text => '                              ');
l_text_idx14 := ploffx_docx.addText( p_paragraph_id => l_paragraph12, p_text => F_ORDER.cust_city);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell6, p_paragraph_id => l_paragraph12);
/* START PARAGRAPH */
l_paragraph13 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx15 := ploffx_docx.addText( p_paragraph_id => l_paragraph13, p_text => '                              ');
l_text_idx16 := ploffx_docx.addText( p_paragraph_id => l_paragraph13, p_text => F_ORDER.cust_state_name);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell6, p_paragraph_id => l_paragraph13);
/* START PARAGRAPH */
l_paragraph14 := ploffx_docx.crParagraph();
l_text_idx17 := ploffx_docx.addText( p_paragraph_id => l_paragraph14, p_text => '                              ');
l_text_idx18 := ploffx_docx.addText( p_paragraph_id => l_paragraph14, p_text => F_ORDER.cust_postal_code);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell6, p_paragraph_id => l_paragraph14);
end loop;
l_table4 := ploffx_docx.addTable( p_table_id => l_table3);
/* START PARAGRAPH */
l_paragraph15 := ploffx_docx.crParagraph();
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph15);
/* START PARAGRAPH */
l_paragraph16 := ploffx_docx.crParagraph();
l_text_idx19 := ploffx_docx.addText( p_paragraph_id => l_paragraph16, p_text => 'Order details', p_bold => true, p_fontSize => 18);
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph16);
/* START TABLE */
l_table5 := ploffx_docx.crTable( p_width => 164.888);
l_row4 := ploffx_docx.AddRow( p_table_id => l_table5, p_height => 4.180);
l_border9 := ploffx_docx.crCellBorder(p_top => l_borderSide3, p_bottom => l_borderSide3, p_left => l_borderSide3, p_right => l_borderSide3);
l_cell7 := ploffx_docx.AddCell( p_row_id => l_row4, p_width => 14.605, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph17 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx20 := ploffx_docx.addText( p_paragraph_id => l_paragraph17, p_text => 'Order ID', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell7, p_paragraph_id => l_paragraph17);
l_cell8 := ploffx_docx.AddCell( p_row_id => l_row4, p_width => 19.050, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph18 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx21 := ploffx_docx.addText( p_paragraph_id => l_paragraph18, p_text => 'Product ID', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell8, p_paragraph_id => l_paragraph18);
l_cell9 := ploffx_docx.AddCell( p_row_id => l_row4, p_width => 19.897, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph19 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx22 := ploffx_docx.addText( p_paragraph_id => l_paragraph19, p_text => 'Product name', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell9, p_paragraph_id => l_paragraph19);
l_cell10 := ploffx_docx.AddCell( p_row_id => l_row4, p_width => 30.797, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph20 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx23 := ploffx_docx.addText( p_paragraph_id => l_paragraph20, p_text => 'Product Image', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell10, p_paragraph_id => l_paragraph20);
l_cell11 := ploffx_docx.AddCell( p_row_id => l_row4, p_width => 27.129, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph21 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx24 := ploffx_docx.addText( p_paragraph_id => l_paragraph21, p_text => 'Quantity', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell11, p_paragraph_id => l_paragraph21);
l_cell12 := ploffx_docx.AddCell( p_row_id => l_row4, p_width => 21.661, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph22 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx25 := ploffx_docx.addText( p_paragraph_id => l_paragraph22, p_text => 'Unit Price', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell12, p_paragraph_id => l_paragraph22);
l_cell13 := ploffx_docx.AddCell( p_row_id => l_row4, p_width => 31.750, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph23 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx26 := ploffx_docx.addText( p_paragraph_id => l_paragraph23, p_text => 'Extended Price', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell13, p_paragraph_id => l_paragraph23);
for F_ITEM in c_order_items(p_order_id) loop

l_row5 := ploffx_docx.AddRow( p_table_id => l_table5, p_height => 41.857);
l_cell14 := ploffx_docx.AddCell( p_row_id => l_row5, p_width => 14.605, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph24 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx27 := ploffx_docx.addText( p_paragraph_id => l_paragraph24, p_text => F_ITEM.order_item_id);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell14, p_paragraph_id => l_paragraph24);
l_cell15 := ploffx_docx.AddCell( p_row_id => l_row5, p_width => 19.050, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph25 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx28 := ploffx_docx.addText( p_paragraph_id => l_paragraph25, p_text => F_ITEM.product_id);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell15, p_paragraph_id => l_paragraph25);
l_cell16 := ploffx_docx.AddCell( p_row_id => l_row5, p_width => 19.897, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph26 := ploffx_docx.crParagraph();
l_text_idx29 := ploffx_docx.addText( p_paragraph_id => l_paragraph26, p_text => F_ITEM.product_name);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell16, p_paragraph_id => l_paragraph26);
l_cell17 := ploffx_docx.AddCell( p_row_id => l_row5, p_width => 30.797, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph27 := ploffx_docx.crParagraph(p_alignment => 'center');
l_image2 := ploffx_docx.addInlineImage( p_paragraph_id => l_paragraph27, p_file => F_ITEM.product_image, p_width => 27, p_height => 27);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell17, p_paragraph_id => l_paragraph27);
l_cell18 := ploffx_docx.AddCell( p_row_id => l_row5, p_width => 27.129, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_spacing2 := ploffx_docx.crSpacing(p_after => 10, p_linespace => 1.150);
l_paragraph28 := ploffx_docx.crParagraph(p_alignment => 'center', p_spacing => l_spacing2);
l_text_idx30 := ploffx_docx.addText( p_paragraph_id => l_paragraph28, p_text => F_ITEM.quantity);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell18, p_paragraph_id => l_paragraph28);
l_cell19 := ploffx_docx.AddCell( p_row_id => l_row5, p_width => 21.661, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph29 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx31 := ploffx_docx.addText( p_paragraph_id => l_paragraph29, p_text => F_ITEM.unit_price);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell19, p_paragraph_id => l_paragraph29);
l_cell20 := ploffx_docx.AddCell( p_row_id => l_row5, p_width => 31.750, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph30 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx32 := ploffx_docx.addText( p_paragraph_id => l_paragraph30, p_text => F_ITEM.extended_price);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell20, p_paragraph_id => l_paragraph30);
end loop;
l_table6 := ploffx_docx.addTable( p_table_id => l_table5);
/* START PARAGRAPH */
l_spacing3 := ploffx_docx.crSpacing(p_before => 18);
l_paragraph31 := ploffx_docx.crParagraph(p_alignment => 'right', p_spacing => l_spacing3);
l_text_idx33 := ploffx_docx.addText( p_paragraph_id => l_paragraph31, p_text => 'Order', p_bold => true, p_fontSize => 18);
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph31);
/* START TABLE */
l_table7 := ploffx_docx.crTable( p_width => 64.558, p_alignment => 'right');
l_row6 := ploffx_docx.AddRow( p_table_id => l_table7, p_alignment => 'right', p_height => 4.180);
l_cell21 := ploffx_docx.AddCell( p_row_id => l_row6, p_width => 21.484, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph32 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx34 := ploffx_docx.addText( p_paragraph_id => l_paragraph32, p_text => 'No.', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell21, p_paragraph_id => l_paragraph32);
l_cell22 := ploffx_docx.AddCell( p_row_id => l_row6, p_width => 21.502, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph33 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx35 := ploffx_docx.addText( p_paragraph_id => l_paragraph33, p_text => 'Total order', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell22, p_paragraph_id => l_paragraph33);
l_cell23 := ploffx_docx.AddCell( p_row_id => l_row6, p_width => 21.572, p_cellBorder => l_border9, p_background => '33CC33');
/* START PARAGRAPH */
l_paragraph34 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx36 := ploffx_docx.addText( p_paragraph_id => l_paragraph34, p_text => 'Order date', p_bold => true);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell23, p_paragraph_id => l_paragraph34);
for F_ORDER in C_ORDER(p_order_id) loop

l_row7 := ploffx_docx.AddRow( p_table_id => l_table7, p_alignment => 'right', p_height => 13.229);
l_cell24 := ploffx_docx.AddCell( p_row_id => l_row7, p_width => 21.484, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph35 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx37 := ploffx_docx.addText( p_paragraph_id => l_paragraph35, p_text => F_ORDER.order_id);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell24, p_paragraph_id => l_paragraph35);
l_cell25 := ploffx_docx.AddCell( p_row_id => l_row7, p_width => 21.502, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph36 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx38 := ploffx_docx.addText( p_paragraph_id => l_paragraph36, p_text => F_ORDER.order_total);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell25, p_paragraph_id => l_paragraph36);
l_cell26 := ploffx_docx.AddCell( p_row_id => l_row7, p_width => 21.572, p_cellBorder => l_border9);
/* START PARAGRAPH */
l_paragraph37 := ploffx_docx.crParagraph(p_alignment => 'left');
l_text_idx39 := ploffx_docx.addText( p_paragraph_id => l_paragraph37, p_text => F_ORDER.order_date);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell26, p_paragraph_id => l_paragraph37);
end loop;
l_table8 := ploffx_docx.addTable( p_table_id => l_table7);
/* START PARAGRAPH */
l_paragraph38 := ploffx_docx.crParagraph(p_alignment => 'left', p_spacing => l_spacing3);
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph38);
ploffx_docx.getDoc( p_blob_file => v_Docx);
end;
end DOCX_SDT_IMAGE;
/
