create or replace package DOCX_SDT_COLUMN_GROUP is
 -- Required procedure
  procedure genDOCX;
 
  -- Required variable
  v_docx blob;

  cursor c_sample is
  select rownum, owner, object_name from all_objects where rownum <= 100;
  
end DOCX_SDT_COLUMN_GROUP;
/
create or replace package body DOCX_SDT_COLUMN_GROUP is
/* 2016-JAN-26 11:18 */
/* PL/PDF REPORTER 3.7.0 */
l_spacing1 ploffx_document_type.CT_Spacing;
l_paragraph1 pls_integer;
l_text_idx1 pls_integer;
l_table1 pls_integer;
l_row1 pls_integer;
l_borderSide1 ploffx_document_type.CT_Border;
l_borderSide2 ploffx_document_type.CT_Border;
l_border3 ploffx_document_type.CT_TcBorders;
l_cell1 pls_integer;
l_paragraph2 pls_integer;
l_text_idx2 pls_integer;
l_border4 ploffx_document_type.CT_TcBorders;
l_cell2 pls_integer;
l_paragraph3 pls_integer;
l_text_idx3 pls_integer;
l_cell3 pls_integer;
l_paragraph4 pls_integer;
l_text_idx4 pls_integer;
l_row2 pls_integer;
l_cell4 pls_integer;
l_paragraph5 pls_integer;
l_text_idx5 pls_integer;
l_cell5 pls_integer;
l_paragraph6 pls_integer;
l_text_idx6 pls_integer;
l_cell6 pls_integer;
l_paragraph7 pls_integer;
l_text_idx7 pls_integer;
l_table2 pls_integer;
l_paragraph8 pls_integer;
procedure genDOCX is
 begin 
ploffx_docx.init( );
/* START PARAGRAPH */
l_spacing1 := ploffx_docx.crSpacing(p_after => 12);
l_paragraph1 := ploffx_docx.crParagraph(p_spacing => l_spacing1);
l_text_idx1 := ploffx_docx.addText( p_paragraph_id => l_paragraph1, p_text => 'Mixed GROUP and COLUMN example!');
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph1);
/* START TABLE */
l_table1 := ploffx_docx.crTable( p_width => 0);
l_row1 := ploffx_docx.AddRow( p_table_id => l_table1);
l_borderSide1 := ploffx_docx.crBorder(p_style => 'single', p_color => '000000', p_width => 0.353, p_spacing => 0);
l_borderSide2 := ploffx_docx.crBorder(p_style => 'single', p_color => 'auto', p_width => 0.353, p_spacing => 0);
l_border3 := ploffx_docx.crCellBorder(p_top => l_borderSide1, p_bottom => l_borderSide2, p_left => l_borderSide1, p_right => l_borderSide2);
l_cell1 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 53.269, p_cellBorder => l_border3);
/* START PARAGRAPH */
l_paragraph2 := ploffx_docx.crParagraph();
l_text_idx2 := ploffx_docx.addText( p_paragraph_id => l_paragraph2, p_text => 'Rownum');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell1, p_paragraph_id => l_paragraph2);
l_border4 := ploffx_docx.crCellBorder(p_top => l_borderSide2, p_bottom => l_borderSide2, p_left => l_borderSide2, p_right => l_borderSide2);
l_cell2 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 53.287, p_cellBorder => l_border4);
/* START PARAGRAPH */
l_paragraph3 := ploffx_docx.crParagraph();
l_text_idx3 := ploffx_docx.addText( p_paragraph_id => l_paragraph3, p_text => 'Owner');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell2, p_paragraph_id => l_paragraph3);
l_cell3 := ploffx_docx.AddCell( p_row_id => l_row1, p_width => 53.287, p_cellBorder => l_border4);
/* START PARAGRAPH */
l_paragraph4 := ploffx_docx.crParagraph();
l_text_idx4 := ploffx_docx.addText( p_paragraph_id => l_paragraph4, p_text => 'Object name');
ploffx_docx.TableAddParagraph( p_cell_id => l_cell3, p_paragraph_id => l_paragraph4);
for F_SAMPLE in C_SAMPLE loop

l_row2 := ploffx_docx.AddRow( p_table_id => l_table1);
l_cell4 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 53.269, p_cellBorder => l_border4);
/* START PARAGRAPH */
l_paragraph5 := ploffx_docx.crParagraph();
l_text_idx5 := ploffx_docx.addText( p_paragraph_id => l_paragraph5, p_text => F_SAMPLE.ROWNUM);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell4, p_paragraph_id => l_paragraph5);
l_cell5 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 53.287, p_cellBorder => l_border4);
/* START PARAGRAPH */
l_paragraph6 := ploffx_docx.crParagraph();
l_text_idx6 := ploffx_docx.addText( p_paragraph_id => l_paragraph6, p_text => F_SAMPLE.OWNER);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell5, p_paragraph_id => l_paragraph6);
l_cell6 := ploffx_docx.AddCell( p_row_id => l_row2, p_width => 53.287, p_cellBorder => l_border4);
/* START PARAGRAPH */
l_paragraph7 := ploffx_docx.crParagraph();
l_text_idx7 := ploffx_docx.addText( p_paragraph_id => l_paragraph7, p_text => F_SAMPLE.OBJECT_NAME);
ploffx_docx.TableAddParagraph( p_cell_id => l_cell6, p_paragraph_id => l_paragraph7);
end loop;
l_table2 := ploffx_docx.addTable( p_table_id => l_table1);
/* START PARAGRAPH */
l_paragraph8 := ploffx_docx.crParagraph();
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph8);
ploffx_docx.getDoc( p_blob_file => v_Docx);
end;
end DOCX_SDT_COLUMN_GROUP;
/
