create or replace package DOCX_SDT_CODE is
    -- Required procedure
  procedure genDOCX;
 
  -- Required variable
  v_docx blob;
  
  cursor_count pls_integer := 1;
  
    --parameter
  p_order_id number default 7;

  --one reocord table
  cursor c_order(p_ord_id number) is
    select
    ord.order_id order_id,
    cus.cust_first_name || ' ' || cus.cust_last_name cust_name,
    cus.cust_street_address1 cust_street_address1,
    cus.cust_city cust_city,
    sta.state_name cust_state_name,
    cus.cust_postal_code cust_postal_code,
    to_char(ord.order_total) order_total,
    to_char(ord.order_timestamp,'MM-DD-YYYY') order_date
  from demo_orders ord,
       demo_customers cus,
       demo_states sta
  where ord.order_id = p_ord_id
    and ord.customer_id = cus.customer_id
    and cus.cust_state = sta.st;

  --multi record table
  cursor c_order_items(p_ord_id number) is
   select
    oit.order_item_id order_item_id,
    oit.product_id product_id,
    pro.product_name product_name,
    to_char(oit.quantity) quantity,
    to_char(oit.unit_price) unit_price,
    to_char(oit.quantity * oit.unit_price) extended_price
    from demo_order_items oit,
         demo_product_info pro
    where oit.order_id = p_ord_id
      and oit.product_id = pro.product_id
    ;


  
end DOCX_SDT_CODE;
/
create or replace package body DOCX_SDT_CODE is
/* 2016-JAN-26 11:09 */
/* PL/PDF REPORTER 3.7.0 */
l_paragraph1 pls_integer;
l_text_idx1 pls_integer;
l_paragraph2 pls_integer;
l_paragraph3 pls_integer;
l_text_idx2 pls_integer;
l_paragraph4 pls_integer;
l_text_idx3 pls_integer;
procedure genDOCX is
 begin 
ploffx_docx.init( );
dbms_output.put_line('This code contains sdt:code controller');
/* START PARAGRAPH */
l_paragraph1 := ploffx_docx.crParagraph(p_alignment => 'center');
l_text_idx1 := ploffx_docx.addText( p_paragraph_id => l_paragraph1, p_text => ' ', p_fontSize => 10);
/* START PARAGRAPH */
l_paragraph2 := ploffx_docx.crParagraph();
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph2);
/* START PARAGRAPH */
l_paragraph3 := ploffx_docx.crParagraph();
l_text_idx2 := ploffx_docx.addText( p_paragraph_id => l_paragraph3, p_text => 'The sharing operation is finished when the document is saved by the recipient and the document can no longer be accessed via the URL. Additional mechanisms, such as password protection, protect the user and data from misuse. It is also possible to scan a 3D barcode and call the document to be signed.', p_fontSize => 10);
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph3);
/* START PARAGRAPH */
l_paragraph4 := ploffx_docx.crParagraph();
l_text_idx3 := ploffx_docx.addText( p_paragraph_id => l_paragraph4, p_text => 'The sharing operation is finished when the document is saved by the recipient and the document can no longer be accessed via the URL. Additional mechanisms, such as password protection, protect the user and data from misuse. It is also possible to scan a 3D barcode and call the document to be signed.', p_fontSize => 10);
ploffx_docx.addParagraph(p_paragraph_id => l_paragraph4);
ploffx_docx.getDoc( p_blob_file => v_Docx);
end;
end DOCX_SDT_CODE;
/
