/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;

public class CMSProcessableBodyPartInbound
implements CMSProcessable {
    private BodyPart bodyPart;
    private byte[] buf = new byte[4];
    private String defaultContentTransferEncoding = "7bit";

    public CMSProcessableBodyPartInbound(BodyPart bodyPart) {
        this.bodyPart = bodyPart;
    }

    public CMSProcessableBodyPartInbound(BodyPart bodyPart, String string) {
        this.bodyPart = bodyPart;
        this.defaultContentTransferEncoding = string;
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        try {
            if (this.bodyPart instanceof MimeBodyPart) {
                MimeBodyPart mimeBodyPart = (MimeBodyPart)this.bodyPart;
                String[] stringArray = mimeBodyPart.getHeader("Content-Transfer-Encoding");
                String string = stringArray == null ? this.defaultContentTransferEncoding : stringArray[0];
                if (!string.equalsIgnoreCase("base64") && !string.equalsIgnoreCase("quoted-printable")) {
                    if (!string.equalsIgnoreCase("binary")) {
                        outputStream = new CRLFOutputStream(outputStream);
                    }
                    this.bodyPart.writeTo(outputStream);
                    outputStream.flush();
                    return;
                }
                LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
                Object object = mimeBodyPart.getAllHeaderLines();
                while (object.hasMoreElements()) {
                    lineOutputStream.writeln((String)object.nextElement());
                }
                lineOutputStream.writeln();
                lineOutputStream.flush();
                object = mimeBodyPart.getRawInputStream();
                CRLFOutputStream cRLFOutputStream = new CRLFOutputStream(outputStream);
                int n = 0;
                while ((n = ((InputStream)object).read(this.buf, 0, this.buf.length)) > 0) {
                    cRLFOutputStream.write(this.buf, 0, n);
                }
                cRLFOutputStream.flush();
            } else {
                if (!this.defaultContentTransferEncoding.equalsIgnoreCase("binary")) {
                    outputStream = new CRLFOutputStream(outputStream);
                }
                this.bodyPart.writeTo((OutputStream)new CRLFOutputStream(outputStream));
            }
        }
        catch (MessagingException messagingException) {
            throw new CMSException("can't write BodyPart to stream.", (Exception)((Object)messagingException));
        }
    }

    public Object getContent() {
        return this.bodyPart;
    }

    private static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeln(String string) throws MessagingException {
            try {
                byte[] byArray = LineOutputStream.getBytes(string);
                this.out.write(byArray);
                this.out.write(newline);
                return;
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
                return;
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        private static byte[] getBytes(String string) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)cArray[n2++];
            }
            return byArray;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }
}

