declare
  l_certkey varchar2(255 char);
  l_defenc varchar2(255 char); 
  l_nl varchar2(1 char) := CHR(10);
  --
  function GetCertVal(
    p_func varchar2
	) return varchar2 is
	l_ret varchar2(255 char);
  begin
    begin
      execute immediate 'select plpdf_cert.' || p_func || ' from dual' into l_ret; 
	exception 
      when others then
        null;
	end;  
	return l_ret;
  end;  
  --
  
begin
  l_certkey := nvl(GetCertVal('setcertkey'),'TRIAL');
  l_defenc := nvl(GetCertVal('GetDefaultEncoding'),'cp1252');
  
  execute immediate 
    'create or replace package plpdf_cert is ' || l_nl ||
    '  function setcertkey ' || l_nl ||
    '    return varchar2; ' || l_nl ||
    '  function GetDefaultEncoding ' || l_nl ||
    '    return varchar2; ' || l_nl ||
    'end;';
  
  execute immediate 
    'create or replace package body plpdf_cert is ' || l_nl ||
    '  function setcertkey ' || l_nl ||
    '    return varchar2 is ' || l_nl ||
    '  begin ' || l_nl ||
    '      return ''' || l_certkey || '''; ' || l_nl ||
    '  end; ' || l_nl ||
    '  function GetDefaultEncoding ' || l_nl || 
	'    return varchar2 is ' || l_nl ||
    '  begin ' || l_nl ||
    '    return ''' || l_defenc || '''; ' || l_nl ||
    '  end; ' || l_nl ||
    'end;';
  
end;
/