create or replace package plpdf_text2 is
  --v2.9.2
--------------------------------------------------
  c_text_type varchar2(10 char) := 'SINGLE';
  c_se varchar2(1 char) := '('; -- start_encloser
  c_ee varchar2(1 char) := ')'; -- end_encloser
  v_encoding  varchar2(20 char); --v2.7.0
---------------------------------------------------------------------------------------------------
function xescape(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function tohex(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function tohex_false(
  p_s varchar2
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function cast_to_varchar2(
  p_s raw
  ) return varchar2;
---------------------------------------------------------------------------------------------------
function cast_to_raw(
  p_s varchar2
  ) return raw;
---------------------------------------------------------------------------------------------------
function ascii1(
  p_s varchar2
  ) return number;
---------------------------------------------------------------------------------------------------
-- mod: v2.3.1
function replace_blob(
  p_blob in out nocopy blob,
  p_from varchar2,
  p_to varchar2,
  p_from2 varchar2 default null,
  p_to2 varchar2 default null,
  p_from3 varchar2 default null,
  p_to3 varchar2 default null
  ) return blob;
---------------------------------------------------------------------------------------------------
procedure repl_init(
  p_enc varchar2 default 'cp1252'
  );
---------------------------------------------------------------------------------------------------
--v2.7.0
function GetTextWidth_J(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw,
  p_fontsize number
  ) return number;
--
function GetTextWidth_KC(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw,
  p_fontsize number
  ) return number;
--
function GetTextWidth_1(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw,
  p_fontsize number
  ) return number;
--
--v2.7.0
function RemoveMissingChars_1(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw
  ) return varchar2;
--
--v2.7.0
function RemoveMissingChars_CJK(
  p_s varchar2,
  p_cw in out nocopy plpdf_type.t_cw
  ) return varchar2;
--
function textstringASCII(
  p_s varchar2,
  p_n number default null
  ) return varchar2;
--
function textstringHEX(
  p_s varchar2,
  p_n number default null
  ) return varchar2;
--v2.9.4
function textstringHEXonlyASCII(
  p_s varchar2,
  p_n pls_integer default null
  ) return varchar2;
--v2.9.0
function TextSplit(
  p_txt varchar2,
  p_w number,
  p_indent number default null,
  p_margins number default 0,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

--v2.9.0
function TextSplitFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt varchar2,
  p_w number,
  p_indent number default null,
  p_margins number default 0,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

--v2.9.2
function TextSplit_CLOB(
  p_txt clob,
  p_w number,
  p_indent number default null,
  p_margins number default 0,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

--v2.9.2
function TextSplitFont_CLOB(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt clob,
  p_w number,
  p_indent number default null,
  p_margins number default 0,
  p_maxline number default 0 --v2.3.0
  ) return plpdf_type.t_text_lines;

end plpdf_text2;
/

