create or replace package plpdf_parser is
--v2.7.0
---------------------------------------------------------------------------------------------------
-- mod:v1.7.0
  type t_fullprep_obj is record (
    obj number,
    gen number,
    offset number,
    obj_vals plpdf_type.t_obj_vals
    );

  type t_fullprep_objs is table of t_fullprep_obj index by pls_integer;

  type t_fullprep_pdf is record (
    pdf_blob blob,
    PDFVersion varchar2(3 char),
    last_obj number,
    objs t_fullprep_objs,
    root_ref plpdf_type.t_obj_ref,
    info_ref plpdf_type.t_obj_ref
    );
---------------------------------------------------------------------------------------------------
 -- "Off"/"Yes"
 checkbox_off constant varchar2(3 char) := 'Off';
 checkbox_on constant varchar2(3 char) := 'Yes';
---------------------------------------------------------------------------------------------------
--v2.7.0
-- Template
  type t_obj_ref_change_g is table of plpdf_type.t_obj_ref index by pls_integer;
  type t_obj_ref_change_i is table of t_obj_ref_change_g index by pls_integer;
  type tr_template is record (
    n number,
    stream_filter plpdf_type.v2avg,
    stream_blob blob,
    box_char plpdf_type.v2avg,
    res number,
    stream_length number,
    x number,
    y number,
    w number,
    h number,
    d_obj_refs plpdf_type.t_d_obj_refs,
    obj_ref_change t_obj_ref_change_i,
    res_obj_obj number,
    res_obj_gen number,
    res_obj_id number,
    obj_vals plpdf_type.t_obj_vals_i
    );
  type t_template is table of tr_template index by pls_integer;
--
---------------------------------------------------------------------------------------------------
function GetTemplate(
  p_blob blob,
  p_page_id number
  ) return plpdf_type.tr_tpl_data;

procedure SaveTemplate(
  p_id number,
  p_tpl plpdf_type.tr_tpl_data,
  p_descr varchar2 default null,
  p_commit boolean default true
  );

function LoadTemplate(
  p_id number
  ) return plpdf_type.tr_tpl_data;

function TemplateRecExists(
  p_id number
  ) return boolean;

procedure DeleteTemplate(
  p_id number,
  p_commit boolean default true
  );

procedure GenerateTemplate(
  p_id number,
  p_descr varchar2 default null,
  p_commit boolean default true
  );

procedure RemoveGenerated(
  p_id number,
  p_commit boolean default true
  );

-- v:1.4.1
function GetBox(
  p_tpl plpdf_type.tr_tpl_data
  ) return plpdf_type.t_pageformat;

-- mod: v1.6.0
function GetPdfFieldsInfo(
  p_blob blob
  ) return plpdf_type.t_form_fields;

-- mod: v1.6.0
function GetPrepFormPDF(
  p_blob blob
  ) return plpdf_type.t_prepform;

--mod:v1.6.0
function GetPDFValue(
  p_utf16_text varchar2,
  p_bom boolean default true
  ) return varchar2;

--mod:v1.6.0
function PrepFormFieldExist(
  p_prepform in out plpdf_type.t_prepform,
  p_obj number,
  p_gen number
  ) return boolean;

--mod:v1.6.0
function PrepFormFieldExist(
  p_prepform in out plpdf_type.t_prepform,
  p_field_name varchar2
  ) return boolean;

--mod:v1.6.0
function SetPrepFormFieldValue(
  p_prepform in out plpdf_type.t_prepform,
  p_obj number,
  p_gen number,
  p_value varchar2 -- text, have to convert val_type string
  ) return boolean;

-- mod: v1.6.0
procedure SetPrepFormFieldValue(
  p_prepform in out plpdf_type.t_prepform,
  p_obj number,
  p_gen number,
  p_value varchar2
  );

--mod:v1.6.0
function SetPrepFormFieldValue(
  p_prepform in out plpdf_type.t_prepform,
  p_field_name varchar2,
  p_value varchar2 -- text, have to convert val_type string
  ) return boolean;

-- mod: v1.6.0
procedure SetPrepFormFieldValue(
  p_prepform in out plpdf_type.t_prepform,
  p_field_name varchar2,
  p_value varchar2
  );

--mod:v1.6.0
function SetPrepFormFieldReadonly(
  p_prepform in out plpdf_type.t_prepform,
  p_obj number,
  p_gen number,
  p_readonly boolean -- boolean, have to convert flag
  ) return boolean;

-- mod: v1.6.0
procedure SetPrepFormFieldReadonly(
  p_prepform in out plpdf_type.t_prepform,
  p_obj number,
  p_gen number,
  p_readonly boolean
  );

--mod:v1.6.0
function SetPrepFormFieldReadonly(
  p_prepform in out plpdf_type.t_prepform,
  p_field_name varchar2,
  p_readonly boolean -- boolean, have to convert flag
  ) return boolean;

-- mod: v1.6.0
procedure SetPrepFormFieldReadonly(
  p_prepform in out plpdf_type.t_prepform,
  p_field_name varchar2,
  p_readonly boolean
  );

-- mod: v1.6.0
procedure GetPrepPDF(
  p_prepform plpdf_type.t_prepform,
  p_blob out nocopy  blob
  );

-- mod: v1.5.1
procedure ParsePdf(
  p_blob blob
  );

-- mod: v1.5.1
function GetParsedTemplate(
  p_page_id number
  ) return plpdf_type.tr_tpl_data;

-- mod: v1.5.1
function GetParsedNOP
  return number;

-- mod: v1.7.0
function FullPreparePDF(
  p_pdf blob
  ) return t_fullprep_pdf;
-----------------------------------------------------------------------------------------------
--v2.7.0
function get_obj_ref_change_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number,
   p_orig_obj_ref plpdf_type.t_obj_ref
  ) return plpdf_type.t_obj_ref;
--
procedure ins_obj_ref_change_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number,
  p_orig_obj_ref plpdf_type.t_obj_ref,
  p_new_obj_ref plpdf_type.t_obj_ref
  );
--
procedure RefChangeDetailOffset_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number,
  p_start_obj number
  );
--
function RefChange_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number,
  p_orig_obj_ref plpdf_type.t_obj_ref
  ) return plpdf_type.t_obj_ref;
--
procedure append_val_sep(
  p_blob in out nocopy blob,
  p_value blob,
  p_sep varchar2
  );
--
procedure append_val_sep(
  p_blob in out nocopy blob,
  p_value varchar2,
  p_sep varchar2
  );
--
function GetObjRef_tpls(
  p_obj_text varchar2
  ) return plpdf_type.t_obj_ref;
--
procedure append_val(
  p_blob in out nocopy blob,
  p_value blob
  );
--
procedure append_val(
  p_blob in out nocopy blob,
  p_value varchar2
  );
--
procedure append_val_wo_sep_tpls(
  p_blob in out nocopy blob,
  p_value varchar2
  );
--
function write_value_1_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number,
  p_obj_ref plpdf_type.t_obj_ref,
  p_parent_id number
  ) return blob;
--
function GetResObject_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number
  ) return blob;
--
function write_obj_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number,
  p_obj_ref plpdf_type.t_obj_ref
  ) return blob;
--
function WriteObject_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number,
  p_ordernum number
  ) return blob;
--
function GetDetailObjectCount_tpls(
  p_tpls in out nocopy t_template,
  p_tpl_id number
  ) return number;
--
function isset_tpls(
  p_tpls in out nocopy t_template,
  p_id number
  ) return boolean;
--
--
end;
/

