create or replace package plpdf as

/**
 <config>
  <pck-name>PL/PDF</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v2.9.4</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/

/**
 <h1>Introduction</h1>
 <br/>
 <p>
 PL/PDF is a PL/SQL based PDF document generator from Oracle databases. Use PL/PDF to quickly and easily develop applications with dynamic content but also quality presentation and printing capabilities.
 </p>
 <br/>
 <h2>Installation</h2>
 <p>
 Before using PL/PDF, make sure that the steps described in the Installation Guide were completed.
 </p>
 <br/>
 <h2>Using PL/PDF</h2>
 <p>
 Essentially, PL/PDF is a series of calls to PL/PDF procedures and functions from a PL/SQL script, package, procedure or function. If you are not familiar with the PL/SQL programming language, study the Oracle documentation.
 </p>
 <br/>
 <h2>Documentation</h2>
 <p>
 The PL/PDF documentation is available at: <a>http://www.plpdf.com/downloads</a>
 </p>
 <br/>
 <h2>Code Examples</h2>
 <p>
 PL/PDF code examples can be found at: <a>http://plpdf.com/index.php/support/examples/</a>
 </p>
 <br/>
 <h2>Contact</h2>
 <p>
 Contact us at: <a>mailto:info@plpdf.com</a>
 </p>
 <newpage/>
*/

/**
 <h1>Certification</h1>

 <name>GetCertKey</name>
 <type>Function</type>
 <desc>
  Generates preliminary certification key.
  This function should be run once when the PL/PDF package is installed. The function generates a string
  that should be sent to <a>mailto:info@plpdf.com</a>. Our representatives will send a certificate key back that should
  be used as the return value in the pl_pdf_cert.SetCertKey function.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>varchar2</return-def>
  <return-desc>Preliminary certificate key</return-desc>
 </return>
*/
function GetCertKey
  return varchar2;

/**
 <name>CertKeyCheck</name>
 <type>Function</type>
 <desc>
  Checks the certification key.<br/>
  Usage:<br/>
  declare                            <br/>
    l_ret boolean;                   <br/>
  begin                              <br/>
    l_ret := plpdf.CertKeyCheck;     <br/>
    if l_ret then                    <br/>
      dbms_output.put_line('true');  <br/>
    else                             <br/>
      dbms_output.put_line('false'); <br/>
    end if;                          <br/>
  end;                               <br/>
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>boolean</return-def>
  <return-desc>validity of the key</return-desc>
 </return>
*/
function CertKeyCheck
  return boolean;

/**
 <newpage/>
 <h1>Administrative commands</h1>
 <br/>
*/

/**
 <name>AddCJKFont</name>
 <type>Procedure</type>
 <desc>
  Add CJK (Chinese/Japanese/Korean) font.
 </desc>
 <version>v1.5.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of font</param-desc>
   <param-ul>
    <param-li>japanese: 'HeiseiKakuGo-W5'</param-li>
    <param-li>korean: 'HYSMyeongJoStd-Medium-Acro'</param-li>
    <param-li>chinese: 'MSungStd-Light-Acro', 'STSongStd-Light-Acro'</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddCJKFont(
  p_name varchar2
  );

/**
 <name>AddTTF</name>
 <type>Procedure</type>
 <desc>
  Imports a TTF (True Type Font). The imported font becomes available to the SetPrintFont procedure.
  The font is stored as binary data in the PDF file.
 </desc>
 <version>v2.6.0</version>
 <params>
  <param>
   <param-def>p_family varchar2</param-def>
   <param-desc>TTF name</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Font style</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>BI or IB: Bold and Italic</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_data t_addfont</param-def>
   <param-desc>Data structure necessary to insert the font. It contains the font definition binary file as well</param-desc>
  </param>
  <param>
   <param-def>p_embed boolean default true</param-def>
   <param-desc>PDF containts TTF binary file or not</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddTTF(
  p_family varchar2,
  p_style varchar2 default null,
  p_data Plpdf_Type.t_addfont,
  p_embed boolean default true
  );

/**
 <name>init</name>
 <type>Procedure</type>
 <desc>
  Initializes generator program variables.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_orientation varchar2 default 'P'</param-def>
   <param-desc>Orientation</param-desc>
   <param-ul>
    <param-li>P: portrait</param-li>
    <param-li>L: landscape</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_unit varchar2 default 'mm'</param-def>
   <param-desc>Unit of measure</param-desc>
  </param>
  <param>
   <param-def>p_format varchar2 default 'A4'</param-def>
   <param-desc>Page format</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure init(
  p_orientation varchar2 default plpdf_const.portrait,
  p_unit varchar2 default plpdf_const.mm,
  p_format varchar2 default 'A4'
  );

/**
 <name>init1</name>
 <type>Procedure</type>
 <desc>
  Initializes generator program variables.
 </desc>
 <version>v2.1.1</version>
 <params>
  <param>
   <param-def>p_orientation varchar2 default 'P'</param-def>
   <param-desc>Orientation</param-desc>
   <param-ul>
    <param-li>P: portrait</param-li>
    <param-li>L: landscape</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_unit varchar2 default 'mm'</param-def>
   <param-desc>Unit of measure</param-desc>
  </param>
  <param>
   <param-def>plpdf_type.t_pageformat</param-def>
   <param-desc>see plpdf_const package for predefined pageformats</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure init1(
  p_orientation varchar2 default plpdf_const.portrait,
  p_unit varchar2 default plpdf_const.mm,
  p_format plpdf_type.t_pageformat
  );

/**
 <name>getVersion</name>
 <type>Function</type>
 <desc>
  Gets the version number of pl/pldf package.
 </desc>
 <version>v1.0.0</version>
 <params>-</params>
 <return>
  <return-def>varchar2</return-def>
  <return-desc>number of current version</return-desc>
 </return>
*/
function getVersion
  return varchar2;

/**
<name>setRTOL</name>
<type>Procedure</type>
 <desc>
  Set text direction Right to Left. Set RtoL is an initialization procedure, therefore it may only be used once.
 </desc>
 <version>v2.1.1</version>
 <params>
 <param>
   <param-def>p_full boolean default null</param-def>
   <param-desc>All text RTOL and mirroring</param-desc>
   <param-ul>
    <param-li>null: only LtoR text (default)</param-li>
    <param-li>true: full RtoL with right alignment by default</param-li>
    <param-li>false: LtoR text with some RtoL text in it</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure setRTOL(
  p_full boolean default null
  );

/**
 <name>nopAlias</name>
 <type>Procedure</type>
 <desc>
  Defines the page number alias.
 </desc>
 <version>v2.9.2</version>
 <params>
  <param>
   <param-def>p_alias varchar2 default '{ nb }'</param-def>
   <param-desc>Page number alias</param-desc>
  </param>
  <param>
   <param-def>p_cp_alias varchar2 default '{ cp }'</param-def>
   <param-desc>Current page number alias</param-desc>
  </param>
  <param>
   <param-def>p_format varchar2 default '{ cp }'/'{ nb }'</param-def>
   <param-desc>Page numbering format</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default null</param-def>
   <param-desc>Align (padding) of result numbering, possible values L(eft)/R(ight) default null means L(eft)</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure nopAlias(
  p_alias varchar2 default '{nb}',
  p_cp_alias varchar2 default '{cp}',
  p_format varchar2 default '{cp}/{nb}',
  p_align varchar2 default null
  );

/**
 <name>setRotatePages</name>
 <type>Procedure</type>
 <desc>
  Sets the degree of rotation for all pages. The value must be a multiple of 90.
 </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_angle number</param-def>
   <param-desc>Angle/degree of rotation</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRotatePages(
  p_angle number
  );

/**
 <name>sendDoc</name>
 <type>Procedure</type>
 <desc>
  Returns the generated PDF document. The document is closed and then returned in the OUT parameter.
 </desc>
 <version>v1.0.0</version>
 <params>
 <param>
  <param-def>p_blob out nocopy  blob</param-def>
  <param-desc>the generated document</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure sendDoc(
  p_blob out nocopy blob
  );

/**
 <name>setAllMargin</name>
 <type>Procedure</type>
 <desc>
 Sets the margin size.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_left number</param-def>
   <param-desc>Left margin size</param-desc>
  </param>
  <param>
   <param-def>p_top number</param-def>
   <param-desc>Top margin size</param-desc>
  </param>
  <param>
   <param-def>p_right number  default -1</param-def>
   <param-desc>Right margin size. When it is set to -1 then the right margin will be the same as the left margin</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setAllMargin(
  p_left number,
  p_top number,
  p_right number  default -1
  );

/**
 <name>setAutoNewPage</name>
 <type>Procedure</type>
 <desc>
 Enables or disables automatic page breaks. The p_margin parameter is
 only relevant when enabling automatic page breaks. It sets the bottom
 margin size under which an automatic page break is triggered.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_auto boolean</param-def>
   <param-desc>Automatic page break</param-desc>
   <param-ul>
    <param-li>true: Enable</param-li>
    <param-li>false: Disable</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_margin number default 0</param-def>
   <param-desc>Bottom margin size, if not set, then 1 cm</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setAutoNewPage(
  p_auto boolean,
  p_margin number default 0
  );

/**
 <name>setCompress</name>
 <type>Procedure</type>
 <desc>
  Enables or disables the compression of PDF documents. By default compression is enabled.
 </desc>
 <version>v2.0.0</version>
 <params>
  <param>
   <param-def>p_compress boolean</param-def>
   <param-desc>Compression</param-desc>
   <param-ul>
    <param-li>True: Enable</param-li>
    <param-li>False: Disable</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_method varchar2 default null</param-def>
   <param-desc>compress method</param-desc>
   <param-ul>
    <param-li>plpdf_const.comp_FlateDecode: FlateDecode (Java)</param-li>
    <param-li>plpdf_const.comp_LZWDecode: LZWDecode</param-li>
    <param-li>plpdf_const.comp_PLDeflate: FlateDecode (PL/SQL)</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure setCompress(
  p_compress boolean default null,
  p_method varchar2 default null
  );

/**
 <name>setDocAuthor</name>
 <type>Procedure</type>
 <desc>
  Sets the document author.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_author varchar2</param-def>
   <param-desc>Document author</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDocAuthor(
  p_author varchar2
  );

/**
 <name>setDocCreator</name>
 <type>Procedure</type>
 <desc>
  Sets the document creator.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_creator varchar2</param-def>
   <param-desc>Document creator</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDocCreator(
  p_creator varchar2
  );

/**
 <name>setDocDisplayMode</name>
 <type>Procedure</type>
 <desc>
  Sets how to display the document in a PDF viewer (e.g. Acrobat Reader).
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_zoom varchar2</param-def>
   <param-desc>Layout view</param-desc>
   <param-ul>
    <param-li>fullpage: fits as full page</param-li>
    <param-li>fullwidth: fits as full width</param-li>
    <param-li>real: fits in actual size</param-li>
    <param-li>default: displays according to the setting of the PDF viewer</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_layout varchar2 default 'continuous'</param-def>
   <param-desc>Page layout</param-desc>
   <param-ul>
    <param-li>single: displays single pages</param-li>
    <param-li>continuous: displays pages continuously</param-li>
    <param-li>default: displays according to the setting of the PDF viewer</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_hidemenubar boolean default false</param-def>
   <param-desc>
     A flag specifying whether to hide the viewer application's menu bar when the document is active.
   </param-desc>
  </param>
  <param>
   <param-def>p_hidetoolbar boolean default false</param-def>
   <param-desc>
     A flag specifying whether to hide the viewer application's tool bars when the document is active.
   </param-desc>
  </param>
  <param>
   <param-def>p_hidewindowui boolean default false</param-def>
   <param-desc> A flag specifying whether to hide
    user interface elements in the document's window (such as scroll
    bars and navigation controls), leaving only the document's contents displayed.
   </param-desc>
  </param>
  <param>
   <param-def>p_displaydoctitle boolean default false</param-def>
   <param-desc>
    A flag specifying whether
    the window's title bar should display the document title taken from the
    Title entry of the document information dictionary.
   </param-desc>
  </param>
  <param>
   <param-def>p_centerwindow boolean default false</param-def>
   <param-desc>
    A flag specifying whether to position the document's window in the center of the screen.
   </param-desc>
  </param>
  <param>
   <param-def>p_fitwindow boolean default false</param-def>
   <param-desc>
    A flag specifying whether to resize the document's window to fit the size of the first displayed page.
   </param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDocDisplayMode(
  p_zoom varchar2 default 'fullwidth',
  p_layout varchar2 default 'continuous',
  p_hidemenubar boolean default false,
  p_hidetoolbar boolean default false,
  p_hidewindowui boolean default false,
  p_displaydoctitle boolean default false,
  p_centerwindow boolean default false,
  p_fitwindow boolean default false
  );

/**
 <name>setDocKeywords</name>
 <type>Procedure</type>
 <desc>
  Sets the document keywords.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_keywords varchar2</param-def>
   <param-desc>Keyword list</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDocKeywords(
  p_keywords varchar2
  );

/**
 <name>setDocSubject</name>
 <type>Procedure</type>
 <desc>
  Sets the document subject.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_subject varchar2</param-def>
   <param-desc>Document subject</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDocSubject(
  p_subject varchar2
  );

/**
 <name>SetDocTitle</name>
 <type>Procedure</type>
 <desc>
 Sets the document title.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_title varchar2</param-def>
   <param-desc>Document title</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDocTitle(
  p_title varchar2
  );

/**
 <name>setEncoding</name>
 <type>Procedure</type>
 <desc>
  Sets Adobe Core character encoding (default code is cp1252).
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_enc varchar2</param-def>
   <param-desc>Character encoding code</param-desc>
   <param-ul>
    <param-li>cp1250</param-li>
    <param-li>cp1251</param-li>
    <param-li>cp1252: this is the default, no need to set </param-li>
    <param-li>cp1253 </param-li>
    <param-li>cp1254</param-li>
    <param-li>cp1255</param-li>
    <param-li>cp1256</param-li>
    <param-li>cp1257</param-li>
    <param-li>cp1258</param-li>
    <param-li>cp874</param-li>
    <param-li>iso-8859-1</param-li>
    <param-li>iso-8859-2</param-li>
    <param-li>iso-8859-4</param-li>
    <param-li>iso-8859-5</param-li>
    <param-li>iso-8859-7</param-li>
    <param-li>iso-8859-9</param-li>
    <param-li>iso-8859-15</param-li>
    <param-li>iso-8859-16</param-li>
    <param-li>utf16: AL32UTF8 database with unicode TTF embending</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure setEncoding(
  p_enc varchar2
  );

/**
 <name>setHeaderProcName</name>
 <type>Procedure</type>
 <desc>
  Sets the page header procedure name. The program name passed
  as a parameter executes when the page header is created. If
  SetHeaderProcName is not executed before a page header is created then
  the page header will be empty.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_proc_name varchar2</param-def>
   <param-desc>Page header procedure name</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>height of header section</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setHeaderProcName(
  p_proc_name varchar2,
  p_height number
  );

/**
 <name>setHeaderProcName5</name>
 <type>Procedure</type>
 <desc>
  Sets the page header procedure name with 5 parameters. The program name passed
  as a parameter executes when the page header is created. If
  SetHeaderProcName is not executed before a page header is created then
  the page header will be empty.
 </desc>
 <version>v2.9.0</version>
 <params>
  <param>
   <param-def>p_proc_name varchar2</param-def>
   <param-desc>Page header procedure name</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>height of header section</param-desc>
  </param>
  <param>
   <param-def>p_1 varchar2 default null</param-def>
   <param-desc>parameter of header procedure</param-desc>
  </param>
  <param>
   <param-def>p_2 varchar2 default null</param-def>
   <param-desc>parameter of header procedure</param-desc>
  </param>
  <param>
   <param-def>p_3 varchar2 default null</param-def>
   <param-desc>parameter of header procedure</param-desc>
  </param>
  <param>
   <param-def>p_4 varchar2 default null</param-def>
   <param-desc>parameter of header procedure</param-desc>
  </param>
  <param>
   <param-def>p_5 varchar2 default null</param-def>
   <param-desc>parameter of header procedure</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setHeaderProcName5(
  p_proc_name varchar2,
  p_height number,
  p_1 varchar2 default null,
  p_2 varchar2 default null,
  p_3 varchar2 default null,
  p_4 varchar2 default null,
  p_5 varchar2 default null
  );

/**
 <name>setFooterProcName</name>
 <type>Procedure</type>
 <desc>
  Sets the page footer procedure name. The program name passed as a parameter
  executes when the page footer is created. If SetFooterProcName is not executed
  before a page footer is created then the page footer will be empty.
 </desc>
 <version>v1.2.4</version>
 <params>
 <param>
  <param-def>p_proc_name varchar2</param-def>
  <param-desc>Page header procedure name</param-desc>
 </param>
 <param>
  <param-def>p_height number</param-def>
  <param-desc>height of header section</param-desc>
 </param>
 </params>
 <return>-</return>
*/
procedure setFooterProcName(
  p_proc_name varchar2,
  p_height number
  );

/**
 <name>setFooterProcName5</name>
 <type>Procedure</type>
 <desc>
  Sets the page footer procedure name with 5 parameters. The program name passed as a parameter
  executes when the page footer is created. If SetFooterProcName is not executed
  before a page footer is created then the page footer will be empty.
 </desc>
 <version>v2.9.0</version>
 <params>
 <param>
  <param-def>p_proc_name varchar2</param-def>
  <param-desc>Page header procedure name</param-desc>
 </param>
 <param>
  <param-def>p_height number</param-def>
  <param-desc>height of header section</param-desc>
 </param>
 <param>
   <param-def>p_1 varchar2 default null</param-def>
   <param-desc>parameter of footer procedure</param-desc>
  </param>
  <param>
   <param-def>p_2 varchar2 default null</param-def>
   <param-desc>parameter of footer procedure</param-desc>
  </param>
  <param>
   <param-def>p_3 varchar2 default null</param-def>
   <param-desc>parameter of footer procedure</param-desc>
  </param>
  <param>
   <param-def>p_4 varchar2 default null</param-def>
   <param-desc>parameter of footer procedure</param-desc>
  </param>
  <param>
   <param-def>p_5 varchar2 default null</param-def>
   <param-desc>parameter of footer procedure</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setFooterProcName5(
  p_proc_name varchar2,
  p_height number,
  p_1 varchar2 default null,
  p_2 varchar2 default null,
  p_3 varchar2 default null,
  p_4 varchar2 default null,
  p_5 varchar2 default null
  );

/**
 <name>setLeftMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the left margin size.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLeftMargin(
  p_margin number
  );

/**
 <name>setTopMargin</name>
 <type>Procedure</type>
 <desc>
 Sets the top margin size.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTopMargin(
  p_margin number
  );

/**
 <name>setRightMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the right margin size.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRightMargin(
  p_margin number
  );

/**
 <name>setNOLastpageProcName</name>
 <type>Procedure</type>
 <desc>
  Sets the not last page procedure name. The program name passed as a parameter
  executes when the not last page closed.
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_proc_name varchar2</param-def>
   <param-desc>Procedure name</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setNOLastpageProcName(
  p_proc_name varchar2
  );

/**
 <name>SetPageNoStart</name>
 <type>Procedure</type>
 <desc>
  Sets start of page numbering to the current page.
 </desc>
 <version>v2.9.3</version>
 <params>
 <param>
   <param-def>p_start_num pls_integer default null</param-def>
   <param-desc>The start of the numbering, null means 1</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setPageNoStart(
  p_start_num pls_integer default null
  );

/**
 <name>SetPageNoEnd</name>
 <type>Procedure</type>
 <desc>
  Sets end of page numbering to the current page, see <link>SetPageNoStart</link>.
 </desc>
 <version>v1.1.8</version>
 <params>-</params>
 <return>-</return>
*/
procedure setPageNoEnd;

/**
 <name>SetProtection</name>
 <type>Procedure</type>
 <desc>
  Allows to protect the PDF document.
 </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_print_perm Boolean default false</param-def>
   <param-desc>print the PDF</param-desc>
  </param>
  <param>
   <param-def>p_modify_perm Boolean default false</param-def>
   <param-desc>modify the PDF</param-desc>
  </param>
  <param>
   <param-def>p_annot_forms_perm Boolean default false</param-def>
   <param-desc>add annotations and forms</param-desc>
  </param>
  <param>
   <param-def>p_user_pass varchar2 default null</param-def>
   <param-desc>user password</param-desc>
  </param>
  <param>
   <param-def>p_owner_pass varchar2 default null</param-def>
   <param-desc>owner password</param-desc>
  </param>
 </params>
 <return>-</return>

*/
procedure setProtection(
  p_print_perm boolean default false,
  p_modify_perm boolean default false,
  p_copy_perm boolean default false,
  p_annot_forms_perm boolean default false,
  p_user_pass varchar2 default null,
  p_owner_pass varchar2 default null
  );

/**
 <name>setPDFA1B</name>
 <type>Procedure</type>
 <desc>
  Set PDF/A-1B support.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure setPDFA1B;

/**
 <name>setID</name>
 <type>Procedure</type>
 <desc>
  Sets the internal identifier of the PDF file. ID format is a 32 characters length hex string,
  possible generator is the "rawtohex(SYS_GUID())" expression.
 </desc>
 <version>v2.7.0</version>
 <params>
  <param>
   <param-def>p_id varchar2</param-def>
   <param-desc>ID value</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setID(
  p_id varchar2
  );
-------------------------------------------------------------------------------
/**
 <newpage/>
 <h1>Navigations and formatting commands</h1>
 <br/>
*/
------------------------------------------------------------------------------

/**
 <name>CheckPageBreak</name>
 <type>Function</type>
 <desc>
  If the height would cause an overflow, add a new page immediately, and return true.
 </desc>
 <version>v1.7.0</version>
 <params>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height for check page overflow</param-desc>
  </param>
  <param>
   <param-def>p_newpage boolean default true</param-def>
   <param-desc>do NewPage procedure</param-desc>
  </param>
 </params>
 <return>
  <return-def>boolean</return-def>
  <param-ul>
    <param-li>true: overflow is reached</param-li>
    <param-li>false: don't reach overflow</param-li>
  </param-ul>
 </return>
*/
function CheckPageBreak(
  p_h number,
  p_newpage boolean default true
  ) return boolean;

/**
 <name>CurrentPagenumber</name>
 <type>Function</type>
 <desc>
  Returns the page number of the current page.
 </desc>
 <version>v1.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Page number of the current page</return-desc>
 </return>
*/
function CurrentPagenumber
  return number;

/**
 <name>getLeftMargin</name>
 <type>Function</type>
 <desc>
  Gets the page left margin size.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of left margin</return-desc>
 </return>
*/
function getLeftMargin
  return number;

/**
 <name>getRightMargin</name>
 <type>Function</type>
 <desc>
  Gets the page right margin size.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of right margin</return-desc>
 </return>
*/
function getRightMargin
  return number;

/**
 <name>getTopMargin</name>
 <type>Function</type>
 <desc>
  Gets the page top margin size.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of top margin</return-desc>
 </return>
*/
function getTopMargin
  return number;

/**
 <name>getBottomMargin</name>
 <type>Function</type>
 <desc>
  Gets the page bottom margin size.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of bottom margin</return-desc>
 </return>
*/
function getBottomMargin
  return number;

/**
 <name>getHeaderHeight</name>
 <type>Function</type>
 <desc>
  Gets the page header size.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of header</return-desc>
 </return>
*/
function getHeaderHeight
  return number;

/**
 <name>getFooterHeight</name>
 <type>Function</type>
 <desc>
  Gets the page footer size.
 </desc>
 <version>v2.3.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of footer</return-desc>
 </return>
*/
function getFooterHeight
  return number;

/**
 <name>getCurrentX</name>
 <type>Function</type>
 <desc>
  Gets the X coordinate of the cursor.
 </desc>
 <version>v1.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>X coordinate</return-desc>
 </return>
*/
function getCurrentX
  return number;

/**
 <name>getCurrentY</name>
 <type>Function</type>
 <desc>
  Gets the Y coordinate of the cursor.
 </desc>
 <version>v1.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Y coordinate</return-desc>
 </return>
*/
function getCurrentY
  return number;

/**
 <name>getPageAvailableHeight</name>
 <type>Function</type>
 <desc>
  Gets the available height (without margins) of actual page.
 </desc>
 <version>v1.1.4</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Available height</return-desc>
 </return>
*/
function getPageAvailableHeight
  return number;

/**
 <name>getPageAvailableWidth</name>
 <type>Function</type>
 <desc>
  Gets the available width (without margins) of actual page.
 </desc>
 <version>v1.1.4</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Available width</return-desc>
 </return>
*/
function getPageAvailableWidth
  return number;

/**
 <name>getPageHeight</name>
 <type>Function</type>
 <desc>
 Gets the height of actual page.
 </desc>
 <version>v1.1.4</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getPageHeight
  return number;

/**
 <name>getPageRightSpace</name>
 <type>Function</type>
 <desc>
  Gets the available width (without margins) of actual page from current position.
 </desc>
 <version>v1.7.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getPageRightSpace
  return number;

/**
 <name>getPageLeftSpace</name>
 <type>Function</type>
 <desc>
  Gets the available width (without margins) of actual page from current position.
 </desc>
 <version>v2.1.1</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getPageLeftSpace
  return number;

/**
 <name>getPageSpace</name>
 <type>Function</type>
 <desc>
  Gets the available width (without margins) of actual page from current position.
 </desc>
 <version>v2.1.1</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getPageSpace
  return number;

/**
 <name>getPageWidth</name>
 <type>Function</type>
 <desc>
  Gets the width of actual page.
 </desc>
 <version>v1.1.4</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getPageWidth
  return number;

/**
 <name>getPrintFontName</name>
 <type>Function</type>
 <desc>
  Get the current font type. See <link>SetPrintFont</link>.
 </desc>
 <version>v1.2.2</version>
 <params>-</params>
 <return>
  <return-def>varchar2</return-def>
  <return-desc>Font type</return-desc>
 </return>
*/
function getPrintFontName
  return varchar2;

/**
 <name>getPrintFontStyle</name>
 <type>Function</type>
 <desc>
  Get the current font style. See <link>SetPrintFont</link>
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>
  <return-def>varchar2</return-def>
  <return-desc>Font style</return-desc>
 </return>
*/
function getPrintFontStyle
  return varchar2;

/**
 <name>getPrintFontSize</name>
 <type>Function</type>
 <desc>
  Get the current font size. See <link>SetPrintFont</link>
 </desc>
 <version>v1.2.2</version>
 <params>-</params>
 <return>
  <return-def>varchar2</return-def>
  <return-desc>Font size</return-desc>
 </return>
*/
function getPrintFontSize
  return number;

/**
 <name>getScaleFactor</name>
 <type>Function</type>
 <desc>
  Get the current scale factor.
 </desc>
 <version>v1.4.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>scale factor</return-desc>
 </return>
*/
function getScaleFactor
  return number;

/**
 <name>getTextWidth</name>
 <type>Function</type>
 <desc>
 Returns the width of the parameter text (uses current font).
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_s varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
 </params>
 <return>
  <return-def>number</return-def>
  <return-desc>The width of the text in the unit of measure specified in Init</return-desc>
 </return>
*/
function getTextWidth(
  p_s varchar2
  ) return number;

/**
 <name>getTextWidthFont</name>
 <type>Function</type>
 <desc>
 Returns the width of the parameter text, font is a parameter too.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_family varchar2 default null</param-def>
   <param-desc>Font type, null means current font family</param-desc>
   <param-ul>
    <param-li>Helvetica (Arial, Sans Serif)</param-li>
    <param-li>Courier</param-li>
    <param-li>Times (Serif)</param-li>
    <param-li>Symbol</param-li>
    <param-li>ZapfDingBats</param-li>
    <param-li>If TTF fonts were added using the AddTTF procedure then they may be used here as well.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Font style</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI will be Bold and Italic)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_size number default null</param-def>
   <param-desc>Font size, null means current font size</param-desc>
  </param>
  <param>
   <param-def>p_s varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
 </params>
 <return>
  <return-def>number</return-def>
  <return-desc>The width of the text in the unit of measure specified in Init</return-desc>
 </return>
*/
function getTextWidthFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_s varchar2
  ) return number;

/**
 <name>RemoveMissingChars</name>
 <type>Function</type>
 <desc>Remove unknown characters from text (uses current font).</desc>
 <version>v2.7.0</version>
 <params>
  <param>
   <param-def>p_s varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
 </params>
 <return>
  <return-def>varchar2</return-def>
  <return-desc>The text without missing characters</return-desc>
 </return>
*/
function RemoveMissingChars(
  p_s varchar2
  ) return varchar2;

/**
 <name>InsertMovePage</name>
 <type>Procedure</type>
 <desc>
  Insert a new page and move it by changing order of pages.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_orig_pos number</param-def>
   <param-desc>origin page position</param-desc>
  </param>
  <param>
   <param-def>p_new_pos number</param-def>
   <param-desc>new page position</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure InsertMovePage(
  p_orig_pos number,
  p_new_pos number
  );

/**
 <name>LineBreak</name>
 <type>Procedure</type>
 <desc>
  Line break. Cursor is placed at the start of the next line.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_h number default NULL</param-def>
   <param-desc>Height of the line break. If not set, then the last printed cells height is the height by default.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure LineBreak(
  p_h number default null
  );

/**
 <name>NewPage</name>
 <type>Procedure</type>
 <desc>
  Creates a new page. If no orientation is given then the orientation specified in Init
  will be used. If a page was previously open, a page break is initiated and the
  cursor is placed at the top left corner of the new page.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_orientation varchar2 default NULL</param-def>
   <param-desc>Page orientation</param-desc>
   <param-ul>
    <param-li>P: Portrait</param-li>
    <param-li>L: Landscape</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure NewPage(
  p_orientation varchar2 default null
  );

/**
 <name>setCurrentX</name>
 <type>Procedure</type>
 <desc>
  Places the cursor at the X coordinate.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_x number default 0</param-def>
   <param-desc>X coordinate</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setCurrentX(
  p_x number default 0
  );

/**
 <name>setCurrentY</name>
 <type>Procedure</type>
 <desc>
  Places the cursor at the Y coordinate and reset X.
 </desc>
 <version>v1.7.0</version>
 <params>
  <param>
   <param-def>p_y number default 0</param-def>
   <param-desc>Y coordinate</param-desc>
  </param>
  <param>
   <param-def>p_cr boolean default true</param-def>
   <param-desc>X position returns to beginning of line</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setCurrentY(
  p_y number default 0,
  p_cr boolean default true
  );

/**
 <name>setCurrentXY</name>
 <type>Procedure</type>
 <desc>
  Places the cursor at the X and Y coordinate.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_x number default 0</param-def>
   <param-desc>X coordinate</param-desc>
  </param>
  <param>
   <param-def>p_y number default 0</param-def>
   <param-desc>Y coordinate</param-desc>
  </param>
 </params>
 <return>-</return>

*/
procedure setCurrentXY(
  p_x number default 0,
  p_y number default 0
  );

------------------------------------------------------------------------------
/**
 <newpage/>
 <h1>Content Related Commands</h1>
 <br/>
*/
------------------------------------------------------------------------------

/**
 <name>AddCircle2Pattern</name>
 <type>Procedure</type>
 <desc>
  Add a circle to the pattern, see <link>CrTillingPattern</link>.
 </desc>
 <version>v1.1.7</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the center of the circle</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the center of the circle</param-desc>
  </param>
  <param>
   <param-def>p_r number</param-def>
   <param-desc>the radius of the circle</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default 'D'</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddCircle2Pattern(
  p_name varchar2,
  p_x number,
  p_y number,
  p_r number,
  p_style varchar2 default 'D'
  );

/**
 <name>AddEllipse2Pattern</name>
 <type>Procedure</type>
 <desc>
  Add a ellipse to the pattern, see <link>CrTillingPattern</link>.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the center of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the center of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_rx number</param-def>
   <param-desc>horizontal radius of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_ry number</param-def>
   <param-desc>vertical radius of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default 'D'</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddEllipse2Pattern(
  p_name varchar2,
  p_x number,
  p_y number,
  p_rx number,
  p_ry number,
  p_style varchar2 default 'D'
  );

/**
 <name>AddLine2Pattern</name>
 <type>Procedure</type>
 <desc>
  Add a line to the pattern, see <link>CrTillingPattern</link>.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern</param-desc>
  </param>
  <param>
   <param-def>p_x1 number</param-def>
   <param-desc>X coordinate for the start of the line</param-desc>
  </param>
  <param>
   <param-def>p_y1 number</param-def>
   <param-desc>Y coordinate for the start of the line</param-desc>
  </param>
  <param>
   <param-def>p_x2 number</param-def>
   <param-desc>X coordinate for the end of the line</param-desc>
  </param>
  <param>
   <param-def>p_y2 number</param-def>
   <param-desc>Y coordinate for the end of the line</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddLine2Pattern(
  p_name varchar2,
  p_x1 number,
  p_y1 number,
  p_x2 number,
  p_y2 number
  );

/**
 <name>AddPolygon2Pattern</name>
 <type>Procedure</type>
 <desc>
  Add a polygon to the pattern, see <link>CrTillingPattern</link>.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern</param-desc>
  </param>
  <param>
   <param-def>p_points plpdf_type.t_points</param-def>
   <param-desc>set of ordered points</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default 'D'</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddPolygon2Pattern(
  p_name varchar2,
  p_points plpdf_type.t_points,
  p_style varchar2 default 'D'
  );

/**
 <name>AddRect2Pattern</name>
 <type>Procedure</type>
 <desc>
  Add a rectangle to the pattern, see <link>CrTillingPattern</link>.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>The width of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>The height of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default NULL</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddRect2Pattern(
  p_name varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_style varchar2 default null
  );

/**
 <name>AddFileAnnot</name>
 <type>Procedure</type>
 <desc>
 Add File annotation to the current page
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2 default 'PushPin'</param-def>
   <param-desc>The name of an icon to be used in displaying the annotation.</param-desc>
   <param-ul>
    <param-li>PushPin</param-li>
    <param-li>Graph</param-li>
    <param-li>Paperclip</param-li>
    <param-li>Tag</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_filename varchar2</param-def>
   <param-desc>name of file</param-desc>
  </param>
  <param>
   <param-def>p_fileblob blob</param-def>
   <param-desc>file</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddFileAnnot(
  p_name varchar2 default 'PushPin', -- has defined types</param-def><param-desc>PushPin Graph Paperclip Tag
  p_contents varchar2,
  p_x number,
  p_y number,
  p_filename varchar2,
  p_fileblob blob,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null
  );

/**
 <name>AddHighLightAnnot</name>
 <type>Procedure</type>
 <desc>
  Add HighLight annotation to the current page
 </desc>
 <version>v1.2.2</version>
 <params>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc> This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddHighLightAnnot(
  p_contents varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddTextAnnot</name>
 <type>Procedure</type>
 <desc>
  Add Text annotation to the current page
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2 default 'Note'</param-def>
   <param-desc>The name of an icon to be used in displaying the annotation.</param-desc>
   <param-ul>
    <param-li>Comment</param-li>
    <param-li>Key</param-li>
    <param-li>Note</param-li>
    <param-li>Help</param-li>
    <param-li>NewParagraph</param-li>
    <param-li>Paragraph</param-li>
    <param-li>Insert</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddTextAnnot(
  p_name varchar2 default 'Note',
  p_contents varchar2,
  p_x number,
  p_y number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddStrikeOutAnnot</name>
 <type>Procedure</type>
 <desc>
  Add StrikeOut annotation to the current page
 </desc>
 <version>v1.2.2</version>
 <params>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddStrikeOutAnnot(
  p_contents varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddUnderlineAnnot</name>
 <type>Procedure</type>
 <desc>
  Add Underline annotation to the current page
 </desc>
 <version>v1.2.2</version>
 <params>
  <param>
   <param-def>p_contents varchar2</param-def>
   <param-desc>The text to be displayed in the pop-up window when the annotation is opened.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>The text label to be displayed in the title bar of the annotation's pop-up window when open and active.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default null</param-def>
   <param-desc>This color will be used for the following purposes</param-desc>
   <param-ul>
    <param-li>The background of the annotation's icon when closed</param-li>
    <param-li>The title bar of the annotation's pop-up window</param-li>
    <param-li>The border of a link annotation</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_popup_x number default null</param-def>
   <param-desc>X coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_y number default null</param-def>
   <param-desc>Y coordinate of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_w number default null</param-def>
   <param-desc>width of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_popup_h number default null</param-def>
   <param-desc>height of the pop-up window</param-desc>
  </param>
  <param>
   <param-def>p_open boolean default false</param-def>
   <param-desc>A flag specifying whether the pop-up window should initially be displayed open.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddUnderlineAnnot(
  p_contents varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_label varchar2 default null,
  p_color plpdf_type.t_color default null,
  p_popup_x number default null,
  p_popup_y number default null,
  p_popup_w number default null,
  p_popup_h number default null,
  p_open boolean default false
  );

/**
 <name>AddScreenAnnotURL</name>
 <type>Procedure</type>
 <desc>
  A screen annotation specifies a region of a page upon which media clips may be played.
  Source of the media is an URL.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Name of the media clip.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_url varchar2</param-def>
   <param-desc>URL of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_mime varchar2</param-def>
   <param-desc>MIME type of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_event varchar2 default null</param-def>
   <param-desc>Additional action when play annotation</param-desc>
   <param-ul>
    <param-li>null: play clip when click/activate annotation only</param-li>
    <param-li>PV: An action to be performed when the page containing the annotation becomes visible in the viewer applications user interface. </param-li>
    <param-li>PO: An action to be performed when the page containing the annotation is opened.</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddScreenAnnotURL(
  p_name varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_url varchar2,
  p_mime varchar2,
  p_event varchar2 default null
  );

/**
 <name>AddScreenAnnotFile</name>
 <type>Procedure</type>
 <desc>
  A screen annotation specifies a region of a page upon which media clips may be played.
  Source of the media is an BLOB.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Name of the media clip.</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>width of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>height of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_fileblob blob</param-def>
   <param-desc>File of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_mime varchar2</param-def>
   <param-desc>MIME type of the annotation</param-desc>
  </param>
  <param>
   <param-def>p_event varchar2 default null</param-def>
   <param-desc>Additional action when play annotation</param-desc>
   <param-ul>
    <param-li>null: play clip when click/activate annotation only</param-li>
    <param-li>PV: An action to be performed when the page containing the annotation becomes visible in the viewer applications user interface. </param-li>
    <param-li>PO: An action to be performed when the page containing the annotation is opened.</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure AddScreenAnnotFile(
  p_name varchar2,
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_fileblob blob,
  p_mime varchar2,
  p_event varchar2 default null
  );

/**
 <name>AttachFile</name>
 <type>Procedure</type>
 <desc>
  Attachs a file to the PDF document.
 </desc>
 <version>v2.8.0</version>
 <params>
  <param>
   <param-def>p_filename varchar2</param-def>
   <param-desc>name of file</param-desc>
  </param>
  <param>
   <param-def>p_fileblob blob</param-def>
   <param-desc>file</param-desc>
  </param>
  <param>
   <param-def>p_desc varchar2 default null</param-def>
   <param-desc>description of file</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AttachFile(
  p_filename varchar2,
  p_fileblob blob,
  p_desc varchar2 default null
  );

/**
 <name>CrBookmark</name>
 <type>Procedure</type>
 <desc>
  Create a bookmark in the PDF document. Bookmarks are displayed in the PDF viewer program (e.g. Acrobat Reader).
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_txt varchar2</param-def>
   <param-desc>Text of the bookmark</param-desc>
  </param>
  <param>
   <param-def>p_level number default 0</param-def>
   <param-desc>Bookmark level, 0 is the highest level</param-desc>
  </param>
  <param>
   <param-def>p_y number default 0</param-def>
   <param-desc>Y coordinate of the bookmark within the current page. -1 denotes the cursor position.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure CrBookmark(
  p_txt varchar2,
  p_level number default 0,
  p_y number default 0
  );

/**
 <name>CrInternalLink</name>
 <type>Function</type>
 <desc>
  Creates an internal link, and returns its ID. An internal link can be used
  to take the cursor to another place within the document by clicking over it.
 </desc>
 <version>v1.0.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>The ID of the internal link</return-desc>
 </return>
*/
function CrInternalLink
  return number;

/**
 <name>CrTillingPattern</name>
 <type>Procedure</type>
 <desc>
  Starts of define a "Tilling Pattern". Tiling patterns consist of a small graphical figure (called a pattern cell) that is
  replicated at fixed horizontal and vertical intervals to fill the area to be painted.
  <br/>
  Add "graphical figure" to pattern:
  <param-ul>
   <param-li>AddLine2Pattern: add a line to pattern</param-li>
   <param-li>AddRect2Pattern: add a rectangle to pattern</param-li>
   <param-li>AddEllipse2Pattern: add a ellipse to pattern</param-li>
   <param-li>AddCircle2Pattern: add a circle to pattern</param-li>
   <param-li>AddPolygon2Pattern: add a polygon to pattern</param-li>
  </param-ul>
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>width of pattern cell</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>height of pattern cell</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure CrTillingPattern(
  p_name varchar2,
  p_width number,
  p_height number
  );

/**
 <name>DrawCircle</name>
 <type>Procedure</type>
 <desc>
  Draws a cirle on the current page.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the center of the circle</param-desc>
  </param>
   <param>
   <param-def>p_y number</param-def>
  <param-desc>Y coordinate of the center of the circle</param-desc>
  </param>
  <param>
   <param-def>p_r number</param-def>
   <param-desc>the radius of the circle</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default NULL</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawCircle(
  p_x number,
  p_y number,
  p_r number,
  p_style varchar2 default 'D'
  );

/**
 <name>DrawEllipse</name>
 <type>Procedure</type>
 <desc>
  Draws an ellipse on the current page.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the center of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the center of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_rx number</param-def>
   <param-desc>horizontal radius of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_ry number</param-def>
   <param-desc>vertical radius of the ellipse</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default 'D'</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawEllipse(
  p_x number,
  p_y number,
  p_rx number,
  p_ry number,
  p_style varchar2 default 'D'
  );

/**
 <name>DrawLine</name>
 <type>Procedure</type>
 <desc>
  Draws a line between the two positions on the page.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_x1 number</param-def>
   <param-desc>X coordinate for the start of the line</param-desc>
  </param>
  <param>
   <param-def>p_y1 number</param-def>
   <param-desc>Y coordinate for the start of the line</param-desc>
  </param>
  <param>
   <param-def>p_x2 number</param-def>
   <param-desc>X coordinate for the end of the line</param-desc>
  </param>
  <param>
   <param-def>p_y2 number</param-def>
   <param-desc>Y coordinate for the end of the line</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawLine(
  p_x1 number,
  p_y1 number,
  p_x2 number,
  p_y2 number
  );

/**
 <name>DrawPolygon</name>
 <type>Procedure</type>
 <desc>
  Draws a lines (polygon) between the points on the page.
 </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_points plpdf_type.t_points</param-def>
   <param-desc>set of ordered points</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default 'D'</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawPolygon(
  p_points plpdf_type.t_points,
  p_style varchar2 default 'D'
  );

/**
 <name>DrawRect</name>
 <type>Procedure</type>
 <desc>
  Draws a rectangle on the page.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
  <param-def>p_x number</param-def>
  <param-desc>X coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>The width of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>The height of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default NULL</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
    </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawRect(
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_style varchar2 default null
  );

/**
 <name>DrawRoundedRect</name>
 <type>Procedure</type>
 <desc>
  Draws a rectangle on the page.
 </desc>
 <version>v2.3.1</version>
 <params>
  <param>
  <param-def>p_x number</param-def>
  <param-desc>X coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>The width of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>The height of the rectangle</param-desc>
  </param>
   <param>
   <param-def>p_r number</param-def>
   <param-desc>The radius of the corners</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default NULL</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF or FD: Fill and border line</param-li>
    </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawRoundedRect(
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_r number,
  p_style varchar2 default null
  );

/**
 <name>DrawSector</name>
 <type>Procedure</type>
 <desc>
  Draws a sector on the current page.
 </desc>
 <version>v1.0.0</version>
 <params>
  <param>
   <param-def>p_xc number</param-def>
   <param-desc>X coordinate of the center of the sector</param-desc>
  </param>
  <param>
   <param-def>p_yc number</param-def>
   <param-desc>Y coordinate of the center of the sector</param-desc>
  </param>
  <param>
   <param-def>p_r number</param-def>
   <param-desc>Radius of the sector</param-desc>
  </param>
  <param>
   <param-def>p_a number</param-def>
   <param-desc>Starting point of the sector</param-desc>
  </param>
  <param>
   <param-def>p_b number</param-def>
   <param-desc>End point of the sector</param-desc>
  </param>
  <param>
   <param-def> p_style varchar2 default 'FD'</param-def>
   <param-desc>Style</param-desc>
   <param-ul>
    <param-li>D: No fill, border line</param-li>
    <param-li>F: Fill, no border line</param-li>
    <param-li>DF vagy FD: Fill and border line</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_cw boolean default true</param-def>
   <param-desc>Draw direction</param-desc>
   <param-ul>
    <param-li>true: Clockwise</param-li>
    <param-li>false: Anti-clockwise</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_o number default 90</param-def>
   <param-desc>origin of angles</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure DrawSector(
  p_xc number,
  p_yc number,
  p_r number,
  p_a number,
  p_b number,
  p_style varchar2 default 'FD',
  p_cw boolean default true,
  p_o number default 90
  );

/**
 <name>EndClipping</name>
 <type>Procedure</type>
 <desc>
  End a cliping frame.  See <link>StartClipping</link>
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure EndClipping;

/**
 <name>EndOpacity</name>
 <type>Procedure</type>
 <desc>
  End a transparency.  See <link>StartOpacity</link>
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure EndOpacity;

/**
 <name>EndOptCont</name>
 <type>Procedure</type>
 <desc>
  End an optional content.  See <link>link StartOptCont</link>
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure EndOptCont;

/**
 <name>getCellMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell margin size.
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Margin size</return-desc>
 </return>
*/
function getCellMargin
  return number;

/**
 <name>getCellBottomMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell bottom margin size.
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of bottom margin</return-desc>
 </return>
*/
function getCellBottomMargin
  return number;

/**
 <name>getCellLeftMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell left margin size.
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of left margin</return-desc>
 </return>
*/
function getCellLeftMargin
  return number;

/**
 <name>getCellRightMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell right margin size.
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of right margin</return-desc>
 </return>
*/
function getCellRightMargin
  return number;

/**
 <name>getCellTopMargin</name>
 <type>Function</type>
 <desc>
  Gets the cell top margin size.
 </desc>
 <version>v2.1.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Size of top margin</return-desc>
 </return>
*/
function getCellTopMargin
  return number;

/**
 <name>getColor4Drawing</name>
 <type>Function</type>
 <desc>
  Gets the line color for objects.
 </desc>
 <version>v1.1.6</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Drawing color</return-desc>
 </return>
*/
function getColor4Drawing
  return plpdf_type.t_color;

/**
 <name>getColor4Filling</name>
 <type>Function</type>
 <desc>
  Gets the filling color for objects.
 </desc>
 <version>v1.1.6</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Filling color</return-desc>
 </return>
*/
function getColor4Filling
  return plpdf_type.t_color;

/**
 <name>getColor4Text</name>
 <type>Function</type>
 <desc>
  Gets the color of text.
 </desc>
 <version>v1.1.6</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Color of text</return-desc>
 </return>
*/
function getColor4Text
  return plpdf_type.t_color;

/**
 <name>getLineWidth</name>
 <type>Function</type>
 <desc>
  Gets the current line size.
 </desc>
 <version>v1.1.6</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>Line size</return-desc>
 </return>
*/
function getLineWidth
  return number;

/**
 <name>getRowHeight</name>
 <type>Function</type>
 <desc>
  Returns with height of row, see <link>Row_Print2</link>.
 </desc>
  <version>v1.1.3</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells </param-desc>
  </param>
 <param>
  <param-def>p_width plpdf_type.t_row_widths</param-def>
  <param-desc>Width of the cells</param-desc>
 </param>
 <param>
  <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
  <param-desc>Maximum number of lines in a multi-line cell</param-desc>
 </param>
 <param>
  <param-def>p_h number default 5</param-def>
  <param-desc>Height of the cells</param-desc>
  </param>
 </params>
 <return>
  <return-def>number</return-def>
  <return-desc>Height of row</return-desc>
 </return>
*/
function getRowHeight(
  p_data Plpdf_Type.t_row_datas,
  p_width Plpdf_Type.t_row_widths,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_h number default 5
  )  return number;

/**
 <name>getTillingPatternColor</name>
 <type>Function</type>
 <desc>
  Gets the color of filling pattern for objects.
 </desc>
 <version>v1.1.7</version>
 <params>-</params>
 <return>
  <return-def>plpdf_type.t_color</return-def>
  <return-desc>Pattern filling color</return-desc>
 </return>
*/
function getTillingPatternColor
  return plpdf_type.t_color;

/**
 <name>getTillingPatternName</name>
 <type>Function</type>
 <desc>
  Gets the name of filling pattern for objects.
 </desc>
 <version>v1.1.7</version>
 <params>- </params>
 <return>
  <return-def>varchar2</return-def>
 </return>
*/
function getTillingPatternName
  return varchar2;

/**
 <name>getCellMinHeight</name>
 <type>Function</type>
 <desc>
  Gets the minimum cell height (uses current font).
 </desc>
 <version>v2.1.1</version>
 <params>- </params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getCellMinHeight
  return number;

/**
 <name>getCellMinHeightFont</name>
 <type>Function</type>
 <desc>
  Gets the minimum cell height, font is parameter.
 </desc>
 <version>v2.3.0</version>
 <params>
 <param>
   <param-def>p_family varchar2 default null</param-def>
   <param-desc>Font type, null means current font family</param-desc>
   <param-ul>
    <param-li>Helvetica (Arial, Sans Serif)</param-li>
    <param-li>Courier</param-li>
    <param-li>Times (Serif)</param-li>
    <param-li>Symbol</param-li>
    <param-li>ZapfDingBats</param-li>
    <param-li>If TTF fonts were added using the AddTTF procedure then they may be used here as well.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Font style</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI will be Bold and Italic)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_size number default null</param-def>
   <param-desc>Font size, null means current font size</param-desc>
  </param>
 </params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getCellMinHeightFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null
  ) return number;

/**
 <name>getCellMinWidth</name>
 <type>Function</type>
 <desc>
  Gets the minimum cell width (uses current font).
 </desc>
 <version>v2.1.1</version>
 <params>
 <param>
   <param-def>p_txt varchar2</param-def>
   <param-desc>Text for calculating width</param-desc>
  </param>
 </params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getCellMinWidth(
  p_txt varchar2
  ) return number;

/**
 <name>getCellMinWidthFont</name>
 <type>Function</type>
 <desc>
  Gets the minimum cell width, font is parameter.
 </desc>
 <version>v2.3.0</version>
 <params>
 <param>
   <param-def>p_family varchar2 default null</param-def>
   <param-desc>Font type, null means current font family</param-desc>
   <param-ul>
    <param-li>Helvetica (Arial, Sans Serif)</param-li>
    <param-li>Courier</param-li>
    <param-li>Times (Serif)</param-li>
    <param-li>Symbol</param-li>
    <param-li>ZapfDingBats</param-li>
    <param-li>If TTF fonts were added using the AddTTF procedure then they may be used here as well.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Font style</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI will be Bold and Italic)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_size number default null</param-def>
   <param-desc>Font size, null means current font size</param-desc>
  </param>
 <param>
   <param-def>p_txt varchar2</param-def>
   <param-desc>Text for calculating width</param-desc>
  </param>
 </params>
 <return>
  <return-def>number</return-def>
 </return>
*/
function getCellMinWidthFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt varchar2
  ) return number;

/**
 <name>PrintCell</name>
 <type>Procedure</type>
 <desc>
  Draws a rectangle cell with text inside. The rectangle may have a border and fill color specified.
 </desc>
 <version>v2.7.0</version>
 <params>
  <param>
   <param-def>p_w number default 0</param-def>
   <param-desc>Rectangle width, if 0 then the rectangle will extend till the right margin</param-desc>
  </param>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>Rectangle height</param-desc>
   <param-ul>
    <param-li>0: uses last cell height</param-li>
    <param-li>-1: uses minimum cell height</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_txt varchar2 default NULL</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
   <param-def>p_border varchar2 default '0'</param-def>
   <param-desc>Rectangle border</param-desc>
   <param-ul>
    <param-li>0: no border</param-li>
    <param-li>1: outline border</param-li>
    <param-li>L: left side border</param-li>
    <param-li>T: top side border</param-li>
    <param-li>R: right side border</param-li>
    <param-li>B: bottom side border</param-li>
    <param-li>Or a combination of L, T, R and B</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_ln number default 0</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>0: Beside the cell</param-li>
    <param-li>1: New line</param-li>
    <param-li>2: Under the cell</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_align varchar2 default NULL</param-def>
   <param-desc>Text alignment</param-desc>
   <param-ul>
    <param-li>L: left</param-li>
    <param-li>R: right</param-li>
    <param-li>C: </param-li>
    <param-li>J: Force Justification</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_link varchar2 default NULL</param-def>
   <param-desc>Link related to the text, can be a URL or an internal link ID</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 1</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_vert_align varchar2 default NULL</param-def>
   <param-desc>Text vertical alignment in cell</param-desc>
   <param-ul>
    <param-li>T: top</param-li>
    <param-li>B: bottom</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintCell(
  p_w number default 0,
  p_h number  default 0,
  p_txt varchar2 default null,
  p_border varchar2 default '0',
  p_ln number default 0,
  p_align varchar2 default null,
  p_fill number default 0,
  p_link varchar2 default null,
  p_clipping number default 1,
  p_vert_align varchar2 default null
  );

/**
 <name>PrintImageCell</name>
 <type>Procedure</type>
 <desc>
  Print an image with frame.
 </desc>
 <version>v2.1.1</version>
 <params>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>Width of frame</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>Height of frame</param-desc>
  </param>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of image</param-desc>
  </param>
  <param>
   <param-def>p_data blob</param-def>
   <param-desc>image</param-desc>
  </param>
  <param>
   <param-def>p_margin number default 0</param-def>
   <param-desc>margin size of frame</param-desc>
  </param>
  <param>
   <param-def>p_border varchar2 default '0'</param-def>
   <param-desc>Rectangle border</param-desc>
   <param-ul>
    <param-li>0: no border</param-li>
    <param-li>1: outline border</param-li>
    <param-li>L: left side border</param-li>
    <param-li>T: top side border</param-li>
    <param-li>R: right side border</param-li>
    <param-li>B: bottom side border</param-li>
    <param-li>Or a combination of L, T, R and B</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_ln number default 0</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>0: Beside the cell</param-li>
    <param-li>1: New line</param-li>
    <param-li>2: Under the cell</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_link varchar2 default NULL</param-def>
   <param-desc>URL or internal link ID</param-desc>
  </param>
  <param>
   <param-def>p_type varchar2 default null</param-def>
   <param-desc>when use Oracle InterMedia then ignore this param,
    when does not use Oracle InterMedia then JPG or PNG, null means JPG</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintImageCell(
  p_w number,
  p_h number,
  p_name varchar2,
  p_data in out nocopy blob,
  p_margin number default 0,
  p_border varchar2 default '0',
  p_ln number default 0,
  p_fill number default 0,
  p_link varchar2 default null,
  p_type varchar2 default null -- JPG, PNG
  );

/**
 <name>PrintFlowingText</name>
 <type>Procedure</type>
 <desc>
  Prints text continuously. Text is wrapped according to the right margin.
 </desc>
 <version>v2.7.0</version>
 <params>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>Height</param-desc>
  </param>
  <param>
   <param-def>p_txt varchar2 default null</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>URL or internal link ID</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default NULL</param-def>
   <param-desc>Text alignment</param-desc>
   <param-ul>
    <param-li>L: left</param-li>
    <param-li>R: right</param-li>
    <param-li>C: </param-li>
    <param-li>J: Force Justification</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_clipping number default 1</param-def>
   <param-desc>Clipping text</param-desc>
    <param-ul>
     <param-li>0: no clipping</param-li>
     <param-li>1: clipping</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_lastline_j varchar2 default 'L'</param-def>
   <param-desc>justified text last line alignment</param-desc>
   <param-ul>
    <param-li>L: left</param-li>
    <param-li>R: right</param-li>
    <param-li>C: center</param-li>
    <param-li>J: Force Justification</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintFlowingText(
  p_h number default 0,
  p_txt varchar2 default null,
  p_link varchar2 default null,
  p_align varchar2 default null,
  p_clipping number default 1,
  p_lastline_j varchar2 default 'L'
  );

/**
 <name>PrintFlowingTextLimit</name>
 <type>Procedure</type>
 <desc>
  Prints text continuously. Text is wrapped according to the p_min_x and p_max_x.
 </desc>
 <version>v2.7.0</version>
 <params>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>Height</param-desc>
  </param>
  <param>
   <param-def>p_txt varchar2 default null</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>URL or internal link ID</param-desc>
  </param>
  <param>
   <param-def>p_min_x number default 0</param-def>
   <param-desc>min X position, 0 means the limit is the left margin</param-desc>
  </param>
  <param>
   <param-def>p_max_x number default 0</param-def>
   <param-desc>max X position, 0 means the limit is the right margin</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default NULL</param-def>
   <param-desc>Text alignment</param-desc>
   <param-ul>
    <param-li>L: left</param-li>
    <param-li>R: right</param-li>
    <param-li>C: </param-li>
    <param-li>J: Force Justification</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_clipping number default 1</param-def>
   <param-desc>Clipping text</param-desc>
    <param-ul>
     <param-li>0: no clipping</param-li>
     <param-li>1: clipping</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_lastline_j varchar2 default 'L'</param-def>
   <param-desc>justified text last line alignment</param-desc>
   <param-ul>
    <param-li>L: left</param-li>
    <param-li>R: right</param-li>
    <param-li>C: </param-li>
    <param-li>J: Force Justification</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintFlowingTextLimit(
  p_h number default 0,
  p_txt varchar2 default null,
  p_link varchar2 default null,
  p_min_x number default 0,
  p_max_x number default 0,
  p_align varchar2 default null,
  p_clipping number default 1,
  p_lastline_j varchar2 default 'L'
  );

/**
 <name>TextSplit</name>
 <type>function</type>
 <desc>
  Splits text to a number of lines based on the width given
 </desc>
 <version>v2.6.0</version>
 <params>
  <param>
  <param-def>p_txt varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
  <param-def>p_w number</param-def>
   <param-desc>Width of lines</param-desc>
  </param>
  <param>
  <param-def>p_indent number default null</param-def>
   <param-desc>First line Indent</param-desc>
  </param>
  <param>
  <param-def>p_use_cell_margins boolean default true</param-def>
   <param-desc>If true then calculates with cell margins</param-desc>
  </param>
  <param>
   <param-def>p_maxline number default 0</param-def>
   <param-desc>Maximum number of lines returned. If 0 then all lines will be returned.</param-desc>
  </param>
 </params>
 <return>
 <return-def>plpdf_type.t_text_lines</return-def>
  <return-desc>Text as an array</return-desc>
 </return>
*/
function TextSplit(
  p_txt varchar2,
  p_w number,
  p_indent number default null,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

--v2.9.2
function TextSplit(
  p_txt clob,
  p_w number,
  p_indent number default null,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

/**
 <name>TextSplitFont</name>
 <type>function</type>
 <desc>
  Splits text to a number of lines based on the width given, font is parameter
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_family varchar2 default null</param-def>
   <param-desc>Font type, null means current font family</param-desc>
   <param-ul>
    <param-li>Helvetica (Arial, Sans Serif)</param-li>
    <param-li>Courier</param-li>
    <param-li>Times (Serif)</param-li>
    <param-li>Symbol</param-li>
    <param-li>ZapfDingBats</param-li>
    <param-li>If TTF fonts were added using the AddTTF procedure then they may be used here as well.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_style varchar2 default null</param-def>
   <param-desc>Font style</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI will be Bold and Italic)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_size number default null</param-def>
   <param-desc>Font size, null means current font size</param-desc>
  </param>
  <param>
  <param-def>p_txt varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
  <param-def>p_w number</param-def>
   <param-desc>Width of lines</param-desc>
  </param>
  <param>
  <param-def>p_indent number default null</param-def>
   <param-desc>First line Indent</param-desc>
  </param>
  <param>
  <param-def>p_use_cell_margins boolean default true</param-def>
   <param-desc>If true then calculates with cell margins</param-desc>
  </param>
  <param>
   <param-def>p_maxline number default 0</param-def>
   <param-desc>Maximum number of lines returned. If 0 then all lines will be returned.</param-desc>
  </param>
 </params>
 <return>
 <return-def>plpdf_type.t_text_lines</return-def>
  <return-desc>Text as an array</return-desc>
 </return>
*/
function TextSplitFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt varchar2,
  p_w number,
  p_indent number default null,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

--v2.9.2
function TextSplitFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_txt clob,
  p_w number,
  p_indent number default null,
  p_use_cell_margins boolean default true,
  p_maxline number default 0
  ) return plpdf_type.t_text_lines;

/**
 <name>PrintMultiLineCell</name>
 <type>Procedure</type>
 <desc>
  Draws a multi line cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_w number default 0</param-def>
   <param-desc>Rectangle width, if 0 then the rectangle will extend till the right margin</param-desc>
  </param>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>Rectangle height</param-desc>
  </param>
  <param>
   <param-def>p_txt varchar2 default null</param-def>
   <param-desc>Text</param-desc>
  </param>
  <param>
   <param-def>p_border varchar2 default '0'</param-def>
   <param-desc>Rectangle border</param-desc>
   <param-ul>
    <param-li>0: no border</param-li>
    <param-li>1: outline border</param-li>
    <param-li>L: left side border</param-li>
    <param-li>T: top side border</param-li>
    <param-li>R: right side border</param-li>
    <param-li>B: bottom side border</param-li>
    <param-li>Or a combination of L, T, R and B</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_align varchar2 default 'J'</param-def>
   <param-desc>Text alignment</param-desc>
   <param-ul>
    <param-li>L: left</param-li>
    <param-li>R: right</param-li>
    <param-li>C: center</param-li>
    <param-li>J: force justification</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_maxline number default 0</param-def>
   <param-desc>Maximum number of lines displayed. If 0 then all lines will be displayed.</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default NULL</param-def>
   <param-desc>Link related to the text, can be a URL or an internal link ID</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 1</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_indent number default 0</param-def>
   <param-desc>First line Indent</param-desc>
  </param>
  <param>
   <param-def>p_ln number default 1</param-def>
   <param-desc>Cursor position after the cell is printed</param-desc>
   <param-ul>
    <param-li>0: Beside the cell</param-li>
    <param-li>1: New line</param-li>
    <param-li>2: Under the cell</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintMultiLineCell(
  p_w number default 0,
  p_h number default 0,
  p_txt varchar2 default null,
  p_border varchar2 default '0',
  p_align varchar2 default 'J',
  p_fill number default 0,
  p_maxline number default 0,
  p_link varchar2 default null,
  p_clipping number default 1,
  p_indent number default 0,
  p_ln number default 1
  );

/**
 <name>PrintText</name>
 <type>Procedure</type>
 <desc>
  Prints a text starting from the specified position.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the start of the text</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the start of the text</param-desc>
  </param>
  <param>
   <param-def>p_txt varchar2</param-def>
   <param-desc>Text</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintText(
  p_x number,
  p_y number,
  p_txt varchar2
  );

/**
 <name>PutImage</name>
 <type>Procedure</type>
 <desc>
  Inserts an image (JPG, BMP, PNG, etc.) from a BLOB variable into the current page.
  Important: When the source of image is a query, then need to use "FOR UPDATE" clause.
 </desc>
 <version>v2.1.1</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Image name or ID</param-desc>
  </param>
  <param>
   <param-def>p_data blob</param-def>
   <param-desc>Variable containing the image as binary data</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the image</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the image</param-desc>
  </param>
  <param>
   <param-def>p_w number default 0</param-def>
   <param-desc>Image width, if 0 then the image is displayed in its actual width</param-desc>
  </param>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>Image height, if 0 then the image is displayed in its actual height</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default NULL</param-def>
   <param-desc>URL or internal link ID</param-desc>
  </param>
  <param>
   <param-def>p_type varchar2 default null</param-def>
   <param-desc>when use Oracle InterMedia then ignore this param,
    when does not use Oracle InterMedia then JPG or PNG, null means JPG</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PutImage(
  p_name varchar2,
  p_data in out nocopy blob,
  p_x number,
  p_y number,
  p_w number default 0,
  p_h number default 0,
  p_link varchar2 default null,
  p_type varchar2 default null -- JPG, PNG
  );

/**
 <name>PutLink</name>
 <type>Procedure</type>
 <desc>
  Puts a link area on the page that point to an internal link.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of the top left corner of the area</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of the top left corner of the area</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>Link area width</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>Link area height</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2</param-def>
   <param-desc>Internal link ID returned by CrInternalLink</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PutLink(
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_link varchar2
  );

/**
 <name>Row_Print</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print(
  p_data Plpdf_Type.t_row_datas,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_h number default 5,
  p_fill number default 0,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print2</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print2(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_style Plpdf_Type.t_row_styles,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_h number default 5,
  p_fill number default 0,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print2</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill colors</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print2(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_style Plpdf_Type.t_row_styles,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_h number default 5,
  p_fill Plpdf_Type.t_row_filles,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print3</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print3(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_style Plpdf_Type.t_row_styles,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_links plpdf_type.t_row_links,
  p_h number default 5,
  p_fill number default 0,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print3</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
   </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_style plpdf_type.t_row_styles</param-def>
   <param-desc>Style of the cells</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def> p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill color</param-desc></param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print3(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_style Plpdf_Type.t_row_styles,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_links plpdf_type.t_row_links,
  p_h number default 5,
  p_fill Plpdf_Type.t_row_filles,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print4(
  p_data Plpdf_Type.t_row_datas,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_font plpdf_type.t_row_fonts,
  p_h number default 5,
  p_fill number default 0,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print4(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_font Plpdf_Type.t_row_fonts,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_h number default 5,
  p_fill number default 0,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill number default 0</param-def>
   <param-desc>Fill</param-desc>
   <param-ul>
    <param-li>0: no fill</param-li>
    <param-li>1: fill with current fill color</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print4(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_font Plpdf_Type.t_row_fonts,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_links plpdf_type.t_row_links,
  p_h number default 5,
  p_fill number default 0,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
   </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill color</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print4(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_font Plpdf_Type.t_row_fonts,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_h number default 5,
  p_fill Plpdf_Type.t_row_filles,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>Row_Print4</name>
 <type>Procedure</type>
 <desc>
  Prints a full row in the PDF document. The rows consist of multi-line cells.
  The row's height is set according to the largest cell.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_data plpdf_type.t_row_datas</param-def>
   <param-desc>Data shown in the cells</param-desc>
  </param>
  <param>
   <param-def>p_border plpdf_type.t_row_borders</param-def>
   <param-desc>Border array of the cells</param-desc>
  </param>
  <param>
   <param-def>p_width plpdf_type.t_row_widths</param-def>
   <param-desc>Width of the cells</param-desc>
  </param>
  <param>
   <param-def>p_align plpdf_type.t_row_aligns</param-def>
   <param-desc>Alignment of the cells</param-desc>
  </param>
  <param>
   <param-def>p_font plpdf_type.t_row_fonts</param-def>
   <param-desc>Font of the cells (Family is required)</param-desc>
  </param>
  <param>
   <param-def>p_maxline plpdf_type.t_row_maxlines</param-def>
   <param-desc>Maximum number of lines in a multi-line cell</param-desc>
  </param>
  <param>
   <param-def>p_links plpdf_type.t_row_links</param-def>
   <param-desc>Links of the cells</param-desc>
  </param>
  <param>
   <param-def>p_h number default 5</param-def>
   <param-desc>Height of the cells</param-desc>
  </param>
  <param>
   <param-def>p_fill Plpdf_Type.t_row_filles</param-def>
   <param-desc>Fill colors</param-desc>
  </param>
  <param>
   <param-def>p_min_height number default 0</param-def>
   <param-desc>Minimal height of row, 0 means that this parameter is not used</param-desc>
  </param>
  <param>
   <param-def>p_clipping number default 0</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure Row_Print4(
  p_data Plpdf_Type.t_row_datas,
  p_border Plpdf_Type.t_row_borders,
  p_width Plpdf_Type.t_row_widths,
  p_align Plpdf_Type.t_row_aligns,
  p_font Plpdf_Type.t_row_fonts,
  p_maxline Plpdf_Type.t_row_maxlines,
  p_links plpdf_type.t_row_links,
  p_h number default 5,
  p_fill Plpdf_Type.t_row_filles,
  p_min_height number default 0,
  p_clipping number default 0
  );

/**
 <name>setCellMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell margin size.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setCellMargin(
  p_margin number
  );

/**
 <name>setCellBottomMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell bottom margin size.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setCellBottomMargin(
  p_margin number
  );

/**
 <name>setCellLeftMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell left margin size.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setCellLeftMargin(
  p_margin number
  );

/**
 <name>setCellRightMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell right margin size.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setCellRightMargin(
  p_margin number
  );

/**
 <name>setCellTopMargin</name>
 <type>Procedure</type>
 <desc>
  Sets the cell top margin size.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_margin number</param-def>
   <param-desc>Margin size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setCellTopMargin(
  p_margin number
  );

/**
 <name>setColor4Drawing</name>
 <type>Procedure</type>
 <desc>
  Sets the line color for objects (line, rectangle, circle etc.) inserted after this statement.
  Colors must be specified according to the RGB pallet.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_r number</param-def>
   <param-desc>Red component code, can be between 0 and 255</param-desc>
  </param>
  <param>
   <param-def>p_g number default  -1</param-def>
   <param-desc>Green component code, can be between 0 and 255</param-desc>
  </param>
  <param>
   <param-def>p_b number default -1</param-def>
   <param-desc>Blue component code, can be between 0 and 255</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setColor4Drawing(
  p_r number,
  p_g number default  -1,
  p_b number default -1
  );

/**
 <name>setColor4Drawing</name>
 <type>Procedure</type>
 <desc>
  Sets the line color for objects (line, rectangle, circle etc.) inserted after this statement.
  Colors must be specified according to the RGB pallet.
 </desc>
 <version>v1.1.6</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setColor4Drawing(
  p_color plpdf_type.t_color
  );

/**
 <name>setColor4Filling</name>
 <type>Procedure</type>
 <desc>
  Sets the fill color for objects inserted after this statement.
  Colors must be specified according to the RGB pallet.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_r number</param-def>
   <param-desc>Red component code, can be between 0 and 255</param-desc>
  </param>
  <param>
   <param-def>p_g number default  -1</param-def>
   <param-desc>Green component code, can be between 0 and 255</param-desc>
  </param>
  <param>
   <param-def>p_b number default -1</param-def>
   <param-desc>Blue component code, can be between 0 and 255</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setColor4Filling(
  p_r number,
  p_g number default -1,
  p_b number default -1
  );

/**
 <name>setColor4Filling</name>
 <type>Procedure</type>
 <desc>
  Sets the fill color for objects inserted after this statement. Colors must be specified according to the RGB pallet.
 </desc>
 <version>v1.1.6</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setColor4Filling(
  p_color plpdf_type.t_color
  );

/**
 <name>setColor4Text</name>
 <type>Procedure</type>
 <desc>
  Sets the text color for objects inserted after this statement.
  Colors must be specified according to the RGB pallet.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_r number</param-def>
   <param-desc>Red component code, can be between 0 and 255</param-desc>
  </param>
  <param>
   <param-def>p_g number default  -1</param-def>
   <param-desc>Green component code, can be between 0 and 255</param-desc>
  </param>
  <param>
   <param-def>p_b number default -1</param-def>
   <param-desc>Blue component code, can be between 0 and 255</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setColor4Text(
  p_r number,
  p_g number default -1,
  p_b number default -1
  );

/**
 <name>setColor4Text</name>
 <type>Procedure</type>
 <desc>
  Sets the text color for objects inserted after this statement. Colors must be specified according to the RGB pallet.
 </desc>
 <version>v1.1.6</version>
 <params>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>color</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setColor4Text(
  p_color plpdf_type.t_color
  );

/**
 <name>setDashPattern</name>
 <type>Procedure</type>
 <desc>
  Sets the dash pattern for lines inserted after this statement. Call the procedure without parameter to restore normal drawing.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_line number default null</param-def>
   <param-desc> length of dashes</param-desc>
  </param>
  <param>
   <param-def>p_noline number default null</param-def>
   <param-desc> length of gaps</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setDashPattern(
  p_line number default null,
  p_noline number default null
  );

/**
 <name>setJS</name>
 <type>Procedure</type>
 <desc>
  Add JavaScript inside the PDF. See Acrobat JavaScript Reference.
 </desc>
 <version>v2.1.0</version>
 <params>- </params>
 <return>-</return>
*/
procedure setJS(
  p_text varchar2
  );

/**
 <name>setLineWidth</name>
 <type>Procedure</type>
 <desc>
  Sets the thickness of lines drawn after this statement. If no thickness is set then it is 0.2 mm by default.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>Line thickness</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLineWidth(
  p_width number
  );

/**
 <name>setLinkDest</name>
 <type>Procedure</type>
 <desc>
  Sets the destination page and position for the internal link.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_link number</param-def>
   <param-desc>Internal link ID returned by CrInternalLink</param-desc>
  </param>
  <param>
   <param-def>p_y number default 0</param-def>
   <param-desc>Y position on the page, if -1 then the current Y coordinate, if 0 then the top of the page</param-desc>
  </param>
  <param>
   <param-def>p_page number default -1</param-def>
   <param-desc>Page number, if -1 then the current page</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setLinkDest(
  p_link number,
  p_y number default 0,
  p_page number default -1
  );

/**
 <name>setPrintFont</name>
 <type>Procedure</type>
 <desc>
  Sets the font and its properties.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_family varchar2 default NULL</param-def>
   <param-desc>Font type</param-desc>
   <param-ul>
    <param-li>Helvetica (Arial, Sans Serif)</param-li>
    <param-li>Courier</param-li>
    <param-li>Times (Serif)</param-li>
    <param-li>Symbol</param-li>
    <param-li>ZapfDingBats</param-li>
    <param-li>If TTF fonts were added using the AddTTF procedure then they may be used here as well.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_style varchar2 default NULL</param-def>
   <param-desc>Font style</param-desc>
   <param-ul>
    <param-li>null: Regular</param-li>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI will be Bold and Italic)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_size number default 0</param-def>
   <param-desc>Font size, 0 means the current size. If no size has been specified then value is 12. </param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setPrintFont(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default 0
  );

/**
 <name>setPrintFontSize</name>
 <type>Procedure</type>
 <desc>
  Sets the font size. All other font properties remain unchanged.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_size number</param-def>
   <param-desc>Font size</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setPrintFontSize(
  p_size number
  );

/**
 <name>setRotate</name>
 <type>Procedure</type>
 <desc>
  Sets the degree of rotation. Text and images can both be rotated.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_angle number</param-def>
   <param-desc>Angle/degree of rotation</param-desc>
  </param>
  <param>
   <param-def>p_x number default -1</param-def>
   <param-desc>X coordinate of the rotation point, if -1 then the X coordinate of the cursor</param-desc>
  </param>
  <param>
   <param-def>p_y number default -1</param-def>
   <param-desc>Y coordinate of the rotation point, if -1 then the Y coordinate of the cursor</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setRotate(
  p_angle number,
  p_x number default -1,
  p_y number default -1
  );

/**
 <name>setTillingPattern</name>
 <type>Procedure</type>
 <desc>
  Sets the fill pattern for objects inserted after this statement.
 </desc>
 <version>v1.2.4</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of pattern, see <link>CrTillingPattern</link></param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color</param-def>
   <param-desc>color of "graphical figures"</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure setTillingPattern(
  p_name varchar2,
  p_color plpdf_type.t_color default null
  );

/**
 <name>startClipping</name>
 <type>Procedure</type>
 <desc>
  Starts a clipping frame. The clipping limits the region that can be paint. The clipping affects for
  objects wich located between StartClipping and EndClipping.
 </desc>
 <version>v2.3.0</version>
 <params>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the start of the clipping frame</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the start of the clipping frame</param-desc>
  </param>
  <param>
   <param-def>p_w number</param-def>
   <param-desc>height of clipping frame</param-desc>
  </param>
  <param>
   <param-def>p_h number</param-def>
   <param-desc>width of clipping frame</param-desc>
  </param>
  <param>
   <param-def>p_end_prev boolean default true</param-def>
   <param-desc>closes previous clipping before start a new clipping</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure startClipping(
  p_x number,
  p_y number,
  p_w number,
  p_h number,
  p_end_prev boolean default true
  );

/**
 <name>startOpacity</name>
 <type>Procedure</type>
 <desc>
  Starts a transparency. The transparency affects for
  objects wich located between StartOpacity and EndOpacity.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_val number</param-def>
   <param-desc>can be a value from 0.0 - 1.0. A lower value makes the element more transparent.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure startOpacity(
  p_val number
  );

/**
 <name>startOptCont</name>
 <type>Procedure</type>
 <desc>
  Start an optional content.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>name of optional content</param-desc>
  </param>
  <param>
   <param-def>p_state boolean default true</param-def>
   <param-desc>dafault state is visible or invisible</param-desc>
  </param>
  <param>
   <param-def>p_ui_order boolean default true</param-def>
   <param-desc>insert into the state array</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default true</param-def>
   <param-desc>printed out</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure startOptCont(
  p_name varchar2,
  p_state boolean default true,
  p_ui_order boolean default true,
  p_print boolean default true
  );

------------------------------------------------------------------------------
/**
 <newpage/>
 <h1>Table Of Contents Commands</h1>
 <br/>
*/
------------------------------------------------------------------------------

/**
 <name>AddTOCItem</name>
 <type>Procedure</type>
 <desc>
  Add Table of Contents item.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_txt varchar2</param-def>
   <param-desc>label of TOC item</param-desc>
  </param>
  <param>
   <param-def>p_level number default 0</param-def>
   <param-desc>level, 0 is the highest level</param-desc>
  </param>
  <param>
   <param-def>p_y number default -1</param-def>
   <param-desc>Y position on the page, if -1 then the current Y coordinate, if 0 then the top of the page</param-desc>
  </param>
  <param>
   <param-def>p_page number default -1</param-def>
   <param-desc>Page number, if -1 then the current page</param-desc>
  </param>
  <param>
   <param-def>p_add_link boolean default true</param-def>
   <param-desc>create link from TOC item to page</param-desc>
  </param>
  <param>
   <param-def>p_add_bookmark boolean default false</param-def>
   <param-desc>create bookmark for TOC item</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddTOCItem(
  p_txt varchar2,
  p_level number default 0,
  p_y number default -1,
  p_page number default -1,
  p_add_link boolean default true,
  p_add_bookmark boolean default false
  );

/**
 <name>AddTOC</name>
 <type>Procedure</type>
 <desc>
  Construct Table of Contents.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_item_height number default null</param-def>
   <param-desc>height of TOC item cell</param-desc>
  </param>
  <param>
   <param-def>p_stop_footer boolean default true</param-def>
   <param-desc>do not print footer (by executing the footer procedure) in TOC</param-desc>
  </param>
  <param>
   <param-def>p_title_font_family varchar2 default null</param-def>
   <param-desc>font family of title text</param-desc>
  </param>
  <param>
   <param-def>p_title_font_style varchar2 default null</param-def>
   <param-desc>font style (bold, italic, etc.) of title text</param-desc>
  </param>
  <param>
   <param-def>p_title_font_size number default 0</param-def>
   <param-desc>font size of title text</param-desc></param>
  <param>
   <param-def>p_title_height number default null</param-def><param-desc>height of title's cell</param-desc>
  </param>
  <param>
   <param-def>p_title_text varchar2  default null</param-def>
   <param-desc>title of TOC if title is null then no title will be printed</param-desc>
  </param>
  <param>
   <param-def>p_title_body_gap number default 0</param-def>
   <param-desc>gap between title and TOC items</param-desc>
  </param>
  <param>
   <param-def>p_item_font_family varchar2 default null</param-def>
   <param-desc>font family of TOC items</param-desc>
  </param>
  <param>
   <param-def>p_item_font_style varchar2 default null</param-def>
   <param-desc>font style of TOC items</param-desc>
  </param>
  <param>
   <param-def>p_item_font_size number default 0</param-def>
   <param-desc>font size of TOC items</param-desc>
  </param>
  <param>
   <param-def>p_level_indent number  default 0</param-def>
   <param-desc>indent size for levels</param-desc>
  </param>
  <param>
   <param-def>p_separator varchar2 default ' '</param-def>
   <param-desc>filler between TOC item and page number</param-desc>
  </param>
   <param><param-def>p_move_to number default 0</param-def>
   <param-desc>move TOC pages to a new page number in PDF</param-desc>
  </param>
   <param><param-def>p_custom_proc varchar2 default null</param-def>
   <param-desc>if a custom procedure is used for creating TOC then it is the name of procedure</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AddTOC(
  p_item_height number default null,
  p_stop_footer boolean default true,
  p_title_font_family varchar2 default null,
  p_title_font_style varchar2 default null,
  p_title_font_size number default 0,
  p_title_height number default null,
  p_title_text varchar2  default null,
  p_title_body_gap number default 0,
  p_item_font_family varchar2 default null,
  p_item_font_style varchar2 default null,
  p_item_font_size number default 0,
  p_level_indent number  default 0,
  p_separator varchar2 default ' ',
  p_move_to number default 0,
  p_custom_proc varchar2 default null
  );

/**
 <name>InTOC</name>
 <type>Function</type>
 <desc>
  Is current position inside TOC.
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>
  <return-def>boolean</return-def>
  <return-desc>Current positin</return-desc>
 </return>
*/
function InTOC
  return boolean;

/**
 <name>GetTOCPageNum</name>
 <type>Function</type>
 <desc>
  If actual position is inside TOC then returns page number (first page of TOC returns 1).
 </desc>
 <version>v1.4.0</version>
 <params>-</params>
 <return>
  <return-def>number</return-def>
  <return-desc>actual position</return-desc>
 </return>
*/
function GetTOCPageNum
  return number;

/**
 <name>PrintTOCItem</name>
 <type>Procedure</type>
 <desc>
  Print a TOC Item into the PDF (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_item plpdf_type.tr_toc</param-def>
   <param-desc>TOC Item</param-desc>
  </param>
  <param>
   <param-def>p_toc_level_indent number default 0</param-def>
   <param-desc>indent size for levels</param-desc>
  </param>
  <param>
   <param-def>p_toc_item_height number</param-def>
   <param-desc>height of TOC item cell</param-desc>
  </param>
  <param>
   <param-def>p_toc_separator varchar2 default '' ''</param-def>
   <param-desc>filler between TOC item and page number</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintTOCItem(
  p_item plpdf_type.tr_toc,
  p_toc_level_indent number default 0,
  p_toc_item_height number,
  p_toc_separator varchar2 default ' '
  );

/**
 <name>PrintTOCItem1</name>
 <type>Procedure</type>
 <desc>
  Print a TOC Item into the PDF with settings specified in <link>AddTOC</link>(for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_item plpdf_type.tr_toc</param-def>
   <param-desc>TOC Item</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintTOCItem1(
  p_item plpdf_type.tr_toc
  );

/**
 <name>TOCInsertGap</name>
 <type>Procedure</type>
 <desc>
  Insert gap between title and items (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_toc_title_body_gap number</param-def>
   <param-desc>size of gap</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure TOCInsertGap(
  p_toc_title_body_gap number
  );

/**
 <name>TOCInsertGap1</name>
 <type>Procedure</type>
 <desc>
  Insert gap between title and items with settings specified in <link>AddTOC</link>(for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>-</return>
*/
procedure TOCInsertGap1;

/**
 <name>PrintTOCTitle</name>
 <type>Procedure</type>
 <desc>
  Insert title section in TOC (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_toc_title_text varchar2 default null</param-def>
   <param-desc>text of title</param-desc>
  </param>
  <param>
   <param-def>p_toc_title_height number default null</param-def>
   <param-desc>height of title's cell</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintTOCTitle(
  p_toc_title_text varchar2 default null,
  p_toc_title_height number default null
  );

/**
 <name>PrintTOCTitle1</name>
 <type>Procedure</type>
 <desc>
  Insert title section in TOC with settings specified in <link>AddTOC</link>(for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>-</return>
*/
procedure PrintTOCTitle1;

/**
 <name>getTOCItems</name>
 <type>Function</type>
 <desc>
  Returns array of TOC items (for creating custom TOC).
 </desc>
 <version>v1.4.0</version>
 <params>- </params>
 <return>
  <return-def>plpdf_type.t_toc</return-def>
 </return>
*/
function getTOCItems
  return plpdf_type.t_toc;

/**
 <name>InsMoveTOC</name>
 <type>Procedure</type>
 <desc>
  Move TOC to specified page number.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_move_to number</param-def>
   <param-desc>page number</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure InsMoveTOC(
  p_move_to number
  );

/**
 <name>InsMoveTOC1</name>
 <type>Procedure</type>
 <desc>
  Move TOC to specified page number using p_move_to parameter in AddTOC.
 </desc>
 <version>v1.4.0</version>
 <params>-</params>
 <return>-</return>

*/
procedure InsMoveTOC1;

------------------------------------------------------------------------------
/**
 <newpage/>
 <h1>Template Related Commands</h1>
 <br/>
*/
------------------------------------------------------------------------------

/**
 <name>InsTemplate</name>
 <type>Function</type>
 <desc>
  Insert a template into the pdf.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_tpl</param-def>
   <param-desc>template data</param-desc>
  </param>
 </params>
 <return>
  <return-def>number</return-def>
  <return-desc>template ID</return-desc>
 </return>
*/
function InsTemplate(
  p_tpl plpdf_type.tr_tpl_data
  ) return number;

/**
 <name>UseTemplate</name>
 <type>Procedure</type>
 <desc>
  Use a template.
 </desc>
 <version>v1.4.0</version>
 <params>
  <param>
   <param-def>p_tplidx number</param-def>
   <param-desc>template ID</param-desc>
  </param>
  <param>
   <param-def>p_fittopage boolean default true</param-def>
   <param-desc>fit template to page size</param-desc>
  </param>
 </params>
 <return>-</return>

*/
procedure UseTemplate(
  p_tplidx number,
  p_fittopage boolean default true
  );

/**
 <name>DefaultTemplate</name>
 <type>Procedure</type>
 <desc>
  Set template for all new page. Remove template when p_tplidx is null.
 </desc>
 <version>v2.3.1</version>
 <params>
  <param>
   <param-def>p_tplidx number</param-def>
   <param-desc>template ID</param-desc>
  </param>
  <param>
   <param-def>p_fittopage boolean default true</param-def>
   <param-desc>fit template to page size</param-desc>
  </param>
 </params>
 <return>-</return>

*/
procedure DefaultTemplate(
  p_tplidx number,
  p_fittopage boolean default true
  );

------------------------------------------------------------------------------
/**
 <newpage/>
 <h1>Acroform Related Commands</h1>
 <br/>
*/
------------------------------------------------------------------------------

/**
 <name>AcroForm_AddCheckBoxField</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add CheckBoxField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>Caption of button</param-desc>
  </param>
  <param>
   <param-def>p_checked boolean default false</param-def>
   <param-desc>If set, the checkbox is checked</param-desc>
  </param>
  <param>
   <param-def>p_default_checked boolean default false</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc></param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_gap number default 0</param-def>
   <param-desc>gap bettween graphical symbol and text</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AcroForm_AddCheckBoxField(
  p_name varchar2,
  p_label varchar2 default null,
  p_checked boolean default false,
  p_default_checked boolean default false,
  p_read_only boolean default false,
  p_required boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_x number,
  p_y number,
  p_height number,
  p_gap number default 0,
  p_fill_color plpdf_type.t_color default plpdf_const.Black,
  p_hint varchar2 default null
  );

/**
 <name>AcroForm_AddChoiceField</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add ChoiceField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_values plpdf_type.t_opt_array</param-def>
   <param-desc>value set of field</param-desc>
  </param>
  <param>
   <param-def>p_value varchar2 default null</param-def>
   <param-desc>value of field</param-desc>
  </param>
  <param>
   <param-def>p_default_value varchar2 default null</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_combo boolean default false</param-def>
   <param-desc>If set, the field is a combo box; if clear, the field is a list box</param-desc>
  </param>
  <param>
   <param-def>p_edit boolean default false</param-def>
   <param-desc>If set, the combo box includes an editable text box as well as a drop list</param-desc>
  </param>
  <param>
   <param-def>p_short boolean default false</param-def>
   <param-desc>If set, the field's option items should be sorted alphabetically</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc>
  </param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>The width of the field</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default 0</param-def>
   <param-desc>width of border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>color of border</param-desc>
  </param>
  <param>
   <param-def>p_font_size_auto boolean default false</param-def>
   <param-desc>If set, the text's size is automatic else use size of current font.</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AcroForm_AddChoiceField(
  p_name varchar2,
  p_values plpdf_type.t_opt_array,
  p_value varchar2 default null,
  p_default_value varchar2 default null,
  p_combo boolean default false,
  p_edit boolean default false,
  p_sort boolean default false,
  p_read_only boolean default false,
  p_required boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_font_size_auto boolean default false,
  p_hint varchar2 default null
  );

/**
 <name>AcroForm_AddPushbutton</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add Push button
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_label varchar2 default null</param-def>
   <param-desc>Caption of button</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_width number</param-def>
   <param-desc>The width of the field</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_action varchar2 default null</param-def>
   <param-desc>supported actions</param-desc>
   <param-ul>
    <param-li>plpdf_const.button_action_submitform: A submit-form action transmits the names and values of selected interactive form
     fields to a specified uniform resource locator (URL), presumably the address of a
     World Wide Web server that will process them and send back a response.</param-li>
    <param-li>plpdf_const.button_action_resetform: A reset-form action resets selected interactive form fields to their default values.</param-li>
    <param-li>plpdf_const.button_action_javascript: A JavaScript action causes a script to be compiled and executed by the JavaScript interpreter.</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_url varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_submitformA URL specification giving the uniform resource
    locator (URL) of the script at the Web server that will process the submission.</param-desc>
  </param>
  <param>
   <param-def>p_submitformat varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_submitform format of submitted data</param-desc>
   <param-ul>
    <param-li>plpdf_const.submit_format_html: HTML Form format</param-li>
    <param-li>plpdf_const.submit_format_fdf: Forms Data Format (FDF)</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_request varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_submitform: form of request</param-desc>
   <param-ul>
    <param-li>plpdf_const.submit_request_post: using an HTTP POST request</param-li>
    <param-li>plpdf_const.submit_request_get: using an HTTP GET request</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_IncludeNoValueFields boolean default false</param-def>
   <param-desc>If clear, fields without a value are not submitted.</param-desc>
  </param>
  <param>
   <param-def>p_SubmitCoordinates boolean default false</param-def>
   <param-desc>when action is plpdf_const.button_action_submitform: If set, the coordinates of the mouse click
    that caused the submit-form action are transmitted as part of the form data.</param-desc>
  </param>
  <param>
   <param-def>p_javascript varchar2 default null</param-def>
   <param-desc>when action is plpdf_const.button_action_javascript: A string containing the JavaScript script to be executed.</param-desc>
  </param>
  <param>
  <param-def>p_print boolean default false</param-def>
  <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
  <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
  <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default 0</param-def>
   <param-desc>width of border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>color of border</param-desc>
  </param>
  <param>
   <param-def>p_font_size_auto boolean default false</param-def>
   <param-desc>If set, the text's size is automatic else use size of current font.</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AcroForm_AddPushbutton(
  p_name varchar2,
  p_label varchar2 default null,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_action varchar2 default null,
  p_url varchar2 default null,
  p_submitformat varchar2 default null,
  p_request varchar2 default null,
  p_IncludeNoValueFields boolean default false,
  p_SubmitCoordinates boolean default false,
  p_javascript varchar2 default null,
  p_print boolean default false,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_font_size_auto boolean default false,
  p_hint varchar2 default null
  );

/**
 <name>AcroForm_AddRadiobuttonField</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add RadiobuttonField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
  </param>
  <param>
   <param-def>p_values plpdf_type.t_radiobutton_array</param-def>
   <param-desc>value set of field</param-desc>
  </param>
  <param>
   <param-def>p_value varchar2 default null</param-def>
   <param-desc>value of field</param-desc>
  </param>
  <param>
   <param-def>p_default_value varchar2 default null</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc>
  </param>
  <param>
   <param-def>p_NoToggleToOff  boolean default false</param-def>
   <param-desc>If set, exactly one radio button must be selected at all times</param-desc>
  </param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_height number</param-def>
   <param-desc>The height of the field</param-desc>
  </param>
  <param>
   <param-def>p_gap number default 0</param-def>
   <param-desc>gap bettween graphical symbol and text</param-desc>
  </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure AcroForm_AddRadiobuttonField(
  p_name varchar2,
  p_values plpdf_type.t_radiobutton_array,
  p_value varchar2 default null,
  p_default_value varchar2 default null,
  p_read_only boolean default false,
  p_required boolean default false,
  p_NoToggleToOff  boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_height number,
  p_gap number default 0,
  p_fill_color plpdf_type.t_color default plpdf_const.Black,
  p_hint varchar2 default null
  );

/**
 <name>AcroForm_AddTextField</name>
 <type>Procedure</type>
 <desc>
  AcroForm: Add TextField
 </desc>
 <version>v1.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>identifier of object</param-desc>
   </param>
  <param>
   <param-def>p_value varchar2 default null</param-def>
   <param-desc>value of field</param-desc>
  </param>
  <param>
   <param-def>p_default_value varchar2 default null</param-def>
   <param-desc>The default value to which the field reverts when a reset-form action is executed</param-desc>
  </param>
  <param>
   <param-def>p_maxlength number default 0</param-def>
   <param-desc>The maximum length of the field's text, in characters</param-desc>
  </param>
  <param>
   <param-def>p_multiline boolean default false</param-def>
   <param-desc>If set, the field may contain multiple lines of text</param-desc>
  </param>
  <param>
   <param-def>p_password boolean default false</param-def>
   <param-desc>If set, the field is intended for entering a secure password that should not be echoed visibly to the screen</param-desc>
  </param>
  <param>
   <param-def>p_read_only boolean default false</param-def>
   <param-desc>If set, the user may not change the value of the field</param-desc>
  </param>
  <param>
   <param-def>p_required boolean default false</param-def>
   <param-desc>If set, the field must have a value at the time it is exported by a submit-form action</param-desc>
  </param>
  <param>
   <param-def>p_noexport boolean default false</param-def>
   <param-desc>If set, the field must not be exported by a submitform action</param-desc>
  </param>
  <param>
   <param-def>p_print boolean default false</param-def>
   <param-desc>If set, print the field when the page is printed</param-desc>
  </param>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate for the field</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate for the field</param-desc>
   </param>
   <param>
    <param-def>p_width number</param-def>
    <param-desc>The width of the field</param-desc>
   </param>
   <param>
    <param-def>p_height number</param-def>
    <param-desc>The height of the field</param-desc>
   </param>
   <param>
    <param-def>p_align varchar2 default null</param-def>
    <param-desc>Text alignment</param-desc>
    <param-ul>
     <param-li>L: left (default)</param-li>
     <param-li>R: right</param-li>
     <param-li>C: center</param-li>
    </param-ul>
   </param>
  <param>
   <param-def>p_fill_color plpdf_type.t_color default plpdf_const.White</param-def>
   <param-desc>color for filling the field</param-desc>
  </param>
  <param>
   <param-def>p_border_width number default 0</param-def>
   <param-desc>width of border of the field</param-desc>
  </param>
  <param>
   <param-def>p_border_color plpdf_type.t_color default plpdf_const.Black</param-def>
   <param-desc>color of border</param-desc>
  </param>
  <param>
   <param-def>p_font_size_auto boolean default false</param-def>
   <param-desc>If set, the text's size is automatic else use size of current font.</param-desc>
  </param>
  <param>
   <param-def>p_hint varchar2 default null</param-def>
   <param-desc>The user name to be used when generating error or status messages for the field</param-desc>
  </param>
 </params>
 <return>-</return>

*/
procedure AcroForm_AddTextField(
  p_name varchar2,
  p_value varchar2 default null,
  p_default_value varchar2 default null,
  p_maxlength number default 0,
  p_multiline boolean default false,
  p_password boolean default false,
  p_read_only boolean default false,
  p_required boolean default false,
  p_noexport boolean default false,
  p_print boolean default false,
  p_x number,
  p_y number,
  p_width number,
  p_height number,
  p_align varchar2 default null,
  p_fill_color plpdf_type.t_color default plpdf_const.White,
  p_border_width number default 0,
  p_border_color plpdf_type.t_color default plpdf_const.Black,
  p_font_size_auto boolean default false,
  p_hint varchar2 default null
  );

/**
 <name>setDigSig</name>
 <type>Procedure</type>
 <desc>
  Set digital signature appearances.
 </desc>
 <version>v2.5.0</version>
 <params>
  <param>
   <param-def>p_Name varchar2 default null</param-def>
   <param-desc>The name of the person or authority signing the document.</param-desc>
  </param>
  <param>
   <param-def>p_Location varchar2 default null</param-def>
   <param-desc>The CPU host name or physical location of the signing.</param-desc>
  </param>
  <param>
   <param-def>p_Reason varchar2 default null</param-def>
   <param-desc>The reason for the signing, such as (I agree).</param-desc>
  </param>
  <param>
   <param-def>p_ContactInfo varchar2 default null</param-def>
   <param-desc>Information provided by the signer to allow a recipient to contact the signer to verify the signature; for example, a phone number.</param-desc>
  </param>
  <param>
   <param-def>p_x number default 0</param-def>
   <param-desc>X coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_y number default 0</param-def>
   <param-desc>Y coordinate for the top left corner of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_w number default 0</param-def>
   <param-desc>The width of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>The height of the rectangle</param-desc>
  </param>
  <param>
   <param-def>p_access_perms</param-def>
   <param-desc>The access permissions granted for this document. Defined values are:</param-desc>
   <param-ul>
     <param-li>1: No changes to the document are permitted; any change to the document invalidates the signature.</param-li>
     <param-li>2: Permitted changes are filling in forms, instantiating page templates, and signing; other changes invalidate the signature.</param-li>
     <param-li>3: Permitted changes are those allowed by 2, as well as annotation creation, deletion, and modification; other changes invalidate the signature.</param-li>
    </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure setDigSig(
  p_Name varchar2 default null,
  p_Location varchar2 default null,
  p_Reason varchar2 default null,
  p_ContactInfo varchar2 default null,
  p_x number default 0,
  p_y number default 0,
  p_w number default 0,
  p_h number default 0,
  p_access_perms number default 1
  );
------------------------------------------------------------------------------
--INTERNAL PROCEDURES and FUNCTIONS
function getFontInfo(
  p_fontkey varchar2
  ) return plpdf_type.t_font_info;
--v2.7.0
function getEncrypted
  return boolean;
--v2.7.0
function getEncrytionKey
  return raw;
--v2.7.0
function getN
  return number;

--v2.9.0
procedure get_font_3(
  p_family varchar2 default null,
  p_style varchar2 default null,
  p_size number default null,
  p_name out varchar2,
  p_type out varchar2,
  p_cw out plpdf_type.t_cw
  );

--v2.9.0
procedure get_font_3_curr(
  p_name out varchar2,
  p_type out varchar2,
  p_cw out plpdf_type.t_cw
  );
--v2.9.0
function inHeader
  return boolean;
--v2.9.0
function inFooter
  return boolean;
--v2.9.0
function inHeaderFooter
  return boolean;
--v2.9.1
function getTextDir
  return varchar2;
--v2.9.1
procedure setTextConvert(
  p_val boolean
  );
--v2.9.1
function getMirroring
  return boolean;
--v2.9.1
procedure setTextReverse(
  p_val boolean
  );
--v2.9.1
function getRTOL
  return boolean;
-------------------------------------------------------
/**
 <newpage/>
 <h1>Version History</h1>
 <br/>
 */
-------------------------------------------------------

/**
 <h2>23-JUL-2008, v2.0.0</h2>
 <p>- setDocDisplayMode: doc extended</p>
 <p>- native PNG support (PrintImageCell, PutImage p_type)</p>
 <p>- use without InterMedia</p>
 <p>- PrintFlowingTextLimit: bad charter handling fixed</p>
 <p>- PrintMultiLineCell: bad charter handling fixed</p>
 <p>- compress: LZW without Java</p>
 <p>- setCompress: new parameter: p_method</p>
 <p>- plpdf_const package: new entries</p>
 <p>- PutImage: new parameter: p_type</p>
 <p>- PrintImageCell: new parameter: p_type</p>
  <h2>16-MAR-2009, v2.1.0</h2>
 <p>- AcroForm_AddPushbutton.p_fill_color: handle null</p>
 <p>- StartOpacity: new procedure</p>
 <p>- EndOpacity: new procedure</p>
 <p>- StartOptCont: new procedure</p>
 <p>- EndOptCont: new procedure</p>
 <p>- setJS: multiline support</p>
 <p>- getPrintFontStyle: fix underline</p>
 <p>- setCellLeftMargin: new procedure</p>
 <p>- setCellRightMargin: new procedure</p>
 <p>- setCellTopMargin: new procedure</p>
 <p>- setCellBottomMargin: new procedure</p>
 <p>- getCellLeftMargin: new procedure</p>
 <p>- getCellRightMargin: new procedure</p>
 <p>- getCellTopMargin: new procedure</p>
 <p>- getCellBottomMargin: new procedure</p>
 <p>- PrintFlowingTextLimit: p_clipping: new parameter</p>
 <p>- PrintFlowingText: p_clipping: new parameter</p>
 <p>- Row_Print: p_clipping: new parameter</p>
 <p>- Row_Print2: p_clipping: new parameter</p>
 <p>- Row_Print3: p_clipping: new parameter</p>
 <p>- Row_Print4: p_clipping: new parameter</p>
 <h2>01-AUG-2009, v2.2.0</h2>
 <p>- setRTOL: new procedure</p>
 <p>- getPageLeftSpace: new function</p>
 <p>- TextSplit: new function</p>
 <p>- getPageLeftSpace: new function</p>
 <p>- getPageSpace: new function</p>
 <p>- setRTOL: new procedure</p>
 <p>- getCellMinHeight: new function</p>
 <p>- getCellMinWidth: new function</p>
 <p>- extended image support: plpdf_img2 package</p>
 <p>- supported image types: JPEG, GIF, PNG</p>
 <p>- merged plpdf_text package: plpdf_text2</p>
 <p>- native TTF parser: plpdf_ttf_parser, plpdf_gl</p>
 <p>- PrintFlowingTextLimit: new parameter</p>
 <p>- PrintFlowingText: new parameter</p>
 <h2>22-MAR-2010, v2.3.0</h2>
 <p>- CertKeyCheck: new function</p>
 <p>- getLeftMargin: new function</p>
 <p>- getRightMargin: new function</p>
 <p>- getTopMargin: new function</p>
 <p>- getBottomMargin: new function</p>
 <p>- getHeaderHeight: new function</p>
 <p>- getFooterHeight: new function</p>
 <p>- getTextWidthFont: new function</p>
 <p>- AddScreenAnnotURL: new procedure</p>
 <p>- AddScreenAnnotFile: new procedure</p>
 <p>- getCellMinHeightFont: new function</p>
 <p>- getCellMinWidthFont: new function</p>
 <p>- PrintCell: new parameter: p_vert_align</p>
 <p>- TextSplit: new parameter: p_maxline</p>
 <p>- TextSplitFont: new function</p>
 <p>- setLineWidth: fixed</p>
 <p>- StartClipping: new parameter: p_end_prev</p>
 <p>- setPDFA1B: new procedure</p>
 <h2>07-OCT-2010, v2.3.1</h2>
 <p>- DefaultTemplate: new procedure</p>
 <h2>01-DEC-2010, v2.4.0</h2>
 <p>- setDigSig: new procedure</p>
 <h2>01-MAR-2011, v2.5.0</h2>
 <p>- new: advanced compress, min req is 10gR2</p>
 <p>- new: advanced protection (RC4), min req is 10gR2</p>
 <p>- fix: PDF/A with protection</p>
 <p>- new: SetRotatePages procedure</p>
 <p>- fix: DrawPolygon extend length of string</p>
 <p>- fix: setDigSig set parameters default value</p>
 <h2>08-DEC-2011, v2.6.0</h2>
 <p>- new: handling non ascii characters in metadata</p>
 <p>- AddTTF: new parameter: p_embed</p>
 <p>- TextSplit: fixed</p>
 <h2>14-JUN-2012, v2.7.0</h2>
 <p>- setpagenostart, setpagenoend: fixed restart</p>
 <p>- printflowingtext, printflowintextlimit: fixed null parameter</p>
 <p>- temporary blob: fixed a missing parameter</p>
 <p>- setID: new procedure</p>
 <p>- attachfile: fixed special characters in filename</p>
 <p>- RemoveMissingChars: missing character handling</p>
 <h2>01-FEB-2013, v2.8.0</h2>
 <p>- source code optimalization</p>
 <p>- AttachFile: p_filename: extend the length</p>
 <h2>01-JUL-2013, v2.9.0</h2>
 <p>- setHeaderProcName5: new procedure</p>
 <p>- setFooterProcName5: new procedure</p>
 <h2>05-AUG-2013, v2.9.1</h2>
 <p>- plpdf_rtol: modified handling</p>
 <h2>05-NOV-2014, v2.9.2</h2>
 <p>- fix: text field</p>
 <p>- new: nopAlias, p_align parameter</p>
 <p>- TextSplit: new CLOB splitter</p>
 <p>- TextSplitFont: new CLOB splitter</p>
 <p>- Remove ACL dependencies</p>
*/
end plpdf;
/

