create or replace
procedure xhtml_multi_pages as
  -- the first source
  l_src clob := 
  '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"' ||
    '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' ||
  '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">' ||
    '<head>' ||
      '<meta name="author" content="PL/PDF" />' ||
      '<title>PL/PDF XHTML Examples - XHTML_MULTI_PAGES</title>' ||
    '</head>' ||
    '<body>' ||
      '<h1>' ||
        'PL/PDF' ||
      '</h1>' ||
      '<h4>' ||
        'This example represents: <br/> how to write more XHMTL pages and another content into one PDF document.' ||
      '</h4>' ||
    '</body>' ||
  '</html>';
  -- second source file
  l_src2 clob := 
  '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"' ||
    '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' ||
  '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">' ||
    '<head>' ||
      '<meta name="author" content="PL/PDF" />' ||
      '<title>PL/PDF XHTML Examples - XHTML_MULTI_PAGES</title>' ||
    '</head>' ||
    '<body>' ||
      '<h1>' ||
        'PL/PDF' ||
      '</h1>' ||
      '<h2>' ||
        'Second XHTML Page.' ||
      '</h2>' ||
    '</body>' ||
  '</html>';
  -- third source file
  l_src3 clob := 
  '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"' ||
    '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' ||
  '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">' ||
    '<head>' ||
      '<meta name="author" content="PL/PDF" />' ||
      '<title>PL/PDF XHTML Examples - XHTML_MULTI_PAGES</title>' ||
    '</head>' ||
    '<body>' ||
      '<h1>' ||
        'PL/PDF' ||
      '</h1>' ||
      '<h2>' ||
        'Third XHTML page' ||
      '</h2>' ||
    '</body>' ||
  '</html>';
  -- target pdf
  v_out blob; 
begin
  -- initialize
  plpdf.init();
  -- create a new page
  plpdf.newpage();
  -- config XHTML processor
  plpdf_xhtml.config();
  -- convert the first XHTML document
  plpdf_xhtml.xhtml_to_pdf(l_src);
  -- new page
  plpdf.newpage;
  -- set font properties
  plpdf.setprintfont('Courier',null,14);
  -- write non-XHMTL content into PDF
  plpdf.printflowingtext( 
    p_h => 10, 
    p_txt => 'This is not a converted XHTML.' || 
             ' This text was written by PLPDF.PrintFlowingText between two XHTML documents.');
  plpdf.newpage;
  -- reset PLPDF_XHTML
  plpdf_xhtml.config();
  -- reset PLPDF_XHTML
  plpdf_xhtml.config();
  -- convert the second XHTML document
  plpdf_xhtml.xhtml_to_pdf(l_src2);
  -- new page
  plpdf.newpage;
  -- reset PLPDF_XHTML
  plpdf_xhtml.config();
  -- convert the third XHTML document and send the full PDF into v_out
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src3);
  /* The previous line is equivalent with this: 
  plpdf_xhtml.xhtml_to_pdf(l_src3);  -- convert the third document
  plpdf.senddoc(v_out);              -- send and close the full PDF into v_out
  */
  -- save result
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_multi_pages;

