create or replace
procedure xhtml_img as
  -- Create source CLOB.(it is able also to select from arbitrary table)
  l_src clob := 
  '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" ' ||
    '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' ||
  '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">' ||
    '<head>' ||
      '<meta name="author" content="PL/PDF" />' ||
      '<title>PL/PDF XHTML Examples - Images</title>' ||
    '</head>' ||
    '<body>' ||
      '<h2>Image Example</h2>' ||
      '<hr />' ||
      '<h4>Full size image</h4>' ||
      '<p>' ||
        '<img alt="img001" src="rj45.jpg" />' ||
      '</p>' ||
      '<hr />' ||
      '<h4>Same image with specified size</h4>' ||
      '<p>' ||
        '<img width="100" height="100" alt="img002" src="rj45.jpg" />' ||
      '</p>' ||
      '<hr/>' ||
      '<h4>Inline text example</h4>' ||
      '<p>' ||
        'Mauris in est lorem, id lacinia ligula. ' ||
        '<img alt="img003" src="1010.jpg" />' ||
        'Pellentesque euismod elit ante, ac suscipit lorem. Etiam ut odio tortor, ut placerat lacus. Sed vitae sem dolor. ' ||
        'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. ' || 
        '<img alt="img004" src="1010.jpg" />' ||
        'Donec at est vitae velit volutpat malesuada adipiscing vel nisl.Proin varius fringilla arcu, vel ultricies urna fringilla nec. ' || 
        'Ut diam ante, pretium in venenatis in, facilisis at velit. Duis volutpat diam enim, eu bibendum dolor. Nullam metus tellus, facilisis ac varius eu, mollis id lacus. ' || 
        'In et elit quis tellus molestie ornare. Vivamus bibendum tincidunt ipsum, nec consequat elit pretium luctus.' ||
      '</p>' ||
    '</body>' ||
  '</html>';
  v_out blob; -- the output
begin
  -- initilaize package variables
  plpdf.init(); 
  -- create new page
  plpdf.newpage();
  -- configuring if the xhtml processor
  plpdf_xhtml.config(
    p_ppi => 96,            -- default resolution
    p_img_proc => 'get_img' -- name of the image getter process
    );
  -- call the xhtml processor
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src);
  -- store blob
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_img;
