create or replace
procedure xhtml_helloworld01 as
  l_src clob := 
  '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"' ||
    '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' ||
  '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">' ||
    '<head>' ||
    '<meta name="author" content="PL/PDF" />' ||
    '<title>PL/PDF XHTML Examples - Hello World</title>' ||
  '</head>' ||
  '<body>' ||
    '<h1>' ||
      'PL/PDF' ||
    '</h1> ' ||
    '<h2>' ||
      'Hello World Example' ||
    '</h2>' ||
    '<p>' ||
      'This is a simple paragraph.' ||
    '</p>' ||
  '</body>' ||
'</html>';

  v_out blob; -- target pdf
begin
  -- initialize
  plpdf.init();
  -- create a new page
  plpdf.newpage();
  -- config xhtml processor
  plpdf_xhtml.config();
  -- call XHTML processor
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src);
  -- save result
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_helloWorld01;
