create or replace procedure xhtml_helloworld as
  l_src clob; -- source XHTML
  v_out blob; -- result PDF
begin
  -- initialize
  plpdf.init();
  -- create a new page
  plpdf.newpage();
  -- select the source document
  select clob_file into l_src from store_clob where id=1;
  -- config xhtml processor
  plpdf_xhtml.config();
  -- call XHTML processor
  v_out := plpdf_xhtml.xhtml_to_pdf(l_src);
  -- save result
  insert into store_blob values(v_out, sysdate);
  commit;
end xhtml_helloWorld;
/
 