create or replace package plzip as

/**
<config>
  <pck-name>PL/ZIP</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v1.1.0</pck-version>
   <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>10</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
</config>
*/

/**
<h1>Introdution</h1>
<br/>
<p>
  PL/ZIP is a PL/SQL package for creating ZIP files. The method consist of three easy steps, create new archive,
  add files and finally save the complete ZIP. TRIAL limitation is a Random message: It''s not error! Certification is TRIAL!
</p>
<br/>
<h2>Installation</h2>
<p>
System requirements: Oracle 10g RDBMS Release 2 or higher. Oracle 10g Express Edition is supported.
</p>
<br/>
*/

/**
<newpage/>
<h1>Procedures and Functions </h1>
<br/>
*/

/**
<name>GetVersion</name>
<type>function</type>
<desc>
Gets the version number of PL/ZIP package.
</desc>
<version>v1.0.0</version>
<params>-</params>
<return>
  <return-def>varchar2</return-def>
  <return-desc>number of current version</return-desc>
</return>
*/
function getVersion return varchar2;

/**
 <name>CertKeyCheck</name>
 <type>Function</type>
 <desc>
  Checks the certification key.<br/>
  Usage:<br/>
  declare                            <br/>
    l_ret boolean;                   <br/>
  begin                              <br/>
    l_ret := plzip.CertKeyCheck;     <br/>
    if l_ret then                    <br/>
      dbms_output.put_line('true');  <br/>
    else                             <br/>
      dbms_output.put_line('false'); <br/>
    end if;                          <br/>
  end;                               <br/>
 </desc>
 <version>v1.1.0</version>
 <params>-</params>
 <return>
  <return-def>boolean</return-def>
  <return-desc>validity of the key</return-desc>
 </return>
*/
function CertKeyCheck
  return boolean;

/**
<name>createNewZip</name>
<type>Procedure</type>
<desc>
  Initializes the package, creates a new zip archive.
</desc>
<version>v1.0.0</version>
<params>-</params>
<return>-</return>
*/
procedure createNewZip;

/**
<name>addFile</name>
<type>Procedure</type>
<desc>
  Adds a file to the ZIP archive. To place a file into a subdirectory inside the ZIP archive, set the full path as p_filename.
</desc>
<version>v1.0.0</version>
<params>
  <param>
   <param-def>p_filename varchar2</param-def>
   <param-desc>[<i>path/</i>]name of the file</param-desc>
  </param>
  <param>
   <param-def>p_file varchar2</param-def>
   <param-desc>file</param-desc>
  </param>
</params>
<return>-</return>
*/
procedure addFile(
  p_filename varchar2,
  p_file blob
  );

/**
<name>saveZip</name>
<type>Function</type>
<desc>
  Builds entries to ZIP file format.
</desc>
<version>v1.0.0</version>
<params>-</params>
<return>
  <return-def>blob</return-def>
  <return-desc>The ZIP archive</return-desc>
</return>
*/
function saveZip
  return blob;

end plzip;
/

create or replace package body plzip wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
b
9200000
1
4
0 
e0
2 :e:
1PACKAGE:
1BODY:
1PLZIP:
1G_VERSION:
1CONSTANT:
1VARCHAR2:
1CHAR:
15:
11.1.0:
1V_PAD_CHR:
11:
1~:
1V_CERT_KEY:
1100:
1V_CERT_OK:
1BOOLEAN:
1FALSE:
1V_CERT_ERR_MISSING:
1PLPDF_TYPE:
1V2AVG:
1Certification key is missing.:
1V_CERT_ERR_INVALID:
1Certification key is invalid. Please contact Support.:
1V_TRIAL_ERROR:
1255:
1Random message:: It's not error! Certification is TRIAL!:
1V_BLOB_FILE:
1BLOB:
1FUNCTION:
1GETVERSION:
1RETURN:
1RAISE_ERROR:
1P_MSG:
1RAISE_APPLICATION_ERROR:
1-:
120000:
1CR_ERROR:
1P_CODE:
1P_1:
1L_MSG:
1=:
1301:
1Stream error:: &1.:
1ELSIF:
1302:
1Buffer error:: &1.:
1303:
1Data error:: &1.:
1IS NOT NULL:
1REPLACE:
1&1:
1SUBSTR:
1ERR-:
1||:
1 :
1GETADDRSTRING:
1L_RET:
1UTL_INADDR:
1GET_HOST_ADDRESS:
1DBMS_STANDARD:
1DATABASE_NAME:
1DUAL:
1ROWNUM:
1<:
12:
1GETDBID:
1TO_CHAR:
1DBID:
1SYS:
1V_$DATABASE:
1CHECKKEY:
1P_KEY:
1P_CACTH:
1TRUE:
1L_STR:
1L_DATE:
1DATE:
1L_ADDR:
1L_RAW:
1RAW:
12048:
1L_CHECK_KEY:
1L_DEVLIC:
1UTL_RAW:
1CAST_TO_RAW:
1SQRT:
113:
13:
138:
1DBMS_OBFUSCATION_TOOLKIT:
1DESDECRYPT:
1INPUT:
1HEXTORAW:
1KEY:
1DECRYPTED_DATA:
1RTRIM:
1CAST_TO_VARCHAR2:
1TO_DATE:
120:
16:
1YYYYMMDD:
17:
1ASPASIA:
1COGNOTEC:
1ISDHR:
1PERFIT:
1DBVALLEY:
1QUINN:
1BERENBERG:
1MYTHICS:
1ELUCID:
1MCGILL:
1SOCHO:
1CAISO:
1DCDK12:
1NTUEDUSG:
1GWIC:
1OHIO:
1FORCES:
1PROMATA:
1SUMNEVA:
1FHG:
1SITE01:
1SITE02:
1SITE03:
1SITE04:
1SITE05:
1DEV01:
1DEV02:
1DEV03:
1DEV04:
1DEV05:
14:
1!=:
1TRUNC:
1SYSDATE:
1<=:
1OTHERS:
1RAISE:
1CERTKEYCHECK:
1PLPDF_CERT:
1SETCERTKEY:
1IS NULL:
1UPPER:
1TRIAL:
1P_PROC:
1ERROR:: proc:::
1,msg:: :
1CREATENEWZIP:
1DBMS_LOB:
1CREATETEMPORARY:
1LITTLE_ENDIAN:
1P_IN_BIG:
1NUMBER:
1P_IN_BYTES:
1PLS_INTEGER:
1CAST_FROM_BINARY_INTEGER:
1ADDFILE:
1P_FILENAME:
1P_FILE:
1L_NOW:
1L_BLOB:
1L_CLEN:
1INTEGER:
1UTL_COMPRESS:
1LZ_COMPRESS:
1GETLENGTH:
1APPEND:
1CONCAT:
1504B0304:
11400:
10000:
10800:
1TO_NUMBER:
1ss:
1/:
1+:
1mi:
1*:
132:
1hh24:
1dd:
1mm:
1yyyy:
11980:
1512:
118:
1LENGTH:
1COPY:
111:
1FREETEMPORARY:
1ADDPRECOMPRESSEDFILE:
1P_CRC32:
1P_OSIZE:
1CREATEPRECOMPRESSEDFILE:
1P_CFILE:
1OUT:
1NOCOPY:
1SAVEZIP:
1L_CNT:
10:
1L_OFFS:
1L_OFFS_DIR_HEADER:
1L_OFFS_END_HEADER:
1L_COMMENT:
132767:
1PL/PDF PL/ZIP:
1L_SS:
1NOT:
1SS:
1MOD:
110:
1INSTR:
1WHILE:
1>:
1LOOP:
1504B0102:
126:
10100:
12000B681:
1CAST_TO_BINARY_INTEGER:
130:
1504B0506:
1NVL:
0

0
0
591
2
0 :2 a0 97 87 :3 a0 51 a5 1c
6e 1b b0 a3 :2 a0 51 a5 1c
6e 81 b0 a3 :2 a0 51 a5 1c
81 b0 a3 a0 1c a0 81 b0
a3 :2 a0 6b 1c 6e 81 b0 a3
:2 a0 6b 1c 6e 81 b0 a3 :2 a0
51 a5 1c 6e 81 b0 a3 a0
1c 81 b0 a0 8d a0 b4 a0
2c 6a :2 a0 65 b7 a4 b1 11
68 4f 9a 8f a0 b0 3d b4
55 6a a0 7e 51 b4 2e a0
a5 57 b7 a4 b1 11 68 4f
9a 8f a0 b0 3d 8f a0 b0
3d b4 55 6a a3 :2 a0 51 a5
1c 81 b0 a0 7e 6e b4 2e
a0 6e d a0 b7 a0 7e 6e
b4 2e a0 6e d a0 b7 19
a0 7e 6e b4 2e a0 6e d
b7 :2 19 3c a0 7e b4 2e :3 a0
6e a0 a5 b d b7 19 3c
:2 a0 6e 7e a0 b4 2e 7e 6e
b4 2e 7e a0 b4 2e :2 51 a5
b d a0 7e 51 b4 2e a0
a5 57 b7 a4 b1 11 68 4f
a0 8d a0 b4 a0 2c 6a a3
:2 a0 6b 1c 81 b0 :2 a0 6b 7e
:2 a0 6b b4 2e ac :2 a0 b2 ee
a0 7e 51 b4 2e ac e5 d0
b2 e9 :2 a0 65 b7 a4 b1 11
68 4f a0 8d a0 b4 a0 2c
6a a3 :2 a0 6b 1c 81 b0 :2 a0
a5 b ac :3 a0 6b b2 ee a0
7e 51 b4 2e ac e5 d0 b2
e9 :2 a0 65 b7 a4 b1 11 68
4f a0 8d 8f a0 b0 3d 8f
:2 a0 b0 3d b4 :2 a0 2c 6a a3
a0 1c a0 81 b0 a3 :2 a0 6b
1c 81 b0 a3 a0 1c 81 b0
a3 :2 a0 6b 1c 81 b0 a3 a0
51 a5 1c 81 b0 a3 a0 51
a5 1c 81 b0 a3 a0 1c a0
81 b0 :3 a0 6b :3 a0 51 a5 b
a5 b :2 51 a5 b a5 b d
:2 a0 6b :3 a0 a5 b e :2 a0 e
:2 a0 e a5 57 :4 a0 6b a0 a5
b a0 a5 b d :2 a0 6e 7e
:2 a0 :2 51 a5 b b4 2e 6e a5
b d :3 a0 51 a5 b d a0
3e :1e 6e 5 48 :2 a0 d b7 19
3c :2 a0 :2 51 a5 b 7e 6e b4
2e :3 a0 a5 b a0 7e b4 2e
:2 a0 d b7 :2 a0 d b7 :2 19 3c
b7 :2 a0 7e b4 2e :2 a0 a5 b
a0 7e b4 2e a 10 :2 a0 d
b7 :2 a0 d b7 :2 19 3c b7 :2 19
3c b7 :2 a0 51 a5 b a0 7e
b4 2e :2 a0 a5 b a0 7e b4
2e a 10 :2 a0 d b7 :2 a0 d
b7 :2 19 3c b7 :2 19 3c b7 a0
53 :3 a0 d b7 a0 62 b7 :2 19
3c b7 a6 9 a4 b1 11 4f
:2 a0 65 b7 a4 b1 11 68 4f
a0 8d a0 b4 a0 2c 6a a3
a0 1c 81 b0 :2 a0 6b 7e b4
2e :2 a0 d a0 b7 :3 a0 6b a5
b 7e 6e b4 2e :2 a0 d b7
19 :4 a0 6b a0 a5 b d b7
:2 19 3c :2 a0 65 b7 a4 b1 11
68 4f 9a 8f a0 b0 3d 8f
a0 b0 3d b4 55 6a a0 7e
51 b4 2e 6e 7e a0 b4 2e
7e 6e b4 2e 7e a0 b4 2e
a5 57 b7 a4 b1 11 68 4f
9a b4 55 6a :2 a0 6b :2 a0 a5
57 b7 a4 b1 11 68 4f a0
8d 8f a0 b0 3d 8f a0 51
b0 3d b4 :2 a0 2c 6a :3 a0 6b
:2 a0 6b :3 a0 6b a5 b 51 a0
a5 b 65 b7 a4 b1 11 68
4f 9a 8f a0 b0 3d 8f a0
b0 3d b4 55 6a a3 a0 1c
81 b0 a3 a0 1c 81 b0 a3
a0 1c 81 b0 :2 a0 d :3 a0 6b
a0 a5 b d :3 a0 6b a0 a5
b d :2 a0 6b :3 a0 6b a0 6e
a5 b a0 6e a5 b a0 6e
a5 b a0 6e a5 b :4 a0 6e
a5 b a5 b 7e 51 b4 2e
7e :3 a0 6e a5 b a5 b 7e
51 b4 2e b4 2e 7e :3 a0 6e
a5 b a5 b 7e 51 b4 2e
b4 2e 51 a5 b :4 a0 6e a5
b a5 b 7e :3 a0 6e a5 b
a5 b 7e 51 b4 2e b4 2e
7e :3 a0 6e a5 b a5 b 7e
51 b4 2e 5a 7e 51 b4 2e
b4 2e 51 a5 b :2 a0 6b a0
51 a0 7e 51 b4 2e a5 b
:2 a0 7e 51 b4 2e a5 b :3 a0
6b a0 a5 b a5 b :3 a0 a5
b 51 a5 b a0 6e a5 b
:2 a0 6b a0 a5 b a5 b a5
57 :2 a0 6b :3 a0 7e 51 b4 2e
:2 a0 6b a0 a5 b 7e 51 b4
2e 51 a5 57 :2 a0 6b a0 a5
57 b7 a4 b1 11 68 4f 9a
8f a0 b0 3d 8f a0 b0 3d
8f a0 b0 3d 8f a0 b0 3d
b4 55 6a 4f b7 a4 b1 11
68 4f 9a 8f a0 b0 3d 96
:3 a0 b0 54 96 :3 a0 b0 54 96
:3 a0 b0 54 b4 55 6a 4f b7
a4 b1 11 68 4f a0 8d a0
b4 a0 2c 6a a3 a0 1c 51
81 b0 a3 a0 1c 81 b0 a3
a0 1c 81 b0 a3 a0 1c 81
b0 a3 a0 51 a5 1c :2 a0 6b
6e a5 b 81 b0 a3 a0 1c
81 b0 :3 a0 6b d a0 7e b4
2e :2 a0 a5 b 7e 6e b4 2e
:2 a0 d b7 :3 a0 a5 b d b7
:2 19 3c b7 :2 a0 a5 57 b7 :2 19
3c a0 5a 7e b4 2e :2 a0 a5
57 b7 19 3c :2 a0 a5 b 7e
6e b4 2e :4 a0 6e a5 b a5
b d :2 a0 51 7e a5 2e 7e
51 b4 2e :2 a0 a5 57 b7 19
3c b7 19 3c :3 a0 6b a0 a5
b d :3 a0 6b :2 a0 6e a5 b
51 a5 b d :2 a0 7e 51 a0
b4 2e 82 :2 a0 7e 51 b4 2e
d :2 a0 6b :3 a0 6b a0 6e a5
b a0 6e a5 b :2 a0 6b a0
51 a0 7e 51 b4 2e a5 b
a0 6e a5 b a0 6e a5 b
a0 6e a5 b a0 6e a5 b
:2 a0 7e 51 b4 2e a5 b :2 a0
6b :3 a0 6b :2 a0 6b a0 51 a0
7e 51 b4 2e a5 b :2 a0 6b
a5 b a0 7e 51 b4 2e a5
b a5 b a5 57 :3 a0 6b :2 a0
6e a5 b a0 7e 51 b4 2e
a5 b d b7 a0 47 :3 a0 6b
a0 a5 b d :2 a0 6b :3 a0 6b
a0 6e a5 b a0 6e a5 b
a0 6e a5 b :2 a0 51 a5 b
:2 a0 51 a5 b :2 a0 7e a0 b4
2e a5 b :2 a0 a5 b :4 a0 6b
a0 a5 b 51 a5 b 51 a5
b a0 a5 b a5 57 :2 a0 65
b7 a4 b1 11 68 4f b1 b7
a4 11 a0 b1 56 4f 1d 17
b5 
591
2
0 3 7 b 3a 19 1d 21
25 28 29 31 36 18 60 45
49 15 4d 4e 56 5b 44 81
6b 6f 41 73 74 7c 6a a1
8c 90 98 9c 67 c5 a8 ac
b0 b3 bb c0 8b ea d0 d4
88 d8 e0 e5 cf 110 f5 f9
cc fd fe 106 10b f4 12c 11b
11f 127 f1 117 133 147 14b 14c
150 154 158 15c 160 164 166 16a
16c 178 17c 17e 19a 196 195 1a2
192 1a7 1ab 1af 1b3 1b6 1b9 1ba
1bf 1c3 1c4 1c9 1cb 1cf 1d1 1dd
1e1 1e3 1ff 1fb 1fa 207 214 210
1f7 21c 20f 221 225 243 22d 231
20c 235 236 23e 22c 24a 229 24e
253 254 259 25d 262 266 26a 26c
270 273 278 279 27e 282 287 28b
28f 291 295 299 29c 2a1 2a2 2a7
2ab 2b0 2b4 2b6 2ba 2be 2c1 2c5
2c8 2c9 2ce 2d2 2d6 2da 2df 2e3
2e4 2e6 2ea 2ec 2f0 2f3 2f7 2fb
300 303 307 308 30d 310 315 316
31b 31e 322 323 328 32b 32e 32f
331 335 339 33c 33f 340 345 349
34a 34f 351 355 357 363 367 369
36d 381 385 386 38a 38e 3ae 396
39a 39e 3a1 3a9 395 3b5 3b9 392
3bd 3c0 3c4 3c8 3cb 3cc 3d1 3d2
3d6 3da 3db 3e2 3e6 3e9 3ec 3ed
3f2 3f3 3f9 3fd 3fe 403 407 40b
40f 411 415 417 423 427 429 42d
441 445 446 44a 44e 46e 456 45a
45e 461 469 455 475 479 452 47d
47f 480 484 488 48c 48f 490 497
49b 49e 4a1 4a2 4a7 4a8 4ae 4b2
4b3 4b8 4bc 4c0 4c4 4c6 4ca 4cc
4d8 4dc 4de 4e2 4fe 4fa 4f9 506
517 50f 513 4f6 51f 50e 524 528
52c 530 54d 538 53c 544 548 50b
56c 554 558 55c 55f 567 537 588
577 57b 583 534 5a7 58f 593 597
59a 5a2 576 5c4 5b2 573 5b6 5b7
5bf 5b1 5e1 5cf 5ae 5d3 5d4 5dc
5ce 601 5ec 5f0 5f8 5fc 5cb 5e8
608 60c 610 613 617 61b 61f 622
623 625 626 628 62b 62e 62f 631
632 634 638 63c 640 643 647 64b
64f 650 652 654 658 65c 65e 662
666 668 669 66e 672 676 67a 67e
681 685 686 688 68c 68d 68f 693
697 69b 6a0 6a3 6a7 6ab 6ae 6b1
6b2 6b4 6b5 6ba 6bf 6c0 6c2 6c6
6ca 6ce 6d2 6d5 6d6 6d8 6dc 1
6e0 6e5 6ea 6ef 6f4 6f9 6fe 703
708 70d 712 717 71c 721 726 72b
730 735 73a 73f 744 749 74e 753
758 75d 762 767 76c 771 776 77a
77d 781 785 789 78b 78f 792 796
79a 79d 7a0 7a1 7a3 7a6 7ab 7ac
7b1 7b5 7b9 7bd 7be 7c0 7c4 7c7
7c8 7cd 7d1 7d5 7d9 7db 7df 7e3
7e7 7e9 7ed 7f1 7f4 7f6 7fa 7fe
801 802 807 80b 80f 810 812 816
819 81a 1 81f 824 828 82c 830
832 836 83a 83e 840 844 848 84b
84d 851 855 858 85a 85e 862 865
866 868 86c 86f 870 875 879 87d
87e 880 884 887 888 1 88d 892
896 89a 89e 8a0 8a4 8a8 8ac 8ae
8b2 8b6 8b9 8bb 8bf 8c3 8c6 8c8
1 8cc 8d0 8d4 8d8 8dc 8de 8e2
8e5 8e7 8eb 8ef 8f2 8f4 8f5 8fa
8fe 900 90c 90e 912 916 91a 91c
920 922 92e 932 934 938 94c 950
951 955 959 972 961 965 96d 960
979 97d 95d 981 984 985 98a 98e
992 996 99a 99c 9a0 9a4 9a8 9ab
9ac 9ae 9b1 9b6 9b7 9bc 9c0 9c4
9c8 9ca 9ce 9d2 9d6 9da 9de 9e1
9e5 9e6 9e8 9ec 9ee 9f2 9f6 9f9
9fd a01 a05 a07 a0b a0d a19 a1d
a1f a3b a37 a36 a43 a50 a4c a33
a58 a4b a5d a61 a65 a48 a69 a6c
a6d a72 a77 a7a a7e a7f a84 a87
a8c a8d a92 a95 a99 a9a a9f aa0
aa5 aa7 aab aad ab9 abd abf ad3
ad4 ad8 adc ae0 ae4 ae7 aeb aef
af0 af5 af7 afb afd b09 b0d b0f
b13 b2f b2b b2a b37 b44 b40 b27
b3f b4c b3c b51 b55 b59 b5d b61
b65 b69 b6d b70 b74 b78 b7b b7f
b83 b87 b8a b8b b8d b90 b94 b95
b97 b9b b9d ba1 ba3 baf bb3 bb5
bd1 bcd bcc bd9 be6 be2 bc9 bee
be1 bf3 bf7 c10 bff c03 c0b bde
c28 c17 c1b c23 bfe c44 c33 c37
c3f bfb c2f c4b c4f c53 c57 c5b
c5f c62 c66 c67 c69 c6d c71 c75
c79 c7c c80 c81 c83 c87 c8b c8f
c92 c96 c9a c9e ca1 ca5 caa cab
cad cb1 cb6 cb7 cb9 cbd cc2 cc3
cc5 cc9 cce ccf cd1 cd5 cd9 cdd
ce1 ce6 ce7 ce9 cea cec cef cf2
cf3 cf8 cfb cff d03 d07 d0c d0d
d0f d10 d12 d15 d18 d19 d1e d1f
d24 d27 d2b d2f d33 d38 d39 d3b
d3c d3e d41 d44 d45 d4a d4b d50
d53 d54 d56 d5a d5e d62 d66 d6b
d6c d6e d6f d71 d74 d78 d7c d80
d85 d86 d88 d89 d8b d8e d91 d92
d97 d98 d9d da0 da4 da8 dac db1
db2 db4 db5 db7 dba dbd dbe dc3
dc6 dc9 dcc dcd dd2 dd3 dd8 ddb
ddc dde de2 de6 de9 ded df0 df4
df7 dfa dfb e00 e01 e03 e07 e0b
e0e e11 e12 e17 e18 e1a e1e e22
e26 e29 e2d e2e e30 e31 e33 e37
e3b e3f e40 e42 e45 e46 e48 e4c
e51 e52 e54 e58 e5c e5f e63 e64
e66 e67 e69 e6a e6f e73 e77 e7a
e7e e82 e86 e89 e8c e8d e92 e96
e9a e9d ea1 ea2 ea4 ea7 eaa eab
eb0 eb3 eb4 eb9 ebd ec1 ec4 ec8
ec9 ece ed0 ed4 ed6 ee2 ee6 ee8
f04 f00 eff f0c f19 f15 efc f21
f2a f26 f14 f32 f3f f3b f11 f47
f3a f4c f50 f37 f54 f56 f5a f5c
f68 f6c f6e f8a f86 f85 f92 fa7
f9b f9f fa3 f82 fae fbf fb3 fb7
fbb f9a fc6 fdb fcf fd3 fd7 f97
fe2 fce fe7 feb fcb fef ff1 ff5
ff7 1003 1007 1009 100d 1021 1025 1026
102a 102e 104a 1036 103a 1042 1045 1035
1066 1055 1059 1061 1032 107e 106d 1071
1079 1054 109a 1089 108d 1095 1051 10c9
10a1 10a5 10a8 10a9 10b1 10b5 10b9 10bc
10c1 10c2 10c4 1088 10e5 10d4 10d8 10e0
1085 10d0 10ec 10f0 10f4 10f7 10fb 10ff
1102 1103 1108 110c 1110 1111 1113 1116
111b 111c 1121 1125 1129 112d 112f 1133
1137 113b 113c 113e 1142 1144 1148 114c
114f 1151 1155 1159 115a 115f 1161 1165
1169 116c 1170 1173 1176 1177 117c 1180
1184 1185 118a 118c 1190 1193 1197 119b
119c 119e 11a1 11a6 11a7 11ac 11b0 11b4
11b8 11bc 11c1 11c2 11c4 11c5 11c7 11cb
11cf 11d3 11d6 11d9 11da 11df 11e2 11e5
11e6 11eb 11ef 11f3 11f4 11f9 11fb 11ff
1202 1204 1208 120b 120f 1213 1217 121a
121e 121f 1221 1225 1229 122d 1231 1234
1238 123c 1241 1242 1244 1247 1248 124a
124e 1252 1256 1259 125c 1260 1261 1266
1268 126c 1270 1273 1276 1277 127c 1280
1284 1288 128b 128f 1293 1297 129a 129e
12a3 12a4 12a6 12aa 12af 12b0 12b2 12b6
12ba 12bd 12c1 12c4 12c8 12cb 12ce 12cf
12d4 12d5 12d7 12db 12e0 12e1 12e3 12e7
12ec 12ed 12ef 12f3 12f8 12f9 12fb 12ff
1304 1305 1307 130b 130f 1312 1315 1316
131b 131c 131e 1322 1326 1329 132d 1331
1335 1338 133c 1340 1343 1347 134a 134e
1351 1354 1355 135a 135b 135d 1361 1365
1368 1369 136b 136f 1372 1375 1376 137b
137c 137e 137f 1381 1382 1387 138b 138f
1393 1396 139a 139e 13a3 13a4 13a6 13aa
13ad 13b0 13b1 13b6 13b7 13b9 13bd 13bf
13c3 13ca 13ce 13d2 13d6 13d9 13dd 13de
13e0 13e4 13e8 13ec 13ef 13f3 13f7 13fb
13fe 1402 1407 1408 140a 140e 1413 1414
1416 141a 141f 1420 1422 1426 142a 142d
142e 1430 1434 1438 143b 143c 143e 1442
1446 1449 144d 144e 1453 1454 1456 145a
145e 145f 1461 1465 1469 146d 1471 1474
1478 1479 147b 147e 147f 1481 1484 1485
1487 148b 148c 148e 148f 1494 1498 149c
14a0 14a2 14a6 14a8 14b4 14b8 14ba 14bc
14be 14c2 14ce 14d2 14d4 14d7 14d9 14da
14e3 
591
2
0 1 9 e 1 b 14 1f
:2 1c 14 28 b 1 3 11 1c
:2 19 11 25 11 :2 3 e 1b :2 16
:2 e 3 2 :2 c 17 c :2 2 15
20 :2 15 29 15 2 3 16 21
:2 16 2a 16 :2 3 11 1e :2 19 11
27 11 :2 3 :3 f 3 2 b 5
0 c :2 2 5 c 5 :2 3 :4 2
b 3 9 :2 3 16 :2 1 3 1b
1c :2 1b 22 :2 3 :6 1 b 3 a
:3 3 7 :2 3 13 :2 1 3 9 16
:2 11 :2 9 3 6 d f :2 d 5
e 5 3 15 9 10 12 :2 10
5 e 5 3 18 15 9 10
12 :2 10 5 e 5 18 15 :2 3
:4 6 5 e 16 1c 21 :2 e 5
16 :3 3 b 12 19 1c :2 12 23
26 :2 12 2a 2d :2 12 33 35 :2 b
:2 3 1b 1c :2 1b 22 :2 3 :7 1 a
3 0 a :2 1 3 9 14 :3 9
3 a :2 15 26 29 :2 37 :4 a 8
3 8 9 10 12 :2 10 :6 3 a
3 :7 1 a 3 0 a :2 1 3
9 14 :3 9 3 a 12 :4 a 8
c 8 3 8 9 10 12 :2 10
:6 3 a 3 :7 1 a 3 9 :3 3
b 1b :2 3 12 5 c :2 1 3
:2 9 14 9 :2 3 9 14 :3 9 :2 3
:3 a :2 3 a 15 :3 a :2 3 9 d
c :2 9 :2 3 11 15 14 :2 11 :2 3
:2 c 17 c 3 5 14 :2 1c 28
2f 37 3c :2 37 :2 2f 41 43 :2 28
:2 14 :2 5 :2 1e 7 10 19 :2 10 :2 7
e :2 7 19 7 :2 5 3 c 12
:2 1a 2b :2 12 32 :2 c 3 2 c
14 19 1c 23 29 2b :2 1c :2 14
2e :2 c :2 2 c 13 19 :2 c 2
:2 7 13 1e 2a 12 1b 26 2e
12 1c :2 12 1a 22 12 1d 24
2b 34 3e :2 12 1b 24 2d 36
12 1a 22 2a 32 :2 7 5 11
5 15 :2 4 5 c 13 15 :2 5
18 1b :2 18 8 a 10 :2 a 1c
:3 19 9 12 9 23 9 12 9
:4 7 11 a 13 :3 11 25 2b :2 25
37 :3 34 :2 a 9 12 9 3e 9
12 9 :4 7 :4 5 22 7 e 15
:2 7 1a :3 18 26 2c :2 26 38 :3 35
:2 7 6 f 6 3f 6 f 6
:4 4 5 :3 2 3 :2 a 8 4 d
4 10 :2 7 :4 5 11 :2 5 3 :3 1
3 a 3 :7 1 a 3 0 a
:2 1 3 :3 9 3 6 :2 11 :3 6 5
e 5 3 24 9 f :2 1a :2 9
26 28 :2 26 5 e 5 30 24
5 e 17 :2 22 2d :2 e 5 :5 3
a 3 :6 1 b 17 1e :2 17 28
2e :2 28 16 :2 1 5 1d 1e :2 1d
25 34 37 :2 25 3e 41 :2 25 4a
4d :2 25 :2 5 :2 3 :4 1 b 0 :2 1
3 :2 c 1c 29 :2 3 :7 1 a 3
c :3 3 e 1d :2 3 17 5 c
:2 1 3 a :2 12 19 :2 21 3a 43
:2 4b :2 19 5a 5c :2 a 3 :6 1 b
3 e :3 3 a :2 3 12 :2 1 3
:3 a :2 3 :3 a :2 3 :3 a :2 3 d :2 3
d :2 1a 26 :2 d :2 3 d :2 16 20
:2 d :2 3 :2 c :2 13 :2 1b 22 2b :2 22
37 40 :2 37 48 51 :2 48 59 62
:2 59 22 30 3a 42 49 :2 3a :2 30
50 52 :2 30 54 30 3a 42 49
:2 3a :2 30 50 52 :4 30 55 30 3a
42 48 :2 3a :2 30 51 53 :4 30 58
:3 22 30 3a 42 49 :2 3a :2 30 50
30 3a 42 49 :2 3a :2 30 50 52
:4 30 55 31 3b 43 49 :2 3b :2 31
52 54 :2 31 30 5a 5c :4 30 60
:3 22 :2 2b 32 3a 3d 44 46 :2 3d
:2 22 24 32 39 3b :2 32 :3 24 32
:2 3b 45 :2 32 :3 24 32 39 :2 32 46
:3 24 2d :3 24 :2 2c 38 :2 24 :2 13 :3 3
:2 c :3 11 18 1a :3 11 :2 1a 24 :2 11
31 33 :3 11 :3 3 :2 c 1a :2 3 :6 1
b 3 e :3 3 a :3 3 b :3 3
b :2 3 1f :2 1 3 :6 1 b 3
d :3 3 b f 16 :3 3 b f
16 :3 3 b f 16 :2 3 22 :2 1
3 :7 1 a 3 0 a :2 1 3
:2 15 24 15 :2 3 :3 15 :2 3 :3 15 :2 3
:3 15 :2 3 15 19 18 15 23 :2 2b
37 :2 23 15 :2 3 :3 8 :2 3 11 :2 1c
3 :4 5 7 d :2 7 19 1b :2 19
6 13 6 23 6 13 1c :2 13
6 :4 4 1c 4 10 :2 4 :4 2 a
9 :3 6 4 10 :2 4 15 :2 3 6
c :2 6 18 1a :2 18 3 b 15
1d 25 :2 15 :2 b 3 8 c 11
:3 8 15 17 :2 15 8 14 :2 8 19
:2 5 22 :3 3 18 :2 21 2b :2 18 :2 3
18 :2 21 27 33 3c :2 33 48 :2 18
:2 3 9 10 12 14 :2 10 3 5
e 14 16 :2 e :2 5 :2 e :2 15 :2 1d
24 2d :3 24 2d :3 24 :2 2d 34 40
43 4a 4c :2 43 :3 24 2d :3 24 2d
:3 24 2d :3 24 2d :3 24 32 39 3b
:2 32 :3 24 :2 2d :2 34 :2 3c 34 :2 3d 44
50 52 59 5b :2 52 :2 34 5f :2 67
:3 34 3b 3d :2 34 :2 24 :2 15 :3 5 f
:2 18 1e 2a 33 :2 2a 3f 46 48
:2 3f :2 f 5 14 7 :2 3 18 :2 21
2b :2 18 3 5 :2 e :2 15 :2 1d 24
2d :3 24 2d :3 24 2d :3 24 32 39
:3 24 32 39 :3 24 32 44 46 :2 32
:3 24 32 :3 24 32 36 :2 3e 45 :2 36
50 :2 32 53 :3 24 :2 15 :2 5 3 a
3 :6 1 :4 2 5 :6 1 
591
4
0 :3 1 :a 3 :9 7
:8 8 :6 9 :8 b :8 c
:9 d :5 f :2 11 12
0 12 :2 11 :3 14
:2 13 :4 11 17 :4 18
:3 17 :8 1c :2 1a :4 17
1f :4 20 :4 21 :3 1f
:8 24 :5 26 :3 27 28
26 :5 28 :3 29 2a
28 26 :5 2a :3 2b
2a :3 26 :4 2d :8 2e
:3 2d :14 30 :8 32 :2 25
:4 1f :2 36 37 0
37 :2 36 :7 38 :a 3a
3b :3 3c :5 3d 3c
:4 3a :3 3f :2 39 :4 36
:2 42 43 0 43
:2 42 :7 44 :5 46 47
:5 48 :5 49 48 :4 46
:3 4b :2 45 :4 42 :2 4e
:4 4f :5 50 4e :2 51
:2 4e :6 52 :7 53 :5 54
:7 55 :7 56 :7 57 :6 58
:13 5b :3 5c :6 5d :3 5e
:3 5f :2 5c :c 60 :10 61
:7 62 :5 64 :4 65 :2 66
67 :3 68 :6 69 6a
:5 6b :5 6c :2 64 :3 6e
6d :2 64 :a 71 72
:8 73 :3 74 73 :3 76
75 :3 73 72 :f 79
:3 7a 79 :3 7c 7b
:3 79 78 :3 72 71
:13 80 :3 81 80 :3 83
82 :3 80 7f :3 71
5a :2 87 88 :3 89
88 :2 8b 8a :3 88
:3 87 86 :3 59 :3 8f
:2 59 :4 4e :2 92 93
0 93 :2 92 :5 94
:6 96 :3 97 98 96
:a 98 :3 99 98 96
:9 9b 9a :3 96 :3 9d
:2 95 :4 92 :c a0 :14 a2
:2 a1 :4 a0 a5 0
:2 a5 :7 a8 :2 a7 :4 a5
:2 ab :4 ac :5 ad ab
:2 ae :2 ab :12 b0 :2 af
:4 ab b3 :4 b4 :4 b5
:3 b3 :5 b7 :5 b8 :5 b9
:3 bb :8 bc :8 bd :4 be
:13 bf :e c0 :c c1 :2 c0
c1 :c c2 :2 c0 c2
:2 c0 :a c3 :c c4 :2 c3
c4 :11 c5 :2 c3 c5
:2 c3 :c c6 :8 c7 :9 c8
:8 c9 :4 ca :6 cb :2 bf
:2 be :4 ce cf :5 d0
:a d1 d2 :2 ce :6 d3
:2 ba :4 b3 d6 :4 d7
:4 d8 :4 d9 :4 da :3 d6
dd :2 dc :4 d6 e0
:4 e1 :6 e2 :6 e3 :6 e4
:3 e0 e7 :2 e6 :4 e0
:2 ea eb 0 eb
:2 ea :6 ec :5 ed :5 ee
:5 ef :d f0 :5 f1 :5 f4
:4 f5 :8 f6 :3 f7 f6
:6 f9 f8 :3 f6 f5
:4 fc fb :3 f5 :5 fe
:4 ff :3 fe :8 102 :a 103
:a 104 :4 105 :3 104 :3 102
:8 10a :d 10b :8 10d :7 10e
:4 10f :7 110 :4 111 :c 112
:4 113 :4 114 :4 115 :4 116
:8 117 :4 118 :3 119 :f 11a
:2 119 :5 11b :2 118 :2 110
:2 10f :11 11f 10d 120
10d :8 122 :4 123 :7 124
:4 125 :4 126 :5 127 :5 128
:8 129 :4 12a :e 12b 12c
:2 124 :2 123 :3 12e :2 f2
:4 ea :4 11 134 :6 1

14e5
4
:3 0 1 :3 0 2
:3 0 3 :6 0 1
:2 0 b :2 0 6
5 :3 0 6 :3 0
7 :3 0 8 :2 0
3 6 9 :6 0
9 :4 0 d a
b 58b 4 :6 0
e :2 0 b 6
:3 0 7 :3 0 8
f 12 :6 0 c
:4 0 16 13 14
58b 0 a :6 0
12 88 0 10
6 :3 0 7 :3 0
d 18 1b :6 0
1e 1c 0 58b
0 d :6 0 2e
2f 0 14 10
:3 0 20 :7 0 11
:3 0 24 21 22
58b 0 f :6 0
13 :3 0 14 :2 0
4 26 27 0
28 :7 0 15 :4 0
2c 29 2a 58b
0 12 :6 0 19
:2 0 16 13 :3 0
14 :2 0 4 30
:7 0 17 :4 0 34
31 32 58b 0
16 :6 0 1d 117
0 1b 6 :3 0
7 :3 0 18 36
39 :6 0 1a :4 0
3d 3a 3b 58b
0 18 :6 0 1d
:3 0 1c :3 0 3f
:7 0 42 40 0
58b 0 1b :6 0
1e :a 0 51 2
:7 0 1f :4 0 6
:3 0 46 47 0
51 44 48 :2 0
1f :3 0 4 :3 0
4b :2 0 4d 1f
50 :3 0 50 0
50 4f 4d 4e
:6 0 51 1 0
44 48 50 58b
:2 0 20 :a 0 67
3 :7 0 23 :2 0
21 6 :3 0 21
:7 0 56 55 :3 0
58 :2 0 67 53
59 :2 0 22 :3 0
23 :2 0 24 :2 0
25 5c 5e :3 0
21 :3 0 27 5b
61 :2 0 63 2a
66 :3 0 66 0
66 65 63 64
:6 0 67 1 0
53 59 66 58b
:2 0 25 :a 0 cd
4 :7 0 2e 20c
0 2c 6 :3 0
26 :7 0 6c 6b
:3 0 19 :2 0 30
6 :3 0 27 :7 0
70 6f :3 0 72
:2 0 cd 69 73
:2 0 29 :2 0 36
6 :3 0 7 :3 0
33 76 79 :6 0
7c 7a 0 cb
0 28 :6 0 26
:3 0 2a :4 0 3a
7e 80 :3 0 28
:3 0 2b :4 0 82
83 0 86 2c
:3 0 3d 9c 26
:3 0 29 :2 0 2d
:4 0 41 88 8a
:3 0 28 :3 0 2e
:4 0 8c 8d 0
90 2c :3 0 44
91 8b 90 0
9d 26 :3 0 29
:2 0 2f :4 0 48
93 95 :3 0 28
:3 0 30 :4 0 97
98 0 9a 4b
9b 96 9a 0
9d 81 86 0
9d 4d 0 c9
27 :3 0 31 :2 0
51 9f a0 :3 0
28 :3 0 32 :3 0
28 :3 0 33 :4 0
27 :3 0 53 a3
a7 a2 a8 0
aa 57 ab a1
aa 0 ac 59
0 c9 28 :3 0
34 :3 0 35 :4 0
36 :2 0 26 :3 0
5b b0 b2 :3 0
36 :2 0 37 :4 0
5e b4 b6 :3 0
36 :2 0 28 :3 0
61 b8 ba :3 0
b :2 0 19 :2 0
64 ae be ad
bf 0 c9 22
:3 0 23 :2 0 24
:2 0 68 c2 c4
:3 0 28 :3 0 6a
c1 c7 :2 0 c9
6d cc :3 0 cc
72 cc cb c9
ca :6 0 cd 1
0 69 73 cc
58b :2 0 1d :3 0
38 :a 0 fc 5
:7 0 1f :4 0 6
:3 0 d2 d3 0
fc d0 d4 :2 0
dd de 0 74
13 :3 0 14 :2 0
4 d7 d8 0
d9 :7 0 dc da
0 fa 0 39
:6 0 3a :3 0 3b
:3 0 36 :2 0 3c
:3 0 3d :3 0 e1
e2 0 76 e0
e4 :3 0 79 39
:3 0 3e :3 0 7b
e9 ef 0 f0
:3 0 3f :3 0 40
:2 0 41 :2 0 7f
ec ee :4 0 f2
f3 :5 0 e6 ea
0 82 0 f1
:2 0 f8 1f :3 0
39 :3 0 f6 :2 0
f8 84 fb :3 0
fb 87 fb fa
f8 f9 :6 0 fc
1 0 d0 d4
fb 58b :2 0 1d
:3 0 42 :a 0 128
6 :7 0 1f :4 0
6 :3 0 101 102
0 128 ff 103
:2 0 8b :2 0 89
13 :3 0 14 :2 0
4 106 107 0
108 :7 0 10b 109
0 126 0 39
:6 0 43 :3 0 44
:3 0 10c 10e 8d
39 :3 0 45 :3 0
46 :2 0 4 112
113 0 8f 115
11b 0 11c :3 0
3f :3 0 40 :2 0
41 :2 0 93 118
11a :4 0 11e 11f
:5 0 110 116 0
96 0 11d :2 0
124 1f :3 0 39
:3 0 122 :2 0 124
98 127 :3 0 127
9b 127 126 124
125 :6 0 128 1
0 ff 103 127
58b :2 0 1d :3 0
47 :a 0 252 7
:7 0 9f 50b 0
9d 6 :3 0 48
:7 0 12e 12d :3 0
a4 534 0 a1
10 :3 0 4a :3 0
49 :7 0 133 131
132 :2 0 1f :3 0
10 :3 0 135 137
0 252 12b 138
:2 0 a8 573 0
a6 10 :3 0 13b
:7 0 11 :3 0 13f
13c 13d 250 0
39 :6 0 13 :3 0
14 :2 0 4 141
142 0 143 :7 0
146 144 0 250
0 4b :6 0 51
:2 0 aa 4d :3 0
148 :7 0 14b 149
0 250 0 4c
:6 0 13 :3 0 14
:2 0 4 14d 14e
0 14f :7 0 152
150 0 250 0
4e :6 0 51 :2 0
ae 50 :3 0 ac
154 156 :6 0 159
157 0 250 0
4f :6 0 b4 5e8
0 b2 50 :3 0
b0 15b 15d :6 0
160 15e 0 250
0 52 :6 0 52
:3 0 10 :3 0 162
:7 0 11 :3 0 166
163 164 250 0
53 :6 0 54 :3 0
55 :3 0 168 169
0 34 :3 0 43
:3 0 56 :3 0 57
:2 0 b6 16d 16f
b8 16c 171 58
:2 0 59 :2 0 ba
16b 175 be 16a
177 167 178 0
236 5a :3 0 5b
:3 0 17a 17b 0
5c :3 0 5d :3 0
48 :3 0 c0 17e
180 17d 181 5e
:3 0 52 :3 0 183
184 5f :3 0 4f
:3 0 186 187 c2
17c 189 :2 0 236
4b :3 0 60 :3 0
54 :3 0 61 :3 0
18d 18e 0 4f
:3 0 c6 18f 191
a :3 0 c8 18c
194 18b 195 0
236 4c :3 0 62
:3 0 63 :4 0 36
:2 0 34 :3 0 4b
:3 0 b :2 0 64
:2 0 cb 19b 19f
cf 19a 1a1 :3 0
65 :4 0 d2 198
1a4 197 1a5 0
236 4e :3 0 34
:3 0 4b :3 0 66
:2 0 d5 1a8 1ab
1a7 1ac 0 236
4e :3 0 67 :4 0
68 :4 0 69 :4 0
6a :4 0 6b :4 0
6c :4 0 6d :4 0
6e :4 0 6f :4 0
70 :4 0 71 :4 0
72 :4 0 73 :4 0
74 :4 0 75 :4 0
76 :4 0 77 :4 0
78 :4 0 79 :4 0
7a :4 0 7b :4 0
7c :4 0 7d :4 0
7e :4 0 7f :4 0
80 :4 0 81 :4 0
82 :4 0 83 :4 0
84 :4 0 d8 :3 0
1ae 1af 1ce 53
:3 0 4a :3 0 1d0
1d1 0 1d3 f7
1d4 1cf 1d3 0
1d5 f9 0 236
34 :3 0 4e :3 0
b :2 0 85 :2 0
fb 1d6 1da 86
:2 0 44 :4 0 101
1dc 1de :3 0 53
:3 0 87 :3 0 88
:3 0 104 1e1 1e3
4c :3 0 89 :2 0
108 1e6 1e7 :3 0
39 :3 0 4a :3 0
1e9 1ea 0 1ec
10b 1f1 39 :3 0
11 :3 0 1ed 1ee
0 1f0 10d 1f2
1e8 1ec 0 1f3
0 1f0 0 1f3
10f 0 1f4 112
210 4e :3 0 38
:3 0 29 :2 0 116
1f7 1f8 :3 0 87
:3 0 88 :3 0 119
1fa 1fc 4c :3 0
89 :2 0 11d 1ff
200 :3 0 1f9 202
201 :2 0 39 :3 0
4a :3 0 204 205
0 207 120 20c
39 :3 0 11 :3 0
208 209 0 20b
122 20d 203 207
0 20e 0 20b
0 20e 124 0
20f 127 211 1e0
1f4 0 212 0
20f 0 212 129
0 213 12c 233
34 :3 0 4e :3 0
8 :2 0 12e 214
217 42 :3 0 29
:2 0 133 21a 21b
:3 0 87 :3 0 88
:3 0 136 21d 21f
4c :3 0 89 :2 0
13a 222 223 :3 0
21c 225 224 :2 0
39 :3 0 4a :3 0
227 228 0 22a
13d 22f 39 :3 0
11 :3 0 22b 22c
0 22e 13f 230
226 22a 0 231
0 22e 0 231
141 0 232 144
234 1df 213 0
235 0 232 0
235 146 0 236
149 249 8a :3 0
49 :3 0 39 :3 0
11 :3 0 23a 23b
0 23d 151 241
8b :5 0 240 153
242 239 23d 0
243 0 240 0
243 155 0 244
158 246 15a 245
244 :2 0 247 15c
:2 0 249 0 249
248 236 247 :6 0
24e 7 :3 0 1f
:3 0 39 :3 0 24c
:2 0 24e 15e 251
:3 0 251 161 251
250 24e 24f :6 0
252 1 0 12b
138 251 58b :2 0
1d :3 0 8c :a 0
28e 9 :7 0 1f
:4 0 10 :3 0 257
258 0 28e 255
259 :2 0 260 261
0 169 10 :3 0
25c :7 0 25f 25d
0 28c 0 39
:6 0 8d :3 0 8e
:3 0 8f :2 0 16b
263 264 :3 0 39
:3 0 11 :3 0 266
267 0 26a 2c
:3 0 16d 284 90
:3 0 8d :3 0 8e
:3 0 26c 26d 0
16f 26b 26f 29
:2 0 91 :4 0 173
271 273 :3 0 39
:3 0 4a :3 0 275
276 0 278 176
279 274 278 0
286 39 :3 0 47
:3 0 8d :3 0 8e
:3 0 27c 27d 0
11 :3 0 178 27b
280 27a 281 0
283 17b 285 265
26a 0 286 0
283 0 286 17d
0 28a 1f :3 0
39 :3 0 288 :2 0
28a 181 28d :3 0
28d 184 28d 28c
28a 28b :6 0 28e
1 0 255 259
28d 58b :2 0 20
:a 0 2b4 a :7 0
188 a48 0 186
6 :3 0 92 :7 0
293 292 :3 0 23
:2 0 18a 6 :3 0
21 :7 0 297 296
:3 0 299 :2 0 2b4
290 29a :2 0 22
:3 0 24 :2 0 18d
29d 29f :3 0 93
:4 0 36 :2 0 92
:3 0 18f 2a2 2a4
:3 0 36 :2 0 94
:4 0 192 2a6 2a8
:3 0 36 :2 0 21
:3 0 195 2aa 2ac
:3 0 198 29c 2ae
:2 0 2b0 19b 2b3
:3 0 2b3 0 2b3
2b2 2b0 2b1 :6 0
2b4 1 0 290
29a 2b3 58b :2 0
95 :a 0 2c5 b
:8 0 2b7 :2 0 2c5
2b6 2b8 :2 0 96
:3 0 97 :3 0 2ba
2bb 0 1b :3 0
4a :3 0 19d 2bc
2bf :2 0 2c1 1a0
2c4 :3 0 2c4 0
2c4 2c3 2c1 2c2
:6 0 2c5 1 0
2b6 2b8 2c4 58b
:2 0 1d :3 0 98
:a 0 2ed c :7 0
85 :2 0 1a2 9a
:3 0 99 :7 0 2cb
2ca :3 0 1a6 :2 0
1a4 9c :3 0 9b
:7 0 2d0 2ce 2cf
:2 0 1f :3 0 50
:3 0 2d2 2d4 0
2ed 2c8 2d5 :2 0
1f :3 0 54 :3 0
34 :3 0 2d8 2d9
0 54 :3 0 9d
:3 0 2db 2dc 0
99 :3 0 54 :3 0
98 :3 0 2df 2e0
0 1a9 2dd 2e2
b :2 0 9b :3 0
1ac 2da 2e6 2e7
:2 0 2e9 1b0 2ec
:3 0 2ec 0 2ec
2eb 2e9 2ea :6 0
2ed 1 0 2c8
2d5 2ec 58b :2 0
9e :a 0 3e5 d
:7 0 1b4 bde 0
1b2 6 :3 0 9f
:7 0 2f2 2f1 :3 0
1b9 bfb 0 1b6
1c :3 0 a0 :7 0
2f6 2f5 :3 0 2f8
:2 0 3e5 2ef 2f9
:2 0 1bd c2f 0
1bb 4d :3 0 2fc
:7 0 2ff 2fd 0
3e3 0 a1 :6 0
1c :3 0 301 :7 0
304 302 0 3e3
0 a2 :6 0 a1
:3 0 a4 :3 0 306
:7 0 309 307 0
3e3 0 a3 :6 0
88 :3 0 30a 30b
0 3e1 a2 :3 0
a5 :3 0 a6 :3 0
30e 30f 0 a0
:3 0 1bf 310 312
30d 313 0 3e1
a3 :3 0 96 :3 0
a7 :3 0 316 317
0 a2 :3 0 1c1
318 31a 315 31b
0 3e1 96 :3 0
a8 :3 0 31d 31e
0 1b :3 0 54
:3 0 a9 :3 0 321
322 0 5d :3 0
aa :4 0 1c3 324
326 5d :3 0 ab
:4 0 1c5 328 32a
5d :3 0 ac :4 0
1c7 32c 32e 5d
:3 0 ad :4 0 1c9
330 332 98 :3 0
ae :3 0 43 :3 0
a1 :3 0 af :4 0
1cb 336 339 1ce
335 33b b0 :2 0
41 :2 0 1d0 33d
33f :3 0 b1 :2 0
ae :3 0 43 :3 0
a1 :3 0 b2 :4 0
1d3 343 346 1d6
342 348 b3 :2 0
b4 :2 0 1d8 34a
34c :3 0 1db 341
34e :3 0 b1 :2 0
ae :3 0 43 :3 0
a1 :3 0 b5 :4 0
1de 352 355 1e1
351 357 b3 :2 0
51 :2 0 1e3 359
35b :3 0 1e6 350
35d :3 0 41 :2 0
1e9 334 360 98
:3 0 ae :3 0 43
:3 0 a1 :3 0 b6
:4 0 1ec 364 367
1ef 363 369 b1
:2 0 ae :3 0 43
:3 0 a1 :3 0 b7
:4 0 1f1 36d 370
1f4 36c 372 b3
:2 0 b4 :2 0 1f6
374 376 :3 0 1f9
36b 378 :3 0 b1
:2 0 ae :3 0 43
:3 0 a1 :3 0 b8
:4 0 1fc 37c 37f
1ff 37b 381 23
:2 0 b9 :2 0 201
383 385 :3 0 386
:2 0 b3 :2 0 ba
:2 0 204 388 38a
:3 0 207 37a 38c
:3 0 41 :2 0 20a
362 38f 96 :3 0
34 :3 0 391 392
0 a2 :3 0 85
:2 0 a3 :3 0 23
:2 0 66 :2 0 20d
397 399 :3 0 210
393 39b 98 :3 0
a3 :3 0 23 :2 0
bb :2 0 214 39f
3a1 :3 0 217 39d
3a3 98 :3 0 96
:3 0 a7 :3 0 3a6
3a7 0 a0 :3 0
219 3a8 3aa 21b
3a5 3ac 98 :3 0
bc :3 0 9f :3 0
21d 3af 3b1 41
:2 0 21f 3ae 3b4
5d :3 0 ac :4 0
222 3b6 3b8 54
:3 0 55 :3 0 3ba
3bb 0 9f :3 0
224 3bc 3be 226
323 3c0 233 31f
3c2 :2 0 3e1 96
:3 0 bd :3 0 3c4
3c5 0 1b :3 0
a2 :3 0 a3 :3 0
23 :2 0 bb :2 0
236 3ca 3cc :3 0
96 :3 0 a7 :3 0
3ce 3cf 0 1b
:3 0 239 3d0 3d2
b1 :2 0 b :2 0
23b 3d4 3d6 :3 0
be :2 0 23e 3c6
3d9 :2 0 3e1 96
:3 0 bf :3 0 3db
3dc 0 a2 :3 0
244 3dd 3df :2 0
3e1 246 3e4 :3 0
3e4 24d 3e4 3e3
3e1 3e2 :6 0 3e5
1 0 2ef 2f9
3e4 58b :2 0 c0
:a 0 400 e :7 0
253 f11 0 251
6 :3 0 9f :7 0
3ea 3e9 :3 0 257
f37 0 255 1c
:3 0 a0 :7 0 3ee
3ed :3 0 50 :3 0
c1 :7 0 3f2 3f1
:4 0 3fc 0 259
50 :3 0 c2 :7 0
3f6 3f5 :3 0 3f8
:2 0 400 3e7 3f9
:2 0 25e 3ff :3 0
3ff 0 3ff 3fe
3fc 3fd :6 0 400
1 0 3e7 3f9
3ff 58b :2 0 c3
:a 0 421 f :7 0
262 f97 0 260
1c :3 0 a0 :7 0
405 404 :3 0 266
fcb 0 264 c5
:3 0 c6 :3 0 1c
:3 0 c4 :5 0 1
40b 40a :3 0 c5
:3 0 c6 :3 0 50
:3 0 c1 :5 0 1
411 410 :4 0 41d
0 268 c5 :3 0
c6 :3 0 50 :3 0
c2 :5 0 1 417
416 :3 0 419 :2 0
421 402 41a :2 0
26d 420 :3 0 420
0 420 41f 41d
41e :6 0 421 1
0 402 41a 420
58b :2 0 1d :3 0
c7 :a 0 584 10
:7 0 1f :4 0 1c
:3 0 426 427 0
584 424 428 :2 0
271 1051 0 26f
9c :3 0 42b :7 0
c9 :2 0 42f 42c
42d 582 0 c8
:6 0 275 1085 0
273 a4 :3 0 431
:7 0 434 432 0
582 0 ca :6 0
a4 :3 0 436 :7 0
439 437 0 582
0 cb :6 0 27d
10d0 0 27b a4
:3 0 43b :7 0 43e
43c 0 582 0
cc :6 0 50 :3 0
ce :2 0 277 440
442 :6 0 54 :3 0
55 :3 0 444 445
0 cf :4 0 279
446 448 44b 443
449 582 0 cd
:6 0 d :3 0 9a
:3 0 44d :7 0 450
44e 0 582 0
d0 :6 0 8d :3 0
8e :3 0 452 453
0 451 454 0
580 d :3 0 31
:2 0 27f 457 458
:3 0 90 :3 0 d
:3 0 281 45a 45c
29 :2 0 91 :4 0
285 45e 460 :3 0
f :3 0 4a :3 0
462 463 0 465
288 46d f :3 0
47 :3 0 d :3 0
28a 467 469 466
46a 0 46c 28c
46e 461 465 0
46f 0 46c 0
46f 28e 0 470
291 476 20 :3 0
12 :3 0 293 471
473 :2 0 475 295
477 459 470 0
478 0 475 0
478 297 0 580
f :3 0 479 :2 0
d1 :2 0 29a 47b
47c :3 0 20 :3 0
16 :3 0 29c 47e
480 :2 0 482 29e
483 47d 482 0
484 2a0 0 580
90 :3 0 d :3 0
2a2 485 487 29
:2 0 91 :4 0 2a6
489 48b :3 0 d0
:3 0 ae :3 0 43
:3 0 88 :3 0 d2
:4 0 2a9 48f 492
2ac 48e 494 48d
495 0 4a8 d3
:3 0 d0 :3 0 d4
:2 0 d3 :2 0 2ae
49a 49b :3 0 29
:2 0 c9 :2 0 2b3
49d 49f :3 0 20
:3 0 18 :3 0 2b6
4a1 4a3 :2 0 4a5
2b8 4a6 4a0 4a5
0 4a7 2ba 0
4a8 2bc 4a9 48c
4a8 0 4aa 2bf
0 580 cb :3 0
96 :3 0 a7 :3 0
4ac 4ad 0 1b
:3 0 2c1 4ae 4b0
4ab 4b1 0 580
ca :3 0 96 :3 0
d5 :3 0 4b4 4b5
0 1b :3 0 5d
:3 0 aa :4 0 2c3
4b8 4ba b :2 0
2c5 4b6 4bd 4b3
4be 0 580 d6
:3 0 ca :3 0 d7
:2 0 c9 :2 0 d8
:3 0 2cb 4c2 4c5
:3 0 4c6 538 c8
:3 0 c8 :3 0 b1
:2 0 b :2 0 2ce
4ca 4cc :3 0 4c8
4cd 0 536 96
:3 0 a8 :3 0 4cf
4d0 0 1b :3 0
54 :3 0 a9 :3 0
4d3 4d4 0 5d
:3 0 d9 :4 0 2d1
4d6 4d8 5d :3 0
ab :4 0 2d3 4da
4dc 96 :3 0 34
:3 0 4de 4df 0
1b :3 0 da :2 0
ca :3 0 b1 :2 0
85 :2 0 2d5 4e4
4e6 :3 0 2d8 4e0
4e8 5d :3 0 ac
:4 0 2dc 4ea 4ec
5d :3 0 ac :4 0
2de 4ee 4f0 5d
:3 0 db :4 0 2e0
4f2 4f4 5d :3 0
dc :4 0 2e2 4f6
4f8 98 :3 0 ca
:3 0 23 :2 0 b
:2 0 2e4 4fc 4fe
:3 0 2e7 4fa 500
96 :3 0 34 :3 0
502 503 0 1b
:3 0 54 :3 0 dd
:3 0 506 507 0
96 :3 0 34 :3 0
509 50a 0 1b
:3 0 41 :2 0 ca
:3 0 b1 :2 0 da
:2 0 2e9 50f 511
:3 0 2ec 50b 513
54 :3 0 98 :3 0
515 516 0 2f0
508 518 ca :3 0
b1 :2 0 de :2 0
2f3 51b 51d :3 0
2f6 504 51f 2fa
4d5 521 304 4d1
523 :2 0 536 ca
:3 0 96 :3 0 d5
:3 0 526 527 0
1b :3 0 5d :3 0
aa :4 0 307 52a
52c ca :3 0 b1
:2 0 b4 :2 0 309
52f 531 :3 0 30c
528 533 525 534
0 536 310 538
d8 :3 0 4c7 536
:4 0 580 cc :3 0
96 :3 0 a7 :3 0
53a 53b 0 1b
:3 0 314 53c 53e
539 53f 0 580
96 :3 0 a8 :3 0
541 542 0 1b
:3 0 54 :3 0 a9
:3 0 545 546 0
5d :3 0 df :4 0
316 548 54a 5d
:3 0 ac :4 0 318
54c 54e 5d :3 0
ac :4 0 31a 550
552 98 :3 0 c8
:3 0 41 :2 0 31c
554 557 98 :3 0
c8 :3 0 41 :2 0
31f 559 55c 98
:3 0 cc :3 0 23
:2 0 cb :3 0 322
560 562 :3 0 325
55e 564 98 :3 0
cb :3 0 327 566
568 98 :3 0 e0
:3 0 54 :3 0 bc
:3 0 56c 56d 0
cd :3 0 329 56e
570 c9 :2 0 32b
56b 573 41 :2 0
32e 56a 576 cd
:3 0 331 547 579
33b 543 57b :2 0
580 1f :3 0 1b
:3 0 57e :2 0 580
33e 583 :3 0 583
349 583 582 580
581 :6 0 584 1
0 424 428 583
58b :3 0 589 0
589 :3 0 589 58b
587 588 :6 0 58c
:2 0 3 :3 0 350
0 3 589 58f
:3 0 58e 58c 590
:8 0 
367
4
:3 0 2 8 7
1 4 2 11
10 1 e 2
1a 19 1 17
1 1f 1 25
1 2d 2 38
37 1 35 1
3e 1 4c 1
54 1 57 1
5d 2 5f 60
1 62 1 6a
1 6e 2 6d
71 2 78 77
1 75 1 7f
2 7d 7f 1
84 1 89 2
87 89 1 8e
1 94 2 92
94 1 99 3
9c 91 9b 1
9e 3 a4 a5
a6 1 a9 1
ab 2 af b1
2 b3 b5 2
b7 b9 3 bb
bc bd 1 c3
2 c5 c6 4
9d ac c0 c8
1 7b 1 d6
2 df e3 1
e5 1 e8 1
ed 2 eb ed
1 e7 2 f4
f7 1 db 1
105 1 10d 1
10f 1 114 1
119 2 117 119
1 111 2 120
123 1 10a 1
12c 1 130 2
12f 134 1 13a
1 140 1 147
1 14c 1 155
1 153 1 15c
1 15a 1 161
1 16e 1 170
3 172 173 174
1 176 1 17f
3 182 185 188
1 190 2 192
193 3 19c 19d
19e 2 199 1a0
2 1a2 1a3 2
1a9 1aa 1e 1b0
1b1 1b2 1b3 1b4
1b5 1b6 1b7 1b8
1b9 1ba 1bb 1bc
1bd 1be 1bf 1c0
1c1 1c2 1c3 1c4
1c5 1c6 1c7 1c8
1c9 1ca 1cb 1cc
1cd 1 1d2 1
1d4 3 1d7 1d8
1d9 1 1dd 2
1db 1dd 1 1e2
1 1e5 2 1e4
1e5 1 1eb 1
1ef 2 1f1 1f2
1 1f3 1 1f6
2 1f5 1f6 1
1fb 1 1fe 2
1fd 1fe 1 206
1 20a 2 20c
20d 1 20e 2
210 211 1 212
2 215 216 1
219 2 218 219
1 21e 1 221
2 220 221 1
229 1 22d 2
22f 230 1 231
2 233 234 7
179 18a 196 1a6
1ad 1d5 235 1
23c 1 23f 2
241 242 1 243
1 238 1 246
2 249 24d 7
13e 145 14a 151
158 15f 165 1
25b 1 262 1
268 1 26e 1
272 2 270 272
1 277 2 27e
27f 1 282 3
284 279 285 2
286 289 1 25e
1 291 1 295
2 294 298 1
29e 2 2a1 2a3
2 2a5 2a7 2
2a9 2ab 2 2a0
2ad 1 2af 2
2bd 2be 1 2c0
1 2c9 1 2cd
2 2cc 2d1 2
2de 2e1 3 2e3
2e4 2e5 1 2e8
1 2f0 1 2f4
2 2f3 2f7 1
2fb 1 300 1
305 1 311 1
319 1 325 1
329 1 32d 1
331 2 337 338
1 33a 2 33c
33e 2 344 345
1 347 2 349
34b 2 340 34d
2 353 354 1
356 2 358 35a
2 34f 35c 2
35e 35f 2 365
366 1 368 2
36e 36f 1 371
2 373 375 2
36a 377 2 37d
37e 1 380 2
382 384 2 387
389 2 379 38b
2 38d 38e 2
396 398 3 394
395 39a 2 39e
3a0 1 3a2 1
3a9 1 3ab 1
3b0 2 3b2 3b3
1 3b7 1 3bd
c 327 32b 32f
333 361 390 39c
3a4 3ad 3b5 3b9
3bf 2 320 3c1
2 3c9 3cb 1
3d1 2 3d3 3d5
5 3c7 3c8 3cd
3d7 3d8 1 3de
6 30c 314 31c
3c3 3da 3e0 3
2fe 303 308 1
3e8 1 3ec 1
3f0 1 3f4 4
3eb 3ef 3f3 3f7
1 3fb 1 403
1 407 1 40d
1 413 4 406
40c 412 418 1
41c 1 42a 1
430 1 435 1
43a 1 441 1
447 1 43f 1
44c 1 456 1
45b 1 45f 2
45d 45f 1 464
1 468 1 46b
2 46d 46e 1
46f 1 472 1
474 2 476 477
1 47a 1 47f
1 481 1 483
1 486 1 48a
2 488 48a 2
490 491 1 493
2 498 499 1
49e 2 49c 49e
1 4a2 1 4a4
1 4a6 2 496
4a7 1 4a9 1
4af 1 4b9 3
4b7 4bb 4bc 1
4c3 2 4c1 4c3
2 4c9 4cb 1
4d7 1 4db 2
4e3 4e5 3 4e1
4e2 4e7 1 4eb
1 4ef 1 4f3
1 4f7 2 4fb
4fd 1 4ff 2
50e 510 3 50c
50d 512 2 514
517 2 51a 51c
3 505 519 51e
9 4d9 4dd 4e9
4ed 4f1 4f5 4f9
501 520 2 4d2
522 1 52b 2
52e 530 3 529
52d 532 3 4ce
524 535 1 53d
1 549 1 54d
1 551 2 555
556 2 55a 55b
2 55f 561 1
563 1 567 1
56f 2 571 572
2 574 575 9
54b 54f 553 558
55d 565 569 577
578 2 544 57a
a 455 478 484
4aa 4b2 4bf 538
540 57c 57f 6
42e 433 438 43d
44a 44f 16 c
15 1d 23 2b
33 3c 41 51
67 cd fc 128
252 28e 2b4 2c5
2ed 3e5 400 421
584 
1
4
0 
58f
0
1
14
11
3e
0 1 1 1 1 1 1 7
1 1 1 1 1 1 1 1
10 0 0 0 
2b6 1 b
407 f 0
424 1 10
2d 1 0
40d f 0
3f0 e 0
305 d 0
300 d 0
ff 1 6
e 1 0
153 7 0
75 4 0
25b 9 0
13a 7 0
105 6 0
d6 5 0
413 f 0
3f4 e 0
402 1 f
2fb d 0
44c 10 0
6a 4 0
290 1 a
53 1 3
2c9 c 0
4 1 0
403 f 0
3ec e 0
2f4 d 0
3e8 e 0
2f0 d 0
43a 10 0
435 10 0
35 1 0
255 1 9
140 7 0
6e 4 0
d0 1 5
130 7 0
14c 7 0
12c 7 0
1f 1 0
291 a 0
3 0 1
3e7 1 e
15a 7 0
2cd c 0
42a 10 0
44 1 2
295 a 0
54 3 0
430 10 0
3e 1 0
12b 1 7
2c8 1 c
69 1 4
161 7 0
147 7 0
43f 10 0
2ef 1 d
25 1 0
17 1 0
0

/
