create or replace procedure plzip_minimal as
  /* 01. Example: Minimal example   */
  /* Before running, load the following file with a
     given filename into the ZIP_EXAMPLES table:

    ID |    FILENAME     
    -------------------------
     1 |    Folder1/splash.bmp

  */
  l_name varchar2(4000 char);    -- filename
  l_file blob;    -- source blob
  l_zip blob;     -- result (ZIP)
begin
  -- get a source file and its name.
  select filename, original_file into l_name, l_file from zip_example
    where id=1;
  -- reset PL/ZIP package
  plzip.createNewZip;
  -- add file to the archive
  plzip.AddFile(
                p_filename =>  l_name,
                p_file => l_file
                );
  -- build and save ZIP
  l_zip := plzip.saveZip;
  delete from store_blob;
  insert into store_blob values(l_zip,sysdate);
  commit;
end plzip_minimal;
/
