create or replace package oo_form_test is
-- table
/*
create table plpdf_00_form_store
(
id number not null,
filename varchar2(255 char),
orig_pdf blob,
prepform plpdf_type_prepform
)
nested table prepform.xref store as xref_table,
nested table prepform.objs store as objs_table
;
*/

--
procedure prepform(
  p_id number
  );
--
procedure prepform1;
--
function loadform(
  p_id number
  ) return plpdf_type.t_prepform;
--
procedure fillform_1(
  p_prepform in out plpdf_type.t_prepform,
  p_clubname varchar2,
  p_contactperson varchar2,
  p_phone varchar2,
  p_email varchar2,
  p_phonetype varchar2,
  p_city varchar2,
  p_association varchar2,
  p_kids boolean,-- cb
  p_cadets boolean, -- cb
  p_juniors boolean, -- cb
  p_open boolean, -- cb
  p_womengirls boolean, -- cb
  p_comments varchar2,
  p_date date-- date
  );  
--
procedure test1;
--
end oo_form_test;
/

create or replace package body oo_form_test is
--
procedure prepform(
    p_id number
    ) is
  l_blob blob;
  l_prepform plpdf_type.t_prepform;
  l_pf plpdf_type_prepform;  
begin    
  -- select PDF BLOB from table
  select t.orig_pdf
    into l_blob
  from plpdf_00_form_store t
  where t.id = p_id
  ;

  -- prepare
  l_prepform := plpdf_oo_form.PrepPDF(l_blob);

  -- convert to stored format
  l_pf := plpdf_oo_form.Convert2Object(l_prepform);

  -- store prepared form in the table
  update plpdf_00_form_store
    set prepform = l_pf
    where id = p_id;

  commit;

end;  
--
procedure prepform1 is
begin
  prepform(1);
end;
--
function loadform(
  p_id number
  ) return plpdf_type.t_prepform is
  l_pf plpdf_type_prepform;
  l_ret plpdf_type.t_prepform;
begin
  select prepform
    into l_pf
  from plpdf_00_form_store
  where id = p_id
  ;

  l_ret := plpdf_oo_form.Convert2Type(l_pf);

  return l_ret;
end;  
--
procedure fillform_1(
  p_prepform in out plpdf_type.t_prepform,
  p_clubname varchar2,
  p_contactperson varchar2,
  p_phone varchar2,
  p_email varchar2,
  p_phonetype varchar2,
  p_city varchar2,
  p_association varchar2,
  p_kids boolean,-- cb
  p_cadets boolean, -- cb
  p_juniors boolean, -- cb
  p_open boolean, -- cb
  p_womengirls boolean, -- cb
  p_comments varchar2,
  p_date date-- date
  ) is
  -- 
begin
  plpdf_oo_form.SetValue(p_prepform,'clubname',p_clubname); -- CLUB NAME
  plpdf_oo_form.SetValueReadonly(p_prepform,'contactperson',p_contactperson); -- Contact Person
  plpdf_oo_form.SetValueReadonly(p_prepform,'phone',p_phone); -- Phone
  plpdf_oo_form.SetValueReadonly(p_prepform,'email',p_email); -- Email
  plpdf_oo_form.SetValueReadonly(p_prepform,'phonetype',p_phonetype); -- Phone type
  plpdf_oo_form.SetValueReadonly(p_prepform,'city',p_city); -- City 
  plpdf_oo_form.SetValueReadonly(p_prepform,'association',p_association); -- Association
  plpdf_oo_form.SetValueReadonly(p_prepform,'kids',plpdf_oo_form.boolean2cb(p_kids)); -- kids
  plpdf_oo_form.SetValueReadonly(p_prepform,'cadets',plpdf_oo_form.boolean2cb(p_cadets)); -- cadets 
  plpdf_oo_form.SetValueReadonly(p_prepform,'juniors',plpdf_oo_form.boolean2cb(p_juniors)); -- juniors
  plpdf_oo_form.SetValueReadonly(p_prepform,'open',plpdf_oo_form.boolean2cb(p_open)); -- open
  plpdf_oo_form.SetValueReadonly(p_prepform,'womengirls',plpdf_oo_form.boolean2cb(p_womengirls)); -- womengirls
  plpdf_oo_form.SetValueReadonly(p_prepform,'comments',p_comments); -- comments
  plpdf_oo_form.SetValueReadonly(p_prepform,'date',to_char(p_date,'YYYY-MM-DD')); -- date
end;
--
procedure test1 is
  l_prepform plpdf_type.t_prepform;
  l_blob blob;
begin
  l_prepform := loadform(1);  
  fillform_1(
  p_prepform => l_prepform,
  p_clubname => 'San Jose W-Squad ',
  p_contactperson => 'Joe Schlabotnik',
  p_phone => '408-555-7871',
  p_email => 'joe_schlabotnik@example.com',
  p_phonetype => '2',
  p_city => 'San Jose, CA',
  p_association => 'SCWA',
  p_kids => true,-- cb
  p_cadets => true, -- cb
  p_juniors => false, -- cb
  p_open => false, -- cb
  p_womengirls => true, -- cb
  p_comments => 
    'Lets say youre in charge of a database of chartered clubs for an amateur sports association. ' ||
    'Club directors send you papers like the one in Appendix A, and you enter the data into an XML file, ' ||
    'which is used to create an online searchable database of the clubs.  Clearly, the better option is ' ||
    'to send the club directors a machine-readable document with form fields that they fill in. ' ||
    'The directors send the file back to you, and, rather than having to decipher their handwriting ' ||
    'and re-enter the data, you run a program to extract the information.',
  p_date => sysdate
  );
  
  plpdf_oo_form.GetPDF(
  p_prepform => l_prepform,
  p_blob => l_blob
  );
 
 insert into store_blob (blob_file,created_date) values 
 (l_blob,sysdate);
 
 commit;
  
end;
--
end oo_form_test;
/

