create or replace package plpdf_tag as
/**
 <config>
  <pck-name>PL/PDF Tag</pck-name>
  <pck-title>User's Guide</pck-title>
  <pck-version>v2.6.0</pck-version>
  <header-prc>plpdf_doc_xml.plpdf_header</header-prc>
  <header-size>15</header-size>
  <footer-prc>plpdf_doc_xml.plpdf_footer</footer-prc>
  <footer-size>10</footer-size>
 </config>
*/

/**
 <h1>Introdution</h1>
 <br/>
 <h2>Purpose</h2>
 <p>
  PL/PDF Tag package is an extension for PL/PDF, which allows to write tag-formatted text to the PDF document. 
  It can work only with PL/PDF v2.1.0 or higher.
 </p>
 <br/>
 <h2>Stored tags</h2>
 <p>
  Stored tags means a set of records, which was defined by procedure <i>PLPDF_TAG.SetStyle</i>. 
  The text could be formatted with these tags. There are two kind of tags: style-tag and command-tag. 
  Style-tags contains any text formatting settings, for example font size or font family.<br/>
  Format: &lt;tag_name&gt;...&lt;/tag_name&gt;.<br/>
  Command-tags contains any PL/SQL block.<br/>
  Format: &lt;tag_name/&gt;.<br/>
  There is one built in command-tag, named &lt;br/&gt;(Break line).
 </p>
 <newpage/>
*/

/**
 <h1>Procedures</h1>
 <br/>
*/

/**
 <name>Init</name>
 <type>Procedure</type>
 <desc>
  Initialize package variables and delete all of stored tags(except &lt;br/&gt;).
 </desc>
 <version>v2.6.0</version>
 <params>-</params>
 <return>-</return>
*/
procedure Init;

/**
 <name>SetStyle</name>
 <type>Procedure</type>
 <desc>
  Creates a new stored-tag. The parameter p_spec decides between two types. 
  When p_spec is 0, then family, style, size, color will be apply. 
  In the other case, when p_spec is 1, then only p_command will be apply. 
 </desc>
 <version>v2.6.0</version>
 <params>
  <param>
   <param-def>p_name varchar2</param-def>
   <param-desc>Name of the new tag.</param-desc>
  </param>
  <param>
   <param-def>p_family varchar2 default null</param-def>
   <param-desc>Font family, null means current font.</param-desc>
  </param>
  <param>
   <param-def>p_style varchar2 default 'CRR'</param-def>
   <param-desc>Font style, null means current style.</param-desc>
   <param-ul>
    <param-li>B: Bold</param-li>
    <param-li>I: Italic</param-li>
    <param-li>U: Underline</param-li>
    <param-li>The styles may be combined (i.e. BI means Bold and Italic).</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_size number default null</param-def>
   <param-desc>Font size, null means current size.</param-desc>
  </param>
  <param>
   <param-def>p_color plpdf_type.t_color default NULL,</param-def>
   <param-desc>Sets the text color for objects inserted after this statement.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure SetStyle(
                   p_name      varchar2,
                   p_family    varchar2             default null,
                   p_style     varchar2             default null,
                   p_size      number               default null,
                   p_color     plpdf_type.t_color   default null
                   -- p_spec      number               default 0,
                   -- p_command   varchar2             default null,
                   -- p_rewrite   boolean              default false
                   );


--v2.6.0
procedure SetCommand(
                   p_name      varchar2,
                   p_command   varchar2
                   );

/**
  <newpage/>
 <name>PrintText</name>
 <type>Procedure</type>
 <desc>
  Put tag-formatted text into the current page. This procedure don't recognize the &lt;br/&gt; command-tag.
 </desc>
 <version>v2.1.0</version>
 <params>
  <param>
   <param-def>p_x number</param-def>
   <param-desc>X coordinate of text.</param-desc>
  </param>
  <param>
   <param-def>p_y number</param-def>
   <param-desc>Y coordinate of text.</param-desc>
  </param>
  <param>
   <param-def>p_txt</param-def>
   <param-desc>Tag-formatted text.</param-desc>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintText(
                    p_x     number,
                    p_y     number,
                    p_txt   varchar2
                    );

/**
 <name>PrintFlowingText</name>
 <type>Procedure</type>
 <desc>
  Prints tag-formatted text continuously. Text is wrapped according to the right margin.
 </desc>
 <version>v2.1.1</version>
 <params>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>Height.</param-desc>
   </param>
   <param>
    <param-def>p_txt varchar2 default null</param-def>
    <param-desc>Text.</param-desc>
   </param>
   <param>
    <param-def>p_link varchar2 default null</param-def>
    <param-desc>URL or internal link ID.</param-desc>
   </param>
   <param>
    <param-def>p_align varchar2 default null</param-def>
    <param-desc>Text alignment.</param-desc>
    <param-ul>
     <param-li>L: Left</param-li>
     <param-li>R: Right</param-li>
     <param-li>C: Center</param-li>
     <param-li>J: Force Justification</param-li>
    </param-ul>
  </param>
  <param>
   <param-def>p_clipping number default 1</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintFlowingText(
                           p_h      number    default 0,
                           p_txt    varchar2  default null,
                           p_link   varchar2  default null,
                           p_align  varchar2  default null,
                           p_clipping number default 1
                           );

/**
 <name>PrintFlowingTextLimit</name>
 <type>Procedure</type>
 <desc>
  Prints tag-formatted text continuously. Text is wrapped according to the p_min_x and p_max_x.
 </desc>
 <version>v2.1.1</version>
 <params>
  <param>
   <param-def>p_h number default 0</param-def>
   <param-desc>Height.</param-desc>
  </param>
  <param>
   <param-def>p_txt varchar2 default null</param-def>
   <param-desc>Text.</param-desc>
  </param>
  <param>
   <param-def>p_link varchar2 default null</param-def>
   <param-desc>URL or internal link ID.</param-desc>
  </param>
  <param>
   <param-def>p_min_x number default 0</param-def>
   <param-desc>min X position, 0 means the limit is the left margin.</param-desc>
  </param>
  <param>
   <param-def>p_max_x number default 0</param-def>
   <param-desc>max X position, 0 means the limit is the right margin.</param-desc>
  </param>
  <param>
   <param-def>p_align varchar2 default null</param-def>
   <param-desc>Text alignment.</param-desc>
   <param-ul>
    <param-li>L: Left</param-li>
    <param-li>R: Right</param-li>
    <param-li>C: Center</param-li>
    <param-li>J: Force Justification</param-li>
   </param-ul>
  </param>
  <param>
   <param-def>p_clipping number default 1</param-def>
   <param-desc>Clipping text</param-desc>
   <param-ul>
    <param-li>0: no clipping</param-li>
    <param-li>1: clipping</param-li>
   </param-ul>
  </param>
 </params>
 <return>-</return>
*/
procedure PrintFlowingTextLimit(
                                p_h     number    default 0,
                                p_txt   varchar2  default null,
                                p_link  varchar2  default null,
                                p_min_x number    default 0,
                                p_max_x number    default 0,
                                p_align varchar2  default null,
                                p_clipping number default 1
                                );

end plpdf_tag;
/
