CREATE OR REPLACE package template_eg is
    /* 50. Example: Templates */

procedure template_init;
procedure template_eg;

end;
/

CREATE OR REPLACE package body template_eg is

/* The template */
v_tpl   plpdf_type.tr_tpl_data;



/* Prepare template PDF */
procedure template_init is
  
  l_pdf blob;
begin
  
  /* Select template PDF*/
  select t.orig_pdf
     into l_pdf
   from plpdf_template t
   where id = 1;
   
   /* Parsing data */
   v_tpl := plpdf_parser.GetTemplate(
   p_blob => l_pdf,
   p_page_id => 1
   );
   
end;


/* Procedure which use the template page */
procedure template_eg is
  
  l_blob blob;
  l_tpl_id number;
 begin
    
    /* Initialize template document */
    template_init;
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Insert a template into the pdf.
       Return: Template ID */
    l_tpl_id := plpdf.InsTemplate(
                 p_tpl => v_tpl   -- Template data
                 );
                  
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage;
    
    /* Use a template. */
    plpdf.useTemplate(
     p_tplidx => l_tpl_id         -- Template ID
     );
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',         -- Font family: Arial
     p_style => null,             -- Font style: regular (default)
     p_size => 12                 -- Font size: 12 pt
     ); 
	
    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 50,                   -- Rectangle width
     p_h => 10,                   -- Rectangle heigth
     p_txt => 'Template Example'  -- Text in rectangle 
     );
       
       
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
 
end; -- End of package template_eg
/
