CREATE OR REPLACE procedure flowingtextlimit is
    /* 48. Example: Flowing text with limit*/
  
  l_blob blob;
  l_link number;
 begin
   
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',    -- Font family: Arial
     p_style => null,        -- Font style: regular (default)
     p_size => 12            -- Font size: 12 pt
     ); 
	
    /* Prints text continuously. */
    plpdf.PrintFlowingTextLimit(
     p_h => 9, -- Line height
     p_txt => 'Generate dynamic PDF documents from data stored in Oracle databases ' ||
            'using the PL/PDF program package. PL/PDF is written exclusively in PL/SQL. ' ||
            'It is able to either store the generated PDF document in the database or ' ||
            'provide the results directly to a browser using MOD_PLSQL. No third-party ' ||
            'software is needed; PL/PDF only uses tools provided by the installation ' ||
            'package of an Oracle Database. Use PL/PDF to quickly and easily develop ' ||
            'applications with dynamic content but also quality ' ||
            'presentation and printing capabilities.', -- Text
     p_min_x => 120,         -- Minimum X position
     p_max_x => 160,         -- Maximum X position
     p_align => 'J'          -- Text alignment: Force Justification
     );
						  	
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob        -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
