CREATE OR REPLACE procedure printtext is
    /* 47. Example: PrintText */
 
  l_blob blob;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',           -- Font family: Arial
     p_style => null,               -- Font style: regular (default)
     p_size => 12                   -- Font size: 12 pt
     ); 
    
    /* Prints a text starting from the specified position. */
    plpdf.PrintText(
     p_x => 50,                     -- X coordinate for the start of the text
     p_y => 50,                     -- Y coordinate for the start of the text
     p_txt => 'Print Text Example'  -- Text
     );
    
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	   
    /* Print it:
	
        owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob); */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/

