CREATE OR REPLACE procedure test_toc_1_custom is

  l_toc plpdf_type.t_toc;
begin
      
    /* Print title */
      
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Courier',         -- Font family: Arial
     p_style => 'B',                -- Font style: regular (default)
     p_size => 15                   -- Font size: 12 pt
     ); 
  
    /* Insert title section in TOC (for creating custom TOC). */
    plpdf.PrintTOCTitle(
     p_toc_title_text => 'Table of Contents', -- Text of title
     p_toc_title_height => 20       -- Height of title's cell
     );

    /* Insert gap between title and items (for creating custom TOC). */
    plpdf.TOCInsertGap(
     p_toc_title_body_gap => 20     -- Size of gap
     );

    
    /* Print items */
  
    /* Returns array of TOC items (for creating custom TOC). */
    l_toc := plpdf.GetTOCItems;
  
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',           -- Font family: Arial
     p_style => null,               -- Font style: regular (default)
     p_size => 12                   -- Font size: 12 pt
     ); 
     
    for l_i in 1..l_toc.count loop
        /* Print a TOC Item into the PDF (for creating custom TOC). */
        plpdf.PrintTOCItem(
         p_item => l_toc(l_i),      -- TOC Item
         p_toc_level_indent  => 0,  -- indent size for levels
         p_toc_item_height => 10,   -- height of TOC item cell
         p_toc_separator => '.'     -- filler between TOC item and page number
         );
  end loop;
end;  
