create or replace procedure chinese is
  /* 39. Example: Chinese font */
  
  l_blob blob;
  l_chinese varchar2(2000 char);
 begin
   /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage;
        
    /* Create a chinese text */
    l_chinese := UNISTR(
               '\53d6\6e96\53d7\4fdd\4eba\5728\6211\56fd\7ecf\6d4e\7ed3\6784'
            || '\8fdb\884c\6218\7565\6027\8c03\6574\7684'
            || '\80CC\666F\4e0B\ff0c\4FE1\606f\4ea7\4e1a'
            || '\5c06\6210\4E3A\62c9\52A8\7ecf\6d4e\589e'
            || '\957f\7684\65b0\52A8\529b\ff0c\800c\4f5c'
            || '\4E3A\4FE1\606f\6280\672f\6838\5fc3\4e4b'
            );    
       
    /* Add CJK (Chinese/Japanese/Korean) font. */
    plpdf.AddCJKFont(
      plpdf_const.font_chinese_GB -- Name of font
      );
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => plpdf_const.font_chinese_GB,   -- Font family: STSongStd-Light-Acro 
     p_style => null,                             -- Font style: regular (default)
     p_size => 12                                 -- Font size: 12 pt
     ); 
    
    plpdf.PrintMultiLineCell(
     p_w => 50, -- Rectangle width
     p_h => 10, -- Rectangle height
     p_txt => l_chinese -- Variable containing the chinese text
     );
    

    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob               -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
