create or replace
procedure printrowlink is
    /* 38. Example: Print row with link (Row_Print3 and Row_Print4) */
  
  l_blob      blob;
  l_datas     plpdf_type.t_row_datas;     -- Array of datas
  l_borders   plpdf_type.t_row_borders;   -- Array of borders
  l_widths    plpdf_type.t_row_widths;    -- Array of widths
  l_aligns    plpdf_type.t_row_aligns;    -- Array of aligns
  l_styles    plpdf_type.t_row_styles;    -- Array of styles
  l_fonts     plpdf_type.t_row_fonts;     -- Array of fonts
  l_maxlines  plpdf_type.t_row_maxlines;  -- Array of max lines
  l_links     plpdf_type.t_row_links;     -- Array of links
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
	 
    /* Set columns borders */
    l_borders(1) := '1'; 
    l_borders(2) := '1';
    l_borders(3) := '1';
	 
    /* Set columns widths */
    l_widths(1) := 30;
    l_widths(2) := 40;
    l_widths(3) := 100;
	 
    /* Set columns aligns */
    l_aligns(1) := 'R';          -- Right
    l_aligns(2) := 'C';          -- Center
    l_aligns(3) := 'L';          -- Left
	
    /* Set links */
    l_links(1) := 'http://www.plpdf.com';
    l_links(2) := 'http://www.plsqlplus.com';
    l_links(3) := 'http://support.plpdf.com';
  
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => 'B',             -- Font style: Bold
     p_size => 12                -- Font size: 12 pt
     );
    
    /* Set background color*/
    
    /* Sets the fill color for objects inserted after this statement. 
       Colors must be specified according to the RGB pallet.*/
    plpdf.SetColor4Filling(
     p_r => 200,                 -- Red component code, can be between 0 and 255
     p_g => 220,                 -- Green component code, can be between 0 and 255
     p_b => 255                  -- Blue component code, can be between 0 and 255
     ); 
    
    /* Print headers */
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(1),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'ROWNUM',          -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(2),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OWNER',           -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );

    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(3),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OBJECT NAME',     -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '1',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
	 
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => null,            -- Font style: regular (default)
     p_size => 12                -- Font size: 12 pt
     );

    /* Print with PLPDF.RowPrint3 */	 
    
    for f_obj in (select rownum, owner, object_name from all_objects where rownum <= 10) loop
        /* Set datas */
	l_datas(1) := to_char(f_obj.rownum); 
	l_datas(2) := f_obj.owner;
	l_datas(3) := f_obj.object_name;    
       
        /* Print datas*/
        
        /* Prints a full row in the PDF document. 
           The rows consist of multi-line cells. 
           The rows height is set according to the largest cell */
        plpdf.Row_Print3(
        p_data => l_datas,       -- Data shown in the cells
        p_border => l_borders,   -- Border array of the cells
        p_width => l_widths,     -- Width of the cells
        p_align => l_aligns,     -- Alignment of the cells
        p_style => l_styles,     -- Style of the cells
        p_maxline => l_maxlines, -- Maximum number of lines in a multi-line cell
        p_links => l_links       -- Links of the cells  
        );
    end loop;

    /* Line break. 
       Cursor is placed at the start of the next line.*/
    plpdf.LineBreak(
     p_h => 40                  -- Height of the line break.
     );
     
     
    
    /* Print with PLPDF.RowPrint4 */	 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',        -- Font family: Arial
     p_style => 'B',             -- Font style: Bold
     p_size => 12                -- Font size: 12 pt
     );
    
    /* Print headers */
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(1),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'ROWNUM',          -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
    
    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(2),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OWNER',           -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '0',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );

    /* Draws a rectangle cell with text inside. */
    plpdf.PrintCell(
     p_w => l_widths(3),         -- Rectangle width
     p_h => 10,                  -- Rectangle heigth
     p_txt => 'OBJECT NAME',     -- Text in rectangle 
     p_border => '1',            -- With frame
     p_ln => '1',                -- Cursor position after the cell is printed
     p_align => 'C',             -- Text alignment: Center
     p_fill => 1                 -- Fill with current fill color
     );
    
    /* Set l_fonts attributes */
    l_fonts(1).family:='Arial';   -- Font family 
    l_fonts(1).style:= 'B';       -- Font style: Bold
    l_fonts(1).fsize:= 12;        -- Font size: 12 pt
    
    /* Set l_fonts attributes */
    l_fonts(2).family:='Arial';   -- Font family 
    l_fonts(2).style:= 'U';       -- Font style: Underline
    l_fonts(2).fsize:= 10;        -- Font size: 10 pt
    
    /* Set l_fonts attributes */
    l_fonts(3).family:='Courier'; -- Font family 
    l_fonts(3).style:= null;      -- Font style: regular
    l_fonts(3).fsize:= 12;        -- Font size: 12 pt
    
    for f_obj in (select rownum, owner, object_name from all_objects where rownum <= 10) loop
        /* Set datas */
	l_datas(1) := to_char(f_obj.rownum); 
	l_datas(2) := f_obj.owner;
	l_datas(3) := f_obj.object_name;    
       
        /* Print datas*/
        
        /* Prints a full row in the PDF document. 
           The rows consist of multi-line cells. 
           The rows height is set according to the largest cell */
        plpdf.Row_Print4(
        p_data => l_datas,       -- Data shown in the cells
        p_border => l_borders,   -- Border array of the cells
        p_width => l_widths,     -- Width of the cells
        p_align => l_aligns,     -- Alignment of the cells
        p_font => l_fonts,       -- Font of the cells (Family is required)
        p_maxline => l_maxlines, -- Maximum number of lines in a multi-line cell
        p_links => l_links       -- Links of the cells  
        );
    end loop;
    
    
    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob            -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
