CREATE OR REPLACE procedure markup is
  /* 37. Example: Markup annotations */
  
  l_blob blob;
  l_x    number;
  l_y    number;
 begin
    
    /* Initialize, without parameters means: 
     - page orientation: portrait
     - unit: mm
     - default page format: A4 */
    plpdf.init; 
    
    /* Begin a new page, without parameters means: 
     - page orientation: default (portrait) */
    plpdf.NewPage; 
    
    /* Sets the font and its properties */
    plpdf.SetPrintFont(
     p_family => 'Arial',               -- Font family: Arial
     p_style => null,                   -- Font style: regular (default)
     p_size => 12                       -- Font size: 12 pt
     ); 

    /* Gets the X coordinate of the cursor. */
    l_x := plpdf.GetCurrentX ; 
    /* Gets the Y coordinate of the cursor */
    l_y := plpdf.GetCurrentY;

    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 80,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Highlight Annotation'    -- Text in rectangle 
     ); 

    /* Add HighLight annotation to the current page. */
    plpdf.AddHighLightAnnot(
     p_contents => 'With Oracle Database 10g, the first relational database ' || 
                   'designed for Grid Computing, your information is always ' || 
                   'available and secure. Oracle Database 10g lowers the cost ' || 
                   'of ownership through automated management while providing ' || 
                   'the highest possible quality of service. And with Release 2, ' || 
                   'Oracle builds on Release 1''s foundation to further improve ' || 
                   'efficiencies and reduce the cost of information management. ' || 
                   'Oracle is the best choice for large enterprises, ' || 
                   'small and midsize businesses, and departments alike.',
                   /* The text to be displayed in the pop-up window when the annotation is opened. */
     p_x => l_x,                        -- X coordinate of the annotation
     p_y => l_y + 1,                    -- Y coordinate of the annotation
     p_w => 50,                         -- Width of the annotation
     p_h => 7,                          -- Height of the annotation
     p_label => 'The First Database Designed for Grid Computing',
                    /* The text label to be displayed in the title bar of the 
                    annotations pop-up window when open and active. */
     p_color => plpdf_const.Lime,       -- This color will be used.(see User Guide)
     p_popup_x => l_x,                  -- X coordinate of the pop-up window
     p_popup_y => l_y + 7,              -- Y coordinate of the pop-up window
     p_popup_w => 80,                   -- Width of the pop-up window
     p_popup_h => 50                    -- Height of the pop-up window
     );

    /* Places the cursor at the Y coordinate. */
    plpdf.SetCurrentY(
     p_y => l_y + 50                    -- Y coordinate
    );

    /* Gets the Y coordinate of the cursor */
    l_y := plpdf.GetCurrentY;

    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 80,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'StrikeOut Annotation'    -- Text in rectangle 
     );

   /* Add StrikeOut annotation to the current page. */
    plpdf.AddStrikeOutAnnot(
     p_contents => 'Oracle Database 10g delivers the response times your users' ||
                   'demand and reduces your cost of downtime. And only Oracle ' || 
                   'offers non-stop availability, scalability, and low-cost ' || 
                   'clustering with Oracle Real Application Clusters, ' || 
                   'the foundation for Grid Computing.',
                   /* The text to be displayed in the pop-up window 
                      when the annotation is opened. */
     p_x => l_x,                        -- X coordinate of the annotation
     p_y => l_y + 1,                    -- Y coordinate of the annotation
     p_w => 50,                         -- Width of the annotation
     p_h => 7,                          -- Height of the annotation
     p_label => 'Availability and Scalability with Grid Computing',
                   /* The text label to be displayed in the title bar of the 
                      annotations pop-up window when open and active. */
     p_color => plpdf_const.Turquoise,  -- This color will be used.(see User Guide)
     p_popup_x => l_x,                  -- X coordinate of the pop-up window
     p_popup_y => l_y + 7,              -- Y coordinate of the pop-up window
     p_popup_w => 80,                   -- Width of the pop-up window
     p_popup_h => 50                    -- Height of the pop-up window
     );

    /* Places the cursor at the Y coordinate. */
    plpdf.SetCurrentX(
     p_x => l_X + 100                   -- X coordinate
     );

    /* Gets the X coordinate of the cursor */
    l_x := plpdf.GetCurrentX;

    /* Draws a rectangle cell with text inside. 
       The rectangle may have a border and fill color specified. */
    plpdf.PrintCell(
     p_w => 80,                         -- Rectangle width
     p_h => 10,                         -- Rectangle heigth
     p_txt => 'Underline Annotation'    -- Text in rectangle 
     );

    /* Add Underline annotation to the current page. */
    plpdf.AddUnderlineAnnot(
     p_contents => 'Oracle automates time-consuming, error-prone administrative ' || 
                   'tasks, so DBAs can focus on strategic business objectives. ' || 
                   'Studies from the Edison Group prove Oracle Database 10g ' || 
                   'offers superior manageability and significant cost savings ' || 
                   'over IBM DB2 8.2 as well as Microsoft SQL Server 2000.',
                   /* The text to be displayed in the pop-up window when the 
                   annotation is opened. */
     p_x => l_x,                        -- X coordinate of the annotation
     p_y => l_y + 1,                    -- Y coordinate of the annotation
     p_w => 50,                         -- Width of the annotation
     p_h => 7,                          -- Height of the annotation
     p_label => 'Lower Costs with the Self-Managing Database',
                   /* The text label to be displayed in the title bar of the 
                      annotations pop-up window when open and active. */
     p_color => plpdf_const.Violet,     -- This color will be used.(see User Guide)
      p_popup_x => l_x,                 -- X coordinate of the pop-up window
     p_popup_y => l_y + 7,              -- Y coordinate of the pop-up window
     p_popup_w => 80,                   -- Width of the pop-up window
     p_popup_h => 50                    -- Height of the pop-up window
     );

    /* Returns the generated PDF document. 
       The document is closed and then returned in the OUT parameter. */
    plpdf.SendDoc(
     p_blob => l_blob                   -- The generated document
     );
	
        
    /* Print it:
    
	owa_util.mime_header('application/pdf',false);
        htp.p('Content-Length: ' || dbms_lob.getlength(l_blob)); 
        owa_util.http_header_close; 	
        wpg_docload.download_file(l_blob);   */
    
    /* Store */
    insert into STORE_BLOB (blob_file, created_date) values (l_blob, sysdate);
    
    commit;
 end;
/
